<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$branches_delete = new branches_delete();

// Run the page
$branches_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$branches_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fbranchesdelete = currentForm = new ew.Form("fbranchesdelete", "delete");

// Form_CustomValidate event
fbranchesdelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbranchesdelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbranchesdelete.lists["x_LawFirmID"] = <?php echo $branches_delete->LawFirmID->Lookup->toClientList() ?>;
fbranchesdelete.lists["x_LawFirmID"].options = <?php echo JsonEncode($branches_delete->LawFirmID->lookupOptions()) ?>;
fbranchesdelete.lists["x_Activated[]"] = <?php echo $branches_delete->Activated->Lookup->toClientList() ?>;
fbranchesdelete.lists["x_Activated[]"].options = <?php echo JsonEncode($branches_delete->Activated->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $branches_delete->showPageHeader(); ?>
<?php
$branches_delete->showMessage();
?>
<form name="fbranchesdelete" id="fbranchesdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($branches_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $branches_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="branches">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($branches_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($branches->Branch->Visible) { // Branch ?>
		<th class="<?php echo $branches->Branch->headerCellClass() ?>"><span id="elh_branches_Branch" class="branches_Branch"><?php echo $branches->Branch->caption() ?></span></th>
<?php } ?>
<?php if ($branches->BranchEn->Visible) { // BranchEn ?>
		<th class="<?php echo $branches->BranchEn->headerCellClass() ?>"><span id="elh_branches_BranchEn" class="branches_BranchEn"><?php echo $branches->BranchEn->caption() ?></span></th>
<?php } ?>
<?php if ($branches->LawFirmID->Visible) { // LawFirmID ?>
		<th class="<?php echo $branches->LawFirmID->headerCellClass() ?>"><span id="elh_branches_LawFirmID" class="branches_LawFirmID"><?php echo $branches->LawFirmID->caption() ?></span></th>
<?php } ?>
<?php if ($branches->Activated->Visible) { // Activated ?>
		<th class="<?php echo $branches->Activated->headerCellClass() ?>"><span id="elh_branches_Activated" class="branches_Activated"><?php echo $branches->Activated->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$branches_delete->RecCnt = 0;
$i = 0;
while (!$branches_delete->Recordset->EOF) {
	$branches_delete->RecCnt++;
	$branches_delete->RowCnt++;

	// Set row properties
	$branches->resetAttributes();
	$branches->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$branches_delete->loadRowValues($branches_delete->Recordset);

	// Render row
	$branches_delete->renderRow();
?>
	<tr<?php echo $branches->rowAttributes() ?>>
<?php if ($branches->Branch->Visible) { // Branch ?>
		<td<?php echo $branches->Branch->cellAttributes() ?>>
<span id="el<?php echo $branches_delete->RowCnt ?>_branches_Branch" class="branches_Branch">
<span<?php echo $branches->Branch->viewAttributes() ?>>
<?php echo $branches->Branch->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($branches->BranchEn->Visible) { // BranchEn ?>
		<td<?php echo $branches->BranchEn->cellAttributes() ?>>
<span id="el<?php echo $branches_delete->RowCnt ?>_branches_BranchEn" class="branches_BranchEn">
<span<?php echo $branches->BranchEn->viewAttributes() ?>>
<?php echo $branches->BranchEn->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($branches->LawFirmID->Visible) { // LawFirmID ?>
		<td<?php echo $branches->LawFirmID->cellAttributes() ?>>
<span id="el<?php echo $branches_delete->RowCnt ?>_branches_LawFirmID" class="branches_LawFirmID">
<span<?php echo $branches->LawFirmID->viewAttributes() ?>>
<?php echo $branches->LawFirmID->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($branches->Activated->Visible) { // Activated ?>
		<td<?php echo $branches->Activated->cellAttributes() ?>>
<span id="el<?php echo $branches_delete->RowCnt ?>_branches_Activated" class="branches_Activated">
<span<?php echo $branches->Activated->viewAttributes() ?>>
<?php if (ConvertToBool($branches->Activated->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $branches->Activated->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $branches->Activated->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$branches_delete->Recordset->moveNext();
}
$branches_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $branches_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$branches_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$branches_delete->terminate();
?>
