<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$branches_search = new branches_search();

// Run the page
$branches_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$branches_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($branches_search->IsModal) { ?>
var fbranchessearch = currentAdvancedSearchForm = new ew.Form("fbranchessearch", "search");
<?php } else { ?>
var fbranchessearch = currentForm = new ew.Form("fbranchessearch", "search");
<?php } ?>

// Form_CustomValidate event
fbranchessearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbranchessearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbranchessearch.lists["x_LawFirmID"] = <?php echo $branches_search->LawFirmID->Lookup->toClientList() ?>;
fbranchessearch.lists["x_LawFirmID"].options = <?php echo JsonEncode($branches_search->LawFirmID->lookupOptions()) ?>;
fbranchessearch.lists["x_Activated[]"] = <?php echo $branches_search->Activated->Lookup->toClientList() ?>;
fbranchessearch.lists["x_Activated[]"].options = <?php echo JsonEncode($branches_search->Activated->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fbranchessearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_BranchID");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($branches->BranchID->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $branches_search->showPageHeader(); ?>
<?php
$branches_search->showMessage();
?>
<form name="fbranchessearch" id="fbranchessearch" class="<?php echo $branches_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($branches_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $branches_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="branches">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$branches_search->IsModal ?>">
<?php if (!$branches_search->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($branches_search->IsMobileOrModal) { ?>
<div class="ew-search-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_branchessearch" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($branches->BranchID->Visible) { // BranchID ?>
<?php if ($branches_search->IsMobileOrModal) { ?>
	<div id="r_BranchID" class="form-group row">
		<label for="x_BranchID" class="<?php echo $branches_search->LeftColumnClass ?>"><span id="elh_branches_BranchID"><?php echo $branches->BranchID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_BranchID" id="z_BranchID" value="="></span>
		</label>
		<div class="<?php echo $branches_search->RightColumnClass ?>"><div<?php echo $branches->BranchID->cellAttributes() ?>>
			<span id="el_branches_BranchID">
<input type="text" data-table="branches" data-field="x_BranchID" name="x_BranchID" id="x_BranchID" placeholder="<?php echo HtmlEncode($branches->BranchID->getPlaceHolder()) ?>" value="<?php echo $branches->BranchID->EditValue ?>"<?php echo $branches->BranchID->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_BranchID">
		<td class="<?php echo $branches_search->TableLeftColumnClass ?>"><span id="elh_branches_BranchID"><?php echo $branches->BranchID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_BranchID" id="z_BranchID" value="="></span></td>
		<td<?php echo $branches->BranchID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_branches_BranchID">
<input type="text" data-table="branches" data-field="x_BranchID" name="x_BranchID" id="x_BranchID" placeholder="<?php echo HtmlEncode($branches->BranchID->getPlaceHolder()) ?>" value="<?php echo $branches->BranchID->EditValue ?>"<?php echo $branches->BranchID->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($branches->Branch->Visible) { // Branch ?>
<?php if ($branches_search->IsMobileOrModal) { ?>
	<div id="r_Branch" class="form-group row">
		<label for="x_Branch" class="<?php echo $branches_search->LeftColumnClass ?>"><span id="elh_branches_Branch"><?php echo $branches->Branch->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Branch" id="z_Branch" value="LIKE"></span>
		</label>
		<div class="<?php echo $branches_search->RightColumnClass ?>"><div<?php echo $branches->Branch->cellAttributes() ?>>
			<span id="el_branches_Branch">
<input type="text" data-table="branches" data-field="x_Branch" name="x_Branch" id="x_Branch" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($branches->Branch->getPlaceHolder()) ?>" value="<?php echo $branches->Branch->EditValue ?>"<?php echo $branches->Branch->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_Branch">
		<td class="<?php echo $branches_search->TableLeftColumnClass ?>"><span id="elh_branches_Branch"><?php echo $branches->Branch->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Branch" id="z_Branch" value="LIKE"></span></td>
		<td<?php echo $branches->Branch->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_branches_Branch">
<input type="text" data-table="branches" data-field="x_Branch" name="x_Branch" id="x_Branch" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($branches->Branch->getPlaceHolder()) ?>" value="<?php echo $branches->Branch->EditValue ?>"<?php echo $branches->Branch->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($branches->BranchEn->Visible) { // BranchEn ?>
<?php if ($branches_search->IsMobileOrModal) { ?>
	<div id="r_BranchEn" class="form-group row">
		<label for="x_BranchEn" class="<?php echo $branches_search->LeftColumnClass ?>"><span id="elh_branches_BranchEn"><?php echo $branches->BranchEn->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_BranchEn" id="z_BranchEn" value="LIKE"></span>
		</label>
		<div class="<?php echo $branches_search->RightColumnClass ?>"><div<?php echo $branches->BranchEn->cellAttributes() ?>>
			<span id="el_branches_BranchEn">
<input type="text" data-table="branches" data-field="x_BranchEn" name="x_BranchEn" id="x_BranchEn" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($branches->BranchEn->getPlaceHolder()) ?>" value="<?php echo $branches->BranchEn->EditValue ?>"<?php echo $branches->BranchEn->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_BranchEn">
		<td class="<?php echo $branches_search->TableLeftColumnClass ?>"><span id="elh_branches_BranchEn"><?php echo $branches->BranchEn->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_BranchEn" id="z_BranchEn" value="LIKE"></span></td>
		<td<?php echo $branches->BranchEn->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_branches_BranchEn">
<input type="text" data-table="branches" data-field="x_BranchEn" name="x_BranchEn" id="x_BranchEn" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($branches->BranchEn->getPlaceHolder()) ?>" value="<?php echo $branches->BranchEn->EditValue ?>"<?php echo $branches->BranchEn->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($branches->LawFirmID->Visible) { // LawFirmID ?>
<?php if ($branches_search->IsMobileOrModal) { ?>
	<div id="r_LawFirmID" class="form-group row">
		<label for="x_LawFirmID" class="<?php echo $branches_search->LeftColumnClass ?>"><span id="elh_branches_LawFirmID"><?php echo $branches->LawFirmID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_LawFirmID" id="z_LawFirmID" value="="></span>
		</label>
		<div class="<?php echo $branches_search->RightColumnClass ?>"><div<?php echo $branches->LawFirmID->cellAttributes() ?>>
			<span id="el_branches_LawFirmID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="branches" data-field="x_LawFirmID" data-value-separator="<?php echo $branches->LawFirmID->displayValueSeparatorAttribute() ?>" id="x_LawFirmID" name="x_LawFirmID"<?php echo $branches->LawFirmID->editAttributes() ?>>
		<?php echo $branches->LawFirmID->selectOptionListHtml("x_LawFirmID") ?>
	</select>
</div>
<?php echo $branches->LawFirmID->Lookup->getParamTag("p_x_LawFirmID") ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_LawFirmID">
		<td class="<?php echo $branches_search->TableLeftColumnClass ?>"><span id="elh_branches_LawFirmID"><?php echo $branches->LawFirmID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_LawFirmID" id="z_LawFirmID" value="="></span></td>
		<td<?php echo $branches->LawFirmID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_branches_LawFirmID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="branches" data-field="x_LawFirmID" data-value-separator="<?php echo $branches->LawFirmID->displayValueSeparatorAttribute() ?>" id="x_LawFirmID" name="x_LawFirmID"<?php echo $branches->LawFirmID->editAttributes() ?>>
		<?php echo $branches->LawFirmID->selectOptionListHtml("x_LawFirmID") ?>
	</select>
</div>
<?php echo $branches->LawFirmID->Lookup->getParamTag("p_x_LawFirmID") ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($branches->Notes->Visible) { // Notes ?>
<?php if ($branches_search->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label for="x_Notes" class="<?php echo $branches_search->LeftColumnClass ?>"><span id="elh_branches_Notes"><?php echo $branches->Notes->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Notes" id="z_Notes" value="LIKE"></span>
		</label>
		<div class="<?php echo $branches_search->RightColumnClass ?>"><div<?php echo $branches->Notes->cellAttributes() ?>>
			<span id="el_branches_Notes">
<input type="text" data-table="branches" data-field="x_Notes" name="x_Notes" id="x_Notes" size="35" placeholder="<?php echo HtmlEncode($branches->Notes->getPlaceHolder()) ?>" value="<?php echo $branches->Notes->EditValue ?>"<?php echo $branches->Notes->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $branches_search->TableLeftColumnClass ?>"><span id="elh_branches_Notes"><?php echo $branches->Notes->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Notes" id="z_Notes" value="LIKE"></span></td>
		<td<?php echo $branches->Notes->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_branches_Notes">
<input type="text" data-table="branches" data-field="x_Notes" name="x_Notes" id="x_Notes" size="35" placeholder="<?php echo HtmlEncode($branches->Notes->getPlaceHolder()) ?>" value="<?php echo $branches->Notes->EditValue ?>"<?php echo $branches->Notes->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($branches->Activated->Visible) { // Activated ?>
<?php if ($branches_search->IsMobileOrModal) { ?>
	<div id="r_Activated" class="form-group row">
		<label class="<?php echo $branches_search->LeftColumnClass ?>"><span id="elh_branches_Activated"><?php echo $branches->Activated->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Activated" id="z_Activated" value="="></span>
		</label>
		<div class="<?php echo $branches_search->RightColumnClass ?>"><div<?php echo $branches->Activated->cellAttributes() ?>>
			<span id="el_branches_Activated">
<?php
$selwrk = (ConvertToBool($branches->Activated->AdvancedSearch->SearchValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="branches" data-field="x_Activated" name="x_Activated[]" id="x_Activated[]" value="1"<?php echo $selwrk ?><?php echo $branches->Activated->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_Activated">
		<td class="<?php echo $branches_search->TableLeftColumnClass ?>"><span id="elh_branches_Activated"><?php echo $branches->Activated->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Activated" id="z_Activated" value="="></span></td>
		<td<?php echo $branches->Activated->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_branches_Activated">
<?php
$selwrk = (ConvertToBool($branches->Activated->AdvancedSearch->SearchValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="branches" data-field="x_Activated" name="x_Activated[]" id="x_Activated[]" value="1"<?php echo $selwrk ?><?php echo $branches->Activated->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($branches_search->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if (!$branches_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $branches_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$branches_search->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
</form>
<?php
$branches_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$branches_search->terminate();
?>
