<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$cases2_list = new cases2_list();

// Run the page
$cases2_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$cases2_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$cases2->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fcases2list = currentForm = new ew.Form("fcases2list", "list");
fcases2list.formKeyCountName = '<?php echo $cases2_list->FormKeyCountName ?>';

// Form_CustomValidate event
fcases2list.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcases2list.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcases2list.lists["x_ClientID"] = <?php echo $cases2_list->ClientID->Lookup->toClientList() ?>;
fcases2list.lists["x_ClientID"].options = <?php echo JsonEncode($cases2_list->ClientID->lookupOptions()) ?>;
fcases2list.autoSuggests["x_ClientID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcases2list.lists["x_LitigantID"] = <?php echo $cases2_list->LitigantID->Lookup->toClientList() ?>;
fcases2list.lists["x_LitigantID"].options = <?php echo JsonEncode($cases2_list->LitigantID->lookupOptions()) ?>;
fcases2list.autoSuggests["x_LitigantID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcases2list.lists["x_CaseTypeID"] = <?php echo $cases2_list->CaseTypeID->Lookup->toClientList() ?>;
fcases2list.lists["x_CaseTypeID"].options = <?php echo JsonEncode($cases2_list->CaseTypeID->lookupOptions()) ?>;
fcases2list.lists["x_ClientStatusID"] = <?php echo $cases2_list->ClientStatusID->Lookup->toClientList() ?>;
fcases2list.lists["x_ClientStatusID"].options = <?php echo JsonEncode($cases2_list->ClientStatusID->lookupOptions()) ?>;

// Form object for search
var fcases2listsrch = currentSearchForm = new ew.Form("fcases2listsrch");

// Filters
fcases2listsrch.filterList = <?php echo $cases2_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$cases2->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($cases2_list->TotalRecs > 0 && $cases2_list->ExportOptions->visible()) { ?>
<?php $cases2_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($cases2_list->ImportOptions->visible()) { ?>
<?php $cases2_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($cases2_list->SearchOptions->visible()) { ?>
<?php $cases2_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($cases2_list->FilterOptions->visible()) { ?>
<?php $cases2_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$cases2_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$cases2->isExport() && !$cases2->CurrentAction) { ?>
<form name="fcases2listsrch" id="fcases2listsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($cases2_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="fcases2listsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="cases2">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($cases2_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($cases2_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $cases2_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($cases2_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($cases2_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($cases2_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($cases2_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $cases2_list->showPageHeader(); ?>
<?php
$cases2_list->showMessage();
?>
<?php if ($cases2_list->TotalRecs > 0 || $cases2->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($cases2_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> cases2">
<?php if (!$cases2->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$cases2->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($cases2_list->Pager)) $cases2_list->Pager = new PrevNextPager($cases2_list->StartRec, $cases2_list->DisplayRecs, $cases2_list->TotalRecs, $cases2_list->AutoHidePager) ?>
<?php if ($cases2_list->Pager->RecordCount > 0 && $cases2_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($cases2_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $cases2_list->pageUrl() ?>start=<?php echo $cases2_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($cases2_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $cases2_list->pageUrl() ?>start=<?php echo $cases2_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $cases2_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($cases2_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $cases2_list->pageUrl() ?>start=<?php echo $cases2_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($cases2_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $cases2_list->pageUrl() ?>start=<?php echo $cases2_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $cases2_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($cases2_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $cases2_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $cases2_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $cases2_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($cases2_list->TotalRecs > 0 && (!$cases2_list->AutoHidePageSizeSelector || $cases2_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="cases2">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($cases2_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($cases2_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($cases2_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($cases2_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($cases2_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($cases2_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($cases2_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($cases2_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($cases2_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($cases2->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $cases2_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fcases2list" id="fcases2list" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($cases2_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $cases2_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="cases2">
<div id="gmp_cases2" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($cases2_list->TotalRecs > 0 || $cases2->isGridEdit()) { ?>
<table id="tbl_cases2list" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$cases2_list->RowType = ROWTYPE_HEADER;

// Render list options
$cases2_list->renderListOptions();

// Render list options (header, left)
$cases2_list->ListOptions->render("header", "left");
?>
<?php if ($cases2->ClientID->Visible) { // ClientID ?>
	<?php if ($cases2->sortUrl($cases2->ClientID) == "") { ?>
		<th data-name="ClientID" class="<?php echo $cases2->ClientID->headerCellClass() ?>" style="min-width: 150px;"><div id="elh_cases2_ClientID" class="cases2_ClientID"><div class="ew-table-header-caption"><?php echo $cases2->ClientID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ClientID" class="<?php echo $cases2->ClientID->headerCellClass() ?>" style="min-width: 150px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cases2->SortUrl($cases2->ClientID) ?>',2);"><div id="elh_cases2_ClientID" class="cases2_ClientID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases2->ClientID->caption() ?></span><span class="ew-table-header-sort"><?php if ($cases2->ClientID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases2->ClientID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases2->LitigantID->Visible) { // LitigantID ?>
	<?php if ($cases2->sortUrl($cases2->LitigantID) == "") { ?>
		<th data-name="LitigantID" class="<?php echo $cases2->LitigantID->headerCellClass() ?>" style="width: 250px; white-space: nowrap;"><div id="elh_cases2_LitigantID" class="cases2_LitigantID"><div class="ew-table-header-caption"><?php echo $cases2->LitigantID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LitigantID" class="<?php echo $cases2->LitigantID->headerCellClass() ?>" style="width: 250px; white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cases2->SortUrl($cases2->LitigantID) ?>',2);"><div id="elh_cases2_LitigantID" class="cases2_LitigantID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases2->LitigantID->caption() ?></span><span class="ew-table-header-sort"><?php if ($cases2->LitigantID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases2->LitigantID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases2->CaseTypeID->Visible) { // CaseTypeID ?>
	<?php if ($cases2->sortUrl($cases2->CaseTypeID) == "") { ?>
		<th data-name="CaseTypeID" class="<?php echo $cases2->CaseTypeID->headerCellClass() ?>" style="min-width: 120px;"><div id="elh_cases2_CaseTypeID" class="cases2_CaseTypeID"><div class="ew-table-header-caption"><?php echo $cases2->CaseTypeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CaseTypeID" class="<?php echo $cases2->CaseTypeID->headerCellClass() ?>" style="min-width: 120px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cases2->SortUrl($cases2->CaseTypeID) ?>',2);"><div id="elh_cases2_CaseTypeID" class="cases2_CaseTypeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases2->CaseTypeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($cases2->CaseTypeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases2->CaseTypeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases2->CaseNumber->Visible) { // CaseNumber ?>
	<?php if ($cases2->sortUrl($cases2->CaseNumber) == "") { ?>
		<th data-name="CaseNumber" class="<?php echo $cases2->CaseNumber->headerCellClass() ?>"><div id="elh_cases2_CaseNumber" class="cases2_CaseNumber"><div class="ew-table-header-caption"><?php echo $cases2->CaseNumber->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CaseNumber" class="<?php echo $cases2->CaseNumber->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cases2->SortUrl($cases2->CaseNumber) ?>',2);"><div id="elh_cases2_CaseNumber" class="cases2_CaseNumber">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases2->CaseNumber->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($cases2->CaseNumber->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases2->CaseNumber->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases2->FileNumber->Visible) { // FileNumber ?>
	<?php if ($cases2->sortUrl($cases2->FileNumber) == "") { ?>
		<th data-name="FileNumber" class="<?php echo $cases2->FileNumber->headerCellClass() ?>"><div id="elh_cases2_FileNumber" class="cases2_FileNumber"><div class="ew-table-header-caption"><?php echo $cases2->FileNumber->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FileNumber" class="<?php echo $cases2->FileNumber->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cases2->SortUrl($cases2->FileNumber) ?>',2);"><div id="elh_cases2_FileNumber" class="cases2_FileNumber">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases2->FileNumber->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($cases2->FileNumber->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases2->FileNumber->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases2->ClientStatusID->Visible) { // ClientStatusID ?>
	<?php if ($cases2->sortUrl($cases2->ClientStatusID) == "") { ?>
		<th data-name="ClientStatusID" class="<?php echo $cases2->ClientStatusID->headerCellClass() ?>"><div id="elh_cases2_ClientStatusID" class="cases2_ClientStatusID"><div class="ew-table-header-caption"><?php echo $cases2->ClientStatusID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ClientStatusID" class="<?php echo $cases2->ClientStatusID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cases2->SortUrl($cases2->ClientStatusID) ?>',2);"><div id="elh_cases2_ClientStatusID" class="cases2_ClientStatusID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases2->ClientStatusID->caption() ?></span><span class="ew-table-header-sort"><?php if ($cases2->ClientStatusID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases2->ClientStatusID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases2->Notes->Visible) { // Notes ?>
	<?php if ($cases2->sortUrl($cases2->Notes) == "") { ?>
		<th data-name="Notes" class="<?php echo $cases2->Notes->headerCellClass() ?>" style="min-width: 200px;"><div id="elh_cases2_Notes" class="cases2_Notes"><div class="ew-table-header-caption"><?php echo $cases2->Notes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Notes" class="<?php echo $cases2->Notes->headerCellClass() ?>" style="min-width: 200px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $cases2->SortUrl($cases2->Notes) ?>',2);"><div id="elh_cases2_Notes" class="cases2_Notes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases2->Notes->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($cases2->Notes->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases2->Notes->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$cases2_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($cases2->ExportAll && $cases2->isExport()) {
	$cases2_list->StopRec = $cases2_list->TotalRecs;
} else {

	// Set the last record to display
	if ($cases2_list->TotalRecs > $cases2_list->StartRec + $cases2_list->DisplayRecs - 1)
		$cases2_list->StopRec = $cases2_list->StartRec + $cases2_list->DisplayRecs - 1;
	else
		$cases2_list->StopRec = $cases2_list->TotalRecs;
}
$cases2_list->RecCnt = $cases2_list->StartRec - 1;
if ($cases2_list->Recordset && !$cases2_list->Recordset->EOF) {
	$cases2_list->Recordset->moveFirst();
	$selectLimit = $cases2_list->UseSelectLimit;
	if (!$selectLimit && $cases2_list->StartRec > 1)
		$cases2_list->Recordset->move($cases2_list->StartRec - 1);
} elseif (!$cases2->AllowAddDeleteRow && $cases2_list->StopRec == 0) {
	$cases2_list->StopRec = $cases2->GridAddRowCount;
}

// Initialize aggregate
$cases2->RowType = ROWTYPE_AGGREGATEINIT;
$cases2->resetAttributes();
$cases2_list->renderRow();
while ($cases2_list->RecCnt < $cases2_list->StopRec) {
	$cases2_list->RecCnt++;
	if ($cases2_list->RecCnt >= $cases2_list->StartRec) {
		$cases2_list->RowCnt++;

		// Set up key count
		$cases2_list->KeyCount = $cases2_list->RowIndex;

		// Init row class and style
		$cases2->resetAttributes();
		$cases2->CssClass = "";
		if ($cases2->isGridAdd()) {
		} else {
			$cases2_list->loadRowValues($cases2_list->Recordset); // Load row values
		}
		$cases2->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$cases2->RowAttrs = array_merge($cases2->RowAttrs, array('data-rowindex'=>$cases2_list->RowCnt, 'id'=>'r' . $cases2_list->RowCnt . '_cases2', 'data-rowtype'=>$cases2->RowType));

		// Render row
		$cases2_list->renderRow();

		// Render list options
		$cases2_list->renderListOptions();
?>
	<tr<?php echo $cases2->rowAttributes() ?>>
<?php

// Render list options (body, left)
$cases2_list->ListOptions->render("body", "left", $cases2_list->RowCnt);
?>
	<?php if ($cases2->ClientID->Visible) { // ClientID ?>
		<td data-name="ClientID"<?php echo $cases2->ClientID->cellAttributes() ?>>
<span id="el<?php echo $cases2_list->RowCnt ?>_cases2_ClientID" class="cases2_ClientID">
<span<?php echo $cases2->ClientID->viewAttributes() ?>>
<?php if ((!EmptyString($cases2->ClientID->getViewValue())) && $cases2->ClientID->linkAttributes() <> "") { ?>
<a<?php echo $cases2->ClientID->linkAttributes() ?>><?php echo $cases2->ClientID->getViewValue() ?></a>
<?php } else { ?>
<?php echo $cases2->ClientID->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($cases2->LitigantID->Visible) { // LitigantID ?>
		<td data-name="LitigantID"<?php echo $cases2->LitigantID->cellAttributes() ?>>
<span id="el<?php echo $cases2_list->RowCnt ?>_cases2_LitigantID" class="cases2_LitigantID">
<span<?php echo $cases2->LitigantID->viewAttributes() ?>>
<?php if ((!EmptyString($cases2->LitigantID->getViewValue())) && $cases2->LitigantID->linkAttributes() <> "") { ?>
<a<?php echo $cases2->LitigantID->linkAttributes() ?>><?php echo $cases2->LitigantID->getViewValue() ?></a>
<?php } else { ?>
<?php echo $cases2->LitigantID->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($cases2->CaseTypeID->Visible) { // CaseTypeID ?>
		<td data-name="CaseTypeID"<?php echo $cases2->CaseTypeID->cellAttributes() ?>>
<span id="el<?php echo $cases2_list->RowCnt ?>_cases2_CaseTypeID" class="cases2_CaseTypeID">
<span<?php echo $cases2->CaseTypeID->viewAttributes() ?>>
<?php echo $cases2->CaseTypeID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cases2->CaseNumber->Visible) { // CaseNumber ?>
		<td data-name="CaseNumber"<?php echo $cases2->CaseNumber->cellAttributes() ?>>
<span id="el<?php echo $cases2_list->RowCnt ?>_cases2_CaseNumber" class="cases2_CaseNumber">
<span<?php echo $cases2->CaseNumber->viewAttributes() ?>>
<?php echo $cases2->CaseNumber->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cases2->FileNumber->Visible) { // FileNumber ?>
		<td data-name="FileNumber"<?php echo $cases2->FileNumber->cellAttributes() ?>>
<span id="el<?php echo $cases2_list->RowCnt ?>_cases2_FileNumber" class="cases2_FileNumber">
<span<?php echo $cases2->FileNumber->viewAttributes() ?>>
<?php echo $cases2->FileNumber->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cases2->ClientStatusID->Visible) { // ClientStatusID ?>
		<td data-name="ClientStatusID"<?php echo $cases2->ClientStatusID->cellAttributes() ?>>
<span id="el<?php echo $cases2_list->RowCnt ?>_cases2_ClientStatusID" class="cases2_ClientStatusID">
<span<?php echo $cases2->ClientStatusID->viewAttributes() ?>>
<?php echo $cases2->ClientStatusID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($cases2->Notes->Visible) { // Notes ?>
		<td data-name="Notes"<?php echo $cases2->Notes->cellAttributes() ?>>
<span id="el<?php echo $cases2_list->RowCnt ?>_cases2_Notes" class="cases2_Notes">
<span<?php echo $cases2->Notes->viewAttributes() ?>>
<?php echo $cases2->Notes->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$cases2_list->ListOptions->render("body", "right", $cases2_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$cases2->isGridAdd())
		$cases2_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$cases2->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($cases2_list->Recordset)
	$cases2_list->Recordset->Close();
?>
<?php if (!$cases2->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$cases2->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($cases2_list->Pager)) $cases2_list->Pager = new PrevNextPager($cases2_list->StartRec, $cases2_list->DisplayRecs, $cases2_list->TotalRecs, $cases2_list->AutoHidePager) ?>
<?php if ($cases2_list->Pager->RecordCount > 0 && $cases2_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($cases2_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $cases2_list->pageUrl() ?>start=<?php echo $cases2_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($cases2_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $cases2_list->pageUrl() ?>start=<?php echo $cases2_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $cases2_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($cases2_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $cases2_list->pageUrl() ?>start=<?php echo $cases2_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($cases2_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $cases2_list->pageUrl() ?>start=<?php echo $cases2_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $cases2_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($cases2_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $cases2_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $cases2_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $cases2_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($cases2_list->TotalRecs > 0 && (!$cases2_list->AutoHidePageSizeSelector || $cases2_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="cases2">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($cases2_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($cases2_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($cases2_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($cases2_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($cases2_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($cases2_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($cases2_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($cases2_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($cases2_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($cases2->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $cases2_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($cases2_list->TotalRecs == 0 && !$cases2->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $cases2_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$cases2_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$cases2->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$cases2->isExport()) { ?>
<script>
ew.scrollableTable("gmp_cases2", "1250px", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$cases2_list->terminate();
?>
