<?php
namespace PHPMaker2019\project_germanos;

// Write header
WriteHeader(FALSE);

// Create page object
if (!isset($cases_grid))
	$cases_grid = new cases_grid();

// Run the page
$cases_grid->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$cases_grid->Page_Render();
?>
<?php if (!$cases->isExport()) { ?>
<script>

// Form object
var fcasesgrid = new ew.Form("fcasesgrid", "grid");
fcasesgrid.formKeyCountName = '<?php echo $cases_grid->FormKeyCountName ?>';

// Validate form
fcasesgrid.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
		if (checkrow) {
			addcnt++;
		<?php if ($cases_grid->ClientID->Required) { ?>
			elm = this.getElements("x" + infix + "_ClientID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->ClientID->caption(), $cases->ClientID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_grid->LitigantID->Required) { ?>
			elm = this.getElements("x" + infix + "_LitigantID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->LitigantID->caption(), $cases->LitigantID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_grid->CaseTypeID->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseTypeID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->CaseTypeID->caption(), $cases->CaseTypeID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_grid->CourtID->Required) { ?>
			elm = this.getElements("x" + infix + "_CourtID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->CourtID->caption(), $cases->CourtID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_grid->CaseNumber->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseNumber");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->CaseNumber->caption(), $cases->CaseNumber->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_grid->FileNumber->Required) { ?>
			elm = this.getElements("x" + infix + "_FileNumber");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->FileNumber->caption(), $cases->FileNumber->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_grid->ClientStatusID->Required) { ?>
			elm = this.getElements("x" + infix + "_ClientStatusID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->ClientStatusID->caption(), $cases->ClientStatusID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_grid->LitigantStatusID->Required) { ?>
			elm = this.getElements("x" + infix + "_LitigantStatusID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->LitigantStatusID->caption(), $cases->LitigantStatusID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_grid->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->Notes->caption(), $cases->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_grid->ParentCaseID->Required) { ?>
			elm = this.getElements("x" + infix + "_ParentCaseID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->ParentCaseID->caption(), $cases->ParentCaseID->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_ParentCaseID");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($cases->ParentCaseID->errorMessage()) ?>");
		<?php if ($cases_grid->FileNumber2->Required) { ?>
			elm = this.getElements("x" + infix + "_FileNumber2");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->FileNumber2->caption(), $cases->FileNumber2->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_FileNumber2");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($cases->FileNumber2->errorMessage()) ?>");
		<?php if ($cases_grid->ClientNameConvFiles->Required) { ?>
			elm = this.getElements("x" + infix + "_ClientNameConvFiles");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->ClientNameConvFiles->caption(), $cases->ClientNameConvFiles->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_grid->LitigantNameConvFiles->Required) { ?>
			elm = this.getElements("x" + infix + "_LitigantNameConvFiles");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->LitigantNameConvFiles->caption(), $cases->LitigantNameConvFiles->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases_grid->CaseTypeConvFiles->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseTypeConvFiles");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases->CaseTypeConvFiles->caption(), $cases->CaseTypeConvFiles->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
		} // End Grid Add checking
	}
	return true;
}

// Check empty row
fcasesgrid.emptyRow = function(infix) {
	var fobj = this._form;
	if (ew.valueChanged(fobj, infix, "ClientID", false)) return false;
	if (ew.valueChanged(fobj, infix, "LitigantID", false)) return false;
	if (ew.valueChanged(fobj, infix, "CaseTypeID", false)) return false;
	if (ew.valueChanged(fobj, infix, "CourtID", false)) return false;
	if (ew.valueChanged(fobj, infix, "CaseNumber", false)) return false;
	if (ew.valueChanged(fobj, infix, "FileNumber", false)) return false;
	if (ew.valueChanged(fobj, infix, "ClientStatusID", false)) return false;
	if (ew.valueChanged(fobj, infix, "LitigantStatusID", false)) return false;
	if (ew.valueChanged(fobj, infix, "Notes", false)) return false;
	if (ew.valueChanged(fobj, infix, "ParentCaseID", false)) return false;
	if (ew.valueChanged(fobj, infix, "FileNumber2", false)) return false;
	if (ew.valueChanged(fobj, infix, "ClientNameConvFiles", false)) return false;
	if (ew.valueChanged(fobj, infix, "LitigantNameConvFiles", false)) return false;
	if (ew.valueChanged(fobj, infix, "CaseTypeConvFiles", false)) return false;
	return true;
}

// Form_CustomValidate event
fcasesgrid.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcasesgrid.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcasesgrid.lists["x_ClientID"] = <?php echo $cases_grid->ClientID->Lookup->toClientList() ?>;
fcasesgrid.lists["x_ClientID"].options = <?php echo JsonEncode($cases_grid->ClientID->lookupOptions()) ?>;
fcasesgrid.autoSuggests["x_ClientID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcasesgrid.lists["x_LitigantID"] = <?php echo $cases_grid->LitigantID->Lookup->toClientList() ?>;
fcasesgrid.lists["x_LitigantID"].options = <?php echo JsonEncode($cases_grid->LitigantID->lookupOptions()) ?>;
fcasesgrid.autoSuggests["x_LitigantID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcasesgrid.lists["x_CaseTypeID"] = <?php echo $cases_grid->CaseTypeID->Lookup->toClientList() ?>;
fcasesgrid.lists["x_CaseTypeID"].options = <?php echo JsonEncode($cases_grid->CaseTypeID->lookupOptions()) ?>;
fcasesgrid.lists["x_CourtID"] = <?php echo $cases_grid->CourtID->Lookup->toClientList() ?>;
fcasesgrid.lists["x_CourtID"].options = <?php echo JsonEncode($cases_grid->CourtID->lookupOptions()) ?>;
fcasesgrid.autoSuggests["x_CourtID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcasesgrid.lists["x_ClientStatusID"] = <?php echo $cases_grid->ClientStatusID->Lookup->toClientList() ?>;
fcasesgrid.lists["x_ClientStatusID"].options = <?php echo JsonEncode($cases_grid->ClientStatusID->lookupOptions()) ?>;
fcasesgrid.lists["x_LitigantStatusID"] = <?php echo $cases_grid->LitigantStatusID->Lookup->toClientList() ?>;
fcasesgrid.lists["x_LitigantStatusID"].options = <?php echo JsonEncode($cases_grid->LitigantStatusID->lookupOptions()) ?>;

// Form object for search
</script>
<script src="phpjs/ewscrolltable.js"></script>
<?php } ?>
<?php
$cases_grid->renderOtherOptions();
?>
<?php $cases_grid->showPageHeader(); ?>
<?php
$cases_grid->showMessage();
?>
<?php if ($cases_grid->TotalRecs > 0 || $cases->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($cases_grid->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> cases">
<?php if ($cases_grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $cases_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<div id="fcasesgrid" class="ew-form ew-list-form form-inline">
<div id="gmp_cases" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table id="tbl_casesgrid" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$cases_grid->RowType = ROWTYPE_HEADER;

// Render list options
$cases_grid->renderListOptions();

// Render list options (header, left)
$cases_grid->ListOptions->render("header", "left");
?>
<?php if ($cases->ClientID->Visible) { // ClientID ?>
	<?php if ($cases->sortUrl($cases->ClientID) == "") { ?>
		<th data-name="ClientID" class="<?php echo $cases->ClientID->headerCellClass() ?>" style="min-width: 150px;"><div id="elh_cases_ClientID" class="cases_ClientID"><div class="ew-table-header-caption"><?php echo $cases->ClientID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ClientID" class="<?php echo $cases->ClientID->headerCellClass() ?>" style="min-width: 150px;"><div><div id="elh_cases_ClientID" class="cases_ClientID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases->ClientID->caption() ?></span><span class="ew-table-header-sort"><?php if ($cases->ClientID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases->ClientID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases->LitigantID->Visible) { // LitigantID ?>
	<?php if ($cases->sortUrl($cases->LitigantID) == "") { ?>
		<th data-name="LitigantID" class="<?php echo $cases->LitigantID->headerCellClass() ?>" style="width: 250px; white-space: nowrap;"><div id="elh_cases_LitigantID" class="cases_LitigantID"><div class="ew-table-header-caption"><?php echo $cases->LitigantID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LitigantID" class="<?php echo $cases->LitigantID->headerCellClass() ?>" style="width: 250px; white-space: nowrap;"><div><div id="elh_cases_LitigantID" class="cases_LitigantID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases->LitigantID->caption() ?></span><span class="ew-table-header-sort"><?php if ($cases->LitigantID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases->LitigantID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases->CaseTypeID->Visible) { // CaseTypeID ?>
	<?php if ($cases->sortUrl($cases->CaseTypeID) == "") { ?>
		<th data-name="CaseTypeID" class="<?php echo $cases->CaseTypeID->headerCellClass() ?>" style="min-width: 120px;"><div id="elh_cases_CaseTypeID" class="cases_CaseTypeID"><div class="ew-table-header-caption"><?php echo $cases->CaseTypeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CaseTypeID" class="<?php echo $cases->CaseTypeID->headerCellClass() ?>" style="min-width: 120px;"><div><div id="elh_cases_CaseTypeID" class="cases_CaseTypeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases->CaseTypeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($cases->CaseTypeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases->CaseTypeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases->CourtID->Visible) { // CourtID ?>
	<?php if ($cases->sortUrl($cases->CourtID) == "") { ?>
		<th data-name="CourtID" class="<?php echo $cases->CourtID->headerCellClass() ?>" style="width: 200px; white-space: nowrap;"><div id="elh_cases_CourtID" class="cases_CourtID"><div class="ew-table-header-caption"><?php echo $cases->CourtID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CourtID" class="<?php echo $cases->CourtID->headerCellClass() ?>" style="width: 200px; white-space: nowrap;"><div><div id="elh_cases_CourtID" class="cases_CourtID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases->CourtID->caption() ?></span><span class="ew-table-header-sort"><?php if ($cases->CourtID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases->CourtID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases->CaseNumber->Visible) { // CaseNumber ?>
	<?php if ($cases->sortUrl($cases->CaseNumber) == "") { ?>
		<th data-name="CaseNumber" class="<?php echo $cases->CaseNumber->headerCellClass() ?>"><div id="elh_cases_CaseNumber" class="cases_CaseNumber"><div class="ew-table-header-caption"><?php echo $cases->CaseNumber->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CaseNumber" class="<?php echo $cases->CaseNumber->headerCellClass() ?>"><div><div id="elh_cases_CaseNumber" class="cases_CaseNumber">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases->CaseNumber->caption() ?></span><span class="ew-table-header-sort"><?php if ($cases->CaseNumber->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases->CaseNumber->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases->FileNumber->Visible) { // FileNumber ?>
	<?php if ($cases->sortUrl($cases->FileNumber) == "") { ?>
		<th data-name="FileNumber" class="<?php echo $cases->FileNumber->headerCellClass() ?>"><div id="elh_cases_FileNumber" class="cases_FileNumber"><div class="ew-table-header-caption"><?php echo $cases->FileNumber->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FileNumber" class="<?php echo $cases->FileNumber->headerCellClass() ?>"><div><div id="elh_cases_FileNumber" class="cases_FileNumber">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases->FileNumber->caption() ?></span><span class="ew-table-header-sort"><?php if ($cases->FileNumber->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases->FileNumber->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases->ClientStatusID->Visible) { // ClientStatusID ?>
	<?php if ($cases->sortUrl($cases->ClientStatusID) == "") { ?>
		<th data-name="ClientStatusID" class="<?php echo $cases->ClientStatusID->headerCellClass() ?>"><div id="elh_cases_ClientStatusID" class="cases_ClientStatusID"><div class="ew-table-header-caption"><?php echo $cases->ClientStatusID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ClientStatusID" class="<?php echo $cases->ClientStatusID->headerCellClass() ?>"><div><div id="elh_cases_ClientStatusID" class="cases_ClientStatusID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases->ClientStatusID->caption() ?></span><span class="ew-table-header-sort"><?php if ($cases->ClientStatusID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases->ClientStatusID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases->LitigantStatusID->Visible) { // LitigantStatusID ?>
	<?php if ($cases->sortUrl($cases->LitigantStatusID) == "") { ?>
		<th data-name="LitigantStatusID" class="<?php echo $cases->LitigantStatusID->headerCellClass() ?>"><div id="elh_cases_LitigantStatusID" class="cases_LitigantStatusID"><div class="ew-table-header-caption"><?php echo $cases->LitigantStatusID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LitigantStatusID" class="<?php echo $cases->LitigantStatusID->headerCellClass() ?>"><div><div id="elh_cases_LitigantStatusID" class="cases_LitigantStatusID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases->LitigantStatusID->caption() ?></span><span class="ew-table-header-sort"><?php if ($cases->LitigantStatusID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases->LitigantStatusID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases->Notes->Visible) { // Notes ?>
	<?php if ($cases->sortUrl($cases->Notes) == "") { ?>
		<th data-name="Notes" class="<?php echo $cases->Notes->headerCellClass() ?>" style="min-width: 200px;"><div id="elh_cases_Notes" class="cases_Notes"><div class="ew-table-header-caption"><?php echo $cases->Notes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Notes" class="<?php echo $cases->Notes->headerCellClass() ?>" style="min-width: 200px;"><div><div id="elh_cases_Notes" class="cases_Notes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases->Notes->caption() ?></span><span class="ew-table-header-sort"><?php if ($cases->Notes->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases->Notes->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases->ParentCaseID->Visible) { // ParentCaseID ?>
	<?php if ($cases->sortUrl($cases->ParentCaseID) == "") { ?>
		<th data-name="ParentCaseID" class="<?php echo $cases->ParentCaseID->headerCellClass() ?>"><div id="elh_cases_ParentCaseID" class="cases_ParentCaseID"><div class="ew-table-header-caption"><?php echo $cases->ParentCaseID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ParentCaseID" class="<?php echo $cases->ParentCaseID->headerCellClass() ?>"><div><div id="elh_cases_ParentCaseID" class="cases_ParentCaseID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases->ParentCaseID->caption() ?></span><span class="ew-table-header-sort"><?php if ($cases->ParentCaseID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases->ParentCaseID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases->FileNumber2->Visible) { // FileNumber2 ?>
	<?php if ($cases->sortUrl($cases->FileNumber2) == "") { ?>
		<th data-name="FileNumber2" class="<?php echo $cases->FileNumber2->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_cases_FileNumber2" class="cases_FileNumber2"><div class="ew-table-header-caption"><?php echo $cases->FileNumber2->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FileNumber2" class="<?php echo $cases->FileNumber2->headerCellClass() ?>" style="white-space: nowrap;"><div><div id="elh_cases_FileNumber2" class="cases_FileNumber2">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases->FileNumber2->caption() ?></span><span class="ew-table-header-sort"><?php if ($cases->FileNumber2->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases->FileNumber2->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases->ClientNameConvFiles->Visible) { // ClientNameConvFiles ?>
	<?php if ($cases->sortUrl($cases->ClientNameConvFiles) == "") { ?>
		<th data-name="ClientNameConvFiles" class="<?php echo $cases->ClientNameConvFiles->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_cases_ClientNameConvFiles" class="cases_ClientNameConvFiles"><div class="ew-table-header-caption"><?php echo $cases->ClientNameConvFiles->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ClientNameConvFiles" class="<?php echo $cases->ClientNameConvFiles->headerCellClass() ?>" style="white-space: nowrap;"><div><div id="elh_cases_ClientNameConvFiles" class="cases_ClientNameConvFiles">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases->ClientNameConvFiles->caption() ?></span><span class="ew-table-header-sort"><?php if ($cases->ClientNameConvFiles->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases->ClientNameConvFiles->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases->LitigantNameConvFiles->Visible) { // LitigantNameConvFiles ?>
	<?php if ($cases->sortUrl($cases->LitigantNameConvFiles) == "") { ?>
		<th data-name="LitigantNameConvFiles" class="<?php echo $cases->LitigantNameConvFiles->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_cases_LitigantNameConvFiles" class="cases_LitigantNameConvFiles"><div class="ew-table-header-caption"><?php echo $cases->LitigantNameConvFiles->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LitigantNameConvFiles" class="<?php echo $cases->LitigantNameConvFiles->headerCellClass() ?>" style="white-space: nowrap;"><div><div id="elh_cases_LitigantNameConvFiles" class="cases_LitigantNameConvFiles">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases->LitigantNameConvFiles->caption() ?></span><span class="ew-table-header-sort"><?php if ($cases->LitigantNameConvFiles->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases->LitigantNameConvFiles->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($cases->CaseTypeConvFiles->Visible) { // CaseTypeConvFiles ?>
	<?php if ($cases->sortUrl($cases->CaseTypeConvFiles) == "") { ?>
		<th data-name="CaseTypeConvFiles" class="<?php echo $cases->CaseTypeConvFiles->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_cases_CaseTypeConvFiles" class="cases_CaseTypeConvFiles"><div class="ew-table-header-caption"><?php echo $cases->CaseTypeConvFiles->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CaseTypeConvFiles" class="<?php echo $cases->CaseTypeConvFiles->headerCellClass() ?>" style="white-space: nowrap;"><div><div id="elh_cases_CaseTypeConvFiles" class="cases_CaseTypeConvFiles">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $cases->CaseTypeConvFiles->caption() ?></span><span class="ew-table-header-sort"><?php if ($cases->CaseTypeConvFiles->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($cases->CaseTypeConvFiles->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$cases_grid->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
$cases_grid->StartRec = 1;
$cases_grid->StopRec = $cases_grid->TotalRecs; // Show all records

// Restore number of post back records
if ($CurrentForm && $cases_grid->EventCancelled) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($cases_grid->FormKeyCountName) && ($cases->isGridAdd() || $cases->isGridEdit() || $cases->isConfirm())) {
		$cases_grid->KeyCount = $CurrentForm->getValue($cases_grid->FormKeyCountName);
		$cases_grid->StopRec = $cases_grid->StartRec + $cases_grid->KeyCount - 1;
	}
}
$cases_grid->RecCnt = $cases_grid->StartRec - 1;
if ($cases_grid->Recordset && !$cases_grid->Recordset->EOF) {
	$cases_grid->Recordset->moveFirst();
	$selectLimit = $cases_grid->UseSelectLimit;
	if (!$selectLimit && $cases_grid->StartRec > 1)
		$cases_grid->Recordset->move($cases_grid->StartRec - 1);
} elseif (!$cases->AllowAddDeleteRow && $cases_grid->StopRec == 0) {
	$cases_grid->StopRec = $cases->GridAddRowCount;
}

// Initialize aggregate
$cases->RowType = ROWTYPE_AGGREGATEINIT;
$cases->resetAttributes();
$cases_grid->renderRow();
if ($cases->isGridAdd())
	$cases_grid->RowIndex = 0;
if ($cases->isGridEdit())
	$cases_grid->RowIndex = 0;
while ($cases_grid->RecCnt < $cases_grid->StopRec) {
	$cases_grid->RecCnt++;
	if ($cases_grid->RecCnt >= $cases_grid->StartRec) {
		$cases_grid->RowCnt++;
		if ($cases->isGridAdd() || $cases->isGridEdit() || $cases->isConfirm()) {
			$cases_grid->RowIndex++;
			$CurrentForm->Index = $cases_grid->RowIndex;
			if ($CurrentForm->hasValue($cases_grid->FormActionName) && $cases_grid->EventCancelled)
				$cases_grid->RowAction = strval($CurrentForm->getValue($cases_grid->FormActionName));
			elseif ($cases->isGridAdd())
				$cases_grid->RowAction = "insert";
			else
				$cases_grid->RowAction = "";
		}

		// Set up key count
		$cases_grid->KeyCount = $cases_grid->RowIndex;

		// Init row class and style
		$cases->resetAttributes();
		$cases->CssClass = "";
		if ($cases->isGridAdd()) {
			if ($cases->CurrentMode == "copy") {
				$cases_grid->loadRowValues($cases_grid->Recordset); // Load row values
				$cases_grid->setRecordKey($cases_grid->RowOldKey, $cases_grid->Recordset); // Set old record key
			} else {
				$cases_grid->loadRowValues(); // Load default values
				$cases_grid->RowOldKey = ""; // Clear old key value
			}
		} else {
			$cases_grid->loadRowValues($cases_grid->Recordset); // Load row values
		}
		$cases->RowType = ROWTYPE_VIEW; // Render view
		if ($cases->isGridAdd()) // Grid add
			$cases->RowType = ROWTYPE_ADD; // Render add
		if ($cases->isGridAdd() && $cases->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$cases_grid->restoreCurrentRowFormValues($cases_grid->RowIndex); // Restore form values
		if ($cases->isGridEdit()) { // Grid edit
			if ($cases->EventCancelled)
				$cases_grid->restoreCurrentRowFormValues($cases_grid->RowIndex); // Restore form values
			if ($cases_grid->RowAction == "insert")
				$cases->RowType = ROWTYPE_ADD; // Render add
			else
				$cases->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($cases->isGridEdit() && ($cases->RowType == ROWTYPE_EDIT || $cases->RowType == ROWTYPE_ADD) && $cases->EventCancelled) // Update failed
			$cases_grid->restoreCurrentRowFormValues($cases_grid->RowIndex); // Restore form values
		if ($cases->RowType == ROWTYPE_EDIT) // Edit row
			$cases_grid->EditRowCnt++;
		if ($cases->isConfirm()) // Confirm row
			$cases_grid->restoreCurrentRowFormValues($cases_grid->RowIndex); // Restore form values

		// Set up row id / data-rowindex
		$cases->RowAttrs = array_merge($cases->RowAttrs, array('data-rowindex'=>$cases_grid->RowCnt, 'id'=>'r' . $cases_grid->RowCnt . '_cases', 'data-rowtype'=>$cases->RowType));

		// Render row
		$cases_grid->renderRow();

		// Render list options
		$cases_grid->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($cases_grid->RowAction <> "delete" && $cases_grid->RowAction <> "insertdelete" && !($cases_grid->RowAction == "insert" && $cases->isConfirm() && $cases_grid->emptyRow())) {
?>
	<tr<?php echo $cases->rowAttributes() ?>>
<?php

// Render list options (body, left)
$cases_grid->ListOptions->render("body", "left", $cases_grid->RowCnt);
?>
	<?php if ($cases->ClientID->Visible) { // ClientID ?>
		<td data-name="ClientID"<?php echo $cases->ClientID->cellAttributes() ?>>
<?php if ($cases->RowType == ROWTYPE_ADD) { // Add record ?>
<?php if ($cases->ClientID->getSessionValue() <> "") { ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_ClientID" class="form-group cases_ClientID">
<span<?php echo $cases->ClientID->viewAttributes() ?>>
<?php if ((!EmptyString($cases->ClientID->ViewValue)) && $cases->ClientID->linkAttributes() <> "") { ?>
<a<?php echo $cases->ClientID->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->ClientID->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->ClientID->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" id="x<?php echo $cases_grid->RowIndex ?>_ClientID" name="x<?php echo $cases_grid->RowIndex ?>_ClientID" value="<?php echo HtmlEncode($cases->ClientID->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_ClientID" class="form-group cases_ClientID">
<?php
$wrkonchange = "" . trim(@$cases->ClientID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases->ClientID->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $cases_grid->RowIndex ?>_ClientID" class="text-nowrap" style="z-index: <?php echo (9000 - $cases_grid->RowCnt * 10) ?>">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x<?php echo $cases_grid->RowIndex ?>_ClientID" id="sv_x<?php echo $cases_grid->RowIndex ?>_ClientID" value="<?php echo RemoveHtml($cases->ClientID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases->ClientID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases->ClientID->getPlaceHolder()) ?>"<?php echo $cases->ClientID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases->ClientID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $cases_grid->RowIndex ?>_ClientID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($cases->ClientID->ReadOnly || $cases->ClientID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "clients") && !$cases->ClientID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $cases_grid->RowIndex ?>_ClientID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->ClientID->caption() ?>" data-title="<?php echo $cases->ClientID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $cases_grid->RowIndex ?>_ClientID',url:'clientsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases" data-field="x_ClientID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases->ClientID->displayValueSeparatorAttribute() ?>" name="x<?php echo $cases_grid->RowIndex ?>_ClientID" id="x<?php echo $cases_grid->RowIndex ?>_ClientID" value="<?php echo HtmlEncode($cases->ClientID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcasesgrid.createAutoSuggest({"id":"x<?php echo $cases_grid->RowIndex ?>_ClientID","forceSelect":true});
</script>
<?php echo $cases->ClientID->Lookup->getParamTag("p_x" . $cases_grid->RowIndex . "_ClientID") ?>
</span>
<?php } ?>
<input type="hidden" data-table="cases" data-field="x_ClientID" name="o<?php echo $cases_grid->RowIndex ?>_ClientID" id="o<?php echo $cases_grid->RowIndex ?>_ClientID" value="<?php echo HtmlEncode($cases->ClientID->OldValue) ?>">
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php if ($cases->ClientID->getSessionValue() <> "") { ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_ClientID" class="form-group cases_ClientID">
<span<?php echo $cases->ClientID->viewAttributes() ?>>
<?php if ((!EmptyString($cases->ClientID->ViewValue)) && $cases->ClientID->linkAttributes() <> "") { ?>
<a<?php echo $cases->ClientID->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->ClientID->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->ClientID->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" id="x<?php echo $cases_grid->RowIndex ?>_ClientID" name="x<?php echo $cases_grid->RowIndex ?>_ClientID" value="<?php echo HtmlEncode($cases->ClientID->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_ClientID" class="form-group cases_ClientID">
<?php
$wrkonchange = "" . trim(@$cases->ClientID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases->ClientID->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $cases_grid->RowIndex ?>_ClientID" class="text-nowrap" style="z-index: <?php echo (9000 - $cases_grid->RowCnt * 10) ?>">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x<?php echo $cases_grid->RowIndex ?>_ClientID" id="sv_x<?php echo $cases_grid->RowIndex ?>_ClientID" value="<?php echo RemoveHtml($cases->ClientID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases->ClientID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases->ClientID->getPlaceHolder()) ?>"<?php echo $cases->ClientID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases->ClientID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $cases_grid->RowIndex ?>_ClientID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($cases->ClientID->ReadOnly || $cases->ClientID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "clients") && !$cases->ClientID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $cases_grid->RowIndex ?>_ClientID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->ClientID->caption() ?>" data-title="<?php echo $cases->ClientID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $cases_grid->RowIndex ?>_ClientID',url:'clientsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases" data-field="x_ClientID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases->ClientID->displayValueSeparatorAttribute() ?>" name="x<?php echo $cases_grid->RowIndex ?>_ClientID" id="x<?php echo $cases_grid->RowIndex ?>_ClientID" value="<?php echo HtmlEncode($cases->ClientID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcasesgrid.createAutoSuggest({"id":"x<?php echo $cases_grid->RowIndex ?>_ClientID","forceSelect":true});
</script>
<?php echo $cases->ClientID->Lookup->getParamTag("p_x" . $cases_grid->RowIndex . "_ClientID") ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_ClientID" class="cases_ClientID">
<span<?php echo $cases->ClientID->viewAttributes() ?>>
<?php if ((!EmptyString($cases->ClientID->getViewValue())) && $cases->ClientID->linkAttributes() <> "") { ?>
<a<?php echo $cases->ClientID->linkAttributes() ?>><?php echo $cases->ClientID->getViewValue() ?></a>
<?php } else { ?>
<?php echo $cases->ClientID->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if (!$cases->isConfirm()) { ?>
<input type="hidden" data-table="cases" data-field="x_ClientID" name="x<?php echo $cases_grid->RowIndex ?>_ClientID" id="x<?php echo $cases_grid->RowIndex ?>_ClientID" value="<?php echo HtmlEncode($cases->ClientID->FormValue) ?>">
<input type="hidden" data-table="cases" data-field="x_ClientID" name="o<?php echo $cases_grid->RowIndex ?>_ClientID" id="o<?php echo $cases_grid->RowIndex ?>_ClientID" value="<?php echo HtmlEncode($cases->ClientID->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="cases" data-field="x_ClientID" name="fcasesgrid$x<?php echo $cases_grid->RowIndex ?>_ClientID" id="fcasesgrid$x<?php echo $cases_grid->RowIndex ?>_ClientID" value="<?php echo HtmlEncode($cases->ClientID->FormValue) ?>">
<input type="hidden" data-table="cases" data-field="x_ClientID" name="fcasesgrid$o<?php echo $cases_grid->RowIndex ?>_ClientID" id="fcasesgrid$o<?php echo $cases_grid->RowIndex ?>_ClientID" value="<?php echo HtmlEncode($cases->ClientID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php if ($cases->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="cases" data-field="x_CaseID" name="x<?php echo $cases_grid->RowIndex ?>_CaseID" id="x<?php echo $cases_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($cases->CaseID->CurrentValue) ?>">
<input type="hidden" data-table="cases" data-field="x_CaseID" name="o<?php echo $cases_grid->RowIndex ?>_CaseID" id="o<?php echo $cases_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($cases->CaseID->OldValue) ?>">
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_EDIT || $cases->CurrentMode == "edit") { ?>
<input type="hidden" data-table="cases" data-field="x_CaseID" name="x<?php echo $cases_grid->RowIndex ?>_CaseID" id="x<?php echo $cases_grid->RowIndex ?>_CaseID" value="<?php echo HtmlEncode($cases->CaseID->CurrentValue) ?>">
<?php } ?>
	<?php if ($cases->LitigantID->Visible) { // LitigantID ?>
		<td data-name="LitigantID"<?php echo $cases->LitigantID->cellAttributes() ?>>
<?php if ($cases->RowType == ROWTYPE_ADD) { // Add record ?>
<?php if ($cases->LitigantID->getSessionValue() <> "") { ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_LitigantID" class="form-group cases_LitigantID">
<span<?php echo $cases->LitigantID->viewAttributes() ?>>
<?php if ((!EmptyString($cases->LitigantID->ViewValue)) && $cases->LitigantID->linkAttributes() <> "") { ?>
<a<?php echo $cases->LitigantID->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->LitigantID->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->LitigantID->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" id="x<?php echo $cases_grid->RowIndex ?>_LitigantID" name="x<?php echo $cases_grid->RowIndex ?>_LitigantID" value="<?php echo HtmlEncode($cases->LitigantID->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_LitigantID" class="form-group cases_LitigantID">
<?php
$wrkonchange = "" . trim(@$cases->LitigantID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases->LitigantID->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $cases_grid->RowIndex ?>_LitigantID" class="text-nowrap" style="z-index: <?php echo (9000 - $cases_grid->RowCnt * 10) ?>">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x<?php echo $cases_grid->RowIndex ?>_LitigantID" id="sv_x<?php echo $cases_grid->RowIndex ?>_LitigantID" value="<?php echo RemoveHtml($cases->LitigantID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases->LitigantID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases->LitigantID->getPlaceHolder()) ?>"<?php echo $cases->LitigantID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases->LitigantID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $cases_grid->RowIndex ?>_LitigantID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($cases->LitigantID->ReadOnly || $cases->LitigantID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "litigants") && !$cases->LitigantID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $cases_grid->RowIndex ?>_LitigantID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->LitigantID->caption() ?>" data-title="<?php echo $cases->LitigantID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $cases_grid->RowIndex ?>_LitigantID',url:'litigantsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases" data-field="x_LitigantID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases->LitigantID->displayValueSeparatorAttribute() ?>" name="x<?php echo $cases_grid->RowIndex ?>_LitigantID" id="x<?php echo $cases_grid->RowIndex ?>_LitigantID" value="<?php echo HtmlEncode($cases->LitigantID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcasesgrid.createAutoSuggest({"id":"x<?php echo $cases_grid->RowIndex ?>_LitigantID","forceSelect":true});
</script>
<?php echo $cases->LitigantID->Lookup->getParamTag("p_x" . $cases_grid->RowIndex . "_LitigantID") ?>
</span>
<?php } ?>
<input type="hidden" data-table="cases" data-field="x_LitigantID" name="o<?php echo $cases_grid->RowIndex ?>_LitigantID" id="o<?php echo $cases_grid->RowIndex ?>_LitigantID" value="<?php echo HtmlEncode($cases->LitigantID->OldValue) ?>">
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php if ($cases->LitigantID->getSessionValue() <> "") { ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_LitigantID" class="form-group cases_LitigantID">
<span<?php echo $cases->LitigantID->viewAttributes() ?>>
<?php if ((!EmptyString($cases->LitigantID->ViewValue)) && $cases->LitigantID->linkAttributes() <> "") { ?>
<a<?php echo $cases->LitigantID->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->LitigantID->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->LitigantID->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" id="x<?php echo $cases_grid->RowIndex ?>_LitigantID" name="x<?php echo $cases_grid->RowIndex ?>_LitigantID" value="<?php echo HtmlEncode($cases->LitigantID->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_LitigantID" class="form-group cases_LitigantID">
<?php
$wrkonchange = "" . trim(@$cases->LitigantID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases->LitigantID->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $cases_grid->RowIndex ?>_LitigantID" class="text-nowrap" style="z-index: <?php echo (9000 - $cases_grid->RowCnt * 10) ?>">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x<?php echo $cases_grid->RowIndex ?>_LitigantID" id="sv_x<?php echo $cases_grid->RowIndex ?>_LitigantID" value="<?php echo RemoveHtml($cases->LitigantID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases->LitigantID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases->LitigantID->getPlaceHolder()) ?>"<?php echo $cases->LitigantID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases->LitigantID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $cases_grid->RowIndex ?>_LitigantID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($cases->LitigantID->ReadOnly || $cases->LitigantID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "litigants") && !$cases->LitigantID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $cases_grid->RowIndex ?>_LitigantID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->LitigantID->caption() ?>" data-title="<?php echo $cases->LitigantID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $cases_grid->RowIndex ?>_LitigantID',url:'litigantsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases" data-field="x_LitigantID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases->LitigantID->displayValueSeparatorAttribute() ?>" name="x<?php echo $cases_grid->RowIndex ?>_LitigantID" id="x<?php echo $cases_grid->RowIndex ?>_LitigantID" value="<?php echo HtmlEncode($cases->LitigantID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcasesgrid.createAutoSuggest({"id":"x<?php echo $cases_grid->RowIndex ?>_LitigantID","forceSelect":true});
</script>
<?php echo $cases->LitigantID->Lookup->getParamTag("p_x" . $cases_grid->RowIndex . "_LitigantID") ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_LitigantID" class="cases_LitigantID">
<span<?php echo $cases->LitigantID->viewAttributes() ?>>
<?php if ((!EmptyString($cases->LitigantID->getViewValue())) && $cases->LitigantID->linkAttributes() <> "") { ?>
<a<?php echo $cases->LitigantID->linkAttributes() ?>><?php echo $cases->LitigantID->getViewValue() ?></a>
<?php } else { ?>
<?php echo $cases->LitigantID->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if (!$cases->isConfirm()) { ?>
<input type="hidden" data-table="cases" data-field="x_LitigantID" name="x<?php echo $cases_grid->RowIndex ?>_LitigantID" id="x<?php echo $cases_grid->RowIndex ?>_LitigantID" value="<?php echo HtmlEncode($cases->LitigantID->FormValue) ?>">
<input type="hidden" data-table="cases" data-field="x_LitigantID" name="o<?php echo $cases_grid->RowIndex ?>_LitigantID" id="o<?php echo $cases_grid->RowIndex ?>_LitigantID" value="<?php echo HtmlEncode($cases->LitigantID->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="cases" data-field="x_LitigantID" name="fcasesgrid$x<?php echo $cases_grid->RowIndex ?>_LitigantID" id="fcasesgrid$x<?php echo $cases_grid->RowIndex ?>_LitigantID" value="<?php echo HtmlEncode($cases->LitigantID->FormValue) ?>">
<input type="hidden" data-table="cases" data-field="x_LitigantID" name="fcasesgrid$o<?php echo $cases_grid->RowIndex ?>_LitigantID" id="fcasesgrid$o<?php echo $cases_grid->RowIndex ?>_LitigantID" value="<?php echo HtmlEncode($cases->LitigantID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($cases->CaseTypeID->Visible) { // CaseTypeID ?>
		<td data-name="CaseTypeID"<?php echo $cases->CaseTypeID->cellAttributes() ?>>
<?php if ($cases->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_CaseTypeID" class="form-group cases_CaseTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases" data-field="x_CaseTypeID" data-value-separator="<?php echo $cases->CaseTypeID->displayValueSeparatorAttribute() ?>" id="x<?php echo $cases_grid->RowIndex ?>_CaseTypeID" name="x<?php echo $cases_grid->RowIndex ?>_CaseTypeID"<?php echo $cases->CaseTypeID->editAttributes() ?>>
		<?php echo $cases->CaseTypeID->selectOptionListHtml("x<?php echo $cases_grid->RowIndex ?>_CaseTypeID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "casetypes") && !$cases->CaseTypeID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $cases_grid->RowIndex ?>_CaseTypeID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->CaseTypeID->caption() ?>" data-title="<?php echo $cases->CaseTypeID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $cases_grid->RowIndex ?>_CaseTypeID',url:'casetypesaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases->CaseTypeID->Lookup->getParamTag("p_x" . $cases_grid->RowIndex . "_CaseTypeID") ?>
</span>
<input type="hidden" data-table="cases" data-field="x_CaseTypeID" name="o<?php echo $cases_grid->RowIndex ?>_CaseTypeID" id="o<?php echo $cases_grid->RowIndex ?>_CaseTypeID" value="<?php echo HtmlEncode($cases->CaseTypeID->OldValue) ?>">
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_CaseTypeID" class="form-group cases_CaseTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases" data-field="x_CaseTypeID" data-value-separator="<?php echo $cases->CaseTypeID->displayValueSeparatorAttribute() ?>" id="x<?php echo $cases_grid->RowIndex ?>_CaseTypeID" name="x<?php echo $cases_grid->RowIndex ?>_CaseTypeID"<?php echo $cases->CaseTypeID->editAttributes() ?>>
		<?php echo $cases->CaseTypeID->selectOptionListHtml("x<?php echo $cases_grid->RowIndex ?>_CaseTypeID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "casetypes") && !$cases->CaseTypeID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $cases_grid->RowIndex ?>_CaseTypeID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->CaseTypeID->caption() ?>" data-title="<?php echo $cases->CaseTypeID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $cases_grid->RowIndex ?>_CaseTypeID',url:'casetypesaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases->CaseTypeID->Lookup->getParamTag("p_x" . $cases_grid->RowIndex . "_CaseTypeID") ?>
</span>
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_CaseTypeID" class="cases_CaseTypeID">
<span<?php echo $cases->CaseTypeID->viewAttributes() ?>>
<?php echo $cases->CaseTypeID->getViewValue() ?></span>
</span>
<?php if (!$cases->isConfirm()) { ?>
<input type="hidden" data-table="cases" data-field="x_CaseTypeID" name="x<?php echo $cases_grid->RowIndex ?>_CaseTypeID" id="x<?php echo $cases_grid->RowIndex ?>_CaseTypeID" value="<?php echo HtmlEncode($cases->CaseTypeID->FormValue) ?>">
<input type="hidden" data-table="cases" data-field="x_CaseTypeID" name="o<?php echo $cases_grid->RowIndex ?>_CaseTypeID" id="o<?php echo $cases_grid->RowIndex ?>_CaseTypeID" value="<?php echo HtmlEncode($cases->CaseTypeID->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="cases" data-field="x_CaseTypeID" name="fcasesgrid$x<?php echo $cases_grid->RowIndex ?>_CaseTypeID" id="fcasesgrid$x<?php echo $cases_grid->RowIndex ?>_CaseTypeID" value="<?php echo HtmlEncode($cases->CaseTypeID->FormValue) ?>">
<input type="hidden" data-table="cases" data-field="x_CaseTypeID" name="fcasesgrid$o<?php echo $cases_grid->RowIndex ?>_CaseTypeID" id="fcasesgrid$o<?php echo $cases_grid->RowIndex ?>_CaseTypeID" value="<?php echo HtmlEncode($cases->CaseTypeID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($cases->CourtID->Visible) { // CourtID ?>
		<td data-name="CourtID"<?php echo $cases->CourtID->cellAttributes() ?>>
<?php if ($cases->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_CourtID" class="form-group cases_CourtID">
<?php
$wrkonchange = "" . trim(@$cases->CourtID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases->CourtID->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $cases_grid->RowIndex ?>_CourtID" class="text-nowrap" style="z-index: <?php echo (9000 - $cases_grid->RowCnt * 10) ?>">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x<?php echo $cases_grid->RowIndex ?>_CourtID" id="sv_x<?php echo $cases_grid->RowIndex ?>_CourtID" value="<?php echo RemoveHtml($cases->CourtID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases->CourtID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases->CourtID->getPlaceHolder()) ?>"<?php echo $cases->CourtID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases->CourtID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $cases_grid->RowIndex ?>_CourtID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($cases->CourtID->ReadOnly || $cases->CourtID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "courts") && !$cases->CourtID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $cases_grid->RowIndex ?>_CourtID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->CourtID->caption() ?>" data-title="<?php echo $cases->CourtID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $cases_grid->RowIndex ?>_CourtID',url:'courtsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases" data-field="x_CourtID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases->CourtID->displayValueSeparatorAttribute() ?>" name="x<?php echo $cases_grid->RowIndex ?>_CourtID" id="x<?php echo $cases_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($cases->CourtID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcasesgrid.createAutoSuggest({"id":"x<?php echo $cases_grid->RowIndex ?>_CourtID","forceSelect":true});
</script>
<?php echo $cases->CourtID->Lookup->getParamTag("p_x" . $cases_grid->RowIndex . "_CourtID") ?>
</span>
<input type="hidden" data-table="cases" data-field="x_CourtID" name="o<?php echo $cases_grid->RowIndex ?>_CourtID" id="o<?php echo $cases_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($cases->CourtID->OldValue) ?>">
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_CourtID" class="form-group cases_CourtID">
<?php
$wrkonchange = "" . trim(@$cases->CourtID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases->CourtID->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $cases_grid->RowIndex ?>_CourtID" class="text-nowrap" style="z-index: <?php echo (9000 - $cases_grid->RowCnt * 10) ?>">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x<?php echo $cases_grid->RowIndex ?>_CourtID" id="sv_x<?php echo $cases_grid->RowIndex ?>_CourtID" value="<?php echo RemoveHtml($cases->CourtID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases->CourtID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases->CourtID->getPlaceHolder()) ?>"<?php echo $cases->CourtID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases->CourtID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $cases_grid->RowIndex ?>_CourtID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($cases->CourtID->ReadOnly || $cases->CourtID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "courts") && !$cases->CourtID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $cases_grid->RowIndex ?>_CourtID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->CourtID->caption() ?>" data-title="<?php echo $cases->CourtID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $cases_grid->RowIndex ?>_CourtID',url:'courtsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases" data-field="x_CourtID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases->CourtID->displayValueSeparatorAttribute() ?>" name="x<?php echo $cases_grid->RowIndex ?>_CourtID" id="x<?php echo $cases_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($cases->CourtID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcasesgrid.createAutoSuggest({"id":"x<?php echo $cases_grid->RowIndex ?>_CourtID","forceSelect":true});
</script>
<?php echo $cases->CourtID->Lookup->getParamTag("p_x" . $cases_grid->RowIndex . "_CourtID") ?>
</span>
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_CourtID" class="cases_CourtID">
<span<?php echo $cases->CourtID->viewAttributes() ?>>
<?php if ((!EmptyString($cases->CourtID->getViewValue())) && $cases->CourtID->linkAttributes() <> "") { ?>
<a<?php echo $cases->CourtID->linkAttributes() ?>><?php echo $cases->CourtID->getViewValue() ?></a>
<?php } else { ?>
<?php echo $cases->CourtID->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if (!$cases->isConfirm()) { ?>
<input type="hidden" data-table="cases" data-field="x_CourtID" name="x<?php echo $cases_grid->RowIndex ?>_CourtID" id="x<?php echo $cases_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($cases->CourtID->FormValue) ?>">
<input type="hidden" data-table="cases" data-field="x_CourtID" name="o<?php echo $cases_grid->RowIndex ?>_CourtID" id="o<?php echo $cases_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($cases->CourtID->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="cases" data-field="x_CourtID" name="fcasesgrid$x<?php echo $cases_grid->RowIndex ?>_CourtID" id="fcasesgrid$x<?php echo $cases_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($cases->CourtID->FormValue) ?>">
<input type="hidden" data-table="cases" data-field="x_CourtID" name="fcasesgrid$o<?php echo $cases_grid->RowIndex ?>_CourtID" id="fcasesgrid$o<?php echo $cases_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($cases->CourtID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($cases->CaseNumber->Visible) { // CaseNumber ?>
		<td data-name="CaseNumber"<?php echo $cases->CaseNumber->cellAttributes() ?>>
<?php if ($cases->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_CaseNumber" class="form-group cases_CaseNumber">
<input type="text" data-table="cases" data-field="x_CaseNumber" name="x<?php echo $cases_grid->RowIndex ?>_CaseNumber" id="x<?php echo $cases_grid->RowIndex ?>_CaseNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($cases->CaseNumber->getPlaceHolder()) ?>" value="<?php echo $cases->CaseNumber->EditValue ?>"<?php echo $cases->CaseNumber->editAttributes() ?>>
</span>
<input type="hidden" data-table="cases" data-field="x_CaseNumber" name="o<?php echo $cases_grid->RowIndex ?>_CaseNumber" id="o<?php echo $cases_grid->RowIndex ?>_CaseNumber" value="<?php echo HtmlEncode($cases->CaseNumber->OldValue) ?>">
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_CaseNumber" class="form-group cases_CaseNumber">
<input type="text" data-table="cases" data-field="x_CaseNumber" name="x<?php echo $cases_grid->RowIndex ?>_CaseNumber" id="x<?php echo $cases_grid->RowIndex ?>_CaseNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($cases->CaseNumber->getPlaceHolder()) ?>" value="<?php echo $cases->CaseNumber->EditValue ?>"<?php echo $cases->CaseNumber->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_CaseNumber" class="cases_CaseNumber">
<span<?php echo $cases->CaseNumber->viewAttributes() ?>>
<?php echo $cases->CaseNumber->getViewValue() ?></span>
</span>
<?php if (!$cases->isConfirm()) { ?>
<input type="hidden" data-table="cases" data-field="x_CaseNumber" name="x<?php echo $cases_grid->RowIndex ?>_CaseNumber" id="x<?php echo $cases_grid->RowIndex ?>_CaseNumber" value="<?php echo HtmlEncode($cases->CaseNumber->FormValue) ?>">
<input type="hidden" data-table="cases" data-field="x_CaseNumber" name="o<?php echo $cases_grid->RowIndex ?>_CaseNumber" id="o<?php echo $cases_grid->RowIndex ?>_CaseNumber" value="<?php echo HtmlEncode($cases->CaseNumber->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="cases" data-field="x_CaseNumber" name="fcasesgrid$x<?php echo $cases_grid->RowIndex ?>_CaseNumber" id="fcasesgrid$x<?php echo $cases_grid->RowIndex ?>_CaseNumber" value="<?php echo HtmlEncode($cases->CaseNumber->FormValue) ?>">
<input type="hidden" data-table="cases" data-field="x_CaseNumber" name="fcasesgrid$o<?php echo $cases_grid->RowIndex ?>_CaseNumber" id="fcasesgrid$o<?php echo $cases_grid->RowIndex ?>_CaseNumber" value="<?php echo HtmlEncode($cases->CaseNumber->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($cases->FileNumber->Visible) { // FileNumber ?>
		<td data-name="FileNumber"<?php echo $cases->FileNumber->cellAttributes() ?>>
<?php if ($cases->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_FileNumber" class="form-group cases_FileNumber">
<input type="text" data-table="cases" data-field="x_FileNumber" name="x<?php echo $cases_grid->RowIndex ?>_FileNumber" id="x<?php echo $cases_grid->RowIndex ?>_FileNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($cases->FileNumber->getPlaceHolder()) ?>" value="<?php echo $cases->FileNumber->EditValue ?>"<?php echo $cases->FileNumber->editAttributes() ?>>
</span>
<input type="hidden" data-table="cases" data-field="x_FileNumber" name="o<?php echo $cases_grid->RowIndex ?>_FileNumber" id="o<?php echo $cases_grid->RowIndex ?>_FileNumber" value="<?php echo HtmlEncode($cases->FileNumber->OldValue) ?>">
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_FileNumber" class="form-group cases_FileNumber">
<input type="text" data-table="cases" data-field="x_FileNumber" name="x<?php echo $cases_grid->RowIndex ?>_FileNumber" id="x<?php echo $cases_grid->RowIndex ?>_FileNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($cases->FileNumber->getPlaceHolder()) ?>" value="<?php echo $cases->FileNumber->EditValue ?>"<?php echo $cases->FileNumber->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_FileNumber" class="cases_FileNumber">
<span<?php echo $cases->FileNumber->viewAttributes() ?>>
<?php echo $cases->FileNumber->getViewValue() ?></span>
</span>
<?php if (!$cases->isConfirm()) { ?>
<input type="hidden" data-table="cases" data-field="x_FileNumber" name="x<?php echo $cases_grid->RowIndex ?>_FileNumber" id="x<?php echo $cases_grid->RowIndex ?>_FileNumber" value="<?php echo HtmlEncode($cases->FileNumber->FormValue) ?>">
<input type="hidden" data-table="cases" data-field="x_FileNumber" name="o<?php echo $cases_grid->RowIndex ?>_FileNumber" id="o<?php echo $cases_grid->RowIndex ?>_FileNumber" value="<?php echo HtmlEncode($cases->FileNumber->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="cases" data-field="x_FileNumber" name="fcasesgrid$x<?php echo $cases_grid->RowIndex ?>_FileNumber" id="fcasesgrid$x<?php echo $cases_grid->RowIndex ?>_FileNumber" value="<?php echo HtmlEncode($cases->FileNumber->FormValue) ?>">
<input type="hidden" data-table="cases" data-field="x_FileNumber" name="fcasesgrid$o<?php echo $cases_grid->RowIndex ?>_FileNumber" id="fcasesgrid$o<?php echo $cases_grid->RowIndex ?>_FileNumber" value="<?php echo HtmlEncode($cases->FileNumber->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($cases->ClientStatusID->Visible) { // ClientStatusID ?>
		<td data-name="ClientStatusID"<?php echo $cases->ClientStatusID->cellAttributes() ?>>
<?php if ($cases->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_ClientStatusID" class="form-group cases_ClientStatusID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases" data-field="x_ClientStatusID" data-value-separator="<?php echo $cases->ClientStatusID->displayValueSeparatorAttribute() ?>" id="x<?php echo $cases_grid->RowIndex ?>_ClientStatusID" name="x<?php echo $cases_grid->RowIndex ?>_ClientStatusID"<?php echo $cases->ClientStatusID->editAttributes() ?>>
		<?php echo $cases->ClientStatusID->selectOptionListHtml("x<?php echo $cases_grid->RowIndex ?>_ClientStatusID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "partiesstatus") && !$cases->ClientStatusID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $cases_grid->RowIndex ?>_ClientStatusID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->ClientStatusID->caption() ?>" data-title="<?php echo $cases->ClientStatusID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $cases_grid->RowIndex ?>_ClientStatusID',url:'partiesstatusaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases->ClientStatusID->Lookup->getParamTag("p_x" . $cases_grid->RowIndex . "_ClientStatusID") ?>
</span>
<input type="hidden" data-table="cases" data-field="x_ClientStatusID" name="o<?php echo $cases_grid->RowIndex ?>_ClientStatusID" id="o<?php echo $cases_grid->RowIndex ?>_ClientStatusID" value="<?php echo HtmlEncode($cases->ClientStatusID->OldValue) ?>">
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_ClientStatusID" class="form-group cases_ClientStatusID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases" data-field="x_ClientStatusID" data-value-separator="<?php echo $cases->ClientStatusID->displayValueSeparatorAttribute() ?>" id="x<?php echo $cases_grid->RowIndex ?>_ClientStatusID" name="x<?php echo $cases_grid->RowIndex ?>_ClientStatusID"<?php echo $cases->ClientStatusID->editAttributes() ?>>
		<?php echo $cases->ClientStatusID->selectOptionListHtml("x<?php echo $cases_grid->RowIndex ?>_ClientStatusID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "partiesstatus") && !$cases->ClientStatusID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $cases_grid->RowIndex ?>_ClientStatusID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->ClientStatusID->caption() ?>" data-title="<?php echo $cases->ClientStatusID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $cases_grid->RowIndex ?>_ClientStatusID',url:'partiesstatusaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases->ClientStatusID->Lookup->getParamTag("p_x" . $cases_grid->RowIndex . "_ClientStatusID") ?>
</span>
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_ClientStatusID" class="cases_ClientStatusID">
<span<?php echo $cases->ClientStatusID->viewAttributes() ?>>
<?php echo $cases->ClientStatusID->getViewValue() ?></span>
</span>
<?php if (!$cases->isConfirm()) { ?>
<input type="hidden" data-table="cases" data-field="x_ClientStatusID" name="x<?php echo $cases_grid->RowIndex ?>_ClientStatusID" id="x<?php echo $cases_grid->RowIndex ?>_ClientStatusID" value="<?php echo HtmlEncode($cases->ClientStatusID->FormValue) ?>">
<input type="hidden" data-table="cases" data-field="x_ClientStatusID" name="o<?php echo $cases_grid->RowIndex ?>_ClientStatusID" id="o<?php echo $cases_grid->RowIndex ?>_ClientStatusID" value="<?php echo HtmlEncode($cases->ClientStatusID->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="cases" data-field="x_ClientStatusID" name="fcasesgrid$x<?php echo $cases_grid->RowIndex ?>_ClientStatusID" id="fcasesgrid$x<?php echo $cases_grid->RowIndex ?>_ClientStatusID" value="<?php echo HtmlEncode($cases->ClientStatusID->FormValue) ?>">
<input type="hidden" data-table="cases" data-field="x_ClientStatusID" name="fcasesgrid$o<?php echo $cases_grid->RowIndex ?>_ClientStatusID" id="fcasesgrid$o<?php echo $cases_grid->RowIndex ?>_ClientStatusID" value="<?php echo HtmlEncode($cases->ClientStatusID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($cases->LitigantStatusID->Visible) { // LitigantStatusID ?>
		<td data-name="LitigantStatusID"<?php echo $cases->LitigantStatusID->cellAttributes() ?>>
<?php if ($cases->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_LitigantStatusID" class="form-group cases_LitigantStatusID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases" data-field="x_LitigantStatusID" data-value-separator="<?php echo $cases->LitigantStatusID->displayValueSeparatorAttribute() ?>" id="x<?php echo $cases_grid->RowIndex ?>_LitigantStatusID" name="x<?php echo $cases_grid->RowIndex ?>_LitigantStatusID"<?php echo $cases->LitigantStatusID->editAttributes() ?>>
		<?php echo $cases->LitigantStatusID->selectOptionListHtml("x<?php echo $cases_grid->RowIndex ?>_LitigantStatusID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "partiesstatus") && !$cases->LitigantStatusID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $cases_grid->RowIndex ?>_LitigantStatusID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->LitigantStatusID->caption() ?>" data-title="<?php echo $cases->LitigantStatusID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $cases_grid->RowIndex ?>_LitigantStatusID',url:'partiesstatusaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases->LitigantStatusID->Lookup->getParamTag("p_x" . $cases_grid->RowIndex . "_LitigantStatusID") ?>
</span>
<input type="hidden" data-table="cases" data-field="x_LitigantStatusID" name="o<?php echo $cases_grid->RowIndex ?>_LitigantStatusID" id="o<?php echo $cases_grid->RowIndex ?>_LitigantStatusID" value="<?php echo HtmlEncode($cases->LitigantStatusID->OldValue) ?>">
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_LitigantStatusID" class="form-group cases_LitigantStatusID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases" data-field="x_LitigantStatusID" data-value-separator="<?php echo $cases->LitigantStatusID->displayValueSeparatorAttribute() ?>" id="x<?php echo $cases_grid->RowIndex ?>_LitigantStatusID" name="x<?php echo $cases_grid->RowIndex ?>_LitigantStatusID"<?php echo $cases->LitigantStatusID->editAttributes() ?>>
		<?php echo $cases->LitigantStatusID->selectOptionListHtml("x<?php echo $cases_grid->RowIndex ?>_LitigantStatusID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "partiesstatus") && !$cases->LitigantStatusID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $cases_grid->RowIndex ?>_LitigantStatusID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->LitigantStatusID->caption() ?>" data-title="<?php echo $cases->LitigantStatusID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $cases_grid->RowIndex ?>_LitigantStatusID',url:'partiesstatusaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases->LitigantStatusID->Lookup->getParamTag("p_x" . $cases_grid->RowIndex . "_LitigantStatusID") ?>
</span>
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_LitigantStatusID" class="cases_LitigantStatusID">
<span<?php echo $cases->LitigantStatusID->viewAttributes() ?>>
<?php echo $cases->LitigantStatusID->getViewValue() ?></span>
</span>
<?php if (!$cases->isConfirm()) { ?>
<input type="hidden" data-table="cases" data-field="x_LitigantStatusID" name="x<?php echo $cases_grid->RowIndex ?>_LitigantStatusID" id="x<?php echo $cases_grid->RowIndex ?>_LitigantStatusID" value="<?php echo HtmlEncode($cases->LitigantStatusID->FormValue) ?>">
<input type="hidden" data-table="cases" data-field="x_LitigantStatusID" name="o<?php echo $cases_grid->RowIndex ?>_LitigantStatusID" id="o<?php echo $cases_grid->RowIndex ?>_LitigantStatusID" value="<?php echo HtmlEncode($cases->LitigantStatusID->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="cases" data-field="x_LitigantStatusID" name="fcasesgrid$x<?php echo $cases_grid->RowIndex ?>_LitigantStatusID" id="fcasesgrid$x<?php echo $cases_grid->RowIndex ?>_LitigantStatusID" value="<?php echo HtmlEncode($cases->LitigantStatusID->FormValue) ?>">
<input type="hidden" data-table="cases" data-field="x_LitigantStatusID" name="fcasesgrid$o<?php echo $cases_grid->RowIndex ?>_LitigantStatusID" id="fcasesgrid$o<?php echo $cases_grid->RowIndex ?>_LitigantStatusID" value="<?php echo HtmlEncode($cases->LitigantStatusID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($cases->Notes->Visible) { // Notes ?>
		<td data-name="Notes"<?php echo $cases->Notes->cellAttributes() ?>>
<?php if ($cases->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_Notes" class="form-group cases_Notes">
<?php AppendClass($cases->Notes->EditAttrs["class"], "editor"); ?>
<textarea data-table="cases" data-field="x_Notes" name="x<?php echo $cases_grid->RowIndex ?>_Notes" id="x<?php echo $cases_grid->RowIndex ?>_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($cases->Notes->getPlaceHolder()) ?>"<?php echo $cases->Notes->editAttributes() ?>><?php echo $cases->Notes->EditValue ?></textarea>
<script>
ew.createEditor("fcasesgrid", "x<?php echo $cases_grid->RowIndex ?>_Notes", 35, 4, <?php echo ($cases->Notes->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<input type="hidden" data-table="cases" data-field="x_Notes" name="o<?php echo $cases_grid->RowIndex ?>_Notes" id="o<?php echo $cases_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($cases->Notes->OldValue) ?>">
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_Notes" class="form-group cases_Notes">
<?php AppendClass($cases->Notes->EditAttrs["class"], "editor"); ?>
<textarea data-table="cases" data-field="x_Notes" name="x<?php echo $cases_grid->RowIndex ?>_Notes" id="x<?php echo $cases_grid->RowIndex ?>_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($cases->Notes->getPlaceHolder()) ?>"<?php echo $cases->Notes->editAttributes() ?>><?php echo $cases->Notes->EditValue ?></textarea>
<script>
ew.createEditor("fcasesgrid", "x<?php echo $cases_grid->RowIndex ?>_Notes", 35, 4, <?php echo ($cases->Notes->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_Notes" class="cases_Notes">
<span<?php echo $cases->Notes->viewAttributes() ?>>
<?php echo $cases->Notes->getViewValue() ?></span>
</span>
<?php if (!$cases->isConfirm()) { ?>
<input type="hidden" data-table="cases" data-field="x_Notes" name="x<?php echo $cases_grid->RowIndex ?>_Notes" id="x<?php echo $cases_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($cases->Notes->FormValue) ?>">
<input type="hidden" data-table="cases" data-field="x_Notes" name="o<?php echo $cases_grid->RowIndex ?>_Notes" id="o<?php echo $cases_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($cases->Notes->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="cases" data-field="x_Notes" name="fcasesgrid$x<?php echo $cases_grid->RowIndex ?>_Notes" id="fcasesgrid$x<?php echo $cases_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($cases->Notes->FormValue) ?>">
<input type="hidden" data-table="cases" data-field="x_Notes" name="fcasesgrid$o<?php echo $cases_grid->RowIndex ?>_Notes" id="fcasesgrid$o<?php echo $cases_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($cases->Notes->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($cases->ParentCaseID->Visible) { // ParentCaseID ?>
		<td data-name="ParentCaseID"<?php echo $cases->ParentCaseID->cellAttributes() ?>>
<?php if ($cases->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_ParentCaseID" class="form-group cases_ParentCaseID">
<input type="text" data-table="cases" data-field="x_ParentCaseID" name="x<?php echo $cases_grid->RowIndex ?>_ParentCaseID" id="x<?php echo $cases_grid->RowIndex ?>_ParentCaseID" size="30" placeholder="<?php echo HtmlEncode($cases->ParentCaseID->getPlaceHolder()) ?>" value="<?php echo $cases->ParentCaseID->EditValue ?>"<?php echo $cases->ParentCaseID->editAttributes() ?>>
</span>
<input type="hidden" data-table="cases" data-field="x_ParentCaseID" name="o<?php echo $cases_grid->RowIndex ?>_ParentCaseID" id="o<?php echo $cases_grid->RowIndex ?>_ParentCaseID" value="<?php echo HtmlEncode($cases->ParentCaseID->OldValue) ?>">
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_ParentCaseID" class="form-group cases_ParentCaseID">
<input type="text" data-table="cases" data-field="x_ParentCaseID" name="x<?php echo $cases_grid->RowIndex ?>_ParentCaseID" id="x<?php echo $cases_grid->RowIndex ?>_ParentCaseID" size="30" placeholder="<?php echo HtmlEncode($cases->ParentCaseID->getPlaceHolder()) ?>" value="<?php echo $cases->ParentCaseID->EditValue ?>"<?php echo $cases->ParentCaseID->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_ParentCaseID" class="cases_ParentCaseID">
<span<?php echo $cases->ParentCaseID->viewAttributes() ?>>
<?php echo $cases->ParentCaseID->getViewValue() ?></span>
</span>
<?php if (!$cases->isConfirm()) { ?>
<input type="hidden" data-table="cases" data-field="x_ParentCaseID" name="x<?php echo $cases_grid->RowIndex ?>_ParentCaseID" id="x<?php echo $cases_grid->RowIndex ?>_ParentCaseID" value="<?php echo HtmlEncode($cases->ParentCaseID->FormValue) ?>">
<input type="hidden" data-table="cases" data-field="x_ParentCaseID" name="o<?php echo $cases_grid->RowIndex ?>_ParentCaseID" id="o<?php echo $cases_grid->RowIndex ?>_ParentCaseID" value="<?php echo HtmlEncode($cases->ParentCaseID->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="cases" data-field="x_ParentCaseID" name="fcasesgrid$x<?php echo $cases_grid->RowIndex ?>_ParentCaseID" id="fcasesgrid$x<?php echo $cases_grid->RowIndex ?>_ParentCaseID" value="<?php echo HtmlEncode($cases->ParentCaseID->FormValue) ?>">
<input type="hidden" data-table="cases" data-field="x_ParentCaseID" name="fcasesgrid$o<?php echo $cases_grid->RowIndex ?>_ParentCaseID" id="fcasesgrid$o<?php echo $cases_grid->RowIndex ?>_ParentCaseID" value="<?php echo HtmlEncode($cases->ParentCaseID->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($cases->FileNumber2->Visible) { // FileNumber2 ?>
		<td data-name="FileNumber2"<?php echo $cases->FileNumber2->cellAttributes() ?>>
<?php if ($cases->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_FileNumber2" class="form-group cases_FileNumber2">
<input type="text" data-table="cases" data-field="x_FileNumber2" name="x<?php echo $cases_grid->RowIndex ?>_FileNumber2" id="x<?php echo $cases_grid->RowIndex ?>_FileNumber2" size="30" placeholder="<?php echo HtmlEncode($cases->FileNumber2->getPlaceHolder()) ?>" value="<?php echo $cases->FileNumber2->EditValue ?>"<?php echo $cases->FileNumber2->editAttributes() ?>>
</span>
<input type="hidden" data-table="cases" data-field="x_FileNumber2" name="o<?php echo $cases_grid->RowIndex ?>_FileNumber2" id="o<?php echo $cases_grid->RowIndex ?>_FileNumber2" value="<?php echo HtmlEncode($cases->FileNumber2->OldValue) ?>">
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_FileNumber2" class="form-group cases_FileNumber2">
<input type="text" data-table="cases" data-field="x_FileNumber2" name="x<?php echo $cases_grid->RowIndex ?>_FileNumber2" id="x<?php echo $cases_grid->RowIndex ?>_FileNumber2" size="30" placeholder="<?php echo HtmlEncode($cases->FileNumber2->getPlaceHolder()) ?>" value="<?php echo $cases->FileNumber2->EditValue ?>"<?php echo $cases->FileNumber2->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_FileNumber2" class="cases_FileNumber2">
<span<?php echo $cases->FileNumber2->viewAttributes() ?>>
<?php echo $cases->FileNumber2->getViewValue() ?></span>
</span>
<?php if (!$cases->isConfirm()) { ?>
<input type="hidden" data-table="cases" data-field="x_FileNumber2" name="x<?php echo $cases_grid->RowIndex ?>_FileNumber2" id="x<?php echo $cases_grid->RowIndex ?>_FileNumber2" value="<?php echo HtmlEncode($cases->FileNumber2->FormValue) ?>">
<input type="hidden" data-table="cases" data-field="x_FileNumber2" name="o<?php echo $cases_grid->RowIndex ?>_FileNumber2" id="o<?php echo $cases_grid->RowIndex ?>_FileNumber2" value="<?php echo HtmlEncode($cases->FileNumber2->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="cases" data-field="x_FileNumber2" name="fcasesgrid$x<?php echo $cases_grid->RowIndex ?>_FileNumber2" id="fcasesgrid$x<?php echo $cases_grid->RowIndex ?>_FileNumber2" value="<?php echo HtmlEncode($cases->FileNumber2->FormValue) ?>">
<input type="hidden" data-table="cases" data-field="x_FileNumber2" name="fcasesgrid$o<?php echo $cases_grid->RowIndex ?>_FileNumber2" id="fcasesgrid$o<?php echo $cases_grid->RowIndex ?>_FileNumber2" value="<?php echo HtmlEncode($cases->FileNumber2->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($cases->ClientNameConvFiles->Visible) { // ClientNameConvFiles ?>
		<td data-name="ClientNameConvFiles"<?php echo $cases->ClientNameConvFiles->cellAttributes() ?>>
<?php if ($cases->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_ClientNameConvFiles" class="form-group cases_ClientNameConvFiles">
<input type="text" data-table="cases" data-field="x_ClientNameConvFiles" name="x<?php echo $cases_grid->RowIndex ?>_ClientNameConvFiles" id="x<?php echo $cases_grid->RowIndex ?>_ClientNameConvFiles" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($cases->ClientNameConvFiles->getPlaceHolder()) ?>" value="<?php echo $cases->ClientNameConvFiles->EditValue ?>"<?php echo $cases->ClientNameConvFiles->editAttributes() ?>>
</span>
<input type="hidden" data-table="cases" data-field="x_ClientNameConvFiles" name="o<?php echo $cases_grid->RowIndex ?>_ClientNameConvFiles" id="o<?php echo $cases_grid->RowIndex ?>_ClientNameConvFiles" value="<?php echo HtmlEncode($cases->ClientNameConvFiles->OldValue) ?>">
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_ClientNameConvFiles" class="form-group cases_ClientNameConvFiles">
<input type="text" data-table="cases" data-field="x_ClientNameConvFiles" name="x<?php echo $cases_grid->RowIndex ?>_ClientNameConvFiles" id="x<?php echo $cases_grid->RowIndex ?>_ClientNameConvFiles" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($cases->ClientNameConvFiles->getPlaceHolder()) ?>" value="<?php echo $cases->ClientNameConvFiles->EditValue ?>"<?php echo $cases->ClientNameConvFiles->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_ClientNameConvFiles" class="cases_ClientNameConvFiles">
<span<?php echo $cases->ClientNameConvFiles->viewAttributes() ?>>
<?php echo $cases->ClientNameConvFiles->getViewValue() ?></span>
</span>
<?php if (!$cases->isConfirm()) { ?>
<input type="hidden" data-table="cases" data-field="x_ClientNameConvFiles" name="x<?php echo $cases_grid->RowIndex ?>_ClientNameConvFiles" id="x<?php echo $cases_grid->RowIndex ?>_ClientNameConvFiles" value="<?php echo HtmlEncode($cases->ClientNameConvFiles->FormValue) ?>">
<input type="hidden" data-table="cases" data-field="x_ClientNameConvFiles" name="o<?php echo $cases_grid->RowIndex ?>_ClientNameConvFiles" id="o<?php echo $cases_grid->RowIndex ?>_ClientNameConvFiles" value="<?php echo HtmlEncode($cases->ClientNameConvFiles->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="cases" data-field="x_ClientNameConvFiles" name="fcasesgrid$x<?php echo $cases_grid->RowIndex ?>_ClientNameConvFiles" id="fcasesgrid$x<?php echo $cases_grid->RowIndex ?>_ClientNameConvFiles" value="<?php echo HtmlEncode($cases->ClientNameConvFiles->FormValue) ?>">
<input type="hidden" data-table="cases" data-field="x_ClientNameConvFiles" name="fcasesgrid$o<?php echo $cases_grid->RowIndex ?>_ClientNameConvFiles" id="fcasesgrid$o<?php echo $cases_grid->RowIndex ?>_ClientNameConvFiles" value="<?php echo HtmlEncode($cases->ClientNameConvFiles->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($cases->LitigantNameConvFiles->Visible) { // LitigantNameConvFiles ?>
		<td data-name="LitigantNameConvFiles"<?php echo $cases->LitigantNameConvFiles->cellAttributes() ?>>
<?php if ($cases->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_LitigantNameConvFiles" class="form-group cases_LitigantNameConvFiles">
<input type="text" data-table="cases" data-field="x_LitigantNameConvFiles" name="x<?php echo $cases_grid->RowIndex ?>_LitigantNameConvFiles" id="x<?php echo $cases_grid->RowIndex ?>_LitigantNameConvFiles" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($cases->LitigantNameConvFiles->getPlaceHolder()) ?>" value="<?php echo $cases->LitigantNameConvFiles->EditValue ?>"<?php echo $cases->LitigantNameConvFiles->editAttributes() ?>>
</span>
<input type="hidden" data-table="cases" data-field="x_LitigantNameConvFiles" name="o<?php echo $cases_grid->RowIndex ?>_LitigantNameConvFiles" id="o<?php echo $cases_grid->RowIndex ?>_LitigantNameConvFiles" value="<?php echo HtmlEncode($cases->LitigantNameConvFiles->OldValue) ?>">
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_LitigantNameConvFiles" class="form-group cases_LitigantNameConvFiles">
<input type="text" data-table="cases" data-field="x_LitigantNameConvFiles" name="x<?php echo $cases_grid->RowIndex ?>_LitigantNameConvFiles" id="x<?php echo $cases_grid->RowIndex ?>_LitigantNameConvFiles" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($cases->LitigantNameConvFiles->getPlaceHolder()) ?>" value="<?php echo $cases->LitigantNameConvFiles->EditValue ?>"<?php echo $cases->LitigantNameConvFiles->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_LitigantNameConvFiles" class="cases_LitigantNameConvFiles">
<span<?php echo $cases->LitigantNameConvFiles->viewAttributes() ?>>
<?php echo $cases->LitigantNameConvFiles->getViewValue() ?></span>
</span>
<?php if (!$cases->isConfirm()) { ?>
<input type="hidden" data-table="cases" data-field="x_LitigantNameConvFiles" name="x<?php echo $cases_grid->RowIndex ?>_LitigantNameConvFiles" id="x<?php echo $cases_grid->RowIndex ?>_LitigantNameConvFiles" value="<?php echo HtmlEncode($cases->LitigantNameConvFiles->FormValue) ?>">
<input type="hidden" data-table="cases" data-field="x_LitigantNameConvFiles" name="o<?php echo $cases_grid->RowIndex ?>_LitigantNameConvFiles" id="o<?php echo $cases_grid->RowIndex ?>_LitigantNameConvFiles" value="<?php echo HtmlEncode($cases->LitigantNameConvFiles->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="cases" data-field="x_LitigantNameConvFiles" name="fcasesgrid$x<?php echo $cases_grid->RowIndex ?>_LitigantNameConvFiles" id="fcasesgrid$x<?php echo $cases_grid->RowIndex ?>_LitigantNameConvFiles" value="<?php echo HtmlEncode($cases->LitigantNameConvFiles->FormValue) ?>">
<input type="hidden" data-table="cases" data-field="x_LitigantNameConvFiles" name="fcasesgrid$o<?php echo $cases_grid->RowIndex ?>_LitigantNameConvFiles" id="fcasesgrid$o<?php echo $cases_grid->RowIndex ?>_LitigantNameConvFiles" value="<?php echo HtmlEncode($cases->LitigantNameConvFiles->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($cases->CaseTypeConvFiles->Visible) { // CaseTypeConvFiles ?>
		<td data-name="CaseTypeConvFiles"<?php echo $cases->CaseTypeConvFiles->cellAttributes() ?>>
<?php if ($cases->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_CaseTypeConvFiles" class="form-group cases_CaseTypeConvFiles">
<input type="text" data-table="cases" data-field="x_CaseTypeConvFiles" name="x<?php echo $cases_grid->RowIndex ?>_CaseTypeConvFiles" id="x<?php echo $cases_grid->RowIndex ?>_CaseTypeConvFiles" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($cases->CaseTypeConvFiles->getPlaceHolder()) ?>" value="<?php echo $cases->CaseTypeConvFiles->EditValue ?>"<?php echo $cases->CaseTypeConvFiles->editAttributes() ?>>
</span>
<input type="hidden" data-table="cases" data-field="x_CaseTypeConvFiles" name="o<?php echo $cases_grid->RowIndex ?>_CaseTypeConvFiles" id="o<?php echo $cases_grid->RowIndex ?>_CaseTypeConvFiles" value="<?php echo HtmlEncode($cases->CaseTypeConvFiles->OldValue) ?>">
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_CaseTypeConvFiles" class="form-group cases_CaseTypeConvFiles">
<input type="text" data-table="cases" data-field="x_CaseTypeConvFiles" name="x<?php echo $cases_grid->RowIndex ?>_CaseTypeConvFiles" id="x<?php echo $cases_grid->RowIndex ?>_CaseTypeConvFiles" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($cases->CaseTypeConvFiles->getPlaceHolder()) ?>" value="<?php echo $cases->CaseTypeConvFiles->EditValue ?>"<?php echo $cases->CaseTypeConvFiles->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($cases->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $cases_grid->RowCnt ?>_cases_CaseTypeConvFiles" class="cases_CaseTypeConvFiles">
<span<?php echo $cases->CaseTypeConvFiles->viewAttributes() ?>>
<?php echo $cases->CaseTypeConvFiles->getViewValue() ?></span>
</span>
<?php if (!$cases->isConfirm()) { ?>
<input type="hidden" data-table="cases" data-field="x_CaseTypeConvFiles" name="x<?php echo $cases_grid->RowIndex ?>_CaseTypeConvFiles" id="x<?php echo $cases_grid->RowIndex ?>_CaseTypeConvFiles" value="<?php echo HtmlEncode($cases->CaseTypeConvFiles->FormValue) ?>">
<input type="hidden" data-table="cases" data-field="x_CaseTypeConvFiles" name="o<?php echo $cases_grid->RowIndex ?>_CaseTypeConvFiles" id="o<?php echo $cases_grid->RowIndex ?>_CaseTypeConvFiles" value="<?php echo HtmlEncode($cases->CaseTypeConvFiles->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="cases" data-field="x_CaseTypeConvFiles" name="fcasesgrid$x<?php echo $cases_grid->RowIndex ?>_CaseTypeConvFiles" id="fcasesgrid$x<?php echo $cases_grid->RowIndex ?>_CaseTypeConvFiles" value="<?php echo HtmlEncode($cases->CaseTypeConvFiles->FormValue) ?>">
<input type="hidden" data-table="cases" data-field="x_CaseTypeConvFiles" name="fcasesgrid$o<?php echo $cases_grid->RowIndex ?>_CaseTypeConvFiles" id="fcasesgrid$o<?php echo $cases_grid->RowIndex ?>_CaseTypeConvFiles" value="<?php echo HtmlEncode($cases->CaseTypeConvFiles->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$cases_grid->ListOptions->render("body", "right", $cases_grid->RowCnt);
?>
	</tr>
<?php if ($cases->RowType == ROWTYPE_ADD || $cases->RowType == ROWTYPE_EDIT) { ?>
<script>
fcasesgrid.updateLists(<?php echo $cases_grid->RowIndex ?>);
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$cases->isGridAdd() || $cases->CurrentMode == "copy")
		if (!$cases_grid->Recordset->EOF)
			$cases_grid->Recordset->moveNext();
}
?>
<?php
	if ($cases->CurrentMode == "add" || $cases->CurrentMode == "copy" || $cases->CurrentMode == "edit") {
		$cases_grid->RowIndex = '$rowindex$';
		$cases_grid->loadRowValues();

		// Set row properties
		$cases->resetAttributes();
		$cases->RowAttrs = array_merge($cases->RowAttrs, array('data-rowindex'=>$cases_grid->RowIndex, 'id'=>'r0_cases', 'data-rowtype'=>ROWTYPE_ADD));
		AppendClass($cases->RowAttrs["class"], "ew-template");
		$cases->RowType = ROWTYPE_ADD;

		// Render row
		$cases_grid->renderRow();

		// Render list options
		$cases_grid->renderListOptions();
		$cases_grid->StartRowCnt = 0;
?>
	<tr<?php echo $cases->rowAttributes() ?>>
<?php

// Render list options (body, left)
$cases_grid->ListOptions->render("body", "left", $cases_grid->RowIndex);
?>
	<?php if ($cases->ClientID->Visible) { // ClientID ?>
		<td data-name="ClientID">
<?php if (!$cases->isConfirm()) { ?>
<?php if ($cases->ClientID->getSessionValue() <> "") { ?>
<span id="el$rowindex$_cases_ClientID" class="form-group cases_ClientID">
<span<?php echo $cases->ClientID->viewAttributes() ?>>
<?php if ((!EmptyString($cases->ClientID->ViewValue)) && $cases->ClientID->linkAttributes() <> "") { ?>
<a<?php echo $cases->ClientID->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->ClientID->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->ClientID->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" id="x<?php echo $cases_grid->RowIndex ?>_ClientID" name="x<?php echo $cases_grid->RowIndex ?>_ClientID" value="<?php echo HtmlEncode($cases->ClientID->CurrentValue) ?>">
<?php } else { ?>
<span id="el$rowindex$_cases_ClientID" class="form-group cases_ClientID">
<?php
$wrkonchange = "" . trim(@$cases->ClientID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases->ClientID->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $cases_grid->RowIndex ?>_ClientID" class="text-nowrap" style="z-index: <?php echo (9000 - $cases_grid->RowCnt * 10) ?>">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x<?php echo $cases_grid->RowIndex ?>_ClientID" id="sv_x<?php echo $cases_grid->RowIndex ?>_ClientID" value="<?php echo RemoveHtml($cases->ClientID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases->ClientID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases->ClientID->getPlaceHolder()) ?>"<?php echo $cases->ClientID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases->ClientID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $cases_grid->RowIndex ?>_ClientID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($cases->ClientID->ReadOnly || $cases->ClientID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "clients") && !$cases->ClientID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $cases_grid->RowIndex ?>_ClientID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->ClientID->caption() ?>" data-title="<?php echo $cases->ClientID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $cases_grid->RowIndex ?>_ClientID',url:'clientsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases" data-field="x_ClientID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases->ClientID->displayValueSeparatorAttribute() ?>" name="x<?php echo $cases_grid->RowIndex ?>_ClientID" id="x<?php echo $cases_grid->RowIndex ?>_ClientID" value="<?php echo HtmlEncode($cases->ClientID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcasesgrid.createAutoSuggest({"id":"x<?php echo $cases_grid->RowIndex ?>_ClientID","forceSelect":true});
</script>
<?php echo $cases->ClientID->Lookup->getParamTag("p_x" . $cases_grid->RowIndex . "_ClientID") ?>
</span>
<?php } ?>
<?php } else { ?>
<span id="el$rowindex$_cases_ClientID" class="form-group cases_ClientID">
<span<?php echo $cases->ClientID->viewAttributes() ?>>
<?php if ((!EmptyString($cases->ClientID->ViewValue)) && $cases->ClientID->linkAttributes() <> "") { ?>
<a<?php echo $cases->ClientID->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->ClientID->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->ClientID->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="cases" data-field="x_ClientID" name="x<?php echo $cases_grid->RowIndex ?>_ClientID" id="x<?php echo $cases_grid->RowIndex ?>_ClientID" value="<?php echo HtmlEncode($cases->ClientID->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="cases" data-field="x_ClientID" name="o<?php echo $cases_grid->RowIndex ?>_ClientID" id="o<?php echo $cases_grid->RowIndex ?>_ClientID" value="<?php echo HtmlEncode($cases->ClientID->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($cases->LitigantID->Visible) { // LitigantID ?>
		<td data-name="LitigantID">
<?php if (!$cases->isConfirm()) { ?>
<?php if ($cases->LitigantID->getSessionValue() <> "") { ?>
<span id="el$rowindex$_cases_LitigantID" class="form-group cases_LitigantID">
<span<?php echo $cases->LitigantID->viewAttributes() ?>>
<?php if ((!EmptyString($cases->LitigantID->ViewValue)) && $cases->LitigantID->linkAttributes() <> "") { ?>
<a<?php echo $cases->LitigantID->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->LitigantID->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->LitigantID->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" id="x<?php echo $cases_grid->RowIndex ?>_LitigantID" name="x<?php echo $cases_grid->RowIndex ?>_LitigantID" value="<?php echo HtmlEncode($cases->LitigantID->CurrentValue) ?>">
<?php } else { ?>
<span id="el$rowindex$_cases_LitigantID" class="form-group cases_LitigantID">
<?php
$wrkonchange = "" . trim(@$cases->LitigantID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases->LitigantID->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $cases_grid->RowIndex ?>_LitigantID" class="text-nowrap" style="z-index: <?php echo (9000 - $cases_grid->RowCnt * 10) ?>">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x<?php echo $cases_grid->RowIndex ?>_LitigantID" id="sv_x<?php echo $cases_grid->RowIndex ?>_LitigantID" value="<?php echo RemoveHtml($cases->LitigantID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases->LitigantID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases->LitigantID->getPlaceHolder()) ?>"<?php echo $cases->LitigantID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases->LitigantID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $cases_grid->RowIndex ?>_LitigantID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($cases->LitigantID->ReadOnly || $cases->LitigantID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "litigants") && !$cases->LitigantID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $cases_grid->RowIndex ?>_LitigantID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->LitigantID->caption() ?>" data-title="<?php echo $cases->LitigantID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $cases_grid->RowIndex ?>_LitigantID',url:'litigantsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases" data-field="x_LitigantID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases->LitigantID->displayValueSeparatorAttribute() ?>" name="x<?php echo $cases_grid->RowIndex ?>_LitigantID" id="x<?php echo $cases_grid->RowIndex ?>_LitigantID" value="<?php echo HtmlEncode($cases->LitigantID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcasesgrid.createAutoSuggest({"id":"x<?php echo $cases_grid->RowIndex ?>_LitigantID","forceSelect":true});
</script>
<?php echo $cases->LitigantID->Lookup->getParamTag("p_x" . $cases_grid->RowIndex . "_LitigantID") ?>
</span>
<?php } ?>
<?php } else { ?>
<span id="el$rowindex$_cases_LitigantID" class="form-group cases_LitigantID">
<span<?php echo $cases->LitigantID->viewAttributes() ?>>
<?php if ((!EmptyString($cases->LitigantID->ViewValue)) && $cases->LitigantID->linkAttributes() <> "") { ?>
<a<?php echo $cases->LitigantID->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->LitigantID->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->LitigantID->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="cases" data-field="x_LitigantID" name="x<?php echo $cases_grid->RowIndex ?>_LitigantID" id="x<?php echo $cases_grid->RowIndex ?>_LitigantID" value="<?php echo HtmlEncode($cases->LitigantID->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="cases" data-field="x_LitigantID" name="o<?php echo $cases_grid->RowIndex ?>_LitigantID" id="o<?php echo $cases_grid->RowIndex ?>_LitigantID" value="<?php echo HtmlEncode($cases->LitigantID->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($cases->CaseTypeID->Visible) { // CaseTypeID ?>
		<td data-name="CaseTypeID">
<?php if (!$cases->isConfirm()) { ?>
<span id="el$rowindex$_cases_CaseTypeID" class="form-group cases_CaseTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases" data-field="x_CaseTypeID" data-value-separator="<?php echo $cases->CaseTypeID->displayValueSeparatorAttribute() ?>" id="x<?php echo $cases_grid->RowIndex ?>_CaseTypeID" name="x<?php echo $cases_grid->RowIndex ?>_CaseTypeID"<?php echo $cases->CaseTypeID->editAttributes() ?>>
		<?php echo $cases->CaseTypeID->selectOptionListHtml("x<?php echo $cases_grid->RowIndex ?>_CaseTypeID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "casetypes") && !$cases->CaseTypeID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $cases_grid->RowIndex ?>_CaseTypeID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->CaseTypeID->caption() ?>" data-title="<?php echo $cases->CaseTypeID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $cases_grid->RowIndex ?>_CaseTypeID',url:'casetypesaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases->CaseTypeID->Lookup->getParamTag("p_x" . $cases_grid->RowIndex . "_CaseTypeID") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_cases_CaseTypeID" class="form-group cases_CaseTypeID">
<span<?php echo $cases->CaseTypeID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->CaseTypeID->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="cases" data-field="x_CaseTypeID" name="x<?php echo $cases_grid->RowIndex ?>_CaseTypeID" id="x<?php echo $cases_grid->RowIndex ?>_CaseTypeID" value="<?php echo HtmlEncode($cases->CaseTypeID->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="cases" data-field="x_CaseTypeID" name="o<?php echo $cases_grid->RowIndex ?>_CaseTypeID" id="o<?php echo $cases_grid->RowIndex ?>_CaseTypeID" value="<?php echo HtmlEncode($cases->CaseTypeID->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($cases->CourtID->Visible) { // CourtID ?>
		<td data-name="CourtID">
<?php if (!$cases->isConfirm()) { ?>
<span id="el$rowindex$_cases_CourtID" class="form-group cases_CourtID">
<?php
$wrkonchange = "" . trim(@$cases->CourtID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases->CourtID->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $cases_grid->RowIndex ?>_CourtID" class="text-nowrap" style="z-index: <?php echo (9000 - $cases_grid->RowCnt * 10) ?>">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x<?php echo $cases_grid->RowIndex ?>_CourtID" id="sv_x<?php echo $cases_grid->RowIndex ?>_CourtID" value="<?php echo RemoveHtml($cases->CourtID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases->CourtID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases->CourtID->getPlaceHolder()) ?>"<?php echo $cases->CourtID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases->CourtID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $cases_grid->RowIndex ?>_CourtID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($cases->CourtID->ReadOnly || $cases->CourtID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "courts") && !$cases->CourtID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $cases_grid->RowIndex ?>_CourtID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->CourtID->caption() ?>" data-title="<?php echo $cases->CourtID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $cases_grid->RowIndex ?>_CourtID',url:'courtsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases" data-field="x_CourtID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases->CourtID->displayValueSeparatorAttribute() ?>" name="x<?php echo $cases_grid->RowIndex ?>_CourtID" id="x<?php echo $cases_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($cases->CourtID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcasesgrid.createAutoSuggest({"id":"x<?php echo $cases_grid->RowIndex ?>_CourtID","forceSelect":true});
</script>
<?php echo $cases->CourtID->Lookup->getParamTag("p_x" . $cases_grid->RowIndex . "_CourtID") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_cases_CourtID" class="form-group cases_CourtID">
<span<?php echo $cases->CourtID->viewAttributes() ?>>
<?php if ((!EmptyString($cases->CourtID->ViewValue)) && $cases->CourtID->linkAttributes() <> "") { ?>
<a<?php echo $cases->CourtID->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->CourtID->ViewValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->CourtID->ViewValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="cases" data-field="x_CourtID" name="x<?php echo $cases_grid->RowIndex ?>_CourtID" id="x<?php echo $cases_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($cases->CourtID->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="cases" data-field="x_CourtID" name="o<?php echo $cases_grid->RowIndex ?>_CourtID" id="o<?php echo $cases_grid->RowIndex ?>_CourtID" value="<?php echo HtmlEncode($cases->CourtID->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($cases->CaseNumber->Visible) { // CaseNumber ?>
		<td data-name="CaseNumber">
<?php if (!$cases->isConfirm()) { ?>
<span id="el$rowindex$_cases_CaseNumber" class="form-group cases_CaseNumber">
<input type="text" data-table="cases" data-field="x_CaseNumber" name="x<?php echo $cases_grid->RowIndex ?>_CaseNumber" id="x<?php echo $cases_grid->RowIndex ?>_CaseNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($cases->CaseNumber->getPlaceHolder()) ?>" value="<?php echo $cases->CaseNumber->EditValue ?>"<?php echo $cases->CaseNumber->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_cases_CaseNumber" class="form-group cases_CaseNumber">
<span<?php echo $cases->CaseNumber->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->CaseNumber->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="cases" data-field="x_CaseNumber" name="x<?php echo $cases_grid->RowIndex ?>_CaseNumber" id="x<?php echo $cases_grid->RowIndex ?>_CaseNumber" value="<?php echo HtmlEncode($cases->CaseNumber->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="cases" data-field="x_CaseNumber" name="o<?php echo $cases_grid->RowIndex ?>_CaseNumber" id="o<?php echo $cases_grid->RowIndex ?>_CaseNumber" value="<?php echo HtmlEncode($cases->CaseNumber->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($cases->FileNumber->Visible) { // FileNumber ?>
		<td data-name="FileNumber">
<?php if (!$cases->isConfirm()) { ?>
<span id="el$rowindex$_cases_FileNumber" class="form-group cases_FileNumber">
<input type="text" data-table="cases" data-field="x_FileNumber" name="x<?php echo $cases_grid->RowIndex ?>_FileNumber" id="x<?php echo $cases_grid->RowIndex ?>_FileNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($cases->FileNumber->getPlaceHolder()) ?>" value="<?php echo $cases->FileNumber->EditValue ?>"<?php echo $cases->FileNumber->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_cases_FileNumber" class="form-group cases_FileNumber">
<span<?php echo $cases->FileNumber->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->FileNumber->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="cases" data-field="x_FileNumber" name="x<?php echo $cases_grid->RowIndex ?>_FileNumber" id="x<?php echo $cases_grid->RowIndex ?>_FileNumber" value="<?php echo HtmlEncode($cases->FileNumber->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="cases" data-field="x_FileNumber" name="o<?php echo $cases_grid->RowIndex ?>_FileNumber" id="o<?php echo $cases_grid->RowIndex ?>_FileNumber" value="<?php echo HtmlEncode($cases->FileNumber->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($cases->ClientStatusID->Visible) { // ClientStatusID ?>
		<td data-name="ClientStatusID">
<?php if (!$cases->isConfirm()) { ?>
<span id="el$rowindex$_cases_ClientStatusID" class="form-group cases_ClientStatusID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases" data-field="x_ClientStatusID" data-value-separator="<?php echo $cases->ClientStatusID->displayValueSeparatorAttribute() ?>" id="x<?php echo $cases_grid->RowIndex ?>_ClientStatusID" name="x<?php echo $cases_grid->RowIndex ?>_ClientStatusID"<?php echo $cases->ClientStatusID->editAttributes() ?>>
		<?php echo $cases->ClientStatusID->selectOptionListHtml("x<?php echo $cases_grid->RowIndex ?>_ClientStatusID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "partiesstatus") && !$cases->ClientStatusID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $cases_grid->RowIndex ?>_ClientStatusID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->ClientStatusID->caption() ?>" data-title="<?php echo $cases->ClientStatusID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $cases_grid->RowIndex ?>_ClientStatusID',url:'partiesstatusaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases->ClientStatusID->Lookup->getParamTag("p_x" . $cases_grid->RowIndex . "_ClientStatusID") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_cases_ClientStatusID" class="form-group cases_ClientStatusID">
<span<?php echo $cases->ClientStatusID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->ClientStatusID->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="cases" data-field="x_ClientStatusID" name="x<?php echo $cases_grid->RowIndex ?>_ClientStatusID" id="x<?php echo $cases_grid->RowIndex ?>_ClientStatusID" value="<?php echo HtmlEncode($cases->ClientStatusID->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="cases" data-field="x_ClientStatusID" name="o<?php echo $cases_grid->RowIndex ?>_ClientStatusID" id="o<?php echo $cases_grid->RowIndex ?>_ClientStatusID" value="<?php echo HtmlEncode($cases->ClientStatusID->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($cases->LitigantStatusID->Visible) { // LitigantStatusID ?>
		<td data-name="LitigantStatusID">
<?php if (!$cases->isConfirm()) { ?>
<span id="el$rowindex$_cases_LitigantStatusID" class="form-group cases_LitigantStatusID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases" data-field="x_LitigantStatusID" data-value-separator="<?php echo $cases->LitigantStatusID->displayValueSeparatorAttribute() ?>" id="x<?php echo $cases_grid->RowIndex ?>_LitigantStatusID" name="x<?php echo $cases_grid->RowIndex ?>_LitigantStatusID"<?php echo $cases->LitigantStatusID->editAttributes() ?>>
		<?php echo $cases->LitigantStatusID->selectOptionListHtml("x<?php echo $cases_grid->RowIndex ?>_LitigantStatusID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "partiesstatus") && !$cases->LitigantStatusID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?php echo $cases_grid->RowIndex ?>_LitigantStatusID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases->LitigantStatusID->caption() ?>" data-title="<?php echo $cases->LitigantStatusID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x<?php echo $cases_grid->RowIndex ?>_LitigantStatusID',url:'partiesstatusaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases->LitigantStatusID->Lookup->getParamTag("p_x" . $cases_grid->RowIndex . "_LitigantStatusID") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_cases_LitigantStatusID" class="form-group cases_LitigantStatusID">
<span<?php echo $cases->LitigantStatusID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->LitigantStatusID->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="cases" data-field="x_LitigantStatusID" name="x<?php echo $cases_grid->RowIndex ?>_LitigantStatusID" id="x<?php echo $cases_grid->RowIndex ?>_LitigantStatusID" value="<?php echo HtmlEncode($cases->LitigantStatusID->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="cases" data-field="x_LitigantStatusID" name="o<?php echo $cases_grid->RowIndex ?>_LitigantStatusID" id="o<?php echo $cases_grid->RowIndex ?>_LitigantStatusID" value="<?php echo HtmlEncode($cases->LitigantStatusID->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($cases->Notes->Visible) { // Notes ?>
		<td data-name="Notes">
<?php if (!$cases->isConfirm()) { ?>
<span id="el$rowindex$_cases_Notes" class="form-group cases_Notes">
<?php AppendClass($cases->Notes->EditAttrs["class"], "editor"); ?>
<textarea data-table="cases" data-field="x_Notes" name="x<?php echo $cases_grid->RowIndex ?>_Notes" id="x<?php echo $cases_grid->RowIndex ?>_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($cases->Notes->getPlaceHolder()) ?>"<?php echo $cases->Notes->editAttributes() ?>><?php echo $cases->Notes->EditValue ?></textarea>
<script>
ew.createEditor("fcasesgrid", "x<?php echo $cases_grid->RowIndex ?>_Notes", 35, 4, <?php echo ($cases->Notes->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php } else { ?>
<span id="el$rowindex$_cases_Notes" class="form-group cases_Notes">
<span<?php echo $cases->Notes->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->Notes->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="cases" data-field="x_Notes" name="x<?php echo $cases_grid->RowIndex ?>_Notes" id="x<?php echo $cases_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($cases->Notes->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="cases" data-field="x_Notes" name="o<?php echo $cases_grid->RowIndex ?>_Notes" id="o<?php echo $cases_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($cases->Notes->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($cases->ParentCaseID->Visible) { // ParentCaseID ?>
		<td data-name="ParentCaseID">
<?php if (!$cases->isConfirm()) { ?>
<span id="el$rowindex$_cases_ParentCaseID" class="form-group cases_ParentCaseID">
<input type="text" data-table="cases" data-field="x_ParentCaseID" name="x<?php echo $cases_grid->RowIndex ?>_ParentCaseID" id="x<?php echo $cases_grid->RowIndex ?>_ParentCaseID" size="30" placeholder="<?php echo HtmlEncode($cases->ParentCaseID->getPlaceHolder()) ?>" value="<?php echo $cases->ParentCaseID->EditValue ?>"<?php echo $cases->ParentCaseID->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_cases_ParentCaseID" class="form-group cases_ParentCaseID">
<span<?php echo $cases->ParentCaseID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->ParentCaseID->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="cases" data-field="x_ParentCaseID" name="x<?php echo $cases_grid->RowIndex ?>_ParentCaseID" id="x<?php echo $cases_grid->RowIndex ?>_ParentCaseID" value="<?php echo HtmlEncode($cases->ParentCaseID->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="cases" data-field="x_ParentCaseID" name="o<?php echo $cases_grid->RowIndex ?>_ParentCaseID" id="o<?php echo $cases_grid->RowIndex ?>_ParentCaseID" value="<?php echo HtmlEncode($cases->ParentCaseID->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($cases->FileNumber2->Visible) { // FileNumber2 ?>
		<td data-name="FileNumber2">
<?php if (!$cases->isConfirm()) { ?>
<span id="el$rowindex$_cases_FileNumber2" class="form-group cases_FileNumber2">
<input type="text" data-table="cases" data-field="x_FileNumber2" name="x<?php echo $cases_grid->RowIndex ?>_FileNumber2" id="x<?php echo $cases_grid->RowIndex ?>_FileNumber2" size="30" placeholder="<?php echo HtmlEncode($cases->FileNumber2->getPlaceHolder()) ?>" value="<?php echo $cases->FileNumber2->EditValue ?>"<?php echo $cases->FileNumber2->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_cases_FileNumber2" class="form-group cases_FileNumber2">
<span<?php echo $cases->FileNumber2->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->FileNumber2->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="cases" data-field="x_FileNumber2" name="x<?php echo $cases_grid->RowIndex ?>_FileNumber2" id="x<?php echo $cases_grid->RowIndex ?>_FileNumber2" value="<?php echo HtmlEncode($cases->FileNumber2->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="cases" data-field="x_FileNumber2" name="o<?php echo $cases_grid->RowIndex ?>_FileNumber2" id="o<?php echo $cases_grid->RowIndex ?>_FileNumber2" value="<?php echo HtmlEncode($cases->FileNumber2->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($cases->ClientNameConvFiles->Visible) { // ClientNameConvFiles ?>
		<td data-name="ClientNameConvFiles">
<?php if (!$cases->isConfirm()) { ?>
<span id="el$rowindex$_cases_ClientNameConvFiles" class="form-group cases_ClientNameConvFiles">
<input type="text" data-table="cases" data-field="x_ClientNameConvFiles" name="x<?php echo $cases_grid->RowIndex ?>_ClientNameConvFiles" id="x<?php echo $cases_grid->RowIndex ?>_ClientNameConvFiles" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($cases->ClientNameConvFiles->getPlaceHolder()) ?>" value="<?php echo $cases->ClientNameConvFiles->EditValue ?>"<?php echo $cases->ClientNameConvFiles->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_cases_ClientNameConvFiles" class="form-group cases_ClientNameConvFiles">
<span<?php echo $cases->ClientNameConvFiles->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->ClientNameConvFiles->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="cases" data-field="x_ClientNameConvFiles" name="x<?php echo $cases_grid->RowIndex ?>_ClientNameConvFiles" id="x<?php echo $cases_grid->RowIndex ?>_ClientNameConvFiles" value="<?php echo HtmlEncode($cases->ClientNameConvFiles->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="cases" data-field="x_ClientNameConvFiles" name="o<?php echo $cases_grid->RowIndex ?>_ClientNameConvFiles" id="o<?php echo $cases_grid->RowIndex ?>_ClientNameConvFiles" value="<?php echo HtmlEncode($cases->ClientNameConvFiles->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($cases->LitigantNameConvFiles->Visible) { // LitigantNameConvFiles ?>
		<td data-name="LitigantNameConvFiles">
<?php if (!$cases->isConfirm()) { ?>
<span id="el$rowindex$_cases_LitigantNameConvFiles" class="form-group cases_LitigantNameConvFiles">
<input type="text" data-table="cases" data-field="x_LitigantNameConvFiles" name="x<?php echo $cases_grid->RowIndex ?>_LitigantNameConvFiles" id="x<?php echo $cases_grid->RowIndex ?>_LitigantNameConvFiles" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($cases->LitigantNameConvFiles->getPlaceHolder()) ?>" value="<?php echo $cases->LitigantNameConvFiles->EditValue ?>"<?php echo $cases->LitigantNameConvFiles->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_cases_LitigantNameConvFiles" class="form-group cases_LitigantNameConvFiles">
<span<?php echo $cases->LitigantNameConvFiles->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->LitigantNameConvFiles->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="cases" data-field="x_LitigantNameConvFiles" name="x<?php echo $cases_grid->RowIndex ?>_LitigantNameConvFiles" id="x<?php echo $cases_grid->RowIndex ?>_LitigantNameConvFiles" value="<?php echo HtmlEncode($cases->LitigantNameConvFiles->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="cases" data-field="x_LitigantNameConvFiles" name="o<?php echo $cases_grid->RowIndex ?>_LitigantNameConvFiles" id="o<?php echo $cases_grid->RowIndex ?>_LitigantNameConvFiles" value="<?php echo HtmlEncode($cases->LitigantNameConvFiles->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($cases->CaseTypeConvFiles->Visible) { // CaseTypeConvFiles ?>
		<td data-name="CaseTypeConvFiles">
<?php if (!$cases->isConfirm()) { ?>
<span id="el$rowindex$_cases_CaseTypeConvFiles" class="form-group cases_CaseTypeConvFiles">
<input type="text" data-table="cases" data-field="x_CaseTypeConvFiles" name="x<?php echo $cases_grid->RowIndex ?>_CaseTypeConvFiles" id="x<?php echo $cases_grid->RowIndex ?>_CaseTypeConvFiles" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($cases->CaseTypeConvFiles->getPlaceHolder()) ?>" value="<?php echo $cases->CaseTypeConvFiles->EditValue ?>"<?php echo $cases->CaseTypeConvFiles->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_cases_CaseTypeConvFiles" class="form-group cases_CaseTypeConvFiles">
<span<?php echo $cases->CaseTypeConvFiles->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($cases->CaseTypeConvFiles->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="cases" data-field="x_CaseTypeConvFiles" name="x<?php echo $cases_grid->RowIndex ?>_CaseTypeConvFiles" id="x<?php echo $cases_grid->RowIndex ?>_CaseTypeConvFiles" value="<?php echo HtmlEncode($cases->CaseTypeConvFiles->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="cases" data-field="x_CaseTypeConvFiles" name="o<?php echo $cases_grid->RowIndex ?>_CaseTypeConvFiles" id="o<?php echo $cases_grid->RowIndex ?>_CaseTypeConvFiles" value="<?php echo HtmlEncode($cases->CaseTypeConvFiles->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$cases_grid->ListOptions->render("body", "right", $cases_grid->RowIndex);
?>
<script>
fcasesgrid.updateLists(<?php echo $cases_grid->RowIndex ?>);
</script>
	</tr>
<?php
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($cases->CurrentMode == "add" || $cases->CurrentMode == "copy") { ?>
<input type="hidden" name="<?php echo $cases_grid->FormKeyCountName ?>" id="<?php echo $cases_grid->FormKeyCountName ?>" value="<?php echo $cases_grid->KeyCount ?>">
<?php echo $cases_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($cases->CurrentMode == "edit") { ?>
<input type="hidden" name="<?php echo $cases_grid->FormKeyCountName ?>" id="<?php echo $cases_grid->FormKeyCountName ?>" value="<?php echo $cases_grid->KeyCount ?>">
<?php echo $cases_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($cases->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fcasesgrid">
</div><!-- /.ew-grid-middle-panel -->
<?php

// Close recordset
if ($cases_grid->Recordset)
	$cases_grid->Recordset->Close();
?>
</div>
<?php if ($cases_grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $cases_grid->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($cases_grid->TotalRecs == 0 && !$cases->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $cases_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$cases_grid->terminate();
?>
<?php if (!$cases->isExport()) { ?>
<script>
ew.scrollableTable("gmp_cases", "1250px", "");
</script>
<?php } ?>
