<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$casesort_add = new casesort_add();

// Run the page
$casesort_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$casesort_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fcasesortadd = currentForm = new ew.Form("fcasesortadd", "add");

// Validate form
fcasesortadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($casesort_add->CaseSort->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseSort");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $casesort->CaseSort->caption(), $casesort->CaseSort->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($casesort_add->CaseSortEn->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseSortEn");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $casesort->CaseSortEn->caption(), $casesort->CaseSortEn->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($casesort_add->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $casesort->Notes->caption(), $casesort->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fcasesortadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcasesortadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $casesort_add->showPageHeader(); ?>
<?php
$casesort_add->showMessage();
?>
<form name="fcasesortadd" id="fcasesortadd" class="<?php echo $casesort_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($casesort_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $casesort_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="casesort">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$casesort_add->IsModal ?>">
<?php if (!$casesort_add->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($casesort_add->IsMobileOrModal) { ?>
<div class="ew-add-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_casesortadd" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($casesort->CaseSort->Visible) { // CaseSort ?>
<?php if ($casesort_add->IsMobileOrModal) { ?>
	<div id="r_CaseSort" class="form-group row">
		<label id="elh_casesort_CaseSort" for="x_CaseSort" class="<?php echo $casesort_add->LeftColumnClass ?>"><?php echo $casesort->CaseSort->caption() ?><?php echo ($casesort->CaseSort->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $casesort_add->RightColumnClass ?>"><div<?php echo $casesort->CaseSort->cellAttributes() ?>>
<span id="el_casesort_CaseSort">
<input type="text" data-table="casesort" data-field="x_CaseSort" name="x_CaseSort" id="x_CaseSort" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($casesort->CaseSort->getPlaceHolder()) ?>" value="<?php echo $casesort->CaseSort->EditValue ?>"<?php echo $casesort->CaseSort->editAttributes() ?>>
</span>
<?php echo $casesort->CaseSort->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseSort">
		<td class="<?php echo $casesort_add->TableLeftColumnClass ?>"><span id="elh_casesort_CaseSort"><?php echo $casesort->CaseSort->caption() ?><?php echo ($casesort->CaseSort->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $casesort->CaseSort->cellAttributes() ?>>
<span id="el_casesort_CaseSort">
<input type="text" data-table="casesort" data-field="x_CaseSort" name="x_CaseSort" id="x_CaseSort" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($casesort->CaseSort->getPlaceHolder()) ?>" value="<?php echo $casesort->CaseSort->EditValue ?>"<?php echo $casesort->CaseSort->editAttributes() ?>>
</span>
<?php echo $casesort->CaseSort->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($casesort->CaseSortEn->Visible) { // CaseSortEn ?>
<?php if ($casesort_add->IsMobileOrModal) { ?>
	<div id="r_CaseSortEn" class="form-group row">
		<label id="elh_casesort_CaseSortEn" for="x_CaseSortEn" class="<?php echo $casesort_add->LeftColumnClass ?>"><?php echo $casesort->CaseSortEn->caption() ?><?php echo ($casesort->CaseSortEn->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $casesort_add->RightColumnClass ?>"><div<?php echo $casesort->CaseSortEn->cellAttributes() ?>>
<span id="el_casesort_CaseSortEn">
<input type="text" data-table="casesort" data-field="x_CaseSortEn" name="x_CaseSortEn" id="x_CaseSortEn" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($casesort->CaseSortEn->getPlaceHolder()) ?>" value="<?php echo $casesort->CaseSortEn->EditValue ?>"<?php echo $casesort->CaseSortEn->editAttributes() ?>>
</span>
<?php echo $casesort->CaseSortEn->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseSortEn">
		<td class="<?php echo $casesort_add->TableLeftColumnClass ?>"><span id="elh_casesort_CaseSortEn"><?php echo $casesort->CaseSortEn->caption() ?><?php echo ($casesort->CaseSortEn->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $casesort->CaseSortEn->cellAttributes() ?>>
<span id="el_casesort_CaseSortEn">
<input type="text" data-table="casesort" data-field="x_CaseSortEn" name="x_CaseSortEn" id="x_CaseSortEn" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($casesort->CaseSortEn->getPlaceHolder()) ?>" value="<?php echo $casesort->CaseSortEn->EditValue ?>"<?php echo $casesort->CaseSortEn->editAttributes() ?>>
</span>
<?php echo $casesort->CaseSortEn->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($casesort->Notes->Visible) { // Notes ?>
<?php if ($casesort_add->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label id="elh_casesort_Notes" for="x_Notes" class="<?php echo $casesort_add->LeftColumnClass ?>"><?php echo $casesort->Notes->caption() ?><?php echo ($casesort->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $casesort_add->RightColumnClass ?>"><div<?php echo $casesort->Notes->cellAttributes() ?>>
<span id="el_casesort_Notes">
<input type="text" data-table="casesort" data-field="x_Notes" name="x_Notes" id="x_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($casesort->Notes->getPlaceHolder()) ?>" value="<?php echo $casesort->Notes->EditValue ?>"<?php echo $casesort->Notes->editAttributes() ?>>
</span>
<?php echo $casesort->Notes->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $casesort_add->TableLeftColumnClass ?>"><span id="elh_casesort_Notes"><?php echo $casesort->Notes->caption() ?><?php echo ($casesort->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $casesort->Notes->cellAttributes() ?>>
<span id="el_casesort_Notes">
<input type="text" data-table="casesort" data-field="x_Notes" name="x_Notes" id="x_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($casesort->Notes->getPlaceHolder()) ?>" value="<?php echo $casesort->Notes->EditValue ?>"<?php echo $casesort->Notes->editAttributes() ?>>
</span>
<?php echo $casesort->Notes->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($casesort_add->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if (!$casesort_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $casesort_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $casesort_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$casesort_add->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
</form>
<?php
$casesort_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$casesort_add->terminate();
?>
