<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$cases_view = new cases_view();

// Run the page
$cases_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$cases_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$cases->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fcasesview = currentForm = new ew.Form("fcasesview", "view");

// Form_CustomValidate event
fcasesview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcasesview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcasesview.lists["x_ClientID"] = <?php echo $cases_view->ClientID->Lookup->toClientList() ?>;
fcasesview.lists["x_ClientID"].options = <?php echo JsonEncode($cases_view->ClientID->lookupOptions()) ?>;
fcasesview.autoSuggests["x_ClientID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcasesview.lists["x_LitigantID"] = <?php echo $cases_view->LitigantID->Lookup->toClientList() ?>;
fcasesview.lists["x_LitigantID"].options = <?php echo JsonEncode($cases_view->LitigantID->lookupOptions()) ?>;
fcasesview.autoSuggests["x_LitigantID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcasesview.lists["x_CaseTypeID"] = <?php echo $cases_view->CaseTypeID->Lookup->toClientList() ?>;
fcasesview.lists["x_CaseTypeID"].options = <?php echo JsonEncode($cases_view->CaseTypeID->lookupOptions()) ?>;
fcasesview.lists["x_CourtID"] = <?php echo $cases_view->CourtID->Lookup->toClientList() ?>;
fcasesview.lists["x_CourtID"].options = <?php echo JsonEncode($cases_view->CourtID->lookupOptions()) ?>;
fcasesview.autoSuggests["x_CourtID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcasesview.lists["x_ClientStatusID"] = <?php echo $cases_view->ClientStatusID->Lookup->toClientList() ?>;
fcasesview.lists["x_ClientStatusID"].options = <?php echo JsonEncode($cases_view->ClientStatusID->lookupOptions()) ?>;
fcasesview.lists["x_LitigantStatusID"] = <?php echo $cases_view->LitigantStatusID->Lookup->toClientList() ?>;
fcasesview.lists["x_LitigantStatusID"].options = <?php echo JsonEncode($cases_view->LitigantStatusID->lookupOptions()) ?>;
fcasesview.lists["x_JudgeID"] = <?php echo $cases_view->JudgeID->Lookup->toClientList() ?>;
fcasesview.lists["x_JudgeID"].options = <?php echo JsonEncode($cases_view->JudgeID->lookupOptions()) ?>;
fcasesview.lists["x_CaseSortID"] = <?php echo $cases_view->CaseSortID->Lookup->toClientList() ?>;
fcasesview.lists["x_CaseSortID"].options = <?php echo JsonEncode($cases_view->CaseSortID->lookupOptions()) ?>;
fcasesview.lists["x_CaseStatusID"] = <?php echo $cases_view->CaseStatusID->Lookup->toClientList() ?>;
fcasesview.lists["x_CaseStatusID"].options = <?php echo JsonEncode($cases_view->CaseStatusID->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$cases->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $cases_view->ExportOptions->render("body") ?>
<?php $cases_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $cases_view->showPageHeader(); ?>
<?php
$cases_view->showMessage();
?>
<?php if (!$cases_view->IsModal) { ?>
<?php if (!$cases->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($cases_view->Pager)) $cases_view->Pager = new PrevNextPager($cases_view->StartRec, $cases_view->DisplayRecs, $cases_view->TotalRecs, $cases_view->AutoHidePager) ?>
<?php if ($cases_view->Pager->RecordCount > 0 && $cases_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($cases_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $cases_view->pageUrl() ?>start=<?php echo $cases_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($cases_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $cases_view->pageUrl() ?>start=<?php echo $cases_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $cases_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($cases_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $cases_view->pageUrl() ?>start=<?php echo $cases_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($cases_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $cases_view->pageUrl() ?>start=<?php echo $cases_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $cases_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="fcasesview" id="fcasesview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($cases_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $cases_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="cases">
<input type="hidden" name="modal" value="<?php echo (int)$cases_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($cases->CaseID->Visible) { // CaseID ?>
	<tr id="r_CaseID">
		<td class="<?php echo $cases_view->TableLeftColumnClass ?>"><span id="elh_cases_CaseID"><?php echo $cases->CaseID->caption() ?></span></td>
		<td data-name="CaseID"<?php echo $cases->CaseID->cellAttributes() ?>>
<span id="el_cases_CaseID" data-page="1">
<span<?php echo $cases->CaseID->viewAttributes() ?>>
<?php echo $cases->CaseID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cases->ClientID->Visible) { // ClientID ?>
	<tr id="r_ClientID">
		<td class="<?php echo $cases_view->TableLeftColumnClass ?>"><span id="elh_cases_ClientID"><?php echo $cases->ClientID->caption() ?></span></td>
		<td data-name="ClientID"<?php echo $cases->ClientID->cellAttributes() ?>>
<span id="el_cases_ClientID" data-page="1">
<span<?php echo $cases->ClientID->viewAttributes() ?>>
<?php if ((!EmptyString($cases->ClientID->getViewValue())) && $cases->ClientID->linkAttributes() <> "") { ?>
<a<?php echo $cases->ClientID->linkAttributes() ?>><?php echo $cases->ClientID->getViewValue() ?></a>
<?php } else { ?>
<?php echo $cases->ClientID->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cases->LitigantID->Visible) { // LitigantID ?>
	<tr id="r_LitigantID">
		<td class="<?php echo $cases_view->TableLeftColumnClass ?>"><span id="elh_cases_LitigantID"><?php echo $cases->LitigantID->caption() ?></span></td>
		<td data-name="LitigantID"<?php echo $cases->LitigantID->cellAttributes() ?>>
<span id="el_cases_LitigantID" data-page="1">
<span<?php echo $cases->LitigantID->viewAttributes() ?>>
<?php if ((!EmptyString($cases->LitigantID->getViewValue())) && $cases->LitigantID->linkAttributes() <> "") { ?>
<a<?php echo $cases->LitigantID->linkAttributes() ?>><?php echo $cases->LitigantID->getViewValue() ?></a>
<?php } else { ?>
<?php echo $cases->LitigantID->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cases->CaseTypeID->Visible) { // CaseTypeID ?>
	<tr id="r_CaseTypeID">
		<td class="<?php echo $cases_view->TableLeftColumnClass ?>"><span id="elh_cases_CaseTypeID"><?php echo $cases->CaseTypeID->caption() ?></span></td>
		<td data-name="CaseTypeID"<?php echo $cases->CaseTypeID->cellAttributes() ?>>
<span id="el_cases_CaseTypeID" data-page="1">
<span<?php echo $cases->CaseTypeID->viewAttributes() ?>>
<?php echo $cases->CaseTypeID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cases->CourtID->Visible) { // CourtID ?>
	<tr id="r_CourtID">
		<td class="<?php echo $cases_view->TableLeftColumnClass ?>"><span id="elh_cases_CourtID"><?php echo $cases->CourtID->caption() ?></span></td>
		<td data-name="CourtID"<?php echo $cases->CourtID->cellAttributes() ?>>
<span id="el_cases_CourtID" data-page="1">
<span<?php echo $cases->CourtID->viewAttributes() ?>>
<?php if ((!EmptyString($cases->CourtID->getViewValue())) && $cases->CourtID->linkAttributes() <> "") { ?>
<a<?php echo $cases->CourtID->linkAttributes() ?>><?php echo $cases->CourtID->getViewValue() ?></a>
<?php } else { ?>
<?php echo $cases->CourtID->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cases->CaseNumber->Visible) { // CaseNumber ?>
	<tr id="r_CaseNumber">
		<td class="<?php echo $cases_view->TableLeftColumnClass ?>"><span id="elh_cases_CaseNumber"><?php echo $cases->CaseNumber->caption() ?></span></td>
		<td data-name="CaseNumber"<?php echo $cases->CaseNumber->cellAttributes() ?>>
<span id="el_cases_CaseNumber" data-page="1">
<span<?php echo $cases->CaseNumber->viewAttributes() ?>>
<?php echo $cases->CaseNumber->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cases->FileNumber->Visible) { // FileNumber ?>
	<tr id="r_FileNumber">
		<td class="<?php echo $cases_view->TableLeftColumnClass ?>"><span id="elh_cases_FileNumber"><?php echo $cases->FileNumber->caption() ?></span></td>
		<td data-name="FileNumber"<?php echo $cases->FileNumber->cellAttributes() ?>>
<span id="el_cases_FileNumber" data-page="1">
<span<?php echo $cases->FileNumber->viewAttributes() ?>>
<?php echo $cases->FileNumber->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cases->ClientStatusID->Visible) { // ClientStatusID ?>
	<tr id="r_ClientStatusID">
		<td class="<?php echo $cases_view->TableLeftColumnClass ?>"><span id="elh_cases_ClientStatusID"><?php echo $cases->ClientStatusID->caption() ?></span></td>
		<td data-name="ClientStatusID"<?php echo $cases->ClientStatusID->cellAttributes() ?>>
<span id="el_cases_ClientStatusID" data-page="1">
<span<?php echo $cases->ClientStatusID->viewAttributes() ?>>
<?php echo $cases->ClientStatusID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cases->LitigantStatusID->Visible) { // LitigantStatusID ?>
	<tr id="r_LitigantStatusID">
		<td class="<?php echo $cases_view->TableLeftColumnClass ?>"><span id="elh_cases_LitigantStatusID"><?php echo $cases->LitigantStatusID->caption() ?></span></td>
		<td data-name="LitigantStatusID"<?php echo $cases->LitigantStatusID->cellAttributes() ?>>
<span id="el_cases_LitigantStatusID" data-page="1">
<span<?php echo $cases->LitigantStatusID->viewAttributes() ?>>
<?php echo $cases->LitigantStatusID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cases->JudgeID->Visible) { // JudgeID ?>
	<tr id="r_JudgeID">
		<td class="<?php echo $cases_view->TableLeftColumnClass ?>"><span id="elh_cases_JudgeID"><?php echo $cases->JudgeID->caption() ?></span></td>
		<td data-name="JudgeID"<?php echo $cases->JudgeID->cellAttributes() ?>>
<span id="el_cases_JudgeID" data-page="1">
<span<?php echo $cases->JudgeID->viewAttributes() ?>>
<?php if ((!EmptyString($cases->JudgeID->getViewValue())) && $cases->JudgeID->linkAttributes() <> "") { ?>
<a<?php echo $cases->JudgeID->linkAttributes() ?>><?php echo $cases->JudgeID->getViewValue() ?></a>
<?php } else { ?>
<?php echo $cases->JudgeID->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cases->Notes->Visible) { // Notes ?>
	<tr id="r_Notes">
		<td class="<?php echo $cases_view->TableLeftColumnClass ?>"><span id="elh_cases_Notes"><?php echo $cases->Notes->caption() ?></span></td>
		<td data-name="Notes"<?php echo $cases->Notes->cellAttributes() ?>>
<span id="el_cases_Notes" data-page="1">
<span<?php echo $cases->Notes->viewAttributes() ?>>
<?php echo $cases->Notes->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cases->FileLocation->Visible) { // FileLocation ?>
	<tr id="r_FileLocation">
		<td class="<?php echo $cases_view->TableLeftColumnClass ?>"><span id="elh_cases_FileLocation"><?php echo $cases->FileLocation->caption() ?></span></td>
		<td data-name="FileLocation"<?php echo $cases->FileLocation->cellAttributes() ?>>
<span id="el_cases_FileLocation" data-page="1">
<span<?php echo $cases->FileLocation->viewAttributes() ?>>
<?php echo $cases->FileLocation->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cases->_Case->Visible) { // Case ?>
	<tr id="r__Case">
		<td class="<?php echo $cases_view->TableLeftColumnClass ?>"><span id="elh_cases__Case"><?php echo $cases->_Case->caption() ?></span></td>
		<td data-name="_Case"<?php echo $cases->_Case->cellAttributes() ?>>
<span id="el_cases__Case" data-page="1">
<span<?php echo $cases->_Case->viewAttributes() ?>>
<?php echo $cases->_Case->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cases->CaseSortID->Visible) { // CaseSortID ?>
	<tr id="r_CaseSortID">
		<td class="<?php echo $cases_view->TableLeftColumnClass ?>"><span id="elh_cases_CaseSortID"><?php echo $cases->CaseSortID->caption() ?></span></td>
		<td data-name="CaseSortID"<?php echo $cases->CaseSortID->cellAttributes() ?>>
<span id="el_cases_CaseSortID" data-page="1">
<span<?php echo $cases->CaseSortID->viewAttributes() ?>>
<?php echo $cases->CaseSortID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cases->CaseRegisteredDate->Visible) { // CaseRegisteredDate ?>
	<tr id="r_CaseRegisteredDate">
		<td class="<?php echo $cases_view->TableLeftColumnClass ?>"><span id="elh_cases_CaseRegisteredDate"><?php echo $cases->CaseRegisteredDate->caption() ?></span></td>
		<td data-name="CaseRegisteredDate"<?php echo $cases->CaseRegisteredDate->cellAttributes() ?>>
<span id="el_cases_CaseRegisteredDate" data-page="1">
<span<?php echo $cases->CaseRegisteredDate->viewAttributes() ?>>
<?php echo $cases->CaseRegisteredDate->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cases->CaseStatusID->Visible) { // CaseStatusID ?>
	<tr id="r_CaseStatusID">
		<td class="<?php echo $cases_view->TableLeftColumnClass ?>"><span id="elh_cases_CaseStatusID"><?php echo $cases->CaseStatusID->caption() ?></span></td>
		<td data-name="CaseStatusID"<?php echo $cases->CaseStatusID->cellAttributes() ?>>
<span id="el_cases_CaseStatusID" data-page="1">
<span<?php echo $cases->CaseStatusID->viewAttributes() ?>>
<?php echo $cases->CaseStatusID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cases->ParentCaseID->Visible) { // ParentCaseID ?>
	<tr id="r_ParentCaseID">
		<td class="<?php echo $cases_view->TableLeftColumnClass ?>"><span id="elh_cases_ParentCaseID"><?php echo $cases->ParentCaseID->caption() ?></span></td>
		<td data-name="ParentCaseID"<?php echo $cases->ParentCaseID->cellAttributes() ?>>
<span id="el_cases_ParentCaseID" data-page="1">
<span<?php echo $cases->ParentCaseID->viewAttributes() ?>>
<?php echo $cases->ParentCaseID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cases->ClientNameConvFiles->Visible) { // ClientNameConvFiles ?>
	<tr id="r_ClientNameConvFiles">
		<td class="<?php echo $cases_view->TableLeftColumnClass ?>"><span id="elh_cases_ClientNameConvFiles"><?php echo $cases->ClientNameConvFiles->caption() ?></span></td>
		<td data-name="ClientNameConvFiles"<?php echo $cases->ClientNameConvFiles->cellAttributes() ?>>
<span id="el_cases_ClientNameConvFiles" data-page="1">
<span<?php echo $cases->ClientNameConvFiles->viewAttributes() ?>>
<?php echo $cases->ClientNameConvFiles->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cases->LitigantNameConvFiles->Visible) { // LitigantNameConvFiles ?>
	<tr id="r_LitigantNameConvFiles">
		<td class="<?php echo $cases_view->TableLeftColumnClass ?>"><span id="elh_cases_LitigantNameConvFiles"><?php echo $cases->LitigantNameConvFiles->caption() ?></span></td>
		<td data-name="LitigantNameConvFiles"<?php echo $cases->LitigantNameConvFiles->cellAttributes() ?>>
<span id="el_cases_LitigantNameConvFiles" data-page="1">
<span<?php echo $cases->LitigantNameConvFiles->viewAttributes() ?>>
<?php echo $cases->LitigantNameConvFiles->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($cases->CaseTypeConvFiles->Visible) { // CaseTypeConvFiles ?>
	<tr id="r_CaseTypeConvFiles">
		<td class="<?php echo $cases_view->TableLeftColumnClass ?>"><span id="elh_cases_CaseTypeConvFiles"><?php echo $cases->CaseTypeConvFiles->caption() ?></span></td>
		<td data-name="CaseTypeConvFiles"<?php echo $cases->CaseTypeConvFiles->cellAttributes() ?>>
<span id="el_cases_CaseTypeConvFiles" data-page="1">
<span<?php echo $cases->CaseTypeConvFiles->viewAttributes() ?>>
<?php echo $cases->CaseTypeConvFiles->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$cases_view->IsModal) { ?>
<?php if (!$cases->isExport()) { ?>
<?php if (!isset($cases_view->Pager)) $cases_view->Pager = new PrevNextPager($cases_view->StartRec, $cases_view->DisplayRecs, $cases_view->TotalRecs, $cases_view->AutoHidePager) ?>
<?php if ($cases_view->Pager->RecordCount > 0 && $cases_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($cases_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $cases_view->pageUrl() ?>start=<?php echo $cases_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($cases_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $cases_view->pageUrl() ?>start=<?php echo $cases_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $cases_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($cases_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $cases_view->pageUrl() ?>start=<?php echo $cases_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($cases_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $cases_view->pageUrl() ?>start=<?php echo $cases_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $cases_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
<?php if ($cases->getCurrentDetailTable() <> "") { ?>
<?php
	$cases_view->DetailPages->ValidKeys = explode(",", $cases->getCurrentDetailTable());
	$firstActiveDetailTable = $cases_view->DetailPages->activePageIndex();
?>
<div class="ew-detail-pages"><!-- detail-pages -->
<div class="ew-nav-tabs" id="cases_view_details"><!-- tabs -->
	<ul class="<?php echo $cases_view->DetailPages->navStyle() ?>"><!-- .nav -->
<?php
	if (in_array("hearings", explode(",", $cases->getCurrentDetailTable())) && $hearings->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "hearings") {
			$firstActiveDetailTable = "hearings";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $cases_view->DetailPages->pageStyle("hearings") ?>" href="#tab_hearings" data-toggle="tab"><?php echo $Language->TablePhrase("hearings", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $cases_view->hearings_Count, $Language->phrase("DetailCount")) ?></a></li>
<?php
	}
?>
<?php
	if (in_array("notices", explode(",", $cases->getCurrentDetailTable())) && $notices->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "notices") {
			$firstActiveDetailTable = "notices";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $cases_view->DetailPages->pageStyle("notices") ?>" href="#tab_notices" data-toggle="tab"><?php echo $Language->TablePhrase("notices", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $cases_view->notices_Count, $Language->phrase("DetailCount")) ?></a></li>
<?php
	}
?>
<?php
	if (in_array("complaints", explode(",", $cases->getCurrentDetailTable())) && $complaints->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "complaints") {
			$firstActiveDetailTable = "complaints";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $cases_view->DetailPages->pageStyle("complaints") ?>" href="#tab_complaints" data-toggle="tab"><?php echo $Language->TablePhrase("complaints", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $cases_view->complaints_Count, $Language->phrase("DetailCount")) ?></a></li>
<?php
	}
?>
<?php
	if (in_array("notifications", explode(",", $cases->getCurrentDetailTable())) && $notifications->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "notifications") {
			$firstActiveDetailTable = "notifications";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $cases_view->DetailPages->pageStyle("notifications") ?>" href="#tab_notifications" data-toggle="tab"><?php echo $Language->TablePhrase("notifications", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $cases_view->notifications_Count, $Language->phrase("DetailCount")) ?></a></li>
<?php
	}
?>
<?php
	if (in_array("attachments", explode(",", $cases->getCurrentDetailTable())) && $attachments->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "attachments") {
			$firstActiveDetailTable = "attachments";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $cases_view->DetailPages->pageStyle("attachments") ?>" href="#tab_attachments" data-toggle="tab"><?php echo $Language->TablePhrase("attachments", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $cases_view->attachments_Count, $Language->phrase("DetailCount")) ?></a></li>
<?php
	}
?>
	</ul><!-- /.nav -->
	<div class="tab-content"><!-- .tab-content -->
<?php
	if (in_array("hearings", explode(",", $cases->getCurrentDetailTable())) && $hearings->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "hearings")
			$firstActiveDetailTable = "hearings";
?>
		<div class="tab-pane<?php echo $cases_view->DetailPages->pageStyle("hearings") ?>" id="tab_hearings"><!-- page* -->
<?php include_once "hearingsgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
<?php
	if (in_array("notices", explode(",", $cases->getCurrentDetailTable())) && $notices->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "notices")
			$firstActiveDetailTable = "notices";
?>
		<div class="tab-pane<?php echo $cases_view->DetailPages->pageStyle("notices") ?>" id="tab_notices"><!-- page* -->
<?php include_once "noticesgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
<?php
	if (in_array("complaints", explode(",", $cases->getCurrentDetailTable())) && $complaints->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "complaints")
			$firstActiveDetailTable = "complaints";
?>
		<div class="tab-pane<?php echo $cases_view->DetailPages->pageStyle("complaints") ?>" id="tab_complaints"><!-- page* -->
<?php include_once "complaintsgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
<?php
	if (in_array("notifications", explode(",", $cases->getCurrentDetailTable())) && $notifications->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "notifications")
			$firstActiveDetailTable = "notifications";
?>
		<div class="tab-pane<?php echo $cases_view->DetailPages->pageStyle("notifications") ?>" id="tab_notifications"><!-- page* -->
<?php include_once "notificationsgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
<?php
	if (in_array("attachments", explode(",", $cases->getCurrentDetailTable())) && $attachments->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "attachments")
			$firstActiveDetailTable = "attachments";
?>
		<div class="tab-pane<?php echo $cases_view->DetailPages->pageStyle("attachments") ?>" id="tab_attachments"><!-- page* -->
<?php include_once "attachmentsgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
	</div><!-- /.tab-content -->
</div><!-- /tabs -->
</div><!-- /detail-pages -->
<?php } ?>
</form>
<?php
$cases_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$cases->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$cases_view->terminate();
?>
