<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$chambers_add = new chambers_add();

// Run the page
$chambers_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$chambers_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fchambersadd = currentForm = new ew.Form("fchambersadd", "add");

// Validate form
fchambersadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($chambers_add->Chamber->Required) { ?>
			elm = this.getElements("x" + infix + "_Chamber");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $chambers->Chamber->caption(), $chambers->Chamber->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($chambers_add->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $chambers->Notes->caption(), $chambers->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fchambersadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fchambersadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $chambers_add->showPageHeader(); ?>
<?php
$chambers_add->showMessage();
?>
<form name="fchambersadd" id="fchambersadd" class="<?php echo $chambers_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($chambers_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $chambers_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="chambers">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$chambers_add->IsModal ?>">
<?php if (!$chambers_add->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($chambers_add->IsMobileOrModal) { ?>
<div class="ew-add-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_chambersadd" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($chambers->Chamber->Visible) { // Chamber ?>
<?php if ($chambers_add->IsMobileOrModal) { ?>
	<div id="r_Chamber" class="form-group row">
		<label id="elh_chambers_Chamber" for="x_Chamber" class="<?php echo $chambers_add->LeftColumnClass ?>"><?php echo $chambers->Chamber->caption() ?><?php echo ($chambers->Chamber->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $chambers_add->RightColumnClass ?>"><div<?php echo $chambers->Chamber->cellAttributes() ?>>
<span id="el_chambers_Chamber">
<input type="text" data-table="chambers" data-field="x_Chamber" name="x_Chamber" id="x_Chamber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($chambers->Chamber->getPlaceHolder()) ?>" value="<?php echo $chambers->Chamber->EditValue ?>"<?php echo $chambers->Chamber->editAttributes() ?>>
</span>
<?php echo $chambers->Chamber->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Chamber">
		<td class="<?php echo $chambers_add->TableLeftColumnClass ?>"><span id="elh_chambers_Chamber"><?php echo $chambers->Chamber->caption() ?><?php echo ($chambers->Chamber->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $chambers->Chamber->cellAttributes() ?>>
<span id="el_chambers_Chamber">
<input type="text" data-table="chambers" data-field="x_Chamber" name="x_Chamber" id="x_Chamber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($chambers->Chamber->getPlaceHolder()) ?>" value="<?php echo $chambers->Chamber->EditValue ?>"<?php echo $chambers->Chamber->editAttributes() ?>>
</span>
<?php echo $chambers->Chamber->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($chambers->Notes->Visible) { // Notes ?>
<?php if ($chambers_add->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label id="elh_chambers_Notes" for="x_Notes" class="<?php echo $chambers_add->LeftColumnClass ?>"><?php echo $chambers->Notes->caption() ?><?php echo ($chambers->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $chambers_add->RightColumnClass ?>"><div<?php echo $chambers->Notes->cellAttributes() ?>>
<span id="el_chambers_Notes">
<textarea data-table="chambers" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($chambers->Notes->getPlaceHolder()) ?>"<?php echo $chambers->Notes->editAttributes() ?>><?php echo $chambers->Notes->EditValue ?></textarea>
</span>
<?php echo $chambers->Notes->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $chambers_add->TableLeftColumnClass ?>"><span id="elh_chambers_Notes"><?php echo $chambers->Notes->caption() ?><?php echo ($chambers->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $chambers->Notes->cellAttributes() ?>>
<span id="el_chambers_Notes">
<textarea data-table="chambers" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($chambers->Notes->getPlaceHolder()) ?>"<?php echo $chambers->Notes->editAttributes() ?>><?php echo $chambers->Notes->EditValue ?></textarea>
</span>
<?php echo $chambers->Notes->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($chambers_add->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if (!$chambers_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $chambers_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $chambers_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$chambers_add->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
</form>
<?php
$chambers_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$chambers_add->terminate();
?>
