<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$chambers_view = new chambers_view();

// Run the page
$chambers_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$chambers_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$chambers->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fchambersview = currentForm = new ew.Form("fchambersview", "view");

// Form_CustomValidate event
fchambersview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fchambersview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$chambers->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $chambers_view->ExportOptions->render("body") ?>
<?php $chambers_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $chambers_view->showPageHeader(); ?>
<?php
$chambers_view->showMessage();
?>
<?php if (!$chambers_view->IsModal) { ?>
<?php if (!$chambers->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($chambers_view->Pager)) $chambers_view->Pager = new PrevNextPager($chambers_view->StartRec, $chambers_view->DisplayRecs, $chambers_view->TotalRecs, $chambers_view->AutoHidePager) ?>
<?php if ($chambers_view->Pager->RecordCount > 0 && $chambers_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($chambers_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $chambers_view->pageUrl() ?>start=<?php echo $chambers_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($chambers_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $chambers_view->pageUrl() ?>start=<?php echo $chambers_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $chambers_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($chambers_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $chambers_view->pageUrl() ?>start=<?php echo $chambers_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($chambers_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $chambers_view->pageUrl() ?>start=<?php echo $chambers_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $chambers_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="fchambersview" id="fchambersview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($chambers_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $chambers_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="chambers">
<input type="hidden" name="modal" value="<?php echo (int)$chambers_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($chambers->ChamberID->Visible) { // ChamberID ?>
	<tr id="r_ChamberID">
		<td class="<?php echo $chambers_view->TableLeftColumnClass ?>"><span id="elh_chambers_ChamberID"><?php echo $chambers->ChamberID->caption() ?></span></td>
		<td data-name="ChamberID"<?php echo $chambers->ChamberID->cellAttributes() ?>>
<span id="el_chambers_ChamberID">
<span<?php echo $chambers->ChamberID->viewAttributes() ?>>
<?php echo $chambers->ChamberID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($chambers->Chamber->Visible) { // Chamber ?>
	<tr id="r_Chamber">
		<td class="<?php echo $chambers_view->TableLeftColumnClass ?>"><span id="elh_chambers_Chamber"><?php echo $chambers->Chamber->caption() ?></span></td>
		<td data-name="Chamber"<?php echo $chambers->Chamber->cellAttributes() ?>>
<span id="el_chambers_Chamber">
<span<?php echo $chambers->Chamber->viewAttributes() ?>>
<?php echo $chambers->Chamber->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($chambers->Notes->Visible) { // Notes ?>
	<tr id="r_Notes">
		<td class="<?php echo $chambers_view->TableLeftColumnClass ?>"><span id="elh_chambers_Notes"><?php echo $chambers->Notes->caption() ?></span></td>
		<td data-name="Notes"<?php echo $chambers->Notes->cellAttributes() ?>>
<span id="el_chambers_Notes">
<span<?php echo $chambers->Notes->viewAttributes() ?>>
<?php echo $chambers->Notes->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$chambers_view->IsModal) { ?>
<?php if (!$chambers->isExport()) { ?>
<?php if (!isset($chambers_view->Pager)) $chambers_view->Pager = new PrevNextPager($chambers_view->StartRec, $chambers_view->DisplayRecs, $chambers_view->TotalRecs, $chambers_view->AutoHidePager) ?>
<?php if ($chambers_view->Pager->RecordCount > 0 && $chambers_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($chambers_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $chambers_view->pageUrl() ?>start=<?php echo $chambers_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($chambers_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $chambers_view->pageUrl() ?>start=<?php echo $chambers_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $chambers_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($chambers_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $chambers_view->pageUrl() ?>start=<?php echo $chambers_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($chambers_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $chambers_view->pageUrl() ?>start=<?php echo $chambers_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $chambers_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
</form>
<?php
$chambers_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$chambers->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$chambers_view->terminate();
?>
