<?php
namespace PHPMaker2019\project_germanos;

/**
 * Table class for attachments
 */
class attachments extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Audit trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Export
	public $ExportDoc;

	// Fields
	public $AttachmentID;
	public $AttachmentSource_ID;
	public $CaseID;
	public $EmployeeID;
	public $AttachID;
	public $AttachFilename;
	public $AttachFilenameInitial;
	public $AttachExtension;
	public $AttachDescription;
	public $AttachNotes;
	public $AttachFilepath;
	public $AttachPath;
	public $Notes;
	public $_UserID;
	public $CreatedBy;
	public $CreatedDate;
	public $UpdatedBy;
	public $UpdatedDate;
	public $AddedBy;
	public $AddedDate;
	public $_Case;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'attachments';
		$this->TableName = 'attachments';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`attachments`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = TRUE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "AND";

		// AttachmentID
		$this->AttachmentID = new DbField('attachments', 'attachments', 'x_AttachmentID', 'AttachmentID', '`AttachmentID`', '`AttachmentID`', 3, -1, FALSE, '`AttachmentID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->AttachmentID->IsAutoIncrement = TRUE; // Autoincrement field
		$this->AttachmentID->IsPrimaryKey = TRUE; // Primary key field
		$this->AttachmentID->Sortable = TRUE; // Allow sort
		$this->AttachmentID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['AttachmentID'] = &$this->AttachmentID;

		// AttachmentSource_ID
		$this->AttachmentSource_ID = new DbField('attachments', 'attachments', 'x_AttachmentSource_ID', 'AttachmentSource_ID', '`AttachmentSource_ID`', '`AttachmentSource_ID`', 3, -1, FALSE, '`AttachmentSource_ID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->AttachmentSource_ID->Nullable = FALSE; // NOT NULL field
		$this->AttachmentSource_ID->Required = TRUE; // Required field
		$this->AttachmentSource_ID->Sortable = TRUE; // Allow sort
		switch ($CurrentLanguage) {
			case "ar":
				$this->AttachmentSource_ID->Lookup = new Lookup('AttachmentSource_ID', 'attachmentsource', FALSE, 'AttachmentSource_ID', ["AttachmentSource","AttachmentSourceEn",null,""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->AttachmentSource_ID->Lookup = new Lookup('AttachmentSource_ID', 'attachmentsource', FALSE, 'AttachmentSource_ID', ["AttachmentSourceEn","AttachmentSourceEn",null,""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->AttachmentSource_ID->Lookup = new Lookup('AttachmentSource_ID', 'attachmentsource', FALSE, 'AttachmentSource_ID', ["AttachmentSourceEn","AttachmentSourceEn",null,""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->AttachmentSource_ID->Lookup = new Lookup('AttachmentSource_ID', 'attachmentsource', FALSE, 'AttachmentSource_ID', ["AttachmentSource","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->AttachmentSource_ID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['AttachmentSource_ID'] = &$this->AttachmentSource_ID;

		// CaseID
		$this->CaseID = new DbField('attachments', 'attachments', 'x_CaseID', 'CaseID', '`CaseID`', '`CaseID`', 3, -1, FALSE, '`CaseID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CaseID->IsForeignKey = TRUE; // Foreign key field
		$this->CaseID->Sortable = TRUE; // Allow sort
		$this->CaseID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['CaseID'] = &$this->CaseID;

		// EmployeeID
		$this->EmployeeID = new DbField('attachments', 'attachments', 'x_EmployeeID', 'EmployeeID', '`EmployeeID`', '`EmployeeID`', 3, -1, FALSE, '`EmployeeID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->EmployeeID->Sortable = TRUE; // Allow sort
		$this->EmployeeID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['EmployeeID'] = &$this->EmployeeID;

		// AttachID
		$this->AttachID = new DbField('attachments', 'attachments', 'x_AttachID', 'AttachID', '`AttachID`', '`AttachID`', 3, -1, FALSE, '`AttachID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->AttachID->Sortable = TRUE; // Allow sort
		$this->AttachID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['AttachID'] = &$this->AttachID;

		// AttachFilename
		$this->AttachFilename = new DbField('attachments', 'attachments', 'x_AttachFilename', 'AttachFilename', '`AttachFilename`', '`AttachFilename`', 200, -1, TRUE, '`AttachFilename`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->AttachFilename->Sortable = TRUE; // Allow sort
		$this->AttachFilename->UploadMultiple = TRUE;
		$this->AttachFilename->Upload->UploadMultiple = TRUE;
		$this->AttachFilename->UploadMaxFileCount = 20;
		$this->fields['AttachFilename'] = &$this->AttachFilename;

		// AttachFilenameInitial
		$this->AttachFilenameInitial = new DbField('attachments', 'attachments', 'x_AttachFilenameInitial', 'AttachFilenameInitial', '`AttachFilenameInitial`', '`AttachFilenameInitial`', 200, -1, FALSE, '`AttachFilenameInitial`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->AttachFilenameInitial->Sortable = TRUE; // Allow sort
		$this->fields['AttachFilenameInitial'] = &$this->AttachFilenameInitial;

		// AttachExtension
		$this->AttachExtension = new DbField('attachments', 'attachments', 'x_AttachExtension', 'AttachExtension', '`AttachExtension`', '`AttachExtension`', 200, -1, FALSE, '`AttachExtension`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->AttachExtension->Sortable = TRUE; // Allow sort
		$this->fields['AttachExtension'] = &$this->AttachExtension;

		// AttachDescription
		$this->AttachDescription = new DbField('attachments', 'attachments', 'x_AttachDescription', 'AttachDescription', '`AttachDescription`', '`AttachDescription`', 200, -1, FALSE, '`AttachDescription`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->AttachDescription->Sortable = TRUE; // Allow sort
		$this->fields['AttachDescription'] = &$this->AttachDescription;

		// AttachNotes
		$this->AttachNotes = new DbField('attachments', 'attachments', 'x_AttachNotes', 'AttachNotes', '`AttachNotes`', '`AttachNotes`', 201, -1, FALSE, '`AttachNotes`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->AttachNotes->Sortable = TRUE; // Allow sort
		$this->fields['AttachNotes'] = &$this->AttachNotes;

		// AttachFilepath
		$this->AttachFilepath = new DbField('attachments', 'attachments', 'x_AttachFilepath', 'AttachFilepath', '`AttachFilepath`', '`AttachFilepath`', 200, -1, FALSE, '`AttachFilepath`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->AttachFilepath->Sortable = TRUE; // Allow sort
		$this->fields['AttachFilepath'] = &$this->AttachFilepath;

		// AttachPath
		$this->AttachPath = new DbField('attachments', 'attachments', 'x_AttachPath', 'AttachPath', '`AttachPath`', '`AttachPath`', 200, -1, FALSE, '`AttachPath`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->AttachPath->Sortable = TRUE; // Allow sort
		$this->fields['AttachPath'] = &$this->AttachPath;

		// Notes
		$this->Notes = new DbField('attachments', 'attachments', 'x_Notes', 'Notes', '`Notes`', '`Notes`', 201, -1, FALSE, '`Notes`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->Notes->Sortable = TRUE; // Allow sort
		$this->fields['Notes'] = &$this->Notes;

		// UserID
		$this->_UserID = new DbField('attachments', 'attachments', 'x__UserID', 'UserID', '`UserID`', '`UserID`', 3, -1, FALSE, '`UserID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_UserID->Sortable = FALSE; // Allow sort
		$this->_UserID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['UserID'] = &$this->_UserID;

		// CreatedBy
		$this->CreatedBy = new DbField('attachments', 'attachments', 'x_CreatedBy', 'CreatedBy', '`CreatedBy`', '`CreatedBy`', 200, -1, FALSE, '`CreatedBy`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CreatedBy->Sortable = FALSE; // Allow sort
		$this->fields['CreatedBy'] = &$this->CreatedBy;

		// CreatedDate
		$this->CreatedDate = new DbField('attachments', 'attachments', 'x_CreatedDate', 'CreatedDate', '`CreatedDate`', CastDateFieldForLike('`CreatedDate`', 0, "DB"), 135, 0, FALSE, '`CreatedDate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CreatedDate->Sortable = FALSE; // Allow sort
		$this->CreatedDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['CreatedDate'] = &$this->CreatedDate;

		// UpdatedBy
		$this->UpdatedBy = new DbField('attachments', 'attachments', 'x_UpdatedBy', 'UpdatedBy', '`UpdatedBy`', '`UpdatedBy`', 200, -1, FALSE, '`UpdatedBy`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->UpdatedBy->Sortable = FALSE; // Allow sort
		$this->fields['UpdatedBy'] = &$this->UpdatedBy;

		// UpdatedDate
		$this->UpdatedDate = new DbField('attachments', 'attachments', 'x_UpdatedDate', 'UpdatedDate', '`UpdatedDate`', CastDateFieldForLike('`UpdatedDate`', 0, "DB"), 135, 0, FALSE, '`UpdatedDate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->UpdatedDate->Sortable = FALSE; // Allow sort
		$this->UpdatedDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['UpdatedDate'] = &$this->UpdatedDate;

		// AddedBy
		$this->AddedBy = new DbField('attachments', 'attachments', 'x_AddedBy', 'AddedBy', '`AddedBy`', '`AddedBy`', 200, -1, FALSE, '`AddedBy`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->AddedBy->Nullable = FALSE; // NOT NULL field
		$this->AddedBy->Required = TRUE; // Required field
		$this->AddedBy->Sortable = FALSE; // Allow sort
		$this->fields['AddedBy'] = &$this->AddedBy;

		// AddedDate
		$this->AddedDate = new DbField('attachments', 'attachments', 'x_AddedDate', 'AddedDate', '`AddedDate`', CastDateFieldForLike('`AddedDate`', 0, "DB"), 133, 0, FALSE, '`AddedDate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->AddedDate->Nullable = FALSE; // NOT NULL field
		$this->AddedDate->Required = TRUE; // Required field
		$this->AddedDate->Sortable = FALSE; // Allow sort
		$this->AddedDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['AddedDate'] = &$this->AddedDate;

		// Case
		$this->_Case = new DbField('attachments', 'attachments', 'x__Case', 'Case', '`Case`', '`Case`', 200, -1, FALSE, '`Case`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_Case->Sortable = TRUE; // Allow sort
		$this->fields['Case'] = &$this->_Case;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Current master table name
	public function getCurrentMasterTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_MASTER_TABLE];
	}
	public function setCurrentMasterTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_MASTER_TABLE] = $v;
	}

	// Session master WHERE clause
	public function getMasterFilter()
	{

		// Master filter
		$masterFilter = "";
		if ($this->getCurrentMasterTable() == "cases") {
			if ($this->CaseID->getSessionValue() <> "")
				$masterFilter .= "`CaseID`=" . QuotedValue($this->CaseID->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		return $masterFilter;
	}

	// Session detail WHERE clause
	public function getDetailFilter()
	{

		// Detail filter
		$detailFilter = "";
		if ($this->getCurrentMasterTable() == "cases") {
			if ($this->CaseID->getSessionValue() <> "")
				$detailFilter .= "`CaseID`=" . QuotedValue($this->CaseID->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		return $detailFilter;
	}

	// Master filter
	public function sqlMasterFilter_cases()
	{
		return "`CaseID`=@CaseID@";
	}

	// Detail filter
	public function sqlDetailFilter_cases()
	{
		return "`CaseID`=@CaseID@";
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`attachments`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->AttachmentID->setDbValue($conn->insert_ID());
			$rs['AttachmentID'] = $this->AttachmentID->DbValue;
			if ($this->AuditTrailOnAdd)
				$this->writeAuditTrailOnAdd($rs);
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnEdit && $rsold) {
			$rsaudit = $rs;
			$fldname = 'AttachmentID';
			if (!array_key_exists($fldname, $rsaudit))
				$rsaudit[$fldname] = $rsold[$fldname];
			$this->writeAuditTrailOnEdit($rsold, $rsaudit);
		}
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('AttachmentID', $rs))
				AddFilter($where, QuotedName('AttachmentID', $this->Dbid) . '=' . QuotedValue($rs['AttachmentID'], $this->AttachmentID->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnDelete)
			$this->writeAuditTrailOnDelete($rs);
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->AttachmentID->DbValue = $row['AttachmentID'];
		$this->AttachmentSource_ID->DbValue = $row['AttachmentSource_ID'];
		$this->CaseID->DbValue = $row['CaseID'];
		$this->EmployeeID->DbValue = $row['EmployeeID'];
		$this->AttachID->DbValue = $row['AttachID'];
		$this->AttachFilename->Upload->DbValue = $row['AttachFilename'];
		$this->AttachFilenameInitial->DbValue = $row['AttachFilenameInitial'];
		$this->AttachExtension->DbValue = $row['AttachExtension'];
		$this->AttachDescription->DbValue = $row['AttachDescription'];
		$this->AttachNotes->DbValue = $row['AttachNotes'];
		$this->AttachFilepath->DbValue = $row['AttachFilepath'];
		$this->AttachPath->DbValue = $row['AttachPath'];
		$this->Notes->DbValue = $row['Notes'];
		$this->_UserID->DbValue = $row['UserID'];
		$this->CreatedBy->DbValue = $row['CreatedBy'];
		$this->CreatedDate->DbValue = $row['CreatedDate'];
		$this->UpdatedBy->DbValue = $row['UpdatedBy'];
		$this->UpdatedDate->DbValue = $row['UpdatedDate'];
		$this->AddedBy->DbValue = $row['AddedBy'];
		$this->AddedDate->DbValue = $row['AddedDate'];
		$this->_Case->DbValue = $row['Case'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
		$oldFiles = EmptyValue($row['AttachFilename']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['AttachFilename']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->AttachFilename->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->AttachFilename->oldPhysicalUploadPath() . $oldFile);
		}
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`AttachmentID` = @AttachmentID@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('AttachmentID', $row) ? $row['AttachmentID'] : NULL) : $this->AttachmentID->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@AttachmentID@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "attachmentslist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "attachmentsview.php")
			return $Language->phrase("View");
		elseif ($pageName == "attachmentsedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "attachmentsadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "attachmentslist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("attachmentsview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("attachmentsview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "attachmentsadd.php?" . $this->getUrlParm($parm);
		else
			$url = "attachmentsadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("attachmentsedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("attachmentsadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("attachmentsdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		if ($this->getCurrentMasterTable() == "cases" && !ContainsString($url, TABLE_SHOW_MASTER . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . TABLE_SHOW_MASTER . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_CaseID=" . urlencode($this->CaseID->CurrentValue);
		}
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "AttachmentID:" . JsonEncode($this->AttachmentID->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->AttachmentID->CurrentValue != NULL) {
			$url .= "AttachmentID=" . urlencode($this->AttachmentID->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("AttachmentID") !== NULL)
				$arKeys[] = Param("AttachmentID");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->AttachmentID->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->AttachmentID->setDbValue($rs->fields('AttachmentID'));
		$this->AttachmentSource_ID->setDbValue($rs->fields('AttachmentSource_ID'));
		$this->CaseID->setDbValue($rs->fields('CaseID'));
		$this->EmployeeID->setDbValue($rs->fields('EmployeeID'));
		$this->AttachID->setDbValue($rs->fields('AttachID'));
		$this->AttachFilename->Upload->DbValue = $rs->fields('AttachFilename');
		$this->AttachFilenameInitial->setDbValue($rs->fields('AttachFilenameInitial'));
		$this->AttachExtension->setDbValue($rs->fields('AttachExtension'));
		$this->AttachDescription->setDbValue($rs->fields('AttachDescription'));
		$this->AttachNotes->setDbValue($rs->fields('AttachNotes'));
		$this->AttachFilepath->setDbValue($rs->fields('AttachFilepath'));
		$this->AttachPath->setDbValue($rs->fields('AttachPath'));
		$this->Notes->setDbValue($rs->fields('Notes'));
		$this->_UserID->setDbValue($rs->fields('UserID'));
		$this->CreatedBy->setDbValue($rs->fields('CreatedBy'));
		$this->CreatedDate->setDbValue($rs->fields('CreatedDate'));
		$this->UpdatedBy->setDbValue($rs->fields('UpdatedBy'));
		$this->UpdatedDate->setDbValue($rs->fields('UpdatedDate'));
		$this->AddedBy->setDbValue($rs->fields('AddedBy'));
		$this->AddedDate->setDbValue($rs->fields('AddedDate'));
		$this->_Case->setDbValue($rs->fields('Case'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// AttachmentID
		// AttachmentSource_ID
		// CaseID
		// EmployeeID
		// AttachID
		// AttachFilename
		// AttachFilenameInitial
		// AttachExtension
		// AttachDescription
		// AttachNotes
		// AttachFilepath
		// AttachPath
		// Notes
		// UserID

		$this->_UserID->CellCssStyle = "white-space: nowrap;";

		// CreatedBy
		$this->CreatedBy->CellCssStyle = "white-space: nowrap;";

		// CreatedDate
		$this->CreatedDate->CellCssStyle = "white-space: nowrap;";

		// UpdatedBy
		$this->UpdatedBy->CellCssStyle = "white-space: nowrap;";

		// UpdatedDate
		$this->UpdatedDate->CellCssStyle = "white-space: nowrap;";

		// AddedBy
		$this->AddedBy->CellCssStyle = "white-space: nowrap;";

		// AddedDate
		$this->AddedDate->CellCssStyle = "white-space: nowrap;";

		// Case
		// AttachmentID

		$this->AttachmentID->ViewValue = $this->AttachmentID->CurrentValue;
		$this->AttachmentID->ViewCustomAttributes = "";

		// AttachmentSource_ID
		$this->AttachmentSource_ID->ViewValue = $this->AttachmentSource_ID->CurrentValue;
		$curVal = strval($this->AttachmentSource_ID->CurrentValue);
		if ($curVal <> "") {
			$this->AttachmentSource_ID->ViewValue = $this->AttachmentSource_ID->lookupCacheOption($curVal);
			if ($this->AttachmentSource_ID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`AttachmentSource_ID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->AttachmentSource_ID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->AttachmentSource_ID->ViewValue = $this->AttachmentSource_ID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->AttachmentSource_ID->ViewValue = $this->AttachmentSource_ID->CurrentValue;
				}
			}
		} else {
			$this->AttachmentSource_ID->ViewValue = NULL;
		}
		$this->AttachmentSource_ID->ViewCustomAttributes = "";

		// CaseID
		$this->CaseID->ViewValue = $this->CaseID->CurrentValue;
		$this->CaseID->ViewValue = FormatNumber($this->CaseID->ViewValue, 0, -2, -2, -2);
		$this->CaseID->ViewCustomAttributes = "";

		// EmployeeID
		$this->EmployeeID->ViewValue = $this->EmployeeID->CurrentValue;
		$this->EmployeeID->ViewValue = FormatNumber($this->EmployeeID->ViewValue, 0, -2, -2, -2);
		$this->EmployeeID->ViewCustomAttributes = "";

		// AttachID
		$this->AttachID->ViewValue = $this->AttachID->CurrentValue;
		$this->AttachID->ViewValue = FormatNumber($this->AttachID->ViewValue, 0, -2, -2, -2);
		$this->AttachID->ViewCustomAttributes = "";

		// AttachFilename
		if (!EmptyValue($this->AttachFilename->Upload->DbValue)) {
			$this->AttachFilename->ViewValue = $this->AttachFilename->Upload->DbValue;
		} else {
			$this->AttachFilename->ViewValue = "";
		}
		$this->AttachFilename->ViewCustomAttributes = "";

		// AttachFilenameInitial
		$this->AttachFilenameInitial->ViewValue = $this->AttachFilenameInitial->CurrentValue;
		$this->AttachFilenameInitial->ViewCustomAttributes = "";

		// AttachExtension
		$this->AttachExtension->ViewValue = $this->AttachExtension->CurrentValue;
		$this->AttachExtension->ViewCustomAttributes = "";

		// AttachDescription
		$this->AttachDescription->ViewValue = $this->AttachDescription->CurrentValue;
		$this->AttachDescription->ViewCustomAttributes = "";

		// AttachNotes
		$this->AttachNotes->ViewValue = $this->AttachNotes->CurrentValue;
		$this->AttachNotes->ViewCustomAttributes = "";

		// AttachFilepath
		$this->AttachFilepath->ViewValue = $this->AttachFilepath->CurrentValue;
		$this->AttachFilepath->ViewCustomAttributes = "";

		// AttachPath
		$this->AttachPath->ViewValue = $this->AttachPath->CurrentValue;
		$this->AttachPath->ViewCustomAttributes = "";

		// Notes
		$this->Notes->ViewValue = $this->Notes->CurrentValue;
		$this->Notes->ViewCustomAttributes = "";

		// UserID
		$this->_UserID->ViewValue = $this->_UserID->CurrentValue;
		$this->_UserID->ViewValue = FormatNumber($this->_UserID->ViewValue, 0, -2, -2, -2);
		$this->_UserID->ViewCustomAttributes = "";

		// CreatedBy
		$this->CreatedBy->ViewValue = $this->CreatedBy->CurrentValue;
		$this->CreatedBy->ViewCustomAttributes = "";

		// CreatedDate
		$this->CreatedDate->ViewValue = $this->CreatedDate->CurrentValue;
		$this->CreatedDate->ViewValue = FormatDateTime($this->CreatedDate->ViewValue, 0);
		$this->CreatedDate->ViewCustomAttributes = "";

		// UpdatedBy
		$this->UpdatedBy->ViewValue = $this->UpdatedBy->CurrentValue;
		$this->UpdatedBy->ViewCustomAttributes = "";

		// UpdatedDate
		$this->UpdatedDate->ViewValue = $this->UpdatedDate->CurrentValue;
		$this->UpdatedDate->ViewValue = FormatDateTime($this->UpdatedDate->ViewValue, 0);
		$this->UpdatedDate->ViewCustomAttributes = "";

		// AddedBy
		$this->AddedBy->ViewValue = $this->AddedBy->CurrentValue;
		$this->AddedBy->ViewCustomAttributes = "";

		// AddedDate
		$this->AddedDate->ViewValue = $this->AddedDate->CurrentValue;
		$this->AddedDate->ViewValue = FormatDateTime($this->AddedDate->ViewValue, 0);
		$this->AddedDate->ViewCustomAttributes = "";

		// Case
		$this->_Case->ViewValue = $this->_Case->CurrentValue;
		$this->_Case->ViewCustomAttributes = "";

		// AttachmentID
		$this->AttachmentID->LinkCustomAttributes = "";
		$this->AttachmentID->HrefValue = "";
		$this->AttachmentID->TooltipValue = "";

		// AttachmentSource_ID
		$this->AttachmentSource_ID->LinkCustomAttributes = "";
		$this->AttachmentSource_ID->HrefValue = "";
		$this->AttachmentSource_ID->TooltipValue = "";

		// CaseID
		$this->CaseID->LinkCustomAttributes = "";
		$this->CaseID->HrefValue = "";
		$this->CaseID->TooltipValue = "";

		// EmployeeID
		$this->EmployeeID->LinkCustomAttributes = "";
		$this->EmployeeID->HrefValue = "";
		$this->EmployeeID->TooltipValue = "";

		// AttachID
		$this->AttachID->LinkCustomAttributes = "";
		$this->AttachID->HrefValue = "";
		$this->AttachID->TooltipValue = "";

		// AttachFilename
		$this->AttachFilename->LinkCustomAttributes = "";
		$this->AttachFilename->HrefValue = "";
		$this->AttachFilename->ExportHrefValue = $this->AttachFilename->UploadPath . $this->AttachFilename->Upload->DbValue;
		$this->AttachFilename->TooltipValue = "";

		// AttachFilenameInitial
		$this->AttachFilenameInitial->LinkCustomAttributes = "";
		$this->AttachFilenameInitial->HrefValue = "";
		$this->AttachFilenameInitial->TooltipValue = "";

		// AttachExtension
		$this->AttachExtension->LinkCustomAttributes = "";
		$this->AttachExtension->HrefValue = "";
		$this->AttachExtension->TooltipValue = "";

		// AttachDescription
		$this->AttachDescription->LinkCustomAttributes = "";
		$this->AttachDescription->HrefValue = "";
		$this->AttachDescription->TooltipValue = "";

		// AttachNotes
		$this->AttachNotes->LinkCustomAttributes = "";
		$this->AttachNotes->HrefValue = "";
		$this->AttachNotes->TooltipValue = "";

		// AttachFilepath
		$this->AttachFilepath->LinkCustomAttributes = "";
		$this->AttachFilepath->HrefValue = "";
		$this->AttachFilepath->TooltipValue = "";

		// AttachPath
		$this->AttachPath->LinkCustomAttributes = "";
		$this->AttachPath->HrefValue = "";
		$this->AttachPath->TooltipValue = "";

		// Notes
		$this->Notes->LinkCustomAttributes = "";
		$this->Notes->HrefValue = "";
		$this->Notes->TooltipValue = "";

		// UserID
		$this->_UserID->LinkCustomAttributes = "";
		$this->_UserID->HrefValue = "";
		$this->_UserID->TooltipValue = "";

		// CreatedBy
		$this->CreatedBy->LinkCustomAttributes = "";
		$this->CreatedBy->HrefValue = "";
		$this->CreatedBy->TooltipValue = "";

		// CreatedDate
		$this->CreatedDate->LinkCustomAttributes = "";
		$this->CreatedDate->HrefValue = "";
		$this->CreatedDate->TooltipValue = "";

		// UpdatedBy
		$this->UpdatedBy->LinkCustomAttributes = "";
		$this->UpdatedBy->HrefValue = "";
		$this->UpdatedBy->TooltipValue = "";

		// UpdatedDate
		$this->UpdatedDate->LinkCustomAttributes = "";
		$this->UpdatedDate->HrefValue = "";
		$this->UpdatedDate->TooltipValue = "";

		// AddedBy
		$this->AddedBy->LinkCustomAttributes = "";
		$this->AddedBy->HrefValue = "";
		$this->AddedBy->TooltipValue = "";

		// AddedDate
		$this->AddedDate->LinkCustomAttributes = "";
		$this->AddedDate->HrefValue = "";
		$this->AddedDate->TooltipValue = "";

		// Case
		$this->_Case->LinkCustomAttributes = "";
		$this->_Case->HrefValue = "";
		$this->_Case->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// AttachmentID
		$this->AttachmentID->EditAttrs["class"] = "form-control";
		$this->AttachmentID->EditCustomAttributes = "";
		$this->AttachmentID->EditValue = $this->AttachmentID->CurrentValue;
		$this->AttachmentID->ViewCustomAttributes = "";

		// AttachmentSource_ID
		$this->AttachmentSource_ID->EditAttrs["class"] = "form-control";
		$this->AttachmentSource_ID->EditCustomAttributes = "";
		$this->AttachmentSource_ID->EditValue = $this->AttachmentSource_ID->CurrentValue;
		$this->AttachmentSource_ID->PlaceHolder = RemoveHtml($this->AttachmentSource_ID->caption());

		// CaseID
		$this->CaseID->EditAttrs["class"] = "form-control";
		$this->CaseID->EditCustomAttributes = "";
		if ($this->CaseID->getSessionValue() <> "") {
			$this->CaseID->CurrentValue = $this->CaseID->getSessionValue();
		$this->CaseID->ViewValue = $this->CaseID->CurrentValue;
		$this->CaseID->ViewValue = FormatNumber($this->CaseID->ViewValue, 0, -2, -2, -2);
		$this->CaseID->ViewCustomAttributes = "";
		} else {
		$this->CaseID->EditValue = $this->CaseID->CurrentValue;
		$this->CaseID->PlaceHolder = RemoveHtml($this->CaseID->caption());
		}

		// EmployeeID
		$this->EmployeeID->EditAttrs["class"] = "form-control";
		$this->EmployeeID->EditCustomAttributes = "";
		$this->EmployeeID->EditValue = $this->EmployeeID->CurrentValue;
		$this->EmployeeID->PlaceHolder = RemoveHtml($this->EmployeeID->caption());

		// AttachID
		$this->AttachID->EditAttrs["class"] = "form-control";
		$this->AttachID->EditCustomAttributes = "";
		$this->AttachID->EditValue = $this->AttachID->CurrentValue;
		$this->AttachID->PlaceHolder = RemoveHtml($this->AttachID->caption());

		// AttachFilename
		$this->AttachFilename->EditAttrs["class"] = "form-control";
		$this->AttachFilename->EditCustomAttributes = "";
		if (!EmptyValue($this->AttachFilename->Upload->DbValue)) {
			$this->AttachFilename->EditValue = $this->AttachFilename->Upload->DbValue;
		} else {
			$this->AttachFilename->EditValue = "";
		}
		if (!EmptyValue($this->AttachFilename->CurrentValue))
				$this->AttachFilename->Upload->FileName = $this->AttachFilename->CurrentValue;

		// AttachFilenameInitial
		$this->AttachFilenameInitial->EditAttrs["class"] = "form-control";
		$this->AttachFilenameInitial->EditCustomAttributes = "";
		$this->AttachFilenameInitial->EditValue = $this->AttachFilenameInitial->CurrentValue;
		$this->AttachFilenameInitial->PlaceHolder = RemoveHtml($this->AttachFilenameInitial->caption());

		// AttachExtension
		$this->AttachExtension->EditAttrs["class"] = "form-control";
		$this->AttachExtension->EditCustomAttributes = "";
		$this->AttachExtension->EditValue = $this->AttachExtension->CurrentValue;
		$this->AttachExtension->PlaceHolder = RemoveHtml($this->AttachExtension->caption());

		// AttachDescription
		$this->AttachDescription->EditAttrs["class"] = "form-control";
		$this->AttachDescription->EditCustomAttributes = "";
		$this->AttachDescription->EditValue = $this->AttachDescription->CurrentValue;
		$this->AttachDescription->PlaceHolder = RemoveHtml($this->AttachDescription->caption());

		// AttachNotes
		$this->AttachNotes->EditAttrs["class"] = "form-control";
		$this->AttachNotes->EditCustomAttributes = "";
		$this->AttachNotes->EditValue = $this->AttachNotes->CurrentValue;
		$this->AttachNotes->PlaceHolder = RemoveHtml($this->AttachNotes->caption());

		// AttachFilepath
		$this->AttachFilepath->EditAttrs["class"] = "form-control";
		$this->AttachFilepath->EditCustomAttributes = "";
		$this->AttachFilepath->EditValue = $this->AttachFilepath->CurrentValue;
		$this->AttachFilepath->PlaceHolder = RemoveHtml($this->AttachFilepath->caption());

		// AttachPath
		$this->AttachPath->EditAttrs["class"] = "form-control";
		$this->AttachPath->EditCustomAttributes = "";
		$this->AttachPath->EditValue = $this->AttachPath->CurrentValue;
		$this->AttachPath->PlaceHolder = RemoveHtml($this->AttachPath->caption());

		// Notes
		$this->Notes->EditAttrs["class"] = "form-control";
		$this->Notes->EditCustomAttributes = "";
		$this->Notes->EditValue = $this->Notes->CurrentValue;
		$this->Notes->PlaceHolder = RemoveHtml($this->Notes->caption());

		// UserID
		$this->_UserID->EditAttrs["class"] = "form-control";
		$this->_UserID->EditCustomAttributes = "";
		$this->_UserID->EditValue = $this->_UserID->CurrentValue;
		$this->_UserID->PlaceHolder = RemoveHtml($this->_UserID->caption());

		// CreatedBy
		$this->CreatedBy->EditAttrs["class"] = "form-control";
		$this->CreatedBy->EditCustomAttributes = "";
		$this->CreatedBy->EditValue = $this->CreatedBy->CurrentValue;
		$this->CreatedBy->PlaceHolder = RemoveHtml($this->CreatedBy->caption());

		// CreatedDate
		$this->CreatedDate->EditAttrs["class"] = "form-control";
		$this->CreatedDate->EditCustomAttributes = "";
		$this->CreatedDate->EditValue = FormatDateTime($this->CreatedDate->CurrentValue, 8);
		$this->CreatedDate->PlaceHolder = RemoveHtml($this->CreatedDate->caption());

		// UpdatedBy
		$this->UpdatedBy->EditAttrs["class"] = "form-control";
		$this->UpdatedBy->EditCustomAttributes = "";
		$this->UpdatedBy->EditValue = $this->UpdatedBy->CurrentValue;
		$this->UpdatedBy->PlaceHolder = RemoveHtml($this->UpdatedBy->caption());

		// UpdatedDate
		$this->UpdatedDate->EditAttrs["class"] = "form-control";
		$this->UpdatedDate->EditCustomAttributes = "";
		$this->UpdatedDate->EditValue = FormatDateTime($this->UpdatedDate->CurrentValue, 8);
		$this->UpdatedDate->PlaceHolder = RemoveHtml($this->UpdatedDate->caption());

		// AddedBy
		$this->AddedBy->EditAttrs["class"] = "form-control";
		$this->AddedBy->EditCustomAttributes = "";
		$this->AddedBy->EditValue = $this->AddedBy->CurrentValue;
		$this->AddedBy->PlaceHolder = RemoveHtml($this->AddedBy->caption());

		// AddedDate
		$this->AddedDate->EditAttrs["class"] = "form-control";
		$this->AddedDate->EditCustomAttributes = "";
		$this->AddedDate->EditValue = FormatDateTime($this->AddedDate->CurrentValue, 8);
		$this->AddedDate->PlaceHolder = RemoveHtml($this->AddedDate->caption());

		// Case
		$this->_Case->EditAttrs["class"] = "form-control";
		$this->_Case->EditCustomAttributes = "";
		$this->_Case->EditValue = $this->_Case->CurrentValue;
		$this->_Case->PlaceHolder = RemoveHtml($this->_Case->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->AttachmentID);
					$doc->exportCaption($this->AttachmentSource_ID);
					$doc->exportCaption($this->CaseID);
					$doc->exportCaption($this->EmployeeID);
					$doc->exportCaption($this->AttachID);
					$doc->exportCaption($this->AttachFilename);
					$doc->exportCaption($this->AttachFilenameInitial);
					$doc->exportCaption($this->AttachExtension);
					$doc->exportCaption($this->AttachDescription);
					$doc->exportCaption($this->AttachNotes);
					$doc->exportCaption($this->AttachFilepath);
					$doc->exportCaption($this->AttachPath);
					$doc->exportCaption($this->Notes);
					$doc->exportCaption($this->_Case);
				} else {
					$doc->exportCaption($this->AttachmentID);
					$doc->exportCaption($this->AttachmentSource_ID);
					$doc->exportCaption($this->CaseID);
					$doc->exportCaption($this->EmployeeID);
					$doc->exportCaption($this->AttachID);
					$doc->exportCaption($this->AttachFilename);
					$doc->exportCaption($this->AttachFilenameInitial);
					$doc->exportCaption($this->AttachExtension);
					$doc->exportCaption($this->AttachDescription);
					$doc->exportCaption($this->AttachFilepath);
					$doc->exportCaption($this->AttachPath);
					$doc->exportCaption($this->_Case);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->AttachmentID);
						$doc->exportField($this->AttachmentSource_ID);
						$doc->exportField($this->CaseID);
						$doc->exportField($this->EmployeeID);
						$doc->exportField($this->AttachID);
						$doc->exportField($this->AttachFilename);
						$doc->exportField($this->AttachFilenameInitial);
						$doc->exportField($this->AttachExtension);
						$doc->exportField($this->AttachDescription);
						$doc->exportField($this->AttachNotes);
						$doc->exportField($this->AttachFilepath);
						$doc->exportField($this->AttachPath);
						$doc->exportField($this->Notes);
						$doc->exportField($this->_Case);
					} else {
						$doc->exportField($this->AttachmentID);
						$doc->exportField($this->AttachmentSource_ID);
						$doc->exportField($this->CaseID);
						$doc->exportField($this->EmployeeID);
						$doc->exportField($this->AttachID);
						$doc->exportField($this->AttachFilename);
						$doc->exportField($this->AttachFilenameInitial);
						$doc->exportField($this->AttachExtension);
						$doc->exportField($this->AttachDescription);
						$doc->exportField($this->AttachFilepath);
						$doc->exportField($this->AttachPath);
						$doc->exportField($this->_Case);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		if (!$validRequest)
			return FALSE;

		// Load lookup parameters
		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{
		global $COMPOSITE_KEY_SEPARATOR;

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'AttachFilename') {
			$fldName = "AttachFilename";
			$fileNameFld = "AttachFilename";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up key values
		$ar = explode($COMPOSITE_KEY_SEPARATOR, $key);
		if (count($ar) == 1) {
			$this->AttachmentID->CurrentValue = $ar[0];
		} else {
			return FALSE; // Incorrect key
		}

		// Set up filter (WHERE Clause)
		$filter = $this->getRecordFilter();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype <> "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld <> "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					if ($fileNameFld <> "" && !EmptyValue($rs->fields($fileNameFld)))
						AddHeader("Content-Disposition", "attachment; filename=\"" . $rs->fields($fileNameFld) . "\"");

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Not ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear any debug message
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Write Audit Trail start/end for grid update
	public function writeAuditTrailDummy($typ)
	{
		$table = 'attachments';
		$usr = CurrentUserID();
		WriteAuditTrail("log", DbCurrentDateTime(), ScriptName(), $usr, $typ, $table, "", "", "", "");
	}

	// Write Audit Trail (add page)
	public function writeAuditTrailOnAdd(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnAdd)
			return;
		$table = 'attachments';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['AttachmentID'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$newvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$newvalue = $rs[$fldname];
					else
						$newvalue = "[MEMO]"; // Memo Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$newvalue = "[XML]"; // XML Field
				} else {
					$newvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $usr, "A", $table, $fldname, $key, "", $newvalue);
			}
		}
	}

	// Write Audit Trail (edit page)
	public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
	{
		global $Language;
		if (!$this->AuditTrailOnEdit)
			return;
		$table = 'attachments';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rsold['AttachmentID'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rsnew) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && array_key_exists($fldname, $rsold) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
					$modified = (FormatDateTime($rsold[$fldname], 0) <> FormatDateTime($rsnew[$fldname], 0));
				} else {
					$modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
				}
				if ($modified) {
					if ($this->fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
						$oldvalue = $Language->phrase("PasswordMask");
						$newvalue = $Language->phrase("PasswordMask");
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
						if (AUDIT_TRAIL_TO_DATABASE) {
							$oldvalue = $rsold[$fldname];
							$newvalue = $rsnew[$fldname];
						} else {
							$oldvalue = "[MEMO]";
							$newvalue = "[MEMO]";
						}
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) { // XML field
						$oldvalue = "[XML]";
						$newvalue = "[XML]";
					} else {
						$oldvalue = $rsold[$fldname];
						$newvalue = $rsnew[$fldname];
					}
					WriteAuditTrail("log", $dt, $id, $usr, "U", $table, $fldname, $key, $oldvalue, $newvalue);
				}
			}
		}
	}

	// Write Audit Trail (delete page)
	public function writeAuditTrailOnDelete(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnDelete)
			return;
		$table = 'attachments';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['AttachmentID'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$curUser = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$oldvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$oldvalue = $rs[$fldname];
					else
						$oldvalue = "[MEMO]"; // Memo field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$oldvalue = "[XML]"; // XML field
				} else {
					$oldvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $curUser, "D", $table, $fldname, $key, $oldvalue, "");
			}
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>
