<?php
namespace PHPMaker2019\project_germanos;

/**
 * Page class
 */
class cases_grid extends cases
{

	// Page ID
	public $PageID = "grid";

	// Project ID
	public $ProjectID = "{8D47CED4-FEF0-4756-8F48-9FC38A15AA2A}";

	// Table name
	public $TableName = 'cases';

	// Page object name
	public $PageObjName = "cases_grid";

	// Grid form hidden field names
	public $FormName = "fcasesgrid";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$this->FormActionName .= "_" . $this->FormName;
		$this->FormKeyName .= "_" . $this->FormName;
		$this->FormOldKeyName .= "_" . $this->FormName;
		$this->FormBlankRowName .= "_" . $this->FormName;
		$this->FormKeyCountName .= "_" . $this->FormName;
		$GLOBALS["Grid"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (cases)
		if (!isset($GLOBALS["cases"]) || get_class($GLOBALS["cases"]) == PROJECT_NAMESPACE . "cases") {
			$GLOBALS["cases"] = &$this;

			// $GLOBALS["MasterTable"] = &$GLOBALS["Table"];
			// if (!isset($GLOBALS["Table"]))
			// 	$GLOBALS["Table"] = &$GLOBALS["cases"];

		}
		$this->AddUrl = "casesadd.php";

		// Table object (employees)
		if (!isset($GLOBALS['employees']))
			$GLOBALS['employees'] = new employees();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'grid');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'cases');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new employees();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Export
		global $EXPORT, $cases;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($cases);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}

//		$GLOBALS["Table"] = &$GLOBALS["MasterTable"];
		unset($GLOBALS["Grid"]);
		if ($url === "")
			return;
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['CaseID'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->CaseID->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $ShowOtherOptions = FALSE;
	public $DisplayRecs = 10;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $hearings_Count;
	public $notices_Count;
	public $complaints_Count;
	public $notifications_Count;
	public $attachments_Count;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (IsPasswordExpired())
				$this->terminate(GetUrl("changepwd.php"));
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Update last accessed time
		if ($UserProfile->isValidUser(CurrentUserName(), session_id())) {
		} else {
			Write($Language->phrase("UserProfileCorrupted"));
			$this->terminate();
		}

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();
		$this->CaseID->Visible = FALSE;
		$this->ClientID->setVisibility();
		$this->LitigantID->setVisibility();
		$this->CaseTypeID->setVisibility();
		$this->CourtID->setVisibility();
		$this->CaseNumber->setVisibility();
		$this->FileNumber->setVisibility();
		$this->EnvelopeNumber->Visible = FALSE;
		$this->ClientStatusID->setVisibility();
		$this->LitigantStatusID->setVisibility();
		$this->CourtTypeID->Visible = FALSE;
		$this->CourtGenderID->Visible = FALSE;
		$this->JudgeID->Visible = FALSE;
		$this->Notes->setVisibility();
		$this->FileLocation->Visible = FALSE;
		$this->_Case->Visible = FALSE;
		$this->CaseEn->Visible = FALSE;
		$this->CaseSortID->Visible = FALSE;
		$this->CaseRegisteredDate->Visible = FALSE;
		$this->CaseStatusID->Visible = FALSE;
		$this->ParentCaseID->setVisibility();
		$this->FileNumber2->setVisibility();
		$this->_UserID->Visible = FALSE;
		$this->CreatedBy->Visible = FALSE;
		$this->CreatedDate->Visible = FALSE;
		$this->UpdatedBy->Visible = FALSE;
		$this->UpdatedDate->Visible = FALSE;
		$this->CaseTypeConv->Visible = FALSE;
		$this->CaseConv->Visible = FALSE;
		$this->ClientStatusConv->Visible = FALSE;
		$this->LitigantStatusConv->Visible = FALSE;
		$this->ClientNameConv->Visible = FALSE;
		$this->LitigantNameConv->Visible = FALSE;
		$this->ClientNameConvFiles->setVisibility();
		$this->LitigantNameConvFiles->setVisibility();
		$this->CaseTypeConvFiles->setVisibility();
		$this->CourtConvFiles->Visible = FALSE;
		$this->FileNumberConvFiles->Visible = FALSE;
		$this->CaseNumberConvFiles->Visible = FALSE;
		$this->NotesConvFiles->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up master detail parameters
		$this->setupMasterParms();

		// Setup other options
		$this->setupOtherOptions();

		// Set up lookup cache
		$this->setupLookupOptions($this->ClientID);
		$this->setupLookupOptions($this->LitigantID);
		$this->setupLookupOptions($this->CaseTypeID);
		$this->setupLookupOptions($this->CourtID);
		$this->setupLookupOptions($this->ClientStatusID);
		$this->setupLookupOptions($this->LitigantStatusID);
		$this->setupLookupOptions($this->CourtTypeID);
		$this->setupLookupOptions($this->CourtGenderID);
		$this->setupLookupOptions($this->JudgeID);
		$this->setupLookupOptions($this->CaseSortID);
		$this->setupLookupOptions($this->CaseStatusID);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Show grid delete link for grid add / grid edit
			if ($this->AllowAddDeleteRow) {
				if ($this->isGridAdd() || $this->isGridEdit()) {
					$item = &$this->ListOptions->getItem("griddelete");
					if ($item)
						$item->Visible = TRUE;
				}
			}

			// Set up sorting order
			$this->setupSortOrder();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 10; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records

		// Restore master/detail filter
		$this->DbMasterFilter = $this->getMasterFilter(); // Restore master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Restore detail filter
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Load master record
		if ($this->CurrentMode <> "add" && $this->getMasterFilter() <> "" && $this->getCurrentMasterTable() == "clients") {
			global $clients;
			$rsmaster = $clients->loadRs($this->DbMasterFilter);
			$this->MasterRecordExists = ($rsmaster && !$rsmaster->EOF);
			if (!$this->MasterRecordExists) {
				$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record found
				$this->terminate("clientslist.php"); // Return to master page
			} else {
				$clients->loadListRowValues($rsmaster);
				$clients->RowType = ROWTYPE_MASTER; // Master row
				$clients->renderListRow();
				$rsmaster->close();
			}
		}

		// Load master record
		if ($this->CurrentMode <> "add" && $this->getMasterFilter() <> "" && $this->getCurrentMasterTable() == "litigants") {
			global $litigants;
			$rsmaster = $litigants->loadRs($this->DbMasterFilter);
			$this->MasterRecordExists = ($rsmaster && !$rsmaster->EOF);
			if (!$this->MasterRecordExists) {
				$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record found
				$this->terminate("litigantslist.php"); // Return to master page
			} else {
				$litigants->loadListRowValues($rsmaster);
				$litigants->RowType = ROWTYPE_MASTER; // Master row
				$litigants->renderListRow();
				$rsmaster->close();
			}
		}

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}
		if ($this->isGridAdd()) {
			if ($this->CurrentMode == "copy") {
				$selectLimit = $this->UseSelectLimit;
				if ($selectLimit) {
					$this->TotalRecs = $this->listRecordCount();
					$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);
				} else {
					if ($this->Recordset = $this->loadRecordset())
						$this->TotalRecs = $this->Recordset->RecordCount();
				}
				$this->StartRec = 1;
				$this->DisplayRecs = $this->TotalRecs;
			} else {
				$this->CurrentFilter = "0=1";
				$this->StartRec = 1;
				$this->DisplayRecs = $this->GridAddRowCount;
			}
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			$this->DisplayRecs = $this->TotalRecs; // Display all records
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 10; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Exit inline mode
	protected function clearInlineMode()
	{
		$this->LastAction = $this->CurrentAction; // Save last action
		$this->CurrentAction = ""; // Clear action
		$_SESSION[SESSION_INLINE_MODE] = ""; // Clear inline mode
	}

	// Switch to Grid Add mode
	protected function gridAddMode()
	{
		$this->CurrentAction = "gridadd";
		$_SESSION[SESSION_INLINE_MODE] = "gridadd";
		$this->hideFieldsForAddEdit();
	}

	// Switch to Grid Edit mode
	protected function gridEditMode()
	{
		$this->CurrentAction = "gridedit";
		$_SESSION[SESSION_INLINE_MODE] = "gridedit";
		$this->hideFieldsForAddEdit();
	}

	// Perform update to grid
	public function gridUpdate()
	{
		global $Language, $CurrentForm, $FormError;
		$gridUpdate = TRUE;

		// Get old recordset
		$this->CurrentFilter = $this->buildKeyFilter();
		if ($this->CurrentFilter == "")
			$this->CurrentFilter = "0=1";
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sql)) {
			$rsold = $rs->getRows();
			$rs->close();
		}

		// Call Grid Updating event
		if (!$this->Grid_Updating($rsold)) {
			if ($this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("GridEditCancelled")); // Set grid edit cancelled message
			return FALSE;
		}
		if ($this->AuditTrailOnEdit)
			$this->writeAuditTrailDummy($Language->phrase("BatchUpdateBegin")); // Batch update begin
		$key = "";

		// Update row index and get row key
		$CurrentForm->Index = -1;
		$rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
		if ($rowcnt == "" || !is_numeric($rowcnt))
			$rowcnt = 0;

		// Update all rows based on key
		for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
			$CurrentForm->Index = $rowindex;
			$rowkey = strval($CurrentForm->getValue($this->FormKeyName));
			$rowaction = strval($CurrentForm->getValue($this->FormActionName));

			// Load all values and keys
			if ($rowaction <> "insertdelete") { // Skip insert then deleted rows
				$this->loadFormValues(); // Get form values
				if ($rowaction == "" || $rowaction == "edit" || $rowaction == "delete") {
					$gridUpdate = $this->setupKeyValues($rowkey); // Set up key values
				} else {
					$gridUpdate = TRUE;
				}

				// Skip empty row
				if ($rowaction == "insert" && $this->emptyRow()) {

					// No action required
				// Validate form and insert/update/delete record

				} elseif ($gridUpdate) {
					if ($rowaction == "delete") {
						$this->CurrentFilter = $this->getRecordFilter();
						$gridUpdate = $this->deleteRows(); // Delete this row
					} else if (!$this->validateForm()) {
						$gridUpdate = FALSE; // Form error, reset action
						$this->setFailureMessage($FormError);
					} else {
						if ($rowaction == "insert") {
							$gridUpdate = $this->addRow(); // Insert this row
						} else {
							if ($rowkey <> "") {
								$this->SendEmail = FALSE; // Do not send email on update success
								$gridUpdate = $this->editRow(); // Update this row
							}
						} // End update
					}
				}
				if ($gridUpdate) {
					if ($key <> "")
						$key .= ", ";
					$key .= $rowkey;
				} else {
					break;
				}
			}
		}
		if ($gridUpdate) {

			// Get new recordset
			if ($rs = $conn->execute($sql)) {
				$rsnew = $rs->getRows();
				$rs->close();
			}

			// Call Grid_Updated event
			$this->Grid_Updated($rsold, $rsnew);
			if ($this->AuditTrailOnEdit)
				$this->writeAuditTrailDummy($Language->phrase("BatchUpdateSuccess")); // Batch update success
			$this->clearInlineMode(); // Clear inline edit mode
		} else {
			if ($this->AuditTrailOnEdit)
				$this->writeAuditTrailDummy($Language->phrase("BatchUpdateRollback")); // Batch update rollback
			if ($this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("UpdateFailed")); // Set update failed message
		}
		return $gridUpdate;
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->CaseID->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->CaseID->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Perform Grid Add
	public function gridInsert()
	{
		global $Language, $CurrentForm, $FormError;
		$rowindex = 1;
		$gridInsert = FALSE;
		$conn = &$this->getConnection();

		// Call Grid Inserting event
		if (!$this->Grid_Inserting()) {
			if ($this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("GridAddCancelled")); // Set grid add cancelled message
			return FALSE;
		}

		// Init key filter
		$wrkfilter = "";
		$addcnt = 0;
		if ($this->AuditTrailOnAdd)
			$this->writeAuditTrailDummy($Language->phrase("BatchInsertBegin")); // Batch insert begin
		$key = "";

		// Get row count
		$CurrentForm->Index = -1;
		$rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
		if ($rowcnt == "" || !is_numeric($rowcnt))
			$rowcnt = 0;

		// Insert all rows
		for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {

			// Load current row values
			$CurrentForm->Index = $rowindex;
			$rowaction = strval($CurrentForm->getValue($this->FormActionName));
			if ($rowaction <> "" && $rowaction <> "insert")
				continue; // Skip
			if ($rowaction == "insert") {
				$this->RowOldKey = strval($CurrentForm->getValue($this->FormOldKeyName));
				$this->loadOldRecord(); // Load old record
			}
			$this->loadFormValues(); // Get form values
			if (!$this->emptyRow()) {
				$addcnt++;
				$this->SendEmail = FALSE; // Do not send email on insert success

				// Validate form
				if (!$this->validateForm()) {
					$gridInsert = FALSE; // Form error, reset action
					$this->setFailureMessage($FormError);
				} else {
					$gridInsert = $this->addRow($this->OldRecordset); // Insert this row
				}
				if ($gridInsert) {
					if ($key <> "")
						$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
					$key .= $this->CaseID->CurrentValue;

					// Add filter for this record
					$filter = $this->getRecordFilter();
					if ($wrkfilter <> "")
						$wrkfilter .= " OR ";
					$wrkfilter .= $filter;
				} else {
					break;
				}
			}
		}
		if ($addcnt == 0) { // No record inserted
			$this->clearInlineMode(); // Clear grid add mode and return
			return TRUE;
		}
		if ($gridInsert) {

			// Get new recordset
			$this->CurrentFilter = $wrkfilter;
			$sql = $this->getCurrentSql();
			if ($rs = $conn->execute($sql)) {
				$rsnew = $rs->getRows();
				$rs->close();
			}

			// Call Grid_Inserted event
			$this->Grid_Inserted($rsnew);
			if ($this->AuditTrailOnAdd)
				$this->writeAuditTrailDummy($Language->phrase("BatchInsertSuccess")); // Batch insert success
			$this->clearInlineMode(); // Clear grid add mode
		} else {
			if ($this->AuditTrailOnAdd)
				$this->writeAuditTrailDummy($Language->phrase("BatchInsertRollback")); // Batch insert rollback
			if ($this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("InsertFailed")); // Set insert failed message
		}
		return $gridInsert;
	}

	// Check if empty row
	public function emptyRow()
	{
		global $CurrentForm;
		if ($CurrentForm->hasValue("x_ClientID") && $CurrentForm->hasValue("o_ClientID") && $this->ClientID->CurrentValue <> $this->ClientID->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_LitigantID") && $CurrentForm->hasValue("o_LitigantID") && $this->LitigantID->CurrentValue <> $this->LitigantID->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_CaseTypeID") && $CurrentForm->hasValue("o_CaseTypeID") && $this->CaseTypeID->CurrentValue <> $this->CaseTypeID->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_CourtID") && $CurrentForm->hasValue("o_CourtID") && $this->CourtID->CurrentValue <> $this->CourtID->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_CaseNumber") && $CurrentForm->hasValue("o_CaseNumber") && $this->CaseNumber->CurrentValue <> $this->CaseNumber->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_FileNumber") && $CurrentForm->hasValue("o_FileNumber") && $this->FileNumber->CurrentValue <> $this->FileNumber->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_ClientStatusID") && $CurrentForm->hasValue("o_ClientStatusID") && $this->ClientStatusID->CurrentValue <> $this->ClientStatusID->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_LitigantStatusID") && $CurrentForm->hasValue("o_LitigantStatusID") && $this->LitigantStatusID->CurrentValue <> $this->LitigantStatusID->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_Notes") && $CurrentForm->hasValue("o_Notes") && $this->Notes->CurrentValue <> $this->Notes->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_ParentCaseID") && $CurrentForm->hasValue("o_ParentCaseID") && $this->ParentCaseID->CurrentValue <> $this->ParentCaseID->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_FileNumber2") && $CurrentForm->hasValue("o_FileNumber2") && $this->FileNumber2->CurrentValue <> $this->FileNumber2->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_ClientNameConvFiles") && $CurrentForm->hasValue("o_ClientNameConvFiles") && $this->ClientNameConvFiles->CurrentValue <> $this->ClientNameConvFiles->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_LitigantNameConvFiles") && $CurrentForm->hasValue("o_LitigantNameConvFiles") && $this->LitigantNameConvFiles->CurrentValue <> $this->LitigantNameConvFiles->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_CaseTypeConvFiles") && $CurrentForm->hasValue("o_CaseTypeConvFiles") && $this->CaseTypeConvFiles->CurrentValue <> $this->CaseTypeConvFiles->OldValue)
			return FALSE;
		return TRUE;
	}

	// Validate grid form
	public function validateGridForm()
	{
		global $CurrentForm;

		// Get row count
		$CurrentForm->Index = -1;
		$rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
		if ($rowcnt == "" || !is_numeric($rowcnt))
			$rowcnt = 0;

		// Validate all records
		for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {

			// Load current row values
			$CurrentForm->Index = $rowindex;
			$rowaction = strval($CurrentForm->getValue($this->FormActionName));
			if ($rowaction <> "delete" && $rowaction <> "insertdelete") {
				$this->loadFormValues(); // Get form values
				if ($rowaction == "insert" && $this->emptyRow()) {

					// Ignore
				} else if (!$this->validateForm()) {
					return FALSE;
				}
			}
		}
		return TRUE;
	}

	// Get all form values of the grid
	public function getGridFormValues()
	{
		global $CurrentForm;

		// Get row count
		$CurrentForm->Index = -1;
		$rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
		if ($rowcnt == "" || !is_numeric($rowcnt))
			$rowcnt = 0;
		$rows = array();

		// Loop through all records
		for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {

			// Load current row values
			$CurrentForm->Index = $rowindex;
			$rowaction = strval($CurrentForm->getValue($this->FormActionName));
			if ($rowaction <> "delete" && $rowaction <> "insertdelete") {
				$this->loadFormValues(); // Get form values
				if ($rowaction == "insert" && $this->emptyRow()) {

					// Ignore
				} else {
					$rows[] = $this->getFieldValues("FormValue"); // Return row as array
				}
			}
		}
		return $rows; // Return as array of array
	}

	// Restore form values for current row
	public function restoreCurrentRowFormValues($idx)
	{
		global $CurrentForm;

		// Get row based on current index
		$CurrentForm->Index = $idx;
		$this->loadFormValues(); // Load form values
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset master/detail keys
			if ($this->Command == "resetall") {
				$this->setCurrentMasterTable(""); // Clear master table
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
				$this->ClientID->setSessionValue("");
				$this->LitigantID->setSessionValue("");
			}

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->setSessionOrderByList($orderBy);
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// "griddelete"
		if ($this->AllowAddDeleteRow) {
			$item = &$this->ListOptions->add("griddelete");
			$item->CssClass = "text-nowrap";
			$item->OnLeft = TRUE;
			$item->Visible = FALSE; // Default hidden
		}

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canEdit();
		$item->OnLeft = TRUE;

		// "copy"
		$item = &$this->ListOptions->add("copy");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canAdd();
		$item->OnLeft = TRUE;

		// "delete"
		$item = &$this->ListOptions->add("delete");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canDelete();
		$item->OnLeft = TRUE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// Set up row action and key
		if (is_numeric($this->RowIndex) && $this->CurrentMode <> "view") {
			$CurrentForm->Index = $this->RowIndex;
			$actionName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormActionName);
			$oldKeyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormOldKeyName);
			$keyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormKeyName);
			$blankRowName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormBlankRowName);
			if ($this->RowAction <> "")
				$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $actionName . "\" id=\"" . $actionName . "\" value=\"" . $this->RowAction . "\">";
			if ($CurrentForm->hasValue($this->FormOldKeyName))
				$this->RowOldKey = strval($CurrentForm->getValue($this->FormOldKeyName));
			if ($this->RowOldKey <> "")
				$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $oldKeyName . "\" id=\"" . $oldKeyName . "\" value=\"" . HtmlEncode($this->RowOldKey) . "\">";
			if ($this->RowAction == "delete") {
				$rowkey = $CurrentForm->getValue($this->FormKeyName);
				$this->setupKeyValues($rowkey);
			}
			if ($this->RowAction == "insert" && $this->isConfirm() && $this->emptyRow())
				$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $blankRowName . "\" id=\"" . $blankRowName . "\" value=\"1\">";
		}

		// "delete"
		if ($this->AllowAddDeleteRow) {
			if ($this->CurrentMode == "add" || $this->CurrentMode == "copy" || $this->CurrentMode == "edit") {
				$options = &$this->ListOptions;
				$options->UseButtonGroup = TRUE; // Use button group for grid delete button
				$opt = &$options->Items["griddelete"];
				if (!$Security->canDelete() && is_numeric($this->RowIndex) && ($this->RowAction == "" || $this->RowAction == "edit")) { // Do not allow delete existing record
					$opt->Body = "&nbsp;";
				} else {
					$opt->Body = "<a class=\"ew-grid-link ew-grid-delete\" title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" onclick=\"return ew.deleteGridRow(this, " . $this->RowIndex . ");\">" . $Language->phrase("DeleteLink") . "</a>";
				}
			}
		}
		if ($this->CurrentMode == "view") { // View mode

		// "view"
		$opt = &$this->ListOptions->Items["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->canView()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "edit"
		$opt = &$this->ListOptions->Items["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->canEdit()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "copy"
		$opt = &$this->ListOptions->Items["copy"];
		$copycaption = HtmlTitle($Language->phrase("CopyLink"));
		if ($Security->canAdd()) {
			$opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("CopyLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "delete"
		$opt = &$this->ListOptions->Items["delete"];
		if ($Security->canDelete())
			$opt->Body = "<a class=\"ew-row-link ew-delete\"" . "" . " title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" href=\"" . HtmlEncode($this->DeleteUrl) . "\">" . $Language->phrase("DeleteLink") . "</a>";
		else
			$opt->Body = "";
		} // End View mode
		if ($this->CurrentMode == "edit" && is_numeric($this->RowIndex)) {
			$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $keyName . "\" id=\"" . $keyName . "\" value=\"" . $this->CaseID->CurrentValue . "\">";
		}
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set record key
	public function setRecordKey(&$key, $rs)
	{
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs->fields('CaseID');
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$option = &$this->OtherOptions["addedit"];
		$option->UseDropDownButton = FALSE;
		$option->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$option->UseButtonGroup = TRUE;

		//$option->ButtonClass = ""; // Class for button group
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Add
		if ($this->CurrentMode == "view") { // Check view mode
			$item = &$option->add("add");
			$addcaption = HtmlTitle($Language->phrase("AddLink"));
			$this->AddUrl = $this->getAddUrl();
			$item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("AddLink") . "</a>";
			$item->Visible = ($this->AddUrl <> "" && $Security->canAdd());
		}
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		if (($this->CurrentMode == "add" || $this->CurrentMode == "copy" || $this->CurrentMode == "edit") && !$this->isConfirm()) { // Check add/copy/edit mode
			if ($this->AllowAddDeleteRow) {
				$option = &$options["addedit"];
				$option->UseDropDownButton = FALSE;
				$item = &$option->add("addblankrow");
				$item->Body = "<a class=\"ew-add-edit ew-add-blank-row\" title=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" href=\"javascript:void(0);\" onclick=\"ew.addGridRow(this);\">" . $Language->phrase("AddBlankRow") . "</a>";
				$item->Visible = $Security->canAdd();
				$this->ShowOtherOptions = $item->Visible;
			}
		}
		if ($this->CurrentMode == "view") { // Check view mode
			$option = &$options["addedit"];
			$item = &$option->getItem("add");
			$this->ShowOtherOptions = $item && $item->Visible;
		}
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->CaseID->CurrentValue = NULL;
		$this->CaseID->OldValue = $this->CaseID->CurrentValue;
		$this->ClientID->CurrentValue = NULL;
		$this->ClientID->OldValue = $this->ClientID->CurrentValue;
		$this->LitigantID->CurrentValue = 1938;
		$this->LitigantID->OldValue = $this->LitigantID->CurrentValue;
		$this->CaseTypeID->CurrentValue = NULL;
		$this->CaseTypeID->OldValue = $this->CaseTypeID->CurrentValue;
		$this->CourtID->CurrentValue = NULL;
		$this->CourtID->OldValue = $this->CourtID->CurrentValue;
		$this->CaseNumber->CurrentValue = NULL;
		$this->CaseNumber->OldValue = $this->CaseNumber->CurrentValue;
		$this->FileNumber->CurrentValue = NULL;
		$this->FileNumber->OldValue = $this->FileNumber->CurrentValue;
		$this->EnvelopeNumber->CurrentValue = NULL;
		$this->EnvelopeNumber->OldValue = $this->EnvelopeNumber->CurrentValue;
		$this->ClientStatusID->CurrentValue = 10;
		$this->ClientStatusID->OldValue = $this->ClientStatusID->CurrentValue;
		$this->LitigantStatusID->CurrentValue = 10;
		$this->LitigantStatusID->OldValue = $this->LitigantStatusID->CurrentValue;
		$this->CourtTypeID->CurrentValue = NULL;
		$this->CourtTypeID->OldValue = $this->CourtTypeID->CurrentValue;
		$this->CourtGenderID->CurrentValue = NULL;
		$this->CourtGenderID->OldValue = $this->CourtGenderID->CurrentValue;
		$this->JudgeID->CurrentValue = NULL;
		$this->JudgeID->OldValue = $this->JudgeID->CurrentValue;
		$this->Notes->CurrentValue = NULL;
		$this->Notes->OldValue = $this->Notes->CurrentValue;
		$this->FileLocation->CurrentValue = NULL;
		$this->FileLocation->OldValue = $this->FileLocation->CurrentValue;
		$this->_Case->CurrentValue = NULL;
		$this->_Case->OldValue = $this->_Case->CurrentValue;
		$this->CaseEn->CurrentValue = NULL;
		$this->CaseEn->OldValue = $this->CaseEn->CurrentValue;
		$this->CaseSortID->CurrentValue = 1;
		$this->CaseSortID->OldValue = $this->CaseSortID->CurrentValue;
		$this->CaseRegisteredDate->CurrentValue = NULL;
		$this->CaseRegisteredDate->OldValue = $this->CaseRegisteredDate->CurrentValue;
		$this->CaseStatusID->CurrentValue = 1;
		$this->CaseStatusID->OldValue = $this->CaseStatusID->CurrentValue;
		$this->ParentCaseID->CurrentValue = NULL;
		$this->ParentCaseID->OldValue = $this->ParentCaseID->CurrentValue;
		$this->FileNumber2->CurrentValue = NULL;
		$this->FileNumber2->OldValue = $this->FileNumber2->CurrentValue;
		$this->_UserID->CurrentValue = NULL;
		$this->_UserID->OldValue = $this->_UserID->CurrentValue;
		$this->CreatedBy->CurrentValue = NULL;
		$this->CreatedBy->OldValue = $this->CreatedBy->CurrentValue;
		$this->CreatedDate->CurrentValue = NULL;
		$this->CreatedDate->OldValue = $this->CreatedDate->CurrentValue;
		$this->UpdatedBy->CurrentValue = NULL;
		$this->UpdatedBy->OldValue = $this->UpdatedBy->CurrentValue;
		$this->UpdatedDate->CurrentValue = NULL;
		$this->UpdatedDate->OldValue = $this->UpdatedDate->CurrentValue;
		$this->CaseTypeConv->CurrentValue = NULL;
		$this->CaseTypeConv->OldValue = $this->CaseTypeConv->CurrentValue;
		$this->CaseConv->CurrentValue = NULL;
		$this->CaseConv->OldValue = $this->CaseConv->CurrentValue;
		$this->ClientStatusConv->CurrentValue = NULL;
		$this->ClientStatusConv->OldValue = $this->ClientStatusConv->CurrentValue;
		$this->LitigantStatusConv->CurrentValue = NULL;
		$this->LitigantStatusConv->OldValue = $this->LitigantStatusConv->CurrentValue;
		$this->ClientNameConv->CurrentValue = NULL;
		$this->ClientNameConv->OldValue = $this->ClientNameConv->CurrentValue;
		$this->LitigantNameConv->CurrentValue = NULL;
		$this->LitigantNameConv->OldValue = $this->LitigantNameConv->CurrentValue;
		$this->ClientNameConvFiles->CurrentValue = NULL;
		$this->ClientNameConvFiles->OldValue = $this->ClientNameConvFiles->CurrentValue;
		$this->LitigantNameConvFiles->CurrentValue = NULL;
		$this->LitigantNameConvFiles->OldValue = $this->LitigantNameConvFiles->CurrentValue;
		$this->CaseTypeConvFiles->CurrentValue = NULL;
		$this->CaseTypeConvFiles->OldValue = $this->CaseTypeConvFiles->CurrentValue;
		$this->CourtConvFiles->CurrentValue = NULL;
		$this->CourtConvFiles->OldValue = $this->CourtConvFiles->CurrentValue;
		$this->FileNumberConvFiles->CurrentValue = NULL;
		$this->FileNumberConvFiles->OldValue = $this->FileNumberConvFiles->CurrentValue;
		$this->CaseNumberConvFiles->CurrentValue = NULL;
		$this->CaseNumberConvFiles->OldValue = $this->CaseNumberConvFiles->CurrentValue;
		$this->NotesConvFiles->CurrentValue = NULL;
		$this->NotesConvFiles->OldValue = $this->NotesConvFiles->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;
		$CurrentForm->FormName = $this->FormName;

		// Check field name 'ClientID' first before field var 'x_ClientID'
		$val = $CurrentForm->hasValue("ClientID") ? $CurrentForm->getValue("ClientID") : $CurrentForm->getValue("x_ClientID");
		if (!$this->ClientID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ClientID->Visible = FALSE; // Disable update for API request
			else
				$this->ClientID->setFormValue($val);
		}
		$this->ClientID->setOldValue($CurrentForm->getValue("o_ClientID"));

		// Check field name 'LitigantID' first before field var 'x_LitigantID'
		$val = $CurrentForm->hasValue("LitigantID") ? $CurrentForm->getValue("LitigantID") : $CurrentForm->getValue("x_LitigantID");
		if (!$this->LitigantID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->LitigantID->Visible = FALSE; // Disable update for API request
			else
				$this->LitigantID->setFormValue($val);
		}
		$this->LitigantID->setOldValue($CurrentForm->getValue("o_LitigantID"));

		// Check field name 'CaseTypeID' first before field var 'x_CaseTypeID'
		$val = $CurrentForm->hasValue("CaseTypeID") ? $CurrentForm->getValue("CaseTypeID") : $CurrentForm->getValue("x_CaseTypeID");
		if (!$this->CaseTypeID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CaseTypeID->Visible = FALSE; // Disable update for API request
			else
				$this->CaseTypeID->setFormValue($val);
		}
		$this->CaseTypeID->setOldValue($CurrentForm->getValue("o_CaseTypeID"));

		// Check field name 'CourtID' first before field var 'x_CourtID'
		$val = $CurrentForm->hasValue("CourtID") ? $CurrentForm->getValue("CourtID") : $CurrentForm->getValue("x_CourtID");
		if (!$this->CourtID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CourtID->Visible = FALSE; // Disable update for API request
			else
				$this->CourtID->setFormValue($val);
		}
		$this->CourtID->setOldValue($CurrentForm->getValue("o_CourtID"));

		// Check field name 'CaseNumber' first before field var 'x_CaseNumber'
		$val = $CurrentForm->hasValue("CaseNumber") ? $CurrentForm->getValue("CaseNumber") : $CurrentForm->getValue("x_CaseNumber");
		if (!$this->CaseNumber->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CaseNumber->Visible = FALSE; // Disable update for API request
			else
				$this->CaseNumber->setFormValue($val);
		}
		$this->CaseNumber->setOldValue($CurrentForm->getValue("o_CaseNumber"));

		// Check field name 'FileNumber' first before field var 'x_FileNumber'
		$val = $CurrentForm->hasValue("FileNumber") ? $CurrentForm->getValue("FileNumber") : $CurrentForm->getValue("x_FileNumber");
		if (!$this->FileNumber->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->FileNumber->Visible = FALSE; // Disable update for API request
			else
				$this->FileNumber->setFormValue($val);
		}
		$this->FileNumber->setOldValue($CurrentForm->getValue("o_FileNumber"));

		// Check field name 'ClientStatusID' first before field var 'x_ClientStatusID'
		$val = $CurrentForm->hasValue("ClientStatusID") ? $CurrentForm->getValue("ClientStatusID") : $CurrentForm->getValue("x_ClientStatusID");
		if (!$this->ClientStatusID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ClientStatusID->Visible = FALSE; // Disable update for API request
			else
				$this->ClientStatusID->setFormValue($val);
		}
		$this->ClientStatusID->setOldValue($CurrentForm->getValue("o_ClientStatusID"));

		// Check field name 'LitigantStatusID' first before field var 'x_LitigantStatusID'
		$val = $CurrentForm->hasValue("LitigantStatusID") ? $CurrentForm->getValue("LitigantStatusID") : $CurrentForm->getValue("x_LitigantStatusID");
		if (!$this->LitigantStatusID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->LitigantStatusID->Visible = FALSE; // Disable update for API request
			else
				$this->LitigantStatusID->setFormValue($val);
		}
		$this->LitigantStatusID->setOldValue($CurrentForm->getValue("o_LitigantStatusID"));

		// Check field name 'Notes' first before field var 'x_Notes'
		$val = $CurrentForm->hasValue("Notes") ? $CurrentForm->getValue("Notes") : $CurrentForm->getValue("x_Notes");
		if (!$this->Notes->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Notes->Visible = FALSE; // Disable update for API request
			else
				$this->Notes->setFormValue($val);
		}
		$this->Notes->setOldValue($CurrentForm->getValue("o_Notes"));

		// Check field name 'ParentCaseID' first before field var 'x_ParentCaseID'
		$val = $CurrentForm->hasValue("ParentCaseID") ? $CurrentForm->getValue("ParentCaseID") : $CurrentForm->getValue("x_ParentCaseID");
		if (!$this->ParentCaseID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ParentCaseID->Visible = FALSE; // Disable update for API request
			else
				$this->ParentCaseID->setFormValue($val);
		}
		$this->ParentCaseID->setOldValue($CurrentForm->getValue("o_ParentCaseID"));

		// Check field name 'FileNumber2' first before field var 'x_FileNumber2'
		$val = $CurrentForm->hasValue("FileNumber2") ? $CurrentForm->getValue("FileNumber2") : $CurrentForm->getValue("x_FileNumber2");
		if (!$this->FileNumber2->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->FileNumber2->Visible = FALSE; // Disable update for API request
			else
				$this->FileNumber2->setFormValue($val);
		}
		$this->FileNumber2->setOldValue($CurrentForm->getValue("o_FileNumber2"));

		// Check field name 'ClientNameConvFiles' first before field var 'x_ClientNameConvFiles'
		$val = $CurrentForm->hasValue("ClientNameConvFiles") ? $CurrentForm->getValue("ClientNameConvFiles") : $CurrentForm->getValue("x_ClientNameConvFiles");
		if (!$this->ClientNameConvFiles->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ClientNameConvFiles->Visible = FALSE; // Disable update for API request
			else
				$this->ClientNameConvFiles->setFormValue($val);
		}
		$this->ClientNameConvFiles->setOldValue($CurrentForm->getValue("o_ClientNameConvFiles"));

		// Check field name 'LitigantNameConvFiles' first before field var 'x_LitigantNameConvFiles'
		$val = $CurrentForm->hasValue("LitigantNameConvFiles") ? $CurrentForm->getValue("LitigantNameConvFiles") : $CurrentForm->getValue("x_LitigantNameConvFiles");
		if (!$this->LitigantNameConvFiles->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->LitigantNameConvFiles->Visible = FALSE; // Disable update for API request
			else
				$this->LitigantNameConvFiles->setFormValue($val);
		}
		$this->LitigantNameConvFiles->setOldValue($CurrentForm->getValue("o_LitigantNameConvFiles"));

		// Check field name 'CaseTypeConvFiles' first before field var 'x_CaseTypeConvFiles'
		$val = $CurrentForm->hasValue("CaseTypeConvFiles") ? $CurrentForm->getValue("CaseTypeConvFiles") : $CurrentForm->getValue("x_CaseTypeConvFiles");
		if (!$this->CaseTypeConvFiles->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CaseTypeConvFiles->Visible = FALSE; // Disable update for API request
			else
				$this->CaseTypeConvFiles->setFormValue($val);
		}
		$this->CaseTypeConvFiles->setOldValue($CurrentForm->getValue("o_CaseTypeConvFiles"));

		// Check field name 'CaseID' first before field var 'x_CaseID'
		$val = $CurrentForm->hasValue("CaseID") ? $CurrentForm->getValue("CaseID") : $CurrentForm->getValue("x_CaseID");
		if (!$this->CaseID->IsDetailKey && !$this->isGridAdd() && !$this->isAdd())
			$this->CaseID->setFormValue($val);
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		if (!$this->isGridAdd() && !$this->isAdd())
			$this->CaseID->CurrentValue = $this->CaseID->FormValue;
		$this->ClientID->CurrentValue = $this->ClientID->FormValue;
		$this->LitigantID->CurrentValue = $this->LitigantID->FormValue;
		$this->CaseTypeID->CurrentValue = $this->CaseTypeID->FormValue;
		$this->CourtID->CurrentValue = $this->CourtID->FormValue;
		$this->CaseNumber->CurrentValue = $this->CaseNumber->FormValue;
		$this->FileNumber->CurrentValue = $this->FileNumber->FormValue;
		$this->ClientStatusID->CurrentValue = $this->ClientStatusID->FormValue;
		$this->LitigantStatusID->CurrentValue = $this->LitigantStatusID->FormValue;
		$this->Notes->CurrentValue = $this->Notes->FormValue;
		$this->ParentCaseID->CurrentValue = $this->ParentCaseID->FormValue;
		$this->FileNumber2->CurrentValue = $this->FileNumber2->FormValue;
		$this->ClientNameConvFiles->CurrentValue = $this->ClientNameConvFiles->FormValue;
		$this->LitigantNameConvFiles->CurrentValue = $this->LitigantNameConvFiles->FormValue;
		$this->CaseTypeConvFiles->CurrentValue = $this->CaseTypeConvFiles->FormValue;
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->CaseID->setDbValue($row['CaseID']);
		$this->ClientID->setDbValue($row['ClientID']);
		if (array_key_exists('EV__ClientID', $rs->fields)) {
			$this->ClientID->VirtualValue = $rs->fields('EV__ClientID'); // Set up virtual field value
		} else {
			$this->ClientID->VirtualValue = ""; // Clear value
		}
		$this->LitigantID->setDbValue($row['LitigantID']);
		if (array_key_exists('EV__LitigantID', $rs->fields)) {
			$this->LitigantID->VirtualValue = $rs->fields('EV__LitigantID'); // Set up virtual field value
		} else {
			$this->LitigantID->VirtualValue = ""; // Clear value
		}
		$this->CaseTypeID->setDbValue($row['CaseTypeID']);
		if (array_key_exists('EV__CaseTypeID', $rs->fields)) {
			$this->CaseTypeID->VirtualValue = $rs->fields('EV__CaseTypeID'); // Set up virtual field value
		} else {
			$this->CaseTypeID->VirtualValue = ""; // Clear value
		}
		$this->CourtID->setDbValue($row['CourtID']);
		if (array_key_exists('EV__CourtID', $rs->fields)) {
			$this->CourtID->VirtualValue = $rs->fields('EV__CourtID'); // Set up virtual field value
		} else {
			$this->CourtID->VirtualValue = ""; // Clear value
		}
		$this->CaseNumber->setDbValue($row['CaseNumber']);
		$this->FileNumber->setDbValue($row['FileNumber']);
		$this->EnvelopeNumber->setDbValue($row['EnvelopeNumber']);
		$this->ClientStatusID->setDbValue($row['ClientStatusID']);
		if (array_key_exists('EV__ClientStatusID', $rs->fields)) {
			$this->ClientStatusID->VirtualValue = $rs->fields('EV__ClientStatusID'); // Set up virtual field value
		} else {
			$this->ClientStatusID->VirtualValue = ""; // Clear value
		}
		$this->LitigantStatusID->setDbValue($row['LitigantStatusID']);
		if (array_key_exists('EV__LitigantStatusID', $rs->fields)) {
			$this->LitigantStatusID->VirtualValue = $rs->fields('EV__LitigantStatusID'); // Set up virtual field value
		} else {
			$this->LitigantStatusID->VirtualValue = ""; // Clear value
		}
		$this->CourtTypeID->setDbValue($row['CourtTypeID']);
		if (array_key_exists('EV__CourtTypeID', $rs->fields)) {
			$this->CourtTypeID->VirtualValue = $rs->fields('EV__CourtTypeID'); // Set up virtual field value
		} else {
			$this->CourtTypeID->VirtualValue = ""; // Clear value
		}
		$this->CourtGenderID->setDbValue($row['CourtGenderID']);
		if (array_key_exists('EV__CourtGenderID', $rs->fields)) {
			$this->CourtGenderID->VirtualValue = $rs->fields('EV__CourtGenderID'); // Set up virtual field value
		} else {
			$this->CourtGenderID->VirtualValue = ""; // Clear value
		}
		$this->JudgeID->setDbValue($row['JudgeID']);
		if (array_key_exists('EV__JudgeID', $rs->fields)) {
			$this->JudgeID->VirtualValue = $rs->fields('EV__JudgeID'); // Set up virtual field value
		} else {
			$this->JudgeID->VirtualValue = ""; // Clear value
		}
		$this->Notes->setDbValue($row['Notes']);
		$this->FileLocation->setDbValue($row['FileLocation']);
		$this->_Case->setDbValue($row['Case']);
		$this->CaseEn->setDbValue($row['CaseEn']);
		$this->CaseSortID->setDbValue($row['CaseSortID']);
		if (array_key_exists('EV__CaseSortID', $rs->fields)) {
			$this->CaseSortID->VirtualValue = $rs->fields('EV__CaseSortID'); // Set up virtual field value
		} else {
			$this->CaseSortID->VirtualValue = ""; // Clear value
		}
		$this->CaseRegisteredDate->setDbValue($row['CaseRegisteredDate']);
		$this->CaseStatusID->setDbValue($row['CaseStatusID']);
		if (array_key_exists('EV__CaseStatusID', $rs->fields)) {
			$this->CaseStatusID->VirtualValue = $rs->fields('EV__CaseStatusID'); // Set up virtual field value
		} else {
			$this->CaseStatusID->VirtualValue = ""; // Clear value
		}
		$this->ParentCaseID->setDbValue($row['ParentCaseID']);
		$this->FileNumber2->setDbValue($row['FileNumber2']);
		$this->_UserID->setDbValue($row['UserID']);
		$this->CreatedBy->setDbValue($row['CreatedBy']);
		$this->CreatedDate->setDbValue($row['CreatedDate']);
		$this->UpdatedBy->setDbValue($row['UpdatedBy']);
		$this->UpdatedDate->setDbValue($row['UpdatedDate']);
		$this->CaseTypeConv->setDbValue($row['CaseTypeConv']);
		$this->CaseConv->setDbValue($row['CaseConv']);
		$this->ClientStatusConv->setDbValue($row['ClientStatusConv']);
		$this->LitigantStatusConv->setDbValue($row['LitigantStatusConv']);
		$this->ClientNameConv->setDbValue($row['ClientNameConv']);
		$this->LitigantNameConv->setDbValue($row['LitigantNameConv']);
		$this->ClientNameConvFiles->setDbValue($row['ClientNameConvFiles']);
		$this->LitigantNameConvFiles->setDbValue($row['LitigantNameConvFiles']);
		$this->CaseTypeConvFiles->setDbValue($row['CaseTypeConvFiles']);
		$this->CourtConvFiles->setDbValue($row['CourtConvFiles']);
		$this->FileNumberConvFiles->setDbValue($row['FileNumberConvFiles']);
		$this->CaseNumberConvFiles->setDbValue($row['CaseNumberConvFiles']);
		$this->NotesConvFiles->setDbValue($row['NotesConvFiles']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['CaseID'] = $this->CaseID->CurrentValue;
		$row['ClientID'] = $this->ClientID->CurrentValue;
		$row['LitigantID'] = $this->LitigantID->CurrentValue;
		$row['CaseTypeID'] = $this->CaseTypeID->CurrentValue;
		$row['CourtID'] = $this->CourtID->CurrentValue;
		$row['CaseNumber'] = $this->CaseNumber->CurrentValue;
		$row['FileNumber'] = $this->FileNumber->CurrentValue;
		$row['EnvelopeNumber'] = $this->EnvelopeNumber->CurrentValue;
		$row['ClientStatusID'] = $this->ClientStatusID->CurrentValue;
		$row['LitigantStatusID'] = $this->LitigantStatusID->CurrentValue;
		$row['CourtTypeID'] = $this->CourtTypeID->CurrentValue;
		$row['CourtGenderID'] = $this->CourtGenderID->CurrentValue;
		$row['JudgeID'] = $this->JudgeID->CurrentValue;
		$row['Notes'] = $this->Notes->CurrentValue;
		$row['FileLocation'] = $this->FileLocation->CurrentValue;
		$row['Case'] = $this->_Case->CurrentValue;
		$row['CaseEn'] = $this->CaseEn->CurrentValue;
		$row['CaseSortID'] = $this->CaseSortID->CurrentValue;
		$row['CaseRegisteredDate'] = $this->CaseRegisteredDate->CurrentValue;
		$row['CaseStatusID'] = $this->CaseStatusID->CurrentValue;
		$row['ParentCaseID'] = $this->ParentCaseID->CurrentValue;
		$row['FileNumber2'] = $this->FileNumber2->CurrentValue;
		$row['UserID'] = $this->_UserID->CurrentValue;
		$row['CreatedBy'] = $this->CreatedBy->CurrentValue;
		$row['CreatedDate'] = $this->CreatedDate->CurrentValue;
		$row['UpdatedBy'] = $this->UpdatedBy->CurrentValue;
		$row['UpdatedDate'] = $this->UpdatedDate->CurrentValue;
		$row['CaseTypeConv'] = $this->CaseTypeConv->CurrentValue;
		$row['CaseConv'] = $this->CaseConv->CurrentValue;
		$row['ClientStatusConv'] = $this->ClientStatusConv->CurrentValue;
		$row['LitigantStatusConv'] = $this->LitigantStatusConv->CurrentValue;
		$row['ClientNameConv'] = $this->ClientNameConv->CurrentValue;
		$row['LitigantNameConv'] = $this->LitigantNameConv->CurrentValue;
		$row['ClientNameConvFiles'] = $this->ClientNameConvFiles->CurrentValue;
		$row['LitigantNameConvFiles'] = $this->LitigantNameConvFiles->CurrentValue;
		$row['CaseTypeConvFiles'] = $this->CaseTypeConvFiles->CurrentValue;
		$row['CourtConvFiles'] = $this->CourtConvFiles->CurrentValue;
		$row['FileNumberConvFiles'] = $this->FileNumberConvFiles->CurrentValue;
		$row['CaseNumberConvFiles'] = $this->CaseNumberConvFiles->CurrentValue;
		$row['NotesConvFiles'] = $this->NotesConvFiles->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		$arKeys[] = $this->RowOldKey;
		$cnt = count($arKeys);
		if ($cnt >= 1) {
			if (strval($arKeys[0]) <> "")
				$this->CaseID->CurrentValue = strval($arKeys[0]); // CaseID
			else
				$validKey = FALSE;
		} else {
			$validKey = FALSE;
		}

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// CaseID
		// ClientID

		$this->ClientID->CellCssStyle = "min-width: 150px;";

		// LitigantID
		$this->LitigantID->CellCssStyle = "width: 250px; white-space: nowrap;";

		// CaseTypeID
		$this->CaseTypeID->CellCssStyle = "min-width: 120px;";

		// CourtID
		$this->CourtID->CellCssStyle = "width: 200px; white-space: nowrap;";

		// CaseNumber
		// FileNumber
		// EnvelopeNumber
		// ClientStatusID
		// LitigantStatusID
		// CourtTypeID

		$this->CourtTypeID->CellCssStyle = "white-space: nowrap;";

		// CourtGenderID
		$this->CourtGenderID->CellCssStyle = "white-space: nowrap;";

		// JudgeID
		$this->JudgeID->CellCssStyle = "min-width: 150px;";

		// Notes
		$this->Notes->CellCssStyle = "min-width: 200px;";

		// FileLocation
		// Case

		$this->_Case->CellCssStyle = "min-width: 180px;";

		// CaseEn
		$this->CaseEn->CellCssStyle = "white-space: nowrap;";

		// CaseSortID
		// CaseRegisteredDate
		// CaseStatusID
		// ParentCaseID
		// FileNumber2

		$this->FileNumber2->CellCssStyle = "white-space: nowrap;";

		// UserID
		$this->_UserID->CellCssStyle = "white-space: nowrap;";

		// CreatedBy
		$this->CreatedBy->CellCssStyle = "white-space: nowrap;";

		// CreatedDate
		$this->CreatedDate->CellCssStyle = "white-space: nowrap;";

		// UpdatedBy
		$this->UpdatedBy->CellCssStyle = "white-space: nowrap;";

		// UpdatedDate
		$this->UpdatedDate->CellCssStyle = "white-space: nowrap;";

		// CaseTypeConv
		$this->CaseTypeConv->CellCssStyle = "white-space: nowrap;";

		// CaseConv
		$this->CaseConv->CellCssStyle = "white-space: nowrap;";

		// ClientStatusConv
		$this->ClientStatusConv->CellCssStyle = "white-space: nowrap;";

		// LitigantStatusConv
		$this->LitigantStatusConv->CellCssStyle = "white-space: nowrap;";

		// ClientNameConv
		$this->ClientNameConv->CellCssStyle = "white-space: nowrap;";

		// LitigantNameConv
		$this->LitigantNameConv->CellCssStyle = "white-space: nowrap;";

		// ClientNameConvFiles
		$this->ClientNameConvFiles->CellCssStyle = "white-space: nowrap;";

		// LitigantNameConvFiles
		$this->LitigantNameConvFiles->CellCssStyle = "white-space: nowrap;";

		// CaseTypeConvFiles
		$this->CaseTypeConvFiles->CellCssStyle = "white-space: nowrap;";

		// CourtConvFiles
		$this->CourtConvFiles->CellCssStyle = "white-space: nowrap;";

		// FileNumberConvFiles
		$this->FileNumberConvFiles->CellCssStyle = "white-space: nowrap;";

		// CaseNumberConvFiles
		$this->CaseNumberConvFiles->CellCssStyle = "white-space: nowrap;";

		// NotesConvFiles
		$this->NotesConvFiles->CellCssStyle = "white-space: nowrap;";
		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// CaseID
			$this->CaseID->ViewValue = $this->CaseID->CurrentValue;
			$this->CaseID->ViewCustomAttributes = "";

			// ClientID
			if ($this->ClientID->VirtualValue <> "") {
				$this->ClientID->ViewValue = $this->ClientID->VirtualValue;
			} else {
				$this->ClientID->ViewValue = $this->ClientID->CurrentValue;
			$curVal = strval($this->ClientID->CurrentValue);
			if ($curVal <> "") {
				$this->ClientID->ViewValue = $this->ClientID->lookupCacheOption($curVal);
				if ($this->ClientID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`ClientID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ClientID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->ClientID->ViewValue = $this->ClientID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ClientID->ViewValue = $this->ClientID->CurrentValue;
					}
				}
			} else {
				$this->ClientID->ViewValue = NULL;
			}
			}
			$this->ClientID->CssStyle = "font-weight: bold;";
			$this->ClientID->ViewCustomAttributes = "";

			// LitigantID
			if ($this->LitigantID->VirtualValue <> "") {
				$this->LitigantID->ViewValue = $this->LitigantID->VirtualValue;
			} else {
				$this->LitigantID->ViewValue = $this->LitigantID->CurrentValue;
			$curVal = strval($this->LitigantID->CurrentValue);
			if ($curVal <> "") {
				$this->LitigantID->ViewValue = $this->LitigantID->lookupCacheOption($curVal);
				if ($this->LitigantID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`LitigantID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->LitigantID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->LitigantID->ViewValue = $this->LitigantID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->LitigantID->ViewValue = $this->LitigantID->CurrentValue;
					}
				}
			} else {
				$this->LitigantID->ViewValue = NULL;
			}
			}
			$this->LitigantID->CssStyle = "font-weight: bold;";
			$this->LitigantID->ViewCustomAttributes = "";

			// CaseTypeID
			if ($this->CaseTypeID->VirtualValue <> "") {
				$this->CaseTypeID->ViewValue = $this->CaseTypeID->VirtualValue;
			} else {
			$curVal = strval($this->CaseTypeID->CurrentValue);
			if ($curVal <> "") {
				$this->CaseTypeID->ViewValue = $this->CaseTypeID->lookupCacheOption($curVal);
				if ($this->CaseTypeID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CaseTypeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CaseTypeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CaseTypeID->ViewValue = $this->CaseTypeID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CaseTypeID->ViewValue = $this->CaseTypeID->CurrentValue;
					}
				}
			} else {
				$this->CaseTypeID->ViewValue = NULL;
			}
			}
			$this->CaseTypeID->CssStyle = "font-style: italic;";
			$this->CaseTypeID->ViewCustomAttributes = "";

			// CourtID
			if ($this->CourtID->VirtualValue <> "") {
				$this->CourtID->ViewValue = $this->CourtID->VirtualValue;
			} else {
				$this->CourtID->ViewValue = $this->CourtID->CurrentValue;
			$curVal = strval($this->CourtID->CurrentValue);
			if ($curVal <> "") {
				$this->CourtID->ViewValue = $this->CourtID->lookupCacheOption($curVal);
				if ($this->CourtID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CourtID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CourtID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CourtID->ViewValue = $this->CourtID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CourtID->ViewValue = $this->CourtID->CurrentValue;
					}
				}
			} else {
				$this->CourtID->ViewValue = NULL;
			}
			}
			$this->CourtID->ViewCustomAttributes = "";

			// CaseNumber
			$this->CaseNumber->ViewValue = $this->CaseNumber->CurrentValue;
			$this->CaseNumber->ViewCustomAttributes = "";

			// FileNumber
			$this->FileNumber->ViewValue = $this->FileNumber->CurrentValue;
			$this->FileNumber->ViewCustomAttributes = "";

			// ClientStatusID
			if ($this->ClientStatusID->VirtualValue <> "") {
				$this->ClientStatusID->ViewValue = $this->ClientStatusID->VirtualValue;
			} else {
			$curVal = strval($this->ClientStatusID->CurrentValue);
			if ($curVal <> "") {
				$this->ClientStatusID->ViewValue = $this->ClientStatusID->lookupCacheOption($curVal);
				if ($this->ClientStatusID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`PartiesStatusID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ClientStatusID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->ClientStatusID->ViewValue = $this->ClientStatusID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ClientStatusID->ViewValue = $this->ClientStatusID->CurrentValue;
					}
				}
			} else {
				$this->ClientStatusID->ViewValue = NULL;
			}
			}
			$this->ClientStatusID->CssStyle = "font-style: italic;";
			$this->ClientStatusID->ViewCustomAttributes = "";

			// LitigantStatusID
			if ($this->LitigantStatusID->VirtualValue <> "") {
				$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->VirtualValue;
			} else {
			$curVal = strval($this->LitigantStatusID->CurrentValue);
			if ($curVal <> "") {
				$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->lookupCacheOption($curVal);
				if ($this->LitigantStatusID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`PartiesStatusID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->LitigantStatusID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->CurrentValue;
					}
				}
			} else {
				$this->LitigantStatusID->ViewValue = NULL;
			}
			}
			$this->LitigantStatusID->CssStyle = "font-style: italic;";
			$this->LitigantStatusID->ViewCustomAttributes = "";

			// JudgeID
			if ($this->JudgeID->VirtualValue <> "") {
				$this->JudgeID->ViewValue = $this->JudgeID->VirtualValue;
			} else {
			$curVal = strval($this->JudgeID->CurrentValue);
			if ($curVal <> "") {
				$this->JudgeID->ViewValue = $this->JudgeID->lookupCacheOption($curVal);
				if ($this->JudgeID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`JudgeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->JudgeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->JudgeID->ViewValue = $this->JudgeID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->JudgeID->ViewValue = $this->JudgeID->CurrentValue;
					}
				}
			} else {
				$this->JudgeID->ViewValue = NULL;
			}
			}
			$this->JudgeID->ViewCustomAttributes = "";

			// Notes
			$this->Notes->ViewValue = $this->Notes->CurrentValue;
			$this->Notes->ViewCustomAttributes = "";

			// FileLocation
			$this->FileLocation->ViewValue = $this->FileLocation->CurrentValue;
			$this->FileLocation->ViewCustomAttributes = "";

			// Case
			$this->_Case->ViewValue = $this->_Case->CurrentValue;
			$this->_Case->ViewCustomAttributes = "";

			// CaseSortID
			if ($this->CaseSortID->VirtualValue <> "") {
				$this->CaseSortID->ViewValue = $this->CaseSortID->VirtualValue;
			} else {
			$curVal = strval($this->CaseSortID->CurrentValue);
			if ($curVal <> "") {
				$this->CaseSortID->ViewValue = $this->CaseSortID->lookupCacheOption($curVal);
				if ($this->CaseSortID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CaseSortID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CaseSortID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CaseSortID->ViewValue = $this->CaseSortID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CaseSortID->ViewValue = $this->CaseSortID->CurrentValue;
					}
				}
			} else {
				$this->CaseSortID->ViewValue = NULL;
			}
			}
			$this->CaseSortID->ViewCustomAttributes = "";

			// CaseRegisteredDate
			$this->CaseRegisteredDate->ViewValue = $this->CaseRegisteredDate->CurrentValue;
			$this->CaseRegisteredDate->ViewValue = FormatDateTime($this->CaseRegisteredDate->ViewValue, 7);
			$this->CaseRegisteredDate->ViewCustomAttributes = "";

			// CaseStatusID
			if ($this->CaseStatusID->VirtualValue <> "") {
				$this->CaseStatusID->ViewValue = $this->CaseStatusID->VirtualValue;
			} else {
			$curVal = strval($this->CaseStatusID->CurrentValue);
			if ($curVal <> "") {
				$this->CaseStatusID->ViewValue = $this->CaseStatusID->lookupCacheOption($curVal);
				if ($this->CaseStatusID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CaseStatusID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CaseStatusID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CaseStatusID->ViewValue = $this->CaseStatusID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CaseStatusID->ViewValue = $this->CaseStatusID->CurrentValue;
					}
				}
			} else {
				$this->CaseStatusID->ViewValue = NULL;
			}
			}
			$this->CaseStatusID->CssStyle = "font-style: italic;";
			$this->CaseStatusID->ViewCustomAttributes = "";

			// ParentCaseID
			$this->ParentCaseID->ViewValue = $this->ParentCaseID->CurrentValue;
			$this->ParentCaseID->ViewValue = FormatNumber($this->ParentCaseID->ViewValue, 0, -2, -2, -2);
			$this->ParentCaseID->ViewCustomAttributes = "";

			// FileNumber2
			$this->FileNumber2->ViewValue = $this->FileNumber2->CurrentValue;
			$this->FileNumber2->ViewValue = FormatNumber($this->FileNumber2->ViewValue, 0, -2, -2, -2);
			$this->FileNumber2->ViewCustomAttributes = "";

			// ClientNameConvFiles
			$this->ClientNameConvFiles->ViewValue = $this->ClientNameConvFiles->CurrentValue;
			$this->ClientNameConvFiles->ViewCustomAttributes = "";

			// LitigantNameConvFiles
			$this->LitigantNameConvFiles->ViewValue = $this->LitigantNameConvFiles->CurrentValue;
			$this->LitigantNameConvFiles->ViewCustomAttributes = "";

			// CaseTypeConvFiles
			$this->CaseTypeConvFiles->ViewValue = $this->CaseTypeConvFiles->CurrentValue;
			$this->CaseTypeConvFiles->ViewCustomAttributes = "";

			// ClientID
			$this->ClientID->LinkCustomAttributes = "";
			if (!EmptyValue($this->ClientID->CurrentValue)) {
				$this->ClientID->HrefValue = "/home/clientsview.php?showdetail=clientaddress,clientcontact,cases&ClientID=" . $this->ClientID->CurrentValue; // Add prefix/suffix
				$this->ClientID->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->ClientID->HrefValue = FullUrl($this->ClientID->HrefValue, "href");
			} else {
				$this->ClientID->HrefValue = "";
			}
			$this->ClientID->TooltipValue = "";

			// LitigantID
			$this->LitigantID->LinkCustomAttributes = "";
			if (!EmptyValue($this->LitigantID->CurrentValue)) {
				$this->LitigantID->HrefValue = "/home/litigantsview.php?showdetail=litigantaddress,litigantcontact,cases&LitigantID=" . $this->LitigantID->CurrentValue; // Add prefix/suffix
				$this->LitigantID->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->LitigantID->HrefValue = FullUrl($this->LitigantID->HrefValue, "href");
			} else {
				$this->LitigantID->HrefValue = "";
			}
			$this->LitigantID->TooltipValue = "";

			// CaseTypeID
			$this->CaseTypeID->LinkCustomAttributes = "";
			$this->CaseTypeID->HrefValue = "";
			$this->CaseTypeID->TooltipValue = "";

			// CourtID
			$this->CourtID->LinkCustomAttributes = "";
			if (!EmptyValue($this->CourtID->CurrentValue)) {
				$this->CourtID->HrefValue = "/home/courtsview.php?showdetail=courtaddress,courtcontact&CourtID=" . $this->CourtID->CurrentValue; // Add prefix/suffix
				$this->CourtID->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->CourtID->HrefValue = FullUrl($this->CourtID->HrefValue, "href");
			} else {
				$this->CourtID->HrefValue = "";
			}
			$this->CourtID->TooltipValue = "";

			// CaseNumber
			$this->CaseNumber->LinkCustomAttributes = "";
			$this->CaseNumber->HrefValue = "";
			$this->CaseNumber->TooltipValue = "";
			if (!$this->isExport())
				$this->CaseNumber->ViewValue = $this->highlightValue($this->CaseNumber);

			// FileNumber
			$this->FileNumber->LinkCustomAttributes = "";
			$this->FileNumber->HrefValue = "";
			$this->FileNumber->TooltipValue = "";
			if (!$this->isExport())
				$this->FileNumber->ViewValue = $this->highlightValue($this->FileNumber);

			// ClientStatusID
			$this->ClientStatusID->LinkCustomAttributes = "";
			$this->ClientStatusID->HrefValue = "";
			$this->ClientStatusID->TooltipValue = "";

			// LitigantStatusID
			$this->LitigantStatusID->LinkCustomAttributes = "";
			$this->LitigantStatusID->HrefValue = "";
			$this->LitigantStatusID->TooltipValue = "";

			// Notes
			$this->Notes->LinkCustomAttributes = "";
			$this->Notes->HrefValue = "";
			$this->Notes->TooltipValue = "";
			if (!$this->isExport())
				$this->Notes->ViewValue = $this->highlightValue($this->Notes);

			// ParentCaseID
			$this->ParentCaseID->LinkCustomAttributes = "";
			$this->ParentCaseID->HrefValue = "";
			$this->ParentCaseID->TooltipValue = "";

			// FileNumber2
			$this->FileNumber2->LinkCustomAttributes = "";
			$this->FileNumber2->HrefValue = "";
			$this->FileNumber2->TooltipValue = "";

			// ClientNameConvFiles
			$this->ClientNameConvFiles->LinkCustomAttributes = "";
			$this->ClientNameConvFiles->HrefValue = "";
			$this->ClientNameConvFiles->TooltipValue = "";
			if (!$this->isExport())
				$this->ClientNameConvFiles->ViewValue = $this->highlightValue($this->ClientNameConvFiles);

			// LitigantNameConvFiles
			$this->LitigantNameConvFiles->LinkCustomAttributes = "";
			$this->LitigantNameConvFiles->HrefValue = "";
			$this->LitigantNameConvFiles->TooltipValue = "";
			if (!$this->isExport())
				$this->LitigantNameConvFiles->ViewValue = $this->highlightValue($this->LitigantNameConvFiles);

			// CaseTypeConvFiles
			$this->CaseTypeConvFiles->LinkCustomAttributes = "";
			$this->CaseTypeConvFiles->HrefValue = "";
			$this->CaseTypeConvFiles->TooltipValue = "";
			if (!$this->isExport())
				$this->CaseTypeConvFiles->ViewValue = $this->highlightValue($this->CaseTypeConvFiles);
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// ClientID
			$this->ClientID->EditAttrs["class"] = "form-control";
			$this->ClientID->EditCustomAttributes = "";
			if ($this->ClientID->getSessionValue() <> "") {
				$this->ClientID->CurrentValue = $this->ClientID->getSessionValue();
				$this->ClientID->OldValue = $this->ClientID->CurrentValue;
			if ($this->ClientID->VirtualValue <> "") {
				$this->ClientID->ViewValue = $this->ClientID->VirtualValue;
			} else {
				$this->ClientID->ViewValue = $this->ClientID->CurrentValue;
			$curVal = strval($this->ClientID->CurrentValue);
			if ($curVal <> "") {
				$this->ClientID->ViewValue = $this->ClientID->lookupCacheOption($curVal);
				if ($this->ClientID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`ClientID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ClientID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->ClientID->ViewValue = $this->ClientID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ClientID->ViewValue = $this->ClientID->CurrentValue;
					}
				}
			} else {
				$this->ClientID->ViewValue = NULL;
			}
			}
			$this->ClientID->CssStyle = "font-weight: bold;";
			$this->ClientID->ViewCustomAttributes = "";
			} else {
			$this->ClientID->EditValue = HtmlEncode($this->ClientID->CurrentValue);
			$curVal = strval($this->ClientID->CurrentValue);
			if ($curVal <> "") {
				$this->ClientID->EditValue = $this->ClientID->lookupCacheOption($curVal);
				if ($this->ClientID->EditValue === NULL) { // Lookup from database
					$filterWrk = "`ClientID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ClientID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$arwrk[3] = HtmlEncode($rswrk->fields('df3'));
						$this->ClientID->EditValue = $this->ClientID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ClientID->EditValue = HtmlEncode($this->ClientID->CurrentValue);
					}
				}
			} else {
				$this->ClientID->EditValue = NULL;
			}
			$this->ClientID->PlaceHolder = RemoveHtml($this->ClientID->caption());
			}

			// LitigantID
			$this->LitigantID->EditAttrs["class"] = "form-control";
			$this->LitigantID->EditCustomAttributes = "";
			if ($this->LitigantID->getSessionValue() <> "") {
				$this->LitigantID->CurrentValue = $this->LitigantID->getSessionValue();
				$this->LitigantID->OldValue = $this->LitigantID->CurrentValue;
			if ($this->LitigantID->VirtualValue <> "") {
				$this->LitigantID->ViewValue = $this->LitigantID->VirtualValue;
			} else {
				$this->LitigantID->ViewValue = $this->LitigantID->CurrentValue;
			$curVal = strval($this->LitigantID->CurrentValue);
			if ($curVal <> "") {
				$this->LitigantID->ViewValue = $this->LitigantID->lookupCacheOption($curVal);
				if ($this->LitigantID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`LitigantID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->LitigantID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->LitigantID->ViewValue = $this->LitigantID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->LitigantID->ViewValue = $this->LitigantID->CurrentValue;
					}
				}
			} else {
				$this->LitigantID->ViewValue = NULL;
			}
			}
			$this->LitigantID->CssStyle = "font-weight: bold;";
			$this->LitigantID->ViewCustomAttributes = "";
			} else {
			$this->LitigantID->EditValue = HtmlEncode($this->LitigantID->CurrentValue);
			$curVal = strval($this->LitigantID->CurrentValue);
			if ($curVal <> "") {
				$this->LitigantID->EditValue = $this->LitigantID->lookupCacheOption($curVal);
				if ($this->LitigantID->EditValue === NULL) { // Lookup from database
					$filterWrk = "`LitigantID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->LitigantID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$arwrk[3] = HtmlEncode($rswrk->fields('df3'));
						$this->LitigantID->EditValue = $this->LitigantID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->LitigantID->EditValue = HtmlEncode($this->LitigantID->CurrentValue);
					}
				}
			} else {
				$this->LitigantID->EditValue = NULL;
			}
			$this->LitigantID->PlaceHolder = RemoveHtml($this->LitigantID->caption());
			}

			// CaseTypeID
			$this->CaseTypeID->EditAttrs["class"] = "form-control";
			$this->CaseTypeID->EditCustomAttributes = "";
			$curVal = trim(strval($this->CaseTypeID->CurrentValue));
			if ($curVal <> "")
				$this->CaseTypeID->ViewValue = $this->CaseTypeID->lookupCacheOption($curVal);
			else
				$this->CaseTypeID->ViewValue = $this->CaseTypeID->Lookup !== NULL && is_array($this->CaseTypeID->Lookup->Options) ? $curVal : NULL;
			if ($this->CaseTypeID->ViewValue !== NULL) { // Load from cache
				$this->CaseTypeID->EditValue = array_values($this->CaseTypeID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`CaseTypeID`" . SearchString("=", $this->CaseTypeID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->CaseTypeID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->CaseTypeID->EditValue = $arwrk;
			}

			// CourtID
			$this->CourtID->EditAttrs["class"] = "form-control";
			$this->CourtID->EditCustomAttributes = "";
			$this->CourtID->EditValue = HtmlEncode($this->CourtID->CurrentValue);
			$curVal = strval($this->CourtID->CurrentValue);
			if ($curVal <> "") {
				$this->CourtID->EditValue = $this->CourtID->lookupCacheOption($curVal);
				if ($this->CourtID->EditValue === NULL) { // Lookup from database
					$filterWrk = "`CourtID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CourtID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->CourtID->EditValue = $this->CourtID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CourtID->EditValue = HtmlEncode($this->CourtID->CurrentValue);
					}
				}
			} else {
				$this->CourtID->EditValue = NULL;
			}
			$this->CourtID->PlaceHolder = RemoveHtml($this->CourtID->caption());

			// CaseNumber
			$this->CaseNumber->EditAttrs["class"] = "form-control";
			$this->CaseNumber->EditCustomAttributes = "";
			$this->CaseNumber->EditValue = HtmlEncode($this->CaseNumber->CurrentValue);
			$this->CaseNumber->PlaceHolder = RemoveHtml($this->CaseNumber->caption());

			// FileNumber
			$this->FileNumber->EditAttrs["class"] = "form-control";
			$this->FileNumber->EditCustomAttributes = "";
			$this->FileNumber->EditValue = HtmlEncode($this->FileNumber->CurrentValue);
			$this->FileNumber->PlaceHolder = RemoveHtml($this->FileNumber->caption());

			// ClientStatusID
			$this->ClientStatusID->EditAttrs["class"] = "form-control";
			$this->ClientStatusID->EditCustomAttributes = "";
			$curVal = trim(strval($this->ClientStatusID->CurrentValue));
			if ($curVal <> "")
				$this->ClientStatusID->ViewValue = $this->ClientStatusID->lookupCacheOption($curVal);
			else
				$this->ClientStatusID->ViewValue = $this->ClientStatusID->Lookup !== NULL && is_array($this->ClientStatusID->Lookup->Options) ? $curVal : NULL;
			if ($this->ClientStatusID->ViewValue !== NULL) { // Load from cache
				$this->ClientStatusID->EditValue = array_values($this->ClientStatusID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`PartiesStatusID`" . SearchString("=", $this->ClientStatusID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->ClientStatusID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->ClientStatusID->EditValue = $arwrk;
			}

			// LitigantStatusID
			$this->LitigantStatusID->EditAttrs["class"] = "form-control";
			$this->LitigantStatusID->EditCustomAttributes = "";
			$curVal = trim(strval($this->LitigantStatusID->CurrentValue));
			if ($curVal <> "")
				$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->lookupCacheOption($curVal);
			else
				$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->Lookup !== NULL && is_array($this->LitigantStatusID->Lookup->Options) ? $curVal : NULL;
			if ($this->LitigantStatusID->ViewValue !== NULL) { // Load from cache
				$this->LitigantStatusID->EditValue = array_values($this->LitigantStatusID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`PartiesStatusID`" . SearchString("=", $this->LitigantStatusID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->LitigantStatusID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->LitigantStatusID->EditValue = $arwrk;
			}

			// Notes
			$this->Notes->EditAttrs["class"] = "form-control";
			$this->Notes->EditCustomAttributes = "";
			$this->Notes->EditValue = HtmlEncode($this->Notes->CurrentValue);
			$this->Notes->PlaceHolder = RemoveHtml($this->Notes->caption());

			// ParentCaseID
			$this->ParentCaseID->EditAttrs["class"] = "form-control";
			$this->ParentCaseID->EditCustomAttributes = "";
			$this->ParentCaseID->EditValue = HtmlEncode($this->ParentCaseID->CurrentValue);
			$this->ParentCaseID->PlaceHolder = RemoveHtml($this->ParentCaseID->caption());

			// FileNumber2
			$this->FileNumber2->EditAttrs["class"] = "form-control";
			$this->FileNumber2->EditCustomAttributes = "";
			$this->FileNumber2->EditValue = HtmlEncode($this->FileNumber2->CurrentValue);
			$this->FileNumber2->PlaceHolder = RemoveHtml($this->FileNumber2->caption());

			// ClientNameConvFiles
			$this->ClientNameConvFiles->EditAttrs["class"] = "form-control";
			$this->ClientNameConvFiles->EditCustomAttributes = "";
			$this->ClientNameConvFiles->EditValue = HtmlEncode($this->ClientNameConvFiles->CurrentValue);
			$this->ClientNameConvFiles->PlaceHolder = RemoveHtml($this->ClientNameConvFiles->caption());

			// LitigantNameConvFiles
			$this->LitigantNameConvFiles->EditAttrs["class"] = "form-control";
			$this->LitigantNameConvFiles->EditCustomAttributes = "";
			$this->LitigantNameConvFiles->EditValue = HtmlEncode($this->LitigantNameConvFiles->CurrentValue);
			$this->LitigantNameConvFiles->PlaceHolder = RemoveHtml($this->LitigantNameConvFiles->caption());

			// CaseTypeConvFiles
			$this->CaseTypeConvFiles->EditAttrs["class"] = "form-control";
			$this->CaseTypeConvFiles->EditCustomAttributes = "";
			$this->CaseTypeConvFiles->EditValue = HtmlEncode($this->CaseTypeConvFiles->CurrentValue);
			$this->CaseTypeConvFiles->PlaceHolder = RemoveHtml($this->CaseTypeConvFiles->caption());

			// Add refer script
			// ClientID

			$this->ClientID->LinkCustomAttributes = "";
			if (!EmptyValue($this->ClientID->CurrentValue)) {
				$this->ClientID->HrefValue = "/home/clientsview.php?showdetail=clientaddress,clientcontact,cases&ClientID=" . $this->ClientID->CurrentValue; // Add prefix/suffix
				$this->ClientID->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->ClientID->HrefValue = FullUrl($this->ClientID->HrefValue, "href");
			} else {
				$this->ClientID->HrefValue = "";
			}

			// LitigantID
			$this->LitigantID->LinkCustomAttributes = "";
			if (!EmptyValue($this->LitigantID->CurrentValue)) {
				$this->LitigantID->HrefValue = "/home/litigantsview.php?showdetail=litigantaddress,litigantcontact,cases&LitigantID=" . $this->LitigantID->CurrentValue; // Add prefix/suffix
				$this->LitigantID->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->LitigantID->HrefValue = FullUrl($this->LitigantID->HrefValue, "href");
			} else {
				$this->LitigantID->HrefValue = "";
			}

			// CaseTypeID
			$this->CaseTypeID->LinkCustomAttributes = "";
			$this->CaseTypeID->HrefValue = "";

			// CourtID
			$this->CourtID->LinkCustomAttributes = "";
			if (!EmptyValue($this->CourtID->CurrentValue)) {
				$this->CourtID->HrefValue = "/home/courtsview.php?showdetail=courtaddress,courtcontact&CourtID=" . $this->CourtID->CurrentValue; // Add prefix/suffix
				$this->CourtID->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->CourtID->HrefValue = FullUrl($this->CourtID->HrefValue, "href");
			} else {
				$this->CourtID->HrefValue = "";
			}

			// CaseNumber
			$this->CaseNumber->LinkCustomAttributes = "";
			$this->CaseNumber->HrefValue = "";

			// FileNumber
			$this->FileNumber->LinkCustomAttributes = "";
			$this->FileNumber->HrefValue = "";

			// ClientStatusID
			$this->ClientStatusID->LinkCustomAttributes = "";
			$this->ClientStatusID->HrefValue = "";

			// LitigantStatusID
			$this->LitigantStatusID->LinkCustomAttributes = "";
			$this->LitigantStatusID->HrefValue = "";

			// Notes
			$this->Notes->LinkCustomAttributes = "";
			$this->Notes->HrefValue = "";

			// ParentCaseID
			$this->ParentCaseID->LinkCustomAttributes = "";
			$this->ParentCaseID->HrefValue = "";

			// FileNumber2
			$this->FileNumber2->LinkCustomAttributes = "";
			$this->FileNumber2->HrefValue = "";

			// ClientNameConvFiles
			$this->ClientNameConvFiles->LinkCustomAttributes = "";
			$this->ClientNameConvFiles->HrefValue = "";

			// LitigantNameConvFiles
			$this->LitigantNameConvFiles->LinkCustomAttributes = "";
			$this->LitigantNameConvFiles->HrefValue = "";

			// CaseTypeConvFiles
			$this->CaseTypeConvFiles->LinkCustomAttributes = "";
			$this->CaseTypeConvFiles->HrefValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// ClientID
			$this->ClientID->EditAttrs["class"] = "form-control";
			$this->ClientID->EditCustomAttributes = "";
			if ($this->ClientID->getSessionValue() <> "") {
				$this->ClientID->CurrentValue = $this->ClientID->getSessionValue();
				$this->ClientID->OldValue = $this->ClientID->CurrentValue;
			if ($this->ClientID->VirtualValue <> "") {
				$this->ClientID->ViewValue = $this->ClientID->VirtualValue;
			} else {
				$this->ClientID->ViewValue = $this->ClientID->CurrentValue;
			$curVal = strval($this->ClientID->CurrentValue);
			if ($curVal <> "") {
				$this->ClientID->ViewValue = $this->ClientID->lookupCacheOption($curVal);
				if ($this->ClientID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`ClientID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ClientID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->ClientID->ViewValue = $this->ClientID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ClientID->ViewValue = $this->ClientID->CurrentValue;
					}
				}
			} else {
				$this->ClientID->ViewValue = NULL;
			}
			}
			$this->ClientID->CssStyle = "font-weight: bold;";
			$this->ClientID->ViewCustomAttributes = "";
			} else {
			$this->ClientID->EditValue = HtmlEncode($this->ClientID->CurrentValue);
			$curVal = strval($this->ClientID->CurrentValue);
			if ($curVal <> "") {
				$this->ClientID->EditValue = $this->ClientID->lookupCacheOption($curVal);
				if ($this->ClientID->EditValue === NULL) { // Lookup from database
					$filterWrk = "`ClientID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ClientID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$arwrk[3] = HtmlEncode($rswrk->fields('df3'));
						$this->ClientID->EditValue = $this->ClientID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ClientID->EditValue = HtmlEncode($this->ClientID->CurrentValue);
					}
				}
			} else {
				$this->ClientID->EditValue = NULL;
			}
			$this->ClientID->PlaceHolder = RemoveHtml($this->ClientID->caption());
			}

			// LitigantID
			$this->LitigantID->EditAttrs["class"] = "form-control";
			$this->LitigantID->EditCustomAttributes = "";
			if ($this->LitigantID->getSessionValue() <> "") {
				$this->LitigantID->CurrentValue = $this->LitigantID->getSessionValue();
				$this->LitigantID->OldValue = $this->LitigantID->CurrentValue;
			if ($this->LitigantID->VirtualValue <> "") {
				$this->LitigantID->ViewValue = $this->LitigantID->VirtualValue;
			} else {
				$this->LitigantID->ViewValue = $this->LitigantID->CurrentValue;
			$curVal = strval($this->LitigantID->CurrentValue);
			if ($curVal <> "") {
				$this->LitigantID->ViewValue = $this->LitigantID->lookupCacheOption($curVal);
				if ($this->LitigantID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`LitigantID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->LitigantID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->LitigantID->ViewValue = $this->LitigantID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->LitigantID->ViewValue = $this->LitigantID->CurrentValue;
					}
				}
			} else {
				$this->LitigantID->ViewValue = NULL;
			}
			}
			$this->LitigantID->CssStyle = "font-weight: bold;";
			$this->LitigantID->ViewCustomAttributes = "";
			} else {
			$this->LitigantID->EditValue = HtmlEncode($this->LitigantID->CurrentValue);
			$curVal = strval($this->LitigantID->CurrentValue);
			if ($curVal <> "") {
				$this->LitigantID->EditValue = $this->LitigantID->lookupCacheOption($curVal);
				if ($this->LitigantID->EditValue === NULL) { // Lookup from database
					$filterWrk = "`LitigantID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->LitigantID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$arwrk[3] = HtmlEncode($rswrk->fields('df3'));
						$this->LitigantID->EditValue = $this->LitigantID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->LitigantID->EditValue = HtmlEncode($this->LitigantID->CurrentValue);
					}
				}
			} else {
				$this->LitigantID->EditValue = NULL;
			}
			$this->LitigantID->PlaceHolder = RemoveHtml($this->LitigantID->caption());
			}

			// CaseTypeID
			$this->CaseTypeID->EditAttrs["class"] = "form-control";
			$this->CaseTypeID->EditCustomAttributes = "";
			$curVal = trim(strval($this->CaseTypeID->CurrentValue));
			if ($curVal <> "")
				$this->CaseTypeID->ViewValue = $this->CaseTypeID->lookupCacheOption($curVal);
			else
				$this->CaseTypeID->ViewValue = $this->CaseTypeID->Lookup !== NULL && is_array($this->CaseTypeID->Lookup->Options) ? $curVal : NULL;
			if ($this->CaseTypeID->ViewValue !== NULL) { // Load from cache
				$this->CaseTypeID->EditValue = array_values($this->CaseTypeID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`CaseTypeID`" . SearchString("=", $this->CaseTypeID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->CaseTypeID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->CaseTypeID->EditValue = $arwrk;
			}

			// CourtID
			$this->CourtID->EditAttrs["class"] = "form-control";
			$this->CourtID->EditCustomAttributes = "";
			$this->CourtID->EditValue = HtmlEncode($this->CourtID->CurrentValue);
			$curVal = strval($this->CourtID->CurrentValue);
			if ($curVal <> "") {
				$this->CourtID->EditValue = $this->CourtID->lookupCacheOption($curVal);
				if ($this->CourtID->EditValue === NULL) { // Lookup from database
					$filterWrk = "`CourtID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CourtID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->CourtID->EditValue = $this->CourtID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CourtID->EditValue = HtmlEncode($this->CourtID->CurrentValue);
					}
				}
			} else {
				$this->CourtID->EditValue = NULL;
			}
			$this->CourtID->PlaceHolder = RemoveHtml($this->CourtID->caption());

			// CaseNumber
			$this->CaseNumber->EditAttrs["class"] = "form-control";
			$this->CaseNumber->EditCustomAttributes = "";
			$this->CaseNumber->EditValue = HtmlEncode($this->CaseNumber->CurrentValue);
			$this->CaseNumber->PlaceHolder = RemoveHtml($this->CaseNumber->caption());

			// FileNumber
			$this->FileNumber->EditAttrs["class"] = "form-control";
			$this->FileNumber->EditCustomAttributes = "";
			$this->FileNumber->EditValue = HtmlEncode($this->FileNumber->CurrentValue);
			$this->FileNumber->PlaceHolder = RemoveHtml($this->FileNumber->caption());

			// ClientStatusID
			$this->ClientStatusID->EditAttrs["class"] = "form-control";
			$this->ClientStatusID->EditCustomAttributes = "";
			$curVal = trim(strval($this->ClientStatusID->CurrentValue));
			if ($curVal <> "")
				$this->ClientStatusID->ViewValue = $this->ClientStatusID->lookupCacheOption($curVal);
			else
				$this->ClientStatusID->ViewValue = $this->ClientStatusID->Lookup !== NULL && is_array($this->ClientStatusID->Lookup->Options) ? $curVal : NULL;
			if ($this->ClientStatusID->ViewValue !== NULL) { // Load from cache
				$this->ClientStatusID->EditValue = array_values($this->ClientStatusID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`PartiesStatusID`" . SearchString("=", $this->ClientStatusID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->ClientStatusID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->ClientStatusID->EditValue = $arwrk;
			}

			// LitigantStatusID
			$this->LitigantStatusID->EditAttrs["class"] = "form-control";
			$this->LitigantStatusID->EditCustomAttributes = "";
			$curVal = trim(strval($this->LitigantStatusID->CurrentValue));
			if ($curVal <> "")
				$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->lookupCacheOption($curVal);
			else
				$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->Lookup !== NULL && is_array($this->LitigantStatusID->Lookup->Options) ? $curVal : NULL;
			if ($this->LitigantStatusID->ViewValue !== NULL) { // Load from cache
				$this->LitigantStatusID->EditValue = array_values($this->LitigantStatusID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`PartiesStatusID`" . SearchString("=", $this->LitigantStatusID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->LitigantStatusID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->LitigantStatusID->EditValue = $arwrk;
			}

			// Notes
			$this->Notes->EditAttrs["class"] = "form-control";
			$this->Notes->EditCustomAttributes = "";
			$this->Notes->EditValue = HtmlEncode($this->Notes->CurrentValue);
			$this->Notes->PlaceHolder = RemoveHtml($this->Notes->caption());

			// ParentCaseID
			$this->ParentCaseID->EditAttrs["class"] = "form-control";
			$this->ParentCaseID->EditCustomAttributes = "";
			$this->ParentCaseID->EditValue = HtmlEncode($this->ParentCaseID->CurrentValue);
			$this->ParentCaseID->PlaceHolder = RemoveHtml($this->ParentCaseID->caption());

			// FileNumber2
			$this->FileNumber2->EditAttrs["class"] = "form-control";
			$this->FileNumber2->EditCustomAttributes = "";
			$this->FileNumber2->EditValue = HtmlEncode($this->FileNumber2->CurrentValue);
			$this->FileNumber2->PlaceHolder = RemoveHtml($this->FileNumber2->caption());

			// ClientNameConvFiles
			$this->ClientNameConvFiles->EditAttrs["class"] = "form-control";
			$this->ClientNameConvFiles->EditCustomAttributes = "";
			$this->ClientNameConvFiles->EditValue = HtmlEncode($this->ClientNameConvFiles->CurrentValue);
			$this->ClientNameConvFiles->PlaceHolder = RemoveHtml($this->ClientNameConvFiles->caption());

			// LitigantNameConvFiles
			$this->LitigantNameConvFiles->EditAttrs["class"] = "form-control";
			$this->LitigantNameConvFiles->EditCustomAttributes = "";
			$this->LitigantNameConvFiles->EditValue = HtmlEncode($this->LitigantNameConvFiles->CurrentValue);
			$this->LitigantNameConvFiles->PlaceHolder = RemoveHtml($this->LitigantNameConvFiles->caption());

			// CaseTypeConvFiles
			$this->CaseTypeConvFiles->EditAttrs["class"] = "form-control";
			$this->CaseTypeConvFiles->EditCustomAttributes = "";
			$this->CaseTypeConvFiles->EditValue = HtmlEncode($this->CaseTypeConvFiles->CurrentValue);
			$this->CaseTypeConvFiles->PlaceHolder = RemoveHtml($this->CaseTypeConvFiles->caption());

			// Edit refer script
			// ClientID

			$this->ClientID->LinkCustomAttributes = "";
			if (!EmptyValue($this->ClientID->CurrentValue)) {
				$this->ClientID->HrefValue = "/home/clientsview.php?showdetail=clientaddress,clientcontact,cases&ClientID=" . $this->ClientID->CurrentValue; // Add prefix/suffix
				$this->ClientID->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->ClientID->HrefValue = FullUrl($this->ClientID->HrefValue, "href");
			} else {
				$this->ClientID->HrefValue = "";
			}

			// LitigantID
			$this->LitigantID->LinkCustomAttributes = "";
			if (!EmptyValue($this->LitigantID->CurrentValue)) {
				$this->LitigantID->HrefValue = "/home/litigantsview.php?showdetail=litigantaddress,litigantcontact,cases&LitigantID=" . $this->LitigantID->CurrentValue; // Add prefix/suffix
				$this->LitigantID->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->LitigantID->HrefValue = FullUrl($this->LitigantID->HrefValue, "href");
			} else {
				$this->LitigantID->HrefValue = "";
			}

			// CaseTypeID
			$this->CaseTypeID->LinkCustomAttributes = "";
			$this->CaseTypeID->HrefValue = "";

			// CourtID
			$this->CourtID->LinkCustomAttributes = "";
			if (!EmptyValue($this->CourtID->CurrentValue)) {
				$this->CourtID->HrefValue = "/home/courtsview.php?showdetail=courtaddress,courtcontact&CourtID=" . $this->CourtID->CurrentValue; // Add prefix/suffix
				$this->CourtID->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->CourtID->HrefValue = FullUrl($this->CourtID->HrefValue, "href");
			} else {
				$this->CourtID->HrefValue = "";
			}

			// CaseNumber
			$this->CaseNumber->LinkCustomAttributes = "";
			$this->CaseNumber->HrefValue = "";

			// FileNumber
			$this->FileNumber->LinkCustomAttributes = "";
			$this->FileNumber->HrefValue = "";

			// ClientStatusID
			$this->ClientStatusID->LinkCustomAttributes = "";
			$this->ClientStatusID->HrefValue = "";

			// LitigantStatusID
			$this->LitigantStatusID->LinkCustomAttributes = "";
			$this->LitigantStatusID->HrefValue = "";

			// Notes
			$this->Notes->LinkCustomAttributes = "";
			$this->Notes->HrefValue = "";

			// ParentCaseID
			$this->ParentCaseID->LinkCustomAttributes = "";
			$this->ParentCaseID->HrefValue = "";

			// FileNumber2
			$this->FileNumber2->LinkCustomAttributes = "";
			$this->FileNumber2->HrefValue = "";

			// ClientNameConvFiles
			$this->ClientNameConvFiles->LinkCustomAttributes = "";
			$this->ClientNameConvFiles->HrefValue = "";

			// LitigantNameConvFiles
			$this->LitigantNameConvFiles->LinkCustomAttributes = "";
			$this->LitigantNameConvFiles->HrefValue = "";

			// CaseTypeConvFiles
			$this->CaseTypeConvFiles->LinkCustomAttributes = "";
			$this->CaseTypeConvFiles->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->CaseID->Required) {
			if (!$this->CaseID->IsDetailKey && $this->CaseID->FormValue != NULL && $this->CaseID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseID->caption(), $this->CaseID->RequiredErrorMessage));
			}
		}
		if ($this->ClientID->Required) {
			if (!$this->ClientID->IsDetailKey && $this->ClientID->FormValue != NULL && $this->ClientID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ClientID->caption(), $this->ClientID->RequiredErrorMessage));
			}
		}
		if ($this->LitigantID->Required) {
			if (!$this->LitigantID->IsDetailKey && $this->LitigantID->FormValue != NULL && $this->LitigantID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->LitigantID->caption(), $this->LitigantID->RequiredErrorMessage));
			}
		}
		if ($this->CaseTypeID->Required) {
			if (!$this->CaseTypeID->IsDetailKey && $this->CaseTypeID->FormValue != NULL && $this->CaseTypeID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseTypeID->caption(), $this->CaseTypeID->RequiredErrorMessage));
			}
		}
		if ($this->CourtID->Required) {
			if (!$this->CourtID->IsDetailKey && $this->CourtID->FormValue != NULL && $this->CourtID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CourtID->caption(), $this->CourtID->RequiredErrorMessage));
			}
		}
		if ($this->CaseNumber->Required) {
			if (!$this->CaseNumber->IsDetailKey && $this->CaseNumber->FormValue != NULL && $this->CaseNumber->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseNumber->caption(), $this->CaseNumber->RequiredErrorMessage));
			}
		}
		if ($this->FileNumber->Required) {
			if (!$this->FileNumber->IsDetailKey && $this->FileNumber->FormValue != NULL && $this->FileNumber->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->FileNumber->caption(), $this->FileNumber->RequiredErrorMessage));
			}
		}
		if ($this->EnvelopeNumber->Required) {
			if (!$this->EnvelopeNumber->IsDetailKey && $this->EnvelopeNumber->FormValue != NULL && $this->EnvelopeNumber->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->EnvelopeNumber->caption(), $this->EnvelopeNumber->RequiredErrorMessage));
			}
		}
		if ($this->ClientStatusID->Required) {
			if (!$this->ClientStatusID->IsDetailKey && $this->ClientStatusID->FormValue != NULL && $this->ClientStatusID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ClientStatusID->caption(), $this->ClientStatusID->RequiredErrorMessage));
			}
		}
		if ($this->LitigantStatusID->Required) {
			if (!$this->LitigantStatusID->IsDetailKey && $this->LitigantStatusID->FormValue != NULL && $this->LitigantStatusID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->LitigantStatusID->caption(), $this->LitigantStatusID->RequiredErrorMessage));
			}
		}
		if ($this->CourtTypeID->Required) {
			if (!$this->CourtTypeID->IsDetailKey && $this->CourtTypeID->FormValue != NULL && $this->CourtTypeID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CourtTypeID->caption(), $this->CourtTypeID->RequiredErrorMessage));
			}
		}
		if ($this->CourtGenderID->Required) {
			if (!$this->CourtGenderID->IsDetailKey && $this->CourtGenderID->FormValue != NULL && $this->CourtGenderID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CourtGenderID->caption(), $this->CourtGenderID->RequiredErrorMessage));
			}
		}
		if ($this->JudgeID->Required) {
			if (!$this->JudgeID->IsDetailKey && $this->JudgeID->FormValue != NULL && $this->JudgeID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->JudgeID->caption(), $this->JudgeID->RequiredErrorMessage));
			}
		}
		if ($this->Notes->Required) {
			if (!$this->Notes->IsDetailKey && $this->Notes->FormValue != NULL && $this->Notes->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Notes->caption(), $this->Notes->RequiredErrorMessage));
			}
		}
		if ($this->FileLocation->Required) {
			if (!$this->FileLocation->IsDetailKey && $this->FileLocation->FormValue != NULL && $this->FileLocation->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->FileLocation->caption(), $this->FileLocation->RequiredErrorMessage));
			}
		}
		if ($this->_Case->Required) {
			if (!$this->_Case->IsDetailKey && $this->_Case->FormValue != NULL && $this->_Case->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_Case->caption(), $this->_Case->RequiredErrorMessage));
			}
		}
		if ($this->CaseEn->Required) {
			if (!$this->CaseEn->IsDetailKey && $this->CaseEn->FormValue != NULL && $this->CaseEn->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseEn->caption(), $this->CaseEn->RequiredErrorMessage));
			}
		}
		if ($this->CaseSortID->Required) {
			if (!$this->CaseSortID->IsDetailKey && $this->CaseSortID->FormValue != NULL && $this->CaseSortID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseSortID->caption(), $this->CaseSortID->RequiredErrorMessage));
			}
		}
		if ($this->CaseRegisteredDate->Required) {
			if (!$this->CaseRegisteredDate->IsDetailKey && $this->CaseRegisteredDate->FormValue != NULL && $this->CaseRegisteredDate->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseRegisteredDate->caption(), $this->CaseRegisteredDate->RequiredErrorMessage));
			}
		}
		if ($this->CaseStatusID->Required) {
			if (!$this->CaseStatusID->IsDetailKey && $this->CaseStatusID->FormValue != NULL && $this->CaseStatusID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseStatusID->caption(), $this->CaseStatusID->RequiredErrorMessage));
			}
		}
		if ($this->ParentCaseID->Required) {
			if (!$this->ParentCaseID->IsDetailKey && $this->ParentCaseID->FormValue != NULL && $this->ParentCaseID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ParentCaseID->caption(), $this->ParentCaseID->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->ParentCaseID->FormValue)) {
			AddMessage($FormError, $this->ParentCaseID->errorMessage());
		}
		if ($this->FileNumber2->Required) {
			if (!$this->FileNumber2->IsDetailKey && $this->FileNumber2->FormValue != NULL && $this->FileNumber2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->FileNumber2->caption(), $this->FileNumber2->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->FileNumber2->FormValue)) {
			AddMessage($FormError, $this->FileNumber2->errorMessage());
		}
		if ($this->_UserID->Required) {
			if (!$this->_UserID->IsDetailKey && $this->_UserID->FormValue != NULL && $this->_UserID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_UserID->caption(), $this->_UserID->RequiredErrorMessage));
			}
		}
		if ($this->CreatedBy->Required) {
			if (!$this->CreatedBy->IsDetailKey && $this->CreatedBy->FormValue != NULL && $this->CreatedBy->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CreatedBy->caption(), $this->CreatedBy->RequiredErrorMessage));
			}
		}
		if ($this->CreatedDate->Required) {
			if (!$this->CreatedDate->IsDetailKey && $this->CreatedDate->FormValue != NULL && $this->CreatedDate->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CreatedDate->caption(), $this->CreatedDate->RequiredErrorMessage));
			}
		}
		if ($this->UpdatedBy->Required) {
			if (!$this->UpdatedBy->IsDetailKey && $this->UpdatedBy->FormValue != NULL && $this->UpdatedBy->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->UpdatedBy->caption(), $this->UpdatedBy->RequiredErrorMessage));
			}
		}
		if ($this->UpdatedDate->Required) {
			if (!$this->UpdatedDate->IsDetailKey && $this->UpdatedDate->FormValue != NULL && $this->UpdatedDate->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->UpdatedDate->caption(), $this->UpdatedDate->RequiredErrorMessage));
			}
		}
		if ($this->CaseTypeConv->Required) {
			if (!$this->CaseTypeConv->IsDetailKey && $this->CaseTypeConv->FormValue != NULL && $this->CaseTypeConv->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseTypeConv->caption(), $this->CaseTypeConv->RequiredErrorMessage));
			}
		}
		if ($this->CaseConv->Required) {
			if (!$this->CaseConv->IsDetailKey && $this->CaseConv->FormValue != NULL && $this->CaseConv->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseConv->caption(), $this->CaseConv->RequiredErrorMessage));
			}
		}
		if ($this->ClientStatusConv->Required) {
			if (!$this->ClientStatusConv->IsDetailKey && $this->ClientStatusConv->FormValue != NULL && $this->ClientStatusConv->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ClientStatusConv->caption(), $this->ClientStatusConv->RequiredErrorMessage));
			}
		}
		if ($this->LitigantStatusConv->Required) {
			if (!$this->LitigantStatusConv->IsDetailKey && $this->LitigantStatusConv->FormValue != NULL && $this->LitigantStatusConv->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->LitigantStatusConv->caption(), $this->LitigantStatusConv->RequiredErrorMessage));
			}
		}
		if ($this->ClientNameConv->Required) {
			if (!$this->ClientNameConv->IsDetailKey && $this->ClientNameConv->FormValue != NULL && $this->ClientNameConv->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ClientNameConv->caption(), $this->ClientNameConv->RequiredErrorMessage));
			}
		}
		if ($this->LitigantNameConv->Required) {
			if (!$this->LitigantNameConv->IsDetailKey && $this->LitigantNameConv->FormValue != NULL && $this->LitigantNameConv->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->LitigantNameConv->caption(), $this->LitigantNameConv->RequiredErrorMessage));
			}
		}
		if ($this->ClientNameConvFiles->Required) {
			if (!$this->ClientNameConvFiles->IsDetailKey && $this->ClientNameConvFiles->FormValue != NULL && $this->ClientNameConvFiles->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ClientNameConvFiles->caption(), $this->ClientNameConvFiles->RequiredErrorMessage));
			}
		}
		if ($this->LitigantNameConvFiles->Required) {
			if (!$this->LitigantNameConvFiles->IsDetailKey && $this->LitigantNameConvFiles->FormValue != NULL && $this->LitigantNameConvFiles->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->LitigantNameConvFiles->caption(), $this->LitigantNameConvFiles->RequiredErrorMessage));
			}
		}
		if ($this->CaseTypeConvFiles->Required) {
			if (!$this->CaseTypeConvFiles->IsDetailKey && $this->CaseTypeConvFiles->FormValue != NULL && $this->CaseTypeConvFiles->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseTypeConvFiles->caption(), $this->CaseTypeConvFiles->RequiredErrorMessage));
			}
		}
		if ($this->CourtConvFiles->Required) {
			if (!$this->CourtConvFiles->IsDetailKey && $this->CourtConvFiles->FormValue != NULL && $this->CourtConvFiles->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CourtConvFiles->caption(), $this->CourtConvFiles->RequiredErrorMessage));
			}
		}
		if ($this->FileNumberConvFiles->Required) {
			if (!$this->FileNumberConvFiles->IsDetailKey && $this->FileNumberConvFiles->FormValue != NULL && $this->FileNumberConvFiles->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->FileNumberConvFiles->caption(), $this->FileNumberConvFiles->RequiredErrorMessage));
			}
		}
		if ($this->CaseNumberConvFiles->Required) {
			if (!$this->CaseNumberConvFiles->IsDetailKey && $this->CaseNumberConvFiles->FormValue != NULL && $this->CaseNumberConvFiles->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseNumberConvFiles->caption(), $this->CaseNumberConvFiles->RequiredErrorMessage));
			}
		}
		if ($this->NotesConvFiles->Required) {
			if (!$this->NotesConvFiles->IsDetailKey && $this->NotesConvFiles->FormValue != NULL && $this->NotesConvFiles->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NotesConvFiles->caption(), $this->NotesConvFiles->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Delete records based on current filter
	protected function deleteRows()
	{
		global $Language, $Security;
		if (!$Security->canDelete()) {
			$this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
			return FALSE;
		}
		$deleteRows = TRUE;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
			$rs->close();
			return FALSE;
		}
		$rows = ($rs) ? $rs->getRows() : [];
		if ($this->AuditTrailOnDelete)
			$this->writeAuditTrailDummy($Language->phrase("BatchDeleteBegin")); // Batch delete begin

		// Clone old rows
		$rsold = $rows;
		if ($rs)
			$rs->close();

		// Call row deleting event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$deleteRows = $this->Row_Deleting($row);
				if (!$deleteRows)
					break;
			}
		}
		if ($deleteRows) {
			$key = "";
			foreach ($rsold as $row) {
				$thisKey = "";
				if ($thisKey <> "")
					$thisKey .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
				$thisKey .= $row['CaseID'];
				if (DELETE_UPLOADED_FILES) // Delete old files
					$this->deleteUploadedFiles($row);
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				$deleteRows = $this->delete($row); // Delete
				$conn->raiseErrorFn = '';
				if ($deleteRows === FALSE)
					break;
				if ($key <> "")
					$key .= ", ";
				$key .= $thisKey;
			}
		}
		if (!$deleteRows) {

			// Set up error message
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("DeleteCancelled"));
			}
		}

		// Call Row Deleted event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$this->Row_Deleted($row);
			}
		}

		// Write JSON for API request (Support single row only)
		if (IsApi() && $deleteRows) {
			$row = $this->getRecordsFromRecordset($rsold, TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $deleteRows;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		if ($this->FileNumber->CurrentValue <> "") { // Check field with unique index
			$filterChk = "(`FileNumber` = '" . AdjustSql($this->FileNumber->CurrentValue, $this->Dbid) . "')";
			$filterChk .= " AND NOT (" . $filter . ")";
			$this->CurrentFilter = $filterChk;
			$sqlChk = $this->getCurrentSql();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rsChk = $conn->Execute($sqlChk);
			$conn->raiseErrorFn = '';
			if ($rsChk === FALSE) {
				return FALSE;
			} elseif (!$rsChk->EOF) {
				$idxErrMsg = str_replace("%f", $this->FileNumber->caption(), $Language->phrase("DupIndex"));
				$idxErrMsg = str_replace("%v", $this->FileNumber->CurrentValue, $idxErrMsg);
				$this->setFailureMessage($idxErrMsg);
				$rsChk->close();
				return FALSE;
			}
			$rsChk->close();
		}
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// ClientID
			$this->ClientID->setDbValueDef($rsnew, $this->ClientID->CurrentValue, NULL, $this->ClientID->ReadOnly);

			// LitigantID
			$this->LitigantID->setDbValueDef($rsnew, $this->LitigantID->CurrentValue, NULL, $this->LitigantID->ReadOnly);

			// CaseTypeID
			$this->CaseTypeID->setDbValueDef($rsnew, $this->CaseTypeID->CurrentValue, 0, $this->CaseTypeID->ReadOnly);

			// CourtID
			$this->CourtID->setDbValueDef($rsnew, $this->CourtID->CurrentValue, NULL, $this->CourtID->ReadOnly);

			// CaseNumber
			$this->CaseNumber->setDbValueDef($rsnew, $this->CaseNumber->CurrentValue, NULL, $this->CaseNumber->ReadOnly);

			// FileNumber
			$this->FileNumber->setDbValueDef($rsnew, $this->FileNumber->CurrentValue, "", $this->FileNumber->ReadOnly);

			// ClientStatusID
			$this->ClientStatusID->setDbValueDef($rsnew, $this->ClientStatusID->CurrentValue, 0, $this->ClientStatusID->ReadOnly);

			// LitigantStatusID
			$this->LitigantStatusID->setDbValueDef($rsnew, $this->LitigantStatusID->CurrentValue, 0, $this->LitigantStatusID->ReadOnly);

			// Notes
			$this->Notes->setDbValueDef($rsnew, $this->Notes->CurrentValue, NULL, $this->Notes->ReadOnly);

			// ParentCaseID
			$this->ParentCaseID->setDbValueDef($rsnew, $this->ParentCaseID->CurrentValue, NULL, $this->ParentCaseID->ReadOnly);

			// FileNumber2
			$this->FileNumber2->setDbValueDef($rsnew, $this->FileNumber2->CurrentValue, 0, $this->FileNumber2->ReadOnly);

			// ClientNameConvFiles
			$this->ClientNameConvFiles->setDbValueDef($rsnew, $this->ClientNameConvFiles->CurrentValue, NULL, $this->ClientNameConvFiles->ReadOnly);

			// LitigantNameConvFiles
			$this->LitigantNameConvFiles->setDbValueDef($rsnew, $this->LitigantNameConvFiles->CurrentValue, NULL, $this->LitigantNameConvFiles->ReadOnly);

			// CaseTypeConvFiles
			$this->CaseTypeConvFiles->setDbValueDef($rsnew, $this->CaseTypeConvFiles->CurrentValue, NULL, $this->CaseTypeConvFiles->ReadOnly);

			// Check referential integrity for master table 'clients'
			$validMasterRecord = TRUE;
			$masterFilter = $this->sqlMasterFilter_clients();
			$keyValue = isset($rsnew['ClientID']) ? $rsnew['ClientID'] : $rsold['ClientID'];
			if (strval($keyValue) <> "") {
				$masterFilter = str_replace("@ClientID@", AdjustSql($keyValue), $masterFilter);
			} else {
				$validMasterRecord = FALSE;
			}
			if ($validMasterRecord) {
				if (!isset($GLOBALS["clients"]))
					$GLOBALS["clients"] = new clients();
				$rsmaster = $GLOBALS["clients"]->loadRs($masterFilter);
				$validMasterRecord = ($rsmaster && !$rsmaster->EOF);
				$rsmaster->close();
			}
			if (!$validMasterRecord) {
				$relatedRecordMsg = str_replace("%t", "clients", $Language->phrase("RelatedRecordRequired"));
				$this->setFailureMessage($relatedRecordMsg);
				$rs->close();
				return FALSE;
			}

			// Check referential integrity for master table 'litigants'
			$validMasterRecord = TRUE;
			$masterFilter = $this->sqlMasterFilter_litigants();
			$keyValue = isset($rsnew['LitigantID']) ? $rsnew['LitigantID'] : $rsold['LitigantID'];
			if (strval($keyValue) <> "") {
				$masterFilter = str_replace("@LitigantID@", AdjustSql($keyValue), $masterFilter);
			} else {
				$validMasterRecord = FALSE;
			}
			if ($validMasterRecord) {
				if (!isset($GLOBALS["litigants"]))
					$GLOBALS["litigants"] = new litigants();
				$rsmaster = $GLOBALS["litigants"]->loadRs($masterFilter);
				$validMasterRecord = ($rsmaster && !$rsmaster->EOF);
				$rsmaster->close();
			}
			if (!$validMasterRecord) {
				$relatedRecordMsg = str_replace("%t", "litigants", $Language->phrase("RelatedRecordRequired"));
				$this->setFailureMessage($relatedRecordMsg);
				$rs->close();
				return FALSE;
			}

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;

		// Set up foreign key field value from Session
			if ($this->getCurrentMasterTable() == "clients") {
				$this->ClientID->CurrentValue = $this->ClientID->getSessionValue();
			}
			if ($this->getCurrentMasterTable() == "litigants") {
				$this->LitigantID->CurrentValue = $this->LitigantID->getSessionValue();
			}
		if ($this->FileNumber->CurrentValue <> "") { // Check field with unique index
			$filter = "(FileNumber = '" . AdjustSql($this->FileNumber->CurrentValue, $this->Dbid) . "')";
			$rsChk = $this->loadRs($filter);
			if ($rsChk && !$rsChk->EOF) {
				$idxErrMsg = str_replace("%f", $this->FileNumber->caption(), $Language->phrase("DupIndex"));
				$idxErrMsg = str_replace("%v", $this->FileNumber->CurrentValue, $idxErrMsg);
				$this->setFailureMessage($idxErrMsg);
				$rsChk->close();
				return FALSE;
			}
		}

		// Check referential integrity for master table 'clients'
		$validMasterRecord = TRUE;
		$masterFilter = $this->sqlMasterFilter_clients();
		if (strval($this->ClientID->CurrentValue) <> "") {
			$masterFilter = str_replace("@ClientID@", AdjustSql($this->ClientID->CurrentValue, "DB"), $masterFilter);
		} else {
			$validMasterRecord = FALSE;
		}
		if ($validMasterRecord) {
			if (!isset($GLOBALS["clients"]))
				$GLOBALS["clients"] = new clients();
			$rsmaster = $GLOBALS["clients"]->loadRs($masterFilter);
			$validMasterRecord = ($rsmaster && !$rsmaster->EOF);
			$rsmaster->close();
		}
		if (!$validMasterRecord) {
			$relatedRecordMsg = str_replace("%t", "clients", $Language->phrase("RelatedRecordRequired"));
			$this->setFailureMessage($relatedRecordMsg);
			return FALSE;
		}

		// Check referential integrity for master table 'litigants'
		$validMasterRecord = TRUE;
		$masterFilter = $this->sqlMasterFilter_litigants();
		if (strval($this->LitigantID->CurrentValue) <> "") {
			$masterFilter = str_replace("@LitigantID@", AdjustSql($this->LitigantID->CurrentValue, "DB"), $masterFilter);
		} else {
			$validMasterRecord = FALSE;
		}
		if ($validMasterRecord) {
			if (!isset($GLOBALS["litigants"]))
				$GLOBALS["litigants"] = new litigants();
			$rsmaster = $GLOBALS["litigants"]->loadRs($masterFilter);
			$validMasterRecord = ($rsmaster && !$rsmaster->EOF);
			$rsmaster->close();
		}
		if (!$validMasterRecord) {
			$relatedRecordMsg = str_replace("%t", "litigants", $Language->phrase("RelatedRecordRequired"));
			$this->setFailureMessage($relatedRecordMsg);
			return FALSE;
		}
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// ClientID
		$this->ClientID->setDbValueDef($rsnew, $this->ClientID->CurrentValue, NULL, FALSE);

		// LitigantID
		$this->LitigantID->setDbValueDef($rsnew, $this->LitigantID->CurrentValue, NULL, FALSE);

		// CaseTypeID
		$this->CaseTypeID->setDbValueDef($rsnew, $this->CaseTypeID->CurrentValue, 0, strval($this->CaseTypeID->CurrentValue) == "");

		// CourtID
		$this->CourtID->setDbValueDef($rsnew, $this->CourtID->CurrentValue, NULL, FALSE);

		// CaseNumber
		$this->CaseNumber->setDbValueDef($rsnew, $this->CaseNumber->CurrentValue, NULL, FALSE);

		// FileNumber
		$this->FileNumber->setDbValueDef($rsnew, $this->FileNumber->CurrentValue, "", FALSE);

		// ClientStatusID
		$this->ClientStatusID->setDbValueDef($rsnew, $this->ClientStatusID->CurrentValue, 0, strval($this->ClientStatusID->CurrentValue) == "");

		// LitigantStatusID
		$this->LitigantStatusID->setDbValueDef($rsnew, $this->LitigantStatusID->CurrentValue, 0, strval($this->LitigantStatusID->CurrentValue) == "");

		// Notes
		$this->Notes->setDbValueDef($rsnew, $this->Notes->CurrentValue, NULL, FALSE);

		// ParentCaseID
		$this->ParentCaseID->setDbValueDef($rsnew, $this->ParentCaseID->CurrentValue, NULL, FALSE);

		// FileNumber2
		$this->FileNumber2->setDbValueDef($rsnew, $this->FileNumber2->CurrentValue, 0, FALSE);

		// ClientNameConvFiles
		$this->ClientNameConvFiles->setDbValueDef($rsnew, $this->ClientNameConvFiles->CurrentValue, NULL, FALSE);

		// LitigantNameConvFiles
		$this->LitigantNameConvFiles->setDbValueDef($rsnew, $this->LitigantNameConvFiles->CurrentValue, NULL, FALSE);

		// CaseTypeConvFiles
		$this->CaseTypeConvFiles->setDbValueDef($rsnew, $this->CaseTypeConvFiles->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up master/detail based on QueryString
	protected function setupMasterParms()
	{

		// Hide foreign keys
		$masterTblVar = $this->getCurrentMasterTable();
		if ($masterTblVar == "clients") {
			$this->ClientID->Visible = FALSE;
			if ($GLOBALS["clients"]->EventCancelled)
				$this->EventCancelled = TRUE;
		}
		if ($masterTblVar == "litigants") {
			$this->LitigantID->Visible = FALSE;
			if ($GLOBALS["litigants"]->EventCancelled)
				$this->EventCancelled = TRUE;
		}
		$this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_ClientID":
							break;
						case "x_LitigantID":
							break;
						case "x_CaseTypeID":
							break;
						case "x_CourtID":
							break;
						case "x_ClientStatusID":
							break;
						case "x_LitigantStatusID":
							break;
						case "x_CourtTypeID":
							break;
						case "x_CourtGenderID":
							break;
						case "x_JudgeID":
							break;
						case "x_CaseSortID":
							break;
						case "x_CaseStatusID":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}
}
?>
