<?php
namespace PHPMaker2019\project_germanos;

/**
 * Page class
 */
class cases_search extends cases
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{8D47CED4-FEF0-4756-8F48-9FC38A15AA2A}";

	// Table name
	public $TableName = 'cases';

	// Page object name
	public $PageObjName = "cases_search";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (cases)
		if (!isset($GLOBALS["cases"]) || get_class($GLOBALS["cases"]) == PROJECT_NAMESPACE . "cases") {
			$GLOBALS["cases"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["cases"];
		}

		// Table object (clients)
		if (!isset($GLOBALS['clients']))
			$GLOBALS['clients'] = new clients();

		// Table object (employees)
		if (!isset($GLOBALS['employees']))
			$GLOBALS['employees'] = new employees();

		// Table object (litigants)
		if (!isset($GLOBALS['litigants']))
			$GLOBALS['litigants'] = new litigants();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'cases');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new employees();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $cases;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($cases);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "casesview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['CaseID'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->CaseID->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (IsPasswordExpired())
				$this->terminate(GetUrl("changepwd.php"));
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("caseslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Update last accessed time
		if ($UserProfile->isValidUser(CurrentUserName(), session_id())) {
		} else {
			Write($Language->phrase("UserProfileCorrupted"));
			$this->terminate();
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->CaseID->setVisibility();
		$this->ClientID->setVisibility();
		$this->LitigantID->setVisibility();
		$this->CaseTypeID->setVisibility();
		$this->CourtID->setVisibility();
		$this->CaseNumber->setVisibility();
		$this->FileNumber->setVisibility();
		$this->EnvelopeNumber->Visible = FALSE;
		$this->ClientStatusID->setVisibility();
		$this->LitigantStatusID->setVisibility();
		$this->CourtTypeID->Visible = FALSE;
		$this->CourtGenderID->Visible = FALSE;
		$this->JudgeID->setVisibility();
		$this->Notes->setVisibility();
		$this->FileLocation->setVisibility();
		$this->_Case->setVisibility();
		$this->CaseEn->Visible = FALSE;
		$this->CaseSortID->setVisibility();
		$this->CaseRegisteredDate->setVisibility();
		$this->CaseStatusID->setVisibility();
		$this->ParentCaseID->setVisibility();
		$this->FileNumber2->Visible = FALSE;
		$this->_UserID->Visible = FALSE;
		$this->CreatedBy->Visible = FALSE;
		$this->CreatedDate->Visible = FALSE;
		$this->UpdatedBy->Visible = FALSE;
		$this->UpdatedDate->Visible = FALSE;
		$this->CaseTypeConv->Visible = FALSE;
		$this->CaseConv->Visible = FALSE;
		$this->ClientStatusConv->Visible = FALSE;
		$this->LitigantStatusConv->Visible = FALSE;
		$this->ClientNameConv->Visible = FALSE;
		$this->LitigantNameConv->Visible = FALSE;
		$this->ClientNameConvFiles->Visible = FALSE;
		$this->LitigantNameConvFiles->Visible = FALSE;
		$this->CaseTypeConvFiles->Visible = FALSE;
		$this->CourtConvFiles->Visible = FALSE;
		$this->FileNumberConvFiles->Visible = FALSE;
		$this->CaseNumberConvFiles->Visible = FALSE;
		$this->NotesConvFiles->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->ClientID);
		$this->setupLookupOptions($this->LitigantID);
		$this->setupLookupOptions($this->CaseTypeID);
		$this->setupLookupOptions($this->CourtID);
		$this->setupLookupOptions($this->ClientStatusID);
		$this->setupLookupOptions($this->LitigantStatusID);
		$this->setupLookupOptions($this->CourtTypeID);
		$this->setupLookupOptions($this->CourtGenderID);
		$this->setupLookupOptions($this->JudgeID);
		$this->setupLookupOptions($this->CaseSortID);
		$this->setupLookupOptions($this->CaseStatusID);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-search-form ew-horizontal";
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "caseslist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->CaseID); // CaseID
		$this->buildSearchUrl($srchUrl, $this->ClientID); // ClientID
		$this->buildSearchUrl($srchUrl, $this->LitigantID); // LitigantID
		$this->buildSearchUrl($srchUrl, $this->CaseTypeID); // CaseTypeID
		$this->buildSearchUrl($srchUrl, $this->CourtID); // CourtID
		$this->buildSearchUrl($srchUrl, $this->CaseNumber); // CaseNumber
		$this->buildSearchUrl($srchUrl, $this->FileNumber); // FileNumber
		$this->buildSearchUrl($srchUrl, $this->ClientStatusID); // ClientStatusID
		$this->buildSearchUrl($srchUrl, $this->LitigantStatusID); // LitigantStatusID
		$this->buildSearchUrl($srchUrl, $this->JudgeID); // JudgeID
		$this->buildSearchUrl($srchUrl, $this->Notes); // Notes
		$this->buildSearchUrl($srchUrl, $this->FileLocation); // FileLocation
		$this->buildSearchUrl($srchUrl, $this->_Case); // Case
		$this->buildSearchUrl($srchUrl, $this->CaseSortID); // CaseSortID
		$this->buildSearchUrl($srchUrl, $this->CaseRegisteredDate); // CaseRegisteredDate
		$this->buildSearchUrl($srchUrl, $this->CaseStatusID); // CaseStatusID
		$this->buildSearchUrl($srchUrl, $this->ParentCaseID); // ParentCaseID
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// CaseID

		if (!$this->isAddOrEdit())
			$this->CaseID->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_CaseID"));
		$this->CaseID->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_CaseID"));

		// ClientID
		if (!$this->isAddOrEdit())
			$this->ClientID->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_ClientID"));
		$this->ClientID->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_ClientID"));

		// LitigantID
		if (!$this->isAddOrEdit())
			$this->LitigantID->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_LitigantID"));
		$this->LitigantID->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_LitigantID"));

		// CaseTypeID
		if (!$this->isAddOrEdit())
			$this->CaseTypeID->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_CaseTypeID"));
		$this->CaseTypeID->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_CaseTypeID"));

		// CourtID
		if (!$this->isAddOrEdit())
			$this->CourtID->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_CourtID"));
		$this->CourtID->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_CourtID"));

		// CaseNumber
		if (!$this->isAddOrEdit())
			$this->CaseNumber->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_CaseNumber"));
		$this->CaseNumber->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_CaseNumber"));

		// FileNumber
		if (!$this->isAddOrEdit())
			$this->FileNumber->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_FileNumber"));
		$this->FileNumber->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_FileNumber"));

		// ClientStatusID
		if (!$this->isAddOrEdit())
			$this->ClientStatusID->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_ClientStatusID"));
		$this->ClientStatusID->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_ClientStatusID"));

		// LitigantStatusID
		if (!$this->isAddOrEdit())
			$this->LitigantStatusID->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_LitigantStatusID"));
		$this->LitigantStatusID->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_LitigantStatusID"));

		// JudgeID
		if (!$this->isAddOrEdit())
			$this->JudgeID->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_JudgeID"));
		$this->JudgeID->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_JudgeID"));

		// Notes
		if (!$this->isAddOrEdit())
			$this->Notes->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_Notes"));
		$this->Notes->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_Notes"));

		// FileLocation
		if (!$this->isAddOrEdit())
			$this->FileLocation->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_FileLocation"));
		$this->FileLocation->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_FileLocation"));

		// Case
		if (!$this->isAddOrEdit())
			$this->_Case->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__Case"));
		$this->_Case->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__Case"));

		// CaseSortID
		if (!$this->isAddOrEdit())
			$this->CaseSortID->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_CaseSortID"));
		$this->CaseSortID->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_CaseSortID"));

		// CaseRegisteredDate
		if (!$this->isAddOrEdit())
			$this->CaseRegisteredDate->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_CaseRegisteredDate"));
		$this->CaseRegisteredDate->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_CaseRegisteredDate"));

		// CaseStatusID
		if (!$this->isAddOrEdit())
			$this->CaseStatusID->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_CaseStatusID"));
		$this->CaseStatusID->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_CaseStatusID"));

		// ParentCaseID
		if (!$this->isAddOrEdit())
			$this->ParentCaseID->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_ParentCaseID"));
		$this->ParentCaseID->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_ParentCaseID"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// CaseID
		// ClientID
		// LitigantID
		// CaseTypeID
		// CourtID
		// CaseNumber
		// FileNumber
		// EnvelopeNumber
		// ClientStatusID
		// LitigantStatusID
		// CourtTypeID
		// CourtGenderID
		// JudgeID
		// Notes
		// FileLocation
		// Case
		// CaseEn
		// CaseSortID
		// CaseRegisteredDate
		// CaseStatusID
		// ParentCaseID
		// FileNumber2
		// UserID
		// CreatedBy
		// CreatedDate
		// UpdatedBy
		// UpdatedDate
		// CaseTypeConv
		// CaseConv
		// ClientStatusConv
		// LitigantStatusConv
		// ClientNameConv
		// LitigantNameConv
		// ClientNameConvFiles
		// LitigantNameConvFiles
		// CaseTypeConvFiles
		// CourtConvFiles
		// FileNumberConvFiles
		// CaseNumberConvFiles
		// NotesConvFiles

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// CaseID
			$this->CaseID->ViewValue = $this->CaseID->CurrentValue;
			$this->CaseID->ViewCustomAttributes = "";

			// ClientID
			if ($this->ClientID->VirtualValue <> "") {
				$this->ClientID->ViewValue = $this->ClientID->VirtualValue;
			} else {
				$this->ClientID->ViewValue = $this->ClientID->CurrentValue;
			$curVal = strval($this->ClientID->CurrentValue);
			if ($curVal <> "") {
				$this->ClientID->ViewValue = $this->ClientID->lookupCacheOption($curVal);
				if ($this->ClientID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`ClientID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ClientID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->ClientID->ViewValue = $this->ClientID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ClientID->ViewValue = $this->ClientID->CurrentValue;
					}
				}
			} else {
				$this->ClientID->ViewValue = NULL;
			}
			}
			$this->ClientID->CssStyle = "font-weight: bold;";
			$this->ClientID->ViewCustomAttributes = "";

			// LitigantID
			if ($this->LitigantID->VirtualValue <> "") {
				$this->LitigantID->ViewValue = $this->LitigantID->VirtualValue;
			} else {
				$this->LitigantID->ViewValue = $this->LitigantID->CurrentValue;
			$curVal = strval($this->LitigantID->CurrentValue);
			if ($curVal <> "") {
				$this->LitigantID->ViewValue = $this->LitigantID->lookupCacheOption($curVal);
				if ($this->LitigantID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`LitigantID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->LitigantID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->LitigantID->ViewValue = $this->LitigantID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->LitigantID->ViewValue = $this->LitigantID->CurrentValue;
					}
				}
			} else {
				$this->LitigantID->ViewValue = NULL;
			}
			}
			$this->LitigantID->CssStyle = "font-weight: bold;";
			$this->LitigantID->ViewCustomAttributes = "";

			// CaseTypeID
			if ($this->CaseTypeID->VirtualValue <> "") {
				$this->CaseTypeID->ViewValue = $this->CaseTypeID->VirtualValue;
			} else {
			$curVal = strval($this->CaseTypeID->CurrentValue);
			if ($curVal <> "") {
				$this->CaseTypeID->ViewValue = $this->CaseTypeID->lookupCacheOption($curVal);
				if ($this->CaseTypeID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CaseTypeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CaseTypeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CaseTypeID->ViewValue = $this->CaseTypeID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CaseTypeID->ViewValue = $this->CaseTypeID->CurrentValue;
					}
				}
			} else {
				$this->CaseTypeID->ViewValue = NULL;
			}
			}
			$this->CaseTypeID->CssStyle = "font-style: italic;";
			$this->CaseTypeID->ViewCustomAttributes = "";

			// CourtID
			if ($this->CourtID->VirtualValue <> "") {
				$this->CourtID->ViewValue = $this->CourtID->VirtualValue;
			} else {
				$this->CourtID->ViewValue = $this->CourtID->CurrentValue;
			$curVal = strval($this->CourtID->CurrentValue);
			if ($curVal <> "") {
				$this->CourtID->ViewValue = $this->CourtID->lookupCacheOption($curVal);
				if ($this->CourtID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CourtID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CourtID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CourtID->ViewValue = $this->CourtID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CourtID->ViewValue = $this->CourtID->CurrentValue;
					}
				}
			} else {
				$this->CourtID->ViewValue = NULL;
			}
			}
			$this->CourtID->ViewCustomAttributes = "";

			// CaseNumber
			$this->CaseNumber->ViewValue = $this->CaseNumber->CurrentValue;
			$this->CaseNumber->ViewCustomAttributes = "";

			// FileNumber
			$this->FileNumber->ViewValue = $this->FileNumber->CurrentValue;
			$this->FileNumber->ViewCustomAttributes = "";

			// ClientStatusID
			if ($this->ClientStatusID->VirtualValue <> "") {
				$this->ClientStatusID->ViewValue = $this->ClientStatusID->VirtualValue;
			} else {
			$curVal = strval($this->ClientStatusID->CurrentValue);
			if ($curVal <> "") {
				$this->ClientStatusID->ViewValue = $this->ClientStatusID->lookupCacheOption($curVal);
				if ($this->ClientStatusID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`PartiesStatusID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ClientStatusID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->ClientStatusID->ViewValue = $this->ClientStatusID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ClientStatusID->ViewValue = $this->ClientStatusID->CurrentValue;
					}
				}
			} else {
				$this->ClientStatusID->ViewValue = NULL;
			}
			}
			$this->ClientStatusID->CssStyle = "font-style: italic;";
			$this->ClientStatusID->ViewCustomAttributes = "";

			// LitigantStatusID
			if ($this->LitigantStatusID->VirtualValue <> "") {
				$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->VirtualValue;
			} else {
			$curVal = strval($this->LitigantStatusID->CurrentValue);
			if ($curVal <> "") {
				$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->lookupCacheOption($curVal);
				if ($this->LitigantStatusID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`PartiesStatusID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->LitigantStatusID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->CurrentValue;
					}
				}
			} else {
				$this->LitigantStatusID->ViewValue = NULL;
			}
			}
			$this->LitigantStatusID->CssStyle = "font-style: italic;";
			$this->LitigantStatusID->ViewCustomAttributes = "";

			// JudgeID
			if ($this->JudgeID->VirtualValue <> "") {
				$this->JudgeID->ViewValue = $this->JudgeID->VirtualValue;
			} else {
			$curVal = strval($this->JudgeID->CurrentValue);
			if ($curVal <> "") {
				$this->JudgeID->ViewValue = $this->JudgeID->lookupCacheOption($curVal);
				if ($this->JudgeID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`JudgeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->JudgeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->JudgeID->ViewValue = $this->JudgeID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->JudgeID->ViewValue = $this->JudgeID->CurrentValue;
					}
				}
			} else {
				$this->JudgeID->ViewValue = NULL;
			}
			}
			$this->JudgeID->ViewCustomAttributes = "";

			// Notes
			$this->Notes->ViewValue = $this->Notes->CurrentValue;
			$this->Notes->ViewCustomAttributes = "";

			// FileLocation
			$this->FileLocation->ViewValue = $this->FileLocation->CurrentValue;
			$this->FileLocation->ViewCustomAttributes = "";

			// Case
			$this->_Case->ViewValue = $this->_Case->CurrentValue;
			$this->_Case->ViewCustomAttributes = "";

			// CaseSortID
			if ($this->CaseSortID->VirtualValue <> "") {
				$this->CaseSortID->ViewValue = $this->CaseSortID->VirtualValue;
			} else {
			$curVal = strval($this->CaseSortID->CurrentValue);
			if ($curVal <> "") {
				$this->CaseSortID->ViewValue = $this->CaseSortID->lookupCacheOption($curVal);
				if ($this->CaseSortID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CaseSortID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CaseSortID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CaseSortID->ViewValue = $this->CaseSortID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CaseSortID->ViewValue = $this->CaseSortID->CurrentValue;
					}
				}
			} else {
				$this->CaseSortID->ViewValue = NULL;
			}
			}
			$this->CaseSortID->ViewCustomAttributes = "";

			// CaseRegisteredDate
			$this->CaseRegisteredDate->ViewValue = $this->CaseRegisteredDate->CurrentValue;
			$this->CaseRegisteredDate->ViewValue = FormatDateTime($this->CaseRegisteredDate->ViewValue, 7);
			$this->CaseRegisteredDate->ViewCustomAttributes = "";

			// CaseStatusID
			if ($this->CaseStatusID->VirtualValue <> "") {
				$this->CaseStatusID->ViewValue = $this->CaseStatusID->VirtualValue;
			} else {
			$curVal = strval($this->CaseStatusID->CurrentValue);
			if ($curVal <> "") {
				$this->CaseStatusID->ViewValue = $this->CaseStatusID->lookupCacheOption($curVal);
				if ($this->CaseStatusID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CaseStatusID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CaseStatusID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CaseStatusID->ViewValue = $this->CaseStatusID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CaseStatusID->ViewValue = $this->CaseStatusID->CurrentValue;
					}
				}
			} else {
				$this->CaseStatusID->ViewValue = NULL;
			}
			}
			$this->CaseStatusID->CssStyle = "font-style: italic;";
			$this->CaseStatusID->ViewCustomAttributes = "";

			// ParentCaseID
			$this->ParentCaseID->ViewValue = $this->ParentCaseID->CurrentValue;
			$this->ParentCaseID->ViewValue = FormatNumber($this->ParentCaseID->ViewValue, 0, -2, -2, -2);
			$this->ParentCaseID->ViewCustomAttributes = "";

			// ClientNameConvFiles
			$this->ClientNameConvFiles->ViewValue = $this->ClientNameConvFiles->CurrentValue;
			$this->ClientNameConvFiles->ViewCustomAttributes = "";

			// LitigantNameConvFiles
			$this->LitigantNameConvFiles->ViewValue = $this->LitigantNameConvFiles->CurrentValue;
			$this->LitigantNameConvFiles->ViewCustomAttributes = "";

			// CaseTypeConvFiles
			$this->CaseTypeConvFiles->ViewValue = $this->CaseTypeConvFiles->CurrentValue;
			$this->CaseTypeConvFiles->ViewCustomAttributes = "";

			// CaseID
			$this->CaseID->LinkCustomAttributes = "";
			$this->CaseID->HrefValue = "";
			$this->CaseID->TooltipValue = "";

			// ClientID
			$this->ClientID->LinkCustomAttributes = "";
			if (!EmptyValue($this->ClientID->CurrentValue)) {
				$this->ClientID->HrefValue = "/home/clientsview.php?showdetail=clientaddress,clientcontact,cases&ClientID=" . $this->ClientID->CurrentValue; // Add prefix/suffix
				$this->ClientID->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->ClientID->HrefValue = FullUrl($this->ClientID->HrefValue, "href");
			} else {
				$this->ClientID->HrefValue = "";
			}
			$this->ClientID->TooltipValue = "";

			// LitigantID
			$this->LitigantID->LinkCustomAttributes = "";
			if (!EmptyValue($this->LitigantID->CurrentValue)) {
				$this->LitigantID->HrefValue = "/home/litigantsview.php?showdetail=litigantaddress,litigantcontact,cases&LitigantID=" . $this->LitigantID->CurrentValue; // Add prefix/suffix
				$this->LitigantID->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->LitigantID->HrefValue = FullUrl($this->LitigantID->HrefValue, "href");
			} else {
				$this->LitigantID->HrefValue = "";
			}
			$this->LitigantID->TooltipValue = "";

			// CaseTypeID
			$this->CaseTypeID->LinkCustomAttributes = "";
			$this->CaseTypeID->HrefValue = "";
			$this->CaseTypeID->TooltipValue = "";

			// CourtID
			$this->CourtID->LinkCustomAttributes = "";
			if (!EmptyValue($this->CourtID->CurrentValue)) {
				$this->CourtID->HrefValue = "/home/courtsview.php?showdetail=courtaddress,courtcontact&CourtID=" . $this->CourtID->CurrentValue; // Add prefix/suffix
				$this->CourtID->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->CourtID->HrefValue = FullUrl($this->CourtID->HrefValue, "href");
			} else {
				$this->CourtID->HrefValue = "";
			}
			$this->CourtID->TooltipValue = "";

			// CaseNumber
			$this->CaseNumber->LinkCustomAttributes = "";
			$this->CaseNumber->HrefValue = "";
			$this->CaseNumber->TooltipValue = "";

			// FileNumber
			$this->FileNumber->LinkCustomAttributes = "";
			$this->FileNumber->HrefValue = "";
			$this->FileNumber->TooltipValue = "";

			// ClientStatusID
			$this->ClientStatusID->LinkCustomAttributes = "";
			$this->ClientStatusID->HrefValue = "";
			$this->ClientStatusID->TooltipValue = "";

			// LitigantStatusID
			$this->LitigantStatusID->LinkCustomAttributes = "";
			$this->LitigantStatusID->HrefValue = "";
			$this->LitigantStatusID->TooltipValue = "";

			// JudgeID
			$this->JudgeID->LinkCustomAttributes = "";
			if (!EmptyValue($this->JudgeID->CurrentValue)) {
				$this->JudgeID->HrefValue = "/home/judgesview.php?showdetail=judgecontact,judgeaddress&JudgeID=" . $this->JudgeID->CurrentValue; // Add prefix/suffix
				$this->JudgeID->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->JudgeID->HrefValue = FullUrl($this->JudgeID->HrefValue, "href");
			} else {
				$this->JudgeID->HrefValue = "";
			}
			$this->JudgeID->TooltipValue = "";

			// Notes
			$this->Notes->LinkCustomAttributes = "";
			$this->Notes->HrefValue = "";
			$this->Notes->TooltipValue = "";

			// FileLocation
			$this->FileLocation->LinkCustomAttributes = "";
			$this->FileLocation->HrefValue = "";
			$this->FileLocation->TooltipValue = "";

			// Case
			$this->_Case->LinkCustomAttributes = "";
			$this->_Case->HrefValue = "";
			$this->_Case->TooltipValue = "";

			// CaseSortID
			$this->CaseSortID->LinkCustomAttributes = "";
			$this->CaseSortID->HrefValue = "";
			$this->CaseSortID->TooltipValue = "";

			// CaseRegisteredDate
			$this->CaseRegisteredDate->LinkCustomAttributes = "";
			$this->CaseRegisteredDate->HrefValue = "";
			$this->CaseRegisteredDate->TooltipValue = "";

			// CaseStatusID
			$this->CaseStatusID->LinkCustomAttributes = "";
			$this->CaseStatusID->HrefValue = "";
			$this->CaseStatusID->TooltipValue = "";

			// ParentCaseID
			$this->ParentCaseID->LinkCustomAttributes = "";
			$this->ParentCaseID->HrefValue = "";
			$this->ParentCaseID->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// CaseID
			$this->CaseID->EditAttrs["class"] = "form-control";
			$this->CaseID->EditCustomAttributes = "";
			$this->CaseID->EditValue = HtmlEncode($this->CaseID->AdvancedSearch->SearchValue);
			$this->CaseID->PlaceHolder = RemoveHtml($this->CaseID->caption());

			// ClientID
			$this->ClientID->EditAttrs["class"] = "form-control";
			$this->ClientID->EditCustomAttributes = "";
			$this->ClientID->EditValue = HtmlEncode($this->ClientID->AdvancedSearch->SearchValue);
			$this->ClientID->PlaceHolder = RemoveHtml($this->ClientID->caption());

			// LitigantID
			$this->LitigantID->EditAttrs["class"] = "form-control";
			$this->LitigantID->EditCustomAttributes = "";
			$this->LitigantID->EditValue = HtmlEncode($this->LitigantID->AdvancedSearch->SearchValue);
			$this->LitigantID->PlaceHolder = RemoveHtml($this->LitigantID->caption());

			// CaseTypeID
			$this->CaseTypeID->EditAttrs["class"] = "form-control";
			$this->CaseTypeID->EditCustomAttributes = "";
			$this->CaseTypeID->EditValue = HtmlEncode($this->CaseTypeID->AdvancedSearch->SearchValue);
			$this->CaseTypeID->PlaceHolder = RemoveHtml($this->CaseTypeID->caption());

			// CourtID
			$this->CourtID->EditAttrs["class"] = "form-control";
			$this->CourtID->EditCustomAttributes = "";
			$this->CourtID->EditValue = HtmlEncode($this->CourtID->AdvancedSearch->SearchValue);
			$this->CourtID->PlaceHolder = RemoveHtml($this->CourtID->caption());

			// CaseNumber
			$this->CaseNumber->EditAttrs["class"] = "form-control";
			$this->CaseNumber->EditCustomAttributes = "";
			$this->CaseNumber->EditValue = HtmlEncode($this->CaseNumber->AdvancedSearch->SearchValue);
			$this->CaseNumber->PlaceHolder = RemoveHtml($this->CaseNumber->caption());

			// FileNumber
			$this->FileNumber->EditAttrs["class"] = "form-control";
			$this->FileNumber->EditCustomAttributes = "";
			$this->FileNumber->EditValue = HtmlEncode($this->FileNumber->AdvancedSearch->SearchValue);
			$this->FileNumber->PlaceHolder = RemoveHtml($this->FileNumber->caption());

			// ClientStatusID
			$this->ClientStatusID->EditAttrs["class"] = "form-control";
			$this->ClientStatusID->EditCustomAttributes = "";
			$this->ClientStatusID->EditValue = HtmlEncode($this->ClientStatusID->AdvancedSearch->SearchValue);
			$this->ClientStatusID->PlaceHolder = RemoveHtml($this->ClientStatusID->caption());

			// LitigantStatusID
			$this->LitigantStatusID->EditAttrs["class"] = "form-control";
			$this->LitigantStatusID->EditCustomAttributes = "";
			$this->LitigantStatusID->EditValue = HtmlEncode($this->LitigantStatusID->AdvancedSearch->SearchValue);
			$this->LitigantStatusID->PlaceHolder = RemoveHtml($this->LitigantStatusID->caption());

			// JudgeID
			$this->JudgeID->EditAttrs["class"] = "form-control";
			$this->JudgeID->EditCustomAttributes = "";
			$this->JudgeID->EditValue = HtmlEncode($this->JudgeID->AdvancedSearch->SearchValue);
			$this->JudgeID->PlaceHolder = RemoveHtml($this->JudgeID->caption());

			// Notes
			$this->Notes->EditAttrs["class"] = "form-control";
			$this->Notes->EditCustomAttributes = "";
			$this->Notes->EditValue = HtmlEncode($this->Notes->AdvancedSearch->SearchValue);
			$this->Notes->PlaceHolder = RemoveHtml($this->Notes->caption());

			// FileLocation
			$this->FileLocation->EditAttrs["class"] = "form-control";
			$this->FileLocation->EditCustomAttributes = "";
			$this->FileLocation->EditValue = HtmlEncode($this->FileLocation->AdvancedSearch->SearchValue);
			$this->FileLocation->PlaceHolder = RemoveHtml($this->FileLocation->caption());

			// Case
			$this->_Case->EditAttrs["class"] = "form-control";
			$this->_Case->EditCustomAttributes = "";
			$this->_Case->EditValue = HtmlEncode($this->_Case->AdvancedSearch->SearchValue);
			$this->_Case->PlaceHolder = RemoveHtml($this->_Case->caption());

			// CaseSortID
			$this->CaseSortID->EditAttrs["class"] = "form-control";
			$this->CaseSortID->EditCustomAttributes = "";
			$this->CaseSortID->EditValue = HtmlEncode($this->CaseSortID->AdvancedSearch->SearchValue);
			$this->CaseSortID->PlaceHolder = RemoveHtml($this->CaseSortID->caption());

			// CaseRegisteredDate
			$this->CaseRegisteredDate->EditAttrs["class"] = "form-control";
			$this->CaseRegisteredDate->EditCustomAttributes = "";
			$this->CaseRegisteredDate->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->CaseRegisteredDate->AdvancedSearch->SearchValue, 7), 7));
			$this->CaseRegisteredDate->PlaceHolder = RemoveHtml($this->CaseRegisteredDate->caption());

			// CaseStatusID
			$this->CaseStatusID->EditAttrs["class"] = "form-control";
			$this->CaseStatusID->EditCustomAttributes = "";
			$this->CaseStatusID->EditValue = HtmlEncode($this->CaseStatusID->AdvancedSearch->SearchValue);
			$this->CaseStatusID->PlaceHolder = RemoveHtml($this->CaseStatusID->caption());

			// ParentCaseID
			$this->ParentCaseID->EditAttrs["class"] = "form-control";
			$this->ParentCaseID->EditCustomAttributes = "";
			$this->ParentCaseID->EditValue = HtmlEncode($this->ParentCaseID->AdvancedSearch->SearchValue);
			$this->ParentCaseID->PlaceHolder = RemoveHtml($this->ParentCaseID->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckEuroDate($this->CaseRegisteredDate->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->CaseRegisteredDate->errorMessage());
		}
		if (!CheckInteger($this->ParentCaseID->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->ParentCaseID->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->CaseID->AdvancedSearch->load();
		$this->ClientID->AdvancedSearch->load();
		$this->LitigantID->AdvancedSearch->load();
		$this->CaseTypeID->AdvancedSearch->load();
		$this->CourtID->AdvancedSearch->load();
		$this->CaseNumber->AdvancedSearch->load();
		$this->FileNumber->AdvancedSearch->load();
		$this->ClientStatusID->AdvancedSearch->load();
		$this->LitigantStatusID->AdvancedSearch->load();
		$this->JudgeID->AdvancedSearch->load();
		$this->Notes->AdvancedSearch->load();
		$this->FileLocation->AdvancedSearch->load();
		$this->_Case->AdvancedSearch->load();
		$this->CaseSortID->AdvancedSearch->load();
		$this->CaseRegisteredDate->AdvancedSearch->load();
		$this->CaseStatusID->AdvancedSearch->load();
		$this->ParentCaseID->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("caseslist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_ClientID":
							break;
						case "x_LitigantID":
							break;
						case "x_CaseTypeID":
							break;
						case "x_CourtID":
							break;
						case "x_ClientStatusID":
							break;
						case "x_LitigantStatusID":
							break;
						case "x_CourtTypeID":
							break;
						case "x_CourtGenderID":
							break;
						case "x_JudgeID":
							break;
						case "x_CaseSortID":
							break;
						case "x_CaseStatusID":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
