<?php
namespace PHPMaker2019\project_germanos;

/**
 * Page class
 */
class clientadditinalinfo_search extends clientadditinalinfo
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{8D47CED4-FEF0-4756-8F48-9FC38A15AA2A}";

	// Table name
	public $TableName = 'clientadditinalinfo';

	// Page object name
	public $PageObjName = "clientadditinalinfo_search";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (clientadditinalinfo)
		if (!isset($GLOBALS["clientadditinalinfo"]) || get_class($GLOBALS["clientadditinalinfo"]) == PROJECT_NAMESPACE . "clientadditinalinfo") {
			$GLOBALS["clientadditinalinfo"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["clientadditinalinfo"];
		}

		// Table object (clients)
		if (!isset($GLOBALS['clients']))
			$GLOBALS['clients'] = new clients();

		// Table object (employees)
		if (!isset($GLOBALS['employees']))
			$GLOBALS['employees'] = new employees();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'clientadditinalinfo');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new employees();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $clientadditinalinfo;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($clientadditinalinfo);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "clientadditinalinfoview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['ClientInfoID'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->ClientInfoID->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (IsPasswordExpired())
				$this->terminate(GetUrl("changepwd.php"));
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("clientadditinalinfolist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Update last accessed time
		if ($UserProfile->isValidUser(CurrentUserName(), session_id())) {
		} else {
			Write($Language->phrase("UserProfileCorrupted"));
			$this->terminate();
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->ClientInfoID->setVisibility();
		$this->ClientID->setVisibility();
		$this->Notes->setVisibility();
		$this->MaritalStatusID->setVisibility();
		$this->CivilStatus23->setVisibility();
		$this->CivilStatusPlace->setVisibility();
		$this->IdCard23->setVisibility();
		$this->NationalId23->setVisibility();
		$this->Nationality1->setVisibility();
		$this->Nationality2->setVisibility();
		$this->Nationality3->setVisibility();
		$this->DriverLicense23->setVisibility();
		$this->SocialSecurity23->setVisibility();
		$this->Financial23->setVisibility();
		$this->Extra23->setVisibility();
		$this->Field1->setVisibility();
		$this->Field2->setVisibility();
		$this->Field3->setVisibility();
		$this->_UserID->Visible = FALSE;
		$this->CreatedBy->Visible = FALSE;
		$this->CreatedDate->Visible = FALSE;
		$this->UpdatedBy->Visible = FALSE;
		$this->UpdatedDate->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->ClientID);
		$this->setupLookupOptions($this->MaritalStatusID);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-search-form ew-horizontal";
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "clientadditinalinfolist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->ClientInfoID); // ClientInfoID
		$this->buildSearchUrl($srchUrl, $this->ClientID); // ClientID
		$this->buildSearchUrl($srchUrl, $this->Notes); // Notes
		$this->buildSearchUrl($srchUrl, $this->MaritalStatusID); // MaritalStatusID
		$this->buildSearchUrl($srchUrl, $this->CivilStatus23); // CivilStatus#
		$this->buildSearchUrl($srchUrl, $this->CivilStatusPlace); // CivilStatusPlace
		$this->buildSearchUrl($srchUrl, $this->IdCard23); // IdCard#
		$this->buildSearchUrl($srchUrl, $this->NationalId23); // NationalId#
		$this->buildSearchUrl($srchUrl, $this->Nationality1); // Nationality1
		$this->buildSearchUrl($srchUrl, $this->Nationality2); // Nationality2
		$this->buildSearchUrl($srchUrl, $this->Nationality3); // Nationality3
		$this->buildSearchUrl($srchUrl, $this->DriverLicense23); // DriverLicense#
		$this->buildSearchUrl($srchUrl, $this->SocialSecurity23); // SocialSecurity#
		$this->buildSearchUrl($srchUrl, $this->Financial23); // Financial#
		$this->buildSearchUrl($srchUrl, $this->Extra23); // Extra#
		$this->buildSearchUrl($srchUrl, $this->Field1); // Field1
		$this->buildSearchUrl($srchUrl, $this->Field2); // Field2
		$this->buildSearchUrl($srchUrl, $this->Field3); // Field3
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// ClientInfoID

		if (!$this->isAddOrEdit())
			$this->ClientInfoID->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_ClientInfoID"));
		$this->ClientInfoID->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_ClientInfoID"));

		// ClientID
		if (!$this->isAddOrEdit())
			$this->ClientID->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_ClientID"));
		$this->ClientID->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_ClientID"));

		// Notes
		if (!$this->isAddOrEdit())
			$this->Notes->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_Notes"));
		$this->Notes->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_Notes"));

		// MaritalStatusID
		if (!$this->isAddOrEdit())
			$this->MaritalStatusID->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_MaritalStatusID"));
		$this->MaritalStatusID->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_MaritalStatusID"));

		// CivilStatus#
		if (!$this->isAddOrEdit())
			$this->CivilStatus23->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_CivilStatus23"));
		$this->CivilStatus23->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_CivilStatus23"));

		// CivilStatusPlace
		if (!$this->isAddOrEdit())
			$this->CivilStatusPlace->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_CivilStatusPlace"));
		$this->CivilStatusPlace->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_CivilStatusPlace"));

		// IdCard#
		if (!$this->isAddOrEdit())
			$this->IdCard23->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_IdCard23"));
		$this->IdCard23->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_IdCard23"));

		// NationalId#
		if (!$this->isAddOrEdit())
			$this->NationalId23->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_NationalId23"));
		$this->NationalId23->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_NationalId23"));

		// Nationality1
		if (!$this->isAddOrEdit())
			$this->Nationality1->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_Nationality1"));
		$this->Nationality1->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_Nationality1"));

		// Nationality2
		if (!$this->isAddOrEdit())
			$this->Nationality2->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_Nationality2"));
		$this->Nationality2->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_Nationality2"));

		// Nationality3
		if (!$this->isAddOrEdit())
			$this->Nationality3->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_Nationality3"));
		$this->Nationality3->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_Nationality3"));

		// DriverLicense#
		if (!$this->isAddOrEdit())
			$this->DriverLicense23->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_DriverLicense23"));
		$this->DriverLicense23->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_DriverLicense23"));

		// SocialSecurity#
		if (!$this->isAddOrEdit())
			$this->SocialSecurity23->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_SocialSecurity23"));
		$this->SocialSecurity23->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_SocialSecurity23"));

		// Financial#
		if (!$this->isAddOrEdit())
			$this->Financial23->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_Financial23"));
		$this->Financial23->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_Financial23"));

		// Extra#
		if (!$this->isAddOrEdit())
			$this->Extra23->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_Extra23"));
		$this->Extra23->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_Extra23"));

		// Field1
		if (!$this->isAddOrEdit())
			$this->Field1->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_Field1"));
		$this->Field1->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_Field1"));

		// Field2
		if (!$this->isAddOrEdit())
			$this->Field2->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_Field2"));
		$this->Field2->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_Field2"));

		// Field3
		if (!$this->isAddOrEdit())
			$this->Field3->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_Field3"));
		$this->Field3->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_Field3"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// ClientInfoID
		// ClientID
		// Notes
		// MaritalStatusID
		// CivilStatus#
		// CivilStatusPlace
		// IdCard#
		// NationalId#
		// Nationality1
		// Nationality2
		// Nationality3
		// DriverLicense#
		// SocialSecurity#
		// Financial#
		// Extra#
		// Field1
		// Field2
		// Field3
		// UserID
		// CreatedBy
		// CreatedDate
		// UpdatedBy
		// UpdatedDate

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// ClientInfoID
			$this->ClientInfoID->ViewValue = $this->ClientInfoID->CurrentValue;
			$this->ClientInfoID->ViewCustomAttributes = "";

			// ClientID
			$curVal = strval($this->ClientID->CurrentValue);
			if ($curVal <> "") {
				$this->ClientID->ViewValue = $this->ClientID->lookupCacheOption($curVal);
				if ($this->ClientID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`ClientID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ClientID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->ClientID->ViewValue = $this->ClientID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ClientID->ViewValue = $this->ClientID->CurrentValue;
					}
				}
			} else {
				$this->ClientID->ViewValue = NULL;
			}
			$this->ClientID->ViewCustomAttributes = "";

			// Notes
			$this->Notes->ViewValue = $this->Notes->CurrentValue;
			$this->Notes->ViewCustomAttributes = "";

			// MaritalStatusID
			$curVal = strval($this->MaritalStatusID->CurrentValue);
			if ($curVal <> "") {
				$this->MaritalStatusID->ViewValue = $this->MaritalStatusID->lookupCacheOption($curVal);
				if ($this->MaritalStatusID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`MaritalStatusID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->MaritalStatusID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->MaritalStatusID->ViewValue = $this->MaritalStatusID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->MaritalStatusID->ViewValue = $this->MaritalStatusID->CurrentValue;
					}
				}
			} else {
				$this->MaritalStatusID->ViewValue = NULL;
			}
			$this->MaritalStatusID->ViewCustomAttributes = "";

			// CivilStatus#
			$this->CivilStatus23->ViewValue = $this->CivilStatus23->CurrentValue;
			$this->CivilStatus23->ViewCustomAttributes = "";

			// CivilStatusPlace
			$this->CivilStatusPlace->ViewValue = $this->CivilStatusPlace->CurrentValue;
			$this->CivilStatusPlace->ViewCustomAttributes = "";

			// IdCard#
			$this->IdCard23->ViewValue = $this->IdCard23->CurrentValue;
			$this->IdCard23->ViewCustomAttributes = "";

			// NationalId#
			$this->NationalId23->ViewValue = $this->NationalId23->CurrentValue;
			$this->NationalId23->ViewCustomAttributes = "";

			// Nationality1
			$this->Nationality1->ViewValue = $this->Nationality1->CurrentValue;
			$this->Nationality1->ViewCustomAttributes = "";

			// Nationality2
			$this->Nationality2->ViewValue = $this->Nationality2->CurrentValue;
			$this->Nationality2->ViewCustomAttributes = "";

			// Nationality3
			$this->Nationality3->ViewValue = $this->Nationality3->CurrentValue;
			$this->Nationality3->ViewCustomAttributes = "";

			// DriverLicense#
			$this->DriverLicense23->ViewValue = $this->DriverLicense23->CurrentValue;
			$this->DriverLicense23->ViewCustomAttributes = "";

			// SocialSecurity#
			$this->SocialSecurity23->ViewValue = $this->SocialSecurity23->CurrentValue;
			$this->SocialSecurity23->ViewCustomAttributes = "";

			// Financial#
			$this->Financial23->ViewValue = $this->Financial23->CurrentValue;
			$this->Financial23->ViewCustomAttributes = "";

			// Extra#
			$this->Extra23->ViewValue = $this->Extra23->CurrentValue;
			$this->Extra23->ViewCustomAttributes = "";

			// Field1
			$this->Field1->ViewValue = $this->Field1->CurrentValue;
			$this->Field1->ViewCustomAttributes = "";

			// Field2
			$this->Field2->ViewValue = $this->Field2->CurrentValue;
			$this->Field2->ViewCustomAttributes = "";

			// Field3
			$this->Field3->ViewValue = $this->Field3->CurrentValue;
			$this->Field3->ViewCustomAttributes = "";

			// ClientInfoID
			$this->ClientInfoID->LinkCustomAttributes = "";
			$this->ClientInfoID->HrefValue = "";
			$this->ClientInfoID->TooltipValue = "";

			// ClientID
			$this->ClientID->LinkCustomAttributes = "";
			$this->ClientID->HrefValue = "";
			$this->ClientID->TooltipValue = "";

			// Notes
			$this->Notes->LinkCustomAttributes = "";
			$this->Notes->HrefValue = "";
			$this->Notes->TooltipValue = "";

			// MaritalStatusID
			$this->MaritalStatusID->LinkCustomAttributes = "";
			$this->MaritalStatusID->HrefValue = "";
			$this->MaritalStatusID->TooltipValue = "";

			// CivilStatus#
			$this->CivilStatus23->LinkCustomAttributes = "";
			$this->CivilStatus23->HrefValue = "";
			$this->CivilStatus23->TooltipValue = "";

			// CivilStatusPlace
			$this->CivilStatusPlace->LinkCustomAttributes = "";
			$this->CivilStatusPlace->HrefValue = "";
			$this->CivilStatusPlace->TooltipValue = "";

			// IdCard#
			$this->IdCard23->LinkCustomAttributes = "";
			$this->IdCard23->HrefValue = "";
			$this->IdCard23->TooltipValue = "";

			// NationalId#
			$this->NationalId23->LinkCustomAttributes = "";
			$this->NationalId23->HrefValue = "";
			$this->NationalId23->TooltipValue = "";

			// Nationality1
			$this->Nationality1->LinkCustomAttributes = "";
			$this->Nationality1->HrefValue = "";
			$this->Nationality1->TooltipValue = "";

			// Nationality2
			$this->Nationality2->LinkCustomAttributes = "";
			$this->Nationality2->HrefValue = "";
			$this->Nationality2->TooltipValue = "";

			// Nationality3
			$this->Nationality3->LinkCustomAttributes = "";
			$this->Nationality3->HrefValue = "";
			$this->Nationality3->TooltipValue = "";

			// DriverLicense#
			$this->DriverLicense23->LinkCustomAttributes = "";
			$this->DriverLicense23->HrefValue = "";
			$this->DriverLicense23->TooltipValue = "";

			// SocialSecurity#
			$this->SocialSecurity23->LinkCustomAttributes = "";
			$this->SocialSecurity23->HrefValue = "";
			$this->SocialSecurity23->TooltipValue = "";

			// Financial#
			$this->Financial23->LinkCustomAttributes = "";
			$this->Financial23->HrefValue = "";
			$this->Financial23->TooltipValue = "";

			// Extra#
			$this->Extra23->LinkCustomAttributes = "";
			$this->Extra23->HrefValue = "";
			$this->Extra23->TooltipValue = "";

			// Field1
			$this->Field1->LinkCustomAttributes = "";
			$this->Field1->HrefValue = "";
			$this->Field1->TooltipValue = "";

			// Field2
			$this->Field2->LinkCustomAttributes = "";
			$this->Field2->HrefValue = "";
			$this->Field2->TooltipValue = "";

			// Field3
			$this->Field3->LinkCustomAttributes = "";
			$this->Field3->HrefValue = "";
			$this->Field3->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// ClientInfoID
			$this->ClientInfoID->EditAttrs["class"] = "form-control";
			$this->ClientInfoID->EditCustomAttributes = "";
			$this->ClientInfoID->EditValue = HtmlEncode($this->ClientInfoID->AdvancedSearch->SearchValue);
			$this->ClientInfoID->PlaceHolder = RemoveHtml($this->ClientInfoID->caption());

			// ClientID
			$this->ClientID->EditAttrs["class"] = "form-control";
			$this->ClientID->EditCustomAttributes = "";
			$curVal = trim(strval($this->ClientID->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->ClientID->AdvancedSearch->ViewValue = $this->ClientID->lookupCacheOption($curVal);
			else
				$this->ClientID->AdvancedSearch->ViewValue = $this->ClientID->Lookup !== NULL && is_array($this->ClientID->Lookup->Options) ? $curVal : NULL;
			if ($this->ClientID->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->ClientID->EditValue = array_values($this->ClientID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`ClientID`" . SearchString("=", $this->ClientID->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->ClientID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->ClientID->EditValue = $arwrk;
			}

			// Notes
			$this->Notes->EditAttrs["class"] = "form-control";
			$this->Notes->EditCustomAttributes = "";
			$this->Notes->EditValue = HtmlEncode($this->Notes->AdvancedSearch->SearchValue);
			$this->Notes->PlaceHolder = RemoveHtml($this->Notes->caption());

			// MaritalStatusID
			$this->MaritalStatusID->EditAttrs["class"] = "form-control";
			$this->MaritalStatusID->EditCustomAttributes = "";
			$curVal = trim(strval($this->MaritalStatusID->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->MaritalStatusID->AdvancedSearch->ViewValue = $this->MaritalStatusID->lookupCacheOption($curVal);
			else
				$this->MaritalStatusID->AdvancedSearch->ViewValue = $this->MaritalStatusID->Lookup !== NULL && is_array($this->MaritalStatusID->Lookup->Options) ? $curVal : NULL;
			if ($this->MaritalStatusID->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->MaritalStatusID->EditValue = array_values($this->MaritalStatusID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`MaritalStatusID`" . SearchString("=", $this->MaritalStatusID->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->MaritalStatusID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->MaritalStatusID->EditValue = $arwrk;
			}

			// CivilStatus#
			$this->CivilStatus23->EditAttrs["class"] = "form-control";
			$this->CivilStatus23->EditCustomAttributes = "";
			$this->CivilStatus23->EditValue = HtmlEncode($this->CivilStatus23->AdvancedSearch->SearchValue);
			$this->CivilStatus23->PlaceHolder = RemoveHtml($this->CivilStatus23->caption());

			// CivilStatusPlace
			$this->CivilStatusPlace->EditAttrs["class"] = "form-control";
			$this->CivilStatusPlace->EditCustomAttributes = "";
			$this->CivilStatusPlace->EditValue = HtmlEncode($this->CivilStatusPlace->AdvancedSearch->SearchValue);
			$this->CivilStatusPlace->PlaceHolder = RemoveHtml($this->CivilStatusPlace->caption());

			// IdCard#
			$this->IdCard23->EditAttrs["class"] = "form-control";
			$this->IdCard23->EditCustomAttributes = "";
			$this->IdCard23->EditValue = HtmlEncode($this->IdCard23->AdvancedSearch->SearchValue);
			$this->IdCard23->PlaceHolder = RemoveHtml($this->IdCard23->caption());

			// NationalId#
			$this->NationalId23->EditAttrs["class"] = "form-control";
			$this->NationalId23->EditCustomAttributes = "";
			$this->NationalId23->EditValue = HtmlEncode($this->NationalId23->AdvancedSearch->SearchValue);
			$this->NationalId23->PlaceHolder = RemoveHtml($this->NationalId23->caption());

			// Nationality1
			$this->Nationality1->EditAttrs["class"] = "form-control";
			$this->Nationality1->EditCustomAttributes = "";
			$this->Nationality1->EditValue = HtmlEncode($this->Nationality1->AdvancedSearch->SearchValue);
			$this->Nationality1->PlaceHolder = RemoveHtml($this->Nationality1->caption());

			// Nationality2
			$this->Nationality2->EditAttrs["class"] = "form-control";
			$this->Nationality2->EditCustomAttributes = "";
			$this->Nationality2->EditValue = HtmlEncode($this->Nationality2->AdvancedSearch->SearchValue);
			$this->Nationality2->PlaceHolder = RemoveHtml($this->Nationality2->caption());

			// Nationality3
			$this->Nationality3->EditAttrs["class"] = "form-control";
			$this->Nationality3->EditCustomAttributes = "";
			$this->Nationality3->EditValue = HtmlEncode($this->Nationality3->AdvancedSearch->SearchValue);
			$this->Nationality3->PlaceHolder = RemoveHtml($this->Nationality3->caption());

			// DriverLicense#
			$this->DriverLicense23->EditAttrs["class"] = "form-control";
			$this->DriverLicense23->EditCustomAttributes = "";
			$this->DriverLicense23->EditValue = HtmlEncode($this->DriverLicense23->AdvancedSearch->SearchValue);
			$this->DriverLicense23->PlaceHolder = RemoveHtml($this->DriverLicense23->caption());

			// SocialSecurity#
			$this->SocialSecurity23->EditAttrs["class"] = "form-control";
			$this->SocialSecurity23->EditCustomAttributes = "";
			$this->SocialSecurity23->EditValue = HtmlEncode($this->SocialSecurity23->AdvancedSearch->SearchValue);
			$this->SocialSecurity23->PlaceHolder = RemoveHtml($this->SocialSecurity23->caption());

			// Financial#
			$this->Financial23->EditAttrs["class"] = "form-control";
			$this->Financial23->EditCustomAttributes = "";
			$this->Financial23->EditValue = HtmlEncode($this->Financial23->AdvancedSearch->SearchValue);
			$this->Financial23->PlaceHolder = RemoveHtml($this->Financial23->caption());

			// Extra#
			$this->Extra23->EditAttrs["class"] = "form-control";
			$this->Extra23->EditCustomAttributes = "";
			$this->Extra23->EditValue = HtmlEncode($this->Extra23->AdvancedSearch->SearchValue);
			$this->Extra23->PlaceHolder = RemoveHtml($this->Extra23->caption());

			// Field1
			$this->Field1->EditAttrs["class"] = "form-control";
			$this->Field1->EditCustomAttributes = "";
			$this->Field1->EditValue = HtmlEncode($this->Field1->AdvancedSearch->SearchValue);
			$this->Field1->PlaceHolder = RemoveHtml($this->Field1->caption());

			// Field2
			$this->Field2->EditAttrs["class"] = "form-control";
			$this->Field2->EditCustomAttributes = "";
			$this->Field2->EditValue = HtmlEncode($this->Field2->AdvancedSearch->SearchValue);
			$this->Field2->PlaceHolder = RemoveHtml($this->Field2->caption());

			// Field3
			$this->Field3->EditAttrs["class"] = "form-control";
			$this->Field3->EditCustomAttributes = "";
			$this->Field3->EditValue = HtmlEncode($this->Field3->AdvancedSearch->SearchValue);
			$this->Field3->PlaceHolder = RemoveHtml($this->Field3->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->ClientInfoID->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->ClientInfoID->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->ClientInfoID->AdvancedSearch->load();
		$this->ClientID->AdvancedSearch->load();
		$this->Notes->AdvancedSearch->load();
		$this->MaritalStatusID->AdvancedSearch->load();
		$this->CivilStatus23->AdvancedSearch->load();
		$this->CivilStatusPlace->AdvancedSearch->load();
		$this->IdCard23->AdvancedSearch->load();
		$this->NationalId23->AdvancedSearch->load();
		$this->Nationality1->AdvancedSearch->load();
		$this->Nationality2->AdvancedSearch->load();
		$this->Nationality3->AdvancedSearch->load();
		$this->DriverLicense23->AdvancedSearch->load();
		$this->SocialSecurity23->AdvancedSearch->load();
		$this->Financial23->AdvancedSearch->load();
		$this->Extra23->AdvancedSearch->load();
		$this->Field1->AdvancedSearch->load();
		$this->Field2->AdvancedSearch->load();
		$this->Field3->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("clientadditinalinfolist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_ClientID":
							break;
						case "x_MaritalStatusID":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
