<?php
namespace PHPMaker2019\project_germanos;

/**
 * Table class for courts
 */
class courts extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Audit trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Export
	public $ExportDoc;

	// Fields
	public $CourtID;
	public $Court;
	public $CourtEn;
	public $CourtTypeID;
	public $ChamberID;
	public $CourtLocationID;
	public $GovernorateID;
	public $SectionID;
	public $AddressID;
	public $ContactID;
	public $Activated;
	public $Notes;
	public $_UserID;
	public $CreatedBy;
	public $CreatedDate;
	public $UpdatedBy;
	public $UpdatedDate;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'courts';
		$this->TableName = 'courts';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`courts`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "landscape"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = TRUE; // Allow detail view
		$this->ShowMultipleDetails = TRUE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "AND";

		// CourtID
		$this->CourtID = new DbField('courts', 'courts', 'x_CourtID', 'CourtID', '`CourtID`', '`CourtID`', 3, -1, FALSE, '`CourtID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'HIDDEN');
		$this->CourtID->IsAutoIncrement = TRUE; // Autoincrement field
		$this->CourtID->IsPrimaryKey = TRUE; // Primary key field
		$this->CourtID->IsForeignKey = TRUE; // Foreign key field
		$this->CourtID->Sortable = TRUE; // Allow sort
		$this->CourtID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['CourtID'] = &$this->CourtID;

		// Court
		$this->Court = new DbField('courts', 'courts', 'x_Court', 'Court', '`Court`', '`Court`', 200, -1, FALSE, '`Court`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Court->Nullable = FALSE; // NOT NULL field
		$this->Court->Required = TRUE; // Required field
		$this->Court->Sortable = TRUE; // Allow sort
		$this->fields['Court'] = &$this->Court;

		// CourtEn
		$this->CourtEn = new DbField('courts', 'courts', 'x_CourtEn', 'CourtEn', '`CourtEn`', '`CourtEn`', 200, -1, FALSE, '`CourtEn`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CourtEn->Sortable = FALSE; // Allow sort
		$this->fields['CourtEn'] = &$this->CourtEn;

		// CourtTypeID
		$this->CourtTypeID = new DbField('courts', 'courts', 'x_CourtTypeID', 'CourtTypeID', '`CourtTypeID`', '`CourtTypeID`', 3, -1, FALSE, '`EV__CourtTypeID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->CourtTypeID->Nullable = FALSE; // NOT NULL field
		$this->CourtTypeID->Required = TRUE; // Required field
		$this->CourtTypeID->Sortable = TRUE; // Allow sort
		$this->CourtTypeID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->CourtTypeID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->CourtTypeID->Lookup = new Lookup('CourtTypeID', 'courttype', TRUE, 'CourtTypeID', ["CourtType",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->CourtTypeID->Lookup = new Lookup('CourtTypeID', 'courttype', TRUE, 'CourtTypeID', ["CourtTypeEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->CourtTypeID->Lookup = new Lookup('CourtTypeID', 'courttype', TRUE, 'CourtTypeID', ["CourtTypeEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->CourtTypeID->Lookup = new Lookup('CourtTypeID', 'courttype', TRUE, 'CourtTypeID', ["CourtType","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->CourtTypeID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['CourtTypeID'] = &$this->CourtTypeID;

		// ChamberID
		$this->ChamberID = new DbField('courts', 'courts', 'x_ChamberID', 'ChamberID', '`ChamberID`', '`ChamberID`', 3, -1, FALSE, '`EV__ChamberID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->ChamberID->Sortable = TRUE; // Allow sort
		$this->ChamberID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->ChamberID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->ChamberID->Lookup = new Lookup('ChamberID', 'chambers', TRUE, 'ChamberID', ["Chamber",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->ChamberID->Lookup = new Lookup('ChamberID', 'chambers', TRUE, 'ChamberID', ["ChamberEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->ChamberID->Lookup = new Lookup('ChamberID', 'chambers', TRUE, 'ChamberID', ["ChamberEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->ChamberID->Lookup = new Lookup('ChamberID', 'chambers', TRUE, 'ChamberID', ["Chamber","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->ChamberID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['ChamberID'] = &$this->ChamberID;

		// CourtLocationID
		$this->CourtLocationID = new DbField('courts', 'courts', 'x_CourtLocationID', 'CourtLocationID', '`CourtLocationID`', '`CourtLocationID`', 3, -1, FALSE, '`EV__CourtLocationID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->CourtLocationID->Sortable = TRUE; // Allow sort
		$this->CourtLocationID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->CourtLocationID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->CourtLocationID->Lookup = new Lookup('CourtLocationID', 'courtlocation', TRUE, 'CourtLocationID', ["CourtLocation",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->CourtLocationID->Lookup = new Lookup('CourtLocationID', 'courtlocation', TRUE, 'CourtLocationID', ["CourtLocationEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->CourtLocationID->Lookup = new Lookup('CourtLocationID', 'courtlocation', TRUE, 'CourtLocationID', ["CourtLocationEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->CourtLocationID->Lookup = new Lookup('CourtLocationID', 'courtlocation', TRUE, 'CourtLocationID', ["CourtLocation","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->CourtLocationID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['CourtLocationID'] = &$this->CourtLocationID;

		// GovernorateID
		$this->GovernorateID = new DbField('courts', 'courts', 'x_GovernorateID', 'GovernorateID', '`GovernorateID`', '`GovernorateID`', 3, -1, FALSE, '`GovernorateID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->GovernorateID->Sortable = TRUE; // Allow sort
		$this->GovernorateID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->GovernorateID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->GovernorateID->Lookup = new Lookup('GovernorateID', 'governorates', FALSE, 'GovernorateID', ["Governorate",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->GovernorateID->Lookup = new Lookup('GovernorateID', 'governorates', FALSE, 'GovernorateID', ["GovernorateEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->GovernorateID->Lookup = new Lookup('GovernorateID', 'governorates', FALSE, 'GovernorateID', ["GovernorateEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->GovernorateID->Lookup = new Lookup('GovernorateID', 'governorates', FALSE, 'GovernorateID', ["Governorate","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->GovernorateID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['GovernorateID'] = &$this->GovernorateID;

		// SectionID
		$this->SectionID = new DbField('courts', 'courts', 'x_SectionID', 'SectionID', '`SectionID`', '`SectionID`', 3, -1, FALSE, '`EV__SectionID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->SectionID->Sortable = TRUE; // Allow sort
		$this->SectionID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->SectionID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->SectionID->Lookup = new Lookup('SectionID', 'sections', TRUE, 'SectionID', ["Section",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->SectionID->Lookup = new Lookup('SectionID', 'sections', TRUE, 'SectionID', ["SectionEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->SectionID->Lookup = new Lookup('SectionID', 'sections', TRUE, 'SectionID', ["SectionEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->SectionID->Lookup = new Lookup('SectionID', 'sections', TRUE, 'SectionID', ["Section","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->SectionID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['SectionID'] = &$this->SectionID;

		// AddressID
		$this->AddressID = new DbField('courts', 'courts', 'x_AddressID', 'AddressID', '`AddressID`', '`AddressID`', 3, -1, FALSE, '`AddressID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->AddressID->Sortable = FALSE; // Allow sort
		$this->AddressID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->AddressID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->AddressID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['AddressID'] = &$this->AddressID;

		// ContactID
		$this->ContactID = new DbField('courts', 'courts', 'x_ContactID', 'ContactID', '`ContactID`', '`ContactID`', 3, -1, FALSE, '`ContactID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->ContactID->Sortable = FALSE; // Allow sort
		$this->ContactID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->ContactID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->ContactID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['ContactID'] = &$this->ContactID;

		// Activated
		$this->Activated = new DbField('courts', 'courts', 'x_Activated', 'Activated', '`Activated`', '`Activated`', 202, -1, FALSE, '`Activated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->Activated->Nullable = FALSE; // NOT NULL field
		$this->Activated->Sortable = FALSE; // Allow sort
		$this->Activated->DataType = DATATYPE_BOOLEAN;
		$this->Activated->TrueValue = 'Y';
		$this->Activated->FalseValue = 'N';
		switch ($CurrentLanguage) {
			case "ar":
				$this->Activated->Lookup = new Lookup('Activated', 'courts', FALSE, '', [null,null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->Activated->Lookup = new Lookup('Activated', 'courts', FALSE, '', [null,null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->Activated->Lookup = new Lookup('Activated', 'courts', FALSE, '', [null,null,null,""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->Activated->Lookup = new Lookup('Activated', 'courts', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->Activated->OptionCount = 2;
		$this->fields['Activated'] = &$this->Activated;

		// Notes
		$this->Notes = new DbField('courts', 'courts', 'x_Notes', 'Notes', '`Notes`', '`Notes`', 201, -1, FALSE, '`Notes`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->Notes->Sortable = FALSE; // Allow sort
		$this->fields['Notes'] = &$this->Notes;

		// UserID
		$this->_UserID = new DbField('courts', 'courts', 'x__UserID', 'UserID', '`UserID`', '`UserID`', 3, -1, FALSE, '`UserID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_UserID->Sortable = FALSE; // Allow sort
		$this->_UserID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['UserID'] = &$this->_UserID;

		// CreatedBy
		$this->CreatedBy = new DbField('courts', 'courts', 'x_CreatedBy', 'CreatedBy', '`CreatedBy`', '`CreatedBy`', 200, -1, FALSE, '`CreatedBy`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CreatedBy->Sortable = FALSE; // Allow sort
		$this->fields['CreatedBy'] = &$this->CreatedBy;

		// CreatedDate
		$this->CreatedDate = new DbField('courts', 'courts', 'x_CreatedDate', 'CreatedDate', '`CreatedDate`', CastDateFieldForLike('`CreatedDate`', 0, "DB"), 135, 0, FALSE, '`CreatedDate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CreatedDate->Sortable = FALSE; // Allow sort
		$this->CreatedDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['CreatedDate'] = &$this->CreatedDate;

		// UpdatedBy
		$this->UpdatedBy = new DbField('courts', 'courts', 'x_UpdatedBy', 'UpdatedBy', '`UpdatedBy`', '`UpdatedBy`', 200, -1, FALSE, '`UpdatedBy`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->UpdatedBy->Sortable = FALSE; // Allow sort
		$this->fields['UpdatedBy'] = &$this->UpdatedBy;

		// UpdatedDate
		$this->UpdatedDate = new DbField('courts', 'courts', 'x_UpdatedDate', 'UpdatedDate', '`UpdatedDate`', CastDateFieldForLike('`UpdatedDate`', 0, "DB"), 135, 0, FALSE, '`UpdatedDate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->UpdatedDate->Sortable = FALSE; // Allow sort
		$this->UpdatedDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['UpdatedDate'] = &$this->UpdatedDate;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Current detail table name
	public function getCurrentDetailTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_DETAIL_TABLE];
	}
	public function setCurrentDetailTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_DETAIL_TABLE] = $v;
	}

	// Get detail url
	public function getDetailUrl()
	{

		// Detail url
		$detailUrl = "";
		if ($this->getCurrentDetailTable() == "courtaddress") {
			$detailUrl = $GLOBALS["courtaddress"]->getListUrl() . "?" . TABLE_SHOW_MASTER . "=" . $this->TableVar;
			$detailUrl .= "&fk_CourtID=" . urlencode($this->CourtID->CurrentValue);
		}
		if ($this->getCurrentDetailTable() == "courtcontact") {
			$detailUrl = $GLOBALS["courtcontact"]->getListUrl() . "?" . TABLE_SHOW_MASTER . "=" . $this->TableVar;
			$detailUrl .= "&fk_CourtID=" . urlencode($this->CourtID->CurrentValue);
		}
		if ($detailUrl == "")
			$detailUrl = "courtslist.php";
		return $detailUrl;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`courts`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		global $CurrentLanguage;
		switch ($CurrentLanguage) {
			case "ar":
				$select = "SELECT * FROM (" .
					"SELECT *, (SELECT DISTINCT `CourtType` FROM `courttype` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CourtTypeID` = `courts`.`CourtTypeID` LIMIT 1) AS `EV__CourtTypeID`, (SELECT DISTINCT `Chamber` FROM `chambers` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`ChamberID` = `courts`.`ChamberID` LIMIT 1) AS `EV__ChamberID`, (SELECT DISTINCT `CourtLocation` FROM `courtlocation` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CourtLocationID` = `courts`.`CourtLocationID` LIMIT 1) AS `EV__CourtLocationID`, (SELECT DISTINCT `Section` FROM `sections` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`SectionID` = `courts`.`SectionID` LIMIT 1) AS `EV__SectionID` FROM `courts`" .
					") `TMP_TABLE`";
				break;
			case "en":
				$select = "SELECT * FROM (" .
					"SELECT *, (SELECT DISTINCT `CourtTypeEn` FROM `courttype` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CourtTypeID` = `courts`.`CourtTypeID` LIMIT 1) AS `EV__CourtTypeID`, (SELECT DISTINCT `ChamberEn` FROM `chambers` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`ChamberID` = `courts`.`ChamberID` LIMIT 1) AS `EV__ChamberID`, (SELECT DISTINCT `CourtLocationEn` FROM `courtlocation` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CourtLocationID` = `courts`.`CourtLocationID` LIMIT 1) AS `EV__CourtLocationID`, (SELECT DISTINCT `SectionEn` FROM `sections` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`SectionID` = `courts`.`SectionID` LIMIT 1) AS `EV__SectionID` FROM `courts`" .
					") `TMP_TABLE`";
				break;
			case "fr":
				$select = "SELECT * FROM (" .
					"SELECT *, (SELECT DISTINCT `CourtTypeEn` FROM `courttype` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CourtTypeID` = `courts`.`CourtTypeID` LIMIT 1) AS `EV__CourtTypeID`, (SELECT DISTINCT `ChamberEn` FROM `chambers` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`ChamberID` = `courts`.`ChamberID` LIMIT 1) AS `EV__ChamberID`, (SELECT DISTINCT `CourtLocationEn` FROM `courtlocation` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CourtLocationID` = `courts`.`CourtLocationID` LIMIT 1) AS `EV__CourtLocationID`, (SELECT DISTINCT `SectionEn` FROM `sections` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`SectionID` = `courts`.`SectionID` LIMIT 1) AS `EV__SectionID` FROM `courts`" .
					") `TMP_TABLE`";
				break;
			default:
				$select = "SELECT * FROM (" .
					"SELECT *, (SELECT DISTINCT `CourtType` FROM `courttype` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CourtTypeID` = `courts`.`CourtTypeID` LIMIT 1) AS `EV__CourtTypeID`, (SELECT DISTINCT `Chamber` FROM `chambers` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`ChamberID` = `courts`.`ChamberID` LIMIT 1) AS `EV__ChamberID`, (SELECT DISTINCT `CourtLocation` FROM `courtlocation` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CourtLocationID` = `courts`.`CourtLocationID` LIMIT 1) AS `EV__CourtLocationID`, (SELECT DISTINCT `Section` FROM `sections` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`SectionID` = `courts`.`SectionID` LIMIT 1) AS `EV__SectionID` FROM `courts`" .
					") `TMP_TABLE`";
				break;
		}
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->CourtTypeID->AdvancedSearch->SearchValue <> "" ||
			$this->CourtTypeID->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->CourtTypeID->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->CourtTypeID->VirtualExpression . " "))
			return TRUE;
		if ($this->ChamberID->AdvancedSearch->SearchValue <> "" ||
			$this->ChamberID->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->ChamberID->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->ChamberID->VirtualExpression . " "))
			return TRUE;
		if ($this->CourtLocationID->AdvancedSearch->SearchValue <> "" ||
			$this->CourtLocationID->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->CourtLocationID->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->CourtLocationID->VirtualExpression . " "))
			return TRUE;
		if ($this->SectionID->AdvancedSearch->SearchValue <> "" ||
			$this->SectionID->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->SectionID->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->SectionID->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->CourtID->setDbValue($conn->insert_ID());
			$rs['CourtID'] = $this->CourtID->DbValue;
			if ($this->AuditTrailOnAdd)
				$this->writeAuditTrailOnAdd($rs);
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnEdit && $rsold) {
			$rsaudit = $rs;
			$fldname = 'CourtID';
			if (!array_key_exists($fldname, $rsaudit))
				$rsaudit[$fldname] = $rsold[$fldname];
			$this->writeAuditTrailOnEdit($rsold, $rsaudit);
		}
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('CourtID', $rs))
				AddFilter($where, QuotedName('CourtID', $this->Dbid) . '=' . QuotedValue($rs['CourtID'], $this->CourtID->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnDelete)
			$this->writeAuditTrailOnDelete($rs);
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->CourtID->DbValue = $row['CourtID'];
		$this->Court->DbValue = $row['Court'];
		$this->CourtEn->DbValue = $row['CourtEn'];
		$this->CourtTypeID->DbValue = $row['CourtTypeID'];
		$this->ChamberID->DbValue = $row['ChamberID'];
		$this->CourtLocationID->DbValue = $row['CourtLocationID'];
		$this->GovernorateID->DbValue = $row['GovernorateID'];
		$this->SectionID->DbValue = $row['SectionID'];
		$this->AddressID->DbValue = $row['AddressID'];
		$this->ContactID->DbValue = $row['ContactID'];
		$this->Activated->DbValue = $row['Activated'];
		$this->Notes->DbValue = $row['Notes'];
		$this->_UserID->DbValue = $row['UserID'];
		$this->CreatedBy->DbValue = $row['CreatedBy'];
		$this->CreatedDate->DbValue = $row['CreatedDate'];
		$this->UpdatedBy->DbValue = $row['UpdatedBy'];
		$this->UpdatedDate->DbValue = $row['UpdatedDate'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`CourtID` = @CourtID@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('CourtID', $row) ? $row['CourtID'] : NULL) : $this->CourtID->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@CourtID@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "courtslist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "courtsview.php")
			return $Language->phrase("View");
		elseif ($pageName == "courtsedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "courtsadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "courtslist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("courtsview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("courtsview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "courtsadd.php?" . $this->getUrlParm($parm);
		else
			$url = "courtsadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("courtsedit.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("courtsedit.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("courtsadd.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("courtsadd.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("courtsdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "CourtID:" . JsonEncode($this->CourtID->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->CourtID->CurrentValue != NULL) {
			$url .= "CourtID=" . urlencode($this->CourtID->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("CourtID") !== NULL)
				$arKeys[] = Param("CourtID");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->CourtID->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->CourtID->setDbValue($rs->fields('CourtID'));
		$this->Court->setDbValue($rs->fields('Court'));
		$this->CourtEn->setDbValue($rs->fields('CourtEn'));
		$this->CourtTypeID->setDbValue($rs->fields('CourtTypeID'));
		$this->ChamberID->setDbValue($rs->fields('ChamberID'));
		$this->CourtLocationID->setDbValue($rs->fields('CourtLocationID'));
		$this->GovernorateID->setDbValue($rs->fields('GovernorateID'));
		$this->SectionID->setDbValue($rs->fields('SectionID'));
		$this->AddressID->setDbValue($rs->fields('AddressID'));
		$this->ContactID->setDbValue($rs->fields('ContactID'));
		$this->Activated->setDbValue($rs->fields('Activated'));
		$this->Notes->setDbValue($rs->fields('Notes'));
		$this->_UserID->setDbValue($rs->fields('UserID'));
		$this->CreatedBy->setDbValue($rs->fields('CreatedBy'));
		$this->CreatedDate->setDbValue($rs->fields('CreatedDate'));
		$this->UpdatedBy->setDbValue($rs->fields('UpdatedBy'));
		$this->UpdatedDate->setDbValue($rs->fields('UpdatedDate'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// CourtID
		// Court
		// CourtEn

		$this->CourtEn->CellCssStyle = "white-space: nowrap;";

		// CourtTypeID
		// ChamberID
		// CourtLocationID
		// GovernorateID
		// SectionID
		// AddressID

		$this->AddressID->CellCssStyle = "white-space: nowrap;";

		// ContactID
		$this->ContactID->CellCssStyle = "white-space: nowrap;";

		// Activated
		$this->Activated->CellCssStyle = "white-space: nowrap;";

		// Notes
		// UserID

		$this->_UserID->CellCssStyle = "white-space: nowrap;";

		// CreatedBy
		$this->CreatedBy->CellCssStyle = "white-space: nowrap;";

		// CreatedDate
		$this->CreatedDate->CellCssStyle = "white-space: nowrap;";

		// UpdatedBy
		$this->UpdatedBy->CellCssStyle = "white-space: nowrap;";

		// UpdatedDate
		$this->UpdatedDate->CellCssStyle = "white-space: nowrap;";

		// CourtID
		$this->CourtID->ViewValue = $this->CourtID->CurrentValue;
		$this->CourtID->ViewCustomAttributes = "";

		// Court
		$this->Court->ViewValue = $this->Court->CurrentValue;
		$this->Court->ViewCustomAttributes = "";

		// CourtEn
		$this->CourtEn->ViewValue = $this->CourtEn->CurrentValue;
		$this->CourtEn->ViewCustomAttributes = "";

		// CourtTypeID
		if ($this->CourtTypeID->VirtualValue <> "") {
			$this->CourtTypeID->ViewValue = $this->CourtTypeID->VirtualValue;
		} else {
		$curVal = strval($this->CourtTypeID->CurrentValue);
		if ($curVal <> "") {
			$this->CourtTypeID->ViewValue = $this->CourtTypeID->lookupCacheOption($curVal);
			if ($this->CourtTypeID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`CourtTypeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->CourtTypeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->CourtTypeID->ViewValue = $this->CourtTypeID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->CourtTypeID->ViewValue = $this->CourtTypeID->CurrentValue;
				}
			}
		} else {
			$this->CourtTypeID->ViewValue = NULL;
		}
		}
		$this->CourtTypeID->ViewCustomAttributes = "";

		// ChamberID
		if ($this->ChamberID->VirtualValue <> "") {
			$this->ChamberID->ViewValue = $this->ChamberID->VirtualValue;
		} else {
		$curVal = strval($this->ChamberID->CurrentValue);
		if ($curVal <> "") {
			$this->ChamberID->ViewValue = $this->ChamberID->lookupCacheOption($curVal);
			if ($this->ChamberID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`ChamberID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->ChamberID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->ChamberID->ViewValue = $this->ChamberID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->ChamberID->ViewValue = $this->ChamberID->CurrentValue;
				}
			}
		} else {
			$this->ChamberID->ViewValue = NULL;
		}
		}
		$this->ChamberID->ViewCustomAttributes = "";

		// CourtLocationID
		if ($this->CourtLocationID->VirtualValue <> "") {
			$this->CourtLocationID->ViewValue = $this->CourtLocationID->VirtualValue;
		} else {
		$curVal = strval($this->CourtLocationID->CurrentValue);
		if ($curVal <> "") {
			$this->CourtLocationID->ViewValue = $this->CourtLocationID->lookupCacheOption($curVal);
			if ($this->CourtLocationID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`CourtLocationID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->CourtLocationID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->CourtLocationID->ViewValue = $this->CourtLocationID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->CourtLocationID->ViewValue = $this->CourtLocationID->CurrentValue;
				}
			}
		} else {
			$this->CourtLocationID->ViewValue = NULL;
		}
		}
		$this->CourtLocationID->ViewCustomAttributes = "";

		// GovernorateID
		$curVal = strval($this->GovernorateID->CurrentValue);
		if ($curVal <> "") {
			$this->GovernorateID->ViewValue = $this->GovernorateID->lookupCacheOption($curVal);
			if ($this->GovernorateID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`GovernorateID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->GovernorateID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->GovernorateID->ViewValue = $this->GovernorateID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->GovernorateID->ViewValue = $this->GovernorateID->CurrentValue;
				}
			}
		} else {
			$this->GovernorateID->ViewValue = NULL;
		}
		$this->GovernorateID->ViewCustomAttributes = "";

		// SectionID
		if ($this->SectionID->VirtualValue <> "") {
			$this->SectionID->ViewValue = $this->SectionID->VirtualValue;
		} else {
		$curVal = strval($this->SectionID->CurrentValue);
		if ($curVal <> "") {
			$this->SectionID->ViewValue = $this->SectionID->lookupCacheOption($curVal);
			if ($this->SectionID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`SectionID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->SectionID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->SectionID->ViewValue = $this->SectionID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->SectionID->ViewValue = $this->SectionID->CurrentValue;
				}
			}
		} else {
			$this->SectionID->ViewValue = NULL;
		}
		}
		$this->SectionID->ViewCustomAttributes = "";

		// AddressID
		$this->AddressID->ViewValue = FormatNumber($this->AddressID->ViewValue, 0, -2, -2, -2);
		$this->AddressID->ViewCustomAttributes = "";

		// ContactID
		$this->ContactID->ViewValue = FormatNumber($this->ContactID->ViewValue, 0, -2, -2, -2);
		$this->ContactID->ViewCustomAttributes = "";

		// Activated
		if (ConvertToBool($this->Activated->CurrentValue)) {
			$this->Activated->ViewValue = $this->Activated->tagCaption(1) <> "" ? $this->Activated->tagCaption(1) : "Y";
		} else {
			$this->Activated->ViewValue = $this->Activated->tagCaption(2) <> "" ? $this->Activated->tagCaption(2) : "N";
		}
		$this->Activated->ViewCustomAttributes = "";

		// Notes
		$this->Notes->ViewValue = $this->Notes->CurrentValue;
		$this->Notes->ViewCustomAttributes = "";

		// UserID
		$this->_UserID->ViewValue = $this->_UserID->CurrentValue;
		$this->_UserID->ViewValue = FormatNumber($this->_UserID->ViewValue, 0, -2, -2, -2);
		$this->_UserID->ViewCustomAttributes = "";

		// CreatedBy
		$this->CreatedBy->ViewValue = $this->CreatedBy->CurrentValue;
		$this->CreatedBy->ViewCustomAttributes = "";

		// CreatedDate
		$this->CreatedDate->ViewValue = $this->CreatedDate->CurrentValue;
		$this->CreatedDate->ViewValue = FormatDateTime($this->CreatedDate->ViewValue, 0);
		$this->CreatedDate->ViewCustomAttributes = "";

		// UpdatedBy
		$this->UpdatedBy->ViewValue = $this->UpdatedBy->CurrentValue;
		$this->UpdatedBy->ViewCustomAttributes = "";

		// UpdatedDate
		$this->UpdatedDate->ViewValue = $this->UpdatedDate->CurrentValue;
		$this->UpdatedDate->ViewValue = FormatDateTime($this->UpdatedDate->ViewValue, 0);
		$this->UpdatedDate->ViewCustomAttributes = "";

		// CourtID
		$this->CourtID->LinkCustomAttributes = "";
		$this->CourtID->HrefValue = "";
		$this->CourtID->TooltipValue = "";

		// Court
		$this->Court->LinkCustomAttributes = "";
		$this->Court->HrefValue = "";
		$this->Court->TooltipValue = "";

		// CourtEn
		$this->CourtEn->LinkCustomAttributes = "";
		$this->CourtEn->HrefValue = "";
		$this->CourtEn->TooltipValue = "";

		// CourtTypeID
		$this->CourtTypeID->LinkCustomAttributes = "";
		$this->CourtTypeID->HrefValue = "";
		$this->CourtTypeID->TooltipValue = "";

		// ChamberID
		$this->ChamberID->LinkCustomAttributes = "";
		$this->ChamberID->HrefValue = "";
		$this->ChamberID->TooltipValue = "";

		// CourtLocationID
		$this->CourtLocationID->LinkCustomAttributes = "";
		$this->CourtLocationID->HrefValue = "";
		$this->CourtLocationID->TooltipValue = "";

		// GovernorateID
		$this->GovernorateID->LinkCustomAttributes = "";
		$this->GovernorateID->HrefValue = "";
		$this->GovernorateID->TooltipValue = "";

		// SectionID
		$this->SectionID->LinkCustomAttributes = "";
		$this->SectionID->HrefValue = "";
		$this->SectionID->TooltipValue = "";

		// AddressID
		$this->AddressID->LinkCustomAttributes = "";
		$this->AddressID->HrefValue = "";
		$this->AddressID->TooltipValue = "";

		// ContactID
		$this->ContactID->LinkCustomAttributes = "";
		$this->ContactID->HrefValue = "";
		$this->ContactID->TooltipValue = "";

		// Activated
		$this->Activated->LinkCustomAttributes = "";
		$this->Activated->HrefValue = "";
		$this->Activated->TooltipValue = "";

		// Notes
		$this->Notes->LinkCustomAttributes = "";
		$this->Notes->HrefValue = "";
		$this->Notes->TooltipValue = "";

		// UserID
		$this->_UserID->LinkCustomAttributes = "";
		$this->_UserID->HrefValue = "";
		$this->_UserID->TooltipValue = "";

		// CreatedBy
		$this->CreatedBy->LinkCustomAttributes = "";
		$this->CreatedBy->HrefValue = "";
		$this->CreatedBy->TooltipValue = "";

		// CreatedDate
		$this->CreatedDate->LinkCustomAttributes = "";
		$this->CreatedDate->HrefValue = "";
		$this->CreatedDate->TooltipValue = "";

		// UpdatedBy
		$this->UpdatedBy->LinkCustomAttributes = "";
		$this->UpdatedBy->HrefValue = "";
		$this->UpdatedBy->TooltipValue = "";

		// UpdatedDate
		$this->UpdatedDate->LinkCustomAttributes = "";
		$this->UpdatedDate->HrefValue = "";
		$this->UpdatedDate->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// CourtID
		$this->CourtID->EditAttrs["class"] = "form-control";
		$this->CourtID->EditCustomAttributes = "";

		// Court
		$this->Court->EditAttrs["class"] = "form-control";
		$this->Court->EditCustomAttributes = "";
		$this->Court->EditValue = $this->Court->CurrentValue;
		$this->Court->PlaceHolder = RemoveHtml($this->Court->caption());

		// CourtEn
		$this->CourtEn->EditAttrs["class"] = "form-control";
		$this->CourtEn->EditCustomAttributes = "";
		$this->CourtEn->EditValue = $this->CourtEn->CurrentValue;
		$this->CourtEn->PlaceHolder = RemoveHtml($this->CourtEn->caption());

		// CourtTypeID
		$this->CourtTypeID->EditAttrs["class"] = "form-control";
		$this->CourtTypeID->EditCustomAttributes = "";

		// ChamberID
		$this->ChamberID->EditAttrs["class"] = "form-control";
		$this->ChamberID->EditCustomAttributes = "";

		// CourtLocationID
		$this->CourtLocationID->EditAttrs["class"] = "form-control";
		$this->CourtLocationID->EditCustomAttributes = "";

		// GovernorateID
		$this->GovernorateID->EditAttrs["class"] = "form-control";
		$this->GovernorateID->EditCustomAttributes = "";

		// SectionID
		$this->SectionID->EditAttrs["class"] = "form-control";
		$this->SectionID->EditCustomAttributes = "";

		// AddressID
		$this->AddressID->EditAttrs["class"] = "form-control";
		$this->AddressID->EditCustomAttributes = "";

		// ContactID
		$this->ContactID->EditAttrs["class"] = "form-control";
		$this->ContactID->EditCustomAttributes = "";

		// Activated
		$this->Activated->EditCustomAttributes = "";
		$this->Activated->EditValue = $this->Activated->options(FALSE);

		// Notes
		$this->Notes->EditAttrs["class"] = "form-control";
		$this->Notes->EditCustomAttributes = "";
		$this->Notes->EditValue = $this->Notes->CurrentValue;
		$this->Notes->PlaceHolder = RemoveHtml($this->Notes->caption());

		// UserID
		$this->_UserID->EditAttrs["class"] = "form-control";
		$this->_UserID->EditCustomAttributes = "";
		$this->_UserID->EditValue = $this->_UserID->CurrentValue;
		$this->_UserID->PlaceHolder = RemoveHtml($this->_UserID->caption());

		// CreatedBy
		$this->CreatedBy->EditAttrs["class"] = "form-control";
		$this->CreatedBy->EditCustomAttributes = "";
		$this->CreatedBy->EditValue = $this->CreatedBy->CurrentValue;
		$this->CreatedBy->PlaceHolder = RemoveHtml($this->CreatedBy->caption());

		// CreatedDate
		$this->CreatedDate->EditAttrs["class"] = "form-control";
		$this->CreatedDate->EditCustomAttributes = "";
		$this->CreatedDate->EditValue = FormatDateTime($this->CreatedDate->CurrentValue, 8);
		$this->CreatedDate->PlaceHolder = RemoveHtml($this->CreatedDate->caption());

		// UpdatedBy
		$this->UpdatedBy->EditAttrs["class"] = "form-control";
		$this->UpdatedBy->EditCustomAttributes = "";
		$this->UpdatedBy->EditValue = $this->UpdatedBy->CurrentValue;
		$this->UpdatedBy->PlaceHolder = RemoveHtml($this->UpdatedBy->caption());

		// UpdatedDate
		$this->UpdatedDate->EditAttrs["class"] = "form-control";
		$this->UpdatedDate->EditCustomAttributes = "";
		$this->UpdatedDate->EditValue = FormatDateTime($this->UpdatedDate->CurrentValue, 8);
		$this->UpdatedDate->PlaceHolder = RemoveHtml($this->UpdatedDate->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->CourtID);
					$doc->exportCaption($this->Court);
					$doc->exportCaption($this->CourtTypeID);
					$doc->exportCaption($this->ChamberID);
					$doc->exportCaption($this->CourtLocationID);
					$doc->exportCaption($this->GovernorateID);
					$doc->exportCaption($this->SectionID);
					$doc->exportCaption($this->Notes);
				} else {
					$doc->exportCaption($this->CourtID);
					$doc->exportCaption($this->Court);
					$doc->exportCaption($this->CourtEn);
					$doc->exportCaption($this->CourtTypeID);
					$doc->exportCaption($this->ChamberID);
					$doc->exportCaption($this->CourtLocationID);
					$doc->exportCaption($this->GovernorateID);
					$doc->exportCaption($this->SectionID);
					$doc->exportCaption($this->Activated);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->CourtID);
						$doc->exportField($this->Court);
						$doc->exportField($this->CourtTypeID);
						$doc->exportField($this->ChamberID);
						$doc->exportField($this->CourtLocationID);
						$doc->exportField($this->GovernorateID);
						$doc->exportField($this->SectionID);
						$doc->exportField($this->Notes);
					} else {
						$doc->exportField($this->CourtID);
						$doc->exportField($this->Court);
						$doc->exportField($this->CourtEn);
						$doc->exportField($this->CourtTypeID);
						$doc->exportField($this->ChamberID);
						$doc->exportField($this->CourtLocationID);
						$doc->exportField($this->GovernorateID);
						$doc->exportField($this->SectionID);
						$doc->exportField($this->Activated);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		if (!$validRequest)
			return FALSE;

		// Load lookup parameters
		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Write Audit Trail start/end for grid update
	public function writeAuditTrailDummy($typ)
	{
		$table = 'courts';
		$usr = CurrentUserID();
		WriteAuditTrail("log", DbCurrentDateTime(), ScriptName(), $usr, $typ, $table, "", "", "", "");
	}

	// Write Audit Trail (add page)
	public function writeAuditTrailOnAdd(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnAdd)
			return;
		$table = 'courts';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['CourtID'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$newvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$newvalue = $rs[$fldname];
					else
						$newvalue = "[MEMO]"; // Memo Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$newvalue = "[XML]"; // XML Field
				} else {
					$newvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $usr, "A", $table, $fldname, $key, "", $newvalue);
			}
		}
	}

	// Write Audit Trail (edit page)
	public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
	{
		global $Language;
		if (!$this->AuditTrailOnEdit)
			return;
		$table = 'courts';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rsold['CourtID'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rsnew) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && array_key_exists($fldname, $rsold) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
					$modified = (FormatDateTime($rsold[$fldname], 0) <> FormatDateTime($rsnew[$fldname], 0));
				} else {
					$modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
				}
				if ($modified) {
					if ($this->fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
						$oldvalue = $Language->phrase("PasswordMask");
						$newvalue = $Language->phrase("PasswordMask");
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
						if (AUDIT_TRAIL_TO_DATABASE) {
							$oldvalue = $rsold[$fldname];
							$newvalue = $rsnew[$fldname];
						} else {
							$oldvalue = "[MEMO]";
							$newvalue = "[MEMO]";
						}
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) { // XML field
						$oldvalue = "[XML]";
						$newvalue = "[XML]";
					} else {
						$oldvalue = $rsold[$fldname];
						$newvalue = $rsnew[$fldname];
					}
					WriteAuditTrail("log", $dt, $id, $usr, "U", $table, $fldname, $key, $oldvalue, $newvalue);
				}
			}
		}
	}

	// Write Audit Trail (delete page)
	public function writeAuditTrailOnDelete(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnDelete)
			return;
		$table = 'courts';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['CourtID'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$curUser = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$oldvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$oldvalue = $rs[$fldname];
					else
						$oldvalue = "[MEMO]"; // Memo field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$oldvalue = "[XML]"; // XML field
				} else {
					$oldvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $curUser, "D", $table, $fldname, $key, $oldvalue, "");
			}
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>
