<?php
namespace PHPMaker2019\project_germanos;

/**
 * Table class for employeeperson
 */
class employeeperson extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Audit trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Export
	public $ExportDoc;

	// Fields
	public $EmployeePersonID;
	public $EmployeeID;
	public $MaritalStatusID;
	public $CivilStatus23;
	public $CivilStatusPlace;
	public $IdCard23;
	public $PracticingProfessionLicense23;
	public $NationalId23;
	public $Nationality1;
	public $Nationality2;
	public $Nationality3;
	public $DriverLicense23;
	public $Extra23;
	public $Notes;
	public $_UserID;
	public $CreatedBy;
	public $CreatedDate;
	public $UpdatedBy;
	public $UpdatedDate;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'employeeperson';
		$this->TableName = 'employeeperson';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`employeeperson`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = TRUE; // Allow detail add
		$this->DetailEdit = TRUE; // Allow detail edit
		$this->DetailView = TRUE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "AND";

		// EmployeePersonID
		$this->EmployeePersonID = new DbField('employeeperson', 'employeeperson', 'x_EmployeePersonID', 'EmployeePersonID', '`EmployeePersonID`', '`EmployeePersonID`', 3, -1, FALSE, '`EmployeePersonID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'HIDDEN');
		$this->EmployeePersonID->IsAutoIncrement = TRUE; // Autoincrement field
		$this->EmployeePersonID->IsPrimaryKey = TRUE; // Primary key field
		$this->EmployeePersonID->Sortable = TRUE; // Allow sort
		$this->EmployeePersonID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['EmployeePersonID'] = &$this->EmployeePersonID;

		// EmployeeID
		$this->EmployeeID = new DbField('employeeperson', 'employeeperson', 'x_EmployeeID', 'EmployeeID', '`EmployeeID`', '`EmployeeID`', 3, -1, FALSE, '`EmployeeID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->EmployeeID->IsForeignKey = TRUE; // Foreign key field
		$this->EmployeeID->Nullable = FALSE; // NOT NULL field
		$this->EmployeeID->Required = TRUE; // Required field
		$this->EmployeeID->Sortable = TRUE; // Allow sort
		$this->EmployeeID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->EmployeeID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->EmployeeID->Lookup = new Lookup('EmployeeID', 'employees', FALSE, 'EmployeeID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->EmployeeID->Lookup = new Lookup('EmployeeID', 'employees', FALSE, 'EmployeeID', ["FirstNameEn","MiddleNameEn","LastNameEn",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->EmployeeID->Lookup = new Lookup('EmployeeID', 'employees', FALSE, 'EmployeeID', ["FirstNameEn","MiddleNameEn","LastNameEn",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->EmployeeID->Lookup = new Lookup('EmployeeID', 'employees', FALSE, 'EmployeeID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->EmployeeID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['EmployeeID'] = &$this->EmployeeID;

		// MaritalStatusID
		$this->MaritalStatusID = new DbField('employeeperson', 'employeeperson', 'x_MaritalStatusID', 'MaritalStatusID', '`MaritalStatusID`', '`MaritalStatusID`', 3, -1, FALSE, '`MaritalStatusID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->MaritalStatusID->Sortable = TRUE; // Allow sort
		$this->MaritalStatusID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->MaritalStatusID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->MaritalStatusID->Lookup = new Lookup('MaritalStatusID', 'maritalstatus', FALSE, 'MaritalStatusID', ["MaritalStatus","MaritalStatusEn",null,""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->MaritalStatusID->Lookup = new Lookup('MaritalStatusID', 'maritalstatus', FALSE, 'MaritalStatusID', ["MaritalStatusEn","MaritalStatusEn",null,""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->MaritalStatusID->Lookup = new Lookup('MaritalStatusID', 'maritalstatus', FALSE, 'MaritalStatusID', ["MaritalStatusEn","MaritalStatusEn",null,""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->MaritalStatusID->Lookup = new Lookup('MaritalStatusID', 'maritalstatus', FALSE, 'MaritalStatusID', ["MaritalStatus","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->MaritalStatusID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['MaritalStatusID'] = &$this->MaritalStatusID;

		// CivilStatus#
		$this->CivilStatus23 = new DbField('employeeperson', 'employeeperson', 'x_CivilStatus23', 'CivilStatus#', '`CivilStatus#`', '`CivilStatus#`', 200, -1, FALSE, '`CivilStatus#`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CivilStatus23->Sortable = TRUE; // Allow sort
		$this->fields['CivilStatus#'] = &$this->CivilStatus23;

		// CivilStatusPlace
		$this->CivilStatusPlace = new DbField('employeeperson', 'employeeperson', 'x_CivilStatusPlace', 'CivilStatusPlace', '`CivilStatusPlace`', '`CivilStatusPlace`', 200, -1, FALSE, '`CivilStatusPlace`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CivilStatusPlace->Sortable = TRUE; // Allow sort
		$this->fields['CivilStatusPlace'] = &$this->CivilStatusPlace;

		// IdCard#
		$this->IdCard23 = new DbField('employeeperson', 'employeeperson', 'x_IdCard23', 'IdCard#', '`IdCard#`', '`IdCard#`', 200, -1, FALSE, '`IdCard#`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->IdCard23->Sortable = TRUE; // Allow sort
		$this->fields['IdCard#'] = &$this->IdCard23;

		// PracticingProfessionLicense#
		$this->PracticingProfessionLicense23 = new DbField('employeeperson', 'employeeperson', 'x_PracticingProfessionLicense23', 'PracticingProfessionLicense#', '`PracticingProfessionLicense#`', '`PracticingProfessionLicense#`', 200, -1, FALSE, '`PracticingProfessionLicense#`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->PracticingProfessionLicense23->Sortable = TRUE; // Allow sort
		$this->fields['PracticingProfessionLicense#'] = &$this->PracticingProfessionLicense23;

		// NationalId#
		$this->NationalId23 = new DbField('employeeperson', 'employeeperson', 'x_NationalId23', 'NationalId#', '`NationalId#`', '`NationalId#`', 200, -1, FALSE, '`NationalId#`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NationalId23->Sortable = TRUE; // Allow sort
		$this->fields['NationalId#'] = &$this->NationalId23;

		// Nationality1
		$this->Nationality1 = new DbField('employeeperson', 'employeeperson', 'x_Nationality1', 'Nationality1', '`Nationality1`', '`Nationality1`', 200, -1, FALSE, '`Nationality1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nationality1->Sortable = TRUE; // Allow sort
		$this->fields['Nationality1'] = &$this->Nationality1;

		// Nationality2
		$this->Nationality2 = new DbField('employeeperson', 'employeeperson', 'x_Nationality2', 'Nationality2', '`Nationality2`', '`Nationality2`', 200, -1, FALSE, '`Nationality2`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nationality2->Sortable = TRUE; // Allow sort
		$this->fields['Nationality2'] = &$this->Nationality2;

		// Nationality3
		$this->Nationality3 = new DbField('employeeperson', 'employeeperson', 'x_Nationality3', 'Nationality3', '`Nationality3`', '`Nationality3`', 200, -1, FALSE, '`Nationality3`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nationality3->Sortable = TRUE; // Allow sort
		$this->fields['Nationality3'] = &$this->Nationality3;

		// DriverLicense#
		$this->DriverLicense23 = new DbField('employeeperson', 'employeeperson', 'x_DriverLicense23', 'DriverLicense#', '`DriverLicense#`', '`DriverLicense#`', 200, -1, FALSE, '`DriverLicense#`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->DriverLicense23->Sortable = TRUE; // Allow sort
		$this->fields['DriverLicense#'] = &$this->DriverLicense23;

		// Extra#
		$this->Extra23 = new DbField('employeeperson', 'employeeperson', 'x_Extra23', 'Extra#', '`Extra#`', '`Extra#`', 200, -1, FALSE, '`Extra#`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Extra23->Sortable = TRUE; // Allow sort
		$this->fields['Extra#'] = &$this->Extra23;

		// Notes
		$this->Notes = new DbField('employeeperson', 'employeeperson', 'x_Notes', 'Notes', '`Notes`', '`Notes`', 201, -1, FALSE, '`Notes`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->Notes->Sortable = TRUE; // Allow sort
		$this->fields['Notes'] = &$this->Notes;

		// UserID
		$this->_UserID = new DbField('employeeperson', 'employeeperson', 'x__UserID', 'UserID', '`UserID`', '`UserID`', 3, -1, FALSE, '`UserID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_UserID->Sortable = FALSE; // Allow sort
		$this->_UserID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['UserID'] = &$this->_UserID;

		// CreatedBy
		$this->CreatedBy = new DbField('employeeperson', 'employeeperson', 'x_CreatedBy', 'CreatedBy', '`CreatedBy`', '`CreatedBy`', 200, -1, FALSE, '`CreatedBy`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CreatedBy->Sortable = FALSE; // Allow sort
		$this->fields['CreatedBy'] = &$this->CreatedBy;

		// CreatedDate
		$this->CreatedDate = new DbField('employeeperson', 'employeeperson', 'x_CreatedDate', 'CreatedDate', '`CreatedDate`', CastDateFieldForLike('`CreatedDate`', 0, "DB"), 135, 0, FALSE, '`CreatedDate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CreatedDate->Sortable = FALSE; // Allow sort
		$this->CreatedDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['CreatedDate'] = &$this->CreatedDate;

		// UpdatedBy
		$this->UpdatedBy = new DbField('employeeperson', 'employeeperson', 'x_UpdatedBy', 'UpdatedBy', '`UpdatedBy`', '`UpdatedBy`', 200, -1, FALSE, '`UpdatedBy`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->UpdatedBy->Sortable = FALSE; // Allow sort
		$this->fields['UpdatedBy'] = &$this->UpdatedBy;

		// UpdatedDate
		$this->UpdatedDate = new DbField('employeeperson', 'employeeperson', 'x_UpdatedDate', 'UpdatedDate', '`UpdatedDate`', CastDateFieldForLike('`UpdatedDate`', 0, "DB"), 135, 0, FALSE, '`UpdatedDate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->UpdatedDate->Sortable = FALSE; // Allow sort
		$this->UpdatedDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['UpdatedDate'] = &$this->UpdatedDate;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Current master table name
	public function getCurrentMasterTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_MASTER_TABLE];
	}
	public function setCurrentMasterTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_MASTER_TABLE] = $v;
	}

	// Session master WHERE clause
	public function getMasterFilter()
	{

		// Master filter
		$masterFilter = "";
		if ($this->getCurrentMasterTable() == "employees") {
			if ($this->EmployeeID->getSessionValue() <> "")
				$masterFilter .= "`EmployeeID`=" . QuotedValue($this->EmployeeID->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		return $masterFilter;
	}

	// Session detail WHERE clause
	public function getDetailFilter()
	{

		// Detail filter
		$detailFilter = "";
		if ($this->getCurrentMasterTable() == "employees") {
			if ($this->EmployeeID->getSessionValue() <> "")
				$detailFilter .= "`EmployeeID`=" . QuotedValue($this->EmployeeID->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		return $detailFilter;
	}

	// Master filter
	public function sqlMasterFilter_employees()
	{
		return "`EmployeeID`=@EmployeeID@";
	}

	// Detail filter
	public function sqlDetailFilter_employees()
	{
		return "`EmployeeID`=@EmployeeID@";
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`employeeperson`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		global $Security;

		// Add User ID filter
		if ($Security->currentUserID() <> "" && !$Security->isAdmin()) { // Non system admin
			if ($this->getCurrentMasterTable() == "employees" || $this->getCurrentMasterTable() == "")
				$filter = $this->addDetailUserIDFilter($filter, "employees"); // Add detail User ID filter
		}
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->EmployeePersonID->setDbValue($conn->insert_ID());
			$rs['EmployeePersonID'] = $this->EmployeePersonID->DbValue;
			if ($this->AuditTrailOnAdd)
				$this->writeAuditTrailOnAdd($rs);
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnEdit && $rsold) {
			$rsaudit = $rs;
			$fldname = 'EmployeePersonID';
			if (!array_key_exists($fldname, $rsaudit))
				$rsaudit[$fldname] = $rsold[$fldname];
			$this->writeAuditTrailOnEdit($rsold, $rsaudit);
		}
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('EmployeePersonID', $rs))
				AddFilter($where, QuotedName('EmployeePersonID', $this->Dbid) . '=' . QuotedValue($rs['EmployeePersonID'], $this->EmployeePersonID->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnDelete)
			$this->writeAuditTrailOnDelete($rs);
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->EmployeePersonID->DbValue = $row['EmployeePersonID'];
		$this->EmployeeID->DbValue = $row['EmployeeID'];
		$this->MaritalStatusID->DbValue = $row['MaritalStatusID'];
		$this->CivilStatus23->DbValue = $row['CivilStatus#'];
		$this->CivilStatusPlace->DbValue = $row['CivilStatusPlace'];
		$this->IdCard23->DbValue = $row['IdCard#'];
		$this->PracticingProfessionLicense23->DbValue = $row['PracticingProfessionLicense#'];
		$this->NationalId23->DbValue = $row['NationalId#'];
		$this->Nationality1->DbValue = $row['Nationality1'];
		$this->Nationality2->DbValue = $row['Nationality2'];
		$this->Nationality3->DbValue = $row['Nationality3'];
		$this->DriverLicense23->DbValue = $row['DriverLicense#'];
		$this->Extra23->DbValue = $row['Extra#'];
		$this->Notes->DbValue = $row['Notes'];
		$this->_UserID->DbValue = $row['UserID'];
		$this->CreatedBy->DbValue = $row['CreatedBy'];
		$this->CreatedDate->DbValue = $row['CreatedDate'];
		$this->UpdatedBy->DbValue = $row['UpdatedBy'];
		$this->UpdatedDate->DbValue = $row['UpdatedDate'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`EmployeePersonID` = @EmployeePersonID@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('EmployeePersonID', $row) ? $row['EmployeePersonID'] : NULL) : $this->EmployeePersonID->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@EmployeePersonID@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "employeepersonlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "employeepersonview.php")
			return $Language->phrase("View");
		elseif ($pageName == "employeepersonedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "employeepersonadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "employeepersonlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("employeepersonview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("employeepersonview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "employeepersonadd.php?" . $this->getUrlParm($parm);
		else
			$url = "employeepersonadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("employeepersonedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("employeepersonadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("employeepersondelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		if ($this->getCurrentMasterTable() == "employees" && !ContainsString($url, TABLE_SHOW_MASTER . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . TABLE_SHOW_MASTER . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_EmployeeID=" . urlencode($this->EmployeeID->CurrentValue);
		}
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "EmployeePersonID:" . JsonEncode($this->EmployeePersonID->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->EmployeePersonID->CurrentValue != NULL) {
			$url .= "EmployeePersonID=" . urlencode($this->EmployeePersonID->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("EmployeePersonID") !== NULL)
				$arKeys[] = Param("EmployeePersonID");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->EmployeePersonID->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->EmployeePersonID->setDbValue($rs->fields('EmployeePersonID'));
		$this->EmployeeID->setDbValue($rs->fields('EmployeeID'));
		$this->MaritalStatusID->setDbValue($rs->fields('MaritalStatusID'));
		$this->CivilStatus23->setDbValue($rs->fields('CivilStatus#'));
		$this->CivilStatusPlace->setDbValue($rs->fields('CivilStatusPlace'));
		$this->IdCard23->setDbValue($rs->fields('IdCard#'));
		$this->PracticingProfessionLicense23->setDbValue($rs->fields('PracticingProfessionLicense#'));
		$this->NationalId23->setDbValue($rs->fields('NationalId#'));
		$this->Nationality1->setDbValue($rs->fields('Nationality1'));
		$this->Nationality2->setDbValue($rs->fields('Nationality2'));
		$this->Nationality3->setDbValue($rs->fields('Nationality3'));
		$this->DriverLicense23->setDbValue($rs->fields('DriverLicense#'));
		$this->Extra23->setDbValue($rs->fields('Extra#'));
		$this->Notes->setDbValue($rs->fields('Notes'));
		$this->_UserID->setDbValue($rs->fields('UserID'));
		$this->CreatedBy->setDbValue($rs->fields('CreatedBy'));
		$this->CreatedDate->setDbValue($rs->fields('CreatedDate'));
		$this->UpdatedBy->setDbValue($rs->fields('UpdatedBy'));
		$this->UpdatedDate->setDbValue($rs->fields('UpdatedDate'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// EmployeePersonID
		// EmployeeID
		// MaritalStatusID
		// CivilStatus#
		// CivilStatusPlace
		// IdCard#
		// PracticingProfessionLicense#
		// NationalId#
		// Nationality1
		// Nationality2
		// Nationality3
		// DriverLicense#
		// Extra#
		// Notes
		// UserID

		$this->_UserID->CellCssStyle = "white-space: nowrap;";

		// CreatedBy
		$this->CreatedBy->CellCssStyle = "white-space: nowrap;";

		// CreatedDate
		$this->CreatedDate->CellCssStyle = "white-space: nowrap;";

		// UpdatedBy
		$this->UpdatedBy->CellCssStyle = "white-space: nowrap;";

		// UpdatedDate
		$this->UpdatedDate->CellCssStyle = "white-space: nowrap;";

		// EmployeePersonID
		$this->EmployeePersonID->ViewValue = $this->EmployeePersonID->CurrentValue;
		$this->EmployeePersonID->ViewCustomAttributes = "";

		// EmployeeID
		$curVal = strval($this->EmployeeID->CurrentValue);
		if ($curVal <> "") {
			$this->EmployeeID->ViewValue = $this->EmployeeID->lookupCacheOption($curVal);
			if ($this->EmployeeID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`EmployeeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->EmployeeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->EmployeeID->ViewValue = $this->EmployeeID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->EmployeeID->ViewValue = $this->EmployeeID->CurrentValue;
				}
			}
		} else {
			$this->EmployeeID->ViewValue = NULL;
		}
		$this->EmployeeID->ViewCustomAttributes = "";

		// MaritalStatusID
		$curVal = strval($this->MaritalStatusID->CurrentValue);
		if ($curVal <> "") {
			$this->MaritalStatusID->ViewValue = $this->MaritalStatusID->lookupCacheOption($curVal);
			if ($this->MaritalStatusID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`MaritalStatusID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->MaritalStatusID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->MaritalStatusID->ViewValue = $this->MaritalStatusID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->MaritalStatusID->ViewValue = $this->MaritalStatusID->CurrentValue;
				}
			}
		} else {
			$this->MaritalStatusID->ViewValue = NULL;
		}
		$this->MaritalStatusID->ViewCustomAttributes = "";

		// CivilStatus#
		$this->CivilStatus23->ViewValue = $this->CivilStatus23->CurrentValue;
		$this->CivilStatus23->ViewCustomAttributes = "";

		// CivilStatusPlace
		$this->CivilStatusPlace->ViewValue = $this->CivilStatusPlace->CurrentValue;
		$this->CivilStatusPlace->ViewCustomAttributes = "";

		// IdCard#
		$this->IdCard23->ViewValue = $this->IdCard23->CurrentValue;
		$this->IdCard23->ViewCustomAttributes = "";

		// PracticingProfessionLicense#
		$this->PracticingProfessionLicense23->ViewValue = $this->PracticingProfessionLicense23->CurrentValue;
		$this->PracticingProfessionLicense23->ViewCustomAttributes = "";

		// NationalId#
		$this->NationalId23->ViewValue = $this->NationalId23->CurrentValue;
		$this->NationalId23->ViewCustomAttributes = "";

		// Nationality1
		$this->Nationality1->ViewValue = $this->Nationality1->CurrentValue;
		$this->Nationality1->ViewCustomAttributes = "";

		// Nationality2
		$this->Nationality2->ViewValue = $this->Nationality2->CurrentValue;
		$this->Nationality2->ViewCustomAttributes = "";

		// Nationality3
		$this->Nationality3->ViewValue = $this->Nationality3->CurrentValue;
		$this->Nationality3->ViewCustomAttributes = "";

		// DriverLicense#
		$this->DriverLicense23->ViewValue = $this->DriverLicense23->CurrentValue;
		$this->DriverLicense23->ViewCustomAttributes = "";

		// Extra#
		$this->Extra23->ViewValue = $this->Extra23->CurrentValue;
		$this->Extra23->ViewCustomAttributes = "";

		// Notes
		$this->Notes->ViewValue = $this->Notes->CurrentValue;
		$this->Notes->ViewCustomAttributes = "";

		// UserID
		$this->_UserID->ViewValue = $this->_UserID->CurrentValue;
		$this->_UserID->ViewValue = FormatNumber($this->_UserID->ViewValue, 0, -2, -2, -2);
		$this->_UserID->ViewCustomAttributes = "";

		// CreatedBy
		$this->CreatedBy->ViewValue = $this->CreatedBy->CurrentValue;
		$this->CreatedBy->ViewCustomAttributes = "";

		// CreatedDate
		$this->CreatedDate->ViewValue = $this->CreatedDate->CurrentValue;
		$this->CreatedDate->ViewValue = FormatDateTime($this->CreatedDate->ViewValue, 0);
		$this->CreatedDate->ViewCustomAttributes = "";

		// UpdatedBy
		$this->UpdatedBy->ViewValue = $this->UpdatedBy->CurrentValue;
		$this->UpdatedBy->ViewCustomAttributes = "";

		// UpdatedDate
		$this->UpdatedDate->ViewValue = $this->UpdatedDate->CurrentValue;
		$this->UpdatedDate->ViewValue = FormatDateTime($this->UpdatedDate->ViewValue, 0);
		$this->UpdatedDate->ViewCustomAttributes = "";

		// EmployeePersonID
		$this->EmployeePersonID->LinkCustomAttributes = "";
		$this->EmployeePersonID->HrefValue = "";
		$this->EmployeePersonID->TooltipValue = "";

		// EmployeeID
		$this->EmployeeID->LinkCustomAttributes = "";
		$this->EmployeeID->HrefValue = "";
		$this->EmployeeID->TooltipValue = "";

		// MaritalStatusID
		$this->MaritalStatusID->LinkCustomAttributes = "";
		$this->MaritalStatusID->HrefValue = "";
		$this->MaritalStatusID->TooltipValue = "";

		// CivilStatus#
		$this->CivilStatus23->LinkCustomAttributes = "";
		$this->CivilStatus23->HrefValue = "";
		$this->CivilStatus23->TooltipValue = "";

		// CivilStatusPlace
		$this->CivilStatusPlace->LinkCustomAttributes = "";
		$this->CivilStatusPlace->HrefValue = "";
		$this->CivilStatusPlace->TooltipValue = "";

		// IdCard#
		$this->IdCard23->LinkCustomAttributes = "";
		$this->IdCard23->HrefValue = "";
		$this->IdCard23->TooltipValue = "";

		// PracticingProfessionLicense#
		$this->PracticingProfessionLicense23->LinkCustomAttributes = "";
		$this->PracticingProfessionLicense23->HrefValue = "";
		$this->PracticingProfessionLicense23->TooltipValue = "";

		// NationalId#
		$this->NationalId23->LinkCustomAttributes = "";
		$this->NationalId23->HrefValue = "";
		$this->NationalId23->TooltipValue = "";

		// Nationality1
		$this->Nationality1->LinkCustomAttributes = "";
		$this->Nationality1->HrefValue = "";
		$this->Nationality1->TooltipValue = "";

		// Nationality2
		$this->Nationality2->LinkCustomAttributes = "";
		$this->Nationality2->HrefValue = "";
		$this->Nationality2->TooltipValue = "";

		// Nationality3
		$this->Nationality3->LinkCustomAttributes = "";
		$this->Nationality3->HrefValue = "";
		$this->Nationality3->TooltipValue = "";

		// DriverLicense#
		$this->DriverLicense23->LinkCustomAttributes = "";
		$this->DriverLicense23->HrefValue = "";
		$this->DriverLicense23->TooltipValue = "";

		// Extra#
		$this->Extra23->LinkCustomAttributes = "";
		$this->Extra23->HrefValue = "";
		$this->Extra23->TooltipValue = "";

		// Notes
		$this->Notes->LinkCustomAttributes = "";
		$this->Notes->HrefValue = "";
		$this->Notes->TooltipValue = "";

		// UserID
		$this->_UserID->LinkCustomAttributes = "";
		$this->_UserID->HrefValue = "";
		$this->_UserID->TooltipValue = "";

		// CreatedBy
		$this->CreatedBy->LinkCustomAttributes = "";
		$this->CreatedBy->HrefValue = "";
		$this->CreatedBy->TooltipValue = "";

		// CreatedDate
		$this->CreatedDate->LinkCustomAttributes = "";
		$this->CreatedDate->HrefValue = "";
		$this->CreatedDate->TooltipValue = "";

		// UpdatedBy
		$this->UpdatedBy->LinkCustomAttributes = "";
		$this->UpdatedBy->HrefValue = "";
		$this->UpdatedBy->TooltipValue = "";

		// UpdatedDate
		$this->UpdatedDate->LinkCustomAttributes = "";
		$this->UpdatedDate->HrefValue = "";
		$this->UpdatedDate->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// EmployeePersonID
		$this->EmployeePersonID->EditAttrs["class"] = "form-control";
		$this->EmployeePersonID->EditCustomAttributes = "";

		// EmployeeID
		$this->EmployeeID->EditAttrs["class"] = "form-control";
		$this->EmployeeID->EditCustomAttributes = "";
		if ($this->EmployeeID->getSessionValue() <> "") {
			$this->EmployeeID->CurrentValue = $this->EmployeeID->getSessionValue();
		$curVal = strval($this->EmployeeID->CurrentValue);
		if ($curVal <> "") {
			$this->EmployeeID->ViewValue = $this->EmployeeID->lookupCacheOption($curVal);
			if ($this->EmployeeID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`EmployeeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->EmployeeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->EmployeeID->ViewValue = $this->EmployeeID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->EmployeeID->ViewValue = $this->EmployeeID->CurrentValue;
				}
			}
		} else {
			$this->EmployeeID->ViewValue = NULL;
		}
		$this->EmployeeID->ViewCustomAttributes = "";
		} else {
		}

		// MaritalStatusID
		$this->MaritalStatusID->EditAttrs["class"] = "form-control";
		$this->MaritalStatusID->EditCustomAttributes = "";

		// CivilStatus#
		$this->CivilStatus23->EditAttrs["class"] = "form-control";
		$this->CivilStatus23->EditCustomAttributes = "";
		$this->CivilStatus23->EditValue = $this->CivilStatus23->CurrentValue;
		$this->CivilStatus23->PlaceHolder = RemoveHtml($this->CivilStatus23->caption());

		// CivilStatusPlace
		$this->CivilStatusPlace->EditAttrs["class"] = "form-control";
		$this->CivilStatusPlace->EditCustomAttributes = "";
		$this->CivilStatusPlace->EditValue = $this->CivilStatusPlace->CurrentValue;
		$this->CivilStatusPlace->PlaceHolder = RemoveHtml($this->CivilStatusPlace->caption());

		// IdCard#
		$this->IdCard23->EditAttrs["class"] = "form-control";
		$this->IdCard23->EditCustomAttributes = "";
		$this->IdCard23->EditValue = $this->IdCard23->CurrentValue;
		$this->IdCard23->PlaceHolder = RemoveHtml($this->IdCard23->caption());

		// PracticingProfessionLicense#
		$this->PracticingProfessionLicense23->EditAttrs["class"] = "form-control";
		$this->PracticingProfessionLicense23->EditCustomAttributes = "";
		$this->PracticingProfessionLicense23->EditValue = $this->PracticingProfessionLicense23->CurrentValue;
		$this->PracticingProfessionLicense23->PlaceHolder = RemoveHtml($this->PracticingProfessionLicense23->caption());

		// NationalId#
		$this->NationalId23->EditAttrs["class"] = "form-control";
		$this->NationalId23->EditCustomAttributes = "";
		$this->NationalId23->EditValue = $this->NationalId23->CurrentValue;
		$this->NationalId23->PlaceHolder = RemoveHtml($this->NationalId23->caption());

		// Nationality1
		$this->Nationality1->EditAttrs["class"] = "form-control";
		$this->Nationality1->EditCustomAttributes = "";
		$this->Nationality1->EditValue = $this->Nationality1->CurrentValue;
		$this->Nationality1->PlaceHolder = RemoveHtml($this->Nationality1->caption());

		// Nationality2
		$this->Nationality2->EditAttrs["class"] = "form-control";
		$this->Nationality2->EditCustomAttributes = "";
		$this->Nationality2->EditValue = $this->Nationality2->CurrentValue;
		$this->Nationality2->PlaceHolder = RemoveHtml($this->Nationality2->caption());

		// Nationality3
		$this->Nationality3->EditAttrs["class"] = "form-control";
		$this->Nationality3->EditCustomAttributes = "";
		$this->Nationality3->EditValue = $this->Nationality3->CurrentValue;
		$this->Nationality3->PlaceHolder = RemoveHtml($this->Nationality3->caption());

		// DriverLicense#
		$this->DriverLicense23->EditAttrs["class"] = "form-control";
		$this->DriverLicense23->EditCustomAttributes = "";
		$this->DriverLicense23->EditValue = $this->DriverLicense23->CurrentValue;
		$this->DriverLicense23->PlaceHolder = RemoveHtml($this->DriverLicense23->caption());

		// Extra#
		$this->Extra23->EditAttrs["class"] = "form-control";
		$this->Extra23->EditCustomAttributes = "";
		$this->Extra23->EditValue = $this->Extra23->CurrentValue;
		$this->Extra23->PlaceHolder = RemoveHtml($this->Extra23->caption());

		// Notes
		$this->Notes->EditAttrs["class"] = "form-control";
		$this->Notes->EditCustomAttributes = "";
		$this->Notes->EditValue = $this->Notes->CurrentValue;
		$this->Notes->PlaceHolder = RemoveHtml($this->Notes->caption());

		// UserID
		$this->_UserID->EditAttrs["class"] = "form-control";
		$this->_UserID->EditCustomAttributes = "";
		$this->_UserID->EditValue = $this->_UserID->CurrentValue;
		$this->_UserID->PlaceHolder = RemoveHtml($this->_UserID->caption());

		// CreatedBy
		$this->CreatedBy->EditAttrs["class"] = "form-control";
		$this->CreatedBy->EditCustomAttributes = "";
		$this->CreatedBy->EditValue = $this->CreatedBy->CurrentValue;
		$this->CreatedBy->PlaceHolder = RemoveHtml($this->CreatedBy->caption());

		// CreatedDate
		$this->CreatedDate->EditAttrs["class"] = "form-control";
		$this->CreatedDate->EditCustomAttributes = "";
		$this->CreatedDate->EditValue = FormatDateTime($this->CreatedDate->CurrentValue, 8);
		$this->CreatedDate->PlaceHolder = RemoveHtml($this->CreatedDate->caption());

		// UpdatedBy
		$this->UpdatedBy->EditAttrs["class"] = "form-control";
		$this->UpdatedBy->EditCustomAttributes = "";
		$this->UpdatedBy->EditValue = $this->UpdatedBy->CurrentValue;
		$this->UpdatedBy->PlaceHolder = RemoveHtml($this->UpdatedBy->caption());

		// UpdatedDate
		$this->UpdatedDate->EditAttrs["class"] = "form-control";
		$this->UpdatedDate->EditCustomAttributes = "";
		$this->UpdatedDate->EditValue = FormatDateTime($this->UpdatedDate->CurrentValue, 8);
		$this->UpdatedDate->PlaceHolder = RemoveHtml($this->UpdatedDate->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->EmployeePersonID);
					$doc->exportCaption($this->EmployeeID);
					$doc->exportCaption($this->MaritalStatusID);
					$doc->exportCaption($this->CivilStatus23);
					$doc->exportCaption($this->CivilStatusPlace);
					$doc->exportCaption($this->IdCard23);
					$doc->exportCaption($this->PracticingProfessionLicense23);
					$doc->exportCaption($this->NationalId23);
					$doc->exportCaption($this->Nationality1);
					$doc->exportCaption($this->Nationality2);
					$doc->exportCaption($this->Nationality3);
					$doc->exportCaption($this->DriverLicense23);
					$doc->exportCaption($this->Extra23);
					$doc->exportCaption($this->Notes);
				} else {
					$doc->exportCaption($this->EmployeePersonID);
					$doc->exportCaption($this->EmployeeID);
					$doc->exportCaption($this->MaritalStatusID);
					$doc->exportCaption($this->CivilStatus23);
					$doc->exportCaption($this->CivilStatusPlace);
					$doc->exportCaption($this->IdCard23);
					$doc->exportCaption($this->PracticingProfessionLicense23);
					$doc->exportCaption($this->NationalId23);
					$doc->exportCaption($this->Nationality1);
					$doc->exportCaption($this->Nationality2);
					$doc->exportCaption($this->Nationality3);
					$doc->exportCaption($this->DriverLicense23);
					$doc->exportCaption($this->Extra23);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->EmployeePersonID);
						$doc->exportField($this->EmployeeID);
						$doc->exportField($this->MaritalStatusID);
						$doc->exportField($this->CivilStatus23);
						$doc->exportField($this->CivilStatusPlace);
						$doc->exportField($this->IdCard23);
						$doc->exportField($this->PracticingProfessionLicense23);
						$doc->exportField($this->NationalId23);
						$doc->exportField($this->Nationality1);
						$doc->exportField($this->Nationality2);
						$doc->exportField($this->Nationality3);
						$doc->exportField($this->DriverLicense23);
						$doc->exportField($this->Extra23);
						$doc->exportField($this->Notes);
					} else {
						$doc->exportField($this->EmployeePersonID);
						$doc->exportField($this->EmployeeID);
						$doc->exportField($this->MaritalStatusID);
						$doc->exportField($this->CivilStatus23);
						$doc->exportField($this->CivilStatusPlace);
						$doc->exportField($this->IdCard23);
						$doc->exportField($this->PracticingProfessionLicense23);
						$doc->exportField($this->NationalId23);
						$doc->exportField($this->Nationality1);
						$doc->exportField($this->Nationality2);
						$doc->exportField($this->Nationality3);
						$doc->exportField($this->DriverLicense23);
						$doc->exportField($this->Extra23);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Add master User ID filter
	public function addMasterUserIDFilter($filter, $currentMasterTable)
	{
		$filterWrk = $filter;
		if ($currentMasterTable == "employees") {
			$filterWrk = $GLOBALS["employees"]->addUserIDFilter($filterWrk);
		}
		return $filterWrk;
	}

	// Add detail User ID filter
	public function addDetailUserIDFilter($filter, $currentMasterTable)
	{
		$filterWrk = $filter;
		if ($currentMasterTable == "employees") {
			$mastertable = $GLOBALS["employees"];
			if (!$mastertable->userIdAllow()) {
				$subqueryWrk = $mastertable->getUserIDSubquery($this->EmployeeID, $mastertable->EmployeeID);
				AddFilter($filterWrk, $subqueryWrk);
			}
		}
		return $filterWrk;
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		if (!$validRequest)
			return FALSE;

		// Load lookup parameters
		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Write Audit Trail start/end for grid update
	public function writeAuditTrailDummy($typ)
	{
		$table = 'employeeperson';
		$usr = CurrentUserID();
		WriteAuditTrail("log", DbCurrentDateTime(), ScriptName(), $usr, $typ, $table, "", "", "", "");
	}

	// Write Audit Trail (add page)
	public function writeAuditTrailOnAdd(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnAdd)
			return;
		$table = 'employeeperson';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['EmployeePersonID'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$newvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$newvalue = $rs[$fldname];
					else
						$newvalue = "[MEMO]"; // Memo Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$newvalue = "[XML]"; // XML Field
				} else {
					$newvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $usr, "A", $table, $fldname, $key, "", $newvalue);
			}
		}
	}

	// Write Audit Trail (edit page)
	public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
	{
		global $Language;
		if (!$this->AuditTrailOnEdit)
			return;
		$table = 'employeeperson';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rsold['EmployeePersonID'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rsnew) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && array_key_exists($fldname, $rsold) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
					$modified = (FormatDateTime($rsold[$fldname], 0) <> FormatDateTime($rsnew[$fldname], 0));
				} else {
					$modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
				}
				if ($modified) {
					if ($this->fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
						$oldvalue = $Language->phrase("PasswordMask");
						$newvalue = $Language->phrase("PasswordMask");
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
						if (AUDIT_TRAIL_TO_DATABASE) {
							$oldvalue = $rsold[$fldname];
							$newvalue = $rsnew[$fldname];
						} else {
							$oldvalue = "[MEMO]";
							$newvalue = "[MEMO]";
						}
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) { // XML field
						$oldvalue = "[XML]";
						$newvalue = "[XML]";
					} else {
						$oldvalue = $rsold[$fldname];
						$newvalue = $rsnew[$fldname];
					}
					WriteAuditTrail("log", $dt, $id, $usr, "U", $table, $fldname, $key, $oldvalue, $newvalue);
				}
			}
		}
	}

	// Write Audit Trail (delete page)
	public function writeAuditTrailOnDelete(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnDelete)
			return;
		$table = 'employeeperson';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['EmployeePersonID'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$curUser = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$oldvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$oldvalue = $rs[$fldname];
					else
						$oldvalue = "[MEMO]"; // Memo field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$oldvalue = "[XML]"; // XML field
				} else {
					$oldvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $curUser, "D", $table, $fldname, $key, $oldvalue, "");
			}
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>
