<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$clientcontact_preview = new clientcontact_preview();

// Run the page
$clientcontact_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$clientcontact_preview->Page_Render();
?>
<?php $clientcontact_preview->showPageHeader(); ?>
<div class="card ew-grid clientcontact"><!-- .card -->
<?php if ($clientcontact_preview->TotalRecs > 0) { ?>
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$clientcontact_preview->renderListOptions();

// Render list options (header, left)
$clientcontact_preview->ListOptions->render("header", "left");
?>
<?php if ($clientcontact->ClientID->Visible) { // ClientID ?>
	<?php if ($clientcontact->SortUrl($clientcontact->ClientID) == "") { ?>
		<th class="<?php echo $clientcontact->ClientID->headerCellClass() ?>"><?php echo $clientcontact->ClientID->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $clientcontact->ClientID->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $clientcontact->ClientID->Name ?>" data-sort-order="<?php echo $clientcontact_preview->SortField == $clientcontact->ClientID->Name && $clientcontact_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $clientcontact->ClientID->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($clientcontact_preview->SortField == $clientcontact->ClientID->Name) { ?><?php if ($clientcontact_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($clientcontact_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientcontact->ContactTypeID->Visible) { // ContactTypeID ?>
	<?php if ($clientcontact->SortUrl($clientcontact->ContactTypeID) == "") { ?>
		<th class="<?php echo $clientcontact->ContactTypeID->headerCellClass() ?>"><?php echo $clientcontact->ContactTypeID->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $clientcontact->ContactTypeID->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $clientcontact->ContactTypeID->Name ?>" data-sort-order="<?php echo $clientcontact_preview->SortField == $clientcontact->ContactTypeID->Name && $clientcontact_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $clientcontact->ContactTypeID->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($clientcontact_preview->SortField == $clientcontact->ContactTypeID->Name) { ?><?php if ($clientcontact_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($clientcontact_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientcontact->Contact->Visible) { // Contact ?>
	<?php if ($clientcontact->SortUrl($clientcontact->Contact) == "") { ?>
		<th class="<?php echo $clientcontact->Contact->headerCellClass() ?>"><?php echo $clientcontact->Contact->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $clientcontact->Contact->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $clientcontact->Contact->Name ?>" data-sort-order="<?php echo $clientcontact_preview->SortField == $clientcontact->Contact->Name && $clientcontact_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $clientcontact->Contact->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($clientcontact_preview->SortField == $clientcontact->Contact->Name) { ?><?php if ($clientcontact_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($clientcontact_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientcontact->Notes->Visible) { // Notes ?>
	<?php if ($clientcontact->SortUrl($clientcontact->Notes) == "") { ?>
		<th class="<?php echo $clientcontact->Notes->headerCellClass() ?>"><?php echo $clientcontact->Notes->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $clientcontact->Notes->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $clientcontact->Notes->Name ?>" data-sort-order="<?php echo $clientcontact_preview->SortField == $clientcontact->Notes->Name && $clientcontact_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $clientcontact->Notes->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($clientcontact_preview->SortField == $clientcontact->Notes->Name) { ?><?php if ($clientcontact_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($clientcontact_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($clientcontact->Primary->Visible) { // Primary ?>
	<?php if ($clientcontact->SortUrl($clientcontact->Primary) == "") { ?>
		<th class="<?php echo $clientcontact->Primary->headerCellClass() ?>"><?php echo $clientcontact->Primary->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $clientcontact->Primary->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $clientcontact->Primary->Name ?>" data-sort-order="<?php echo $clientcontact_preview->SortField == $clientcontact->Primary->Name && $clientcontact_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $clientcontact->Primary->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($clientcontact_preview->SortField == $clientcontact->Primary->Name) { ?><?php if ($clientcontact_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($clientcontact_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$clientcontact_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$clientcontact_preview->RecCount = 0;
$clientcontact_preview->RowCnt = 0;
while ($clientcontact_preview->Recordset && !$clientcontact_preview->Recordset->EOF) {

	// Init row class and style
	$clientcontact_preview->RecCount++;
	$clientcontact_preview->RowCnt++;
	$clientcontact_preview->CssStyle = "";
	$clientcontact_preview->loadListRowValues($clientcontact_preview->Recordset);

	// Render row
	$clientcontact_preview->RowType = ROWTYPE_PREVIEW; // Preview record
	$clientcontact_preview->resetAttributes();
	$clientcontact_preview->renderListRow();

	// Render list options
	$clientcontact_preview->renderListOptions();
?>
	<tr<?php echo $clientcontact_preview->rowAttributes() ?>>
<?php

// Render list options (body, left)
$clientcontact_preview->ListOptions->render("body", "left", $clientcontact_preview->RowCnt);
?>
<?php if ($clientcontact->ClientID->Visible) { // ClientID ?>
		<!-- ClientID -->
		<td<?php echo $clientcontact->ClientID->cellAttributes() ?>>
<span<?php echo $clientcontact->ClientID->viewAttributes() ?>>
<?php echo $clientcontact->ClientID->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($clientcontact->ContactTypeID->Visible) { // ContactTypeID ?>
		<!-- ContactTypeID -->
		<td<?php echo $clientcontact->ContactTypeID->cellAttributes() ?>>
<span<?php echo $clientcontact->ContactTypeID->viewAttributes() ?>>
<?php echo $clientcontact->ContactTypeID->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($clientcontact->Contact->Visible) { // Contact ?>
		<!-- Contact -->
		<td<?php echo $clientcontact->Contact->cellAttributes() ?>>
<span<?php echo $clientcontact->Contact->viewAttributes() ?>>
<?php if ((!EmptyString($clientcontact->Contact->getViewValue())) && $clientcontact->Contact->linkAttributes() <> "") { ?>
<a<?php echo $clientcontact->Contact->linkAttributes() ?>><?php echo $clientcontact->Contact->getViewValue() ?></a>
<?php } else { ?>
<?php echo $clientcontact->Contact->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($clientcontact->Notes->Visible) { // Notes ?>
		<!-- Notes -->
		<td<?php echo $clientcontact->Notes->cellAttributes() ?>>
<span<?php echo $clientcontact->Notes->viewAttributes() ?>>
<?php echo $clientcontact->Notes->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($clientcontact->Primary->Visible) { // Primary ?>
		<!-- Primary -->
		<td<?php echo $clientcontact->Primary->cellAttributes() ?>>
<span<?php echo $clientcontact->Primary->viewAttributes() ?>>
<?php if (ConvertToBool($clientcontact->Primary->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $clientcontact->Primary->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $clientcontact->Primary->getViewValue() ?>" disabled>
<?php } ?>
</span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$clientcontact_preview->ListOptions->render("body", "right", $clientcontact_preview->RowCnt);
?>
	</tr>
<?php
	$clientcontact_preview->Recordset->MoveNext();
}
?>
	</tbody>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<?php } ?>
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php if ($clientcontact_preview->TotalRecs > 0) { ?>
<?php if (!isset($clientcontact_preview->Pager)) $clientcontact_preview->Pager = new PrevNextPager($clientcontact_preview->StartRec, $clientcontact_preview->DisplayRecs, $clientcontact_preview->TotalRecs) ?>
<?php if ($clientcontact_preview->Pager->RecordCount > 0 && $clientcontact_preview->Pager->Visible) { ?>
<div class="ew-pager"><div class="ew-prev-next"><div class="btn-group btn-group-sm ew-btn-group">
<!--first page button-->
	<?php if ($clientcontact_preview->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" data-start="<?php echo $clientcontact_preview->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($clientcontact_preview->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" data-start="<?php echo $clientcontact_preview->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
<!--next page button-->
	<?php if ($clientcontact_preview->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" data-start="<?php echo $clientcontact_preview->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($clientcontact_preview->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" data-start="<?php echo $clientcontact_preview->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div></div></div>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->phrase("Record") ?>&nbsp;<?php echo $clientcontact_preview->Pager->FromIndex ?>&nbsp;<?php echo $Language->phrase("To") ?>&nbsp;<?php echo $clientcontact_preview->Pager->ToIndex ?>&nbsp;<?php echo $Language->phrase("Of") ?>&nbsp;<?php echo $clientcontact_preview->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php } else { ?>
<div class="ew-detail-count"><?php echo $Language->Phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($clientcontact_preview->OtherOptions as &$option)
		$option->render("body");
?>
</div>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php
$clientcontact_preview->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php
if ($clientcontact_preview->Recordset)
	$clientcontact_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$clientcontact_preview->terminate();
?>
