<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$complaints_search = new complaints_search();

// Run the page
$complaints_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$complaints_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($complaints_search->IsModal) { ?>
var fcomplaintssearch = currentAdvancedSearchForm = new ew.Form("fcomplaintssearch", "search");
<?php } else { ?>
var fcomplaintssearch = currentForm = new ew.Form("fcomplaintssearch", "search");
<?php } ?>

// Form_CustomValidate event
fcomplaintssearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcomplaintssearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search
// Validate function for search

fcomplaintssearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_ComplaintDate");
	if (elm && !ew.checkEuroDate(elm.value))
		return this.onError(elm, "<?php echo JsEncode($complaints->ComplaintDate->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_CaseID");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($complaints->CaseID->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $complaints_search->showPageHeader(); ?>
<?php
$complaints_search->showMessage();
?>
<form name="fcomplaintssearch" id="fcomplaintssearch" class="<?php echo $complaints_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($complaints_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $complaints_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="complaints">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$complaints_search->IsModal ?>">
<?php if (!$complaints_search->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($complaints_search->IsMobileOrModal) { ?>
<div class="ew-search-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_complaintssearch" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($complaints->ComplaintID->Visible) { // ComplaintID ?>
<?php if ($complaints_search->IsMobileOrModal) { ?>
	<div id="r_ComplaintID" class="form-group row">
		<label class="<?php echo $complaints_search->LeftColumnClass ?>"><span id="elh_complaints_ComplaintID"><?php echo $complaints->ComplaintID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ComplaintID" id="z_ComplaintID" value="="></span>
		</label>
		<div class="<?php echo $complaints_search->RightColumnClass ?>"><div<?php echo $complaints->ComplaintID->cellAttributes() ?>>
			<span id="el_complaints_ComplaintID">
<input type="text" data-table="complaints" data-field="x_ComplaintID" name="x_ComplaintID" id="x_ComplaintID" placeholder="<?php echo HtmlEncode($complaints->ComplaintID->getPlaceHolder()) ?>" value="<?php echo $complaints->ComplaintID->EditValue ?>"<?php echo $complaints->ComplaintID->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_ComplaintID">
		<td class="<?php echo $complaints_search->TableLeftColumnClass ?>"><span id="elh_complaints_ComplaintID"><?php echo $complaints->ComplaintID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ComplaintID" id="z_ComplaintID" value="="></span></td>
		<td<?php echo $complaints->ComplaintID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_complaints_ComplaintID">
<input type="text" data-table="complaints" data-field="x_ComplaintID" name="x_ComplaintID" id="x_ComplaintID" placeholder="<?php echo HtmlEncode($complaints->ComplaintID->getPlaceHolder()) ?>" value="<?php echo $complaints->ComplaintID->EditValue ?>"<?php echo $complaints->ComplaintID->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($complaints->CaseNumber->Visible) { // CaseNumber ?>
<?php if ($complaints_search->IsMobileOrModal) { ?>
	<div id="r_CaseNumber" class="form-group row">
		<label for="x_CaseNumber" class="<?php echo $complaints_search->LeftColumnClass ?>"><span id="elh_complaints_CaseNumber"><?php echo $complaints->CaseNumber->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_CaseNumber" id="z_CaseNumber" value="LIKE"></span>
		</label>
		<div class="<?php echo $complaints_search->RightColumnClass ?>"><div<?php echo $complaints->CaseNumber->cellAttributes() ?>>
			<span id="el_complaints_CaseNumber">
<input type="text" data-table="complaints" data-field="x_CaseNumber" name="x_CaseNumber" id="x_CaseNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($complaints->CaseNumber->getPlaceHolder()) ?>" value="<?php echo $complaints->CaseNumber->EditValue ?>"<?php echo $complaints->CaseNumber->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseNumber">
		<td class="<?php echo $complaints_search->TableLeftColumnClass ?>"><span id="elh_complaints_CaseNumber"><?php echo $complaints->CaseNumber->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_CaseNumber" id="z_CaseNumber" value="LIKE"></span></td>
		<td<?php echo $complaints->CaseNumber->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_complaints_CaseNumber">
<input type="text" data-table="complaints" data-field="x_CaseNumber" name="x_CaseNumber" id="x_CaseNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($complaints->CaseNumber->getPlaceHolder()) ?>" value="<?php echo $complaints->CaseNumber->EditValue ?>"<?php echo $complaints->CaseNumber->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($complaints->FileNumber->Visible) { // FileNumber ?>
<?php if ($complaints_search->IsMobileOrModal) { ?>
	<div id="r_FileNumber" class="form-group row">
		<label for="x_FileNumber" class="<?php echo $complaints_search->LeftColumnClass ?>"><span id="elh_complaints_FileNumber"><?php echo $complaints->FileNumber->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_FileNumber" id="z_FileNumber" value="LIKE"></span>
		</label>
		<div class="<?php echo $complaints_search->RightColumnClass ?>"><div<?php echo $complaints->FileNumber->cellAttributes() ?>>
			<span id="el_complaints_FileNumber">
<input type="text" data-table="complaints" data-field="x_FileNumber" name="x_FileNumber" id="x_FileNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($complaints->FileNumber->getPlaceHolder()) ?>" value="<?php echo $complaints->FileNumber->EditValue ?>"<?php echo $complaints->FileNumber->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_FileNumber">
		<td class="<?php echo $complaints_search->TableLeftColumnClass ?>"><span id="elh_complaints_FileNumber"><?php echo $complaints->FileNumber->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_FileNumber" id="z_FileNumber" value="LIKE"></span></td>
		<td<?php echo $complaints->FileNumber->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_complaints_FileNumber">
<input type="text" data-table="complaints" data-field="x_FileNumber" name="x_FileNumber" id="x_FileNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($complaints->FileNumber->getPlaceHolder()) ?>" value="<?php echo $complaints->FileNumber->EditValue ?>"<?php echo $complaints->FileNumber->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($complaints->ComplaintDate->Visible) { // ComplaintDate ?>
<?php if ($complaints_search->IsMobileOrModal) { ?>
	<div id="r_ComplaintDate" class="form-group row">
		<label for="x_ComplaintDate" class="<?php echo $complaints_search->LeftColumnClass ?>"><span id="elh_complaints_ComplaintDate"><?php echo $complaints->ComplaintDate->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ComplaintDate" id="z_ComplaintDate" value="="></span>
		</label>
		<div class="<?php echo $complaints_search->RightColumnClass ?>"><div<?php echo $complaints->ComplaintDate->cellAttributes() ?>>
			<span id="el_complaints_ComplaintDate">
<input type="text" data-table="complaints" data-field="x_ComplaintDate" data-format="7" name="x_ComplaintDate" id="x_ComplaintDate" placeholder="<?php echo HtmlEncode($complaints->ComplaintDate->getPlaceHolder()) ?>" value="<?php echo $complaints->ComplaintDate->EditValue ?>"<?php echo $complaints->ComplaintDate->editAttributes() ?>>
<?php if (!$complaints->ComplaintDate->ReadOnly && !$complaints->ComplaintDate->Disabled && !isset($complaints->ComplaintDate->EditAttrs["readonly"]) && !isset($complaints->ComplaintDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fcomplaintssearch", "x_ComplaintDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_ComplaintDate">
		<td class="<?php echo $complaints_search->TableLeftColumnClass ?>"><span id="elh_complaints_ComplaintDate"><?php echo $complaints->ComplaintDate->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ComplaintDate" id="z_ComplaintDate" value="="></span></td>
		<td<?php echo $complaints->ComplaintDate->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_complaints_ComplaintDate">
<input type="text" data-table="complaints" data-field="x_ComplaintDate" data-format="7" name="x_ComplaintDate" id="x_ComplaintDate" placeholder="<?php echo HtmlEncode($complaints->ComplaintDate->getPlaceHolder()) ?>" value="<?php echo $complaints->ComplaintDate->EditValue ?>"<?php echo $complaints->ComplaintDate->editAttributes() ?>>
<?php if (!$complaints->ComplaintDate->ReadOnly && !$complaints->ComplaintDate->Disabled && !isset($complaints->ComplaintDate->EditAttrs["readonly"]) && !isset($complaints->ComplaintDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fcomplaintssearch", "x_ComplaintDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($complaints->Complaint->Visible) { // Complaint ?>
<?php if ($complaints_search->IsMobileOrModal) { ?>
	<div id="r_Complaint" class="form-group row">
		<label for="x_Complaint" class="<?php echo $complaints_search->LeftColumnClass ?>"><span id="elh_complaints_Complaint"><?php echo $complaints->Complaint->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Complaint" id="z_Complaint" value="LIKE"></span>
		</label>
		<div class="<?php echo $complaints_search->RightColumnClass ?>"><div<?php echo $complaints->Complaint->cellAttributes() ?>>
			<span id="el_complaints_Complaint">
<input type="text" data-table="complaints" data-field="x_Complaint" name="x_Complaint" id="x_Complaint" size="35" maxlength="200" placeholder="<?php echo HtmlEncode($complaints->Complaint->getPlaceHolder()) ?>" value="<?php echo $complaints->Complaint->EditValue ?>"<?php echo $complaints->Complaint->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_Complaint">
		<td class="<?php echo $complaints_search->TableLeftColumnClass ?>"><span id="elh_complaints_Complaint"><?php echo $complaints->Complaint->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Complaint" id="z_Complaint" value="LIKE"></span></td>
		<td<?php echo $complaints->Complaint->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_complaints_Complaint">
<input type="text" data-table="complaints" data-field="x_Complaint" name="x_Complaint" id="x_Complaint" size="35" maxlength="200" placeholder="<?php echo HtmlEncode($complaints->Complaint->getPlaceHolder()) ?>" value="<?php echo $complaints->Complaint->EditValue ?>"<?php echo $complaints->Complaint->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($complaints->CaseID->Visible) { // CaseID ?>
<?php if ($complaints_search->IsMobileOrModal) { ?>
	<div id="r_CaseID" class="form-group row">
		<label for="x_CaseID" class="<?php echo $complaints_search->LeftColumnClass ?>"><span id="elh_complaints_CaseID"><?php echo $complaints->CaseID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CaseID" id="z_CaseID" value="="></span>
		</label>
		<div class="<?php echo $complaints_search->RightColumnClass ?>"><div<?php echo $complaints->CaseID->cellAttributes() ?>>
			<span id="el_complaints_CaseID">
<input type="text" data-table="complaints" data-field="x_CaseID" name="x_CaseID" id="x_CaseID" size="30" placeholder="<?php echo HtmlEncode($complaints->CaseID->getPlaceHolder()) ?>" value="<?php echo $complaints->CaseID->EditValue ?>"<?php echo $complaints->CaseID->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseID">
		<td class="<?php echo $complaints_search->TableLeftColumnClass ?>"><span id="elh_complaints_CaseID"><?php echo $complaints->CaseID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CaseID" id="z_CaseID" value="="></span></td>
		<td<?php echo $complaints->CaseID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_complaints_CaseID">
<input type="text" data-table="complaints" data-field="x_CaseID" name="x_CaseID" id="x_CaseID" size="30" placeholder="<?php echo HtmlEncode($complaints->CaseID->getPlaceHolder()) ?>" value="<?php echo $complaints->CaseID->EditValue ?>"<?php echo $complaints->CaseID->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($complaints->Notes->Visible) { // Notes ?>
<?php if ($complaints_search->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label class="<?php echo $complaints_search->LeftColumnClass ?>"><span id="elh_complaints_Notes"><?php echo $complaints->Notes->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Notes" id="z_Notes" value="LIKE"></span>
		</label>
		<div class="<?php echo $complaints_search->RightColumnClass ?>"><div<?php echo $complaints->Notes->cellAttributes() ?>>
			<span id="el_complaints_Notes">
<input type="text" data-table="complaints" data-field="x_Notes" name="x_Notes" id="x_Notes" size="35" placeholder="<?php echo HtmlEncode($complaints->Notes->getPlaceHolder()) ?>" value="<?php echo $complaints->Notes->EditValue ?>"<?php echo $complaints->Notes->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $complaints_search->TableLeftColumnClass ?>"><span id="elh_complaints_Notes"><?php echo $complaints->Notes->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Notes" id="z_Notes" value="LIKE"></span></td>
		<td<?php echo $complaints->Notes->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_complaints_Notes">
<input type="text" data-table="complaints" data-field="x_Notes" name="x_Notes" id="x_Notes" size="35" placeholder="<?php echo HtmlEncode($complaints->Notes->getPlaceHolder()) ?>" value="<?php echo $complaints->Notes->EditValue ?>"<?php echo $complaints->Notes->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($complaints_search->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if (!$complaints_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $complaints_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$complaints_search->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
</form>
<?php
$complaints_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$complaints_search->terminate();
?>
