<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$contacts_list = new contacts_list();

// Run the page
$contacts_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$contacts_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$contacts->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fcontactslist = currentForm = new ew.Form("fcontactslist", "list");
fcontactslist.formKeyCountName = '<?php echo $contacts_list->FormKeyCountName ?>';

// Form_CustomValidate event
fcontactslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcontactslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcontactslist.lists["x_ContactTypeID"] = <?php echo $contacts_list->ContactTypeID->Lookup->toClientList() ?>;
fcontactslist.lists["x_ContactTypeID"].options = <?php echo JsonEncode($contacts_list->ContactTypeID->lookupOptions()) ?>;
fcontactslist.lists["x_Primary[]"] = <?php echo $contacts_list->Primary->Lookup->toClientList() ?>;
fcontactslist.lists["x_Primary[]"].options = <?php echo JsonEncode($contacts_list->Primary->options(FALSE, TRUE)) ?>;

// Form object for search
var fcontactslistsrch = currentSearchForm = new ew.Form("fcontactslistsrch");

// Validate function for search
fcontactslistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fcontactslistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcontactslistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcontactslistsrch.lists["x_ContactTypeID"] = <?php echo $contacts_list->ContactTypeID->Lookup->toClientList() ?>;
fcontactslistsrch.lists["x_ContactTypeID"].options = <?php echo JsonEncode($contacts_list->ContactTypeID->lookupOptions()) ?>;
fcontactslistsrch.lists["x_Primary[]"] = <?php echo $contacts_list->Primary->Lookup->toClientList() ?>;
fcontactslistsrch.lists["x_Primary[]"].options = <?php echo JsonEncode($contacts_list->Primary->options(FALSE, TRUE)) ?>;

// Filters
fcontactslistsrch.filterList = <?php echo $contacts_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$contacts->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($contacts_list->TotalRecs > 0 && $contacts_list->ExportOptions->visible()) { ?>
<?php $contacts_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($contacts_list->ImportOptions->visible()) { ?>
<?php $contacts_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($contacts_list->SearchOptions->visible()) { ?>
<?php $contacts_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($contacts_list->FilterOptions->visible()) { ?>
<?php $contacts_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$contacts_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$contacts->isExport() && !$contacts->CurrentAction) { ?>
<form name="fcontactslistsrch" id="fcontactslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($contacts_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="fcontactslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="contacts">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$contacts_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$contacts->RowType = ROWTYPE_SEARCH;

// Render row
$contacts->resetAttributes();
$contacts_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($contacts->ContactTypeID->Visible) { // ContactTypeID ?>
	<div id="xsc_ContactTypeID" class="ew-cell form-group">
		<label for="x_ContactTypeID" class="ew-search-caption ew-label"><?php echo $contacts->ContactTypeID->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ContactTypeID" id="z_ContactTypeID" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="contacts" data-field="x_ContactTypeID" data-value-separator="<?php echo $contacts->ContactTypeID->displayValueSeparatorAttribute() ?>" id="x_ContactTypeID" name="x_ContactTypeID"<?php echo $contacts->ContactTypeID->editAttributes() ?>>
		<?php echo $contacts->ContactTypeID->selectOptionListHtml("x_ContactTypeID") ?>
	</select>
</div>
<?php echo $contacts->ContactTypeID->Lookup->getParamTag("p_x_ContactTypeID") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($contacts->Primary->Visible) { // Primary ?>
	<div id="xsc_Primary" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $contacts->Primary->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Primary" id="z_Primary" value="="></span>
		<span class="ew-search-field">
<?php
$selwrk = (ConvertToBool($contacts->Primary->AdvancedSearch->SearchValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="contacts" data-field="x_Primary" name="x_Primary[]" id="x_Primary[]" value="1"<?php echo $selwrk ?><?php echo $contacts->Primary->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($contacts_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($contacts_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $contacts_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($contacts_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($contacts_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($contacts_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($contacts_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $contacts_list->showPageHeader(); ?>
<?php
$contacts_list->showMessage();
?>
<?php if ($contacts_list->TotalRecs > 0 || $contacts->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($contacts_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> contacts">
<?php if (!$contacts->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$contacts->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($contacts_list->Pager)) $contacts_list->Pager = new PrevNextPager($contacts_list->StartRec, $contacts_list->DisplayRecs, $contacts_list->TotalRecs, $contacts_list->AutoHidePager) ?>
<?php if ($contacts_list->Pager->RecordCount > 0 && $contacts_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($contacts_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $contacts_list->pageUrl() ?>start=<?php echo $contacts_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($contacts_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $contacts_list->pageUrl() ?>start=<?php echo $contacts_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $contacts_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($contacts_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $contacts_list->pageUrl() ?>start=<?php echo $contacts_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($contacts_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $contacts_list->pageUrl() ?>start=<?php echo $contacts_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $contacts_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($contacts_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $contacts_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $contacts_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $contacts_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($contacts_list->TotalRecs > 0 && (!$contacts_list->AutoHidePageSizeSelector || $contacts_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="contacts">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($contacts_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($contacts_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($contacts_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($contacts_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($contacts_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($contacts_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($contacts_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($contacts_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($contacts_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($contacts->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $contacts_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fcontactslist" id="fcontactslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($contacts_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $contacts_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="contacts">
<div id="gmp_contacts" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($contacts_list->TotalRecs > 0 || $contacts->isGridEdit()) { ?>
<table id="tbl_contactslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$contacts_list->RowType = ROWTYPE_HEADER;

// Render list options
$contacts_list->renderListOptions();

// Render list options (header, left)
$contacts_list->ListOptions->render("header", "left");
?>
<?php if ($contacts->ContactTypeID->Visible) { // ContactTypeID ?>
	<?php if ($contacts->sortUrl($contacts->ContactTypeID) == "") { ?>
		<th data-name="ContactTypeID" class="<?php echo $contacts->ContactTypeID->headerCellClass() ?>"><div id="elh_contacts_ContactTypeID" class="contacts_ContactTypeID"><div class="ew-table-header-caption"><?php echo $contacts->ContactTypeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ContactTypeID" class="<?php echo $contacts->ContactTypeID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $contacts->SortUrl($contacts->ContactTypeID) ?>',2);"><div id="elh_contacts_ContactTypeID" class="contacts_ContactTypeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $contacts->ContactTypeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($contacts->ContactTypeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($contacts->ContactTypeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($contacts->Contact->Visible) { // Contact ?>
	<?php if ($contacts->sortUrl($contacts->Contact) == "") { ?>
		<th data-name="Contact" class="<?php echo $contacts->Contact->headerCellClass() ?>"><div id="elh_contacts_Contact" class="contacts_Contact"><div class="ew-table-header-caption"><?php echo $contacts->Contact->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Contact" class="<?php echo $contacts->Contact->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $contacts->SortUrl($contacts->Contact) ?>',2);"><div id="elh_contacts_Contact" class="contacts_Contact">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $contacts->Contact->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($contacts->Contact->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($contacts->Contact->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($contacts->Notes->Visible) { // Notes ?>
	<?php if ($contacts->sortUrl($contacts->Notes) == "") { ?>
		<th data-name="Notes" class="<?php echo $contacts->Notes->headerCellClass() ?>"><div id="elh_contacts_Notes" class="contacts_Notes"><div class="ew-table-header-caption"><?php echo $contacts->Notes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Notes" class="<?php echo $contacts->Notes->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $contacts->SortUrl($contacts->Notes) ?>',2);"><div id="elh_contacts_Notes" class="contacts_Notes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $contacts->Notes->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($contacts->Notes->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($contacts->Notes->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($contacts->Primary->Visible) { // Primary ?>
	<?php if ($contacts->sortUrl($contacts->Primary) == "") { ?>
		<th data-name="Primary" class="<?php echo $contacts->Primary->headerCellClass() ?>"><div id="elh_contacts_Primary" class="contacts_Primary"><div class="ew-table-header-caption"><?php echo $contacts->Primary->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Primary" class="<?php echo $contacts->Primary->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $contacts->SortUrl($contacts->Primary) ?>',2);"><div id="elh_contacts_Primary" class="contacts_Primary">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $contacts->Primary->caption() ?></span><span class="ew-table-header-sort"><?php if ($contacts->Primary->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($contacts->Primary->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$contacts_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($contacts->ExportAll && $contacts->isExport()) {
	$contacts_list->StopRec = $contacts_list->TotalRecs;
} else {

	// Set the last record to display
	if ($contacts_list->TotalRecs > $contacts_list->StartRec + $contacts_list->DisplayRecs - 1)
		$contacts_list->StopRec = $contacts_list->StartRec + $contacts_list->DisplayRecs - 1;
	else
		$contacts_list->StopRec = $contacts_list->TotalRecs;
}
$contacts_list->RecCnt = $contacts_list->StartRec - 1;
if ($contacts_list->Recordset && !$contacts_list->Recordset->EOF) {
	$contacts_list->Recordset->moveFirst();
	$selectLimit = $contacts_list->UseSelectLimit;
	if (!$selectLimit && $contacts_list->StartRec > 1)
		$contacts_list->Recordset->move($contacts_list->StartRec - 1);
} elseif (!$contacts->AllowAddDeleteRow && $contacts_list->StopRec == 0) {
	$contacts_list->StopRec = $contacts->GridAddRowCount;
}

// Initialize aggregate
$contacts->RowType = ROWTYPE_AGGREGATEINIT;
$contacts->resetAttributes();
$contacts_list->renderRow();
while ($contacts_list->RecCnt < $contacts_list->StopRec) {
	$contacts_list->RecCnt++;
	if ($contacts_list->RecCnt >= $contacts_list->StartRec) {
		$contacts_list->RowCnt++;

		// Set up key count
		$contacts_list->KeyCount = $contacts_list->RowIndex;

		// Init row class and style
		$contacts->resetAttributes();
		$contacts->CssClass = "";
		if ($contacts->isGridAdd()) {
		} else {
			$contacts_list->loadRowValues($contacts_list->Recordset); // Load row values
		}
		$contacts->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$contacts->RowAttrs = array_merge($contacts->RowAttrs, array('data-rowindex'=>$contacts_list->RowCnt, 'id'=>'r' . $contacts_list->RowCnt . '_contacts', 'data-rowtype'=>$contacts->RowType));

		// Render row
		$contacts_list->renderRow();

		// Render list options
		$contacts_list->renderListOptions();
?>
	<tr<?php echo $contacts->rowAttributes() ?>>
<?php

// Render list options (body, left)
$contacts_list->ListOptions->render("body", "left", $contacts_list->RowCnt);
?>
	<?php if ($contacts->ContactTypeID->Visible) { // ContactTypeID ?>
		<td data-name="ContactTypeID"<?php echo $contacts->ContactTypeID->cellAttributes() ?>>
<span id="el<?php echo $contacts_list->RowCnt ?>_contacts_ContactTypeID" class="contacts_ContactTypeID">
<span<?php echo $contacts->ContactTypeID->viewAttributes() ?>>
<?php echo $contacts->ContactTypeID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($contacts->Contact->Visible) { // Contact ?>
		<td data-name="Contact"<?php echo $contacts->Contact->cellAttributes() ?>>
<span id="el<?php echo $contacts_list->RowCnt ?>_contacts_Contact" class="contacts_Contact">
<span<?php echo $contacts->Contact->viewAttributes() ?>>
<?php echo $contacts->Contact->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($contacts->Notes->Visible) { // Notes ?>
		<td data-name="Notes"<?php echo $contacts->Notes->cellAttributes() ?>>
<span id="el<?php echo $contacts_list->RowCnt ?>_contacts_Notes" class="contacts_Notes">
<span<?php echo $contacts->Notes->viewAttributes() ?>>
<?php echo $contacts->Notes->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($contacts->Primary->Visible) { // Primary ?>
		<td data-name="Primary"<?php echo $contacts->Primary->cellAttributes() ?>>
<span id="el<?php echo $contacts_list->RowCnt ?>_contacts_Primary" class="contacts_Primary">
<span<?php echo $contacts->Primary->viewAttributes() ?>>
<?php if (ConvertToBool($contacts->Primary->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $contacts->Primary->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $contacts->Primary->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$contacts_list->ListOptions->render("body", "right", $contacts_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$contacts->isGridAdd())
		$contacts_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$contacts->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($contacts_list->Recordset)
	$contacts_list->Recordset->Close();
?>
<?php if (!$contacts->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$contacts->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($contacts_list->Pager)) $contacts_list->Pager = new PrevNextPager($contacts_list->StartRec, $contacts_list->DisplayRecs, $contacts_list->TotalRecs, $contacts_list->AutoHidePager) ?>
<?php if ($contacts_list->Pager->RecordCount > 0 && $contacts_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($contacts_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $contacts_list->pageUrl() ?>start=<?php echo $contacts_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($contacts_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $contacts_list->pageUrl() ?>start=<?php echo $contacts_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $contacts_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($contacts_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $contacts_list->pageUrl() ?>start=<?php echo $contacts_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($contacts_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $contacts_list->pageUrl() ?>start=<?php echo $contacts_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $contacts_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($contacts_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $contacts_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $contacts_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $contacts_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($contacts_list->TotalRecs > 0 && (!$contacts_list->AutoHidePageSizeSelector || $contacts_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="contacts">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($contacts_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($contacts_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($contacts_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($contacts_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($contacts_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($contacts_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($contacts_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($contacts_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($contacts_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($contacts->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $contacts_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($contacts_list->TotalRecs == 0 && !$contacts->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $contacts_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$contacts_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$contacts->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$contacts->isExport()) { ?>
<script>
ew.scrollableTable("gmp_contacts", "", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$contacts_list->terminate();
?>
