<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$contacts_view = new contacts_view();

// Run the page
$contacts_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$contacts_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$contacts->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fcontactsview = currentForm = new ew.Form("fcontactsview", "view");

// Form_CustomValidate event
fcontactsview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcontactsview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcontactsview.lists["x_ContactTypeID"] = <?php echo $contacts_view->ContactTypeID->Lookup->toClientList() ?>;
fcontactsview.lists["x_ContactTypeID"].options = <?php echo JsonEncode($contacts_view->ContactTypeID->lookupOptions()) ?>;
fcontactsview.lists["x_Primary[]"] = <?php echo $contacts_view->Primary->Lookup->toClientList() ?>;
fcontactsview.lists["x_Primary[]"].options = <?php echo JsonEncode($contacts_view->Primary->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$contacts->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $contacts_view->ExportOptions->render("body") ?>
<?php $contacts_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $contacts_view->showPageHeader(); ?>
<?php
$contacts_view->showMessage();
?>
<?php if (!$contacts_view->IsModal) { ?>
<?php if (!$contacts->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($contacts_view->Pager)) $contacts_view->Pager = new PrevNextPager($contacts_view->StartRec, $contacts_view->DisplayRecs, $contacts_view->TotalRecs, $contacts_view->AutoHidePager) ?>
<?php if ($contacts_view->Pager->RecordCount > 0 && $contacts_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($contacts_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $contacts_view->pageUrl() ?>start=<?php echo $contacts_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($contacts_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $contacts_view->pageUrl() ?>start=<?php echo $contacts_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $contacts_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($contacts_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $contacts_view->pageUrl() ?>start=<?php echo $contacts_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($contacts_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $contacts_view->pageUrl() ?>start=<?php echo $contacts_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $contacts_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="fcontactsview" id="fcontactsview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($contacts_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $contacts_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="contacts">
<input type="hidden" name="modal" value="<?php echo (int)$contacts_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($contacts->ContactID->Visible) { // ContactID ?>
	<tr id="r_ContactID">
		<td class="<?php echo $contacts_view->TableLeftColumnClass ?>"><span id="elh_contacts_ContactID"><?php echo $contacts->ContactID->caption() ?></span></td>
		<td data-name="ContactID"<?php echo $contacts->ContactID->cellAttributes() ?>>
<span id="el_contacts_ContactID">
<span<?php echo $contacts->ContactID->viewAttributes() ?>>
<?php echo $contacts->ContactID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($contacts->ContactTypeID->Visible) { // ContactTypeID ?>
	<tr id="r_ContactTypeID">
		<td class="<?php echo $contacts_view->TableLeftColumnClass ?>"><span id="elh_contacts_ContactTypeID"><?php echo $contacts->ContactTypeID->caption() ?></span></td>
		<td data-name="ContactTypeID"<?php echo $contacts->ContactTypeID->cellAttributes() ?>>
<span id="el_contacts_ContactTypeID">
<span<?php echo $contacts->ContactTypeID->viewAttributes() ?>>
<?php echo $contacts->ContactTypeID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($contacts->Contact->Visible) { // Contact ?>
	<tr id="r_Contact">
		<td class="<?php echo $contacts_view->TableLeftColumnClass ?>"><span id="elh_contacts_Contact"><?php echo $contacts->Contact->caption() ?></span></td>
		<td data-name="Contact"<?php echo $contacts->Contact->cellAttributes() ?>>
<span id="el_contacts_Contact">
<span<?php echo $contacts->Contact->viewAttributes() ?>>
<?php echo $contacts->Contact->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($contacts->Notes->Visible) { // Notes ?>
	<tr id="r_Notes">
		<td class="<?php echo $contacts_view->TableLeftColumnClass ?>"><span id="elh_contacts_Notes"><?php echo $contacts->Notes->caption() ?></span></td>
		<td data-name="Notes"<?php echo $contacts->Notes->cellAttributes() ?>>
<span id="el_contacts_Notes">
<span<?php echo $contacts->Notes->viewAttributes() ?>>
<?php echo $contacts->Notes->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($contacts->Primary->Visible) { // Primary ?>
	<tr id="r_Primary">
		<td class="<?php echo $contacts_view->TableLeftColumnClass ?>"><span id="elh_contacts_Primary"><?php echo $contacts->Primary->caption() ?></span></td>
		<td data-name="Primary"<?php echo $contacts->Primary->cellAttributes() ?>>
<span id="el_contacts_Primary">
<span<?php echo $contacts->Primary->viewAttributes() ?>>
<?php if (ConvertToBool($contacts->Primary->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $contacts->Primary->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $contacts->Primary->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$contacts_view->IsModal) { ?>
<?php if (!$contacts->isExport()) { ?>
<?php if (!isset($contacts_view->Pager)) $contacts_view->Pager = new PrevNextPager($contacts_view->StartRec, $contacts_view->DisplayRecs, $contacts_view->TotalRecs, $contacts_view->AutoHidePager) ?>
<?php if ($contacts_view->Pager->RecordCount > 0 && $contacts_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($contacts_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $contacts_view->pageUrl() ?>start=<?php echo $contacts_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($contacts_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $contacts_view->pageUrl() ?>start=<?php echo $contacts_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $contacts_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($contacts_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $contacts_view->pageUrl() ?>start=<?php echo $contacts_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($contacts_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $contacts_view->pageUrl() ?>start=<?php echo $contacts_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $contacts_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
</form>
<?php
$contacts_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$contacts->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$contacts_view->terminate();
?>
