<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$courtcontact_list = new courtcontact_list();

// Run the page
$courtcontact_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$courtcontact_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$courtcontact->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fcourtcontactlist = currentForm = new ew.Form("fcourtcontactlist", "list");
fcourtcontactlist.formKeyCountName = '<?php echo $courtcontact_list->FormKeyCountName ?>';

// Form_CustomValidate event
fcourtcontactlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcourtcontactlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcourtcontactlist.lists["x_CourtID"] = <?php echo $courtcontact_list->CourtID->Lookup->toClientList() ?>;
fcourtcontactlist.lists["x_CourtID"].options = <?php echo JsonEncode($courtcontact_list->CourtID->lookupOptions()) ?>;
fcourtcontactlist.lists["x_ContactTypeID"] = <?php echo $courtcontact_list->ContactTypeID->Lookup->toClientList() ?>;
fcourtcontactlist.lists["x_ContactTypeID"].options = <?php echo JsonEncode($courtcontact_list->ContactTypeID->lookupOptions()) ?>;
fcourtcontactlist.lists["x_Primary[]"] = <?php echo $courtcontact_list->Primary->Lookup->toClientList() ?>;
fcourtcontactlist.lists["x_Primary[]"].options = <?php echo JsonEncode($courtcontact_list->Primary->options(FALSE, TRUE)) ?>;

// Form object for search
var fcourtcontactlistsrch = currentSearchForm = new ew.Form("fcourtcontactlistsrch");

// Validate function for search
fcourtcontactlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fcourtcontactlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcourtcontactlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcourtcontactlistsrch.lists["x_Primary[]"] = <?php echo $courtcontact_list->Primary->Lookup->toClientList() ?>;
fcourtcontactlistsrch.lists["x_Primary[]"].options = <?php echo JsonEncode($courtcontact_list->Primary->options(FALSE, TRUE)) ?>;

// Filters
fcourtcontactlistsrch.filterList = <?php echo $courtcontact_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$courtcontact->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($courtcontact_list->TotalRecs > 0 && $courtcontact_list->ExportOptions->visible()) { ?>
<?php $courtcontact_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($courtcontact_list->ImportOptions->visible()) { ?>
<?php $courtcontact_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($courtcontact_list->SearchOptions->visible()) { ?>
<?php $courtcontact_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($courtcontact_list->FilterOptions->visible()) { ?>
<?php $courtcontact_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$courtcontact->isExport() || EXPORT_MASTER_RECORD && $courtcontact->isExport("print")) { ?>
<?php
if ($courtcontact_list->DbMasterFilter <> "" && $courtcontact->getCurrentMasterTable() == "courts") {
	if ($courtcontact_list->MasterRecordExists) {
		include_once "courtsmaster.php";
	}
}
?>
<?php } ?>
<?php
$courtcontact_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$courtcontact->isExport() && !$courtcontact->CurrentAction) { ?>
<form name="fcourtcontactlistsrch" id="fcourtcontactlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($courtcontact_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="fcourtcontactlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="courtcontact">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$courtcontact_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$courtcontact->RowType = ROWTYPE_SEARCH;

// Render row
$courtcontact->resetAttributes();
$courtcontact_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($courtcontact->Primary->Visible) { // Primary ?>
	<div id="xsc_Primary" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $courtcontact->Primary->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Primary" id="z_Primary" value="="></span>
		<span class="ew-search-field">
<?php
$selwrk = (ConvertToBool($courtcontact->Primary->AdvancedSearch->SearchValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="courtcontact" data-field="x_Primary" name="x_Primary[]" id="x_Primary[]" value="1"<?php echo $selwrk ?><?php echo $courtcontact->Primary->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($courtcontact_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($courtcontact_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $courtcontact_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($courtcontact_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($courtcontact_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($courtcontact_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($courtcontact_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $courtcontact_list->showPageHeader(); ?>
<?php
$courtcontact_list->showMessage();
?>
<?php if ($courtcontact_list->TotalRecs > 0 || $courtcontact->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($courtcontact_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> courtcontact">
<?php if (!$courtcontact->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$courtcontact->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($courtcontact_list->Pager)) $courtcontact_list->Pager = new PrevNextPager($courtcontact_list->StartRec, $courtcontact_list->DisplayRecs, $courtcontact_list->TotalRecs, $courtcontact_list->AutoHidePager) ?>
<?php if ($courtcontact_list->Pager->RecordCount > 0 && $courtcontact_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($courtcontact_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $courtcontact_list->pageUrl() ?>start=<?php echo $courtcontact_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($courtcontact_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $courtcontact_list->pageUrl() ?>start=<?php echo $courtcontact_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $courtcontact_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($courtcontact_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $courtcontact_list->pageUrl() ?>start=<?php echo $courtcontact_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($courtcontact_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $courtcontact_list->pageUrl() ?>start=<?php echo $courtcontact_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $courtcontact_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($courtcontact_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $courtcontact_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $courtcontact_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $courtcontact_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($courtcontact_list->TotalRecs > 0 && (!$courtcontact_list->AutoHidePageSizeSelector || $courtcontact_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="courtcontact">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($courtcontact_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($courtcontact_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($courtcontact_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($courtcontact_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($courtcontact_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($courtcontact_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($courtcontact_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($courtcontact_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($courtcontact_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($courtcontact->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $courtcontact_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fcourtcontactlist" id="fcourtcontactlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($courtcontact_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $courtcontact_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="courtcontact">
<?php if ($courtcontact->getCurrentMasterTable() == "courts" && $courtcontact->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="courts">
<input type="hidden" name="fk_CourtID" value="<?php echo $courtcontact->CourtID->getSessionValue() ?>">
<?php } ?>
<div id="gmp_courtcontact" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($courtcontact_list->TotalRecs > 0 || $courtcontact->isGridEdit()) { ?>
<table id="tbl_courtcontactlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$courtcontact_list->RowType = ROWTYPE_HEADER;

// Render list options
$courtcontact_list->renderListOptions();

// Render list options (header, left)
$courtcontact_list->ListOptions->render("header", "left");
?>
<?php if ($courtcontact->CourtID->Visible) { // CourtID ?>
	<?php if ($courtcontact->sortUrl($courtcontact->CourtID) == "") { ?>
		<th data-name="CourtID" class="<?php echo $courtcontact->CourtID->headerCellClass() ?>"><div id="elh_courtcontact_CourtID" class="courtcontact_CourtID"><div class="ew-table-header-caption"><?php echo $courtcontact->CourtID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CourtID" class="<?php echo $courtcontact->CourtID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtcontact->SortUrl($courtcontact->CourtID) ?>',2);"><div id="elh_courtcontact_CourtID" class="courtcontact_CourtID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtcontact->CourtID->caption() ?></span><span class="ew-table-header-sort"><?php if ($courtcontact->CourtID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtcontact->CourtID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtcontact->ContactTypeID->Visible) { // ContactTypeID ?>
	<?php if ($courtcontact->sortUrl($courtcontact->ContactTypeID) == "") { ?>
		<th data-name="ContactTypeID" class="<?php echo $courtcontact->ContactTypeID->headerCellClass() ?>"><div id="elh_courtcontact_ContactTypeID" class="courtcontact_ContactTypeID"><div class="ew-table-header-caption"><?php echo $courtcontact->ContactTypeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ContactTypeID" class="<?php echo $courtcontact->ContactTypeID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtcontact->SortUrl($courtcontact->ContactTypeID) ?>',2);"><div id="elh_courtcontact_ContactTypeID" class="courtcontact_ContactTypeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtcontact->ContactTypeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($courtcontact->ContactTypeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtcontact->ContactTypeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtcontact->Contact->Visible) { // Contact ?>
	<?php if ($courtcontact->sortUrl($courtcontact->Contact) == "") { ?>
		<th data-name="Contact" class="<?php echo $courtcontact->Contact->headerCellClass() ?>"><div id="elh_courtcontact_Contact" class="courtcontact_Contact"><div class="ew-table-header-caption"><?php echo $courtcontact->Contact->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Contact" class="<?php echo $courtcontact->Contact->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtcontact->SortUrl($courtcontact->Contact) ?>',2);"><div id="elh_courtcontact_Contact" class="courtcontact_Contact">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtcontact->Contact->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($courtcontact->Contact->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtcontact->Contact->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtcontact->Notes->Visible) { // Notes ?>
	<?php if ($courtcontact->sortUrl($courtcontact->Notes) == "") { ?>
		<th data-name="Notes" class="<?php echo $courtcontact->Notes->headerCellClass() ?>"><div id="elh_courtcontact_Notes" class="courtcontact_Notes"><div class="ew-table-header-caption"><?php echo $courtcontact->Notes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Notes" class="<?php echo $courtcontact->Notes->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtcontact->SortUrl($courtcontact->Notes) ?>',2);"><div id="elh_courtcontact_Notes" class="courtcontact_Notes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtcontact->Notes->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($courtcontact->Notes->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtcontact->Notes->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($courtcontact->Primary->Visible) { // Primary ?>
	<?php if ($courtcontact->sortUrl($courtcontact->Primary) == "") { ?>
		<th data-name="Primary" class="<?php echo $courtcontact->Primary->headerCellClass() ?>"><div id="elh_courtcontact_Primary" class="courtcontact_Primary"><div class="ew-table-header-caption"><?php echo $courtcontact->Primary->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Primary" class="<?php echo $courtcontact->Primary->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $courtcontact->SortUrl($courtcontact->Primary) ?>',2);"><div id="elh_courtcontact_Primary" class="courtcontact_Primary">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $courtcontact->Primary->caption() ?></span><span class="ew-table-header-sort"><?php if ($courtcontact->Primary->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($courtcontact->Primary->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$courtcontact_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($courtcontact->ExportAll && $courtcontact->isExport()) {
	$courtcontact_list->StopRec = $courtcontact_list->TotalRecs;
} else {

	// Set the last record to display
	if ($courtcontact_list->TotalRecs > $courtcontact_list->StartRec + $courtcontact_list->DisplayRecs - 1)
		$courtcontact_list->StopRec = $courtcontact_list->StartRec + $courtcontact_list->DisplayRecs - 1;
	else
		$courtcontact_list->StopRec = $courtcontact_list->TotalRecs;
}
$courtcontact_list->RecCnt = $courtcontact_list->StartRec - 1;
if ($courtcontact_list->Recordset && !$courtcontact_list->Recordset->EOF) {
	$courtcontact_list->Recordset->moveFirst();
	$selectLimit = $courtcontact_list->UseSelectLimit;
	if (!$selectLimit && $courtcontact_list->StartRec > 1)
		$courtcontact_list->Recordset->move($courtcontact_list->StartRec - 1);
} elseif (!$courtcontact->AllowAddDeleteRow && $courtcontact_list->StopRec == 0) {
	$courtcontact_list->StopRec = $courtcontact->GridAddRowCount;
}

// Initialize aggregate
$courtcontact->RowType = ROWTYPE_AGGREGATEINIT;
$courtcontact->resetAttributes();
$courtcontact_list->renderRow();
while ($courtcontact_list->RecCnt < $courtcontact_list->StopRec) {
	$courtcontact_list->RecCnt++;
	if ($courtcontact_list->RecCnt >= $courtcontact_list->StartRec) {
		$courtcontact_list->RowCnt++;

		// Set up key count
		$courtcontact_list->KeyCount = $courtcontact_list->RowIndex;

		// Init row class and style
		$courtcontact->resetAttributes();
		$courtcontact->CssClass = "";
		if ($courtcontact->isGridAdd()) {
		} else {
			$courtcontact_list->loadRowValues($courtcontact_list->Recordset); // Load row values
		}
		$courtcontact->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$courtcontact->RowAttrs = array_merge($courtcontact->RowAttrs, array('data-rowindex'=>$courtcontact_list->RowCnt, 'id'=>'r' . $courtcontact_list->RowCnt . '_courtcontact', 'data-rowtype'=>$courtcontact->RowType));

		// Render row
		$courtcontact_list->renderRow();

		// Render list options
		$courtcontact_list->renderListOptions();
?>
	<tr<?php echo $courtcontact->rowAttributes() ?>>
<?php

// Render list options (body, left)
$courtcontact_list->ListOptions->render("body", "left", $courtcontact_list->RowCnt);
?>
	<?php if ($courtcontact->CourtID->Visible) { // CourtID ?>
		<td data-name="CourtID"<?php echo $courtcontact->CourtID->cellAttributes() ?>>
<span id="el<?php echo $courtcontact_list->RowCnt ?>_courtcontact_CourtID" class="courtcontact_CourtID">
<span<?php echo $courtcontact->CourtID->viewAttributes() ?>>
<?php echo $courtcontact->CourtID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtcontact->ContactTypeID->Visible) { // ContactTypeID ?>
		<td data-name="ContactTypeID"<?php echo $courtcontact->ContactTypeID->cellAttributes() ?>>
<span id="el<?php echo $courtcontact_list->RowCnt ?>_courtcontact_ContactTypeID" class="courtcontact_ContactTypeID">
<span<?php echo $courtcontact->ContactTypeID->viewAttributes() ?>>
<?php echo $courtcontact->ContactTypeID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtcontact->Contact->Visible) { // Contact ?>
		<td data-name="Contact"<?php echo $courtcontact->Contact->cellAttributes() ?>>
<span id="el<?php echo $courtcontact_list->RowCnt ?>_courtcontact_Contact" class="courtcontact_Contact">
<span<?php echo $courtcontact->Contact->viewAttributes() ?>>
<?php echo $courtcontact->Contact->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtcontact->Notes->Visible) { // Notes ?>
		<td data-name="Notes"<?php echo $courtcontact->Notes->cellAttributes() ?>>
<span id="el<?php echo $courtcontact_list->RowCnt ?>_courtcontact_Notes" class="courtcontact_Notes">
<span<?php echo $courtcontact->Notes->viewAttributes() ?>>
<?php echo $courtcontact->Notes->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($courtcontact->Primary->Visible) { // Primary ?>
		<td data-name="Primary"<?php echo $courtcontact->Primary->cellAttributes() ?>>
<span id="el<?php echo $courtcontact_list->RowCnt ?>_courtcontact_Primary" class="courtcontact_Primary">
<span<?php echo $courtcontact->Primary->viewAttributes() ?>>
<?php if (ConvertToBool($courtcontact->Primary->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $courtcontact->Primary->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $courtcontact->Primary->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$courtcontact_list->ListOptions->render("body", "right", $courtcontact_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$courtcontact->isGridAdd())
		$courtcontact_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$courtcontact->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($courtcontact_list->Recordset)
	$courtcontact_list->Recordset->Close();
?>
<?php if (!$courtcontact->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$courtcontact->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($courtcontact_list->Pager)) $courtcontact_list->Pager = new PrevNextPager($courtcontact_list->StartRec, $courtcontact_list->DisplayRecs, $courtcontact_list->TotalRecs, $courtcontact_list->AutoHidePager) ?>
<?php if ($courtcontact_list->Pager->RecordCount > 0 && $courtcontact_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($courtcontact_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $courtcontact_list->pageUrl() ?>start=<?php echo $courtcontact_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($courtcontact_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $courtcontact_list->pageUrl() ?>start=<?php echo $courtcontact_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $courtcontact_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($courtcontact_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $courtcontact_list->pageUrl() ?>start=<?php echo $courtcontact_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($courtcontact_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $courtcontact_list->pageUrl() ?>start=<?php echo $courtcontact_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $courtcontact_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($courtcontact_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $courtcontact_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $courtcontact_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $courtcontact_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($courtcontact_list->TotalRecs > 0 && (!$courtcontact_list->AutoHidePageSizeSelector || $courtcontact_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="courtcontact">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($courtcontact_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($courtcontact_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($courtcontact_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($courtcontact_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($courtcontact_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($courtcontact_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($courtcontact_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($courtcontact_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($courtcontact_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($courtcontact->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $courtcontact_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($courtcontact_list->TotalRecs == 0 && !$courtcontact->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $courtcontact_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$courtcontact_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$courtcontact->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$courtcontact->isExport()) { ?>
<script>
ew.scrollableTable("gmp_courtcontact", "", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$courtcontact_list->terminate();
?>
