<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$courts_search = new courts_search();

// Run the page
$courts_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$courts_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($courts_search->IsModal) { ?>
var fcourtssearch = currentAdvancedSearchForm = new ew.Form("fcourtssearch", "search");
<?php } else { ?>
var fcourtssearch = currentForm = new ew.Form("fcourtssearch", "search");
<?php } ?>

// Form_CustomValidate event
fcourtssearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcourtssearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcourtssearch.lists["x_CourtTypeID"] = <?php echo $courts_search->CourtTypeID->Lookup->toClientList() ?>;
fcourtssearch.lists["x_CourtTypeID"].options = <?php echo JsonEncode($courts_search->CourtTypeID->lookupOptions()) ?>;
fcourtssearch.lists["x_ChamberID"] = <?php echo $courts_search->ChamberID->Lookup->toClientList() ?>;
fcourtssearch.lists["x_ChamberID"].options = <?php echo JsonEncode($courts_search->ChamberID->lookupOptions()) ?>;
fcourtssearch.lists["x_CourtLocationID"] = <?php echo $courts_search->CourtLocationID->Lookup->toClientList() ?>;
fcourtssearch.lists["x_CourtLocationID"].options = <?php echo JsonEncode($courts_search->CourtLocationID->lookupOptions()) ?>;
fcourtssearch.lists["x_GovernorateID"] = <?php echo $courts_search->GovernorateID->Lookup->toClientList() ?>;
fcourtssearch.lists["x_GovernorateID"].options = <?php echo JsonEncode($courts_search->GovernorateID->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fcourtssearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $courts_search->showPageHeader(); ?>
<?php
$courts_search->showMessage();
?>
<form name="fcourtssearch" id="fcourtssearch" class="<?php echo $courts_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($courts_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $courts_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="courts">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$courts_search->IsModal ?>">
<?php if (!$courts_search->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($courts_search->IsMobileOrModal) { ?>
<div class="ew-search-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_courtssearch" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($courts->Court->Visible) { // Court ?>
<?php if ($courts_search->IsMobileOrModal) { ?>
	<div id="r_Court" class="form-group row">
		<label for="x_Court" class="<?php echo $courts_search->LeftColumnClass ?>"><span id="elh_courts_Court"><?php echo $courts->Court->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Court" id="z_Court" value="LIKE"></span>
		</label>
		<div class="<?php echo $courts_search->RightColumnClass ?>"><div<?php echo $courts->Court->cellAttributes() ?>>
			<span id="el_courts_Court">
<input type="text" data-table="courts" data-field="x_Court" name="x_Court" id="x_Court" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($courts->Court->getPlaceHolder()) ?>" value="<?php echo $courts->Court->EditValue ?>"<?php echo $courts->Court->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_Court">
		<td class="<?php echo $courts_search->TableLeftColumnClass ?>"><span id="elh_courts_Court"><?php echo $courts->Court->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Court" id="z_Court" value="LIKE"></span></td>
		<td<?php echo $courts->Court->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_courts_Court">
<input type="text" data-table="courts" data-field="x_Court" name="x_Court" id="x_Court" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($courts->Court->getPlaceHolder()) ?>" value="<?php echo $courts->Court->EditValue ?>"<?php echo $courts->Court->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($courts->CourtTypeID->Visible) { // CourtTypeID ?>
<?php if ($courts_search->IsMobileOrModal) { ?>
	<div id="r_CourtTypeID" class="form-group row">
		<label for="x_CourtTypeID" class="<?php echo $courts_search->LeftColumnClass ?>"><span id="elh_courts_CourtTypeID"><?php echo $courts->CourtTypeID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CourtTypeID" id="z_CourtTypeID" value="="></span>
		</label>
		<div class="<?php echo $courts_search->RightColumnClass ?>"><div<?php echo $courts->CourtTypeID->cellAttributes() ?>>
			<span id="el_courts_CourtTypeID">
<input type="text" data-table="courts" data-field="x_CourtTypeID" name="x_CourtTypeID" id="x_CourtTypeID" size="30" placeholder="<?php echo HtmlEncode($courts->CourtTypeID->getPlaceHolder()) ?>" value="<?php echo $courts->CourtTypeID->EditValue ?>"<?php echo $courts->CourtTypeID->editAttributes() ?>>
<?php echo $courts->CourtTypeID->Lookup->getParamTag("p_x_CourtTypeID") ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_CourtTypeID">
		<td class="<?php echo $courts_search->TableLeftColumnClass ?>"><span id="elh_courts_CourtTypeID"><?php echo $courts->CourtTypeID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CourtTypeID" id="z_CourtTypeID" value="="></span></td>
		<td<?php echo $courts->CourtTypeID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_courts_CourtTypeID">
<input type="text" data-table="courts" data-field="x_CourtTypeID" name="x_CourtTypeID" id="x_CourtTypeID" size="30" placeholder="<?php echo HtmlEncode($courts->CourtTypeID->getPlaceHolder()) ?>" value="<?php echo $courts->CourtTypeID->EditValue ?>"<?php echo $courts->CourtTypeID->editAttributes() ?>>
<?php echo $courts->CourtTypeID->Lookup->getParamTag("p_x_CourtTypeID") ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($courts->ChamberID->Visible) { // ChamberID ?>
<?php if ($courts_search->IsMobileOrModal) { ?>
	<div id="r_ChamberID" class="form-group row">
		<label for="x_ChamberID" class="<?php echo $courts_search->LeftColumnClass ?>"><span id="elh_courts_ChamberID"><?php echo $courts->ChamberID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ChamberID" id="z_ChamberID" value="="></span>
		</label>
		<div class="<?php echo $courts_search->RightColumnClass ?>"><div<?php echo $courts->ChamberID->cellAttributes() ?>>
			<span id="el_courts_ChamberID">
<input type="text" data-table="courts" data-field="x_ChamberID" name="x_ChamberID" id="x_ChamberID" size="30" placeholder="<?php echo HtmlEncode($courts->ChamberID->getPlaceHolder()) ?>" value="<?php echo $courts->ChamberID->EditValue ?>"<?php echo $courts->ChamberID->editAttributes() ?>>
<?php echo $courts->ChamberID->Lookup->getParamTag("p_x_ChamberID") ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_ChamberID">
		<td class="<?php echo $courts_search->TableLeftColumnClass ?>"><span id="elh_courts_ChamberID"><?php echo $courts->ChamberID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ChamberID" id="z_ChamberID" value="="></span></td>
		<td<?php echo $courts->ChamberID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_courts_ChamberID">
<input type="text" data-table="courts" data-field="x_ChamberID" name="x_ChamberID" id="x_ChamberID" size="30" placeholder="<?php echo HtmlEncode($courts->ChamberID->getPlaceHolder()) ?>" value="<?php echo $courts->ChamberID->EditValue ?>"<?php echo $courts->ChamberID->editAttributes() ?>>
<?php echo $courts->ChamberID->Lookup->getParamTag("p_x_ChamberID") ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($courts->CourtLocationID->Visible) { // CourtLocationID ?>
<?php if ($courts_search->IsMobileOrModal) { ?>
	<div id="r_CourtLocationID" class="form-group row">
		<label for="x_CourtLocationID" class="<?php echo $courts_search->LeftColumnClass ?>"><span id="elh_courts_CourtLocationID"><?php echo $courts->CourtLocationID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CourtLocationID" id="z_CourtLocationID" value="="></span>
		</label>
		<div class="<?php echo $courts_search->RightColumnClass ?>"><div<?php echo $courts->CourtLocationID->cellAttributes() ?>>
			<span id="el_courts_CourtLocationID">
<input type="text" data-table="courts" data-field="x_CourtLocationID" name="x_CourtLocationID" id="x_CourtLocationID" size="30" placeholder="<?php echo HtmlEncode($courts->CourtLocationID->getPlaceHolder()) ?>" value="<?php echo $courts->CourtLocationID->EditValue ?>"<?php echo $courts->CourtLocationID->editAttributes() ?>>
<?php echo $courts->CourtLocationID->Lookup->getParamTag("p_x_CourtLocationID") ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_CourtLocationID">
		<td class="<?php echo $courts_search->TableLeftColumnClass ?>"><span id="elh_courts_CourtLocationID"><?php echo $courts->CourtLocationID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CourtLocationID" id="z_CourtLocationID" value="="></span></td>
		<td<?php echo $courts->CourtLocationID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_courts_CourtLocationID">
<input type="text" data-table="courts" data-field="x_CourtLocationID" name="x_CourtLocationID" id="x_CourtLocationID" size="30" placeholder="<?php echo HtmlEncode($courts->CourtLocationID->getPlaceHolder()) ?>" value="<?php echo $courts->CourtLocationID->EditValue ?>"<?php echo $courts->CourtLocationID->editAttributes() ?>>
<?php echo $courts->CourtLocationID->Lookup->getParamTag("p_x_CourtLocationID") ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($courts->GovernorateID->Visible) { // GovernorateID ?>
<?php if ($courts_search->IsMobileOrModal) { ?>
	<div id="r_GovernorateID" class="form-group row">
		<label for="x_GovernorateID" class="<?php echo $courts_search->LeftColumnClass ?>"><span id="elh_courts_GovernorateID"><?php echo $courts->GovernorateID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_GovernorateID" id="z_GovernorateID" value="="></span>
		</label>
		<div class="<?php echo $courts_search->RightColumnClass ?>"><div<?php echo $courts->GovernorateID->cellAttributes() ?>>
			<span id="el_courts_GovernorateID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="courts" data-field="x_GovernorateID" data-value-separator="<?php echo $courts->GovernorateID->displayValueSeparatorAttribute() ?>" id="x_GovernorateID" name="x_GovernorateID"<?php echo $courts->GovernorateID->editAttributes() ?>>
		<?php echo $courts->GovernorateID->selectOptionListHtml("x_GovernorateID") ?>
	</select>
</div>
<?php echo $courts->GovernorateID->Lookup->getParamTag("p_x_GovernorateID") ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_GovernorateID">
		<td class="<?php echo $courts_search->TableLeftColumnClass ?>"><span id="elh_courts_GovernorateID"><?php echo $courts->GovernorateID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_GovernorateID" id="z_GovernorateID" value="="></span></td>
		<td<?php echo $courts->GovernorateID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_courts_GovernorateID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="courts" data-field="x_GovernorateID" data-value-separator="<?php echo $courts->GovernorateID->displayValueSeparatorAttribute() ?>" id="x_GovernorateID" name="x_GovernorateID"<?php echo $courts->GovernorateID->editAttributes() ?>>
		<?php echo $courts->GovernorateID->selectOptionListHtml("x_GovernorateID") ?>
	</select>
</div>
<?php echo $courts->GovernorateID->Lookup->getParamTag("p_x_GovernorateID") ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($courts->Notes->Visible) { // Notes ?>
<?php if ($courts_search->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label for="x_Notes" class="<?php echo $courts_search->LeftColumnClass ?>"><span id="elh_courts_Notes"><?php echo $courts->Notes->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Notes" id="z_Notes" value="LIKE"></span>
		</label>
		<div class="<?php echo $courts_search->RightColumnClass ?>"><div<?php echo $courts->Notes->cellAttributes() ?>>
			<span id="el_courts_Notes">
<input type="text" data-table="courts" data-field="x_Notes" name="x_Notes" id="x_Notes" size="35" placeholder="<?php echo HtmlEncode($courts->Notes->getPlaceHolder()) ?>" value="<?php echo $courts->Notes->EditValue ?>"<?php echo $courts->Notes->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $courts_search->TableLeftColumnClass ?>"><span id="elh_courts_Notes"><?php echo $courts->Notes->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Notes" id="z_Notes" value="LIKE"></span></td>
		<td<?php echo $courts->Notes->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_courts_Notes">
<input type="text" data-table="courts" data-field="x_Notes" name="x_Notes" id="x_Notes" size="35" placeholder="<?php echo HtmlEncode($courts->Notes->getPlaceHolder()) ?>" value="<?php echo $courts->Notes->EditValue ?>"<?php echo $courts->Notes->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($courts_search->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if (!$courts_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $courts_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$courts_search->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
</form>
<?php
$courts_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$courts_search->terminate();
?>
