<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$employeeperson_list = new employeeperson_list();

// Run the page
$employeeperson_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$employeeperson_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$employeeperson->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var femployeepersonlist = currentForm = new ew.Form("femployeepersonlist", "list");
femployeepersonlist.formKeyCountName = '<?php echo $employeeperson_list->FormKeyCountName ?>';

// Form_CustomValidate event
femployeepersonlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
femployeepersonlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
femployeepersonlist.lists["x_EmployeeID"] = <?php echo $employeeperson_list->EmployeeID->Lookup->toClientList() ?>;
femployeepersonlist.lists["x_EmployeeID"].options = <?php echo JsonEncode($employeeperson_list->EmployeeID->lookupOptions()) ?>;
femployeepersonlist.lists["x_MaritalStatusID"] = <?php echo $employeeperson_list->MaritalStatusID->Lookup->toClientList() ?>;
femployeepersonlist.lists["x_MaritalStatusID"].options = <?php echo JsonEncode($employeeperson_list->MaritalStatusID->lookupOptions()) ?>;

// Form object for search
var femployeepersonlistsrch = currentSearchForm = new ew.Form("femployeepersonlistsrch");

// Filters
femployeepersonlistsrch.filterList = <?php echo $employeeperson_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$employeeperson->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($employeeperson_list->TotalRecs > 0 && $employeeperson_list->ExportOptions->visible()) { ?>
<?php $employeeperson_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($employeeperson_list->ImportOptions->visible()) { ?>
<?php $employeeperson_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($employeeperson_list->SearchOptions->visible()) { ?>
<?php $employeeperson_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($employeeperson_list->FilterOptions->visible()) { ?>
<?php $employeeperson_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$employeeperson->isExport() || EXPORT_MASTER_RECORD && $employeeperson->isExport("print")) { ?>
<?php
if ($employeeperson_list->DbMasterFilter <> "" && $employeeperson->getCurrentMasterTable() == "employees") {
	if ($employeeperson_list->MasterRecordExists) {
		include_once "employeesmaster.php";
	}
}
?>
<?php } ?>
<?php
$employeeperson_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$employeeperson->isExport() && !$employeeperson->CurrentAction) { ?>
<form name="femployeepersonlistsrch" id="femployeepersonlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($employeeperson_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="femployeepersonlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="employeeperson">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($employeeperson_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($employeeperson_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $employeeperson_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($employeeperson_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($employeeperson_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($employeeperson_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($employeeperson_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $employeeperson_list->showPageHeader(); ?>
<?php
$employeeperson_list->showMessage();
?>
<?php if ($employeeperson_list->TotalRecs > 0 || $employeeperson->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($employeeperson_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> employeeperson">
<?php if (!$employeeperson->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$employeeperson->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($employeeperson_list->Pager)) $employeeperson_list->Pager = new PrevNextPager($employeeperson_list->StartRec, $employeeperson_list->DisplayRecs, $employeeperson_list->TotalRecs, $employeeperson_list->AutoHidePager) ?>
<?php if ($employeeperson_list->Pager->RecordCount > 0 && $employeeperson_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($employeeperson_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $employeeperson_list->pageUrl() ?>start=<?php echo $employeeperson_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($employeeperson_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $employeeperson_list->pageUrl() ?>start=<?php echo $employeeperson_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $employeeperson_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($employeeperson_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $employeeperson_list->pageUrl() ?>start=<?php echo $employeeperson_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($employeeperson_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $employeeperson_list->pageUrl() ?>start=<?php echo $employeeperson_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $employeeperson_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($employeeperson_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $employeeperson_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $employeeperson_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $employeeperson_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($employeeperson_list->TotalRecs > 0 && (!$employeeperson_list->AutoHidePageSizeSelector || $employeeperson_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="employeeperson">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($employeeperson_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($employeeperson_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($employeeperson_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($employeeperson_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($employeeperson_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($employeeperson_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($employeeperson_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($employeeperson_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($employeeperson_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($employeeperson->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $employeeperson_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="femployeepersonlist" id="femployeepersonlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($employeeperson_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $employeeperson_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="employeeperson">
<?php if ($employeeperson->getCurrentMasterTable() == "employees" && $employeeperson->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="employees">
<input type="hidden" name="fk_EmployeeID" value="<?php echo $employeeperson->EmployeeID->getSessionValue() ?>">
<?php } ?>
<div id="gmp_employeeperson" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($employeeperson_list->TotalRecs > 0 || $employeeperson->isGridEdit()) { ?>
<table id="tbl_employeepersonlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$employeeperson_list->RowType = ROWTYPE_HEADER;

// Render list options
$employeeperson_list->renderListOptions();

// Render list options (header, left)
$employeeperson_list->ListOptions->render("header", "left");
?>
<?php if ($employeeperson->EmployeeID->Visible) { // EmployeeID ?>
	<?php if ($employeeperson->sortUrl($employeeperson->EmployeeID) == "") { ?>
		<th data-name="EmployeeID" class="<?php echo $employeeperson->EmployeeID->headerCellClass() ?>"><div id="elh_employeeperson_EmployeeID" class="employeeperson_EmployeeID"><div class="ew-table-header-caption"><?php echo $employeeperson->EmployeeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="EmployeeID" class="<?php echo $employeeperson->EmployeeID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $employeeperson->SortUrl($employeeperson->EmployeeID) ?>',2);"><div id="elh_employeeperson_EmployeeID" class="employeeperson_EmployeeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employeeperson->EmployeeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($employeeperson->EmployeeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($employeeperson->EmployeeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employeeperson->MaritalStatusID->Visible) { // MaritalStatusID ?>
	<?php if ($employeeperson->sortUrl($employeeperson->MaritalStatusID) == "") { ?>
		<th data-name="MaritalStatusID" class="<?php echo $employeeperson->MaritalStatusID->headerCellClass() ?>"><div id="elh_employeeperson_MaritalStatusID" class="employeeperson_MaritalStatusID"><div class="ew-table-header-caption"><?php echo $employeeperson->MaritalStatusID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="MaritalStatusID" class="<?php echo $employeeperson->MaritalStatusID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $employeeperson->SortUrl($employeeperson->MaritalStatusID) ?>',2);"><div id="elh_employeeperson_MaritalStatusID" class="employeeperson_MaritalStatusID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employeeperson->MaritalStatusID->caption() ?></span><span class="ew-table-header-sort"><?php if ($employeeperson->MaritalStatusID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($employeeperson->MaritalStatusID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employeeperson->CivilStatus23->Visible) { // CivilStatus# ?>
	<?php if ($employeeperson->sortUrl($employeeperson->CivilStatus23) == "") { ?>
		<th data-name="CivilStatus23" class="<?php echo $employeeperson->CivilStatus23->headerCellClass() ?>"><div id="elh_employeeperson_CivilStatus23" class="employeeperson_CivilStatus23"><div class="ew-table-header-caption"><?php echo $employeeperson->CivilStatus23->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CivilStatus23" class="<?php echo $employeeperson->CivilStatus23->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $employeeperson->SortUrl($employeeperson->CivilStatus23) ?>',2);"><div id="elh_employeeperson_CivilStatus23" class="employeeperson_CivilStatus23">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employeeperson->CivilStatus23->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($employeeperson->CivilStatus23->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($employeeperson->CivilStatus23->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employeeperson->CivilStatusPlace->Visible) { // CivilStatusPlace ?>
	<?php if ($employeeperson->sortUrl($employeeperson->CivilStatusPlace) == "") { ?>
		<th data-name="CivilStatusPlace" class="<?php echo $employeeperson->CivilStatusPlace->headerCellClass() ?>"><div id="elh_employeeperson_CivilStatusPlace" class="employeeperson_CivilStatusPlace"><div class="ew-table-header-caption"><?php echo $employeeperson->CivilStatusPlace->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CivilStatusPlace" class="<?php echo $employeeperson->CivilStatusPlace->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $employeeperson->SortUrl($employeeperson->CivilStatusPlace) ?>',2);"><div id="elh_employeeperson_CivilStatusPlace" class="employeeperson_CivilStatusPlace">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employeeperson->CivilStatusPlace->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($employeeperson->CivilStatusPlace->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($employeeperson->CivilStatusPlace->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employeeperson->IdCard23->Visible) { // IdCard# ?>
	<?php if ($employeeperson->sortUrl($employeeperson->IdCard23) == "") { ?>
		<th data-name="IdCard23" class="<?php echo $employeeperson->IdCard23->headerCellClass() ?>"><div id="elh_employeeperson_IdCard23" class="employeeperson_IdCard23"><div class="ew-table-header-caption"><?php echo $employeeperson->IdCard23->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IdCard23" class="<?php echo $employeeperson->IdCard23->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $employeeperson->SortUrl($employeeperson->IdCard23) ?>',2);"><div id="elh_employeeperson_IdCard23" class="employeeperson_IdCard23">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employeeperson->IdCard23->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($employeeperson->IdCard23->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($employeeperson->IdCard23->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employeeperson->PracticingProfessionLicense23->Visible) { // PracticingProfessionLicense# ?>
	<?php if ($employeeperson->sortUrl($employeeperson->PracticingProfessionLicense23) == "") { ?>
		<th data-name="PracticingProfessionLicense23" class="<?php echo $employeeperson->PracticingProfessionLicense23->headerCellClass() ?>"><div id="elh_employeeperson_PracticingProfessionLicense23" class="employeeperson_PracticingProfessionLicense23"><div class="ew-table-header-caption"><?php echo $employeeperson->PracticingProfessionLicense23->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PracticingProfessionLicense23" class="<?php echo $employeeperson->PracticingProfessionLicense23->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $employeeperson->SortUrl($employeeperson->PracticingProfessionLicense23) ?>',2);"><div id="elh_employeeperson_PracticingProfessionLicense23" class="employeeperson_PracticingProfessionLicense23">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employeeperson->PracticingProfessionLicense23->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($employeeperson->PracticingProfessionLicense23->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($employeeperson->PracticingProfessionLicense23->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employeeperson->NationalId23->Visible) { // NationalId# ?>
	<?php if ($employeeperson->sortUrl($employeeperson->NationalId23) == "") { ?>
		<th data-name="NationalId23" class="<?php echo $employeeperson->NationalId23->headerCellClass() ?>"><div id="elh_employeeperson_NationalId23" class="employeeperson_NationalId23"><div class="ew-table-header-caption"><?php echo $employeeperson->NationalId23->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NationalId23" class="<?php echo $employeeperson->NationalId23->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $employeeperson->SortUrl($employeeperson->NationalId23) ?>',2);"><div id="elh_employeeperson_NationalId23" class="employeeperson_NationalId23">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employeeperson->NationalId23->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($employeeperson->NationalId23->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($employeeperson->NationalId23->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employeeperson->Nationality1->Visible) { // Nationality1 ?>
	<?php if ($employeeperson->sortUrl($employeeperson->Nationality1) == "") { ?>
		<th data-name="Nationality1" class="<?php echo $employeeperson->Nationality1->headerCellClass() ?>"><div id="elh_employeeperson_Nationality1" class="employeeperson_Nationality1"><div class="ew-table-header-caption"><?php echo $employeeperson->Nationality1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nationality1" class="<?php echo $employeeperson->Nationality1->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $employeeperson->SortUrl($employeeperson->Nationality1) ?>',2);"><div id="elh_employeeperson_Nationality1" class="employeeperson_Nationality1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employeeperson->Nationality1->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($employeeperson->Nationality1->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($employeeperson->Nationality1->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employeeperson->Nationality2->Visible) { // Nationality2 ?>
	<?php if ($employeeperson->sortUrl($employeeperson->Nationality2) == "") { ?>
		<th data-name="Nationality2" class="<?php echo $employeeperson->Nationality2->headerCellClass() ?>"><div id="elh_employeeperson_Nationality2" class="employeeperson_Nationality2"><div class="ew-table-header-caption"><?php echo $employeeperson->Nationality2->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nationality2" class="<?php echo $employeeperson->Nationality2->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $employeeperson->SortUrl($employeeperson->Nationality2) ?>',2);"><div id="elh_employeeperson_Nationality2" class="employeeperson_Nationality2">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employeeperson->Nationality2->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($employeeperson->Nationality2->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($employeeperson->Nationality2->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employeeperson->Nationality3->Visible) { // Nationality3 ?>
	<?php if ($employeeperson->sortUrl($employeeperson->Nationality3) == "") { ?>
		<th data-name="Nationality3" class="<?php echo $employeeperson->Nationality3->headerCellClass() ?>"><div id="elh_employeeperson_Nationality3" class="employeeperson_Nationality3"><div class="ew-table-header-caption"><?php echo $employeeperson->Nationality3->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Nationality3" class="<?php echo $employeeperson->Nationality3->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $employeeperson->SortUrl($employeeperson->Nationality3) ?>',2);"><div id="elh_employeeperson_Nationality3" class="employeeperson_Nationality3">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employeeperson->Nationality3->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($employeeperson->Nationality3->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($employeeperson->Nationality3->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employeeperson->DriverLicense23->Visible) { // DriverLicense# ?>
	<?php if ($employeeperson->sortUrl($employeeperson->DriverLicense23) == "") { ?>
		<th data-name="DriverLicense23" class="<?php echo $employeeperson->DriverLicense23->headerCellClass() ?>"><div id="elh_employeeperson_DriverLicense23" class="employeeperson_DriverLicense23"><div class="ew-table-header-caption"><?php echo $employeeperson->DriverLicense23->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="DriverLicense23" class="<?php echo $employeeperson->DriverLicense23->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $employeeperson->SortUrl($employeeperson->DriverLicense23) ?>',2);"><div id="elh_employeeperson_DriverLicense23" class="employeeperson_DriverLicense23">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employeeperson->DriverLicense23->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($employeeperson->DriverLicense23->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($employeeperson->DriverLicense23->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employeeperson->Extra23->Visible) { // Extra# ?>
	<?php if ($employeeperson->sortUrl($employeeperson->Extra23) == "") { ?>
		<th data-name="Extra23" class="<?php echo $employeeperson->Extra23->headerCellClass() ?>"><div id="elh_employeeperson_Extra23" class="employeeperson_Extra23"><div class="ew-table-header-caption"><?php echo $employeeperson->Extra23->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Extra23" class="<?php echo $employeeperson->Extra23->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $employeeperson->SortUrl($employeeperson->Extra23) ?>',2);"><div id="elh_employeeperson_Extra23" class="employeeperson_Extra23">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employeeperson->Extra23->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($employeeperson->Extra23->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($employeeperson->Extra23->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$employeeperson_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($employeeperson->ExportAll && $employeeperson->isExport()) {
	$employeeperson_list->StopRec = $employeeperson_list->TotalRecs;
} else {

	// Set the last record to display
	if ($employeeperson_list->TotalRecs > $employeeperson_list->StartRec + $employeeperson_list->DisplayRecs - 1)
		$employeeperson_list->StopRec = $employeeperson_list->StartRec + $employeeperson_list->DisplayRecs - 1;
	else
		$employeeperson_list->StopRec = $employeeperson_list->TotalRecs;
}
$employeeperson_list->RecCnt = $employeeperson_list->StartRec - 1;
if ($employeeperson_list->Recordset && !$employeeperson_list->Recordset->EOF) {
	$employeeperson_list->Recordset->moveFirst();
	$selectLimit = $employeeperson_list->UseSelectLimit;
	if (!$selectLimit && $employeeperson_list->StartRec > 1)
		$employeeperson_list->Recordset->move($employeeperson_list->StartRec - 1);
} elseif (!$employeeperson->AllowAddDeleteRow && $employeeperson_list->StopRec == 0) {
	$employeeperson_list->StopRec = $employeeperson->GridAddRowCount;
}

// Initialize aggregate
$employeeperson->RowType = ROWTYPE_AGGREGATEINIT;
$employeeperson->resetAttributes();
$employeeperson_list->renderRow();
while ($employeeperson_list->RecCnt < $employeeperson_list->StopRec) {
	$employeeperson_list->RecCnt++;
	if ($employeeperson_list->RecCnt >= $employeeperson_list->StartRec) {
		$employeeperson_list->RowCnt++;

		// Set up key count
		$employeeperson_list->KeyCount = $employeeperson_list->RowIndex;

		// Init row class and style
		$employeeperson->resetAttributes();
		$employeeperson->CssClass = "";
		if ($employeeperson->isGridAdd()) {
		} else {
			$employeeperson_list->loadRowValues($employeeperson_list->Recordset); // Load row values
		}
		$employeeperson->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$employeeperson->RowAttrs = array_merge($employeeperson->RowAttrs, array('data-rowindex'=>$employeeperson_list->RowCnt, 'id'=>'r' . $employeeperson_list->RowCnt . '_employeeperson', 'data-rowtype'=>$employeeperson->RowType));

		// Render row
		$employeeperson_list->renderRow();

		// Render list options
		$employeeperson_list->renderListOptions();
?>
	<tr<?php echo $employeeperson->rowAttributes() ?>>
<?php

// Render list options (body, left)
$employeeperson_list->ListOptions->render("body", "left", $employeeperson_list->RowCnt);
?>
	<?php if ($employeeperson->EmployeeID->Visible) { // EmployeeID ?>
		<td data-name="EmployeeID"<?php echo $employeeperson->EmployeeID->cellAttributes() ?>>
<span id="el<?php echo $employeeperson_list->RowCnt ?>_employeeperson_EmployeeID" class="employeeperson_EmployeeID">
<span<?php echo $employeeperson->EmployeeID->viewAttributes() ?>>
<?php echo $employeeperson->EmployeeID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employeeperson->MaritalStatusID->Visible) { // MaritalStatusID ?>
		<td data-name="MaritalStatusID"<?php echo $employeeperson->MaritalStatusID->cellAttributes() ?>>
<span id="el<?php echo $employeeperson_list->RowCnt ?>_employeeperson_MaritalStatusID" class="employeeperson_MaritalStatusID">
<span<?php echo $employeeperson->MaritalStatusID->viewAttributes() ?>>
<?php echo $employeeperson->MaritalStatusID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employeeperson->CivilStatus23->Visible) { // CivilStatus# ?>
		<td data-name="CivilStatus23"<?php echo $employeeperson->CivilStatus23->cellAttributes() ?>>
<span id="el<?php echo $employeeperson_list->RowCnt ?>_employeeperson_CivilStatus23" class="employeeperson_CivilStatus23">
<span<?php echo $employeeperson->CivilStatus23->viewAttributes() ?>>
<?php echo $employeeperson->CivilStatus23->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employeeperson->CivilStatusPlace->Visible) { // CivilStatusPlace ?>
		<td data-name="CivilStatusPlace"<?php echo $employeeperson->CivilStatusPlace->cellAttributes() ?>>
<span id="el<?php echo $employeeperson_list->RowCnt ?>_employeeperson_CivilStatusPlace" class="employeeperson_CivilStatusPlace">
<span<?php echo $employeeperson->CivilStatusPlace->viewAttributes() ?>>
<?php echo $employeeperson->CivilStatusPlace->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employeeperson->IdCard23->Visible) { // IdCard# ?>
		<td data-name="IdCard23"<?php echo $employeeperson->IdCard23->cellAttributes() ?>>
<span id="el<?php echo $employeeperson_list->RowCnt ?>_employeeperson_IdCard23" class="employeeperson_IdCard23">
<span<?php echo $employeeperson->IdCard23->viewAttributes() ?>>
<?php echo $employeeperson->IdCard23->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employeeperson->PracticingProfessionLicense23->Visible) { // PracticingProfessionLicense# ?>
		<td data-name="PracticingProfessionLicense23"<?php echo $employeeperson->PracticingProfessionLicense23->cellAttributes() ?>>
<span id="el<?php echo $employeeperson_list->RowCnt ?>_employeeperson_PracticingProfessionLicense23" class="employeeperson_PracticingProfessionLicense23">
<span<?php echo $employeeperson->PracticingProfessionLicense23->viewAttributes() ?>>
<?php echo $employeeperson->PracticingProfessionLicense23->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employeeperson->NationalId23->Visible) { // NationalId# ?>
		<td data-name="NationalId23"<?php echo $employeeperson->NationalId23->cellAttributes() ?>>
<span id="el<?php echo $employeeperson_list->RowCnt ?>_employeeperson_NationalId23" class="employeeperson_NationalId23">
<span<?php echo $employeeperson->NationalId23->viewAttributes() ?>>
<?php echo $employeeperson->NationalId23->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employeeperson->Nationality1->Visible) { // Nationality1 ?>
		<td data-name="Nationality1"<?php echo $employeeperson->Nationality1->cellAttributes() ?>>
<span id="el<?php echo $employeeperson_list->RowCnt ?>_employeeperson_Nationality1" class="employeeperson_Nationality1">
<span<?php echo $employeeperson->Nationality1->viewAttributes() ?>>
<?php echo $employeeperson->Nationality1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employeeperson->Nationality2->Visible) { // Nationality2 ?>
		<td data-name="Nationality2"<?php echo $employeeperson->Nationality2->cellAttributes() ?>>
<span id="el<?php echo $employeeperson_list->RowCnt ?>_employeeperson_Nationality2" class="employeeperson_Nationality2">
<span<?php echo $employeeperson->Nationality2->viewAttributes() ?>>
<?php echo $employeeperson->Nationality2->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employeeperson->Nationality3->Visible) { // Nationality3 ?>
		<td data-name="Nationality3"<?php echo $employeeperson->Nationality3->cellAttributes() ?>>
<span id="el<?php echo $employeeperson_list->RowCnt ?>_employeeperson_Nationality3" class="employeeperson_Nationality3">
<span<?php echo $employeeperson->Nationality3->viewAttributes() ?>>
<?php echo $employeeperson->Nationality3->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employeeperson->DriverLicense23->Visible) { // DriverLicense# ?>
		<td data-name="DriverLicense23"<?php echo $employeeperson->DriverLicense23->cellAttributes() ?>>
<span id="el<?php echo $employeeperson_list->RowCnt ?>_employeeperson_DriverLicense23" class="employeeperson_DriverLicense23">
<span<?php echo $employeeperson->DriverLicense23->viewAttributes() ?>>
<?php echo $employeeperson->DriverLicense23->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employeeperson->Extra23->Visible) { // Extra# ?>
		<td data-name="Extra23"<?php echo $employeeperson->Extra23->cellAttributes() ?>>
<span id="el<?php echo $employeeperson_list->RowCnt ?>_employeeperson_Extra23" class="employeeperson_Extra23">
<span<?php echo $employeeperson->Extra23->viewAttributes() ?>>
<?php echo $employeeperson->Extra23->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$employeeperson_list->ListOptions->render("body", "right", $employeeperson_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$employeeperson->isGridAdd())
		$employeeperson_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$employeeperson->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($employeeperson_list->Recordset)
	$employeeperson_list->Recordset->Close();
?>
<?php if (!$employeeperson->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$employeeperson->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($employeeperson_list->Pager)) $employeeperson_list->Pager = new PrevNextPager($employeeperson_list->StartRec, $employeeperson_list->DisplayRecs, $employeeperson_list->TotalRecs, $employeeperson_list->AutoHidePager) ?>
<?php if ($employeeperson_list->Pager->RecordCount > 0 && $employeeperson_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($employeeperson_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $employeeperson_list->pageUrl() ?>start=<?php echo $employeeperson_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($employeeperson_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $employeeperson_list->pageUrl() ?>start=<?php echo $employeeperson_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $employeeperson_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($employeeperson_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $employeeperson_list->pageUrl() ?>start=<?php echo $employeeperson_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($employeeperson_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $employeeperson_list->pageUrl() ?>start=<?php echo $employeeperson_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $employeeperson_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($employeeperson_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $employeeperson_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $employeeperson_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $employeeperson_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($employeeperson_list->TotalRecs > 0 && (!$employeeperson_list->AutoHidePageSizeSelector || $employeeperson_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="employeeperson">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($employeeperson_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($employeeperson_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($employeeperson_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($employeeperson_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($employeeperson_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($employeeperson_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($employeeperson_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($employeeperson_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($employeeperson_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($employeeperson->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $employeeperson_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($employeeperson_list->TotalRecs == 0 && !$employeeperson->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $employeeperson_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$employeeperson_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$employeeperson->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$employeeperson->isExport()) { ?>
<script>
ew.scrollableTable("gmp_employeeperson", "1250px", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$employeeperson_list->terminate();
?>
