<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$hearings_list = new hearings_list();

// Run the page
$hearings_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$hearings_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$hearings->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fhearingslist = currentForm = new ew.Form("fhearingslist", "list");
fhearingslist.formKeyCountName = '<?php echo $hearings_list->FormKeyCountName ?>';

// Form_CustomValidate event
fhearingslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fhearingslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fhearingslist.lists["x_CaseID"] = <?php echo $hearings_list->CaseID->Lookup->toClientList() ?>;
fhearingslist.lists["x_CaseID"].options = <?php echo JsonEncode($hearings_list->CaseID->lookupOptions()) ?>;
fhearingslist.autoSuggests["x_CaseID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fhearingslist.lists["x_LawyerID"] = <?php echo $hearings_list->LawyerID->Lookup->toClientList() ?>;
fhearingslist.lists["x_LawyerID"].options = <?php echo JsonEncode($hearings_list->LawyerID->lookupOptions()) ?>;
fhearingslist.lists["x_JudgeID"] = <?php echo $hearings_list->JudgeID->Lookup->toClientList() ?>;
fhearingslist.lists["x_JudgeID"].options = <?php echo JsonEncode($hearings_list->JudgeID->lookupOptions()) ?>;
fhearingslist.lists["x_CourtID"] = <?php echo $hearings_list->CourtID->Lookup->toClientList() ?>;
fhearingslist.lists["x_CourtID"].options = <?php echo JsonEncode($hearings_list->CourtID->lookupOptions()) ?>;
fhearingslist.autoSuggests["x_CourtID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var fhearingslistsrch = currentSearchForm = new ew.Form("fhearingslistsrch");

// Filters
fhearingslistsrch.filterList = <?php echo $hearings_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$hearings->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($hearings_list->TotalRecs > 0 && $hearings_list->ExportOptions->visible()) { ?>
<?php $hearings_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($hearings_list->ImportOptions->visible()) { ?>
<?php $hearings_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($hearings_list->SearchOptions->visible()) { ?>
<?php $hearings_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($hearings_list->FilterOptions->visible()) { ?>
<?php $hearings_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$hearings->isExport() || EXPORT_MASTER_RECORD && $hearings->isExport("print")) { ?>
<?php
if ($hearings_list->DbMasterFilter <> "" && $hearings->getCurrentMasterTable() == "cases") {
	if ($hearings_list->MasterRecordExists) {
		include_once "casesmaster.php";
	}
}
?>
<?php } ?>
<?php
$hearings_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$hearings->isExport() && !$hearings->CurrentAction) { ?>
<form name="fhearingslistsrch" id="fhearingslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($hearings_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="fhearingslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="hearings">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($hearings_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($hearings_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $hearings_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($hearings_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($hearings_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($hearings_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($hearings_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $hearings_list->showPageHeader(); ?>
<?php
$hearings_list->showMessage();
?>
<?php if ($hearings_list->TotalRecs > 0 || $hearings->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($hearings_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> hearings">
<?php if (!$hearings->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$hearings->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($hearings_list->Pager)) $hearings_list->Pager = new PrevNextPager($hearings_list->StartRec, $hearings_list->DisplayRecs, $hearings_list->TotalRecs, $hearings_list->AutoHidePager) ?>
<?php if ($hearings_list->Pager->RecordCount > 0 && $hearings_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($hearings_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $hearings_list->pageUrl() ?>start=<?php echo $hearings_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($hearings_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $hearings_list->pageUrl() ?>start=<?php echo $hearings_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $hearings_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($hearings_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $hearings_list->pageUrl() ?>start=<?php echo $hearings_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($hearings_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $hearings_list->pageUrl() ?>start=<?php echo $hearings_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $hearings_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($hearings_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $hearings_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $hearings_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $hearings_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($hearings_list->TotalRecs > 0 && (!$hearings_list->AutoHidePageSizeSelector || $hearings_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="hearings">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($hearings_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($hearings_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($hearings_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($hearings_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($hearings_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($hearings_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($hearings_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($hearings_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($hearings_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($hearings->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $hearings_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fhearingslist" id="fhearingslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($hearings_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $hearings_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="hearings">
<?php if ($hearings->getCurrentMasterTable() == "cases" && $hearings->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="cases">
<input type="hidden" name="fk_CaseID" value="<?php echo $hearings->CaseID->getSessionValue() ?>">
<?php } ?>
<div id="gmp_hearings" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($hearings_list->TotalRecs > 0 || $hearings->isGridEdit()) { ?>
<table id="tbl_hearingslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$hearings_list->RowType = ROWTYPE_HEADER;

// Render list options
$hearings_list->renderListOptions();

// Render list options (header, left)
$hearings_list->ListOptions->render("header", "left");
?>
<?php if ($hearings->CaseID->Visible) { // CaseID ?>
	<?php if ($hearings->sortUrl($hearings->CaseID) == "") { ?>
		<th data-name="CaseID" class="<?php echo $hearings->CaseID->headerCellClass() ?>" style="min-width: 200px;"><div id="elh_hearings_CaseID" class="hearings_CaseID"><div class="ew-table-header-caption"><?php echo $hearings->CaseID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CaseID" class="<?php echo $hearings->CaseID->headerCellClass() ?>" style="min-width: 200px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hearings->SortUrl($hearings->CaseID) ?>',2);"><div id="elh_hearings_CaseID" class="hearings_CaseID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hearings->CaseID->caption() ?></span><span class="ew-table-header-sort"><?php if ($hearings->CaseID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hearings->CaseID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hearings->HearingDate->Visible) { // HearingDate ?>
	<?php if ($hearings->sortUrl($hearings->HearingDate) == "") { ?>
		<th data-name="HearingDate" class="<?php echo $hearings->HearingDate->headerCellClass() ?>"><div id="elh_hearings_HearingDate" class="hearings_HearingDate"><div class="ew-table-header-caption"><?php echo $hearings->HearingDate->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="HearingDate" class="<?php echo $hearings->HearingDate->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hearings->SortUrl($hearings->HearingDate) ?>',2);"><div id="elh_hearings_HearingDate" class="hearings_HearingDate">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hearings->HearingDate->caption() ?></span><span class="ew-table-header-sort"><?php if ($hearings->HearingDate->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hearings->HearingDate->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hearings->HearingTime->Visible) { // HearingTime ?>
	<?php if ($hearings->sortUrl($hearings->HearingTime) == "") { ?>
		<th data-name="HearingTime" class="<?php echo $hearings->HearingTime->headerCellClass() ?>"><div id="elh_hearings_HearingTime" class="hearings_HearingTime"><div class="ew-table-header-caption"><?php echo $hearings->HearingTime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="HearingTime" class="<?php echo $hearings->HearingTime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hearings->SortUrl($hearings->HearingTime) ?>',2);"><div id="elh_hearings_HearingTime" class="hearings_HearingTime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hearings->HearingTime->caption() ?></span><span class="ew-table-header-sort"><?php if ($hearings->HearingTime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hearings->HearingTime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hearings->NextHearingDate->Visible) { // NextHearingDate ?>
	<?php if ($hearings->sortUrl($hearings->NextHearingDate) == "") { ?>
		<th data-name="NextHearingDate" class="<?php echo $hearings->NextHearingDate->headerCellClass() ?>"><div id="elh_hearings_NextHearingDate" class="hearings_NextHearingDate"><div class="ew-table-header-caption"><?php echo $hearings->NextHearingDate->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NextHearingDate" class="<?php echo $hearings->NextHearingDate->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hearings->SortUrl($hearings->NextHearingDate) ?>',2);"><div id="elh_hearings_NextHearingDate" class="hearings_NextHearingDate">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hearings->NextHearingDate->caption() ?></span><span class="ew-table-header-sort"><?php if ($hearings->NextHearingDate->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hearings->NextHearingDate->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hearings->NextHearingTime->Visible) { // NextHearingTime ?>
	<?php if ($hearings->sortUrl($hearings->NextHearingTime) == "") { ?>
		<th data-name="NextHearingTime" class="<?php echo $hearings->NextHearingTime->headerCellClass() ?>"><div id="elh_hearings_NextHearingTime" class="hearings_NextHearingTime"><div class="ew-table-header-caption"><?php echo $hearings->NextHearingTime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NextHearingTime" class="<?php echo $hearings->NextHearingTime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hearings->SortUrl($hearings->NextHearingTime) ?>',2);"><div id="elh_hearings_NextHearingTime" class="hearings_NextHearingTime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hearings->NextHearingTime->caption() ?></span><span class="ew-table-header-sort"><?php if ($hearings->NextHearingTime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hearings->NextHearingTime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hearings->Hearing->Visible) { // Hearing ?>
	<?php if ($hearings->sortUrl($hearings->Hearing) == "") { ?>
		<th data-name="Hearing" class="<?php echo $hearings->Hearing->headerCellClass() ?>" style="min-width: 100px;"><div id="elh_hearings_Hearing" class="hearings_Hearing"><div class="ew-table-header-caption"><?php echo $hearings->Hearing->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Hearing" class="<?php echo $hearings->Hearing->headerCellClass() ?>" style="min-width: 100px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hearings->SortUrl($hearings->Hearing) ?>',2);"><div id="elh_hearings_Hearing" class="hearings_Hearing">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hearings->Hearing->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($hearings->Hearing->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hearings->Hearing->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hearings->Notes->Visible) { // Notes ?>
	<?php if ($hearings->sortUrl($hearings->Notes) == "") { ?>
		<th data-name="Notes" class="<?php echo $hearings->Notes->headerCellClass() ?>" style="min-width: 200px;"><div id="elh_hearings_Notes" class="hearings_Notes"><div class="ew-table-header-caption"><?php echo $hearings->Notes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Notes" class="<?php echo $hearings->Notes->headerCellClass() ?>" style="min-width: 200px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hearings->SortUrl($hearings->Notes) ?>',2);"><div id="elh_hearings_Notes" class="hearings_Notes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hearings->Notes->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($hearings->Notes->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hearings->Notes->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hearings->LawyerID->Visible) { // LawyerID ?>
	<?php if ($hearings->sortUrl($hearings->LawyerID) == "") { ?>
		<th data-name="LawyerID" class="<?php echo $hearings->LawyerID->headerCellClass() ?>"><div id="elh_hearings_LawyerID" class="hearings_LawyerID"><div class="ew-table-header-caption"><?php echo $hearings->LawyerID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LawyerID" class="<?php echo $hearings->LawyerID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hearings->SortUrl($hearings->LawyerID) ?>',2);"><div id="elh_hearings_LawyerID" class="hearings_LawyerID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hearings->LawyerID->caption() ?></span><span class="ew-table-header-sort"><?php if ($hearings->LawyerID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hearings->LawyerID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hearings->JudgeID->Visible) { // JudgeID ?>
	<?php if ($hearings->sortUrl($hearings->JudgeID) == "") { ?>
		<th data-name="JudgeID" class="<?php echo $hearings->JudgeID->headerCellClass() ?>"><div id="elh_hearings_JudgeID" class="hearings_JudgeID"><div class="ew-table-header-caption"><?php echo $hearings->JudgeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="JudgeID" class="<?php echo $hearings->JudgeID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hearings->SortUrl($hearings->JudgeID) ?>',2);"><div id="elh_hearings_JudgeID" class="hearings_JudgeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hearings->JudgeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($hearings->JudgeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hearings->JudgeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hearings->CaseNumber->Visible) { // CaseNumber ?>
	<?php if ($hearings->sortUrl($hearings->CaseNumber) == "") { ?>
		<th data-name="CaseNumber" class="<?php echo $hearings->CaseNumber->headerCellClass() ?>"><div id="elh_hearings_CaseNumber" class="hearings_CaseNumber"><div class="ew-table-header-caption"><?php echo $hearings->CaseNumber->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CaseNumber" class="<?php echo $hearings->CaseNumber->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hearings->SortUrl($hearings->CaseNumber) ?>',2);"><div id="elh_hearings_CaseNumber" class="hearings_CaseNumber">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hearings->CaseNumber->caption() ?></span><span class="ew-table-header-sort"><?php if ($hearings->CaseNumber->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hearings->CaseNumber->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($hearings->CourtID->Visible) { // CourtID ?>
	<?php if ($hearings->sortUrl($hearings->CourtID) == "") { ?>
		<th data-name="CourtID" class="<?php echo $hearings->CourtID->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_hearings_CourtID" class="hearings_CourtID"><div class="ew-table-header-caption"><?php echo $hearings->CourtID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CourtID" class="<?php echo $hearings->CourtID->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $hearings->SortUrl($hearings->CourtID) ?>',2);"><div id="elh_hearings_CourtID" class="hearings_CourtID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $hearings->CourtID->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($hearings->CourtID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($hearings->CourtID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$hearings_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($hearings->ExportAll && $hearings->isExport()) {
	$hearings_list->StopRec = $hearings_list->TotalRecs;
} else {

	// Set the last record to display
	if ($hearings_list->TotalRecs > $hearings_list->StartRec + $hearings_list->DisplayRecs - 1)
		$hearings_list->StopRec = $hearings_list->StartRec + $hearings_list->DisplayRecs - 1;
	else
		$hearings_list->StopRec = $hearings_list->TotalRecs;
}
$hearings_list->RecCnt = $hearings_list->StartRec - 1;
if ($hearings_list->Recordset && !$hearings_list->Recordset->EOF) {
	$hearings_list->Recordset->moveFirst();
	$selectLimit = $hearings_list->UseSelectLimit;
	if (!$selectLimit && $hearings_list->StartRec > 1)
		$hearings_list->Recordset->move($hearings_list->StartRec - 1);
} elseif (!$hearings->AllowAddDeleteRow && $hearings_list->StopRec == 0) {
	$hearings_list->StopRec = $hearings->GridAddRowCount;
}

// Initialize aggregate
$hearings->RowType = ROWTYPE_AGGREGATEINIT;
$hearings->resetAttributes();
$hearings_list->renderRow();
while ($hearings_list->RecCnt < $hearings_list->StopRec) {
	$hearings_list->RecCnt++;
	if ($hearings_list->RecCnt >= $hearings_list->StartRec) {
		$hearings_list->RowCnt++;

		// Set up key count
		$hearings_list->KeyCount = $hearings_list->RowIndex;

		// Init row class and style
		$hearings->resetAttributes();
		$hearings->CssClass = "";
		if ($hearings->isGridAdd()) {
		} else {
			$hearings_list->loadRowValues($hearings_list->Recordset); // Load row values
		}
		$hearings->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$hearings->RowAttrs = array_merge($hearings->RowAttrs, array('data-rowindex'=>$hearings_list->RowCnt, 'id'=>'r' . $hearings_list->RowCnt . '_hearings', 'data-rowtype'=>$hearings->RowType));

		// Render row
		$hearings_list->renderRow();

		// Render list options
		$hearings_list->renderListOptions();
?>
	<tr<?php echo $hearings->rowAttributes() ?>>
<?php

// Render list options (body, left)
$hearings_list->ListOptions->render("body", "left", $hearings_list->RowCnt);
?>
	<?php if ($hearings->CaseID->Visible) { // CaseID ?>
		<td data-name="CaseID"<?php echo $hearings->CaseID->cellAttributes() ?>>
<span id="el<?php echo $hearings_list->RowCnt ?>_hearings_CaseID" class="hearings_CaseID">
<span<?php echo $hearings->CaseID->viewAttributes() ?>>
<?php echo $hearings->CaseID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hearings->HearingDate->Visible) { // HearingDate ?>
		<td data-name="HearingDate"<?php echo $hearings->HearingDate->cellAttributes() ?>>
<span id="el<?php echo $hearings_list->RowCnt ?>_hearings_HearingDate" class="hearings_HearingDate">
<span<?php echo $hearings->HearingDate->viewAttributes() ?>>
<?php echo $hearings->HearingDate->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hearings->HearingTime->Visible) { // HearingTime ?>
		<td data-name="HearingTime"<?php echo $hearings->HearingTime->cellAttributes() ?>>
<span id="el<?php echo $hearings_list->RowCnt ?>_hearings_HearingTime" class="hearings_HearingTime">
<span<?php echo $hearings->HearingTime->viewAttributes() ?>>
<?php echo $hearings->HearingTime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hearings->NextHearingDate->Visible) { // NextHearingDate ?>
		<td data-name="NextHearingDate"<?php echo $hearings->NextHearingDate->cellAttributes() ?>>
<span id="el<?php echo $hearings_list->RowCnt ?>_hearings_NextHearingDate" class="hearings_NextHearingDate">
<span<?php echo $hearings->NextHearingDate->viewAttributes() ?>>
<?php echo $hearings->NextHearingDate->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hearings->NextHearingTime->Visible) { // NextHearingTime ?>
		<td data-name="NextHearingTime"<?php echo $hearings->NextHearingTime->cellAttributes() ?>>
<span id="el<?php echo $hearings_list->RowCnt ?>_hearings_NextHearingTime" class="hearings_NextHearingTime">
<span<?php echo $hearings->NextHearingTime->viewAttributes() ?>>
<?php echo $hearings->NextHearingTime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hearings->Hearing->Visible) { // Hearing ?>
		<td data-name="Hearing"<?php echo $hearings->Hearing->cellAttributes() ?>>
<span id="el<?php echo $hearings_list->RowCnt ?>_hearings_Hearing" class="hearings_Hearing">
<span<?php echo $hearings->Hearing->viewAttributes() ?>>
<?php echo $hearings->Hearing->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hearings->Notes->Visible) { // Notes ?>
		<td data-name="Notes"<?php echo $hearings->Notes->cellAttributes() ?>>
<span id="el<?php echo $hearings_list->RowCnt ?>_hearings_Notes" class="hearings_Notes">
<span<?php echo $hearings->Notes->viewAttributes() ?>>
<?php echo $hearings->Notes->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hearings->LawyerID->Visible) { // LawyerID ?>
		<td data-name="LawyerID"<?php echo $hearings->LawyerID->cellAttributes() ?>>
<span id="el<?php echo $hearings_list->RowCnt ?>_hearings_LawyerID" class="hearings_LawyerID">
<span<?php echo $hearings->LawyerID->viewAttributes() ?>>
<?php echo $hearings->LawyerID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hearings->JudgeID->Visible) { // JudgeID ?>
		<td data-name="JudgeID"<?php echo $hearings->JudgeID->cellAttributes() ?>>
<span id="el<?php echo $hearings_list->RowCnt ?>_hearings_JudgeID" class="hearings_JudgeID">
<span<?php echo $hearings->JudgeID->viewAttributes() ?>>
<?php echo $hearings->JudgeID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hearings->CaseNumber->Visible) { // CaseNumber ?>
		<td data-name="CaseNumber"<?php echo $hearings->CaseNumber->cellAttributes() ?>>
<span id="el<?php echo $hearings_list->RowCnt ?>_hearings_CaseNumber" class="hearings_CaseNumber">
<span<?php echo $hearings->CaseNumber->viewAttributes() ?>>
<?php echo $hearings->CaseNumber->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($hearings->CourtID->Visible) { // CourtID ?>
		<td data-name="CourtID"<?php echo $hearings->CourtID->cellAttributes() ?>>
<span id="el<?php echo $hearings_list->RowCnt ?>_hearings_CourtID" class="hearings_CourtID">
<span<?php echo $hearings->CourtID->viewAttributes() ?>>
<?php echo $hearings->CourtID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$hearings_list->ListOptions->render("body", "right", $hearings_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$hearings->isGridAdd())
		$hearings_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$hearings->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($hearings_list->Recordset)
	$hearings_list->Recordset->Close();
?>
<?php if (!$hearings->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$hearings->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($hearings_list->Pager)) $hearings_list->Pager = new PrevNextPager($hearings_list->StartRec, $hearings_list->DisplayRecs, $hearings_list->TotalRecs, $hearings_list->AutoHidePager) ?>
<?php if ($hearings_list->Pager->RecordCount > 0 && $hearings_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($hearings_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $hearings_list->pageUrl() ?>start=<?php echo $hearings_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($hearings_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $hearings_list->pageUrl() ?>start=<?php echo $hearings_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $hearings_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($hearings_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $hearings_list->pageUrl() ?>start=<?php echo $hearings_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($hearings_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $hearings_list->pageUrl() ?>start=<?php echo $hearings_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $hearings_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($hearings_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $hearings_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $hearings_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $hearings_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($hearings_list->TotalRecs > 0 && (!$hearings_list->AutoHidePageSizeSelector || $hearings_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="hearings">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($hearings_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($hearings_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($hearings_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($hearings_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($hearings_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($hearings_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($hearings_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($hearings_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($hearings_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($hearings->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $hearings_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($hearings_list->TotalRecs == 0 && !$hearings->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $hearings_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$hearings_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$hearings->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$hearings->isExport()) { ?>
<script>
ew.scrollableTable("gmp_hearings", "1250px", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$hearings_list->terminate();
?>
