<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$judges_list = new judges_list();

// Run the page
$judges_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$judges_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$judges->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fjudgeslist = currentForm = new ew.Form("fjudgeslist", "list");
fjudgeslist.formKeyCountName = '<?php echo $judges_list->FormKeyCountName ?>';

// Form_CustomValidate event
fjudgeslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fjudgeslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fjudgeslist.lists["x_CourtID"] = <?php echo $judges_list->CourtID->Lookup->toClientList() ?>;
fjudgeslist.lists["x_CourtID"].options = <?php echo JsonEncode($judges_list->CourtID->lookupOptions()) ?>;
fjudgeslist.autoSuggests["x_CourtID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fjudgeslist.lists["x_TitleID"] = <?php echo $judges_list->TitleID->Lookup->toClientList() ?>;
fjudgeslist.lists["x_TitleID"].options = <?php echo JsonEncode($judges_list->TitleID->lookupOptions()) ?>;

// Form object for search
var fjudgeslistsrch = currentSearchForm = new ew.Form("fjudgeslistsrch");

// Filters
fjudgeslistsrch.filterList = <?php echo $judges_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #00FA9A; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$judges->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($judges_list->TotalRecs > 0 && $judges_list->ExportOptions->visible()) { ?>
<?php $judges_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($judges_list->ImportOptions->visible()) { ?>
<?php $judges_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($judges_list->SearchOptions->visible()) { ?>
<?php $judges_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($judges_list->FilterOptions->visible()) { ?>
<?php $judges_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$judges_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$judges->isExport() && !$judges->CurrentAction) { ?>
<form name="fjudgeslistsrch" id="fjudgeslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($judges_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="fjudgeslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="judges">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($judges_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($judges_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $judges_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($judges_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($judges_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($judges_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($judges_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $judges_list->showPageHeader(); ?>
<?php
$judges_list->showMessage();
?>
<?php if ($judges_list->TotalRecs > 0 || $judges->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($judges_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> judges">
<?php if (!$judges->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$judges->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($judges_list->Pager)) $judges_list->Pager = new PrevNextPager($judges_list->StartRec, $judges_list->DisplayRecs, $judges_list->TotalRecs, $judges_list->AutoHidePager) ?>
<?php if ($judges_list->Pager->RecordCount > 0 && $judges_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($judges_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $judges_list->pageUrl() ?>start=<?php echo $judges_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($judges_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $judges_list->pageUrl() ?>start=<?php echo $judges_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $judges_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($judges_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $judges_list->pageUrl() ?>start=<?php echo $judges_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($judges_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $judges_list->pageUrl() ?>start=<?php echo $judges_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $judges_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($judges_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $judges_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $judges_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $judges_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($judges_list->TotalRecs > 0 && (!$judges_list->AutoHidePageSizeSelector || $judges_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="judges">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($judges_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($judges_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($judges_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($judges_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($judges_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($judges_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($judges_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($judges_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($judges_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($judges->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $judges_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fjudgeslist" id="fjudgeslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($judges_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $judges_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="judges">
<div id="gmp_judges" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($judges_list->TotalRecs > 0 || $judges->isGridEdit()) { ?>
<table id="tbl_judgeslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$judges_list->RowType = ROWTYPE_HEADER;

// Render list options
$judges_list->renderListOptions();

// Render list options (header, left)
$judges_list->ListOptions->render("header", "left");
?>
<?php if ($judges->CourtID->Visible) { // CourtID ?>
	<?php if ($judges->sortUrl($judges->CourtID) == "") { ?>
		<th data-name="CourtID" class="<?php echo $judges->CourtID->headerCellClass() ?>"><div id="elh_judges_CourtID" class="judges_CourtID"><div class="ew-table-header-caption"><?php echo $judges->CourtID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CourtID" class="<?php echo $judges->CourtID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $judges->SortUrl($judges->CourtID) ?>',2);"><div id="elh_judges_CourtID" class="judges_CourtID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $judges->CourtID->caption() ?></span><span class="ew-table-header-sort"><?php if ($judges->CourtID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($judges->CourtID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($judges->TitleID->Visible) { // TitleID ?>
	<?php if ($judges->sortUrl($judges->TitleID) == "") { ?>
		<th data-name="TitleID" class="<?php echo $judges->TitleID->headerCellClass() ?>"><div id="elh_judges_TitleID" class="judges_TitleID"><div class="ew-table-header-caption"><?php echo $judges->TitleID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TitleID" class="<?php echo $judges->TitleID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $judges->SortUrl($judges->TitleID) ?>',2);"><div id="elh_judges_TitleID" class="judges_TitleID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $judges->TitleID->caption() ?></span><span class="ew-table-header-sort"><?php if ($judges->TitleID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($judges->TitleID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($judges->FirstName->Visible) { // FirstName ?>
	<?php if ($judges->sortUrl($judges->FirstName) == "") { ?>
		<th data-name="FirstName" class="<?php echo $judges->FirstName->headerCellClass() ?>"><div id="elh_judges_FirstName" class="judges_FirstName"><div class="ew-table-header-caption"><?php echo $judges->FirstName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FirstName" class="<?php echo $judges->FirstName->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $judges->SortUrl($judges->FirstName) ?>',2);"><div id="elh_judges_FirstName" class="judges_FirstName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $judges->FirstName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($judges->FirstName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($judges->FirstName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($judges->MiddleName->Visible) { // MiddleName ?>
	<?php if ($judges->sortUrl($judges->MiddleName) == "") { ?>
		<th data-name="MiddleName" class="<?php echo $judges->MiddleName->headerCellClass() ?>"><div id="elh_judges_MiddleName" class="judges_MiddleName"><div class="ew-table-header-caption"><?php echo $judges->MiddleName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="MiddleName" class="<?php echo $judges->MiddleName->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $judges->SortUrl($judges->MiddleName) ?>',2);"><div id="elh_judges_MiddleName" class="judges_MiddleName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $judges->MiddleName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($judges->MiddleName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($judges->MiddleName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($judges->LastName->Visible) { // LastName ?>
	<?php if ($judges->sortUrl($judges->LastName) == "") { ?>
		<th data-name="LastName" class="<?php echo $judges->LastName->headerCellClass() ?>"><div id="elh_judges_LastName" class="judges_LastName"><div class="ew-table-header-caption"><?php echo $judges->LastName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LastName" class="<?php echo $judges->LastName->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $judges->SortUrl($judges->LastName) ?>',2);"><div id="elh_judges_LastName" class="judges_LastName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $judges->LastName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($judges->LastName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($judges->LastName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$judges_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($judges->ExportAll && $judges->isExport()) {
	$judges_list->StopRec = $judges_list->TotalRecs;
} else {

	// Set the last record to display
	if ($judges_list->TotalRecs > $judges_list->StartRec + $judges_list->DisplayRecs - 1)
		$judges_list->StopRec = $judges_list->StartRec + $judges_list->DisplayRecs - 1;
	else
		$judges_list->StopRec = $judges_list->TotalRecs;
}
$judges_list->RecCnt = $judges_list->StartRec - 1;
if ($judges_list->Recordset && !$judges_list->Recordset->EOF) {
	$judges_list->Recordset->moveFirst();
	$selectLimit = $judges_list->UseSelectLimit;
	if (!$selectLimit && $judges_list->StartRec > 1)
		$judges_list->Recordset->move($judges_list->StartRec - 1);
} elseif (!$judges->AllowAddDeleteRow && $judges_list->StopRec == 0) {
	$judges_list->StopRec = $judges->GridAddRowCount;
}

// Initialize aggregate
$judges->RowType = ROWTYPE_AGGREGATEINIT;
$judges->resetAttributes();
$judges_list->renderRow();
while ($judges_list->RecCnt < $judges_list->StopRec) {
	$judges_list->RecCnt++;
	if ($judges_list->RecCnt >= $judges_list->StartRec) {
		$judges_list->RowCnt++;

		// Set up key count
		$judges_list->KeyCount = $judges_list->RowIndex;

		// Init row class and style
		$judges->resetAttributes();
		$judges->CssClass = "";
		if ($judges->isGridAdd()) {
		} else {
			$judges_list->loadRowValues($judges_list->Recordset); // Load row values
		}
		$judges->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$judges->RowAttrs = array_merge($judges->RowAttrs, array('data-rowindex'=>$judges_list->RowCnt, 'id'=>'r' . $judges_list->RowCnt . '_judges', 'data-rowtype'=>$judges->RowType));

		// Render row
		$judges_list->renderRow();

		// Render list options
		$judges_list->renderListOptions();
?>
	<tr<?php echo $judges->rowAttributes() ?>>
<?php

// Render list options (body, left)
$judges_list->ListOptions->render("body", "left", $judges_list->RowCnt);
?>
	<?php if ($judges->CourtID->Visible) { // CourtID ?>
		<td data-name="CourtID"<?php echo $judges->CourtID->cellAttributes() ?>>
<span id="el<?php echo $judges_list->RowCnt ?>_judges_CourtID" class="judges_CourtID">
<span<?php echo $judges->CourtID->viewAttributes() ?>>
<?php echo $judges->CourtID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($judges->TitleID->Visible) { // TitleID ?>
		<td data-name="TitleID"<?php echo $judges->TitleID->cellAttributes() ?>>
<span id="el<?php echo $judges_list->RowCnt ?>_judges_TitleID" class="judges_TitleID">
<span<?php echo $judges->TitleID->viewAttributes() ?>>
<?php echo $judges->TitleID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($judges->FirstName->Visible) { // FirstName ?>
		<td data-name="FirstName"<?php echo $judges->FirstName->cellAttributes() ?>>
<span id="el<?php echo $judges_list->RowCnt ?>_judges_FirstName" class="judges_FirstName">
<span<?php echo $judges->FirstName->viewAttributes() ?>>
<?php echo $judges->FirstName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($judges->MiddleName->Visible) { // MiddleName ?>
		<td data-name="MiddleName"<?php echo $judges->MiddleName->cellAttributes() ?>>
<span id="el<?php echo $judges_list->RowCnt ?>_judges_MiddleName" class="judges_MiddleName">
<span<?php echo $judges->MiddleName->viewAttributes() ?>>
<?php echo $judges->MiddleName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($judges->LastName->Visible) { // LastName ?>
		<td data-name="LastName"<?php echo $judges->LastName->cellAttributes() ?>>
<span id="el<?php echo $judges_list->RowCnt ?>_judges_LastName" class="judges_LastName">
<span<?php echo $judges->LastName->viewAttributes() ?>>
<?php echo $judges->LastName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$judges_list->ListOptions->render("body", "right", $judges_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$judges->isGridAdd())
		$judges_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$judges->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($judges_list->Recordset)
	$judges_list->Recordset->Close();
?>
<?php if (!$judges->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$judges->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($judges_list->Pager)) $judges_list->Pager = new PrevNextPager($judges_list->StartRec, $judges_list->DisplayRecs, $judges_list->TotalRecs, $judges_list->AutoHidePager) ?>
<?php if ($judges_list->Pager->RecordCount > 0 && $judges_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($judges_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $judges_list->pageUrl() ?>start=<?php echo $judges_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($judges_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $judges_list->pageUrl() ?>start=<?php echo $judges_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $judges_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($judges_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $judges_list->pageUrl() ?>start=<?php echo $judges_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($judges_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $judges_list->pageUrl() ?>start=<?php echo $judges_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $judges_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($judges_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $judges_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $judges_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $judges_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($judges_list->TotalRecs > 0 && (!$judges_list->AutoHidePageSizeSelector || $judges_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="judges">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($judges_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($judges_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($judges_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($judges_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($judges_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($judges_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($judges_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($judges_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($judges_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($judges->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $judges_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($judges_list->TotalRecs == 0 && !$judges->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $judges_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$judges_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$judges->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$judges->isExport()) { ?>
<script>
ew.scrollableTable("gmp_judges", "1250px", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$judges_list->terminate();
?>
