<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$lawyercontact_list = new lawyercontact_list();

// Run the page
$lawyercontact_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$lawyercontact_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$lawyercontact->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var flawyercontactlist = currentForm = new ew.Form("flawyercontactlist", "list");
flawyercontactlist.formKeyCountName = '<?php echo $lawyercontact_list->FormKeyCountName ?>';

// Form_CustomValidate event
flawyercontactlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
flawyercontactlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
flawyercontactlist.lists["x_LawyerID"] = <?php echo $lawyercontact_list->LawyerID->Lookup->toClientList() ?>;
flawyercontactlist.lists["x_LawyerID"].options = <?php echo JsonEncode($lawyercontact_list->LawyerID->lookupOptions()) ?>;
flawyercontactlist.lists["x_ContactTypeID"] = <?php echo $lawyercontact_list->ContactTypeID->Lookup->toClientList() ?>;
flawyercontactlist.lists["x_ContactTypeID"].options = <?php echo JsonEncode($lawyercontact_list->ContactTypeID->lookupOptions()) ?>;
flawyercontactlist.lists["x_Primary[]"] = <?php echo $lawyercontact_list->Primary->Lookup->toClientList() ?>;
flawyercontactlist.lists["x_Primary[]"].options = <?php echo JsonEncode($lawyercontact_list->Primary->options(FALSE, TRUE)) ?>;

// Form object for search
var flawyercontactlistsrch = currentSearchForm = new ew.Form("flawyercontactlistsrch");

// Validate function for search
flawyercontactlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
flawyercontactlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
flawyercontactlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
flawyercontactlistsrch.lists["x_Primary[]"] = <?php echo $lawyercontact_list->Primary->Lookup->toClientList() ?>;
flawyercontactlistsrch.lists["x_Primary[]"].options = <?php echo JsonEncode($lawyercontact_list->Primary->options(FALSE, TRUE)) ?>;

// Filters
flawyercontactlistsrch.filterList = <?php echo $lawyercontact_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$lawyercontact->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($lawyercontact_list->TotalRecs > 0 && $lawyercontact_list->ExportOptions->visible()) { ?>
<?php $lawyercontact_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($lawyercontact_list->ImportOptions->visible()) { ?>
<?php $lawyercontact_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($lawyercontact_list->SearchOptions->visible()) { ?>
<?php $lawyercontact_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($lawyercontact_list->FilterOptions->visible()) { ?>
<?php $lawyercontact_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$lawyercontact->isExport() || EXPORT_MASTER_RECORD && $lawyercontact->isExport("print")) { ?>
<?php
if ($lawyercontact_list->DbMasterFilter <> "" && $lawyercontact->getCurrentMasterTable() == "lawyers") {
	if ($lawyercontact_list->MasterRecordExists) {
		include_once "lawyersmaster.php";
	}
}
?>
<?php } ?>
<?php
$lawyercontact_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$lawyercontact->isExport() && !$lawyercontact->CurrentAction) { ?>
<form name="flawyercontactlistsrch" id="flawyercontactlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($lawyercontact_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="flawyercontactlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="lawyercontact">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$lawyercontact_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$lawyercontact->RowType = ROWTYPE_SEARCH;

// Render row
$lawyercontact->resetAttributes();
$lawyercontact_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($lawyercontact->Primary->Visible) { // Primary ?>
	<div id="xsc_Primary" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $lawyercontact->Primary->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Primary" id="z_Primary" value="="></span>
		<span class="ew-search-field">
<?php
$selwrk = (ConvertToBool($lawyercontact->Primary->AdvancedSearch->SearchValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="lawyercontact" data-field="x_Primary" name="x_Primary[]" id="x_Primary[]" value="1"<?php echo $selwrk ?><?php echo $lawyercontact->Primary->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($lawyercontact_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($lawyercontact_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $lawyercontact_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($lawyercontact_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($lawyercontact_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($lawyercontact_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($lawyercontact_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $lawyercontact_list->showPageHeader(); ?>
<?php
$lawyercontact_list->showMessage();
?>
<?php if ($lawyercontact_list->TotalRecs > 0 || $lawyercontact->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($lawyercontact_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> lawyercontact">
<?php if (!$lawyercontact->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$lawyercontact->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($lawyercontact_list->Pager)) $lawyercontact_list->Pager = new PrevNextPager($lawyercontact_list->StartRec, $lawyercontact_list->DisplayRecs, $lawyercontact_list->TotalRecs, $lawyercontact_list->AutoHidePager) ?>
<?php if ($lawyercontact_list->Pager->RecordCount > 0 && $lawyercontact_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($lawyercontact_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $lawyercontact_list->pageUrl() ?>start=<?php echo $lawyercontact_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($lawyercontact_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $lawyercontact_list->pageUrl() ?>start=<?php echo $lawyercontact_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $lawyercontact_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($lawyercontact_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $lawyercontact_list->pageUrl() ?>start=<?php echo $lawyercontact_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($lawyercontact_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $lawyercontact_list->pageUrl() ?>start=<?php echo $lawyercontact_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $lawyercontact_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($lawyercontact_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $lawyercontact_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $lawyercontact_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $lawyercontact_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($lawyercontact_list->TotalRecs > 0 && (!$lawyercontact_list->AutoHidePageSizeSelector || $lawyercontact_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="lawyercontact">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($lawyercontact_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($lawyercontact_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($lawyercontact_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($lawyercontact_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($lawyercontact_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($lawyercontact_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($lawyercontact_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($lawyercontact_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($lawyercontact_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($lawyercontact->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $lawyercontact_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="flawyercontactlist" id="flawyercontactlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($lawyercontact_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $lawyercontact_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="lawyercontact">
<?php if ($lawyercontact->getCurrentMasterTable() == "lawyers" && $lawyercontact->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="lawyers">
<input type="hidden" name="fk_LawyerID" value="<?php echo $lawyercontact->LawyerID->getSessionValue() ?>">
<?php } ?>
<div id="gmp_lawyercontact" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($lawyercontact_list->TotalRecs > 0 || $lawyercontact->isGridEdit()) { ?>
<table id="tbl_lawyercontactlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$lawyercontact_list->RowType = ROWTYPE_HEADER;

// Render list options
$lawyercontact_list->renderListOptions();

// Render list options (header, left)
$lawyercontact_list->ListOptions->render("header", "left");
?>
<?php if ($lawyercontact->LawyerID->Visible) { // LawyerID ?>
	<?php if ($lawyercontact->sortUrl($lawyercontact->LawyerID) == "") { ?>
		<th data-name="LawyerID" class="<?php echo $lawyercontact->LawyerID->headerCellClass() ?>"><div id="elh_lawyercontact_LawyerID" class="lawyercontact_LawyerID"><div class="ew-table-header-caption"><?php echo $lawyercontact->LawyerID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LawyerID" class="<?php echo $lawyercontact->LawyerID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $lawyercontact->SortUrl($lawyercontact->LawyerID) ?>',2);"><div id="elh_lawyercontact_LawyerID" class="lawyercontact_LawyerID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyercontact->LawyerID->caption() ?></span><span class="ew-table-header-sort"><?php if ($lawyercontact->LawyerID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyercontact->LawyerID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyercontact->ContactTypeID->Visible) { // ContactTypeID ?>
	<?php if ($lawyercontact->sortUrl($lawyercontact->ContactTypeID) == "") { ?>
		<th data-name="ContactTypeID" class="<?php echo $lawyercontact->ContactTypeID->headerCellClass() ?>"><div id="elh_lawyercontact_ContactTypeID" class="lawyercontact_ContactTypeID"><div class="ew-table-header-caption"><?php echo $lawyercontact->ContactTypeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ContactTypeID" class="<?php echo $lawyercontact->ContactTypeID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $lawyercontact->SortUrl($lawyercontact->ContactTypeID) ?>',2);"><div id="elh_lawyercontact_ContactTypeID" class="lawyercontact_ContactTypeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyercontact->ContactTypeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($lawyercontact->ContactTypeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyercontact->ContactTypeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyercontact->Contact->Visible) { // Contact ?>
	<?php if ($lawyercontact->sortUrl($lawyercontact->Contact) == "") { ?>
		<th data-name="Contact" class="<?php echo $lawyercontact->Contact->headerCellClass() ?>"><div id="elh_lawyercontact_Contact" class="lawyercontact_Contact"><div class="ew-table-header-caption"><?php echo $lawyercontact->Contact->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Contact" class="<?php echo $lawyercontact->Contact->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $lawyercontact->SortUrl($lawyercontact->Contact) ?>',2);"><div id="elh_lawyercontact_Contact" class="lawyercontact_Contact">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyercontact->Contact->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lawyercontact->Contact->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyercontact->Contact->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyercontact->Notes->Visible) { // Notes ?>
	<?php if ($lawyercontact->sortUrl($lawyercontact->Notes) == "") { ?>
		<th data-name="Notes" class="<?php echo $lawyercontact->Notes->headerCellClass() ?>"><div id="elh_lawyercontact_Notes" class="lawyercontact_Notes"><div class="ew-table-header-caption"><?php echo $lawyercontact->Notes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Notes" class="<?php echo $lawyercontact->Notes->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $lawyercontact->SortUrl($lawyercontact->Notes) ?>',2);"><div id="elh_lawyercontact_Notes" class="lawyercontact_Notes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyercontact->Notes->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lawyercontact->Notes->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyercontact->Notes->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyercontact->Primary->Visible) { // Primary ?>
	<?php if ($lawyercontact->sortUrl($lawyercontact->Primary) == "") { ?>
		<th data-name="Primary" class="<?php echo $lawyercontact->Primary->headerCellClass() ?>"><div id="elh_lawyercontact_Primary" class="lawyercontact_Primary"><div class="ew-table-header-caption"><?php echo $lawyercontact->Primary->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Primary" class="<?php echo $lawyercontact->Primary->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $lawyercontact->SortUrl($lawyercontact->Primary) ?>',2);"><div id="elh_lawyercontact_Primary" class="lawyercontact_Primary">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyercontact->Primary->caption() ?></span><span class="ew-table-header-sort"><?php if ($lawyercontact->Primary->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyercontact->Primary->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$lawyercontact_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($lawyercontact->ExportAll && $lawyercontact->isExport()) {
	$lawyercontact_list->StopRec = $lawyercontact_list->TotalRecs;
} else {

	// Set the last record to display
	if ($lawyercontact_list->TotalRecs > $lawyercontact_list->StartRec + $lawyercontact_list->DisplayRecs - 1)
		$lawyercontact_list->StopRec = $lawyercontact_list->StartRec + $lawyercontact_list->DisplayRecs - 1;
	else
		$lawyercontact_list->StopRec = $lawyercontact_list->TotalRecs;
}
$lawyercontact_list->RecCnt = $lawyercontact_list->StartRec - 1;
if ($lawyercontact_list->Recordset && !$lawyercontact_list->Recordset->EOF) {
	$lawyercontact_list->Recordset->moveFirst();
	$selectLimit = $lawyercontact_list->UseSelectLimit;
	if (!$selectLimit && $lawyercontact_list->StartRec > 1)
		$lawyercontact_list->Recordset->move($lawyercontact_list->StartRec - 1);
} elseif (!$lawyercontact->AllowAddDeleteRow && $lawyercontact_list->StopRec == 0) {
	$lawyercontact_list->StopRec = $lawyercontact->GridAddRowCount;
}

// Initialize aggregate
$lawyercontact->RowType = ROWTYPE_AGGREGATEINIT;
$lawyercontact->resetAttributes();
$lawyercontact_list->renderRow();
while ($lawyercontact_list->RecCnt < $lawyercontact_list->StopRec) {
	$lawyercontact_list->RecCnt++;
	if ($lawyercontact_list->RecCnt >= $lawyercontact_list->StartRec) {
		$lawyercontact_list->RowCnt++;

		// Set up key count
		$lawyercontact_list->KeyCount = $lawyercontact_list->RowIndex;

		// Init row class and style
		$lawyercontact->resetAttributes();
		$lawyercontact->CssClass = "";
		if ($lawyercontact->isGridAdd()) {
		} else {
			$lawyercontact_list->loadRowValues($lawyercontact_list->Recordset); // Load row values
		}
		$lawyercontact->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$lawyercontact->RowAttrs = array_merge($lawyercontact->RowAttrs, array('data-rowindex'=>$lawyercontact_list->RowCnt, 'id'=>'r' . $lawyercontact_list->RowCnt . '_lawyercontact', 'data-rowtype'=>$lawyercontact->RowType));

		// Render row
		$lawyercontact_list->renderRow();

		// Render list options
		$lawyercontact_list->renderListOptions();
?>
	<tr<?php echo $lawyercontact->rowAttributes() ?>>
<?php

// Render list options (body, left)
$lawyercontact_list->ListOptions->render("body", "left", $lawyercontact_list->RowCnt);
?>
	<?php if ($lawyercontact->LawyerID->Visible) { // LawyerID ?>
		<td data-name="LawyerID"<?php echo $lawyercontact->LawyerID->cellAttributes() ?>>
<span id="el<?php echo $lawyercontact_list->RowCnt ?>_lawyercontact_LawyerID" class="lawyercontact_LawyerID">
<span<?php echo $lawyercontact->LawyerID->viewAttributes() ?>>
<?php echo $lawyercontact->LawyerID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lawyercontact->ContactTypeID->Visible) { // ContactTypeID ?>
		<td data-name="ContactTypeID"<?php echo $lawyercontact->ContactTypeID->cellAttributes() ?>>
<span id="el<?php echo $lawyercontact_list->RowCnt ?>_lawyercontact_ContactTypeID" class="lawyercontact_ContactTypeID">
<span<?php echo $lawyercontact->ContactTypeID->viewAttributes() ?>>
<?php echo $lawyercontact->ContactTypeID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lawyercontact->Contact->Visible) { // Contact ?>
		<td data-name="Contact"<?php echo $lawyercontact->Contact->cellAttributes() ?>>
<span id="el<?php echo $lawyercontact_list->RowCnt ?>_lawyercontact_Contact" class="lawyercontact_Contact">
<span<?php echo $lawyercontact->Contact->viewAttributes() ?>>
<?php echo $lawyercontact->Contact->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lawyercontact->Notes->Visible) { // Notes ?>
		<td data-name="Notes"<?php echo $lawyercontact->Notes->cellAttributes() ?>>
<span id="el<?php echo $lawyercontact_list->RowCnt ?>_lawyercontact_Notes" class="lawyercontact_Notes">
<span<?php echo $lawyercontact->Notes->viewAttributes() ?>>
<?php echo $lawyercontact->Notes->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lawyercontact->Primary->Visible) { // Primary ?>
		<td data-name="Primary"<?php echo $lawyercontact->Primary->cellAttributes() ?>>
<span id="el<?php echo $lawyercontact_list->RowCnt ?>_lawyercontact_Primary" class="lawyercontact_Primary">
<span<?php echo $lawyercontact->Primary->viewAttributes() ?>>
<?php if (ConvertToBool($lawyercontact->Primary->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $lawyercontact->Primary->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $lawyercontact->Primary->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$lawyercontact_list->ListOptions->render("body", "right", $lawyercontact_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$lawyercontact->isGridAdd())
		$lawyercontact_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$lawyercontact->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($lawyercontact_list->Recordset)
	$lawyercontact_list->Recordset->Close();
?>
<?php if (!$lawyercontact->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$lawyercontact->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($lawyercontact_list->Pager)) $lawyercontact_list->Pager = new PrevNextPager($lawyercontact_list->StartRec, $lawyercontact_list->DisplayRecs, $lawyercontact_list->TotalRecs, $lawyercontact_list->AutoHidePager) ?>
<?php if ($lawyercontact_list->Pager->RecordCount > 0 && $lawyercontact_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($lawyercontact_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $lawyercontact_list->pageUrl() ?>start=<?php echo $lawyercontact_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($lawyercontact_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $lawyercontact_list->pageUrl() ?>start=<?php echo $lawyercontact_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $lawyercontact_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($lawyercontact_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $lawyercontact_list->pageUrl() ?>start=<?php echo $lawyercontact_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($lawyercontact_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $lawyercontact_list->pageUrl() ?>start=<?php echo $lawyercontact_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $lawyercontact_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($lawyercontact_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $lawyercontact_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $lawyercontact_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $lawyercontact_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($lawyercontact_list->TotalRecs > 0 && (!$lawyercontact_list->AutoHidePageSizeSelector || $lawyercontact_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="lawyercontact">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($lawyercontact_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($lawyercontact_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($lawyercontact_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($lawyercontact_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($lawyercontact_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($lawyercontact_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($lawyercontact_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($lawyercontact_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($lawyercontact_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($lawyercontact->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $lawyercontact_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($lawyercontact_list->TotalRecs == 0 && !$lawyercontact->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $lawyercontact_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$lawyercontact_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$lawyercontact->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$lawyercontact->isExport()) { ?>
<script>
ew.scrollableTable("gmp_lawyercontact", "", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$lawyercontact_list->terminate();
?>
