<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$lawyercontact_preview = new lawyercontact_preview();

// Run the page
$lawyercontact_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$lawyercontact_preview->Page_Render();
?>
<?php $lawyercontact_preview->showPageHeader(); ?>
<div class="card ew-grid lawyercontact"><!-- .card -->
<?php if ($lawyercontact_preview->TotalRecs > 0) { ?>
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$lawyercontact_preview->renderListOptions();

// Render list options (header, left)
$lawyercontact_preview->ListOptions->render("header", "left");
?>
<?php if ($lawyercontact->LawyerID->Visible) { // LawyerID ?>
	<?php if ($lawyercontact->SortUrl($lawyercontact->LawyerID) == "") { ?>
		<th class="<?php echo $lawyercontact->LawyerID->headerCellClass() ?>"><?php echo $lawyercontact->LawyerID->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $lawyercontact->LawyerID->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $lawyercontact->LawyerID->Name ?>" data-sort-order="<?php echo $lawyercontact_preview->SortField == $lawyercontact->LawyerID->Name && $lawyercontact_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $lawyercontact->LawyerID->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($lawyercontact_preview->SortField == $lawyercontact->LawyerID->Name) { ?><?php if ($lawyercontact_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($lawyercontact_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyercontact->ContactTypeID->Visible) { // ContactTypeID ?>
	<?php if ($lawyercontact->SortUrl($lawyercontact->ContactTypeID) == "") { ?>
		<th class="<?php echo $lawyercontact->ContactTypeID->headerCellClass() ?>"><?php echo $lawyercontact->ContactTypeID->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $lawyercontact->ContactTypeID->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $lawyercontact->ContactTypeID->Name ?>" data-sort-order="<?php echo $lawyercontact_preview->SortField == $lawyercontact->ContactTypeID->Name && $lawyercontact_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $lawyercontact->ContactTypeID->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($lawyercontact_preview->SortField == $lawyercontact->ContactTypeID->Name) { ?><?php if ($lawyercontact_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($lawyercontact_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyercontact->Contact->Visible) { // Contact ?>
	<?php if ($lawyercontact->SortUrl($lawyercontact->Contact) == "") { ?>
		<th class="<?php echo $lawyercontact->Contact->headerCellClass() ?>"><?php echo $lawyercontact->Contact->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $lawyercontact->Contact->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $lawyercontact->Contact->Name ?>" data-sort-order="<?php echo $lawyercontact_preview->SortField == $lawyercontact->Contact->Name && $lawyercontact_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $lawyercontact->Contact->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($lawyercontact_preview->SortField == $lawyercontact->Contact->Name) { ?><?php if ($lawyercontact_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($lawyercontact_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyercontact->Notes->Visible) { // Notes ?>
	<?php if ($lawyercontact->SortUrl($lawyercontact->Notes) == "") { ?>
		<th class="<?php echo $lawyercontact->Notes->headerCellClass() ?>"><?php echo $lawyercontact->Notes->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $lawyercontact->Notes->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $lawyercontact->Notes->Name ?>" data-sort-order="<?php echo $lawyercontact_preview->SortField == $lawyercontact->Notes->Name && $lawyercontact_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $lawyercontact->Notes->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($lawyercontact_preview->SortField == $lawyercontact->Notes->Name) { ?><?php if ($lawyercontact_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($lawyercontact_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyercontact->Primary->Visible) { // Primary ?>
	<?php if ($lawyercontact->SortUrl($lawyercontact->Primary) == "") { ?>
		<th class="<?php echo $lawyercontact->Primary->headerCellClass() ?>"><?php echo $lawyercontact->Primary->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $lawyercontact->Primary->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo $lawyercontact->Primary->Name ?>" data-sort-order="<?php echo $lawyercontact_preview->SortField == $lawyercontact->Primary->Name && $lawyercontact_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>"><div class="ew-table-header-btn">
		<span class="ew-table-header-caption"><?php echo $lawyercontact->Primary->caption() ?></span>
		<span class="ew-table-header-sort"><?php if ($lawyercontact_preview->SortField == $lawyercontact->Primary->Name) { ?><?php if ($lawyercontact_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up ew-sort-up"></span><?php } elseif ($lawyercontact_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
	</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$lawyercontact_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$lawyercontact_preview->RecCount = 0;
$lawyercontact_preview->RowCnt = 0;
while ($lawyercontact_preview->Recordset && !$lawyercontact_preview->Recordset->EOF) {

	// Init row class and style
	$lawyercontact_preview->RecCount++;
	$lawyercontact_preview->RowCnt++;
	$lawyercontact_preview->CssStyle = "";
	$lawyercontact_preview->loadListRowValues($lawyercontact_preview->Recordset);

	// Render row
	$lawyercontact_preview->RowType = ROWTYPE_PREVIEW; // Preview record
	$lawyercontact_preview->resetAttributes();
	$lawyercontact_preview->renderListRow();

	// Render list options
	$lawyercontact_preview->renderListOptions();
?>
	<tr<?php echo $lawyercontact_preview->rowAttributes() ?>>
<?php

// Render list options (body, left)
$lawyercontact_preview->ListOptions->render("body", "left", $lawyercontact_preview->RowCnt);
?>
<?php if ($lawyercontact->LawyerID->Visible) { // LawyerID ?>
		<!-- LawyerID -->
		<td<?php echo $lawyercontact->LawyerID->cellAttributes() ?>>
<span<?php echo $lawyercontact->LawyerID->viewAttributes() ?>>
<?php echo $lawyercontact->LawyerID->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($lawyercontact->ContactTypeID->Visible) { // ContactTypeID ?>
		<!-- ContactTypeID -->
		<td<?php echo $lawyercontact->ContactTypeID->cellAttributes() ?>>
<span<?php echo $lawyercontact->ContactTypeID->viewAttributes() ?>>
<?php echo $lawyercontact->ContactTypeID->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($lawyercontact->Contact->Visible) { // Contact ?>
		<!-- Contact -->
		<td<?php echo $lawyercontact->Contact->cellAttributes() ?>>
<span<?php echo $lawyercontact->Contact->viewAttributes() ?>>
<?php echo $lawyercontact->Contact->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($lawyercontact->Notes->Visible) { // Notes ?>
		<!-- Notes -->
		<td<?php echo $lawyercontact->Notes->cellAttributes() ?>>
<span<?php echo $lawyercontact->Notes->viewAttributes() ?>>
<?php echo $lawyercontact->Notes->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($lawyercontact->Primary->Visible) { // Primary ?>
		<!-- Primary -->
		<td<?php echo $lawyercontact->Primary->cellAttributes() ?>>
<span<?php echo $lawyercontact->Primary->viewAttributes() ?>>
<?php if (ConvertToBool($lawyercontact->Primary->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $lawyercontact->Primary->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $lawyercontact->Primary->getViewValue() ?>" disabled>
<?php } ?>
</span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$lawyercontact_preview->ListOptions->render("body", "right", $lawyercontact_preview->RowCnt);
?>
	</tr>
<?php
	$lawyercontact_preview->Recordset->MoveNext();
}
?>
	</tbody>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<?php } ?>
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php if ($lawyercontact_preview->TotalRecs > 0) { ?>
<?php if (!isset($lawyercontact_preview->Pager)) $lawyercontact_preview->Pager = new PrevNextPager($lawyercontact_preview->StartRec, $lawyercontact_preview->DisplayRecs, $lawyercontact_preview->TotalRecs) ?>
<?php if ($lawyercontact_preview->Pager->RecordCount > 0 && $lawyercontact_preview->Pager->Visible) { ?>
<div class="ew-pager"><div class="ew-prev-next"><div class="btn-group btn-group-sm ew-btn-group">
<!--first page button-->
	<?php if ($lawyercontact_preview->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" data-start="<?php echo $lawyercontact_preview->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($lawyercontact_preview->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" data-start="<?php echo $lawyercontact_preview->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
<!--next page button-->
	<?php if ($lawyercontact_preview->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" data-start="<?php echo $lawyercontact_preview->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($lawyercontact_preview->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" data-start="<?php echo $lawyercontact_preview->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div></div></div>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->phrase("Record") ?>&nbsp;<?php echo $lawyercontact_preview->Pager->FromIndex ?>&nbsp;<?php echo $Language->phrase("To") ?>&nbsp;<?php echo $lawyercontact_preview->Pager->ToIndex ?>&nbsp;<?php echo $Language->phrase("Of") ?>&nbsp;<?php echo $lawyercontact_preview->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php } else { ?>
<div class="ew-detail-count"><?php echo $Language->Phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($lawyercontact_preview->OtherOptions as &$option)
		$option->render("body");
?>
</div>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php
$lawyercontact_preview->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php
if ($lawyercontact_preview->Recordset)
	$lawyercontact_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$lawyercontact_preview->terminate();
?>
