<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$lawyers_addopt = new lawyers_addopt();

// Run the page
$lawyers_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$lawyers_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var flawyersaddopt = currentForm = new ew.Form("flawyersaddopt", "addopt");

// Validate form
flawyersaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($lawyers_addopt->LawyerTypeID->Required) { ?>
			elm = this.getElements("x" + infix + "_LawyerTypeID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lawyers->LawyerTypeID->caption(), $lawyers->LawyerTypeID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($lawyers_addopt->FirmID->Required) { ?>
			elm = this.getElements("x" + infix + "_FirmID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lawyers->FirmID->caption(), $lawyers->FirmID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($lawyers_addopt->FirmName->Required) { ?>
			elm = this.getElements("x" + infix + "_FirmName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lawyers->FirmName->caption(), $lawyers->FirmName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($lawyers_addopt->TitleID->Required) { ?>
			elm = this.getElements("x" + infix + "_TitleID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lawyers->TitleID->caption(), $lawyers->TitleID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($lawyers_addopt->FirstName->Required) { ?>
			elm = this.getElements("x" + infix + "_FirstName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lawyers->FirstName->caption(), $lawyers->FirstName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($lawyers_addopt->MiddleName->Required) { ?>
			elm = this.getElements("x" + infix + "_MiddleName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lawyers->MiddleName->caption(), $lawyers->MiddleName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($lawyers_addopt->LastName->Required) { ?>
			elm = this.getElements("x" + infix + "_LastName");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lawyers->LastName->caption(), $lawyers->LastName->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($lawyers_addopt->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $lawyers->Notes->caption(), $lawyers->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
flawyersaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
flawyersaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
flawyersaddopt.lists["x_LawyerTypeID"] = <?php echo $lawyers_addopt->LawyerTypeID->Lookup->toClientList() ?>;
flawyersaddopt.lists["x_LawyerTypeID"].options = <?php echo JsonEncode($lawyers_addopt->LawyerTypeID->lookupOptions()) ?>;
flawyersaddopt.lists["x_FirmID"] = <?php echo $lawyers_addopt->FirmID->Lookup->toClientList() ?>;
flawyersaddopt.lists["x_FirmID"].options = <?php echo JsonEncode($lawyers_addopt->FirmID->lookupOptions()) ?>;
flawyersaddopt.lists["x_TitleID"] = <?php echo $lawyers_addopt->TitleID->Lookup->toClientList() ?>;
flawyersaddopt.lists["x_TitleID"].options = <?php echo JsonEncode($lawyers_addopt->TitleID->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $lawyers_addopt->showPageHeader(); ?>
<?php
$lawyers_addopt->showMessage();
?>
<form name="flawyersaddopt" id="flawyersaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($lawyers_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $lawyers_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $lawyers_addopt->TableVar ?>">
<?php if ($lawyers->LawyerTypeID->Visible) { // LawyerTypeID ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_LawyerTypeID"><?php echo $lawyers->LawyerTypeID->caption() ?><?php echo ($lawyers->LawyerTypeID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="lawyers" data-field="x_LawyerTypeID" data-value-separator="<?php echo $lawyers->LawyerTypeID->displayValueSeparatorAttribute() ?>" id="x_LawyerTypeID" name="x_LawyerTypeID"<?php echo $lawyers->LawyerTypeID->editAttributes() ?>>
		<?php echo $lawyers->LawyerTypeID->selectOptionListHtml("x_LawyerTypeID") ?>
	</select>
</div>
<?php echo $lawyers->LawyerTypeID->Lookup->getParamTag("p_x_LawyerTypeID") ?>
</div>
	</div>
<?php } ?>
<?php if ($lawyers->FirmID->Visible) { // FirmID ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_FirmID"><?php echo $lawyers->FirmID->caption() ?><?php echo ($lawyers->FirmID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="lawyers" data-field="x_FirmID" data-value-separator="<?php echo $lawyers->FirmID->displayValueSeparatorAttribute() ?>" id="x_FirmID" name="x_FirmID"<?php echo $lawyers->FirmID->editAttributes() ?>>
		<?php echo $lawyers->FirmID->selectOptionListHtml("x_FirmID") ?>
	</select>
</div>
<?php echo $lawyers->FirmID->Lookup->getParamTag("p_x_FirmID") ?>
</div>
	</div>
<?php } ?>
<?php if ($lawyers->FirmName->Visible) { // FirmName ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_FirmName"><?php echo $lawyers->FirmName->caption() ?><?php echo ($lawyers->FirmName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="lawyers" data-field="x_FirmName" name="x_FirmName" id="x_FirmName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($lawyers->FirmName->getPlaceHolder()) ?>" value="<?php echo $lawyers->FirmName->EditValue ?>"<?php echo $lawyers->FirmName->editAttributes() ?>>
</div>
	</div>
<?php } ?>
<?php if ($lawyers->TitleID->Visible) { // TitleID ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_TitleID"><?php echo $lawyers->TitleID->caption() ?><?php echo ($lawyers->TitleID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="lawyers" data-field="x_TitleID" data-value-separator="<?php echo $lawyers->TitleID->displayValueSeparatorAttribute() ?>" id="x_TitleID" name="x_TitleID"<?php echo $lawyers->TitleID->editAttributes() ?>>
		<?php echo $lawyers->TitleID->selectOptionListHtml("x_TitleID") ?>
	</select>
</div>
<?php echo $lawyers->TitleID->Lookup->getParamTag("p_x_TitleID") ?>
</div>
	</div>
<?php } ?>
<?php if ($lawyers->FirstName->Visible) { // FirstName ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_FirstName"><?php echo $lawyers->FirstName->caption() ?><?php echo ($lawyers->FirstName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="lawyers" data-field="x_FirstName" name="x_FirstName" id="x_FirstName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($lawyers->FirstName->getPlaceHolder()) ?>" value="<?php echo $lawyers->FirstName->EditValue ?>"<?php echo $lawyers->FirstName->editAttributes() ?>>
</div>
	</div>
<?php } ?>
<?php if ($lawyers->MiddleName->Visible) { // MiddleName ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_MiddleName"><?php echo $lawyers->MiddleName->caption() ?><?php echo ($lawyers->MiddleName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="lawyers" data-field="x_MiddleName" name="x_MiddleName" id="x_MiddleName" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($lawyers->MiddleName->getPlaceHolder()) ?>" value="<?php echo $lawyers->MiddleName->EditValue ?>"<?php echo $lawyers->MiddleName->editAttributes() ?>>
</div>
	</div>
<?php } ?>
<?php if ($lawyers->LastName->Visible) { // LastName ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_LastName"><?php echo $lawyers->LastName->caption() ?><?php echo ($lawyers->LastName->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="lawyers" data-field="x_LastName" name="x_LastName" id="x_LastName" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($lawyers->LastName->getPlaceHolder()) ?>" value="<?php echo $lawyers->LastName->EditValue ?>"<?php echo $lawyers->LastName->editAttributes() ?>>
</div>
	</div>
<?php } ?>
<?php if ($lawyers->Notes->Visible) { // Notes ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_Notes"><?php echo $lawyers->Notes->caption() ?><?php echo ($lawyers->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="lawyers" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($lawyers->Notes->getPlaceHolder()) ?>"<?php echo $lawyers->Notes->editAttributes() ?>><?php echo $lawyers->Notes->EditValue ?></textarea>
</div>
	</div>
<?php } ?>
</form>
<?php
$lawyers_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$lawyers_addopt->terminate();
?>
