<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$lawyers_list = new lawyers_list();

// Run the page
$lawyers_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$lawyers_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$lawyers->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var flawyerslist = currentForm = new ew.Form("flawyerslist", "list");
flawyerslist.formKeyCountName = '<?php echo $lawyers_list->FormKeyCountName ?>';

// Form_CustomValidate event
flawyerslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
flawyerslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
flawyerslist.lists["x_LawyerTypeID"] = <?php echo $lawyers_list->LawyerTypeID->Lookup->toClientList() ?>;
flawyerslist.lists["x_LawyerTypeID"].options = <?php echo JsonEncode($lawyers_list->LawyerTypeID->lookupOptions()) ?>;
flawyerslist.lists["x_FirmID"] = <?php echo $lawyers_list->FirmID->Lookup->toClientList() ?>;
flawyerslist.lists["x_FirmID"].options = <?php echo JsonEncode($lawyers_list->FirmID->lookupOptions()) ?>;
flawyerslist.lists["x_TitleID"] = <?php echo $lawyers_list->TitleID->Lookup->toClientList() ?>;
flawyerslist.lists["x_TitleID"].options = <?php echo JsonEncode($lawyers_list->TitleID->lookupOptions()) ?>;

// Form object for search
var flawyerslistsrch = currentSearchForm = new ew.Form("flawyerslistsrch");

// Filters
flawyerslistsrch.filterList = <?php echo $lawyers_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFF00; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$lawyers->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($lawyers_list->TotalRecs > 0 && $lawyers_list->ExportOptions->visible()) { ?>
<?php $lawyers_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($lawyers_list->ImportOptions->visible()) { ?>
<?php $lawyers_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($lawyers_list->SearchOptions->visible()) { ?>
<?php $lawyers_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($lawyers_list->FilterOptions->visible()) { ?>
<?php $lawyers_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$lawyers_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$lawyers->isExport() && !$lawyers->CurrentAction) { ?>
<form name="flawyerslistsrch" id="flawyerslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($lawyers_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="flawyerslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="lawyers">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($lawyers_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($lawyers_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $lawyers_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($lawyers_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($lawyers_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($lawyers_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($lawyers_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $lawyers_list->showPageHeader(); ?>
<?php
$lawyers_list->showMessage();
?>
<?php if ($lawyers_list->TotalRecs > 0 || $lawyers->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($lawyers_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> lawyers">
<?php if (!$lawyers->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$lawyers->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($lawyers_list->Pager)) $lawyers_list->Pager = new PrevNextPager($lawyers_list->StartRec, $lawyers_list->DisplayRecs, $lawyers_list->TotalRecs, $lawyers_list->AutoHidePager) ?>
<?php if ($lawyers_list->Pager->RecordCount > 0 && $lawyers_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($lawyers_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $lawyers_list->pageUrl() ?>start=<?php echo $lawyers_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($lawyers_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $lawyers_list->pageUrl() ?>start=<?php echo $lawyers_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $lawyers_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($lawyers_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $lawyers_list->pageUrl() ?>start=<?php echo $lawyers_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($lawyers_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $lawyers_list->pageUrl() ?>start=<?php echo $lawyers_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $lawyers_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($lawyers_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $lawyers_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $lawyers_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $lawyers_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($lawyers_list->TotalRecs > 0 && (!$lawyers_list->AutoHidePageSizeSelector || $lawyers_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="lawyers">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($lawyers_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($lawyers_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($lawyers_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($lawyers_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($lawyers_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($lawyers_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($lawyers_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($lawyers_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($lawyers_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($lawyers->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $lawyers_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="flawyerslist" id="flawyerslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($lawyers_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $lawyers_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="lawyers">
<div id="gmp_lawyers" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($lawyers_list->TotalRecs > 0 || $lawyers->isGridEdit()) { ?>
<table id="tbl_lawyerslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$lawyers_list->RowType = ROWTYPE_HEADER;

// Render list options
$lawyers_list->renderListOptions();

// Render list options (header, left)
$lawyers_list->ListOptions->render("header", "left");
?>
<?php if ($lawyers->LawyerTypeID->Visible) { // LawyerTypeID ?>
	<?php if ($lawyers->sortUrl($lawyers->LawyerTypeID) == "") { ?>
		<th data-name="LawyerTypeID" class="<?php echo $lawyers->LawyerTypeID->headerCellClass() ?>"><div id="elh_lawyers_LawyerTypeID" class="lawyers_LawyerTypeID"><div class="ew-table-header-caption"><?php echo $lawyers->LawyerTypeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LawyerTypeID" class="<?php echo $lawyers->LawyerTypeID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $lawyers->SortUrl($lawyers->LawyerTypeID) ?>',2);"><div id="elh_lawyers_LawyerTypeID" class="lawyers_LawyerTypeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyers->LawyerTypeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($lawyers->LawyerTypeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyers->LawyerTypeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyers->SyndicateNumber->Visible) { // SyndicateNumber ?>
	<?php if ($lawyers->sortUrl($lawyers->SyndicateNumber) == "") { ?>
		<th data-name="SyndicateNumber" class="<?php echo $lawyers->SyndicateNumber->headerCellClass() ?>"><div id="elh_lawyers_SyndicateNumber" class="lawyers_SyndicateNumber"><div class="ew-table-header-caption"><?php echo $lawyers->SyndicateNumber->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SyndicateNumber" class="<?php echo $lawyers->SyndicateNumber->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $lawyers->SortUrl($lawyers->SyndicateNumber) ?>',2);"><div id="elh_lawyers_SyndicateNumber" class="lawyers_SyndicateNumber">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyers->SyndicateNumber->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lawyers->SyndicateNumber->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyers->SyndicateNumber->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyers->FirmID->Visible) { // FirmID ?>
	<?php if ($lawyers->sortUrl($lawyers->FirmID) == "") { ?>
		<th data-name="FirmID" class="<?php echo $lawyers->FirmID->headerCellClass() ?>"><div id="elh_lawyers_FirmID" class="lawyers_FirmID"><div class="ew-table-header-caption"><?php echo $lawyers->FirmID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FirmID" class="<?php echo $lawyers->FirmID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $lawyers->SortUrl($lawyers->FirmID) ?>',2);"><div id="elh_lawyers_FirmID" class="lawyers_FirmID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyers->FirmID->caption() ?></span><span class="ew-table-header-sort"><?php if ($lawyers->FirmID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyers->FirmID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyers->TitleID->Visible) { // TitleID ?>
	<?php if ($lawyers->sortUrl($lawyers->TitleID) == "") { ?>
		<th data-name="TitleID" class="<?php echo $lawyers->TitleID->headerCellClass() ?>"><div id="elh_lawyers_TitleID" class="lawyers_TitleID"><div class="ew-table-header-caption"><?php echo $lawyers->TitleID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TitleID" class="<?php echo $lawyers->TitleID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $lawyers->SortUrl($lawyers->TitleID) ?>',2);"><div id="elh_lawyers_TitleID" class="lawyers_TitleID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyers->TitleID->caption() ?></span><span class="ew-table-header-sort"><?php if ($lawyers->TitleID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyers->TitleID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyers->FirstName->Visible) { // FirstName ?>
	<?php if ($lawyers->sortUrl($lawyers->FirstName) == "") { ?>
		<th data-name="FirstName" class="<?php echo $lawyers->FirstName->headerCellClass() ?>"><div id="elh_lawyers_FirstName" class="lawyers_FirstName"><div class="ew-table-header-caption"><?php echo $lawyers->FirstName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FirstName" class="<?php echo $lawyers->FirstName->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $lawyers->SortUrl($lawyers->FirstName) ?>',2);"><div id="elh_lawyers_FirstName" class="lawyers_FirstName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyers->FirstName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lawyers->FirstName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyers->FirstName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyers->MiddleName->Visible) { // MiddleName ?>
	<?php if ($lawyers->sortUrl($lawyers->MiddleName) == "") { ?>
		<th data-name="MiddleName" class="<?php echo $lawyers->MiddleName->headerCellClass() ?>"><div id="elh_lawyers_MiddleName" class="lawyers_MiddleName"><div class="ew-table-header-caption"><?php echo $lawyers->MiddleName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="MiddleName" class="<?php echo $lawyers->MiddleName->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $lawyers->SortUrl($lawyers->MiddleName) ?>',2);"><div id="elh_lawyers_MiddleName" class="lawyers_MiddleName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyers->MiddleName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lawyers->MiddleName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyers->MiddleName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($lawyers->LastName->Visible) { // LastName ?>
	<?php if ($lawyers->sortUrl($lawyers->LastName) == "") { ?>
		<th data-name="LastName" class="<?php echo $lawyers->LastName->headerCellClass() ?>"><div id="elh_lawyers_LastName" class="lawyers_LastName"><div class="ew-table-header-caption"><?php echo $lawyers->LastName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LastName" class="<?php echo $lawyers->LastName->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $lawyers->SortUrl($lawyers->LastName) ?>',2);"><div id="elh_lawyers_LastName" class="lawyers_LastName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $lawyers->LastName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($lawyers->LastName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($lawyers->LastName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$lawyers_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($lawyers->ExportAll && $lawyers->isExport()) {
	$lawyers_list->StopRec = $lawyers_list->TotalRecs;
} else {

	// Set the last record to display
	if ($lawyers_list->TotalRecs > $lawyers_list->StartRec + $lawyers_list->DisplayRecs - 1)
		$lawyers_list->StopRec = $lawyers_list->StartRec + $lawyers_list->DisplayRecs - 1;
	else
		$lawyers_list->StopRec = $lawyers_list->TotalRecs;
}
$lawyers_list->RecCnt = $lawyers_list->StartRec - 1;
if ($lawyers_list->Recordset && !$lawyers_list->Recordset->EOF) {
	$lawyers_list->Recordset->moveFirst();
	$selectLimit = $lawyers_list->UseSelectLimit;
	if (!$selectLimit && $lawyers_list->StartRec > 1)
		$lawyers_list->Recordset->move($lawyers_list->StartRec - 1);
} elseif (!$lawyers->AllowAddDeleteRow && $lawyers_list->StopRec == 0) {
	$lawyers_list->StopRec = $lawyers->GridAddRowCount;
}

// Initialize aggregate
$lawyers->RowType = ROWTYPE_AGGREGATEINIT;
$lawyers->resetAttributes();
$lawyers_list->renderRow();
while ($lawyers_list->RecCnt < $lawyers_list->StopRec) {
	$lawyers_list->RecCnt++;
	if ($lawyers_list->RecCnt >= $lawyers_list->StartRec) {
		$lawyers_list->RowCnt++;

		// Set up key count
		$lawyers_list->KeyCount = $lawyers_list->RowIndex;

		// Init row class and style
		$lawyers->resetAttributes();
		$lawyers->CssClass = "";
		if ($lawyers->isGridAdd()) {
		} else {
			$lawyers_list->loadRowValues($lawyers_list->Recordset); // Load row values
		}
		$lawyers->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$lawyers->RowAttrs = array_merge($lawyers->RowAttrs, array('data-rowindex'=>$lawyers_list->RowCnt, 'id'=>'r' . $lawyers_list->RowCnt . '_lawyers', 'data-rowtype'=>$lawyers->RowType));

		// Render row
		$lawyers_list->renderRow();

		// Render list options
		$lawyers_list->renderListOptions();
?>
	<tr<?php echo $lawyers->rowAttributes() ?>>
<?php

// Render list options (body, left)
$lawyers_list->ListOptions->render("body", "left", $lawyers_list->RowCnt);
?>
	<?php if ($lawyers->LawyerTypeID->Visible) { // LawyerTypeID ?>
		<td data-name="LawyerTypeID"<?php echo $lawyers->LawyerTypeID->cellAttributes() ?>>
<span id="el<?php echo $lawyers_list->RowCnt ?>_lawyers_LawyerTypeID" class="lawyers_LawyerTypeID">
<span<?php echo $lawyers->LawyerTypeID->viewAttributes() ?>>
<?php echo $lawyers->LawyerTypeID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lawyers->SyndicateNumber->Visible) { // SyndicateNumber ?>
		<td data-name="SyndicateNumber"<?php echo $lawyers->SyndicateNumber->cellAttributes() ?>>
<span id="el<?php echo $lawyers_list->RowCnt ?>_lawyers_SyndicateNumber" class="lawyers_SyndicateNumber">
<span<?php echo $lawyers->SyndicateNumber->viewAttributes() ?>>
<?php echo $lawyers->SyndicateNumber->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lawyers->FirmID->Visible) { // FirmID ?>
		<td data-name="FirmID"<?php echo $lawyers->FirmID->cellAttributes() ?>>
<span id="el<?php echo $lawyers_list->RowCnt ?>_lawyers_FirmID" class="lawyers_FirmID">
<span<?php echo $lawyers->FirmID->viewAttributes() ?>>
<?php echo $lawyers->FirmID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lawyers->TitleID->Visible) { // TitleID ?>
		<td data-name="TitleID"<?php echo $lawyers->TitleID->cellAttributes() ?>>
<span id="el<?php echo $lawyers_list->RowCnt ?>_lawyers_TitleID" class="lawyers_TitleID">
<span<?php echo $lawyers->TitleID->viewAttributes() ?>>
<?php echo $lawyers->TitleID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lawyers->FirstName->Visible) { // FirstName ?>
		<td data-name="FirstName"<?php echo $lawyers->FirstName->cellAttributes() ?>>
<span id="el<?php echo $lawyers_list->RowCnt ?>_lawyers_FirstName" class="lawyers_FirstName">
<span<?php echo $lawyers->FirstName->viewAttributes() ?>>
<?php echo $lawyers->FirstName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lawyers->MiddleName->Visible) { // MiddleName ?>
		<td data-name="MiddleName"<?php echo $lawyers->MiddleName->cellAttributes() ?>>
<span id="el<?php echo $lawyers_list->RowCnt ?>_lawyers_MiddleName" class="lawyers_MiddleName">
<span<?php echo $lawyers->MiddleName->viewAttributes() ?>>
<?php echo $lawyers->MiddleName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($lawyers->LastName->Visible) { // LastName ?>
		<td data-name="LastName"<?php echo $lawyers->LastName->cellAttributes() ?>>
<span id="el<?php echo $lawyers_list->RowCnt ?>_lawyers_LastName" class="lawyers_LastName">
<span<?php echo $lawyers->LastName->viewAttributes() ?>>
<?php echo $lawyers->LastName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$lawyers_list->ListOptions->render("body", "right", $lawyers_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$lawyers->isGridAdd())
		$lawyers_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$lawyers->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($lawyers_list->Recordset)
	$lawyers_list->Recordset->Close();
?>
<?php if (!$lawyers->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$lawyers->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($lawyers_list->Pager)) $lawyers_list->Pager = new PrevNextPager($lawyers_list->StartRec, $lawyers_list->DisplayRecs, $lawyers_list->TotalRecs, $lawyers_list->AutoHidePager) ?>
<?php if ($lawyers_list->Pager->RecordCount > 0 && $lawyers_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($lawyers_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $lawyers_list->pageUrl() ?>start=<?php echo $lawyers_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($lawyers_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $lawyers_list->pageUrl() ?>start=<?php echo $lawyers_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $lawyers_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($lawyers_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $lawyers_list->pageUrl() ?>start=<?php echo $lawyers_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($lawyers_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $lawyers_list->pageUrl() ?>start=<?php echo $lawyers_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $lawyers_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($lawyers_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $lawyers_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $lawyers_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $lawyers_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($lawyers_list->TotalRecs > 0 && (!$lawyers_list->AutoHidePageSizeSelector || $lawyers_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="lawyers">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($lawyers_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($lawyers_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($lawyers_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($lawyers_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($lawyers_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($lawyers_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($lawyers_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($lawyers_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($lawyers_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($lawyers->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $lawyers_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($lawyers_list->TotalRecs == 0 && !$lawyers->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $lawyers_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$lawyers_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$lawyers->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$lawyers->isExport()) { ?>
<script>
ew.scrollableTable("gmp_lawyers", "1250px", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$lawyers_list->terminate();
?>
