<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$lawyers_view = new lawyers_view();

// Run the page
$lawyers_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$lawyers_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$lawyers->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var flawyersview = currentForm = new ew.Form("flawyersview", "view");

// Form_CustomValidate event
flawyersview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
flawyersview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
flawyersview.lists["x_LawyerTypeID"] = <?php echo $lawyers_view->LawyerTypeID->Lookup->toClientList() ?>;
flawyersview.lists["x_LawyerTypeID"].options = <?php echo JsonEncode($lawyers_view->LawyerTypeID->lookupOptions()) ?>;
flawyersview.lists["x_FirmID"] = <?php echo $lawyers_view->FirmID->Lookup->toClientList() ?>;
flawyersview.lists["x_FirmID"].options = <?php echo JsonEncode($lawyers_view->FirmID->lookupOptions()) ?>;
flawyersview.lists["x_TitleID"] = <?php echo $lawyers_view->TitleID->Lookup->toClientList() ?>;
flawyersview.lists["x_TitleID"].options = <?php echo JsonEncode($lawyers_view->TitleID->lookupOptions()) ?>;
flawyersview.lists["x_Activated[]"] = <?php echo $lawyers_view->Activated->Lookup->toClientList() ?>;
flawyersview.lists["x_Activated[]"].options = <?php echo JsonEncode($lawyers_view->Activated->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$lawyers->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $lawyers_view->ExportOptions->render("body") ?>
<?php $lawyers_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $lawyers_view->showPageHeader(); ?>
<?php
$lawyers_view->showMessage();
?>
<?php if (!$lawyers_view->IsModal) { ?>
<?php if (!$lawyers->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($lawyers_view->Pager)) $lawyers_view->Pager = new PrevNextPager($lawyers_view->StartRec, $lawyers_view->DisplayRecs, $lawyers_view->TotalRecs, $lawyers_view->AutoHidePager) ?>
<?php if ($lawyers_view->Pager->RecordCount > 0 && $lawyers_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($lawyers_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $lawyers_view->pageUrl() ?>start=<?php echo $lawyers_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($lawyers_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $lawyers_view->pageUrl() ?>start=<?php echo $lawyers_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $lawyers_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($lawyers_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $lawyers_view->pageUrl() ?>start=<?php echo $lawyers_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($lawyers_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $lawyers_view->pageUrl() ?>start=<?php echo $lawyers_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $lawyers_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="flawyersview" id="flawyersview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($lawyers_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $lawyers_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="lawyers">
<input type="hidden" name="modal" value="<?php echo (int)$lawyers_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($lawyers->LawyerID->Visible) { // LawyerID ?>
	<tr id="r_LawyerID">
		<td class="<?php echo $lawyers_view->TableLeftColumnClass ?>"><span id="elh_lawyers_LawyerID"><?php echo $lawyers->LawyerID->caption() ?></span></td>
		<td data-name="LawyerID"<?php echo $lawyers->LawyerID->cellAttributes() ?>>
<span id="el_lawyers_LawyerID">
<span<?php echo $lawyers->LawyerID->viewAttributes() ?>>
<?php echo $lawyers->LawyerID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($lawyers->LawyerTypeID->Visible) { // LawyerTypeID ?>
	<tr id="r_LawyerTypeID">
		<td class="<?php echo $lawyers_view->TableLeftColumnClass ?>"><span id="elh_lawyers_LawyerTypeID"><?php echo $lawyers->LawyerTypeID->caption() ?></span></td>
		<td data-name="LawyerTypeID"<?php echo $lawyers->LawyerTypeID->cellAttributes() ?>>
<span id="el_lawyers_LawyerTypeID">
<span<?php echo $lawyers->LawyerTypeID->viewAttributes() ?>>
<?php echo $lawyers->LawyerTypeID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($lawyers->SyndicateNumber->Visible) { // SyndicateNumber ?>
	<tr id="r_SyndicateNumber">
		<td class="<?php echo $lawyers_view->TableLeftColumnClass ?>"><span id="elh_lawyers_SyndicateNumber"><?php echo $lawyers->SyndicateNumber->caption() ?></span></td>
		<td data-name="SyndicateNumber"<?php echo $lawyers->SyndicateNumber->cellAttributes() ?>>
<span id="el_lawyers_SyndicateNumber">
<span<?php echo $lawyers->SyndicateNumber->viewAttributes() ?>>
<?php echo $lawyers->SyndicateNumber->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($lawyers->FirmID->Visible) { // FirmID ?>
	<tr id="r_FirmID">
		<td class="<?php echo $lawyers_view->TableLeftColumnClass ?>"><span id="elh_lawyers_FirmID"><?php echo $lawyers->FirmID->caption() ?></span></td>
		<td data-name="FirmID"<?php echo $lawyers->FirmID->cellAttributes() ?>>
<span id="el_lawyers_FirmID">
<span<?php echo $lawyers->FirmID->viewAttributes() ?>>
<?php echo $lawyers->FirmID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($lawyers->TitleID->Visible) { // TitleID ?>
	<tr id="r_TitleID">
		<td class="<?php echo $lawyers_view->TableLeftColumnClass ?>"><span id="elh_lawyers_TitleID"><?php echo $lawyers->TitleID->caption() ?></span></td>
		<td data-name="TitleID"<?php echo $lawyers->TitleID->cellAttributes() ?>>
<span id="el_lawyers_TitleID">
<span<?php echo $lawyers->TitleID->viewAttributes() ?>>
<?php echo $lawyers->TitleID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($lawyers->FirstName->Visible) { // FirstName ?>
	<tr id="r_FirstName">
		<td class="<?php echo $lawyers_view->TableLeftColumnClass ?>"><span id="elh_lawyers_FirstName"><?php echo $lawyers->FirstName->caption() ?></span></td>
		<td data-name="FirstName"<?php echo $lawyers->FirstName->cellAttributes() ?>>
<span id="el_lawyers_FirstName">
<span<?php echo $lawyers->FirstName->viewAttributes() ?>>
<?php echo $lawyers->FirstName->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($lawyers->MiddleName->Visible) { // MiddleName ?>
	<tr id="r_MiddleName">
		<td class="<?php echo $lawyers_view->TableLeftColumnClass ?>"><span id="elh_lawyers_MiddleName"><?php echo $lawyers->MiddleName->caption() ?></span></td>
		<td data-name="MiddleName"<?php echo $lawyers->MiddleName->cellAttributes() ?>>
<span id="el_lawyers_MiddleName">
<span<?php echo $lawyers->MiddleName->viewAttributes() ?>>
<?php echo $lawyers->MiddleName->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($lawyers->LastName->Visible) { // LastName ?>
	<tr id="r_LastName">
		<td class="<?php echo $lawyers_view->TableLeftColumnClass ?>"><span id="elh_lawyers_LastName"><?php echo $lawyers->LastName->caption() ?></span></td>
		<td data-name="LastName"<?php echo $lawyers->LastName->cellAttributes() ?>>
<span id="el_lawyers_LastName">
<span<?php echo $lawyers->LastName->viewAttributes() ?>>
<?php echo $lawyers->LastName->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($lawyers->Notes->Visible) { // Notes ?>
	<tr id="r_Notes">
		<td class="<?php echo $lawyers_view->TableLeftColumnClass ?>"><span id="elh_lawyers_Notes"><?php echo $lawyers->Notes->caption() ?></span></td>
		<td data-name="Notes"<?php echo $lawyers->Notes->cellAttributes() ?>>
<span id="el_lawyers_Notes">
<span<?php echo $lawyers->Notes->viewAttributes() ?>>
<?php echo $lawyers->Notes->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($lawyers->Activated->Visible) { // Activated ?>
	<tr id="r_Activated">
		<td class="<?php echo $lawyers_view->TableLeftColumnClass ?>"><span id="elh_lawyers_Activated"><?php echo $lawyers->Activated->caption() ?></span></td>
		<td data-name="Activated"<?php echo $lawyers->Activated->cellAttributes() ?>>
<span id="el_lawyers_Activated">
<span<?php echo $lawyers->Activated->viewAttributes() ?>>
<?php if (ConvertToBool($lawyers->Activated->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $lawyers->Activated->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $lawyers->Activated->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$lawyers_view->IsModal) { ?>
<?php if (!$lawyers->isExport()) { ?>
<?php if (!isset($lawyers_view->Pager)) $lawyers_view->Pager = new PrevNextPager($lawyers_view->StartRec, $lawyers_view->DisplayRecs, $lawyers_view->TotalRecs, $lawyers_view->AutoHidePager) ?>
<?php if ($lawyers_view->Pager->RecordCount > 0 && $lawyers_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($lawyers_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $lawyers_view->pageUrl() ?>start=<?php echo $lawyers_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($lawyers_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $lawyers_view->pageUrl() ?>start=<?php echo $lawyers_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $lawyers_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($lawyers_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $lawyers_view->pageUrl() ?>start=<?php echo $lawyers_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($lawyers_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $lawyers_view->pageUrl() ?>start=<?php echo $lawyers_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $lawyers_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
<?php if ($lawyers->getCurrentDetailTable() <> "") { ?>
<?php
	$lawyers_view->DetailPages->ValidKeys = explode(",", $lawyers->getCurrentDetailTable());
	$firstActiveDetailTable = $lawyers_view->DetailPages->activePageIndex();
?>
<div class="ew-detail-pages"><!-- detail-pages -->
<div class="ew-nav-tabs" id="lawyers_view_details"><!-- tabs -->
	<ul class="<?php echo $lawyers_view->DetailPages->navStyle() ?>"><!-- .nav -->
<?php
	if (in_array("lawyeraddress", explode(",", $lawyers->getCurrentDetailTable())) && $lawyeraddress->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "lawyeraddress") {
			$firstActiveDetailTable = "lawyeraddress";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $lawyers_view->DetailPages->pageStyle("lawyeraddress") ?>" href="#tab_lawyeraddress" data-toggle="tab"><?php echo $Language->TablePhrase("lawyeraddress", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $lawyers_view->lawyeraddress_Count, $Language->phrase("DetailCount")) ?></a></li>
<?php
	}
?>
<?php
	if (in_array("lawyercontact", explode(",", $lawyers->getCurrentDetailTable())) && $lawyercontact->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "lawyercontact") {
			$firstActiveDetailTable = "lawyercontact";
		}
?>
		<li class="nav-item"><a class="nav-link<?php echo $lawyers_view->DetailPages->pageStyle("lawyercontact") ?>" href="#tab_lawyercontact" data-toggle="tab"><?php echo $Language->TablePhrase("lawyercontact", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $lawyers_view->lawyercontact_Count, $Language->phrase("DetailCount")) ?></a></li>
<?php
	}
?>
	</ul><!-- /.nav -->
	<div class="tab-content"><!-- .tab-content -->
<?php
	if (in_array("lawyeraddress", explode(",", $lawyers->getCurrentDetailTable())) && $lawyeraddress->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "lawyeraddress")
			$firstActiveDetailTable = "lawyeraddress";
?>
		<div class="tab-pane<?php echo $lawyers_view->DetailPages->pageStyle("lawyeraddress") ?>" id="tab_lawyeraddress"><!-- page* -->
<?php include_once "lawyeraddressgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
<?php
	if (in_array("lawyercontact", explode(",", $lawyers->getCurrentDetailTable())) && $lawyercontact->DetailView) {
		if ($firstActiveDetailTable == "" || $firstActiveDetailTable == "lawyercontact")
			$firstActiveDetailTable = "lawyercontact";
?>
		<div class="tab-pane<?php echo $lawyers_view->DetailPages->pageStyle("lawyercontact") ?>" id="tab_lawyercontact"><!-- page* -->
<?php include_once "lawyercontactgrid.php" ?>
		</div><!-- /page* -->
<?php } ?>
	</div><!-- /.tab-content -->
</div><!-- /tabs -->
</div><!-- /detail-pages -->
<?php } ?>
</form>
<?php
$lawyers_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$lawyers->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$lawyers_view->terminate();
?>
