<?php
namespace PHPMaker2019\project_germanos;

// Write header
WriteHeader(FALSE);

// Create page object
if (!isset($notifications_grid))
	$notifications_grid = new notifications_grid();

// Run the page
$notifications_grid->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$notifications_grid->Page_Render();
?>
<?php if (!$notifications->isExport()) { ?>
<script>

// Form object
var fnotificationsgrid = new ew.Form("fnotificationsgrid", "grid");
fnotificationsgrid.formKeyCountName = '<?php echo $notifications_grid->FormKeyCountName ?>';

// Validate form
fnotificationsgrid.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
		if (checkrow) {
			addcnt++;
		<?php if ($notifications_grid->CaseNumber->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseNumber");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $notifications->CaseNumber->caption(), $notifications->CaseNumber->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($notifications_grid->Notification->Required) { ?>
			elm = this.getElements("x" + infix + "_Notification");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $notifications->Notification->caption(), $notifications->Notification->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($notifications_grid->NotificationDate->Required) { ?>
			elm = this.getElements("x" + infix + "_NotificationDate");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $notifications->NotificationDate->caption(), $notifications->NotificationDate->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_NotificationDate");
			if (elm && !ew.checkEuroDate(elm.value))
				return this.onError(elm, "<?php echo JsEncode($notifications->NotificationDate->errorMessage()) ?>");
		<?php if ($notifications_grid->NotificationTime->Required) { ?>
			elm = this.getElements("x" + infix + "_NotificationTime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $notifications->NotificationTime->caption(), $notifications->NotificationTime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_NotificationTime");
			if (elm && !ew.checkTime(elm.value))
				return this.onError(elm, "<?php echo JsEncode($notifications->NotificationTime->errorMessage()) ?>");
		<?php if ($notifications_grid->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $notifications->Notes->caption(), $notifications->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
		} // End Grid Add checking
	}
	return true;
}

// Check empty row
fnotificationsgrid.emptyRow = function(infix) {
	var fobj = this._form;
	if (ew.valueChanged(fobj, infix, "CaseNumber", false)) return false;
	if (ew.valueChanged(fobj, infix, "Notification", false)) return false;
	if (ew.valueChanged(fobj, infix, "NotificationDate", false)) return false;
	if (ew.valueChanged(fobj, infix, "NotificationTime", false)) return false;
	if (ew.valueChanged(fobj, infix, "Notes", false)) return false;
	return true;
}

// Form_CustomValidate event
fnotificationsgrid.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fnotificationsgrid.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script src="phpjs/ewscrolltable.js"></script>
<?php } ?>
<?php
$notifications_grid->renderOtherOptions();
?>
<?php $notifications_grid->showPageHeader(); ?>
<?php
$notifications_grid->showMessage();
?>
<?php if ($notifications_grid->TotalRecs > 0 || $notifications->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($notifications_grid->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> notifications">
<?php if ($notifications_grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $notifications_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<div id="fnotificationsgrid" class="ew-form ew-list-form form-inline">
<div id="gmp_notifications" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table id="tbl_notificationsgrid" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$notifications_grid->RowType = ROWTYPE_HEADER;

// Render list options
$notifications_grid->renderListOptions();

// Render list options (header, left)
$notifications_grid->ListOptions->render("header", "left");
?>
<?php if ($notifications->CaseNumber->Visible) { // CaseNumber ?>
	<?php if ($notifications->sortUrl($notifications->CaseNumber) == "") { ?>
		<th data-name="CaseNumber" class="<?php echo $notifications->CaseNumber->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_notifications_CaseNumber" class="notifications_CaseNumber"><div class="ew-table-header-caption"><?php echo $notifications->CaseNumber->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CaseNumber" class="<?php echo $notifications->CaseNumber->headerCellClass() ?>" style="white-space: nowrap;"><div><div id="elh_notifications_CaseNumber" class="notifications_CaseNumber">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $notifications->CaseNumber->caption() ?></span><span class="ew-table-header-sort"><?php if ($notifications->CaseNumber->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($notifications->CaseNumber->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($notifications->Notification->Visible) { // Notification ?>
	<?php if ($notifications->sortUrl($notifications->Notification) == "") { ?>
		<th data-name="Notification" class="<?php echo $notifications->Notification->headerCellClass() ?>"><div id="elh_notifications_Notification" class="notifications_Notification"><div class="ew-table-header-caption"><?php echo $notifications->Notification->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Notification" class="<?php echo $notifications->Notification->headerCellClass() ?>"><div><div id="elh_notifications_Notification" class="notifications_Notification">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $notifications->Notification->caption() ?></span><span class="ew-table-header-sort"><?php if ($notifications->Notification->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($notifications->Notification->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($notifications->NotificationDate->Visible) { // NotificationDate ?>
	<?php if ($notifications->sortUrl($notifications->NotificationDate) == "") { ?>
		<th data-name="NotificationDate" class="<?php echo $notifications->NotificationDate->headerCellClass() ?>"><div id="elh_notifications_NotificationDate" class="notifications_NotificationDate"><div class="ew-table-header-caption"><?php echo $notifications->NotificationDate->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NotificationDate" class="<?php echo $notifications->NotificationDate->headerCellClass() ?>"><div><div id="elh_notifications_NotificationDate" class="notifications_NotificationDate">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $notifications->NotificationDate->caption() ?></span><span class="ew-table-header-sort"><?php if ($notifications->NotificationDate->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($notifications->NotificationDate->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($notifications->NotificationTime->Visible) { // NotificationTime ?>
	<?php if ($notifications->sortUrl($notifications->NotificationTime) == "") { ?>
		<th data-name="NotificationTime" class="<?php echo $notifications->NotificationTime->headerCellClass() ?>"><div id="elh_notifications_NotificationTime" class="notifications_NotificationTime"><div class="ew-table-header-caption"><?php echo $notifications->NotificationTime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NotificationTime" class="<?php echo $notifications->NotificationTime->headerCellClass() ?>"><div><div id="elh_notifications_NotificationTime" class="notifications_NotificationTime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $notifications->NotificationTime->caption() ?></span><span class="ew-table-header-sort"><?php if ($notifications->NotificationTime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($notifications->NotificationTime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($notifications->Notes->Visible) { // Notes ?>
	<?php if ($notifications->sortUrl($notifications->Notes) == "") { ?>
		<th data-name="Notes" class="<?php echo $notifications->Notes->headerCellClass() ?>"><div id="elh_notifications_Notes" class="notifications_Notes"><div class="ew-table-header-caption"><?php echo $notifications->Notes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Notes" class="<?php echo $notifications->Notes->headerCellClass() ?>"><div><div id="elh_notifications_Notes" class="notifications_Notes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $notifications->Notes->caption() ?></span><span class="ew-table-header-sort"><?php if ($notifications->Notes->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($notifications->Notes->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$notifications_grid->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
$notifications_grid->StartRec = 1;
$notifications_grid->StopRec = $notifications_grid->TotalRecs; // Show all records

// Restore number of post back records
if ($CurrentForm && $notifications_grid->EventCancelled) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($notifications_grid->FormKeyCountName) && ($notifications->isGridAdd() || $notifications->isGridEdit() || $notifications->isConfirm())) {
		$notifications_grid->KeyCount = $CurrentForm->getValue($notifications_grid->FormKeyCountName);
		$notifications_grid->StopRec = $notifications_grid->StartRec + $notifications_grid->KeyCount - 1;
	}
}
$notifications_grid->RecCnt = $notifications_grid->StartRec - 1;
if ($notifications_grid->Recordset && !$notifications_grid->Recordset->EOF) {
	$notifications_grid->Recordset->moveFirst();
	$selectLimit = $notifications_grid->UseSelectLimit;
	if (!$selectLimit && $notifications_grid->StartRec > 1)
		$notifications_grid->Recordset->move($notifications_grid->StartRec - 1);
} elseif (!$notifications->AllowAddDeleteRow && $notifications_grid->StopRec == 0) {
	$notifications_grid->StopRec = $notifications->GridAddRowCount;
}

// Initialize aggregate
$notifications->RowType = ROWTYPE_AGGREGATEINIT;
$notifications->resetAttributes();
$notifications_grid->renderRow();
if ($notifications->isGridAdd())
	$notifications_grid->RowIndex = 0;
if ($notifications->isGridEdit())
	$notifications_grid->RowIndex = 0;
while ($notifications_grid->RecCnt < $notifications_grid->StopRec) {
	$notifications_grid->RecCnt++;
	if ($notifications_grid->RecCnt >= $notifications_grid->StartRec) {
		$notifications_grid->RowCnt++;
		if ($notifications->isGridAdd() || $notifications->isGridEdit() || $notifications->isConfirm()) {
			$notifications_grid->RowIndex++;
			$CurrentForm->Index = $notifications_grid->RowIndex;
			if ($CurrentForm->hasValue($notifications_grid->FormActionName) && $notifications_grid->EventCancelled)
				$notifications_grid->RowAction = strval($CurrentForm->getValue($notifications_grid->FormActionName));
			elseif ($notifications->isGridAdd())
				$notifications_grid->RowAction = "insert";
			else
				$notifications_grid->RowAction = "";
		}

		// Set up key count
		$notifications_grid->KeyCount = $notifications_grid->RowIndex;

		// Init row class and style
		$notifications->resetAttributes();
		$notifications->CssClass = "";
		if ($notifications->isGridAdd()) {
			if ($notifications->CurrentMode == "copy") {
				$notifications_grid->loadRowValues($notifications_grid->Recordset); // Load row values
				$notifications_grid->setRecordKey($notifications_grid->RowOldKey, $notifications_grid->Recordset); // Set old record key
			} else {
				$notifications_grid->loadRowValues(); // Load default values
				$notifications_grid->RowOldKey = ""; // Clear old key value
			}
		} else {
			$notifications_grid->loadRowValues($notifications_grid->Recordset); // Load row values
		}
		$notifications->RowType = ROWTYPE_VIEW; // Render view
		if ($notifications->isGridAdd()) // Grid add
			$notifications->RowType = ROWTYPE_ADD; // Render add
		if ($notifications->isGridAdd() && $notifications->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$notifications_grid->restoreCurrentRowFormValues($notifications_grid->RowIndex); // Restore form values
		if ($notifications->isGridEdit()) { // Grid edit
			if ($notifications->EventCancelled)
				$notifications_grid->restoreCurrentRowFormValues($notifications_grid->RowIndex); // Restore form values
			if ($notifications_grid->RowAction == "insert")
				$notifications->RowType = ROWTYPE_ADD; // Render add
			else
				$notifications->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($notifications->isGridEdit() && ($notifications->RowType == ROWTYPE_EDIT || $notifications->RowType == ROWTYPE_ADD) && $notifications->EventCancelled) // Update failed
			$notifications_grid->restoreCurrentRowFormValues($notifications_grid->RowIndex); // Restore form values
		if ($notifications->RowType == ROWTYPE_EDIT) // Edit row
			$notifications_grid->EditRowCnt++;
		if ($notifications->isConfirm()) // Confirm row
			$notifications_grid->restoreCurrentRowFormValues($notifications_grid->RowIndex); // Restore form values

		// Set up row id / data-rowindex
		$notifications->RowAttrs = array_merge($notifications->RowAttrs, array('data-rowindex'=>$notifications_grid->RowCnt, 'id'=>'r' . $notifications_grid->RowCnt . '_notifications', 'data-rowtype'=>$notifications->RowType));

		// Render row
		$notifications_grid->renderRow();

		// Render list options
		$notifications_grid->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($notifications_grid->RowAction <> "delete" && $notifications_grid->RowAction <> "insertdelete" && !($notifications_grid->RowAction == "insert" && $notifications->isConfirm() && $notifications_grid->emptyRow())) {
?>
	<tr<?php echo $notifications->rowAttributes() ?>>
<?php

// Render list options (body, left)
$notifications_grid->ListOptions->render("body", "left", $notifications_grid->RowCnt);
?>
	<?php if ($notifications->CaseNumber->Visible) { // CaseNumber ?>
		<td data-name="CaseNumber"<?php echo $notifications->CaseNumber->cellAttributes() ?>>
<?php if ($notifications->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $notifications_grid->RowCnt ?>_notifications_CaseNumber" class="form-group notifications_CaseNumber">
<input type="text" data-table="notifications" data-field="x_CaseNumber" name="x<?php echo $notifications_grid->RowIndex ?>_CaseNumber" id="x<?php echo $notifications_grid->RowIndex ?>_CaseNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($notifications->CaseNumber->getPlaceHolder()) ?>" value="<?php echo $notifications->CaseNumber->EditValue ?>"<?php echo $notifications->CaseNumber->editAttributes() ?>>
</span>
<input type="hidden" data-table="notifications" data-field="x_CaseNumber" name="o<?php echo $notifications_grid->RowIndex ?>_CaseNumber" id="o<?php echo $notifications_grid->RowIndex ?>_CaseNumber" value="<?php echo HtmlEncode($notifications->CaseNumber->OldValue) ?>">
<?php } ?>
<?php if ($notifications->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $notifications_grid->RowCnt ?>_notifications_CaseNumber" class="form-group notifications_CaseNumber">
<input type="text" data-table="notifications" data-field="x_CaseNumber" name="x<?php echo $notifications_grid->RowIndex ?>_CaseNumber" id="x<?php echo $notifications_grid->RowIndex ?>_CaseNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($notifications->CaseNumber->getPlaceHolder()) ?>" value="<?php echo $notifications->CaseNumber->EditValue ?>"<?php echo $notifications->CaseNumber->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($notifications->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $notifications_grid->RowCnt ?>_notifications_CaseNumber" class="notifications_CaseNumber">
<span<?php echo $notifications->CaseNumber->viewAttributes() ?>>
<?php echo $notifications->CaseNumber->getViewValue() ?></span>
</span>
<?php if (!$notifications->isConfirm()) { ?>
<input type="hidden" data-table="notifications" data-field="x_CaseNumber" name="x<?php echo $notifications_grid->RowIndex ?>_CaseNumber" id="x<?php echo $notifications_grid->RowIndex ?>_CaseNumber" value="<?php echo HtmlEncode($notifications->CaseNumber->FormValue) ?>">
<input type="hidden" data-table="notifications" data-field="x_CaseNumber" name="o<?php echo $notifications_grid->RowIndex ?>_CaseNumber" id="o<?php echo $notifications_grid->RowIndex ?>_CaseNumber" value="<?php echo HtmlEncode($notifications->CaseNumber->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="notifications" data-field="x_CaseNumber" name="fnotificationsgrid$x<?php echo $notifications_grid->RowIndex ?>_CaseNumber" id="fnotificationsgrid$x<?php echo $notifications_grid->RowIndex ?>_CaseNumber" value="<?php echo HtmlEncode($notifications->CaseNumber->FormValue) ?>">
<input type="hidden" data-table="notifications" data-field="x_CaseNumber" name="fnotificationsgrid$o<?php echo $notifications_grid->RowIndex ?>_CaseNumber" id="fnotificationsgrid$o<?php echo $notifications_grid->RowIndex ?>_CaseNumber" value="<?php echo HtmlEncode($notifications->CaseNumber->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php if ($notifications->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="notifications" data-field="x_NotificationID" name="x<?php echo $notifications_grid->RowIndex ?>_NotificationID" id="x<?php echo $notifications_grid->RowIndex ?>_NotificationID" value="<?php echo HtmlEncode($notifications->NotificationID->CurrentValue) ?>">
<input type="hidden" data-table="notifications" data-field="x_NotificationID" name="o<?php echo $notifications_grid->RowIndex ?>_NotificationID" id="o<?php echo $notifications_grid->RowIndex ?>_NotificationID" value="<?php echo HtmlEncode($notifications->NotificationID->OldValue) ?>">
<?php } ?>
<?php if ($notifications->RowType == ROWTYPE_EDIT || $notifications->CurrentMode == "edit") { ?>
<input type="hidden" data-table="notifications" data-field="x_NotificationID" name="x<?php echo $notifications_grid->RowIndex ?>_NotificationID" id="x<?php echo $notifications_grid->RowIndex ?>_NotificationID" value="<?php echo HtmlEncode($notifications->NotificationID->CurrentValue) ?>">
<?php } ?>
	<?php if ($notifications->Notification->Visible) { // Notification ?>
		<td data-name="Notification"<?php echo $notifications->Notification->cellAttributes() ?>>
<?php if ($notifications->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $notifications_grid->RowCnt ?>_notifications_Notification" class="form-group notifications_Notification">
<textarea data-table="notifications" data-field="x_Notification" name="x<?php echo $notifications_grid->RowIndex ?>_Notification" id="x<?php echo $notifications_grid->RowIndex ?>_Notification" cols="35" rows="2" placeholder="<?php echo HtmlEncode($notifications->Notification->getPlaceHolder()) ?>"<?php echo $notifications->Notification->editAttributes() ?>><?php echo $notifications->Notification->EditValue ?></textarea>
</span>
<input type="hidden" data-table="notifications" data-field="x_Notification" name="o<?php echo $notifications_grid->RowIndex ?>_Notification" id="o<?php echo $notifications_grid->RowIndex ?>_Notification" value="<?php echo HtmlEncode($notifications->Notification->OldValue) ?>">
<?php } ?>
<?php if ($notifications->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $notifications_grid->RowCnt ?>_notifications_Notification" class="form-group notifications_Notification">
<textarea data-table="notifications" data-field="x_Notification" name="x<?php echo $notifications_grid->RowIndex ?>_Notification" id="x<?php echo $notifications_grid->RowIndex ?>_Notification" cols="35" rows="2" placeholder="<?php echo HtmlEncode($notifications->Notification->getPlaceHolder()) ?>"<?php echo $notifications->Notification->editAttributes() ?>><?php echo $notifications->Notification->EditValue ?></textarea>
</span>
<?php } ?>
<?php if ($notifications->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $notifications_grid->RowCnt ?>_notifications_Notification" class="notifications_Notification">
<span<?php echo $notifications->Notification->viewAttributes() ?>>
<?php echo $notifications->Notification->getViewValue() ?></span>
</span>
<?php if (!$notifications->isConfirm()) { ?>
<input type="hidden" data-table="notifications" data-field="x_Notification" name="x<?php echo $notifications_grid->RowIndex ?>_Notification" id="x<?php echo $notifications_grid->RowIndex ?>_Notification" value="<?php echo HtmlEncode($notifications->Notification->FormValue) ?>">
<input type="hidden" data-table="notifications" data-field="x_Notification" name="o<?php echo $notifications_grid->RowIndex ?>_Notification" id="o<?php echo $notifications_grid->RowIndex ?>_Notification" value="<?php echo HtmlEncode($notifications->Notification->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="notifications" data-field="x_Notification" name="fnotificationsgrid$x<?php echo $notifications_grid->RowIndex ?>_Notification" id="fnotificationsgrid$x<?php echo $notifications_grid->RowIndex ?>_Notification" value="<?php echo HtmlEncode($notifications->Notification->FormValue) ?>">
<input type="hidden" data-table="notifications" data-field="x_Notification" name="fnotificationsgrid$o<?php echo $notifications_grid->RowIndex ?>_Notification" id="fnotificationsgrid$o<?php echo $notifications_grid->RowIndex ?>_Notification" value="<?php echo HtmlEncode($notifications->Notification->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($notifications->NotificationDate->Visible) { // NotificationDate ?>
		<td data-name="NotificationDate"<?php echo $notifications->NotificationDate->cellAttributes() ?>>
<?php if ($notifications->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $notifications_grid->RowCnt ?>_notifications_NotificationDate" class="form-group notifications_NotificationDate">
<input type="text" data-table="notifications" data-field="x_NotificationDate" data-format="7" name="x<?php echo $notifications_grid->RowIndex ?>_NotificationDate" id="x<?php echo $notifications_grid->RowIndex ?>_NotificationDate" placeholder="<?php echo HtmlEncode($notifications->NotificationDate->getPlaceHolder()) ?>" value="<?php echo $notifications->NotificationDate->EditValue ?>"<?php echo $notifications->NotificationDate->editAttributes() ?>>
<?php if (!$notifications->NotificationDate->ReadOnly && !$notifications->NotificationDate->Disabled && !isset($notifications->NotificationDate->EditAttrs["readonly"]) && !isset($notifications->NotificationDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fnotificationsgrid", "x<?php echo $notifications_grid->RowIndex ?>_NotificationDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="notifications" data-field="x_NotificationDate" name="o<?php echo $notifications_grid->RowIndex ?>_NotificationDate" id="o<?php echo $notifications_grid->RowIndex ?>_NotificationDate" value="<?php echo HtmlEncode($notifications->NotificationDate->OldValue) ?>">
<?php } ?>
<?php if ($notifications->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $notifications_grid->RowCnt ?>_notifications_NotificationDate" class="form-group notifications_NotificationDate">
<input type="text" data-table="notifications" data-field="x_NotificationDate" data-format="7" name="x<?php echo $notifications_grid->RowIndex ?>_NotificationDate" id="x<?php echo $notifications_grid->RowIndex ?>_NotificationDate" placeholder="<?php echo HtmlEncode($notifications->NotificationDate->getPlaceHolder()) ?>" value="<?php echo $notifications->NotificationDate->EditValue ?>"<?php echo $notifications->NotificationDate->editAttributes() ?>>
<?php if (!$notifications->NotificationDate->ReadOnly && !$notifications->NotificationDate->Disabled && !isset($notifications->NotificationDate->EditAttrs["readonly"]) && !isset($notifications->NotificationDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fnotificationsgrid", "x<?php echo $notifications_grid->RowIndex ?>_NotificationDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($notifications->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $notifications_grid->RowCnt ?>_notifications_NotificationDate" class="notifications_NotificationDate">
<span<?php echo $notifications->NotificationDate->viewAttributes() ?>>
<?php echo $notifications->NotificationDate->getViewValue() ?></span>
</span>
<?php if (!$notifications->isConfirm()) { ?>
<input type="hidden" data-table="notifications" data-field="x_NotificationDate" name="x<?php echo $notifications_grid->RowIndex ?>_NotificationDate" id="x<?php echo $notifications_grid->RowIndex ?>_NotificationDate" value="<?php echo HtmlEncode($notifications->NotificationDate->FormValue) ?>">
<input type="hidden" data-table="notifications" data-field="x_NotificationDate" name="o<?php echo $notifications_grid->RowIndex ?>_NotificationDate" id="o<?php echo $notifications_grid->RowIndex ?>_NotificationDate" value="<?php echo HtmlEncode($notifications->NotificationDate->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="notifications" data-field="x_NotificationDate" name="fnotificationsgrid$x<?php echo $notifications_grid->RowIndex ?>_NotificationDate" id="fnotificationsgrid$x<?php echo $notifications_grid->RowIndex ?>_NotificationDate" value="<?php echo HtmlEncode($notifications->NotificationDate->FormValue) ?>">
<input type="hidden" data-table="notifications" data-field="x_NotificationDate" name="fnotificationsgrid$o<?php echo $notifications_grid->RowIndex ?>_NotificationDate" id="fnotificationsgrid$o<?php echo $notifications_grid->RowIndex ?>_NotificationDate" value="<?php echo HtmlEncode($notifications->NotificationDate->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($notifications->NotificationTime->Visible) { // NotificationTime ?>
		<td data-name="NotificationTime"<?php echo $notifications->NotificationTime->cellAttributes() ?>>
<?php if ($notifications->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $notifications_grid->RowCnt ?>_notifications_NotificationTime" class="form-group notifications_NotificationTime">
<input type="text" data-table="notifications" data-field="x_NotificationTime" name="x<?php echo $notifications_grid->RowIndex ?>_NotificationTime" id="x<?php echo $notifications_grid->RowIndex ?>_NotificationTime" placeholder="<?php echo HtmlEncode($notifications->NotificationTime->getPlaceHolder()) ?>" value="<?php echo $notifications->NotificationTime->EditValue ?>"<?php echo $notifications->NotificationTime->editAttributes() ?>>
<?php if (!$notifications->NotificationTime->ReadOnly && !$notifications->NotificationTime->Disabled && !isset($notifications->NotificationTime->EditAttrs["readonly"]) && !isset($notifications->NotificationTime->EditAttrs["disabled"])) { ?>
<script>ew.createTimePicker("fnotificationsgrid", "x<?php echo $notifications_grid->RowIndex ?>_NotificationTime", {"timeFormat":"h:i A","step":15});</script><?php } ?>
</span>
<input type="hidden" data-table="notifications" data-field="x_NotificationTime" name="o<?php echo $notifications_grid->RowIndex ?>_NotificationTime" id="o<?php echo $notifications_grid->RowIndex ?>_NotificationTime" value="<?php echo HtmlEncode($notifications->NotificationTime->OldValue) ?>">
<?php } ?>
<?php if ($notifications->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $notifications_grid->RowCnt ?>_notifications_NotificationTime" class="form-group notifications_NotificationTime">
<input type="text" data-table="notifications" data-field="x_NotificationTime" name="x<?php echo $notifications_grid->RowIndex ?>_NotificationTime" id="x<?php echo $notifications_grid->RowIndex ?>_NotificationTime" placeholder="<?php echo HtmlEncode($notifications->NotificationTime->getPlaceHolder()) ?>" value="<?php echo $notifications->NotificationTime->EditValue ?>"<?php echo $notifications->NotificationTime->editAttributes() ?>>
<?php if (!$notifications->NotificationTime->ReadOnly && !$notifications->NotificationTime->Disabled && !isset($notifications->NotificationTime->EditAttrs["readonly"]) && !isset($notifications->NotificationTime->EditAttrs["disabled"])) { ?>
<script>ew.createTimePicker("fnotificationsgrid", "x<?php echo $notifications_grid->RowIndex ?>_NotificationTime", {"timeFormat":"h:i A","step":15});</script><?php } ?>
</span>
<?php } ?>
<?php if ($notifications->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $notifications_grid->RowCnt ?>_notifications_NotificationTime" class="notifications_NotificationTime">
<span<?php echo $notifications->NotificationTime->viewAttributes() ?>>
<?php echo $notifications->NotificationTime->getViewValue() ?></span>
</span>
<?php if (!$notifications->isConfirm()) { ?>
<input type="hidden" data-table="notifications" data-field="x_NotificationTime" name="x<?php echo $notifications_grid->RowIndex ?>_NotificationTime" id="x<?php echo $notifications_grid->RowIndex ?>_NotificationTime" value="<?php echo HtmlEncode($notifications->NotificationTime->FormValue) ?>">
<input type="hidden" data-table="notifications" data-field="x_NotificationTime" name="o<?php echo $notifications_grid->RowIndex ?>_NotificationTime" id="o<?php echo $notifications_grid->RowIndex ?>_NotificationTime" value="<?php echo HtmlEncode($notifications->NotificationTime->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="notifications" data-field="x_NotificationTime" name="fnotificationsgrid$x<?php echo $notifications_grid->RowIndex ?>_NotificationTime" id="fnotificationsgrid$x<?php echo $notifications_grid->RowIndex ?>_NotificationTime" value="<?php echo HtmlEncode($notifications->NotificationTime->FormValue) ?>">
<input type="hidden" data-table="notifications" data-field="x_NotificationTime" name="fnotificationsgrid$o<?php echo $notifications_grid->RowIndex ?>_NotificationTime" id="fnotificationsgrid$o<?php echo $notifications_grid->RowIndex ?>_NotificationTime" value="<?php echo HtmlEncode($notifications->NotificationTime->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($notifications->Notes->Visible) { // Notes ?>
		<td data-name="Notes"<?php echo $notifications->Notes->cellAttributes() ?>>
<?php if ($notifications->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $notifications_grid->RowCnt ?>_notifications_Notes" class="form-group notifications_Notes">
<?php AppendClass($notifications->Notes->EditAttrs["class"], "editor"); ?>
<textarea data-table="notifications" data-field="x_Notes" name="x<?php echo $notifications_grid->RowIndex ?>_Notes" id="x<?php echo $notifications_grid->RowIndex ?>_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($notifications->Notes->getPlaceHolder()) ?>"<?php echo $notifications->Notes->editAttributes() ?>><?php echo $notifications->Notes->EditValue ?></textarea>
<script>
ew.createEditor("fnotificationsgrid", "x<?php echo $notifications_grid->RowIndex ?>_Notes", 35, 4, <?php echo ($notifications->Notes->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<input type="hidden" data-table="notifications" data-field="x_Notes" name="o<?php echo $notifications_grid->RowIndex ?>_Notes" id="o<?php echo $notifications_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($notifications->Notes->OldValue) ?>">
<?php } ?>
<?php if ($notifications->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $notifications_grid->RowCnt ?>_notifications_Notes" class="form-group notifications_Notes">
<?php AppendClass($notifications->Notes->EditAttrs["class"], "editor"); ?>
<textarea data-table="notifications" data-field="x_Notes" name="x<?php echo $notifications_grid->RowIndex ?>_Notes" id="x<?php echo $notifications_grid->RowIndex ?>_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($notifications->Notes->getPlaceHolder()) ?>"<?php echo $notifications->Notes->editAttributes() ?>><?php echo $notifications->Notes->EditValue ?></textarea>
<script>
ew.createEditor("fnotificationsgrid", "x<?php echo $notifications_grid->RowIndex ?>_Notes", 35, 4, <?php echo ($notifications->Notes->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php } ?>
<?php if ($notifications->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $notifications_grid->RowCnt ?>_notifications_Notes" class="notifications_Notes">
<span<?php echo $notifications->Notes->viewAttributes() ?>>
<?php echo $notifications->Notes->getViewValue() ?></span>
</span>
<?php if (!$notifications->isConfirm()) { ?>
<input type="hidden" data-table="notifications" data-field="x_Notes" name="x<?php echo $notifications_grid->RowIndex ?>_Notes" id="x<?php echo $notifications_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($notifications->Notes->FormValue) ?>">
<input type="hidden" data-table="notifications" data-field="x_Notes" name="o<?php echo $notifications_grid->RowIndex ?>_Notes" id="o<?php echo $notifications_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($notifications->Notes->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="notifications" data-field="x_Notes" name="fnotificationsgrid$x<?php echo $notifications_grid->RowIndex ?>_Notes" id="fnotificationsgrid$x<?php echo $notifications_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($notifications->Notes->FormValue) ?>">
<input type="hidden" data-table="notifications" data-field="x_Notes" name="fnotificationsgrid$o<?php echo $notifications_grid->RowIndex ?>_Notes" id="fnotificationsgrid$o<?php echo $notifications_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($notifications->Notes->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$notifications_grid->ListOptions->render("body", "right", $notifications_grid->RowCnt);
?>
	</tr>
<?php if ($notifications->RowType == ROWTYPE_ADD || $notifications->RowType == ROWTYPE_EDIT) { ?>
<script>
fnotificationsgrid.updateLists(<?php echo $notifications_grid->RowIndex ?>);
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$notifications->isGridAdd() || $notifications->CurrentMode == "copy")
		if (!$notifications_grid->Recordset->EOF)
			$notifications_grid->Recordset->moveNext();
}
?>
<?php
	if ($notifications->CurrentMode == "add" || $notifications->CurrentMode == "copy" || $notifications->CurrentMode == "edit") {
		$notifications_grid->RowIndex = '$rowindex$';
		$notifications_grid->loadRowValues();

		// Set row properties
		$notifications->resetAttributes();
		$notifications->RowAttrs = array_merge($notifications->RowAttrs, array('data-rowindex'=>$notifications_grid->RowIndex, 'id'=>'r0_notifications', 'data-rowtype'=>ROWTYPE_ADD));
		AppendClass($notifications->RowAttrs["class"], "ew-template");
		$notifications->RowType = ROWTYPE_ADD;

		// Render row
		$notifications_grid->renderRow();

		// Render list options
		$notifications_grid->renderListOptions();
		$notifications_grid->StartRowCnt = 0;
?>
	<tr<?php echo $notifications->rowAttributes() ?>>
<?php

// Render list options (body, left)
$notifications_grid->ListOptions->render("body", "left", $notifications_grid->RowIndex);
?>
	<?php if ($notifications->CaseNumber->Visible) { // CaseNumber ?>
		<td data-name="CaseNumber">
<?php if (!$notifications->isConfirm()) { ?>
<span id="el$rowindex$_notifications_CaseNumber" class="form-group notifications_CaseNumber">
<input type="text" data-table="notifications" data-field="x_CaseNumber" name="x<?php echo $notifications_grid->RowIndex ?>_CaseNumber" id="x<?php echo $notifications_grid->RowIndex ?>_CaseNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($notifications->CaseNumber->getPlaceHolder()) ?>" value="<?php echo $notifications->CaseNumber->EditValue ?>"<?php echo $notifications->CaseNumber->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_notifications_CaseNumber" class="form-group notifications_CaseNumber">
<span<?php echo $notifications->CaseNumber->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($notifications->CaseNumber->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="notifications" data-field="x_CaseNumber" name="x<?php echo $notifications_grid->RowIndex ?>_CaseNumber" id="x<?php echo $notifications_grid->RowIndex ?>_CaseNumber" value="<?php echo HtmlEncode($notifications->CaseNumber->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="notifications" data-field="x_CaseNumber" name="o<?php echo $notifications_grid->RowIndex ?>_CaseNumber" id="o<?php echo $notifications_grid->RowIndex ?>_CaseNumber" value="<?php echo HtmlEncode($notifications->CaseNumber->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($notifications->Notification->Visible) { // Notification ?>
		<td data-name="Notification">
<?php if (!$notifications->isConfirm()) { ?>
<span id="el$rowindex$_notifications_Notification" class="form-group notifications_Notification">
<textarea data-table="notifications" data-field="x_Notification" name="x<?php echo $notifications_grid->RowIndex ?>_Notification" id="x<?php echo $notifications_grid->RowIndex ?>_Notification" cols="35" rows="2" placeholder="<?php echo HtmlEncode($notifications->Notification->getPlaceHolder()) ?>"<?php echo $notifications->Notification->editAttributes() ?>><?php echo $notifications->Notification->EditValue ?></textarea>
</span>
<?php } else { ?>
<span id="el$rowindex$_notifications_Notification" class="form-group notifications_Notification">
<span<?php echo $notifications->Notification->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($notifications->Notification->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="notifications" data-field="x_Notification" name="x<?php echo $notifications_grid->RowIndex ?>_Notification" id="x<?php echo $notifications_grid->RowIndex ?>_Notification" value="<?php echo HtmlEncode($notifications->Notification->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="notifications" data-field="x_Notification" name="o<?php echo $notifications_grid->RowIndex ?>_Notification" id="o<?php echo $notifications_grid->RowIndex ?>_Notification" value="<?php echo HtmlEncode($notifications->Notification->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($notifications->NotificationDate->Visible) { // NotificationDate ?>
		<td data-name="NotificationDate">
<?php if (!$notifications->isConfirm()) { ?>
<span id="el$rowindex$_notifications_NotificationDate" class="form-group notifications_NotificationDate">
<input type="text" data-table="notifications" data-field="x_NotificationDate" data-format="7" name="x<?php echo $notifications_grid->RowIndex ?>_NotificationDate" id="x<?php echo $notifications_grid->RowIndex ?>_NotificationDate" placeholder="<?php echo HtmlEncode($notifications->NotificationDate->getPlaceHolder()) ?>" value="<?php echo $notifications->NotificationDate->EditValue ?>"<?php echo $notifications->NotificationDate->editAttributes() ?>>
<?php if (!$notifications->NotificationDate->ReadOnly && !$notifications->NotificationDate->Disabled && !isset($notifications->NotificationDate->EditAttrs["readonly"]) && !isset($notifications->NotificationDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fnotificationsgrid", "x<?php echo $notifications_grid->RowIndex ?>_NotificationDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_notifications_NotificationDate" class="form-group notifications_NotificationDate">
<span<?php echo $notifications->NotificationDate->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($notifications->NotificationDate->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="notifications" data-field="x_NotificationDate" name="x<?php echo $notifications_grid->RowIndex ?>_NotificationDate" id="x<?php echo $notifications_grid->RowIndex ?>_NotificationDate" value="<?php echo HtmlEncode($notifications->NotificationDate->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="notifications" data-field="x_NotificationDate" name="o<?php echo $notifications_grid->RowIndex ?>_NotificationDate" id="o<?php echo $notifications_grid->RowIndex ?>_NotificationDate" value="<?php echo HtmlEncode($notifications->NotificationDate->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($notifications->NotificationTime->Visible) { // NotificationTime ?>
		<td data-name="NotificationTime">
<?php if (!$notifications->isConfirm()) { ?>
<span id="el$rowindex$_notifications_NotificationTime" class="form-group notifications_NotificationTime">
<input type="text" data-table="notifications" data-field="x_NotificationTime" name="x<?php echo $notifications_grid->RowIndex ?>_NotificationTime" id="x<?php echo $notifications_grid->RowIndex ?>_NotificationTime" placeholder="<?php echo HtmlEncode($notifications->NotificationTime->getPlaceHolder()) ?>" value="<?php echo $notifications->NotificationTime->EditValue ?>"<?php echo $notifications->NotificationTime->editAttributes() ?>>
<?php if (!$notifications->NotificationTime->ReadOnly && !$notifications->NotificationTime->Disabled && !isset($notifications->NotificationTime->EditAttrs["readonly"]) && !isset($notifications->NotificationTime->EditAttrs["disabled"])) { ?>
<script>ew.createTimePicker("fnotificationsgrid", "x<?php echo $notifications_grid->RowIndex ?>_NotificationTime", {"timeFormat":"h:i A","step":15});</script><?php } ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_notifications_NotificationTime" class="form-group notifications_NotificationTime">
<span<?php echo $notifications->NotificationTime->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($notifications->NotificationTime->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="notifications" data-field="x_NotificationTime" name="x<?php echo $notifications_grid->RowIndex ?>_NotificationTime" id="x<?php echo $notifications_grid->RowIndex ?>_NotificationTime" value="<?php echo HtmlEncode($notifications->NotificationTime->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="notifications" data-field="x_NotificationTime" name="o<?php echo $notifications_grid->RowIndex ?>_NotificationTime" id="o<?php echo $notifications_grid->RowIndex ?>_NotificationTime" value="<?php echo HtmlEncode($notifications->NotificationTime->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($notifications->Notes->Visible) { // Notes ?>
		<td data-name="Notes">
<?php if (!$notifications->isConfirm()) { ?>
<span id="el$rowindex$_notifications_Notes" class="form-group notifications_Notes">
<?php AppendClass($notifications->Notes->EditAttrs["class"], "editor"); ?>
<textarea data-table="notifications" data-field="x_Notes" name="x<?php echo $notifications_grid->RowIndex ?>_Notes" id="x<?php echo $notifications_grid->RowIndex ?>_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($notifications->Notes->getPlaceHolder()) ?>"<?php echo $notifications->Notes->editAttributes() ?>><?php echo $notifications->Notes->EditValue ?></textarea>
<script>
ew.createEditor("fnotificationsgrid", "x<?php echo $notifications_grid->RowIndex ?>_Notes", 35, 4, <?php echo ($notifications->Notes->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php } else { ?>
<span id="el$rowindex$_notifications_Notes" class="form-group notifications_Notes">
<span<?php echo $notifications->Notes->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($notifications->Notes->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="notifications" data-field="x_Notes" name="x<?php echo $notifications_grid->RowIndex ?>_Notes" id="x<?php echo $notifications_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($notifications->Notes->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="notifications" data-field="x_Notes" name="o<?php echo $notifications_grid->RowIndex ?>_Notes" id="o<?php echo $notifications_grid->RowIndex ?>_Notes" value="<?php echo HtmlEncode($notifications->Notes->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$notifications_grid->ListOptions->render("body", "right", $notifications_grid->RowIndex);
?>
<script>
fnotificationsgrid.updateLists(<?php echo $notifications_grid->RowIndex ?>);
</script>
	</tr>
<?php
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($notifications->CurrentMode == "add" || $notifications->CurrentMode == "copy") { ?>
<input type="hidden" name="<?php echo $notifications_grid->FormKeyCountName ?>" id="<?php echo $notifications_grid->FormKeyCountName ?>" value="<?php echo $notifications_grid->KeyCount ?>">
<?php echo $notifications_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($notifications->CurrentMode == "edit") { ?>
<input type="hidden" name="<?php echo $notifications_grid->FormKeyCountName ?>" id="<?php echo $notifications_grid->FormKeyCountName ?>" value="<?php echo $notifications_grid->KeyCount ?>">
<?php echo $notifications_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($notifications->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fnotificationsgrid">
</div><!-- /.ew-grid-middle-panel -->
<?php

// Close recordset
if ($notifications_grid->Recordset)
	$notifications_grid->Recordset->Close();
?>
</div>
<?php if ($notifications_grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $notifications_grid->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($notifications_grid->TotalRecs == 0 && !$notifications->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $notifications_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$notifications_grid->terminate();
?>
<?php if (!$notifications->isExport()) { ?>
<script>
ew.scrollableTable("gmp_notifications", "1250px", "");
</script>
<?php } ?>
