<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$sections_edit = new sections_edit();

// Run the page
$sections_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$sections_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fsectionsedit = currentForm = new ew.Form("fsectionsedit", "edit");

// Validate form
fsectionsedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($sections_edit->SectionID->Required) { ?>
			elm = this.getElements("x" + infix + "_SectionID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sections->SectionID->caption(), $sections->SectionID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sections_edit->Section->Required) { ?>
			elm = this.getElements("x" + infix + "_Section");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sections->Section->caption(), $sections->Section->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sections_edit->SectionEn->Required) { ?>
			elm = this.getElements("x" + infix + "_SectionEn");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sections->SectionEn->caption(), $sections->SectionEn->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sections_edit->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sections->Notes->caption(), $sections->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($sections_edit->Activated->Required) { ?>
			elm = this.getElements("x" + infix + "_Activated[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $sections->Activated->caption(), $sections->Activated->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fsectionsedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fsectionsedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fsectionsedit.lists["x_Activated[]"] = <?php echo $sections_edit->Activated->Lookup->toClientList() ?>;
fsectionsedit.lists["x_Activated[]"].options = <?php echo JsonEncode($sections_edit->Activated->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $sections_edit->showPageHeader(); ?>
<?php
$sections_edit->showMessage();
?>
<?php if (!$sections_edit->IsModal) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($sections_edit->Pager)) $sections_edit->Pager = new PrevNextPager($sections_edit->StartRec, $sections_edit->DisplayRecs, $sections_edit->TotalRecs, $sections_edit->AutoHidePager) ?>
<?php if ($sections_edit->Pager->RecordCount > 0 && $sections_edit->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($sections_edit->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $sections_edit->pageUrl() ?>start=<?php echo $sections_edit->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($sections_edit->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $sections_edit->pageUrl() ?>start=<?php echo $sections_edit->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $sections_edit->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($sections_edit->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $sections_edit->pageUrl() ?>start=<?php echo $sections_edit->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($sections_edit->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $sections_edit->pageUrl() ?>start=<?php echo $sections_edit->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $sections_edit->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<form name="fsectionsedit" id="fsectionsedit" class="<?php echo $sections_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($sections_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $sections_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="sections">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$sections_edit->IsModal ?>">
<?php if (!$sections_edit->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($sections_edit->IsMobileOrModal) { ?>
<div class="ew-edit-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_sectionsedit" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($sections->Section->Visible) { // Section ?>
<?php if ($sections_edit->IsMobileOrModal) { ?>
	<div id="r_Section" class="form-group row">
		<label id="elh_sections_Section" for="x_Section" class="<?php echo $sections_edit->LeftColumnClass ?>"><?php echo $sections->Section->caption() ?><?php echo ($sections->Section->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sections_edit->RightColumnClass ?>"><div<?php echo $sections->Section->cellAttributes() ?>>
<span id="el_sections_Section">
<input type="text" data-table="sections" data-field="x_Section" name="x_Section" id="x_Section" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($sections->Section->getPlaceHolder()) ?>" value="<?php echo $sections->Section->EditValue ?>"<?php echo $sections->Section->editAttributes() ?>>
</span>
<?php echo $sections->Section->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Section">
		<td class="<?php echo $sections_edit->TableLeftColumnClass ?>"><span id="elh_sections_Section"><?php echo $sections->Section->caption() ?><?php echo ($sections->Section->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $sections->Section->cellAttributes() ?>>
<span id="el_sections_Section">
<input type="text" data-table="sections" data-field="x_Section" name="x_Section" id="x_Section" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($sections->Section->getPlaceHolder()) ?>" value="<?php echo $sections->Section->EditValue ?>"<?php echo $sections->Section->editAttributes() ?>>
</span>
<?php echo $sections->Section->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($sections->SectionEn->Visible) { // SectionEn ?>
<?php if ($sections_edit->IsMobileOrModal) { ?>
	<div id="r_SectionEn" class="form-group row">
		<label id="elh_sections_SectionEn" for="x_SectionEn" class="<?php echo $sections_edit->LeftColumnClass ?>"><?php echo $sections->SectionEn->caption() ?><?php echo ($sections->SectionEn->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sections_edit->RightColumnClass ?>"><div<?php echo $sections->SectionEn->cellAttributes() ?>>
<span id="el_sections_SectionEn">
<input type="text" data-table="sections" data-field="x_SectionEn" name="x_SectionEn" id="x_SectionEn" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($sections->SectionEn->getPlaceHolder()) ?>" value="<?php echo $sections->SectionEn->EditValue ?>"<?php echo $sections->SectionEn->editAttributes() ?>>
</span>
<?php echo $sections->SectionEn->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_SectionEn">
		<td class="<?php echo $sections_edit->TableLeftColumnClass ?>"><span id="elh_sections_SectionEn"><?php echo $sections->SectionEn->caption() ?><?php echo ($sections->SectionEn->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $sections->SectionEn->cellAttributes() ?>>
<span id="el_sections_SectionEn">
<input type="text" data-table="sections" data-field="x_SectionEn" name="x_SectionEn" id="x_SectionEn" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($sections->SectionEn->getPlaceHolder()) ?>" value="<?php echo $sections->SectionEn->EditValue ?>"<?php echo $sections->SectionEn->editAttributes() ?>>
</span>
<?php echo $sections->SectionEn->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($sections->Notes->Visible) { // Notes ?>
<?php if ($sections_edit->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label id="elh_sections_Notes" for="x_Notes" class="<?php echo $sections_edit->LeftColumnClass ?>"><?php echo $sections->Notes->caption() ?><?php echo ($sections->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sections_edit->RightColumnClass ?>"><div<?php echo $sections->Notes->cellAttributes() ?>>
<span id="el_sections_Notes">
<textarea data-table="sections" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($sections->Notes->getPlaceHolder()) ?>"<?php echo $sections->Notes->editAttributes() ?>><?php echo $sections->Notes->EditValue ?></textarea>
</span>
<?php echo $sections->Notes->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $sections_edit->TableLeftColumnClass ?>"><span id="elh_sections_Notes"><?php echo $sections->Notes->caption() ?><?php echo ($sections->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $sections->Notes->cellAttributes() ?>>
<span id="el_sections_Notes">
<textarea data-table="sections" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($sections->Notes->getPlaceHolder()) ?>"<?php echo $sections->Notes->editAttributes() ?>><?php echo $sections->Notes->EditValue ?></textarea>
</span>
<?php echo $sections->Notes->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($sections->Activated->Visible) { // Activated ?>
<?php if ($sections_edit->IsMobileOrModal) { ?>
	<div id="r_Activated" class="form-group row">
		<label id="elh_sections_Activated" class="<?php echo $sections_edit->LeftColumnClass ?>"><?php echo $sections->Activated->caption() ?><?php echo ($sections->Activated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $sections_edit->RightColumnClass ?>"><div<?php echo $sections->Activated->cellAttributes() ?>>
<span id="el_sections_Activated">
<?php
$selwrk = (ConvertToBool($sections->Activated->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="sections" data-field="x_Activated" name="x_Activated[]" id="x_Activated[]" value="1"<?php echo $selwrk ?><?php echo $sections->Activated->editAttributes() ?>>
</span>
<?php echo $sections->Activated->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Activated">
		<td class="<?php echo $sections_edit->TableLeftColumnClass ?>"><span id="elh_sections_Activated"><?php echo $sections->Activated->caption() ?><?php echo ($sections->Activated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $sections->Activated->cellAttributes() ?>>
<span id="el_sections_Activated">
<?php
$selwrk = (ConvertToBool($sections->Activated->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="sections" data-field="x_Activated" name="x_Activated[]" id="x_Activated[]" value="1"<?php echo $selwrk ?><?php echo $sections->Activated->editAttributes() ?>>
</span>
<?php echo $sections->Activated->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($sections_edit->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<span id="el_sections_SectionID">
<input type="hidden" data-table="sections" data-field="x_SectionID" name="x_SectionID" id="x_SectionID" value="<?php echo HtmlEncode($sections->SectionID->CurrentValue) ?>">
</span>
<?php if (!$sections_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $sections_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $sections_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$sections_edit->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
<?php if (!$sections_edit->IsModal) { ?>
<?php if (!isset($sections_edit->Pager)) $sections_edit->Pager = new PrevNextPager($sections_edit->StartRec, $sections_edit->DisplayRecs, $sections_edit->TotalRecs, $sections_edit->AutoHidePager) ?>
<?php if ($sections_edit->Pager->RecordCount > 0 && $sections_edit->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($sections_edit->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $sections_edit->pageUrl() ?>start=<?php echo $sections_edit->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($sections_edit->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $sections_edit->pageUrl() ?>start=<?php echo $sections_edit->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $sections_edit->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($sections_edit->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $sections_edit->pageUrl() ?>start=<?php echo $sections_edit->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($sections_edit->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $sections_edit->pageUrl() ?>start=<?php echo $sections_edit->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $sections_edit->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
<?php } ?>
</form>
<?php
$sections_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$sections_edit->terminate();
?>
