<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$users_list = new users_list();

// Run the page
$users_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$users_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$users->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fuserslist = currentForm = new ew.Form("fuserslist", "list");
fuserslist.formKeyCountName = '<?php echo $users_list->FormKeyCountName ?>';

// Form_CustomValidate event
fuserslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fuserslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fuserslist.lists["x_Activated[]"] = <?php echo $users_list->Activated->Lookup->toClientList() ?>;
fuserslist.lists["x_Activated[]"].options = <?php echo JsonEncode($users_list->Activated->options(FALSE, TRUE)) ?>;
fuserslist.lists["x_Type"] = <?php echo $users_list->Type->Lookup->toClientList() ?>;
fuserslist.lists["x_Type"].options = <?php echo JsonEncode($users_list->Type->options(FALSE, TRUE)) ?>;
fuserslist.lists["x_Gender"] = <?php echo $users_list->Gender->Lookup->toClientList() ?>;
fuserslist.lists["x_Gender"].options = <?php echo JsonEncode($users_list->Gender->options(FALSE, TRUE)) ?>;
fuserslist.lists["x_Locked[]"] = <?php echo $users_list->Locked->Lookup->toClientList() ?>;
fuserslist.lists["x_Locked[]"].options = <?php echo JsonEncode($users_list->Locked->options(FALSE, TRUE)) ?>;
fuserslist.lists["x_Menu_Horizontal[]"] = <?php echo $users_list->Menu_Horizontal->Lookup->toClientList() ?>;
fuserslist.lists["x_Menu_Horizontal[]"].options = <?php echo JsonEncode($users_list->Menu_Horizontal->options(FALSE, TRUE)) ?>;

// Form object for search
var fuserslistsrch = currentSearchForm = new ew.Form("fuserslistsrch");

// Validate function for search
fuserslistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fuserslistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fuserslistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fuserslistsrch.lists["x_Activated[]"] = <?php echo $users_list->Activated->Lookup->toClientList() ?>;
fuserslistsrch.lists["x_Activated[]"].options = <?php echo JsonEncode($users_list->Activated->options(FALSE, TRUE)) ?>;
fuserslistsrch.lists["x_Type"] = <?php echo $users_list->Type->Lookup->toClientList() ?>;
fuserslistsrch.lists["x_Type"].options = <?php echo JsonEncode($users_list->Type->options(FALSE, TRUE)) ?>;
fuserslistsrch.lists["x_Gender"] = <?php echo $users_list->Gender->Lookup->toClientList() ?>;
fuserslistsrch.lists["x_Gender"].options = <?php echo JsonEncode($users_list->Gender->options(FALSE, TRUE)) ?>;
fuserslistsrch.lists["x_Locked[]"] = <?php echo $users_list->Locked->Lookup->toClientList() ?>;
fuserslistsrch.lists["x_Locked[]"].options = <?php echo JsonEncode($users_list->Locked->options(FALSE, TRUE)) ?>;
fuserslistsrch.lists["x_Menu_Horizontal[]"] = <?php echo $users_list->Menu_Horizontal->Lookup->toClientList() ?>;
fuserslistsrch.lists["x_Menu_Horizontal[]"].options = <?php echo JsonEncode($users_list->Menu_Horizontal->options(FALSE, TRUE)) ?>;

// Filters
fuserslistsrch.filterList = <?php echo $users_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$users->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($users_list->TotalRecs > 0 && $users_list->ExportOptions->visible()) { ?>
<?php $users_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($users_list->ImportOptions->visible()) { ?>
<?php $users_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($users_list->SearchOptions->visible()) { ?>
<?php $users_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($users_list->FilterOptions->visible()) { ?>
<?php $users_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$users_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$users->isExport() && !$users->CurrentAction) { ?>
<form name="fuserslistsrch" id="fuserslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($users_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="fuserslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="users">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$users_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$users->RowType = ROWTYPE_SEARCH;

// Render row
$users->resetAttributes();
$users_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($users->Activated->Visible) { // Activated ?>
	<div id="xsc_Activated" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $users->Activated->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Activated" id="z_Activated" value="="></span>
		<span class="ew-search-field">
<?php
$selwrk = (ConvertToBool($users->Activated->AdvancedSearch->SearchValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="users" data-field="x_Activated" name="x_Activated[]" id="x_Activated[]" value="1"<?php echo $selwrk ?><?php echo $users->Activated->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($users->Type->Visible) { // Type ?>
	<div id="xsc_Type" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $users->Type->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Type" id="z_Type" value="="></span>
		<span class="ew-search-field">
<div id="tp_x_Type" class="ew-template"><input type="radio" class="form-check-input" data-table="users" data-field="x_Type" data-value-separator="<?php echo $users->Type->displayValueSeparatorAttribute() ?>" name="x_Type" id="x_Type" value="{value}"<?php echo $users->Type->editAttributes() ?>></div>
<div id="dsl_x_Type" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $users->Type->radioButtonListHtml(FALSE, "x_Type") ?>
</div></div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
<?php if ($users->Gender->Visible) { // Gender ?>
	<div id="xsc_Gender" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $users->Gender->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Gender" id="z_Gender" value="="></span>
		<span class="ew-search-field">
<div id="tp_x_Gender" class="ew-template"><input type="radio" class="form-check-input" data-table="users" data-field="x_Gender" data-value-separator="<?php echo $users->Gender->displayValueSeparatorAttribute() ?>" name="x_Gender" id="x_Gender" value="{value}"<?php echo $users->Gender->editAttributes() ?>></div>
<div id="dsl_x_Gender" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $users->Gender->radioButtonListHtml(FALSE, "x_Gender") ?>
</div></div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ew-row d-sm-flex">
<?php if ($users->Locked->Visible) { // Locked ?>
	<div id="xsc_Locked" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $users->Locked->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Locked" id="z_Locked" value="="></span>
		<span class="ew-search-field">
<?php
$selwrk = (ConvertToBool($users->Locked->AdvancedSearch->SearchValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="users" data-field="x_Locked" name="x_Locked[]" id="x_Locked[]" value="1"<?php echo $selwrk ?><?php echo $users->Locked->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_5" class="ew-row d-sm-flex">
<?php if ($users->Menu_Horizontal->Visible) { // Menu_Horizontal ?>
	<div id="xsc_Menu_Horizontal" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $users->Menu_Horizontal->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Menu_Horizontal" id="z_Menu_Horizontal" value="="></span>
		<span class="ew-search-field">
<?php
$selwrk = (ConvertToBool($users->Menu_Horizontal->AdvancedSearch->SearchValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="users" data-field="x_Menu_Horizontal" name="x_Menu_Horizontal[]" id="x_Menu_Horizontal[]" value="1"<?php echo $selwrk ?><?php echo $users->Menu_Horizontal->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_6" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($users_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($users_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $users_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($users_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($users_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($users_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($users_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $users_list->showPageHeader(); ?>
<?php
$users_list->showMessage();
?>
<?php if ($users_list->TotalRecs > 0 || $users->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($users_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> users">
<?php if (!$users->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$users->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($users_list->Pager)) $users_list->Pager = new PrevNextPager($users_list->StartRec, $users_list->DisplayRecs, $users_list->TotalRecs, $users_list->AutoHidePager) ?>
<?php if ($users_list->Pager->RecordCount > 0 && $users_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($users_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $users_list->pageUrl() ?>start=<?php echo $users_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($users_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $users_list->pageUrl() ?>start=<?php echo $users_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $users_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($users_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $users_list->pageUrl() ?>start=<?php echo $users_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($users_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $users_list->pageUrl() ?>start=<?php echo $users_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $users_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($users_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $users_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $users_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $users_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($users_list->TotalRecs > 0 && (!$users_list->AutoHidePageSizeSelector || $users_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="users">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($users_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($users_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($users_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($users_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($users_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($users_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($users_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($users_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($users_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($users->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $users_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fuserslist" id="fuserslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($users_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $users_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="users">
<div id="gmp_users" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($users_list->TotalRecs > 0 || $users->isGridEdit()) { ?>
<table id="tbl_userslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$users_list->RowType = ROWTYPE_HEADER;

// Render list options
$users_list->renderListOptions();

// Render list options (header, left)
$users_list->ListOptions->render("header", "left");
?>
<?php if ($users->_UserID->Visible) { // UserID ?>
	<?php if ($users->sortUrl($users->_UserID) == "") { ?>
		<th data-name="_UserID" class="<?php echo $users->_UserID->headerCellClass() ?>"><div id="elh_users__UserID" class="users__UserID"><div class="ew-table-header-caption"><?php echo $users->_UserID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_UserID" class="<?php echo $users->_UserID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $users->SortUrl($users->_UserID) ?>',2);"><div id="elh_users__UserID" class="users__UserID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $users->_UserID->caption() ?></span><span class="ew-table-header-sort"><?php if ($users->_UserID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($users->_UserID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($users->Username->Visible) { // Username ?>
	<?php if ($users->sortUrl($users->Username) == "") { ?>
		<th data-name="Username" class="<?php echo $users->Username->headerCellClass() ?>"><div id="elh_users_Username" class="users_Username"><div class="ew-table-header-caption"><?php echo $users->Username->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Username" class="<?php echo $users->Username->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $users->SortUrl($users->Username) ?>',2);"><div id="elh_users_Username" class="users_Username">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $users->Username->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($users->Username->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($users->Username->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($users->Password->Visible) { // Password ?>
	<?php if ($users->sortUrl($users->Password) == "") { ?>
		<th data-name="Password" class="<?php echo $users->Password->headerCellClass() ?>"><div id="elh_users_Password" class="users_Password"><div class="ew-table-header-caption"><?php echo $users->Password->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Password" class="<?php echo $users->Password->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $users->SortUrl($users->Password) ?>',2);"><div id="elh_users_Password" class="users_Password">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $users->Password->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($users->Password->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($users->Password->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($users->LastName->Visible) { // LastName ?>
	<?php if ($users->sortUrl($users->LastName) == "") { ?>
		<th data-name="LastName" class="<?php echo $users->LastName->headerCellClass() ?>"><div id="elh_users_LastName" class="users_LastName"><div class="ew-table-header-caption"><?php echo $users->LastName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LastName" class="<?php echo $users->LastName->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $users->SortUrl($users->LastName) ?>',2);"><div id="elh_users_LastName" class="users_LastName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $users->LastName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($users->LastName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($users->LastName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($users->FirstName->Visible) { // FirstName ?>
	<?php if ($users->sortUrl($users->FirstName) == "") { ?>
		<th data-name="FirstName" class="<?php echo $users->FirstName->headerCellClass() ?>"><div id="elh_users_FirstName" class="users_FirstName"><div class="ew-table-header-caption"><?php echo $users->FirstName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FirstName" class="<?php echo $users->FirstName->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $users->SortUrl($users->FirstName) ?>',2);"><div id="elh_users_FirstName" class="users_FirstName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $users->FirstName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($users->FirstName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($users->FirstName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($users->Title->Visible) { // Title ?>
	<?php if ($users->sortUrl($users->Title) == "") { ?>
		<th data-name="Title" class="<?php echo $users->Title->headerCellClass() ?>"><div id="elh_users_Title" class="users_Title"><div class="ew-table-header-caption"><?php echo $users->Title->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Title" class="<?php echo $users->Title->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $users->SortUrl($users->Title) ?>',2);"><div id="elh_users_Title" class="users_Title">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $users->Title->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($users->Title->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($users->Title->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($users->TitleOfCourtesy->Visible) { // TitleOfCourtesy ?>
	<?php if ($users->sortUrl($users->TitleOfCourtesy) == "") { ?>
		<th data-name="TitleOfCourtesy" class="<?php echo $users->TitleOfCourtesy->headerCellClass() ?>"><div id="elh_users_TitleOfCourtesy" class="users_TitleOfCourtesy"><div class="ew-table-header-caption"><?php echo $users->TitleOfCourtesy->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TitleOfCourtesy" class="<?php echo $users->TitleOfCourtesy->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $users->SortUrl($users->TitleOfCourtesy) ?>',2);"><div id="elh_users_TitleOfCourtesy" class="users_TitleOfCourtesy">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $users->TitleOfCourtesy->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($users->TitleOfCourtesy->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($users->TitleOfCourtesy->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($users->BirthDate->Visible) { // BirthDate ?>
	<?php if ($users->sortUrl($users->BirthDate) == "") { ?>
		<th data-name="BirthDate" class="<?php echo $users->BirthDate->headerCellClass() ?>"><div id="elh_users_BirthDate" class="users_BirthDate"><div class="ew-table-header-caption"><?php echo $users->BirthDate->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="BirthDate" class="<?php echo $users->BirthDate->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $users->SortUrl($users->BirthDate) ?>',2);"><div id="elh_users_BirthDate" class="users_BirthDate">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $users->BirthDate->caption() ?></span><span class="ew-table-header-sort"><?php if ($users->BirthDate->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($users->BirthDate->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($users->HireDate->Visible) { // HireDate ?>
	<?php if ($users->sortUrl($users->HireDate) == "") { ?>
		<th data-name="HireDate" class="<?php echo $users->HireDate->headerCellClass() ?>"><div id="elh_users_HireDate" class="users_HireDate"><div class="ew-table-header-caption"><?php echo $users->HireDate->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="HireDate" class="<?php echo $users->HireDate->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $users->SortUrl($users->HireDate) ?>',2);"><div id="elh_users_HireDate" class="users_HireDate">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $users->HireDate->caption() ?></span><span class="ew-table-header-sort"><?php if ($users->HireDate->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($users->HireDate->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($users->Address->Visible) { // Address ?>
	<?php if ($users->sortUrl($users->Address) == "") { ?>
		<th data-name="Address" class="<?php echo $users->Address->headerCellClass() ?>"><div id="elh_users_Address" class="users_Address"><div class="ew-table-header-caption"><?php echo $users->Address->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Address" class="<?php echo $users->Address->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $users->SortUrl($users->Address) ?>',2);"><div id="elh_users_Address" class="users_Address">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $users->Address->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($users->Address->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($users->Address->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($users->City->Visible) { // City ?>
	<?php if ($users->sortUrl($users->City) == "") { ?>
		<th data-name="City" class="<?php echo $users->City->headerCellClass() ?>"><div id="elh_users_City" class="users_City"><div class="ew-table-header-caption"><?php echo $users->City->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="City" class="<?php echo $users->City->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $users->SortUrl($users->City) ?>',2);"><div id="elh_users_City" class="users_City">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $users->City->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($users->City->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($users->City->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($users->Region->Visible) { // Region ?>
	<?php if ($users->sortUrl($users->Region) == "") { ?>
		<th data-name="Region" class="<?php echo $users->Region->headerCellClass() ?>"><div id="elh_users_Region" class="users_Region"><div class="ew-table-header-caption"><?php echo $users->Region->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Region" class="<?php echo $users->Region->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $users->SortUrl($users->Region) ?>',2);"><div id="elh_users_Region" class="users_Region">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $users->Region->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($users->Region->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($users->Region->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($users->PostalCode->Visible) { // PostalCode ?>
	<?php if ($users->sortUrl($users->PostalCode) == "") { ?>
		<th data-name="PostalCode" class="<?php echo $users->PostalCode->headerCellClass() ?>"><div id="elh_users_PostalCode" class="users_PostalCode"><div class="ew-table-header-caption"><?php echo $users->PostalCode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PostalCode" class="<?php echo $users->PostalCode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $users->SortUrl($users->PostalCode) ?>',2);"><div id="elh_users_PostalCode" class="users_PostalCode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $users->PostalCode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($users->PostalCode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($users->PostalCode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($users->Country->Visible) { // Country ?>
	<?php if ($users->sortUrl($users->Country) == "") { ?>
		<th data-name="Country" class="<?php echo $users->Country->headerCellClass() ?>"><div id="elh_users_Country" class="users_Country"><div class="ew-table-header-caption"><?php echo $users->Country->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Country" class="<?php echo $users->Country->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $users->SortUrl($users->Country) ?>',2);"><div id="elh_users_Country" class="users_Country">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $users->Country->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($users->Country->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($users->Country->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($users->HomePhone->Visible) { // HomePhone ?>
	<?php if ($users->sortUrl($users->HomePhone) == "") { ?>
		<th data-name="HomePhone" class="<?php echo $users->HomePhone->headerCellClass() ?>"><div id="elh_users_HomePhone" class="users_HomePhone"><div class="ew-table-header-caption"><?php echo $users->HomePhone->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="HomePhone" class="<?php echo $users->HomePhone->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $users->SortUrl($users->HomePhone) ?>',2);"><div id="elh_users_HomePhone" class="users_HomePhone">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $users->HomePhone->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($users->HomePhone->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($users->HomePhone->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($users->Extension->Visible) { // Extension ?>
	<?php if ($users->sortUrl($users->Extension) == "") { ?>
		<th data-name="Extension" class="<?php echo $users->Extension->headerCellClass() ?>"><div id="elh_users_Extension" class="users_Extension"><div class="ew-table-header-caption"><?php echo $users->Extension->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Extension" class="<?php echo $users->Extension->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $users->SortUrl($users->Extension) ?>',2);"><div id="elh_users_Extension" class="users_Extension">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $users->Extension->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($users->Extension->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($users->Extension->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($users->_Email->Visible) { // Email ?>
	<?php if ($users->sortUrl($users->_Email) == "") { ?>
		<th data-name="_Email" class="<?php echo $users->_Email->headerCellClass() ?>"><div id="elh_users__Email" class="users__Email"><div class="ew-table-header-caption"><?php echo $users->_Email->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_Email" class="<?php echo $users->_Email->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $users->SortUrl($users->_Email) ?>',2);"><div id="elh_users__Email" class="users__Email">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $users->_Email->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($users->_Email->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($users->_Email->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($users->Photo->Visible) { // Photo ?>
	<?php if ($users->sortUrl($users->Photo) == "") { ?>
		<th data-name="Photo" class="<?php echo $users->Photo->headerCellClass() ?>"><div id="elh_users_Photo" class="users_Photo"><div class="ew-table-header-caption"><?php echo $users->Photo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Photo" class="<?php echo $users->Photo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $users->SortUrl($users->Photo) ?>',2);"><div id="elh_users_Photo" class="users_Photo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $users->Photo->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($users->Photo->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($users->Photo->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($users->ReportsTo->Visible) { // ReportsTo ?>
	<?php if ($users->sortUrl($users->ReportsTo) == "") { ?>
		<th data-name="ReportsTo" class="<?php echo $users->ReportsTo->headerCellClass() ?>"><div id="elh_users_ReportsTo" class="users_ReportsTo"><div class="ew-table-header-caption"><?php echo $users->ReportsTo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ReportsTo" class="<?php echo $users->ReportsTo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $users->SortUrl($users->ReportsTo) ?>',2);"><div id="elh_users_ReportsTo" class="users_ReportsTo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $users->ReportsTo->caption() ?></span><span class="ew-table-header-sort"><?php if ($users->ReportsTo->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($users->ReportsTo->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($users->UserLevel->Visible) { // UserLevel ?>
	<?php if ($users->sortUrl($users->UserLevel) == "") { ?>
		<th data-name="UserLevel" class="<?php echo $users->UserLevel->headerCellClass() ?>"><div id="elh_users_UserLevel" class="users_UserLevel"><div class="ew-table-header-caption"><?php echo $users->UserLevel->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="UserLevel" class="<?php echo $users->UserLevel->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $users->SortUrl($users->UserLevel) ?>',2);"><div id="elh_users_UserLevel" class="users_UserLevel">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $users->UserLevel->caption() ?></span><span class="ew-table-header-sort"><?php if ($users->UserLevel->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($users->UserLevel->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($users->Activated->Visible) { // Activated ?>
	<?php if ($users->sortUrl($users->Activated) == "") { ?>
		<th data-name="Activated" class="<?php echo $users->Activated->headerCellClass() ?>"><div id="elh_users_Activated" class="users_Activated"><div class="ew-table-header-caption"><?php echo $users->Activated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Activated" class="<?php echo $users->Activated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $users->SortUrl($users->Activated) ?>',2);"><div id="elh_users_Activated" class="users_Activated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $users->Activated->caption() ?></span><span class="ew-table-header-sort"><?php if ($users->Activated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($users->Activated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($users->Type->Visible) { // Type ?>
	<?php if ($users->sortUrl($users->Type) == "") { ?>
		<th data-name="Type" class="<?php echo $users->Type->headerCellClass() ?>"><div id="elh_users_Type" class="users_Type"><div class="ew-table-header-caption"><?php echo $users->Type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Type" class="<?php echo $users->Type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $users->SortUrl($users->Type) ?>',2);"><div id="elh_users_Type" class="users_Type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $users->Type->caption() ?></span><span class="ew-table-header-sort"><?php if ($users->Type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($users->Type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($users->Gender->Visible) { // Gender ?>
	<?php if ($users->sortUrl($users->Gender) == "") { ?>
		<th data-name="Gender" class="<?php echo $users->Gender->headerCellClass() ?>"><div id="elh_users_Gender" class="users_Gender"><div class="ew-table-header-caption"><?php echo $users->Gender->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Gender" class="<?php echo $users->Gender->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $users->SortUrl($users->Gender) ?>',2);"><div id="elh_users_Gender" class="users_Gender">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $users->Gender->caption() ?></span><span class="ew-table-header-sort"><?php if ($users->Gender->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($users->Gender->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($users->MobilePhone->Visible) { // MobilePhone ?>
	<?php if ($users->sortUrl($users->MobilePhone) == "") { ?>
		<th data-name="MobilePhone" class="<?php echo $users->MobilePhone->headerCellClass() ?>"><div id="elh_users_MobilePhone" class="users_MobilePhone"><div class="ew-table-header-caption"><?php echo $users->MobilePhone->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="MobilePhone" class="<?php echo $users->MobilePhone->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $users->SortUrl($users->MobilePhone) ?>',2);"><div id="elh_users_MobilePhone" class="users_MobilePhone">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $users->MobilePhone->caption() ?></span><span class="ew-table-header-sort"><?php if ($users->MobilePhone->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($users->MobilePhone->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($users->Locked->Visible) { // Locked ?>
	<?php if ($users->sortUrl($users->Locked) == "") { ?>
		<th data-name="Locked" class="<?php echo $users->Locked->headerCellClass() ?>"><div id="elh_users_Locked" class="users_Locked"><div class="ew-table-header-caption"><?php echo $users->Locked->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Locked" class="<?php echo $users->Locked->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $users->SortUrl($users->Locked) ?>',2);"><div id="elh_users_Locked" class="users_Locked">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $users->Locked->caption() ?></span><span class="ew-table-header-sort"><?php if ($users->Locked->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($users->Locked->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($users->Theme->Visible) { // Theme ?>
	<?php if ($users->sortUrl($users->Theme) == "") { ?>
		<th data-name="Theme" class="<?php echo $users->Theme->headerCellClass() ?>"><div id="elh_users_Theme" class="users_Theme"><div class="ew-table-header-caption"><?php echo $users->Theme->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Theme" class="<?php echo $users->Theme->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $users->SortUrl($users->Theme) ?>',2);"><div id="elh_users_Theme" class="users_Theme">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $users->Theme->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($users->Theme->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($users->Theme->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($users->Menu_Horizontal->Visible) { // Menu_Horizontal ?>
	<?php if ($users->sortUrl($users->Menu_Horizontal) == "") { ?>
		<th data-name="Menu_Horizontal" class="<?php echo $users->Menu_Horizontal->headerCellClass() ?>"><div id="elh_users_Menu_Horizontal" class="users_Menu_Horizontal"><div class="ew-table-header-caption"><?php echo $users->Menu_Horizontal->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Menu_Horizontal" class="<?php echo $users->Menu_Horizontal->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $users->SortUrl($users->Menu_Horizontal) ?>',2);"><div id="elh_users_Menu_Horizontal" class="users_Menu_Horizontal">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $users->Menu_Horizontal->caption() ?></span><span class="ew-table-header-sort"><?php if ($users->Menu_Horizontal->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($users->Menu_Horizontal->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($users->_Language->Visible) { // Language ?>
	<?php if ($users->sortUrl($users->_Language) == "") { ?>
		<th data-name="_Language" class="<?php echo $users->_Language->headerCellClass() ?>"><div id="elh_users__Language" class="users__Language"><div class="ew-table-header-caption"><?php echo $users->_Language->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_Language" class="<?php echo $users->_Language->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $users->SortUrl($users->_Language) ?>',2);"><div id="elh_users__Language" class="users__Language">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $users->_Language->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($users->_Language->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($users->_Language->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$users_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($users->ExportAll && $users->isExport()) {
	$users_list->StopRec = $users_list->TotalRecs;
} else {

	// Set the last record to display
	if ($users_list->TotalRecs > $users_list->StartRec + $users_list->DisplayRecs - 1)
		$users_list->StopRec = $users_list->StartRec + $users_list->DisplayRecs - 1;
	else
		$users_list->StopRec = $users_list->TotalRecs;
}
$users_list->RecCnt = $users_list->StartRec - 1;
if ($users_list->Recordset && !$users_list->Recordset->EOF) {
	$users_list->Recordset->moveFirst();
	$selectLimit = $users_list->UseSelectLimit;
	if (!$selectLimit && $users_list->StartRec > 1)
		$users_list->Recordset->move($users_list->StartRec - 1);
} elseif (!$users->AllowAddDeleteRow && $users_list->StopRec == 0) {
	$users_list->StopRec = $users->GridAddRowCount;
}

// Initialize aggregate
$users->RowType = ROWTYPE_AGGREGATEINIT;
$users->resetAttributes();
$users_list->renderRow();
while ($users_list->RecCnt < $users_list->StopRec) {
	$users_list->RecCnt++;
	if ($users_list->RecCnt >= $users_list->StartRec) {
		$users_list->RowCnt++;

		// Set up key count
		$users_list->KeyCount = $users_list->RowIndex;

		// Init row class and style
		$users->resetAttributes();
		$users->CssClass = "";
		if ($users->isGridAdd()) {
		} else {
			$users_list->loadRowValues($users_list->Recordset); // Load row values
		}
		$users->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$users->RowAttrs = array_merge($users->RowAttrs, array('data-rowindex'=>$users_list->RowCnt, 'id'=>'r' . $users_list->RowCnt . '_users', 'data-rowtype'=>$users->RowType));

		// Render row
		$users_list->renderRow();

		// Render list options
		$users_list->renderListOptions();
?>
	<tr<?php echo $users->rowAttributes() ?>>
<?php

// Render list options (body, left)
$users_list->ListOptions->render("body", "left", $users_list->RowCnt);
?>
	<?php if ($users->_UserID->Visible) { // UserID ?>
		<td data-name="_UserID"<?php echo $users->_UserID->cellAttributes() ?>>
<span id="el<?php echo $users_list->RowCnt ?>_users__UserID" class="users__UserID">
<span<?php echo $users->_UserID->viewAttributes() ?>>
<?php echo $users->_UserID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($users->Username->Visible) { // Username ?>
		<td data-name="Username"<?php echo $users->Username->cellAttributes() ?>>
<span id="el<?php echo $users_list->RowCnt ?>_users_Username" class="users_Username">
<span<?php echo $users->Username->viewAttributes() ?>>
<?php echo $users->Username->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($users->Password->Visible) { // Password ?>
		<td data-name="Password"<?php echo $users->Password->cellAttributes() ?>>
<span id="el<?php echo $users_list->RowCnt ?>_users_Password" class="users_Password">
<span<?php echo $users->Password->viewAttributes() ?>>
<?php echo $users->Password->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($users->LastName->Visible) { // LastName ?>
		<td data-name="LastName"<?php echo $users->LastName->cellAttributes() ?>>
<span id="el<?php echo $users_list->RowCnt ?>_users_LastName" class="users_LastName">
<span<?php echo $users->LastName->viewAttributes() ?>>
<?php echo $users->LastName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($users->FirstName->Visible) { // FirstName ?>
		<td data-name="FirstName"<?php echo $users->FirstName->cellAttributes() ?>>
<span id="el<?php echo $users_list->RowCnt ?>_users_FirstName" class="users_FirstName">
<span<?php echo $users->FirstName->viewAttributes() ?>>
<?php echo $users->FirstName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($users->Title->Visible) { // Title ?>
		<td data-name="Title"<?php echo $users->Title->cellAttributes() ?>>
<span id="el<?php echo $users_list->RowCnt ?>_users_Title" class="users_Title">
<span<?php echo $users->Title->viewAttributes() ?>>
<?php echo $users->Title->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($users->TitleOfCourtesy->Visible) { // TitleOfCourtesy ?>
		<td data-name="TitleOfCourtesy"<?php echo $users->TitleOfCourtesy->cellAttributes() ?>>
<span id="el<?php echo $users_list->RowCnt ?>_users_TitleOfCourtesy" class="users_TitleOfCourtesy">
<span<?php echo $users->TitleOfCourtesy->viewAttributes() ?>>
<?php echo $users->TitleOfCourtesy->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($users->BirthDate->Visible) { // BirthDate ?>
		<td data-name="BirthDate"<?php echo $users->BirthDate->cellAttributes() ?>>
<span id="el<?php echo $users_list->RowCnt ?>_users_BirthDate" class="users_BirthDate">
<span<?php echo $users->BirthDate->viewAttributes() ?>>
<?php echo $users->BirthDate->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($users->HireDate->Visible) { // HireDate ?>
		<td data-name="HireDate"<?php echo $users->HireDate->cellAttributes() ?>>
<span id="el<?php echo $users_list->RowCnt ?>_users_HireDate" class="users_HireDate">
<span<?php echo $users->HireDate->viewAttributes() ?>>
<?php echo $users->HireDate->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($users->Address->Visible) { // Address ?>
		<td data-name="Address"<?php echo $users->Address->cellAttributes() ?>>
<span id="el<?php echo $users_list->RowCnt ?>_users_Address" class="users_Address">
<span<?php echo $users->Address->viewAttributes() ?>>
<?php echo $users->Address->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($users->City->Visible) { // City ?>
		<td data-name="City"<?php echo $users->City->cellAttributes() ?>>
<span id="el<?php echo $users_list->RowCnt ?>_users_City" class="users_City">
<span<?php echo $users->City->viewAttributes() ?>>
<?php echo $users->City->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($users->Region->Visible) { // Region ?>
		<td data-name="Region"<?php echo $users->Region->cellAttributes() ?>>
<span id="el<?php echo $users_list->RowCnt ?>_users_Region" class="users_Region">
<span<?php echo $users->Region->viewAttributes() ?>>
<?php echo $users->Region->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($users->PostalCode->Visible) { // PostalCode ?>
		<td data-name="PostalCode"<?php echo $users->PostalCode->cellAttributes() ?>>
<span id="el<?php echo $users_list->RowCnt ?>_users_PostalCode" class="users_PostalCode">
<span<?php echo $users->PostalCode->viewAttributes() ?>>
<?php echo $users->PostalCode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($users->Country->Visible) { // Country ?>
		<td data-name="Country"<?php echo $users->Country->cellAttributes() ?>>
<span id="el<?php echo $users_list->RowCnt ?>_users_Country" class="users_Country">
<span<?php echo $users->Country->viewAttributes() ?>>
<?php echo $users->Country->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($users->HomePhone->Visible) { // HomePhone ?>
		<td data-name="HomePhone"<?php echo $users->HomePhone->cellAttributes() ?>>
<span id="el<?php echo $users_list->RowCnt ?>_users_HomePhone" class="users_HomePhone">
<span<?php echo $users->HomePhone->viewAttributes() ?>>
<?php echo $users->HomePhone->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($users->Extension->Visible) { // Extension ?>
		<td data-name="Extension"<?php echo $users->Extension->cellAttributes() ?>>
<span id="el<?php echo $users_list->RowCnt ?>_users_Extension" class="users_Extension">
<span<?php echo $users->Extension->viewAttributes() ?>>
<?php echo $users->Extension->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($users->_Email->Visible) { // Email ?>
		<td data-name="_Email"<?php echo $users->_Email->cellAttributes() ?>>
<span id="el<?php echo $users_list->RowCnt ?>_users__Email" class="users__Email">
<span<?php echo $users->_Email->viewAttributes() ?>>
<?php echo $users->_Email->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($users->Photo->Visible) { // Photo ?>
		<td data-name="Photo"<?php echo $users->Photo->cellAttributes() ?>>
<span id="el<?php echo $users_list->RowCnt ?>_users_Photo" class="users_Photo">
<span>
<?php echo GetFileViewTag($users->Photo, $users->Photo->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($users->ReportsTo->Visible) { // ReportsTo ?>
		<td data-name="ReportsTo"<?php echo $users->ReportsTo->cellAttributes() ?>>
<span id="el<?php echo $users_list->RowCnt ?>_users_ReportsTo" class="users_ReportsTo">
<span<?php echo $users->ReportsTo->viewAttributes() ?>>
<?php echo $users->ReportsTo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($users->UserLevel->Visible) { // UserLevel ?>
		<td data-name="UserLevel"<?php echo $users->UserLevel->cellAttributes() ?>>
<span id="el<?php echo $users_list->RowCnt ?>_users_UserLevel" class="users_UserLevel">
<span<?php echo $users->UserLevel->viewAttributes() ?>>
<?php echo $users->UserLevel->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($users->Activated->Visible) { // Activated ?>
		<td data-name="Activated"<?php echo $users->Activated->cellAttributes() ?>>
<span id="el<?php echo $users_list->RowCnt ?>_users_Activated" class="users_Activated">
<span<?php echo $users->Activated->viewAttributes() ?>>
<?php if (ConvertToBool($users->Activated->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $users->Activated->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $users->Activated->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($users->Type->Visible) { // Type ?>
		<td data-name="Type"<?php echo $users->Type->cellAttributes() ?>>
<span id="el<?php echo $users_list->RowCnt ?>_users_Type" class="users_Type">
<span<?php echo $users->Type->viewAttributes() ?>>
<?php echo $users->Type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($users->Gender->Visible) { // Gender ?>
		<td data-name="Gender"<?php echo $users->Gender->cellAttributes() ?>>
<span id="el<?php echo $users_list->RowCnt ?>_users_Gender" class="users_Gender">
<span<?php echo $users->Gender->viewAttributes() ?>>
<?php echo $users->Gender->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($users->MobilePhone->Visible) { // MobilePhone ?>
		<td data-name="MobilePhone"<?php echo $users->MobilePhone->cellAttributes() ?>>
<span id="el<?php echo $users_list->RowCnt ?>_users_MobilePhone" class="users_MobilePhone">
<span<?php echo $users->MobilePhone->viewAttributes() ?>>
<?php echo $users->MobilePhone->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($users->Locked->Visible) { // Locked ?>
		<td data-name="Locked"<?php echo $users->Locked->cellAttributes() ?>>
<span id="el<?php echo $users_list->RowCnt ?>_users_Locked" class="users_Locked">
<span<?php echo $users->Locked->viewAttributes() ?>>
<?php if (ConvertToBool($users->Locked->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $users->Locked->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $users->Locked->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($users->Theme->Visible) { // Theme ?>
		<td data-name="Theme"<?php echo $users->Theme->cellAttributes() ?>>
<span id="el<?php echo $users_list->RowCnt ?>_users_Theme" class="users_Theme">
<span<?php echo $users->Theme->viewAttributes() ?>>
<?php echo $users->Theme->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($users->Menu_Horizontal->Visible) { // Menu_Horizontal ?>
		<td data-name="Menu_Horizontal"<?php echo $users->Menu_Horizontal->cellAttributes() ?>>
<span id="el<?php echo $users_list->RowCnt ?>_users_Menu_Horizontal" class="users_Menu_Horizontal">
<span<?php echo $users->Menu_Horizontal->viewAttributes() ?>>
<?php if (ConvertToBool($users->Menu_Horizontal->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $users->Menu_Horizontal->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $users->Menu_Horizontal->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($users->_Language->Visible) { // Language ?>
		<td data-name="_Language"<?php echo $users->_Language->cellAttributes() ?>>
<span id="el<?php echo $users_list->RowCnt ?>_users__Language" class="users__Language">
<span<?php echo $users->_Language->viewAttributes() ?>>
<?php echo $users->_Language->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$users_list->ListOptions->render("body", "right", $users_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$users->isGridAdd())
		$users_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$users->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($users_list->Recordset)
	$users_list->Recordset->Close();
?>
<?php if (!$users->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$users->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($users_list->Pager)) $users_list->Pager = new PrevNextPager($users_list->StartRec, $users_list->DisplayRecs, $users_list->TotalRecs, $users_list->AutoHidePager) ?>
<?php if ($users_list->Pager->RecordCount > 0 && $users_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($users_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $users_list->pageUrl() ?>start=<?php echo $users_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($users_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $users_list->pageUrl() ?>start=<?php echo $users_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $users_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($users_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $users_list->pageUrl() ?>start=<?php echo $users_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($users_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $users_list->pageUrl() ?>start=<?php echo $users_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $users_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($users_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $users_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $users_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $users_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($users_list->TotalRecs > 0 && (!$users_list->AutoHidePageSizeSelector || $users_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="users">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($users_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($users_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($users_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($users_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($users_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($users_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($users_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($users_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($users_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($users->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $users_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($users_list->TotalRecs == 0 && !$users->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $users_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$users_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$users->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$users->isExport()) { ?>
<script>
ew.scrollableTable("gmp_users", "1250px", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$users_list->terminate();
?>
