<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$_cases_report_list = new _cases_report_list();

// Run the page
$_cases_report_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$_cases_report_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$_cases_report->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var f_cases_reportlist = currentForm = new ew.Form("f_cases_reportlist", "list");
f_cases_reportlist.formKeyCountName = '<?php echo $_cases_report_list->FormKeyCountName ?>';

// Form_CustomValidate event
f_cases_reportlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
f_cases_reportlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
f_cases_reportlist.lists["x_ClientID"] = <?php echo $_cases_report_list->ClientID->Lookup->toClientList() ?>;
f_cases_reportlist.lists["x_ClientID"].options = <?php echo JsonEncode($_cases_report_list->ClientID->lookupOptions()) ?>;
f_cases_reportlist.autoSuggests["x_ClientID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
f_cases_reportlist.lists["x_LitigantID"] = <?php echo $_cases_report_list->LitigantID->Lookup->toClientList() ?>;
f_cases_reportlist.lists["x_LitigantID"].options = <?php echo JsonEncode($_cases_report_list->LitigantID->lookupOptions()) ?>;
f_cases_reportlist.autoSuggests["x_LitigantID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
f_cases_reportlist.lists["x_CaseTypeID"] = <?php echo $_cases_report_list->CaseTypeID->Lookup->toClientList() ?>;
f_cases_reportlist.lists["x_CaseTypeID"].options = <?php echo JsonEncode($_cases_report_list->CaseTypeID->lookupOptions()) ?>;
f_cases_reportlist.lists["x_ClientStatusID"] = <?php echo $_cases_report_list->ClientStatusID->Lookup->toClientList() ?>;
f_cases_reportlist.lists["x_ClientStatusID"].options = <?php echo JsonEncode($_cases_report_list->ClientStatusID->lookupOptions()) ?>;
f_cases_reportlist.lists["x_LitigantStatusID"] = <?php echo $_cases_report_list->LitigantStatusID->Lookup->toClientList() ?>;
f_cases_reportlist.lists["x_LitigantStatusID"].options = <?php echo JsonEncode($_cases_report_list->LitigantStatusID->lookupOptions()) ?>;
f_cases_reportlist.lists["x_CourtID"] = <?php echo $_cases_report_list->CourtID->Lookup->toClientList() ?>;
f_cases_reportlist.lists["x_CourtID"].options = <?php echo JsonEncode($_cases_report_list->CourtID->lookupOptions()) ?>;
f_cases_reportlist.autoSuggests["x_CourtID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
f_cases_reportlist.lists["x_TitleID"] = <?php echo $_cases_report_list->TitleID->Lookup->toClientList() ?>;
f_cases_reportlist.lists["x_TitleID"].options = <?php echo JsonEncode($_cases_report_list->TitleID->lookupOptions()) ?>;
f_cases_reportlist.lists["x_TitleID1"] = <?php echo $_cases_report_list->TitleID1->Lookup->toClientList() ?>;
f_cases_reportlist.lists["x_TitleID1"].options = <?php echo JsonEncode($_cases_report_list->TitleID1->lookupOptions()) ?>;

// Form object for search
var f_cases_reportlistsrch = currentSearchForm = new ew.Form("f_cases_reportlistsrch");

// Filters
f_cases_reportlistsrch.filterList = <?php echo $_cases_report_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$_cases_report->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($_cases_report_list->TotalRecs > 0 && $_cases_report_list->ExportOptions->visible()) { ?>
<?php $_cases_report_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($_cases_report_list->ImportOptions->visible()) { ?>
<?php $_cases_report_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($_cases_report_list->SearchOptions->visible()) { ?>
<?php $_cases_report_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($_cases_report_list->FilterOptions->visible()) { ?>
<?php $_cases_report_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$_cases_report_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$_cases_report->isExport() && !$_cases_report->CurrentAction) { ?>
<form name="f_cases_reportlistsrch" id="f_cases_reportlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($_cases_report_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="f_cases_reportlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="_cases_report">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($_cases_report_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($_cases_report_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $_cases_report_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($_cases_report_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($_cases_report_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($_cases_report_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($_cases_report_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $_cases_report_list->showPageHeader(); ?>
<?php
$_cases_report_list->showMessage();
?>
<?php if ($_cases_report_list->TotalRecs > 0 || $_cases_report->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($_cases_report_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> _cases_report">
<?php if (!$_cases_report->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$_cases_report->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($_cases_report_list->Pager)) $_cases_report_list->Pager = new PrevNextPager($_cases_report_list->StartRec, $_cases_report_list->DisplayRecs, $_cases_report_list->TotalRecs, $_cases_report_list->AutoHidePager) ?>
<?php if ($_cases_report_list->Pager->RecordCount > 0 && $_cases_report_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($_cases_report_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $_cases_report_list->pageUrl() ?>start=<?php echo $_cases_report_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($_cases_report_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $_cases_report_list->pageUrl() ?>start=<?php echo $_cases_report_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $_cases_report_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($_cases_report_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $_cases_report_list->pageUrl() ?>start=<?php echo $_cases_report_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($_cases_report_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $_cases_report_list->pageUrl() ?>start=<?php echo $_cases_report_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $_cases_report_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($_cases_report_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $_cases_report_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $_cases_report_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $_cases_report_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($_cases_report_list->TotalRecs > 0 && (!$_cases_report_list->AutoHidePageSizeSelector || $_cases_report_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="_cases_report">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($_cases_report_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($_cases_report_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($_cases_report_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($_cases_report_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($_cases_report_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($_cases_report_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($_cases_report_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($_cases_report_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($_cases_report_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($_cases_report->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $_cases_report_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="f_cases_reportlist" id="f_cases_reportlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($_cases_report_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $_cases_report_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="_cases_report">
<div id="gmp__cases_report" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($_cases_report_list->TotalRecs > 0 || $_cases_report->isGridEdit()) { ?>
<table id="tbl__cases_reportlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$_cases_report_list->RowType = ROWTYPE_HEADER;

// Render list options
$_cases_report_list->renderListOptions();

// Render list options (header, left)
$_cases_report_list->ListOptions->render("header", "left");
?>
<?php if ($_cases_report->ClientID->Visible) { // ClientID ?>
	<?php if ($_cases_report->sortUrl($_cases_report->ClientID) == "") { ?>
		<th data-name="ClientID" class="<?php echo $_cases_report->ClientID->headerCellClass() ?>" style="min-width: 150px;"><div id="elh__cases_report_ClientID" class="_cases_report_ClientID"><div class="ew-table-header-caption"><?php echo $_cases_report->ClientID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ClientID" class="<?php echo $_cases_report->ClientID->headerCellClass() ?>" style="min-width: 150px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_cases_report->SortUrl($_cases_report->ClientID) ?>',2);"><div id="elh__cases_report_ClientID" class="_cases_report_ClientID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_cases_report->ClientID->caption() ?></span><span class="ew-table-header-sort"><?php if ($_cases_report->ClientID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_cases_report->ClientID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_cases_report->LitigantID->Visible) { // LitigantID ?>
	<?php if ($_cases_report->sortUrl($_cases_report->LitigantID) == "") { ?>
		<th data-name="LitigantID" class="<?php echo $_cases_report->LitigantID->headerCellClass() ?>" style="width: 250px; white-space: nowrap;"><div id="elh__cases_report_LitigantID" class="_cases_report_LitigantID"><div class="ew-table-header-caption"><?php echo $_cases_report->LitigantID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LitigantID" class="<?php echo $_cases_report->LitigantID->headerCellClass() ?>" style="width: 250px; white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_cases_report->SortUrl($_cases_report->LitigantID) ?>',2);"><div id="elh__cases_report_LitigantID" class="_cases_report_LitigantID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_cases_report->LitigantID->caption() ?></span><span class="ew-table-header-sort"><?php if ($_cases_report->LitigantID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_cases_report->LitigantID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_cases_report->CaseTypeID->Visible) { // CaseTypeID ?>
	<?php if ($_cases_report->sortUrl($_cases_report->CaseTypeID) == "") { ?>
		<th data-name="CaseTypeID" class="<?php echo $_cases_report->CaseTypeID->headerCellClass() ?>" style="min-width: 120px;"><div id="elh__cases_report_CaseTypeID" class="_cases_report_CaseTypeID"><div class="ew-table-header-caption"><?php echo $_cases_report->CaseTypeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CaseTypeID" class="<?php echo $_cases_report->CaseTypeID->headerCellClass() ?>" style="min-width: 120px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_cases_report->SortUrl($_cases_report->CaseTypeID) ?>',2);"><div id="elh__cases_report_CaseTypeID" class="_cases_report_CaseTypeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_cases_report->CaseTypeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($_cases_report->CaseTypeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_cases_report->CaseTypeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_cases_report->FileNumber->Visible) { // FileNumber ?>
	<?php if ($_cases_report->sortUrl($_cases_report->FileNumber) == "") { ?>
		<th data-name="FileNumber" class="<?php echo $_cases_report->FileNumber->headerCellClass() ?>"><div id="elh__cases_report_FileNumber" class="_cases_report_FileNumber"><div class="ew-table-header-caption"><?php echo $_cases_report->FileNumber->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FileNumber" class="<?php echo $_cases_report->FileNumber->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_cases_report->SortUrl($_cases_report->FileNumber) ?>',2);"><div id="elh__cases_report_FileNumber" class="_cases_report_FileNumber">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_cases_report->FileNumber->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_cases_report->FileNumber->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_cases_report->FileNumber->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_cases_report->EnvelopeNumber->Visible) { // EnvelopeNumber ?>
	<?php if ($_cases_report->sortUrl($_cases_report->EnvelopeNumber) == "") { ?>
		<th data-name="EnvelopeNumber" class="<?php echo $_cases_report->EnvelopeNumber->headerCellClass() ?>"><div id="elh__cases_report_EnvelopeNumber" class="_cases_report_EnvelopeNumber"><div class="ew-table-header-caption"><?php echo $_cases_report->EnvelopeNumber->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="EnvelopeNumber" class="<?php echo $_cases_report->EnvelopeNumber->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_cases_report->SortUrl($_cases_report->EnvelopeNumber) ?>',2);"><div id="elh__cases_report_EnvelopeNumber" class="_cases_report_EnvelopeNumber">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_cases_report->EnvelopeNumber->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_cases_report->EnvelopeNumber->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_cases_report->EnvelopeNumber->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_cases_report->CaseNumber->Visible) { // CaseNumber ?>
	<?php if ($_cases_report->sortUrl($_cases_report->CaseNumber) == "") { ?>
		<th data-name="CaseNumber" class="<?php echo $_cases_report->CaseNumber->headerCellClass() ?>"><div id="elh__cases_report_CaseNumber" class="_cases_report_CaseNumber"><div class="ew-table-header-caption"><?php echo $_cases_report->CaseNumber->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CaseNumber" class="<?php echo $_cases_report->CaseNumber->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_cases_report->SortUrl($_cases_report->CaseNumber) ?>',2);"><div id="elh__cases_report_CaseNumber" class="_cases_report_CaseNumber">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_cases_report->CaseNumber->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_cases_report->CaseNumber->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_cases_report->CaseNumber->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_cases_report->ClientStatusID->Visible) { // ClientStatusID ?>
	<?php if ($_cases_report->sortUrl($_cases_report->ClientStatusID) == "") { ?>
		<th data-name="ClientStatusID" class="<?php echo $_cases_report->ClientStatusID->headerCellClass() ?>"><div id="elh__cases_report_ClientStatusID" class="_cases_report_ClientStatusID"><div class="ew-table-header-caption"><?php echo $_cases_report->ClientStatusID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ClientStatusID" class="<?php echo $_cases_report->ClientStatusID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_cases_report->SortUrl($_cases_report->ClientStatusID) ?>',2);"><div id="elh__cases_report_ClientStatusID" class="_cases_report_ClientStatusID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_cases_report->ClientStatusID->caption() ?></span><span class="ew-table-header-sort"><?php if ($_cases_report->ClientStatusID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_cases_report->ClientStatusID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_cases_report->LitigantStatusID->Visible) { // LitigantStatusID ?>
	<?php if ($_cases_report->sortUrl($_cases_report->LitigantStatusID) == "") { ?>
		<th data-name="LitigantStatusID" class="<?php echo $_cases_report->LitigantStatusID->headerCellClass() ?>"><div id="elh__cases_report_LitigantStatusID" class="_cases_report_LitigantStatusID"><div class="ew-table-header-caption"><?php echo $_cases_report->LitigantStatusID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LitigantStatusID" class="<?php echo $_cases_report->LitigantStatusID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_cases_report->SortUrl($_cases_report->LitigantStatusID) ?>',2);"><div id="elh__cases_report_LitigantStatusID" class="_cases_report_LitigantStatusID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_cases_report->LitigantStatusID->caption() ?></span><span class="ew-table-header-sort"><?php if ($_cases_report->LitigantStatusID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_cases_report->LitigantStatusID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_cases_report->CourtID->Visible) { // CourtID ?>
	<?php if ($_cases_report->sortUrl($_cases_report->CourtID) == "") { ?>
		<th data-name="CourtID" class="<?php echo $_cases_report->CourtID->headerCellClass() ?>" style="width: 200px; white-space: nowrap;"><div id="elh__cases_report_CourtID" class="_cases_report_CourtID"><div class="ew-table-header-caption"><?php echo $_cases_report->CourtID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CourtID" class="<?php echo $_cases_report->CourtID->headerCellClass() ?>" style="width: 200px; white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_cases_report->SortUrl($_cases_report->CourtID) ?>',2);"><div id="elh__cases_report_CourtID" class="_cases_report_CourtID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_cases_report->CourtID->caption() ?></span><span class="ew-table-header-sort"><?php if ($_cases_report->CourtID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_cases_report->CourtID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_cases_report->Notes->Visible) { // Notes ?>
	<?php if ($_cases_report->sortUrl($_cases_report->Notes) == "") { ?>
		<th data-name="Notes" class="<?php echo $_cases_report->Notes->headerCellClass() ?>" style="min-width: 200px;"><div id="elh__cases_report_Notes" class="_cases_report_Notes"><div class="ew-table-header-caption"><?php echo $_cases_report->Notes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Notes" class="<?php echo $_cases_report->Notes->headerCellClass() ?>" style="min-width: 200px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_cases_report->SortUrl($_cases_report->Notes) ?>',2);"><div id="elh__cases_report_Notes" class="_cases_report_Notes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_cases_report->Notes->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_cases_report->Notes->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_cases_report->Notes->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_cases_report->TitleID->Visible) { // TitleID ?>
	<?php if ($_cases_report->sortUrl($_cases_report->TitleID) == "") { ?>
		<th data-name="TitleID" class="<?php echo $_cases_report->TitleID->headerCellClass() ?>"><div id="elh__cases_report_TitleID" class="_cases_report_TitleID"><div class="ew-table-header-caption"><?php echo $_cases_report->TitleID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TitleID" class="<?php echo $_cases_report->TitleID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_cases_report->SortUrl($_cases_report->TitleID) ?>',2);"><div id="elh__cases_report_TitleID" class="_cases_report_TitleID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_cases_report->TitleID->caption() ?></span><span class="ew-table-header-sort"><?php if ($_cases_report->TitleID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_cases_report->TitleID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_cases_report->FirstName->Visible) { // FirstName ?>
	<?php if ($_cases_report->sortUrl($_cases_report->FirstName) == "") { ?>
		<th data-name="FirstName" class="<?php echo $_cases_report->FirstName->headerCellClass() ?>" style="min-width: 150px;"><div id="elh__cases_report_FirstName" class="_cases_report_FirstName"><div class="ew-table-header-caption"><?php echo $_cases_report->FirstName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FirstName" class="<?php echo $_cases_report->FirstName->headerCellClass() ?>" style="min-width: 150px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_cases_report->SortUrl($_cases_report->FirstName) ?>',2);"><div id="elh__cases_report_FirstName" class="_cases_report_FirstName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_cases_report->FirstName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_cases_report->FirstName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_cases_report->FirstName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_cases_report->MiddleName->Visible) { // MiddleName ?>
	<?php if ($_cases_report->sortUrl($_cases_report->MiddleName) == "") { ?>
		<th data-name="MiddleName" class="<?php echo $_cases_report->MiddleName->headerCellClass() ?>"><div id="elh__cases_report_MiddleName" class="_cases_report_MiddleName"><div class="ew-table-header-caption"><?php echo $_cases_report->MiddleName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="MiddleName" class="<?php echo $_cases_report->MiddleName->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_cases_report->SortUrl($_cases_report->MiddleName) ?>',2);"><div id="elh__cases_report_MiddleName" class="_cases_report_MiddleName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_cases_report->MiddleName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_cases_report->MiddleName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_cases_report->MiddleName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_cases_report->LastName->Visible) { // LastName ?>
	<?php if ($_cases_report->sortUrl($_cases_report->LastName) == "") { ?>
		<th data-name="LastName" class="<?php echo $_cases_report->LastName->headerCellClass() ?>"><div id="elh__cases_report_LastName" class="_cases_report_LastName"><div class="ew-table-header-caption"><?php echo $_cases_report->LastName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LastName" class="<?php echo $_cases_report->LastName->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_cases_report->SortUrl($_cases_report->LastName) ?>',2);"><div id="elh__cases_report_LastName" class="_cases_report_LastName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_cases_report->LastName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_cases_report->LastName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_cases_report->LastName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_cases_report->TitleID1->Visible) { // TitleID1 ?>
	<?php if ($_cases_report->sortUrl($_cases_report->TitleID1) == "") { ?>
		<th data-name="TitleID1" class="<?php echo $_cases_report->TitleID1->headerCellClass() ?>"><div id="elh__cases_report_TitleID1" class="_cases_report_TitleID1"><div class="ew-table-header-caption"><?php echo $_cases_report->TitleID1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TitleID1" class="<?php echo $_cases_report->TitleID1->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_cases_report->SortUrl($_cases_report->TitleID1) ?>',2);"><div id="elh__cases_report_TitleID1" class="_cases_report_TitleID1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_cases_report->TitleID1->caption() ?></span><span class="ew-table-header-sort"><?php if ($_cases_report->TitleID1->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_cases_report->TitleID1->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_cases_report->FirstName1->Visible) { // FirstName1 ?>
	<?php if ($_cases_report->sortUrl($_cases_report->FirstName1) == "") { ?>
		<th data-name="FirstName1" class="<?php echo $_cases_report->FirstName1->headerCellClass() ?>" style="min-width: 150px;"><div id="elh__cases_report_FirstName1" class="_cases_report_FirstName1"><div class="ew-table-header-caption"><?php echo $_cases_report->FirstName1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="FirstName1" class="<?php echo $_cases_report->FirstName1->headerCellClass() ?>" style="min-width: 150px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_cases_report->SortUrl($_cases_report->FirstName1) ?>',2);"><div id="elh__cases_report_FirstName1" class="_cases_report_FirstName1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_cases_report->FirstName1->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_cases_report->FirstName1->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_cases_report->FirstName1->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_cases_report->MiddleName1->Visible) { // MiddleName1 ?>
	<?php if ($_cases_report->sortUrl($_cases_report->MiddleName1) == "") { ?>
		<th data-name="MiddleName1" class="<?php echo $_cases_report->MiddleName1->headerCellClass() ?>"><div id="elh__cases_report_MiddleName1" class="_cases_report_MiddleName1"><div class="ew-table-header-caption"><?php echo $_cases_report->MiddleName1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="MiddleName1" class="<?php echo $_cases_report->MiddleName1->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_cases_report->SortUrl($_cases_report->MiddleName1) ?>',2);"><div id="elh__cases_report_MiddleName1" class="_cases_report_MiddleName1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_cases_report->MiddleName1->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_cases_report->MiddleName1->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_cases_report->MiddleName1->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_cases_report->LastName1->Visible) { // LastName1 ?>
	<?php if ($_cases_report->sortUrl($_cases_report->LastName1) == "") { ?>
		<th data-name="LastName1" class="<?php echo $_cases_report->LastName1->headerCellClass() ?>" style="min-width: 150px;"><div id="elh__cases_report_LastName1" class="_cases_report_LastName1"><div class="ew-table-header-caption"><?php echo $_cases_report->LastName1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="LastName1" class="<?php echo $_cases_report->LastName1->headerCellClass() ?>" style="min-width: 150px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_cases_report->SortUrl($_cases_report->LastName1) ?>',2);"><div id="elh__cases_report_LastName1" class="_cases_report_LastName1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_cases_report->LastName1->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_cases_report->LastName1->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_cases_report->LastName1->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_cases_report->PartnersName->Visible) { // PartnersName ?>
	<?php if ($_cases_report->sortUrl($_cases_report->PartnersName) == "") { ?>
		<th data-name="PartnersName" class="<?php echo $_cases_report->PartnersName->headerCellClass() ?>"><div id="elh__cases_report_PartnersName" class="_cases_report_PartnersName"><div class="ew-table-header-caption"><?php echo $_cases_report->PartnersName->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PartnersName" class="<?php echo $_cases_report->PartnersName->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_cases_report->SortUrl($_cases_report->PartnersName) ?>',2);"><div id="elh__cases_report_PartnersName" class="_cases_report_PartnersName">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_cases_report->PartnersName->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_cases_report->PartnersName->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_cases_report->PartnersName->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_cases_report->PartnersName1->Visible) { // PartnersName1 ?>
	<?php if ($_cases_report->sortUrl($_cases_report->PartnersName1) == "") { ?>
		<th data-name="PartnersName1" class="<?php echo $_cases_report->PartnersName1->headerCellClass() ?>"><div id="elh__cases_report_PartnersName1" class="_cases_report_PartnersName1"><div class="ew-table-header-caption"><?php echo $_cases_report->PartnersName1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PartnersName1" class="<?php echo $_cases_report->PartnersName1->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_cases_report->SortUrl($_cases_report->PartnersName1) ?>',2);"><div id="elh__cases_report_PartnersName1" class="_cases_report_PartnersName1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_cases_report->PartnersName1->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_cases_report->PartnersName1->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_cases_report->PartnersName1->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$_cases_report_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($_cases_report->ExportAll && $_cases_report->isExport()) {
	$_cases_report_list->StopRec = $_cases_report_list->TotalRecs;
} else {

	// Set the last record to display
	if ($_cases_report_list->TotalRecs > $_cases_report_list->StartRec + $_cases_report_list->DisplayRecs - 1)
		$_cases_report_list->StopRec = $_cases_report_list->StartRec + $_cases_report_list->DisplayRecs - 1;
	else
		$_cases_report_list->StopRec = $_cases_report_list->TotalRecs;
}
$_cases_report_list->RecCnt = $_cases_report_list->StartRec - 1;
if ($_cases_report_list->Recordset && !$_cases_report_list->Recordset->EOF) {
	$_cases_report_list->Recordset->moveFirst();
	$selectLimit = $_cases_report_list->UseSelectLimit;
	if (!$selectLimit && $_cases_report_list->StartRec > 1)
		$_cases_report_list->Recordset->move($_cases_report_list->StartRec - 1);
} elseif (!$_cases_report->AllowAddDeleteRow && $_cases_report_list->StopRec == 0) {
	$_cases_report_list->StopRec = $_cases_report->GridAddRowCount;
}

// Initialize aggregate
$_cases_report->RowType = ROWTYPE_AGGREGATEINIT;
$_cases_report->resetAttributes();
$_cases_report_list->renderRow();
while ($_cases_report_list->RecCnt < $_cases_report_list->StopRec) {
	$_cases_report_list->RecCnt++;
	if ($_cases_report_list->RecCnt >= $_cases_report_list->StartRec) {
		$_cases_report_list->RowCnt++;

		// Set up key count
		$_cases_report_list->KeyCount = $_cases_report_list->RowIndex;

		// Init row class and style
		$_cases_report->resetAttributes();
		$_cases_report->CssClass = "";
		if ($_cases_report->isGridAdd()) {
		} else {
			$_cases_report_list->loadRowValues($_cases_report_list->Recordset); // Load row values
		}
		$_cases_report->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$_cases_report->RowAttrs = array_merge($_cases_report->RowAttrs, array('data-rowindex'=>$_cases_report_list->RowCnt, 'id'=>'r' . $_cases_report_list->RowCnt . '__cases_report', 'data-rowtype'=>$_cases_report->RowType));

		// Render row
		$_cases_report_list->renderRow();

		// Render list options
		$_cases_report_list->renderListOptions();
?>
	<tr<?php echo $_cases_report->rowAttributes() ?>>
<?php

// Render list options (body, left)
$_cases_report_list->ListOptions->render("body", "left", $_cases_report_list->RowCnt);
?>
	<?php if ($_cases_report->ClientID->Visible) { // ClientID ?>
		<td data-name="ClientID"<?php echo $_cases_report->ClientID->cellAttributes() ?>>
<span id="el<?php echo $_cases_report_list->RowCnt ?>__cases_report_ClientID" class="_cases_report_ClientID">
<span<?php echo $_cases_report->ClientID->viewAttributes() ?>>
<?php if ((!EmptyString($_cases_report->ClientID->getViewValue())) && $_cases_report->ClientID->linkAttributes() <> "") { ?>
<a<?php echo $_cases_report->ClientID->linkAttributes() ?>><?php echo $_cases_report->ClientID->getViewValue() ?></a>
<?php } else { ?>
<?php echo $_cases_report->ClientID->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($_cases_report->LitigantID->Visible) { // LitigantID ?>
		<td data-name="LitigantID"<?php echo $_cases_report->LitigantID->cellAttributes() ?>>
<span id="el<?php echo $_cases_report_list->RowCnt ?>__cases_report_LitigantID" class="_cases_report_LitigantID">
<span<?php echo $_cases_report->LitigantID->viewAttributes() ?>>
<?php if ((!EmptyString($_cases_report->LitigantID->getViewValue())) && $_cases_report->LitigantID->linkAttributes() <> "") { ?>
<a<?php echo $_cases_report->LitigantID->linkAttributes() ?>><?php echo $_cases_report->LitigantID->getViewValue() ?></a>
<?php } else { ?>
<?php echo $_cases_report->LitigantID->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($_cases_report->CaseTypeID->Visible) { // CaseTypeID ?>
		<td data-name="CaseTypeID"<?php echo $_cases_report->CaseTypeID->cellAttributes() ?>>
<span id="el<?php echo $_cases_report_list->RowCnt ?>__cases_report_CaseTypeID" class="_cases_report_CaseTypeID">
<span<?php echo $_cases_report->CaseTypeID->viewAttributes() ?>>
<?php echo $_cases_report->CaseTypeID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_cases_report->FileNumber->Visible) { // FileNumber ?>
		<td data-name="FileNumber"<?php echo $_cases_report->FileNumber->cellAttributes() ?>>
<span id="el<?php echo $_cases_report_list->RowCnt ?>__cases_report_FileNumber" class="_cases_report_FileNumber">
<span<?php echo $_cases_report->FileNumber->viewAttributes() ?>>
<?php echo $_cases_report->FileNumber->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_cases_report->EnvelopeNumber->Visible) { // EnvelopeNumber ?>
		<td data-name="EnvelopeNumber"<?php echo $_cases_report->EnvelopeNumber->cellAttributes() ?>>
<span id="el<?php echo $_cases_report_list->RowCnt ?>__cases_report_EnvelopeNumber" class="_cases_report_EnvelopeNumber">
<span<?php echo $_cases_report->EnvelopeNumber->viewAttributes() ?>>
<?php echo $_cases_report->EnvelopeNumber->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_cases_report->CaseNumber->Visible) { // CaseNumber ?>
		<td data-name="CaseNumber"<?php echo $_cases_report->CaseNumber->cellAttributes() ?>>
<span id="el<?php echo $_cases_report_list->RowCnt ?>__cases_report_CaseNumber" class="_cases_report_CaseNumber">
<span<?php echo $_cases_report->CaseNumber->viewAttributes() ?>>
<?php echo $_cases_report->CaseNumber->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_cases_report->ClientStatusID->Visible) { // ClientStatusID ?>
		<td data-name="ClientStatusID"<?php echo $_cases_report->ClientStatusID->cellAttributes() ?>>
<span id="el<?php echo $_cases_report_list->RowCnt ?>__cases_report_ClientStatusID" class="_cases_report_ClientStatusID">
<span<?php echo $_cases_report->ClientStatusID->viewAttributes() ?>>
<?php echo $_cases_report->ClientStatusID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_cases_report->LitigantStatusID->Visible) { // LitigantStatusID ?>
		<td data-name="LitigantStatusID"<?php echo $_cases_report->LitigantStatusID->cellAttributes() ?>>
<span id="el<?php echo $_cases_report_list->RowCnt ?>__cases_report_LitigantStatusID" class="_cases_report_LitigantStatusID">
<span<?php echo $_cases_report->LitigantStatusID->viewAttributes() ?>>
<?php echo $_cases_report->LitigantStatusID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_cases_report->CourtID->Visible) { // CourtID ?>
		<td data-name="CourtID"<?php echo $_cases_report->CourtID->cellAttributes() ?>>
<span id="el<?php echo $_cases_report_list->RowCnt ?>__cases_report_CourtID" class="_cases_report_CourtID">
<span<?php echo $_cases_report->CourtID->viewAttributes() ?>>
<?php if ((!EmptyString($_cases_report->CourtID->getViewValue())) && $_cases_report->CourtID->linkAttributes() <> "") { ?>
<a<?php echo $_cases_report->CourtID->linkAttributes() ?>><?php echo $_cases_report->CourtID->getViewValue() ?></a>
<?php } else { ?>
<?php echo $_cases_report->CourtID->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($_cases_report->Notes->Visible) { // Notes ?>
		<td data-name="Notes"<?php echo $_cases_report->Notes->cellAttributes() ?>>
<span id="el<?php echo $_cases_report_list->RowCnt ?>__cases_report_Notes" class="_cases_report_Notes">
<span<?php echo $_cases_report->Notes->viewAttributes() ?>>
<?php echo $_cases_report->Notes->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_cases_report->TitleID->Visible) { // TitleID ?>
		<td data-name="TitleID"<?php echo $_cases_report->TitleID->cellAttributes() ?>>
<span id="el<?php echo $_cases_report_list->RowCnt ?>__cases_report_TitleID" class="_cases_report_TitleID">
<span<?php echo $_cases_report->TitleID->viewAttributes() ?>>
<?php echo $_cases_report->TitleID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_cases_report->FirstName->Visible) { // FirstName ?>
		<td data-name="FirstName"<?php echo $_cases_report->FirstName->cellAttributes() ?>>
<span id="el<?php echo $_cases_report_list->RowCnt ?>__cases_report_FirstName" class="_cases_report_FirstName">
<span<?php echo $_cases_report->FirstName->viewAttributes() ?>>
<?php echo $_cases_report->FirstName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_cases_report->MiddleName->Visible) { // MiddleName ?>
		<td data-name="MiddleName"<?php echo $_cases_report->MiddleName->cellAttributes() ?>>
<span id="el<?php echo $_cases_report_list->RowCnt ?>__cases_report_MiddleName" class="_cases_report_MiddleName">
<span<?php echo $_cases_report->MiddleName->viewAttributes() ?>>
<?php echo $_cases_report->MiddleName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_cases_report->LastName->Visible) { // LastName ?>
		<td data-name="LastName"<?php echo $_cases_report->LastName->cellAttributes() ?>>
<span id="el<?php echo $_cases_report_list->RowCnt ?>__cases_report_LastName" class="_cases_report_LastName">
<span<?php echo $_cases_report->LastName->viewAttributes() ?>>
<?php echo $_cases_report->LastName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_cases_report->TitleID1->Visible) { // TitleID1 ?>
		<td data-name="TitleID1"<?php echo $_cases_report->TitleID1->cellAttributes() ?>>
<span id="el<?php echo $_cases_report_list->RowCnt ?>__cases_report_TitleID1" class="_cases_report_TitleID1">
<span<?php echo $_cases_report->TitleID1->viewAttributes() ?>>
<?php echo $_cases_report->TitleID1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_cases_report->FirstName1->Visible) { // FirstName1 ?>
		<td data-name="FirstName1"<?php echo $_cases_report->FirstName1->cellAttributes() ?>>
<span id="el<?php echo $_cases_report_list->RowCnt ?>__cases_report_FirstName1" class="_cases_report_FirstName1">
<span<?php echo $_cases_report->FirstName1->viewAttributes() ?>>
<?php echo $_cases_report->FirstName1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_cases_report->MiddleName1->Visible) { // MiddleName1 ?>
		<td data-name="MiddleName1"<?php echo $_cases_report->MiddleName1->cellAttributes() ?>>
<span id="el<?php echo $_cases_report_list->RowCnt ?>__cases_report_MiddleName1" class="_cases_report_MiddleName1">
<span<?php echo $_cases_report->MiddleName1->viewAttributes() ?>>
<?php echo $_cases_report->MiddleName1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_cases_report->LastName1->Visible) { // LastName1 ?>
		<td data-name="LastName1"<?php echo $_cases_report->LastName1->cellAttributes() ?>>
<span id="el<?php echo $_cases_report_list->RowCnt ?>__cases_report_LastName1" class="_cases_report_LastName1">
<span<?php echo $_cases_report->LastName1->viewAttributes() ?>>
<?php echo $_cases_report->LastName1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_cases_report->PartnersName->Visible) { // PartnersName ?>
		<td data-name="PartnersName"<?php echo $_cases_report->PartnersName->cellAttributes() ?>>
<span id="el<?php echo $_cases_report_list->RowCnt ?>__cases_report_PartnersName" class="_cases_report_PartnersName">
<span<?php echo $_cases_report->PartnersName->viewAttributes() ?>>
<?php echo $_cases_report->PartnersName->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_cases_report->PartnersName1->Visible) { // PartnersName1 ?>
		<td data-name="PartnersName1"<?php echo $_cases_report->PartnersName1->cellAttributes() ?>>
<span id="el<?php echo $_cases_report_list->RowCnt ?>__cases_report_PartnersName1" class="_cases_report_PartnersName1">
<span<?php echo $_cases_report->PartnersName1->viewAttributes() ?>>
<?php echo $_cases_report->PartnersName1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$_cases_report_list->ListOptions->render("body", "right", $_cases_report_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$_cases_report->isGridAdd())
		$_cases_report_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$_cases_report->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($_cases_report_list->Recordset)
	$_cases_report_list->Recordset->Close();
?>
<?php if (!$_cases_report->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$_cases_report->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($_cases_report_list->Pager)) $_cases_report_list->Pager = new PrevNextPager($_cases_report_list->StartRec, $_cases_report_list->DisplayRecs, $_cases_report_list->TotalRecs, $_cases_report_list->AutoHidePager) ?>
<?php if ($_cases_report_list->Pager->RecordCount > 0 && $_cases_report_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($_cases_report_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $_cases_report_list->pageUrl() ?>start=<?php echo $_cases_report_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($_cases_report_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $_cases_report_list->pageUrl() ?>start=<?php echo $_cases_report_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $_cases_report_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($_cases_report_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $_cases_report_list->pageUrl() ?>start=<?php echo $_cases_report_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($_cases_report_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $_cases_report_list->pageUrl() ?>start=<?php echo $_cases_report_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $_cases_report_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($_cases_report_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $_cases_report_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $_cases_report_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $_cases_report_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($_cases_report_list->TotalRecs > 0 && (!$_cases_report_list->AutoHidePageSizeSelector || $_cases_report_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="_cases_report">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($_cases_report_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($_cases_report_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($_cases_report_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($_cases_report_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($_cases_report_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($_cases_report_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($_cases_report_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($_cases_report_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($_cases_report_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($_cases_report->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $_cases_report_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($_cases_report_list->TotalRecs == 0 && !$_cases_report->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $_cases_report_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$_cases_report_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$_cases_report->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$_cases_report->isExport()) { ?>
<script>
ew.scrollableTable("gmp__cases_report", "", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$_cases_report_list->terminate();
?>
