<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$address_edit = new address_edit();

// Run the page
$address_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$address_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var faddressedit = currentForm = new ew.Form("faddressedit", "edit");

// Validate form
faddressedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($address_edit->AddressID->Required) { ?>
			elm = this.getElements("x" + infix + "_AddressID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $address->AddressID->caption(), $address->AddressID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($address_edit->AddressTypeID->Required) { ?>
			elm = this.getElements("x" + infix + "_AddressTypeID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $address->AddressTypeID->caption(), $address->AddressTypeID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($address_edit->Address->Required) { ?>
			elm = this.getElements("x" + infix + "_Address");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $address->Address->caption(), $address->Address->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($address_edit->City->Required) { ?>
			elm = this.getElements("x" + infix + "_City");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $address->City->caption(), $address->City->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($address_edit->Region->Required) { ?>
			elm = this.getElements("x" + infix + "_Region");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $address->Region->caption(), $address->Region->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($address_edit->PostalCode->Required) { ?>
			elm = this.getElements("x" + infix + "_PostalCode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $address->PostalCode->caption(), $address->PostalCode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($address_edit->Country->Required) { ?>
			elm = this.getElements("x" + infix + "_Country");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $address->Country->caption(), $address->Country->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($address_edit->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $address->Notes->caption(), $address->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($address_edit->Primary->Required) { ?>
			elm = this.getElements("x" + infix + "_Primary[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $address->Primary->caption(), $address->Primary->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
faddressedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
faddressedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
faddressedit.lists["x_AddressTypeID"] = <?php echo $address_edit->AddressTypeID->Lookup->toClientList() ?>;
faddressedit.lists["x_AddressTypeID"].options = <?php echo JsonEncode($address_edit->AddressTypeID->lookupOptions()) ?>;
faddressedit.lists["x_Primary[]"] = <?php echo $address_edit->Primary->Lookup->toClientList() ?>;
faddressedit.lists["x_Primary[]"].options = <?php echo JsonEncode($address_edit->Primary->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $address_edit->showPageHeader(); ?>
<?php
$address_edit->showMessage();
?>
<?php if (!$address_edit->IsModal) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($address_edit->Pager)) $address_edit->Pager = new PrevNextPager($address_edit->StartRec, $address_edit->DisplayRecs, $address_edit->TotalRecs, $address_edit->AutoHidePager) ?>
<?php if ($address_edit->Pager->RecordCount > 0 && $address_edit->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($address_edit->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $address_edit->pageUrl() ?>start=<?php echo $address_edit->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($address_edit->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $address_edit->pageUrl() ?>start=<?php echo $address_edit->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $address_edit->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($address_edit->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $address_edit->pageUrl() ?>start=<?php echo $address_edit->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($address_edit->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $address_edit->pageUrl() ?>start=<?php echo $address_edit->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $address_edit->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<form name="faddressedit" id="faddressedit" class="<?php echo $address_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($address_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $address_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="address">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$address_edit->IsModal ?>">
<?php if (!$address_edit->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($address_edit->IsMobileOrModal) { ?>
<div class="ew-edit-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_addressedit" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($address->AddressID->Visible) { // AddressID ?>
<?php if ($address_edit->IsMobileOrModal) { ?>
	<div id="r_AddressID" class="form-group row">
		<label id="elh_address_AddressID" class="<?php echo $address_edit->LeftColumnClass ?>"><?php echo $address->AddressID->caption() ?><?php echo ($address->AddressID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $address_edit->RightColumnClass ?>"><div<?php echo $address->AddressID->cellAttributes() ?>>
<span id="el_address_AddressID">
<span<?php echo $address->AddressID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($address->AddressID->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="address" data-field="x_AddressID" name="x_AddressID" id="x_AddressID" value="<?php echo HtmlEncode($address->AddressID->CurrentValue) ?>">
<?php echo $address->AddressID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_AddressID">
		<td class="<?php echo $address_edit->TableLeftColumnClass ?>"><span id="elh_address_AddressID"><?php echo $address->AddressID->caption() ?><?php echo ($address->AddressID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $address->AddressID->cellAttributes() ?>>
<span id="el_address_AddressID">
<span<?php echo $address->AddressID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($address->AddressID->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="address" data-field="x_AddressID" name="x_AddressID" id="x_AddressID" value="<?php echo HtmlEncode($address->AddressID->CurrentValue) ?>">
<?php echo $address->AddressID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($address->AddressTypeID->Visible) { // AddressTypeID ?>
<?php if ($address_edit->IsMobileOrModal) { ?>
	<div id="r_AddressTypeID" class="form-group row">
		<label id="elh_address_AddressTypeID" for="x_AddressTypeID" class="<?php echo $address_edit->LeftColumnClass ?>"><?php echo $address->AddressTypeID->caption() ?><?php echo ($address->AddressTypeID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $address_edit->RightColumnClass ?>"><div<?php echo $address->AddressTypeID->cellAttributes() ?>>
<span id="el_address_AddressTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="address" data-field="x_AddressTypeID" data-value-separator="<?php echo $address->AddressTypeID->displayValueSeparatorAttribute() ?>" id="x_AddressTypeID" name="x_AddressTypeID"<?php echo $address->AddressTypeID->editAttributes() ?>>
		<?php echo $address->AddressTypeID->selectOptionListHtml("x_AddressTypeID") ?>
	</select>
</div>
<?php echo $address->AddressTypeID->Lookup->getParamTag("p_x_AddressTypeID") ?>
</span>
<?php echo $address->AddressTypeID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_AddressTypeID">
		<td class="<?php echo $address_edit->TableLeftColumnClass ?>"><span id="elh_address_AddressTypeID"><?php echo $address->AddressTypeID->caption() ?><?php echo ($address->AddressTypeID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $address->AddressTypeID->cellAttributes() ?>>
<span id="el_address_AddressTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="address" data-field="x_AddressTypeID" data-value-separator="<?php echo $address->AddressTypeID->displayValueSeparatorAttribute() ?>" id="x_AddressTypeID" name="x_AddressTypeID"<?php echo $address->AddressTypeID->editAttributes() ?>>
		<?php echo $address->AddressTypeID->selectOptionListHtml("x_AddressTypeID") ?>
	</select>
</div>
<?php echo $address->AddressTypeID->Lookup->getParamTag("p_x_AddressTypeID") ?>
</span>
<?php echo $address->AddressTypeID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($address->Address->Visible) { // Address ?>
<?php if ($address_edit->IsMobileOrModal) { ?>
	<div id="r_Address" class="form-group row">
		<label id="elh_address_Address" for="x_Address" class="<?php echo $address_edit->LeftColumnClass ?>"><?php echo $address->Address->caption() ?><?php echo ($address->Address->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $address_edit->RightColumnClass ?>"><div<?php echo $address->Address->cellAttributes() ?>>
<span id="el_address_Address">
<input type="text" data-table="address" data-field="x_Address" name="x_Address" id="x_Address" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($address->Address->getPlaceHolder()) ?>" value="<?php echo $address->Address->EditValue ?>"<?php echo $address->Address->editAttributes() ?>>
</span>
<?php echo $address->Address->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Address">
		<td class="<?php echo $address_edit->TableLeftColumnClass ?>"><span id="elh_address_Address"><?php echo $address->Address->caption() ?><?php echo ($address->Address->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $address->Address->cellAttributes() ?>>
<span id="el_address_Address">
<input type="text" data-table="address" data-field="x_Address" name="x_Address" id="x_Address" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($address->Address->getPlaceHolder()) ?>" value="<?php echo $address->Address->EditValue ?>"<?php echo $address->Address->editAttributes() ?>>
</span>
<?php echo $address->Address->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($address->City->Visible) { // City ?>
<?php if ($address_edit->IsMobileOrModal) { ?>
	<div id="r_City" class="form-group row">
		<label id="elh_address_City" for="x_City" class="<?php echo $address_edit->LeftColumnClass ?>"><?php echo $address->City->caption() ?><?php echo ($address->City->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $address_edit->RightColumnClass ?>"><div<?php echo $address->City->cellAttributes() ?>>
<span id="el_address_City">
<input type="text" data-table="address" data-field="x_City" name="x_City" id="x_City" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($address->City->getPlaceHolder()) ?>" value="<?php echo $address->City->EditValue ?>"<?php echo $address->City->editAttributes() ?>>
</span>
<?php echo $address->City->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_City">
		<td class="<?php echo $address_edit->TableLeftColumnClass ?>"><span id="elh_address_City"><?php echo $address->City->caption() ?><?php echo ($address->City->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $address->City->cellAttributes() ?>>
<span id="el_address_City">
<input type="text" data-table="address" data-field="x_City" name="x_City" id="x_City" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($address->City->getPlaceHolder()) ?>" value="<?php echo $address->City->EditValue ?>"<?php echo $address->City->editAttributes() ?>>
</span>
<?php echo $address->City->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($address->Region->Visible) { // Region ?>
<?php if ($address_edit->IsMobileOrModal) { ?>
	<div id="r_Region" class="form-group row">
		<label id="elh_address_Region" for="x_Region" class="<?php echo $address_edit->LeftColumnClass ?>"><?php echo $address->Region->caption() ?><?php echo ($address->Region->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $address_edit->RightColumnClass ?>"><div<?php echo $address->Region->cellAttributes() ?>>
<span id="el_address_Region">
<input type="text" data-table="address" data-field="x_Region" name="x_Region" id="x_Region" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($address->Region->getPlaceHolder()) ?>" value="<?php echo $address->Region->EditValue ?>"<?php echo $address->Region->editAttributes() ?>>
</span>
<?php echo $address->Region->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Region">
		<td class="<?php echo $address_edit->TableLeftColumnClass ?>"><span id="elh_address_Region"><?php echo $address->Region->caption() ?><?php echo ($address->Region->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $address->Region->cellAttributes() ?>>
<span id="el_address_Region">
<input type="text" data-table="address" data-field="x_Region" name="x_Region" id="x_Region" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($address->Region->getPlaceHolder()) ?>" value="<?php echo $address->Region->EditValue ?>"<?php echo $address->Region->editAttributes() ?>>
</span>
<?php echo $address->Region->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($address->PostalCode->Visible) { // PostalCode ?>
<?php if ($address_edit->IsMobileOrModal) { ?>
	<div id="r_PostalCode" class="form-group row">
		<label id="elh_address_PostalCode" for="x_PostalCode" class="<?php echo $address_edit->LeftColumnClass ?>"><?php echo $address->PostalCode->caption() ?><?php echo ($address->PostalCode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $address_edit->RightColumnClass ?>"><div<?php echo $address->PostalCode->cellAttributes() ?>>
<span id="el_address_PostalCode">
<input type="text" data-table="address" data-field="x_PostalCode" name="x_PostalCode" id="x_PostalCode" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($address->PostalCode->getPlaceHolder()) ?>" value="<?php echo $address->PostalCode->EditValue ?>"<?php echo $address->PostalCode->editAttributes() ?>>
</span>
<?php echo $address->PostalCode->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_PostalCode">
		<td class="<?php echo $address_edit->TableLeftColumnClass ?>"><span id="elh_address_PostalCode"><?php echo $address->PostalCode->caption() ?><?php echo ($address->PostalCode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $address->PostalCode->cellAttributes() ?>>
<span id="el_address_PostalCode">
<input type="text" data-table="address" data-field="x_PostalCode" name="x_PostalCode" id="x_PostalCode" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($address->PostalCode->getPlaceHolder()) ?>" value="<?php echo $address->PostalCode->EditValue ?>"<?php echo $address->PostalCode->editAttributes() ?>>
</span>
<?php echo $address->PostalCode->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($address->Country->Visible) { // Country ?>
<?php if ($address_edit->IsMobileOrModal) { ?>
	<div id="r_Country" class="form-group row">
		<label id="elh_address_Country" for="x_Country" class="<?php echo $address_edit->LeftColumnClass ?>"><?php echo $address->Country->caption() ?><?php echo ($address->Country->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $address_edit->RightColumnClass ?>"><div<?php echo $address->Country->cellAttributes() ?>>
<span id="el_address_Country">
<input type="text" data-table="address" data-field="x_Country" name="x_Country" id="x_Country" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($address->Country->getPlaceHolder()) ?>" value="<?php echo $address->Country->EditValue ?>"<?php echo $address->Country->editAttributes() ?>>
</span>
<?php echo $address->Country->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Country">
		<td class="<?php echo $address_edit->TableLeftColumnClass ?>"><span id="elh_address_Country"><?php echo $address->Country->caption() ?><?php echo ($address->Country->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $address->Country->cellAttributes() ?>>
<span id="el_address_Country">
<input type="text" data-table="address" data-field="x_Country" name="x_Country" id="x_Country" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($address->Country->getPlaceHolder()) ?>" value="<?php echo $address->Country->EditValue ?>"<?php echo $address->Country->editAttributes() ?>>
</span>
<?php echo $address->Country->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($address->Notes->Visible) { // Notes ?>
<?php if ($address_edit->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label id="elh_address_Notes" for="x_Notes" class="<?php echo $address_edit->LeftColumnClass ?>"><?php echo $address->Notes->caption() ?><?php echo ($address->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $address_edit->RightColumnClass ?>"><div<?php echo $address->Notes->cellAttributes() ?>>
<span id="el_address_Notes">
<input type="text" data-table="address" data-field="x_Notes" name="x_Notes" id="x_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($address->Notes->getPlaceHolder()) ?>" value="<?php echo $address->Notes->EditValue ?>"<?php echo $address->Notes->editAttributes() ?>>
</span>
<?php echo $address->Notes->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $address_edit->TableLeftColumnClass ?>"><span id="elh_address_Notes"><?php echo $address->Notes->caption() ?><?php echo ($address->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $address->Notes->cellAttributes() ?>>
<span id="el_address_Notes">
<input type="text" data-table="address" data-field="x_Notes" name="x_Notes" id="x_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($address->Notes->getPlaceHolder()) ?>" value="<?php echo $address->Notes->EditValue ?>"<?php echo $address->Notes->editAttributes() ?>>
</span>
<?php echo $address->Notes->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($address->Primary->Visible) { // Primary ?>
<?php if ($address_edit->IsMobileOrModal) { ?>
	<div id="r_Primary" class="form-group row">
		<label id="elh_address_Primary" class="<?php echo $address_edit->LeftColumnClass ?>"><?php echo $address->Primary->caption() ?><?php echo ($address->Primary->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $address_edit->RightColumnClass ?>"><div<?php echo $address->Primary->cellAttributes() ?>>
<span id="el_address_Primary">
<?php
$selwrk = (ConvertToBool($address->Primary->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="address" data-field="x_Primary" name="x_Primary[]" id="x_Primary[]" value="1"<?php echo $selwrk ?><?php echo $address->Primary->editAttributes() ?>>
</span>
<?php echo $address->Primary->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Primary">
		<td class="<?php echo $address_edit->TableLeftColumnClass ?>"><span id="elh_address_Primary"><?php echo $address->Primary->caption() ?><?php echo ($address->Primary->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $address->Primary->cellAttributes() ?>>
<span id="el_address_Primary">
<?php
$selwrk = (ConvertToBool($address->Primary->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="address" data-field="x_Primary" name="x_Primary[]" id="x_Primary[]" value="1"<?php echo $selwrk ?><?php echo $address->Primary->editAttributes() ?>>
</span>
<?php echo $address->Primary->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($address_edit->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if (!$address_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $address_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $address_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$address_edit->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
<?php if (!$address_edit->IsModal) { ?>
<?php if (!isset($address_edit->Pager)) $address_edit->Pager = new PrevNextPager($address_edit->StartRec, $address_edit->DisplayRecs, $address_edit->TotalRecs, $address_edit->AutoHidePager) ?>
<?php if ($address_edit->Pager->RecordCount > 0 && $address_edit->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($address_edit->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $address_edit->pageUrl() ?>start=<?php echo $address_edit->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($address_edit->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $address_edit->pageUrl() ?>start=<?php echo $address_edit->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $address_edit->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($address_edit->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $address_edit->pageUrl() ?>start=<?php echo $address_edit->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($address_edit->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $address_edit->pageUrl() ?>start=<?php echo $address_edit->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $address_edit->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
<?php } ?>
</form>
<?php
$address_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$address_edit->terminate();
?>
