<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$address_list = new address_list();

// Run the page
$address_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$address_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$address->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var faddresslist = currentForm = new ew.Form("faddresslist", "list");
faddresslist.formKeyCountName = '<?php echo $address_list->FormKeyCountName ?>';

// Form_CustomValidate event
faddresslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
faddresslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
faddresslist.lists["x_AddressTypeID"] = <?php echo $address_list->AddressTypeID->Lookup->toClientList() ?>;
faddresslist.lists["x_AddressTypeID"].options = <?php echo JsonEncode($address_list->AddressTypeID->lookupOptions()) ?>;
faddresslist.lists["x_Primary[]"] = <?php echo $address_list->Primary->Lookup->toClientList() ?>;
faddresslist.lists["x_Primary[]"].options = <?php echo JsonEncode($address_list->Primary->options(FALSE, TRUE)) ?>;

// Form object for search
var faddresslistsrch = currentSearchForm = new ew.Form("faddresslistsrch");

// Validate function for search
faddresslistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
faddresslistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
faddresslistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
faddresslistsrch.lists["x_Primary[]"] = <?php echo $address_list->Primary->Lookup->toClientList() ?>;
faddresslistsrch.lists["x_Primary[]"].options = <?php echo JsonEncode($address_list->Primary->options(FALSE, TRUE)) ?>;

// Filters
faddresslistsrch.filterList = <?php echo $address_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$address->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($address_list->TotalRecs > 0 && $address_list->ExportOptions->visible()) { ?>
<?php $address_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($address_list->ImportOptions->visible()) { ?>
<?php $address_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($address_list->SearchOptions->visible()) { ?>
<?php $address_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($address_list->FilterOptions->visible()) { ?>
<?php $address_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$address_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$address->isExport() && !$address->CurrentAction) { ?>
<form name="faddresslistsrch" id="faddresslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($address_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="faddresslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="address">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$address_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$address->RowType = ROWTYPE_SEARCH;

// Render row
$address->resetAttributes();
$address_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($address->Primary->Visible) { // Primary ?>
	<div id="xsc_Primary" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $address->Primary->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Primary" id="z_Primary" value="="></span>
		<span class="ew-search-field">
<?php
$selwrk = (ConvertToBool($address->Primary->AdvancedSearch->SearchValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="address" data-field="x_Primary" name="x_Primary[]" id="x_Primary[]" value="1"<?php echo $selwrk ?><?php echo $address->Primary->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($address_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($address_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $address_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($address_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($address_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($address_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($address_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $address_list->showPageHeader(); ?>
<?php
$address_list->showMessage();
?>
<?php if ($address_list->TotalRecs > 0 || $address->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($address_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> address">
<?php if (!$address->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$address->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($address_list->Pager)) $address_list->Pager = new PrevNextPager($address_list->StartRec, $address_list->DisplayRecs, $address_list->TotalRecs, $address_list->AutoHidePager) ?>
<?php if ($address_list->Pager->RecordCount > 0 && $address_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($address_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $address_list->pageUrl() ?>start=<?php echo $address_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($address_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $address_list->pageUrl() ?>start=<?php echo $address_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $address_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($address_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $address_list->pageUrl() ?>start=<?php echo $address_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($address_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $address_list->pageUrl() ?>start=<?php echo $address_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $address_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($address_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $address_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $address_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $address_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($address_list->TotalRecs > 0 && (!$address_list->AutoHidePageSizeSelector || $address_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="address">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($address_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($address_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($address_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($address_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($address_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($address_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($address_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($address_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($address_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($address->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $address_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="faddresslist" id="faddresslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($address_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $address_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="address">
<div id="gmp_address" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($address_list->TotalRecs > 0 || $address->isGridEdit()) { ?>
<table id="tbl_addresslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$address_list->RowType = ROWTYPE_HEADER;

// Render list options
$address_list->renderListOptions();

// Render list options (header, left)
$address_list->ListOptions->render("header", "left");
?>
<?php if ($address->AddressID->Visible) { // AddressID ?>
	<?php if ($address->sortUrl($address->AddressID) == "") { ?>
		<th data-name="AddressID" class="<?php echo $address->AddressID->headerCellClass() ?>"><div id="elh_address_AddressID" class="address_AddressID"><div class="ew-table-header-caption"><?php echo $address->AddressID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="AddressID" class="<?php echo $address->AddressID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $address->SortUrl($address->AddressID) ?>',2);"><div id="elh_address_AddressID" class="address_AddressID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $address->AddressID->caption() ?></span><span class="ew-table-header-sort"><?php if ($address->AddressID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($address->AddressID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($address->AddressTypeID->Visible) { // AddressTypeID ?>
	<?php if ($address->sortUrl($address->AddressTypeID) == "") { ?>
		<th data-name="AddressTypeID" class="<?php echo $address->AddressTypeID->headerCellClass() ?>"><div id="elh_address_AddressTypeID" class="address_AddressTypeID"><div class="ew-table-header-caption"><?php echo $address->AddressTypeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="AddressTypeID" class="<?php echo $address->AddressTypeID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $address->SortUrl($address->AddressTypeID) ?>',2);"><div id="elh_address_AddressTypeID" class="address_AddressTypeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $address->AddressTypeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($address->AddressTypeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($address->AddressTypeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($address->Address->Visible) { // Address ?>
	<?php if ($address->sortUrl($address->Address) == "") { ?>
		<th data-name="Address" class="<?php echo $address->Address->headerCellClass() ?>"><div id="elh_address_Address" class="address_Address"><div class="ew-table-header-caption"><?php echo $address->Address->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Address" class="<?php echo $address->Address->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $address->SortUrl($address->Address) ?>',2);"><div id="elh_address_Address" class="address_Address">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $address->Address->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($address->Address->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($address->Address->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($address->City->Visible) { // City ?>
	<?php if ($address->sortUrl($address->City) == "") { ?>
		<th data-name="City" class="<?php echo $address->City->headerCellClass() ?>"><div id="elh_address_City" class="address_City"><div class="ew-table-header-caption"><?php echo $address->City->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="City" class="<?php echo $address->City->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $address->SortUrl($address->City) ?>',2);"><div id="elh_address_City" class="address_City">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $address->City->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($address->City->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($address->City->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($address->Region->Visible) { // Region ?>
	<?php if ($address->sortUrl($address->Region) == "") { ?>
		<th data-name="Region" class="<?php echo $address->Region->headerCellClass() ?>"><div id="elh_address_Region" class="address_Region"><div class="ew-table-header-caption"><?php echo $address->Region->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Region" class="<?php echo $address->Region->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $address->SortUrl($address->Region) ?>',2);"><div id="elh_address_Region" class="address_Region">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $address->Region->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($address->Region->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($address->Region->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($address->PostalCode->Visible) { // PostalCode ?>
	<?php if ($address->sortUrl($address->PostalCode) == "") { ?>
		<th data-name="PostalCode" class="<?php echo $address->PostalCode->headerCellClass() ?>"><div id="elh_address_PostalCode" class="address_PostalCode"><div class="ew-table-header-caption"><?php echo $address->PostalCode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PostalCode" class="<?php echo $address->PostalCode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $address->SortUrl($address->PostalCode) ?>',2);"><div id="elh_address_PostalCode" class="address_PostalCode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $address->PostalCode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($address->PostalCode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($address->PostalCode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($address->Country->Visible) { // Country ?>
	<?php if ($address->sortUrl($address->Country) == "") { ?>
		<th data-name="Country" class="<?php echo $address->Country->headerCellClass() ?>"><div id="elh_address_Country" class="address_Country"><div class="ew-table-header-caption"><?php echo $address->Country->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Country" class="<?php echo $address->Country->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $address->SortUrl($address->Country) ?>',2);"><div id="elh_address_Country" class="address_Country">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $address->Country->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($address->Country->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($address->Country->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($address->Notes->Visible) { // Notes ?>
	<?php if ($address->sortUrl($address->Notes) == "") { ?>
		<th data-name="Notes" class="<?php echo $address->Notes->headerCellClass() ?>"><div id="elh_address_Notes" class="address_Notes"><div class="ew-table-header-caption"><?php echo $address->Notes->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Notes" class="<?php echo $address->Notes->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $address->SortUrl($address->Notes) ?>',2);"><div id="elh_address_Notes" class="address_Notes">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $address->Notes->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($address->Notes->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($address->Notes->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($address->Primary->Visible) { // Primary ?>
	<?php if ($address->sortUrl($address->Primary) == "") { ?>
		<th data-name="Primary" class="<?php echo $address->Primary->headerCellClass() ?>"><div id="elh_address_Primary" class="address_Primary"><div class="ew-table-header-caption"><?php echo $address->Primary->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Primary" class="<?php echo $address->Primary->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $address->SortUrl($address->Primary) ?>',2);"><div id="elh_address_Primary" class="address_Primary">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $address->Primary->caption() ?></span><span class="ew-table-header-sort"><?php if ($address->Primary->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($address->Primary->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$address_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($address->ExportAll && $address->isExport()) {
	$address_list->StopRec = $address_list->TotalRecs;
} else {

	// Set the last record to display
	if ($address_list->TotalRecs > $address_list->StartRec + $address_list->DisplayRecs - 1)
		$address_list->StopRec = $address_list->StartRec + $address_list->DisplayRecs - 1;
	else
		$address_list->StopRec = $address_list->TotalRecs;
}
$address_list->RecCnt = $address_list->StartRec - 1;
if ($address_list->Recordset && !$address_list->Recordset->EOF) {
	$address_list->Recordset->moveFirst();
	$selectLimit = $address_list->UseSelectLimit;
	if (!$selectLimit && $address_list->StartRec > 1)
		$address_list->Recordset->move($address_list->StartRec - 1);
} elseif (!$address->AllowAddDeleteRow && $address_list->StopRec == 0) {
	$address_list->StopRec = $address->GridAddRowCount;
}

// Initialize aggregate
$address->RowType = ROWTYPE_AGGREGATEINIT;
$address->resetAttributes();
$address_list->renderRow();
while ($address_list->RecCnt < $address_list->StopRec) {
	$address_list->RecCnt++;
	if ($address_list->RecCnt >= $address_list->StartRec) {
		$address_list->RowCnt++;

		// Set up key count
		$address_list->KeyCount = $address_list->RowIndex;

		// Init row class and style
		$address->resetAttributes();
		$address->CssClass = "";
		if ($address->isGridAdd()) {
		} else {
			$address_list->loadRowValues($address_list->Recordset); // Load row values
		}
		$address->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$address->RowAttrs = array_merge($address->RowAttrs, array('data-rowindex'=>$address_list->RowCnt, 'id'=>'r' . $address_list->RowCnt . '_address', 'data-rowtype'=>$address->RowType));

		// Render row
		$address_list->renderRow();

		// Render list options
		$address_list->renderListOptions();
?>
	<tr<?php echo $address->rowAttributes() ?>>
<?php

// Render list options (body, left)
$address_list->ListOptions->render("body", "left", $address_list->RowCnt);
?>
	<?php if ($address->AddressID->Visible) { // AddressID ?>
		<td data-name="AddressID"<?php echo $address->AddressID->cellAttributes() ?>>
<span id="el<?php echo $address_list->RowCnt ?>_address_AddressID" class="address_AddressID">
<span<?php echo $address->AddressID->viewAttributes() ?>>
<?php echo $address->AddressID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($address->AddressTypeID->Visible) { // AddressTypeID ?>
		<td data-name="AddressTypeID"<?php echo $address->AddressTypeID->cellAttributes() ?>>
<span id="el<?php echo $address_list->RowCnt ?>_address_AddressTypeID" class="address_AddressTypeID">
<span<?php echo $address->AddressTypeID->viewAttributes() ?>>
<?php echo $address->AddressTypeID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($address->Address->Visible) { // Address ?>
		<td data-name="Address"<?php echo $address->Address->cellAttributes() ?>>
<span id="el<?php echo $address_list->RowCnt ?>_address_Address" class="address_Address">
<span<?php echo $address->Address->viewAttributes() ?>>
<?php echo $address->Address->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($address->City->Visible) { // City ?>
		<td data-name="City"<?php echo $address->City->cellAttributes() ?>>
<span id="el<?php echo $address_list->RowCnt ?>_address_City" class="address_City">
<span<?php echo $address->City->viewAttributes() ?>>
<?php echo $address->City->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($address->Region->Visible) { // Region ?>
		<td data-name="Region"<?php echo $address->Region->cellAttributes() ?>>
<span id="el<?php echo $address_list->RowCnt ?>_address_Region" class="address_Region">
<span<?php echo $address->Region->viewAttributes() ?>>
<?php echo $address->Region->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($address->PostalCode->Visible) { // PostalCode ?>
		<td data-name="PostalCode"<?php echo $address->PostalCode->cellAttributes() ?>>
<span id="el<?php echo $address_list->RowCnt ?>_address_PostalCode" class="address_PostalCode">
<span<?php echo $address->PostalCode->viewAttributes() ?>>
<?php echo $address->PostalCode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($address->Country->Visible) { // Country ?>
		<td data-name="Country"<?php echo $address->Country->cellAttributes() ?>>
<span id="el<?php echo $address_list->RowCnt ?>_address_Country" class="address_Country">
<span<?php echo $address->Country->viewAttributes() ?>>
<?php echo $address->Country->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($address->Notes->Visible) { // Notes ?>
		<td data-name="Notes"<?php echo $address->Notes->cellAttributes() ?>>
<span id="el<?php echo $address_list->RowCnt ?>_address_Notes" class="address_Notes">
<span<?php echo $address->Notes->viewAttributes() ?>>
<?php echo $address->Notes->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($address->Primary->Visible) { // Primary ?>
		<td data-name="Primary"<?php echo $address->Primary->cellAttributes() ?>>
<span id="el<?php echo $address_list->RowCnt ?>_address_Primary" class="address_Primary">
<span<?php echo $address->Primary->viewAttributes() ?>>
<?php if (ConvertToBool($address->Primary->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $address->Primary->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $address->Primary->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$address_list->ListOptions->render("body", "right", $address_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$address->isGridAdd())
		$address_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$address->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($address_list->Recordset)
	$address_list->Recordset->Close();
?>
<?php if (!$address->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$address->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($address_list->Pager)) $address_list->Pager = new PrevNextPager($address_list->StartRec, $address_list->DisplayRecs, $address_list->TotalRecs, $address_list->AutoHidePager) ?>
<?php if ($address_list->Pager->RecordCount > 0 && $address_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($address_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $address_list->pageUrl() ?>start=<?php echo $address_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($address_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $address_list->pageUrl() ?>start=<?php echo $address_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $address_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($address_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $address_list->pageUrl() ?>start=<?php echo $address_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($address_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $address_list->pageUrl() ?>start=<?php echo $address_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $address_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($address_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $address_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $address_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $address_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($address_list->TotalRecs > 0 && (!$address_list->AutoHidePageSizeSelector || $address_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="address">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($address_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($address_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($address_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($address_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($address_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($address_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($address_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($address_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($address_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($address->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $address_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($address_list->TotalRecs == 0 && !$address->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $address_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$address_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$address->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$address->isExport()) { ?>
<script>
ew.scrollableTable("gmp_address", "", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$address_list->terminate();
?>
