<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$address_view = new address_view();

// Run the page
$address_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$address_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$address->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var faddressview = currentForm = new ew.Form("faddressview", "view");

// Form_CustomValidate event
faddressview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
faddressview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
faddressview.lists["x_AddressTypeID"] = <?php echo $address_view->AddressTypeID->Lookup->toClientList() ?>;
faddressview.lists["x_AddressTypeID"].options = <?php echo JsonEncode($address_view->AddressTypeID->lookupOptions()) ?>;
faddressview.lists["x_Primary[]"] = <?php echo $address_view->Primary->Lookup->toClientList() ?>;
faddressview.lists["x_Primary[]"].options = <?php echo JsonEncode($address_view->Primary->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$address->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $address_view->ExportOptions->render("body") ?>
<?php $address_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $address_view->showPageHeader(); ?>
<?php
$address_view->showMessage();
?>
<?php if (!$address_view->IsModal) { ?>
<?php if (!$address->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($address_view->Pager)) $address_view->Pager = new PrevNextPager($address_view->StartRec, $address_view->DisplayRecs, $address_view->TotalRecs, $address_view->AutoHidePager) ?>
<?php if ($address_view->Pager->RecordCount > 0 && $address_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($address_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $address_view->pageUrl() ?>start=<?php echo $address_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($address_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $address_view->pageUrl() ?>start=<?php echo $address_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $address_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($address_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $address_view->pageUrl() ?>start=<?php echo $address_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($address_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $address_view->pageUrl() ?>start=<?php echo $address_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $address_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="faddressview" id="faddressview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($address_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $address_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="address">
<input type="hidden" name="modal" value="<?php echo (int)$address_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($address->AddressID->Visible) { // AddressID ?>
	<tr id="r_AddressID">
		<td class="<?php echo $address_view->TableLeftColumnClass ?>"><span id="elh_address_AddressID"><?php echo $address->AddressID->caption() ?></span></td>
		<td data-name="AddressID"<?php echo $address->AddressID->cellAttributes() ?>>
<span id="el_address_AddressID">
<span<?php echo $address->AddressID->viewAttributes() ?>>
<?php echo $address->AddressID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($address->AddressTypeID->Visible) { // AddressTypeID ?>
	<tr id="r_AddressTypeID">
		<td class="<?php echo $address_view->TableLeftColumnClass ?>"><span id="elh_address_AddressTypeID"><?php echo $address->AddressTypeID->caption() ?></span></td>
		<td data-name="AddressTypeID"<?php echo $address->AddressTypeID->cellAttributes() ?>>
<span id="el_address_AddressTypeID">
<span<?php echo $address->AddressTypeID->viewAttributes() ?>>
<?php echo $address->AddressTypeID->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($address->Address->Visible) { // Address ?>
	<tr id="r_Address">
		<td class="<?php echo $address_view->TableLeftColumnClass ?>"><span id="elh_address_Address"><?php echo $address->Address->caption() ?></span></td>
		<td data-name="Address"<?php echo $address->Address->cellAttributes() ?>>
<span id="el_address_Address">
<span<?php echo $address->Address->viewAttributes() ?>>
<?php echo $address->Address->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($address->City->Visible) { // City ?>
	<tr id="r_City">
		<td class="<?php echo $address_view->TableLeftColumnClass ?>"><span id="elh_address_City"><?php echo $address->City->caption() ?></span></td>
		<td data-name="City"<?php echo $address->City->cellAttributes() ?>>
<span id="el_address_City">
<span<?php echo $address->City->viewAttributes() ?>>
<?php echo $address->City->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($address->Region->Visible) { // Region ?>
	<tr id="r_Region">
		<td class="<?php echo $address_view->TableLeftColumnClass ?>"><span id="elh_address_Region"><?php echo $address->Region->caption() ?></span></td>
		<td data-name="Region"<?php echo $address->Region->cellAttributes() ?>>
<span id="el_address_Region">
<span<?php echo $address->Region->viewAttributes() ?>>
<?php echo $address->Region->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($address->PostalCode->Visible) { // PostalCode ?>
	<tr id="r_PostalCode">
		<td class="<?php echo $address_view->TableLeftColumnClass ?>"><span id="elh_address_PostalCode"><?php echo $address->PostalCode->caption() ?></span></td>
		<td data-name="PostalCode"<?php echo $address->PostalCode->cellAttributes() ?>>
<span id="el_address_PostalCode">
<span<?php echo $address->PostalCode->viewAttributes() ?>>
<?php echo $address->PostalCode->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($address->Country->Visible) { // Country ?>
	<tr id="r_Country">
		<td class="<?php echo $address_view->TableLeftColumnClass ?>"><span id="elh_address_Country"><?php echo $address->Country->caption() ?></span></td>
		<td data-name="Country"<?php echo $address->Country->cellAttributes() ?>>
<span id="el_address_Country">
<span<?php echo $address->Country->viewAttributes() ?>>
<?php echo $address->Country->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($address->Notes->Visible) { // Notes ?>
	<tr id="r_Notes">
		<td class="<?php echo $address_view->TableLeftColumnClass ?>"><span id="elh_address_Notes"><?php echo $address->Notes->caption() ?></span></td>
		<td data-name="Notes"<?php echo $address->Notes->cellAttributes() ?>>
<span id="el_address_Notes">
<span<?php echo $address->Notes->viewAttributes() ?>>
<?php echo $address->Notes->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($address->Primary->Visible) { // Primary ?>
	<tr id="r_Primary">
		<td class="<?php echo $address_view->TableLeftColumnClass ?>"><span id="elh_address_Primary"><?php echo $address->Primary->caption() ?></span></td>
		<td data-name="Primary"<?php echo $address->Primary->cellAttributes() ?>>
<span id="el_address_Primary">
<span<?php echo $address->Primary->viewAttributes() ?>>
<?php if (ConvertToBool($address->Primary->CurrentValue)) { ?>
<input type="checkbox" value="<?php echo $address->Primary->getViewValue() ?>" disabled checked>
<?php } else { ?>
<input type="checkbox" value="<?php echo $address->Primary->getViewValue() ?>" disabled>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$address_view->IsModal) { ?>
<?php if (!$address->isExport()) { ?>
<?php if (!isset($address_view->Pager)) $address_view->Pager = new PrevNextPager($address_view->StartRec, $address_view->DisplayRecs, $address_view->TotalRecs, $address_view->AutoHidePager) ?>
<?php if ($address_view->Pager->RecordCount > 0 && $address_view->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($address_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $address_view->pageUrl() ?>start=<?php echo $address_view->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($address_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $address_view->pageUrl() ?>start=<?php echo $address_view->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $address_view->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($address_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $address_view->pageUrl() ?>start=<?php echo $address_view->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($address_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $address_view->pageUrl() ?>start=<?php echo $address_view->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $address_view->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
</form>
<?php
$address_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$address->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$address_view->terminate();
?>
