<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$attachments_list = new attachments_list();

// Run the page
$attachments_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$attachments_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$attachments->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fattachmentslist = currentForm = new ew.Form("fattachmentslist", "list");
fattachmentslist.formKeyCountName = '<?php echo $attachments_list->FormKeyCountName ?>';

// Form_CustomValidate event
fattachmentslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fattachmentslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fattachmentslist.lists["x_AttachmentSource_ID"] = <?php echo $attachments_list->AttachmentSource_ID->Lookup->toClientList() ?>;
fattachmentslist.lists["x_AttachmentSource_ID"].options = <?php echo JsonEncode($attachments_list->AttachmentSource_ID->lookupOptions()) ?>;
fattachmentslist.autoSuggests["x_AttachmentSource_ID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var fattachmentslistsrch = currentSearchForm = new ew.Form("fattachmentslistsrch");

// Filters
fattachmentslistsrch.filterList = <?php echo $attachments_list->getFilterList() ?>;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = true;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$attachments->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($attachments_list->TotalRecs > 0 && $attachments_list->ExportOptions->visible()) { ?>
<?php $attachments_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($attachments_list->ImportOptions->visible()) { ?>
<?php $attachments_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($attachments_list->SearchOptions->visible()) { ?>
<?php $attachments_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($attachments_list->FilterOptions->visible()) { ?>
<?php $attachments_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$attachments->isExport() || EXPORT_MASTER_RECORD && $attachments->isExport("print")) { ?>
<?php
if ($attachments_list->DbMasterFilter <> "" && $attachments->getCurrentMasterTable() == "cases") {
	if ($attachments_list->MasterRecordExists) {
		include_once "casesmaster.php";
	}
}
?>
<?php } ?>
<?php
$attachments_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$attachments->isExport() && !$attachments->CurrentAction) { ?>
<form name="fattachmentslistsrch" id="fattachmentslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($attachments_list->SearchWhere <> "") ? " show" : " show"; ?>
<div id="fattachmentslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="attachments">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($attachments_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($attachments_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $attachments_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($attachments_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($attachments_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($attachments_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($attachments_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $attachments_list->showPageHeader(); ?>
<?php
$attachments_list->showMessage();
?>
<?php if ($attachments_list->TotalRecs > 0 || $attachments->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($attachments_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> attachments">
<?php if (!$attachments->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$attachments->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($attachments_list->Pager)) $attachments_list->Pager = new PrevNextPager($attachments_list->StartRec, $attachments_list->DisplayRecs, $attachments_list->TotalRecs, $attachments_list->AutoHidePager) ?>
<?php if ($attachments_list->Pager->RecordCount > 0 && $attachments_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($attachments_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $attachments_list->pageUrl() ?>start=<?php echo $attachments_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($attachments_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $attachments_list->pageUrl() ?>start=<?php echo $attachments_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $attachments_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($attachments_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $attachments_list->pageUrl() ?>start=<?php echo $attachments_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($attachments_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $attachments_list->pageUrl() ?>start=<?php echo $attachments_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $attachments_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($attachments_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $attachments_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $attachments_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $attachments_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($attachments_list->TotalRecs > 0 && (!$attachments_list->AutoHidePageSizeSelector || $attachments_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="attachments">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($attachments_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($attachments_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($attachments_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($attachments_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($attachments_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($attachments_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($attachments_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($attachments_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($attachments_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($attachments->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $attachments_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fattachmentslist" id="fattachmentslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($attachments_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $attachments_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="attachments">
<?php if ($attachments->getCurrentMasterTable() == "cases" && $attachments->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="cases">
<input type="hidden" name="fk_CaseID" value="<?php echo $attachments->CaseID->getSessionValue() ?>">
<?php } ?>
<div id="gmp_attachments" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($attachments_list->TotalRecs > 0 || $attachments->isGridEdit()) { ?>
<table id="tbl_attachmentslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$attachments_list->RowType = ROWTYPE_HEADER;

// Render list options
$attachments_list->renderListOptions();

// Render list options (header, left)
$attachments_list->ListOptions->render("header", "left");
?>
<?php if ($attachments->AttachmentID->Visible) { // AttachmentID ?>
	<?php if ($attachments->sortUrl($attachments->AttachmentID) == "") { ?>
		<th data-name="AttachmentID" class="<?php echo $attachments->AttachmentID->headerCellClass() ?>"><div id="elh_attachments_AttachmentID" class="attachments_AttachmentID"><div class="ew-table-header-caption"><?php echo $attachments->AttachmentID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="AttachmentID" class="<?php echo $attachments->AttachmentID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $attachments->SortUrl($attachments->AttachmentID) ?>',2);"><div id="elh_attachments_AttachmentID" class="attachments_AttachmentID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $attachments->AttachmentID->caption() ?></span><span class="ew-table-header-sort"><?php if ($attachments->AttachmentID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($attachments->AttachmentID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($attachments->AttachmentSource_ID->Visible) { // AttachmentSource_ID ?>
	<?php if ($attachments->sortUrl($attachments->AttachmentSource_ID) == "") { ?>
		<th data-name="AttachmentSource_ID" class="<?php echo $attachments->AttachmentSource_ID->headerCellClass() ?>"><div id="elh_attachments_AttachmentSource_ID" class="attachments_AttachmentSource_ID"><div class="ew-table-header-caption"><?php echo $attachments->AttachmentSource_ID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="AttachmentSource_ID" class="<?php echo $attachments->AttachmentSource_ID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $attachments->SortUrl($attachments->AttachmentSource_ID) ?>',2);"><div id="elh_attachments_AttachmentSource_ID" class="attachments_AttachmentSource_ID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $attachments->AttachmentSource_ID->caption() ?></span><span class="ew-table-header-sort"><?php if ($attachments->AttachmentSource_ID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($attachments->AttachmentSource_ID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($attachments->CaseID->Visible) { // CaseID ?>
	<?php if ($attachments->sortUrl($attachments->CaseID) == "") { ?>
		<th data-name="CaseID" class="<?php echo $attachments->CaseID->headerCellClass() ?>"><div id="elh_attachments_CaseID" class="attachments_CaseID"><div class="ew-table-header-caption"><?php echo $attachments->CaseID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="CaseID" class="<?php echo $attachments->CaseID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $attachments->SortUrl($attachments->CaseID) ?>',2);"><div id="elh_attachments_CaseID" class="attachments_CaseID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $attachments->CaseID->caption() ?></span><span class="ew-table-header-sort"><?php if ($attachments->CaseID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($attachments->CaseID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($attachments->EmployeeID->Visible) { // EmployeeID ?>
	<?php if ($attachments->sortUrl($attachments->EmployeeID) == "") { ?>
		<th data-name="EmployeeID" class="<?php echo $attachments->EmployeeID->headerCellClass() ?>"><div id="elh_attachments_EmployeeID" class="attachments_EmployeeID"><div class="ew-table-header-caption"><?php echo $attachments->EmployeeID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="EmployeeID" class="<?php echo $attachments->EmployeeID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $attachments->SortUrl($attachments->EmployeeID) ?>',2);"><div id="elh_attachments_EmployeeID" class="attachments_EmployeeID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $attachments->EmployeeID->caption() ?></span><span class="ew-table-header-sort"><?php if ($attachments->EmployeeID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($attachments->EmployeeID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($attachments->AttachID->Visible) { // AttachID ?>
	<?php if ($attachments->sortUrl($attachments->AttachID) == "") { ?>
		<th data-name="AttachID" class="<?php echo $attachments->AttachID->headerCellClass() ?>"><div id="elh_attachments_AttachID" class="attachments_AttachID"><div class="ew-table-header-caption"><?php echo $attachments->AttachID->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="AttachID" class="<?php echo $attachments->AttachID->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $attachments->SortUrl($attachments->AttachID) ?>',2);"><div id="elh_attachments_AttachID" class="attachments_AttachID">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $attachments->AttachID->caption() ?></span><span class="ew-table-header-sort"><?php if ($attachments->AttachID->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($attachments->AttachID->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($attachments->AttachFilename->Visible) { // AttachFilename ?>
	<?php if ($attachments->sortUrl($attachments->AttachFilename) == "") { ?>
		<th data-name="AttachFilename" class="<?php echo $attachments->AttachFilename->headerCellClass() ?>"><div id="elh_attachments_AttachFilename" class="attachments_AttachFilename"><div class="ew-table-header-caption"><?php echo $attachments->AttachFilename->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="AttachFilename" class="<?php echo $attachments->AttachFilename->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $attachments->SortUrl($attachments->AttachFilename) ?>',2);"><div id="elh_attachments_AttachFilename" class="attachments_AttachFilename">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $attachments->AttachFilename->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($attachments->AttachFilename->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($attachments->AttachFilename->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($attachments->AttachFilenameInitial->Visible) { // AttachFilenameInitial ?>
	<?php if ($attachments->sortUrl($attachments->AttachFilenameInitial) == "") { ?>
		<th data-name="AttachFilenameInitial" class="<?php echo $attachments->AttachFilenameInitial->headerCellClass() ?>"><div id="elh_attachments_AttachFilenameInitial" class="attachments_AttachFilenameInitial"><div class="ew-table-header-caption"><?php echo $attachments->AttachFilenameInitial->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="AttachFilenameInitial" class="<?php echo $attachments->AttachFilenameInitial->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $attachments->SortUrl($attachments->AttachFilenameInitial) ?>',2);"><div id="elh_attachments_AttachFilenameInitial" class="attachments_AttachFilenameInitial">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $attachments->AttachFilenameInitial->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($attachments->AttachFilenameInitial->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($attachments->AttachFilenameInitial->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($attachments->AttachExtension->Visible) { // AttachExtension ?>
	<?php if ($attachments->sortUrl($attachments->AttachExtension) == "") { ?>
		<th data-name="AttachExtension" class="<?php echo $attachments->AttachExtension->headerCellClass() ?>"><div id="elh_attachments_AttachExtension" class="attachments_AttachExtension"><div class="ew-table-header-caption"><?php echo $attachments->AttachExtension->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="AttachExtension" class="<?php echo $attachments->AttachExtension->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $attachments->SortUrl($attachments->AttachExtension) ?>',2);"><div id="elh_attachments_AttachExtension" class="attachments_AttachExtension">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $attachments->AttachExtension->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($attachments->AttachExtension->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($attachments->AttachExtension->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($attachments->AttachDescription->Visible) { // AttachDescription ?>
	<?php if ($attachments->sortUrl($attachments->AttachDescription) == "") { ?>
		<th data-name="AttachDescription" class="<?php echo $attachments->AttachDescription->headerCellClass() ?>"><div id="elh_attachments_AttachDescription" class="attachments_AttachDescription"><div class="ew-table-header-caption"><?php echo $attachments->AttachDescription->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="AttachDescription" class="<?php echo $attachments->AttachDescription->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $attachments->SortUrl($attachments->AttachDescription) ?>',2);"><div id="elh_attachments_AttachDescription" class="attachments_AttachDescription">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $attachments->AttachDescription->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($attachments->AttachDescription->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($attachments->AttachDescription->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($attachments->AttachFilepath->Visible) { // AttachFilepath ?>
	<?php if ($attachments->sortUrl($attachments->AttachFilepath) == "") { ?>
		<th data-name="AttachFilepath" class="<?php echo $attachments->AttachFilepath->headerCellClass() ?>"><div id="elh_attachments_AttachFilepath" class="attachments_AttachFilepath"><div class="ew-table-header-caption"><?php echo $attachments->AttachFilepath->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="AttachFilepath" class="<?php echo $attachments->AttachFilepath->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $attachments->SortUrl($attachments->AttachFilepath) ?>',2);"><div id="elh_attachments_AttachFilepath" class="attachments_AttachFilepath">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $attachments->AttachFilepath->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($attachments->AttachFilepath->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($attachments->AttachFilepath->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($attachments->AttachPath->Visible) { // AttachPath ?>
	<?php if ($attachments->sortUrl($attachments->AttachPath) == "") { ?>
		<th data-name="AttachPath" class="<?php echo $attachments->AttachPath->headerCellClass() ?>"><div id="elh_attachments_AttachPath" class="attachments_AttachPath"><div class="ew-table-header-caption"><?php echo $attachments->AttachPath->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="AttachPath" class="<?php echo $attachments->AttachPath->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $attachments->SortUrl($attachments->AttachPath) ?>',2);"><div id="elh_attachments_AttachPath" class="attachments_AttachPath">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $attachments->AttachPath->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($attachments->AttachPath->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($attachments->AttachPath->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($attachments->_Case->Visible) { // Case ?>
	<?php if ($attachments->sortUrl($attachments->_Case) == "") { ?>
		<th data-name="_Case" class="<?php echo $attachments->_Case->headerCellClass() ?>"><div id="elh_attachments__Case" class="attachments__Case"><div class="ew-table-header-caption"><?php echo $attachments->_Case->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_Case" class="<?php echo $attachments->_Case->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $attachments->SortUrl($attachments->_Case) ?>',2);"><div id="elh_attachments__Case" class="attachments__Case">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $attachments->_Case->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($attachments->_Case->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($attachments->_Case->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$attachments_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($attachments->ExportAll && $attachments->isExport()) {
	$attachments_list->StopRec = $attachments_list->TotalRecs;
} else {

	// Set the last record to display
	if ($attachments_list->TotalRecs > $attachments_list->StartRec + $attachments_list->DisplayRecs - 1)
		$attachments_list->StopRec = $attachments_list->StartRec + $attachments_list->DisplayRecs - 1;
	else
		$attachments_list->StopRec = $attachments_list->TotalRecs;
}
$attachments_list->RecCnt = $attachments_list->StartRec - 1;
if ($attachments_list->Recordset && !$attachments_list->Recordset->EOF) {
	$attachments_list->Recordset->moveFirst();
	$selectLimit = $attachments_list->UseSelectLimit;
	if (!$selectLimit && $attachments_list->StartRec > 1)
		$attachments_list->Recordset->move($attachments_list->StartRec - 1);
} elseif (!$attachments->AllowAddDeleteRow && $attachments_list->StopRec == 0) {
	$attachments_list->StopRec = $attachments->GridAddRowCount;
}

// Initialize aggregate
$attachments->RowType = ROWTYPE_AGGREGATEINIT;
$attachments->resetAttributes();
$attachments_list->renderRow();
while ($attachments_list->RecCnt < $attachments_list->StopRec) {
	$attachments_list->RecCnt++;
	if ($attachments_list->RecCnt >= $attachments_list->StartRec) {
		$attachments_list->RowCnt++;

		// Set up key count
		$attachments_list->KeyCount = $attachments_list->RowIndex;

		// Init row class and style
		$attachments->resetAttributes();
		$attachments->CssClass = "";
		if ($attachments->isGridAdd()) {
		} else {
			$attachments_list->loadRowValues($attachments_list->Recordset); // Load row values
		}
		$attachments->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$attachments->RowAttrs = array_merge($attachments->RowAttrs, array('data-rowindex'=>$attachments_list->RowCnt, 'id'=>'r' . $attachments_list->RowCnt . '_attachments', 'data-rowtype'=>$attachments->RowType));

		// Render row
		$attachments_list->renderRow();

		// Render list options
		$attachments_list->renderListOptions();
?>
	<tr<?php echo $attachments->rowAttributes() ?>>
<?php

// Render list options (body, left)
$attachments_list->ListOptions->render("body", "left", $attachments_list->RowCnt);
?>
	<?php if ($attachments->AttachmentID->Visible) { // AttachmentID ?>
		<td data-name="AttachmentID"<?php echo $attachments->AttachmentID->cellAttributes() ?>>
<span id="el<?php echo $attachments_list->RowCnt ?>_attachments_AttachmentID" class="attachments_AttachmentID">
<span<?php echo $attachments->AttachmentID->viewAttributes() ?>>
<?php echo $attachments->AttachmentID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($attachments->AttachmentSource_ID->Visible) { // AttachmentSource_ID ?>
		<td data-name="AttachmentSource_ID"<?php echo $attachments->AttachmentSource_ID->cellAttributes() ?>>
<span id="el<?php echo $attachments_list->RowCnt ?>_attachments_AttachmentSource_ID" class="attachments_AttachmentSource_ID">
<span<?php echo $attachments->AttachmentSource_ID->viewAttributes() ?>>
<?php echo $attachments->AttachmentSource_ID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($attachments->CaseID->Visible) { // CaseID ?>
		<td data-name="CaseID"<?php echo $attachments->CaseID->cellAttributes() ?>>
<span id="el<?php echo $attachments_list->RowCnt ?>_attachments_CaseID" class="attachments_CaseID">
<span<?php echo $attachments->CaseID->viewAttributes() ?>>
<?php echo $attachments->CaseID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($attachments->EmployeeID->Visible) { // EmployeeID ?>
		<td data-name="EmployeeID"<?php echo $attachments->EmployeeID->cellAttributes() ?>>
<span id="el<?php echo $attachments_list->RowCnt ?>_attachments_EmployeeID" class="attachments_EmployeeID">
<span<?php echo $attachments->EmployeeID->viewAttributes() ?>>
<?php echo $attachments->EmployeeID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($attachments->AttachID->Visible) { // AttachID ?>
		<td data-name="AttachID"<?php echo $attachments->AttachID->cellAttributes() ?>>
<span id="el<?php echo $attachments_list->RowCnt ?>_attachments_AttachID" class="attachments_AttachID">
<span<?php echo $attachments->AttachID->viewAttributes() ?>>
<?php echo $attachments->AttachID->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($attachments->AttachFilename->Visible) { // AttachFilename ?>
		<td data-name="AttachFilename"<?php echo $attachments->AttachFilename->cellAttributes() ?>>
<span id="el<?php echo $attachments_list->RowCnt ?>_attachments_AttachFilename" class="attachments_AttachFilename">
<span<?php echo $attachments->AttachFilename->viewAttributes() ?>>
<?php echo GetFileViewTag($attachments->AttachFilename, $attachments->AttachFilename->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($attachments->AttachFilenameInitial->Visible) { // AttachFilenameInitial ?>
		<td data-name="AttachFilenameInitial"<?php echo $attachments->AttachFilenameInitial->cellAttributes() ?>>
<span id="el<?php echo $attachments_list->RowCnt ?>_attachments_AttachFilenameInitial" class="attachments_AttachFilenameInitial">
<span<?php echo $attachments->AttachFilenameInitial->viewAttributes() ?>>
<?php echo $attachments->AttachFilenameInitial->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($attachments->AttachExtension->Visible) { // AttachExtension ?>
		<td data-name="AttachExtension"<?php echo $attachments->AttachExtension->cellAttributes() ?>>
<span id="el<?php echo $attachments_list->RowCnt ?>_attachments_AttachExtension" class="attachments_AttachExtension">
<span<?php echo $attachments->AttachExtension->viewAttributes() ?>>
<?php echo $attachments->AttachExtension->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($attachments->AttachDescription->Visible) { // AttachDescription ?>
		<td data-name="AttachDescription"<?php echo $attachments->AttachDescription->cellAttributes() ?>>
<span id="el<?php echo $attachments_list->RowCnt ?>_attachments_AttachDescription" class="attachments_AttachDescription">
<span<?php echo $attachments->AttachDescription->viewAttributes() ?>>
<?php echo $attachments->AttachDescription->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($attachments->AttachFilepath->Visible) { // AttachFilepath ?>
		<td data-name="AttachFilepath"<?php echo $attachments->AttachFilepath->cellAttributes() ?>>
<span id="el<?php echo $attachments_list->RowCnt ?>_attachments_AttachFilepath" class="attachments_AttachFilepath">
<span<?php echo $attachments->AttachFilepath->viewAttributes() ?>>
<?php echo $attachments->AttachFilepath->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($attachments->AttachPath->Visible) { // AttachPath ?>
		<td data-name="AttachPath"<?php echo $attachments->AttachPath->cellAttributes() ?>>
<span id="el<?php echo $attachments_list->RowCnt ?>_attachments_AttachPath" class="attachments_AttachPath">
<span<?php echo $attachments->AttachPath->viewAttributes() ?>>
<?php echo $attachments->AttachPath->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($attachments->_Case->Visible) { // Case ?>
		<td data-name="_Case"<?php echo $attachments->_Case->cellAttributes() ?>>
<span id="el<?php echo $attachments_list->RowCnt ?>_attachments__Case" class="attachments__Case">
<span<?php echo $attachments->_Case->viewAttributes() ?>>
<?php echo $attachments->_Case->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$attachments_list->ListOptions->render("body", "right", $attachments_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$attachments->isGridAdd())
		$attachments_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$attachments->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($attachments_list->Recordset)
	$attachments_list->Recordset->Close();
?>
<?php if (!$attachments->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$attachments->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($attachments_list->Pager)) $attachments_list->Pager = new PrevNextPager($attachments_list->StartRec, $attachments_list->DisplayRecs, $attachments_list->TotalRecs, $attachments_list->AutoHidePager) ?>
<?php if ($attachments_list->Pager->RecordCount > 0 && $attachments_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($attachments_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $attachments_list->pageUrl() ?>start=<?php echo $attachments_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($attachments_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $attachments_list->pageUrl() ?>start=<?php echo $attachments_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $attachments_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($attachments_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $attachments_list->pageUrl() ?>start=<?php echo $attachments_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($attachments_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $attachments_list->pageUrl() ?>start=<?php echo $attachments_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $attachments_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($attachments_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $attachments_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $attachments_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $attachments_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($attachments_list->TotalRecs > 0 && (!$attachments_list->AutoHidePageSizeSelector || $attachments_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="attachments">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="5"<?php if ($attachments_list->DisplayRecs == 5) { ?> selected<?php } ?>>5</option>
<option value="10"<?php if ($attachments_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($attachments_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="30"<?php if ($attachments_list->DisplayRecs == 30) { ?> selected<?php } ?>>30</option>
<option value="40"<?php if ($attachments_list->DisplayRecs == 40) { ?> selected<?php } ?>>40</option>
<option value="50"<?php if ($attachments_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($attachments_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="200"<?php if ($attachments_list->DisplayRecs == 200) { ?> selected<?php } ?>>200</option>
<option value="500"<?php if ($attachments_list->DisplayRecs == 500) { ?> selected<?php } ?>>500</option>
<option value="ALL"<?php if ($attachments->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $attachments_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($attachments_list->TotalRecs == 0 && !$attachments->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $attachments_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$attachments_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$attachments->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$attachments->isExport()) { ?>
<script>
ew.scrollableTable("gmp_attachments", "1250px", "");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$attachments_list->terminate();
?>
