<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$branches_add = new branches_add();

// Run the page
$branches_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$branches_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fbranchesadd = currentForm = new ew.Form("fbranchesadd", "add");

// Validate form
fbranchesadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($branches_add->Branch->Required) { ?>
			elm = this.getElements("x" + infix + "_Branch");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $branches->Branch->caption(), $branches->Branch->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($branches_add->BranchEn->Required) { ?>
			elm = this.getElements("x" + infix + "_BranchEn");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $branches->BranchEn->caption(), $branches->BranchEn->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($branches_add->LawFirmID->Required) { ?>
			elm = this.getElements("x" + infix + "_LawFirmID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $branches->LawFirmID->caption(), $branches->LawFirmID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($branches_add->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $branches->Notes->caption(), $branches->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($branches_add->Activated->Required) { ?>
			elm = this.getElements("x" + infix + "_Activated[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $branches->Activated->caption(), $branches->Activated->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fbranchesadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbranchesadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbranchesadd.lists["x_LawFirmID"] = <?php echo $branches_add->LawFirmID->Lookup->toClientList() ?>;
fbranchesadd.lists["x_LawFirmID"].options = <?php echo JsonEncode($branches_add->LawFirmID->lookupOptions()) ?>;
fbranchesadd.lists["x_Activated[]"] = <?php echo $branches_add->Activated->Lookup->toClientList() ?>;
fbranchesadd.lists["x_Activated[]"].options = <?php echo JsonEncode($branches_add->Activated->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $branches_add->showPageHeader(); ?>
<?php
$branches_add->showMessage();
?>
<form name="fbranchesadd" id="fbranchesadd" class="<?php echo $branches_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($branches_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $branches_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="branches">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$branches_add->IsModal ?>">
<?php if (!$branches_add->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($branches_add->IsMobileOrModal) { ?>
<div class="ew-add-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_branchesadd" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($branches->Branch->Visible) { // Branch ?>
<?php if ($branches_add->IsMobileOrModal) { ?>
	<div id="r_Branch" class="form-group row">
		<label id="elh_branches_Branch" for="x_Branch" class="<?php echo $branches_add->LeftColumnClass ?>"><?php echo $branches->Branch->caption() ?><?php echo ($branches->Branch->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $branches_add->RightColumnClass ?>"><div<?php echo $branches->Branch->cellAttributes() ?>>
<span id="el_branches_Branch">
<input type="text" data-table="branches" data-field="x_Branch" name="x_Branch" id="x_Branch" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($branches->Branch->getPlaceHolder()) ?>" value="<?php echo $branches->Branch->EditValue ?>"<?php echo $branches->Branch->editAttributes() ?>>
</span>
<?php echo $branches->Branch->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Branch">
		<td class="<?php echo $branches_add->TableLeftColumnClass ?>"><span id="elh_branches_Branch"><?php echo $branches->Branch->caption() ?><?php echo ($branches->Branch->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $branches->Branch->cellAttributes() ?>>
<span id="el_branches_Branch">
<input type="text" data-table="branches" data-field="x_Branch" name="x_Branch" id="x_Branch" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($branches->Branch->getPlaceHolder()) ?>" value="<?php echo $branches->Branch->EditValue ?>"<?php echo $branches->Branch->editAttributes() ?>>
</span>
<?php echo $branches->Branch->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($branches->BranchEn->Visible) { // BranchEn ?>
<?php if ($branches_add->IsMobileOrModal) { ?>
	<div id="r_BranchEn" class="form-group row">
		<label id="elh_branches_BranchEn" for="x_BranchEn" class="<?php echo $branches_add->LeftColumnClass ?>"><?php echo $branches->BranchEn->caption() ?><?php echo ($branches->BranchEn->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $branches_add->RightColumnClass ?>"><div<?php echo $branches->BranchEn->cellAttributes() ?>>
<span id="el_branches_BranchEn">
<input type="text" data-table="branches" data-field="x_BranchEn" name="x_BranchEn" id="x_BranchEn" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($branches->BranchEn->getPlaceHolder()) ?>" value="<?php echo $branches->BranchEn->EditValue ?>"<?php echo $branches->BranchEn->editAttributes() ?>>
</span>
<?php echo $branches->BranchEn->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_BranchEn">
		<td class="<?php echo $branches_add->TableLeftColumnClass ?>"><span id="elh_branches_BranchEn"><?php echo $branches->BranchEn->caption() ?><?php echo ($branches->BranchEn->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $branches->BranchEn->cellAttributes() ?>>
<span id="el_branches_BranchEn">
<input type="text" data-table="branches" data-field="x_BranchEn" name="x_BranchEn" id="x_BranchEn" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($branches->BranchEn->getPlaceHolder()) ?>" value="<?php echo $branches->BranchEn->EditValue ?>"<?php echo $branches->BranchEn->editAttributes() ?>>
</span>
<?php echo $branches->BranchEn->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($branches->LawFirmID->Visible) { // LawFirmID ?>
<?php if ($branches_add->IsMobileOrModal) { ?>
	<div id="r_LawFirmID" class="form-group row">
		<label id="elh_branches_LawFirmID" for="x_LawFirmID" class="<?php echo $branches_add->LeftColumnClass ?>"><?php echo $branches->LawFirmID->caption() ?><?php echo ($branches->LawFirmID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $branches_add->RightColumnClass ?>"><div<?php echo $branches->LawFirmID->cellAttributes() ?>>
<span id="el_branches_LawFirmID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="branches" data-field="x_LawFirmID" data-value-separator="<?php echo $branches->LawFirmID->displayValueSeparatorAttribute() ?>" id="x_LawFirmID" name="x_LawFirmID"<?php echo $branches->LawFirmID->editAttributes() ?>>
		<?php echo $branches->LawFirmID->selectOptionListHtml("x_LawFirmID") ?>
	</select>
</div>
<?php echo $branches->LawFirmID->Lookup->getParamTag("p_x_LawFirmID") ?>
</span>
<?php echo $branches->LawFirmID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_LawFirmID">
		<td class="<?php echo $branches_add->TableLeftColumnClass ?>"><span id="elh_branches_LawFirmID"><?php echo $branches->LawFirmID->caption() ?><?php echo ($branches->LawFirmID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $branches->LawFirmID->cellAttributes() ?>>
<span id="el_branches_LawFirmID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="branches" data-field="x_LawFirmID" data-value-separator="<?php echo $branches->LawFirmID->displayValueSeparatorAttribute() ?>" id="x_LawFirmID" name="x_LawFirmID"<?php echo $branches->LawFirmID->editAttributes() ?>>
		<?php echo $branches->LawFirmID->selectOptionListHtml("x_LawFirmID") ?>
	</select>
</div>
<?php echo $branches->LawFirmID->Lookup->getParamTag("p_x_LawFirmID") ?>
</span>
<?php echo $branches->LawFirmID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($branches->Notes->Visible) { // Notes ?>
<?php if ($branches_add->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label id="elh_branches_Notes" for="x_Notes" class="<?php echo $branches_add->LeftColumnClass ?>"><?php echo $branches->Notes->caption() ?><?php echo ($branches->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $branches_add->RightColumnClass ?>"><div<?php echo $branches->Notes->cellAttributes() ?>>
<span id="el_branches_Notes">
<textarea data-table="branches" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($branches->Notes->getPlaceHolder()) ?>"<?php echo $branches->Notes->editAttributes() ?>><?php echo $branches->Notes->EditValue ?></textarea>
</span>
<?php echo $branches->Notes->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $branches_add->TableLeftColumnClass ?>"><span id="elh_branches_Notes"><?php echo $branches->Notes->caption() ?><?php echo ($branches->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $branches->Notes->cellAttributes() ?>>
<span id="el_branches_Notes">
<textarea data-table="branches" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($branches->Notes->getPlaceHolder()) ?>"<?php echo $branches->Notes->editAttributes() ?>><?php echo $branches->Notes->EditValue ?></textarea>
</span>
<?php echo $branches->Notes->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($branches->Activated->Visible) { // Activated ?>
<?php if ($branches_add->IsMobileOrModal) { ?>
	<div id="r_Activated" class="form-group row">
		<label id="elh_branches_Activated" class="<?php echo $branches_add->LeftColumnClass ?>"><?php echo $branches->Activated->caption() ?><?php echo ($branches->Activated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $branches_add->RightColumnClass ?>"><div<?php echo $branches->Activated->cellAttributes() ?>>
<span id="el_branches_Activated">
<?php
$selwrk = (ConvertToBool($branches->Activated->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="branches" data-field="x_Activated" name="x_Activated[]" id="x_Activated[]" value="1"<?php echo $selwrk ?><?php echo $branches->Activated->editAttributes() ?>>
</span>
<?php echo $branches->Activated->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Activated">
		<td class="<?php echo $branches_add->TableLeftColumnClass ?>"><span id="elh_branches_Activated"><?php echo $branches->Activated->caption() ?><?php echo ($branches->Activated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $branches->Activated->cellAttributes() ?>>
<span id="el_branches_Activated">
<?php
$selwrk = (ConvertToBool($branches->Activated->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="branches" data-field="x_Activated" name="x_Activated[]" id="x_Activated[]" value="1"<?php echo $selwrk ?><?php echo $branches->Activated->editAttributes() ?>>
</span>
<?php echo $branches->Activated->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($branches_add->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if (!$branches_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $branches_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $branches_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$branches_add->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
</form>
<?php
$branches_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$branches_add->terminate();
?>
