<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$branches_edit = new branches_edit();

// Run the page
$branches_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$branches_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fbranchesedit = currentForm = new ew.Form("fbranchesedit", "edit");

// Validate form
fbranchesedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($branches_edit->BranchID->Required) { ?>
			elm = this.getElements("x" + infix + "_BranchID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $branches->BranchID->caption(), $branches->BranchID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($branches_edit->Branch->Required) { ?>
			elm = this.getElements("x" + infix + "_Branch");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $branches->Branch->caption(), $branches->Branch->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($branches_edit->BranchEn->Required) { ?>
			elm = this.getElements("x" + infix + "_BranchEn");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $branches->BranchEn->caption(), $branches->BranchEn->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($branches_edit->LawFirmID->Required) { ?>
			elm = this.getElements("x" + infix + "_LawFirmID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $branches->LawFirmID->caption(), $branches->LawFirmID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($branches_edit->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $branches->Notes->caption(), $branches->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($branches_edit->Activated->Required) { ?>
			elm = this.getElements("x" + infix + "_Activated[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $branches->Activated->caption(), $branches->Activated->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fbranchesedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fbranchesedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fbranchesedit.lists["x_LawFirmID"] = <?php echo $branches_edit->LawFirmID->Lookup->toClientList() ?>;
fbranchesedit.lists["x_LawFirmID"].options = <?php echo JsonEncode($branches_edit->LawFirmID->lookupOptions()) ?>;
fbranchesedit.lists["x_Activated[]"] = <?php echo $branches_edit->Activated->Lookup->toClientList() ?>;
fbranchesedit.lists["x_Activated[]"].options = <?php echo JsonEncode($branches_edit->Activated->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $branches_edit->showPageHeader(); ?>
<?php
$branches_edit->showMessage();
?>
<?php if (!$branches_edit->IsModal) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($branches_edit->Pager)) $branches_edit->Pager = new PrevNextPager($branches_edit->StartRec, $branches_edit->DisplayRecs, $branches_edit->TotalRecs, $branches_edit->AutoHidePager) ?>
<?php if ($branches_edit->Pager->RecordCount > 0 && $branches_edit->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($branches_edit->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $branches_edit->pageUrl() ?>start=<?php echo $branches_edit->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($branches_edit->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $branches_edit->pageUrl() ?>start=<?php echo $branches_edit->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $branches_edit->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($branches_edit->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $branches_edit->pageUrl() ?>start=<?php echo $branches_edit->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($branches_edit->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $branches_edit->pageUrl() ?>start=<?php echo $branches_edit->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $branches_edit->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<form name="fbranchesedit" id="fbranchesedit" class="<?php echo $branches_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($branches_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $branches_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="branches">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$branches_edit->IsModal ?>">
<?php if (!$branches_edit->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($branches_edit->IsMobileOrModal) { ?>
<div class="ew-edit-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_branchesedit" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($branches->BranchID->Visible) { // BranchID ?>
<?php if ($branches_edit->IsMobileOrModal) { ?>
	<div id="r_BranchID" class="form-group row">
		<label id="elh_branches_BranchID" class="<?php echo $branches_edit->LeftColumnClass ?>"><?php echo $branches->BranchID->caption() ?><?php echo ($branches->BranchID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $branches_edit->RightColumnClass ?>"><div<?php echo $branches->BranchID->cellAttributes() ?>>
<span id="el_branches_BranchID">
<span<?php echo $branches->BranchID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($branches->BranchID->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="branches" data-field="x_BranchID" name="x_BranchID" id="x_BranchID" value="<?php echo HtmlEncode($branches->BranchID->CurrentValue) ?>">
<?php echo $branches->BranchID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_BranchID">
		<td class="<?php echo $branches_edit->TableLeftColumnClass ?>"><span id="elh_branches_BranchID"><?php echo $branches->BranchID->caption() ?><?php echo ($branches->BranchID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $branches->BranchID->cellAttributes() ?>>
<span id="el_branches_BranchID">
<span<?php echo $branches->BranchID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($branches->BranchID->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="branches" data-field="x_BranchID" name="x_BranchID" id="x_BranchID" value="<?php echo HtmlEncode($branches->BranchID->CurrentValue) ?>">
<?php echo $branches->BranchID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($branches->Branch->Visible) { // Branch ?>
<?php if ($branches_edit->IsMobileOrModal) { ?>
	<div id="r_Branch" class="form-group row">
		<label id="elh_branches_Branch" for="x_Branch" class="<?php echo $branches_edit->LeftColumnClass ?>"><?php echo $branches->Branch->caption() ?><?php echo ($branches->Branch->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $branches_edit->RightColumnClass ?>"><div<?php echo $branches->Branch->cellAttributes() ?>>
<span id="el_branches_Branch">
<input type="text" data-table="branches" data-field="x_Branch" name="x_Branch" id="x_Branch" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($branches->Branch->getPlaceHolder()) ?>" value="<?php echo $branches->Branch->EditValue ?>"<?php echo $branches->Branch->editAttributes() ?>>
</span>
<?php echo $branches->Branch->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Branch">
		<td class="<?php echo $branches_edit->TableLeftColumnClass ?>"><span id="elh_branches_Branch"><?php echo $branches->Branch->caption() ?><?php echo ($branches->Branch->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $branches->Branch->cellAttributes() ?>>
<span id="el_branches_Branch">
<input type="text" data-table="branches" data-field="x_Branch" name="x_Branch" id="x_Branch" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($branches->Branch->getPlaceHolder()) ?>" value="<?php echo $branches->Branch->EditValue ?>"<?php echo $branches->Branch->editAttributes() ?>>
</span>
<?php echo $branches->Branch->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($branches->BranchEn->Visible) { // BranchEn ?>
<?php if ($branches_edit->IsMobileOrModal) { ?>
	<div id="r_BranchEn" class="form-group row">
		<label id="elh_branches_BranchEn" for="x_BranchEn" class="<?php echo $branches_edit->LeftColumnClass ?>"><?php echo $branches->BranchEn->caption() ?><?php echo ($branches->BranchEn->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $branches_edit->RightColumnClass ?>"><div<?php echo $branches->BranchEn->cellAttributes() ?>>
<span id="el_branches_BranchEn">
<input type="text" data-table="branches" data-field="x_BranchEn" name="x_BranchEn" id="x_BranchEn" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($branches->BranchEn->getPlaceHolder()) ?>" value="<?php echo $branches->BranchEn->EditValue ?>"<?php echo $branches->BranchEn->editAttributes() ?>>
</span>
<?php echo $branches->BranchEn->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_BranchEn">
		<td class="<?php echo $branches_edit->TableLeftColumnClass ?>"><span id="elh_branches_BranchEn"><?php echo $branches->BranchEn->caption() ?><?php echo ($branches->BranchEn->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $branches->BranchEn->cellAttributes() ?>>
<span id="el_branches_BranchEn">
<input type="text" data-table="branches" data-field="x_BranchEn" name="x_BranchEn" id="x_BranchEn" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($branches->BranchEn->getPlaceHolder()) ?>" value="<?php echo $branches->BranchEn->EditValue ?>"<?php echo $branches->BranchEn->editAttributes() ?>>
</span>
<?php echo $branches->BranchEn->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($branches->LawFirmID->Visible) { // LawFirmID ?>
<?php if ($branches_edit->IsMobileOrModal) { ?>
	<div id="r_LawFirmID" class="form-group row">
		<label id="elh_branches_LawFirmID" for="x_LawFirmID" class="<?php echo $branches_edit->LeftColumnClass ?>"><?php echo $branches->LawFirmID->caption() ?><?php echo ($branches->LawFirmID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $branches_edit->RightColumnClass ?>"><div<?php echo $branches->LawFirmID->cellAttributes() ?>>
<span id="el_branches_LawFirmID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="branches" data-field="x_LawFirmID" data-value-separator="<?php echo $branches->LawFirmID->displayValueSeparatorAttribute() ?>" id="x_LawFirmID" name="x_LawFirmID"<?php echo $branches->LawFirmID->editAttributes() ?>>
		<?php echo $branches->LawFirmID->selectOptionListHtml("x_LawFirmID") ?>
	</select>
</div>
<?php echo $branches->LawFirmID->Lookup->getParamTag("p_x_LawFirmID") ?>
</span>
<?php echo $branches->LawFirmID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_LawFirmID">
		<td class="<?php echo $branches_edit->TableLeftColumnClass ?>"><span id="elh_branches_LawFirmID"><?php echo $branches->LawFirmID->caption() ?><?php echo ($branches->LawFirmID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $branches->LawFirmID->cellAttributes() ?>>
<span id="el_branches_LawFirmID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="branches" data-field="x_LawFirmID" data-value-separator="<?php echo $branches->LawFirmID->displayValueSeparatorAttribute() ?>" id="x_LawFirmID" name="x_LawFirmID"<?php echo $branches->LawFirmID->editAttributes() ?>>
		<?php echo $branches->LawFirmID->selectOptionListHtml("x_LawFirmID") ?>
	</select>
</div>
<?php echo $branches->LawFirmID->Lookup->getParamTag("p_x_LawFirmID") ?>
</span>
<?php echo $branches->LawFirmID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($branches->Notes->Visible) { // Notes ?>
<?php if ($branches_edit->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label id="elh_branches_Notes" for="x_Notes" class="<?php echo $branches_edit->LeftColumnClass ?>"><?php echo $branches->Notes->caption() ?><?php echo ($branches->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $branches_edit->RightColumnClass ?>"><div<?php echo $branches->Notes->cellAttributes() ?>>
<span id="el_branches_Notes">
<textarea data-table="branches" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($branches->Notes->getPlaceHolder()) ?>"<?php echo $branches->Notes->editAttributes() ?>><?php echo $branches->Notes->EditValue ?></textarea>
</span>
<?php echo $branches->Notes->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $branches_edit->TableLeftColumnClass ?>"><span id="elh_branches_Notes"><?php echo $branches->Notes->caption() ?><?php echo ($branches->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $branches->Notes->cellAttributes() ?>>
<span id="el_branches_Notes">
<textarea data-table="branches" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($branches->Notes->getPlaceHolder()) ?>"<?php echo $branches->Notes->editAttributes() ?>><?php echo $branches->Notes->EditValue ?></textarea>
</span>
<?php echo $branches->Notes->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($branches->Activated->Visible) { // Activated ?>
<?php if ($branches_edit->IsMobileOrModal) { ?>
	<div id="r_Activated" class="form-group row">
		<label id="elh_branches_Activated" class="<?php echo $branches_edit->LeftColumnClass ?>"><?php echo $branches->Activated->caption() ?><?php echo ($branches->Activated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $branches_edit->RightColumnClass ?>"><div<?php echo $branches->Activated->cellAttributes() ?>>
<span id="el_branches_Activated">
<?php
$selwrk = (ConvertToBool($branches->Activated->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="branches" data-field="x_Activated" name="x_Activated[]" id="x_Activated[]" value="1"<?php echo $selwrk ?><?php echo $branches->Activated->editAttributes() ?>>
</span>
<?php echo $branches->Activated->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Activated">
		<td class="<?php echo $branches_edit->TableLeftColumnClass ?>"><span id="elh_branches_Activated"><?php echo $branches->Activated->caption() ?><?php echo ($branches->Activated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $branches->Activated->cellAttributes() ?>>
<span id="el_branches_Activated">
<?php
$selwrk = (ConvertToBool($branches->Activated->CurrentValue)) ? " checked" : "";
?>
<input type="checkbox" data-table="branches" data-field="x_Activated" name="x_Activated[]" id="x_Activated[]" value="1"<?php echo $selwrk ?><?php echo $branches->Activated->editAttributes() ?>>
</span>
<?php echo $branches->Activated->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($branches_edit->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if (!$branches_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $branches_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $branches_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$branches_edit->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
<?php if (!$branches_edit->IsModal) { ?>
<?php if (!isset($branches_edit->Pager)) $branches_edit->Pager = new PrevNextPager($branches_edit->StartRec, $branches_edit->DisplayRecs, $branches_edit->TotalRecs, $branches_edit->AutoHidePager) ?>
<?php if ($branches_edit->Pager->RecordCount > 0 && $branches_edit->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($branches_edit->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $branches_edit->pageUrl() ?>start=<?php echo $branches_edit->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($branches_edit->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $branches_edit->pageUrl() ?>start=<?php echo $branches_edit->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $branches_edit->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($branches_edit->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $branches_edit->pageUrl() ?>start=<?php echo $branches_edit->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($branches_edit->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $branches_edit->pageUrl() ?>start=<?php echo $branches_edit->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $branches_edit->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
<?php } ?>
</form>
<?php
$branches_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$branches_edit->terminate();
?>
