<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$cases2_edit = new cases2_edit();

// Run the page
$cases2_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$cases2_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fcases2edit = currentForm = new ew.Form("fcases2edit", "edit");

// Validate form
fcases2edit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($cases2_edit->CaseID->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases2->CaseID->caption(), $cases2->CaseID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases2_edit->ClientID->Required) { ?>
			elm = this.getElements("x" + infix + "_ClientID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases2->ClientID->caption(), $cases2->ClientID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases2_edit->LitigantID->Required) { ?>
			elm = this.getElements("x" + infix + "_LitigantID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases2->LitigantID->caption(), $cases2->LitigantID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases2_edit->CaseTypeID->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseTypeID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases2->CaseTypeID->caption(), $cases2->CaseTypeID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases2_edit->CourtID->Required) { ?>
			elm = this.getElements("x" + infix + "_CourtID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases2->CourtID->caption(), $cases2->CourtID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases2_edit->CaseNumber->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseNumber");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases2->CaseNumber->caption(), $cases2->CaseNumber->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases2_edit->FileNumber->Required) { ?>
			elm = this.getElements("x" + infix + "_FileNumber");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases2->FileNumber->caption(), $cases2->FileNumber->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases2_edit->ClientStatusID->Required) { ?>
			elm = this.getElements("x" + infix + "_ClientStatusID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases2->ClientStatusID->caption(), $cases2->ClientStatusID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases2_edit->LitigantStatusID->Required) { ?>
			elm = this.getElements("x" + infix + "_LitigantStatusID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases2->LitigantStatusID->caption(), $cases2->LitigantStatusID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases2_edit->CaseSortID->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseSortID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases2->CaseSortID->caption(), $cases2->CaseSortID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases2_edit->CaseStatusID->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseStatusID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases2->CaseStatusID->caption(), $cases2->CaseStatusID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases2_edit->ParentCaseID->Required) { ?>
			elm = this.getElements("x" + infix + "_ParentCaseID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases2->ParentCaseID->caption(), $cases2->ParentCaseID->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_ParentCaseID");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($cases2->ParentCaseID->errorMessage()) ?>");
		<?php if ($cases2_edit->CaseRegisteredDate->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseRegisteredDate");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases2->CaseRegisteredDate->caption(), $cases2->CaseRegisteredDate->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_CaseRegisteredDate");
			if (elm && !ew.checkEuroDate(elm.value))
				return this.onError(elm, "<?php echo JsEncode($cases2->CaseRegisteredDate->errorMessage()) ?>");
		<?php if ($cases2_edit->_Case->Required) { ?>
			elm = this.getElements("x" + infix + "__Case");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases2->_Case->caption(), $cases2->_Case->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases2_edit->CourtTypeID->Required) { ?>
			elm = this.getElements("x" + infix + "_CourtTypeID");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases2->CourtTypeID->caption(), $cases2->CourtTypeID->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases2_edit->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases2->Notes->caption(), $cases2->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($cases2_edit->FileLocation->Required) { ?>
			elm = this.getElements("x" + infix + "_FileLocation");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $cases2->FileLocation->caption(), $cases2->FileLocation->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fcases2edit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcases2edit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcases2edit.lists["x_ClientID"] = <?php echo $cases2_edit->ClientID->Lookup->toClientList() ?>;
fcases2edit.lists["x_ClientID"].options = <?php echo JsonEncode($cases2_edit->ClientID->lookupOptions()) ?>;
fcases2edit.autoSuggests["x_ClientID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcases2edit.lists["x_LitigantID"] = <?php echo $cases2_edit->LitigantID->Lookup->toClientList() ?>;
fcases2edit.lists["x_LitigantID"].options = <?php echo JsonEncode($cases2_edit->LitigantID->lookupOptions()) ?>;
fcases2edit.autoSuggests["x_LitigantID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcases2edit.lists["x_CaseTypeID"] = <?php echo $cases2_edit->CaseTypeID->Lookup->toClientList() ?>;
fcases2edit.lists["x_CaseTypeID"].options = <?php echo JsonEncode($cases2_edit->CaseTypeID->lookupOptions()) ?>;
fcases2edit.lists["x_CourtID"] = <?php echo $cases2_edit->CourtID->Lookup->toClientList() ?>;
fcases2edit.lists["x_CourtID"].options = <?php echo JsonEncode($cases2_edit->CourtID->lookupOptions()) ?>;
fcases2edit.autoSuggests["x_CourtID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcases2edit.lists["x_ClientStatusID"] = <?php echo $cases2_edit->ClientStatusID->Lookup->toClientList() ?>;
fcases2edit.lists["x_ClientStatusID"].options = <?php echo JsonEncode($cases2_edit->ClientStatusID->lookupOptions()) ?>;
fcases2edit.lists["x_LitigantStatusID"] = <?php echo $cases2_edit->LitigantStatusID->Lookup->toClientList() ?>;
fcases2edit.lists["x_LitigantStatusID"].options = <?php echo JsonEncode($cases2_edit->LitigantStatusID->lookupOptions()) ?>;
fcases2edit.lists["x_CaseSortID"] = <?php echo $cases2_edit->CaseSortID->Lookup->toClientList() ?>;
fcases2edit.lists["x_CaseSortID"].options = <?php echo JsonEncode($cases2_edit->CaseSortID->lookupOptions()) ?>;
fcases2edit.lists["x_CaseStatusID"] = <?php echo $cases2_edit->CaseStatusID->Lookup->toClientList() ?>;
fcases2edit.lists["x_CaseStatusID"].options = <?php echo JsonEncode($cases2_edit->CaseStatusID->lookupOptions()) ?>;
fcases2edit.lists["x_CourtTypeID"] = <?php echo $cases2_edit->CourtTypeID->Lookup->toClientList() ?>;
fcases2edit.lists["x_CourtTypeID"].options = <?php echo JsonEncode($cases2_edit->CourtTypeID->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $cases2_edit->showPageHeader(); ?>
<?php
$cases2_edit->showMessage();
?>
<?php if (!$cases2_edit->IsModal) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($cases2_edit->Pager)) $cases2_edit->Pager = new PrevNextPager($cases2_edit->StartRec, $cases2_edit->DisplayRecs, $cases2_edit->TotalRecs, $cases2_edit->AutoHidePager) ?>
<?php if ($cases2_edit->Pager->RecordCount > 0 && $cases2_edit->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($cases2_edit->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $cases2_edit->pageUrl() ?>start=<?php echo $cases2_edit->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($cases2_edit->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $cases2_edit->pageUrl() ?>start=<?php echo $cases2_edit->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $cases2_edit->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($cases2_edit->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $cases2_edit->pageUrl() ?>start=<?php echo $cases2_edit->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($cases2_edit->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $cases2_edit->pageUrl() ?>start=<?php echo $cases2_edit->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $cases2_edit->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<form name="fcases2edit" id="fcases2edit" class="<?php echo $cases2_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($cases2_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $cases2_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="cases2">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$cases2_edit->IsModal ?>">
<?php if (!$cases2_edit->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($cases2_edit->IsMobileOrModal) { ?>
<div class="ew-edit-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_cases2edit" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($cases2->ClientID->Visible) { // ClientID ?>
<?php if ($cases2_edit->IsMobileOrModal) { ?>
	<div id="r_ClientID" class="form-group row">
		<label id="elh_cases2_ClientID" class="<?php echo $cases2_edit->LeftColumnClass ?>"><?php echo $cases2->ClientID->caption() ?><?php echo ($cases2->ClientID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases2_edit->RightColumnClass ?>"><div<?php echo $cases2->ClientID->cellAttributes() ?>>
<span id="el_cases2_ClientID">
<?php
$wrkonchange = "" . trim(@$cases2->ClientID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases2->ClientID->EditAttrs["onchange"] = "";
?>
<span id="as_x_ClientID" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_ClientID" id="sv_x_ClientID" value="<?php echo RemoveHtml($cases2->ClientID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases2->ClientID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases2->ClientID->getPlaceHolder()) ?>"<?php echo $cases2->ClientID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases2->ClientID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_ClientID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($cases2->ClientID->ReadOnly || $cases2->ClientID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "clients2") && !$cases2->ClientID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_ClientID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases2->ClientID->caption() ?>" data-title="<?php echo $cases2->ClientID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_ClientID',url:'clients2addopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases2" data-field="x_ClientID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases2->ClientID->displayValueSeparatorAttribute() ?>" name="x_ClientID" id="x_ClientID" value="<?php echo HtmlEncode($cases2->ClientID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcases2edit.createAutoSuggest({"id":"x_ClientID","forceSelect":true});
</script>
<?php echo $cases2->ClientID->Lookup->getParamTag("p_x_ClientID") ?>
</span>
<?php echo $cases2->ClientID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_ClientID">
		<td class="<?php echo $cases2_edit->TableLeftColumnClass ?>"><span id="elh_cases2_ClientID"><?php echo $cases2->ClientID->caption() ?><?php echo ($cases2->ClientID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases2->ClientID->cellAttributes() ?>>
<span id="el_cases2_ClientID">
<?php
$wrkonchange = "" . trim(@$cases2->ClientID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases2->ClientID->EditAttrs["onchange"] = "";
?>
<span id="as_x_ClientID" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_ClientID" id="sv_x_ClientID" value="<?php echo RemoveHtml($cases2->ClientID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases2->ClientID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases2->ClientID->getPlaceHolder()) ?>"<?php echo $cases2->ClientID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases2->ClientID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_ClientID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($cases2->ClientID->ReadOnly || $cases2->ClientID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "clients2") && !$cases2->ClientID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_ClientID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases2->ClientID->caption() ?>" data-title="<?php echo $cases2->ClientID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_ClientID',url:'clients2addopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases2" data-field="x_ClientID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases2->ClientID->displayValueSeparatorAttribute() ?>" name="x_ClientID" id="x_ClientID" value="<?php echo HtmlEncode($cases2->ClientID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcases2edit.createAutoSuggest({"id":"x_ClientID","forceSelect":true});
</script>
<?php echo $cases2->ClientID->Lookup->getParamTag("p_x_ClientID") ?>
</span>
<?php echo $cases2->ClientID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->LitigantID->Visible) { // LitigantID ?>
<?php if ($cases2_edit->IsMobileOrModal) { ?>
	<div id="r_LitigantID" class="form-group row">
		<label id="elh_cases2_LitigantID" class="<?php echo $cases2_edit->LeftColumnClass ?>"><?php echo $cases2->LitigantID->caption() ?><?php echo ($cases2->LitigantID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases2_edit->RightColumnClass ?>"><div<?php echo $cases2->LitigantID->cellAttributes() ?>>
<span id="el_cases2_LitigantID">
<?php
$wrkonchange = "" . trim(@$cases2->LitigantID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases2->LitigantID->EditAttrs["onchange"] = "";
?>
<span id="as_x_LitigantID" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_LitigantID" id="sv_x_LitigantID" value="<?php echo RemoveHtml($cases2->LitigantID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases2->LitigantID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases2->LitigantID->getPlaceHolder()) ?>"<?php echo $cases2->LitigantID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases2->LitigantID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_LitigantID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($cases2->LitigantID->ReadOnly || $cases2->LitigantID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "litigants") && !$cases2->LitigantID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_LitigantID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases2->LitigantID->caption() ?>" data-title="<?php echo $cases2->LitigantID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_LitigantID',url:'litigantsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases2" data-field="x_LitigantID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases2->LitigantID->displayValueSeparatorAttribute() ?>" name="x_LitigantID" id="x_LitigantID" value="<?php echo HtmlEncode($cases2->LitigantID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcases2edit.createAutoSuggest({"id":"x_LitigantID","forceSelect":true});
</script>
<?php echo $cases2->LitigantID->Lookup->getParamTag("p_x_LitigantID") ?>
</span>
<?php echo $cases2->LitigantID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_LitigantID">
		<td class="<?php echo $cases2_edit->TableLeftColumnClass ?>"><span id="elh_cases2_LitigantID"><?php echo $cases2->LitigantID->caption() ?><?php echo ($cases2->LitigantID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases2->LitigantID->cellAttributes() ?>>
<span id="el_cases2_LitigantID">
<?php
$wrkonchange = "" . trim(@$cases2->LitigantID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases2->LitigantID->EditAttrs["onchange"] = "";
?>
<span id="as_x_LitigantID" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_LitigantID" id="sv_x_LitigantID" value="<?php echo RemoveHtml($cases2->LitigantID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases2->LitigantID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases2->LitigantID->getPlaceHolder()) ?>"<?php echo $cases2->LitigantID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases2->LitigantID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_LitigantID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($cases2->LitigantID->ReadOnly || $cases2->LitigantID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "litigants") && !$cases2->LitigantID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_LitigantID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases2->LitigantID->caption() ?>" data-title="<?php echo $cases2->LitigantID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_LitigantID',url:'litigantsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases2" data-field="x_LitigantID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases2->LitigantID->displayValueSeparatorAttribute() ?>" name="x_LitigantID" id="x_LitigantID" value="<?php echo HtmlEncode($cases2->LitigantID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcases2edit.createAutoSuggest({"id":"x_LitigantID","forceSelect":true});
</script>
<?php echo $cases2->LitigantID->Lookup->getParamTag("p_x_LitigantID") ?>
</span>
<?php echo $cases2->LitigantID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->CaseTypeID->Visible) { // CaseTypeID ?>
<?php if ($cases2_edit->IsMobileOrModal) { ?>
	<div id="r_CaseTypeID" class="form-group row">
		<label id="elh_cases2_CaseTypeID" for="x_CaseTypeID" class="<?php echo $cases2_edit->LeftColumnClass ?>"><?php echo $cases2->CaseTypeID->caption() ?><?php echo ($cases2->CaseTypeID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases2_edit->RightColumnClass ?>"><div<?php echo $cases2->CaseTypeID->cellAttributes() ?>>
<span id="el_cases2_CaseTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases2" data-field="x_CaseTypeID" data-value-separator="<?php echo $cases2->CaseTypeID->displayValueSeparatorAttribute() ?>" id="x_CaseTypeID" name="x_CaseTypeID"<?php echo $cases2->CaseTypeID->editAttributes() ?>>
		<?php echo $cases2->CaseTypeID->selectOptionListHtml("x_CaseTypeID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "casetypes") && !$cases2->CaseTypeID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_CaseTypeID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases2->CaseTypeID->caption() ?>" data-title="<?php echo $cases2->CaseTypeID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_CaseTypeID',url:'casetypesaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases2->CaseTypeID->Lookup->getParamTag("p_x_CaseTypeID") ?>
</span>
<?php echo $cases2->CaseTypeID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseTypeID">
		<td class="<?php echo $cases2_edit->TableLeftColumnClass ?>"><span id="elh_cases2_CaseTypeID"><?php echo $cases2->CaseTypeID->caption() ?><?php echo ($cases2->CaseTypeID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases2->CaseTypeID->cellAttributes() ?>>
<span id="el_cases2_CaseTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases2" data-field="x_CaseTypeID" data-value-separator="<?php echo $cases2->CaseTypeID->displayValueSeparatorAttribute() ?>" id="x_CaseTypeID" name="x_CaseTypeID"<?php echo $cases2->CaseTypeID->editAttributes() ?>>
		<?php echo $cases2->CaseTypeID->selectOptionListHtml("x_CaseTypeID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "casetypes") && !$cases2->CaseTypeID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_CaseTypeID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases2->CaseTypeID->caption() ?>" data-title="<?php echo $cases2->CaseTypeID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_CaseTypeID',url:'casetypesaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases2->CaseTypeID->Lookup->getParamTag("p_x_CaseTypeID") ?>
</span>
<?php echo $cases2->CaseTypeID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->CourtID->Visible) { // CourtID ?>
<?php if ($cases2_edit->IsMobileOrModal) { ?>
	<div id="r_CourtID" class="form-group row">
		<label id="elh_cases2_CourtID" class="<?php echo $cases2_edit->LeftColumnClass ?>"><?php echo $cases2->CourtID->caption() ?><?php echo ($cases2->CourtID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases2_edit->RightColumnClass ?>"><div<?php echo $cases2->CourtID->cellAttributes() ?>>
<span id="el_cases2_CourtID">
<?php
$wrkonchange = "" . trim(@$cases2->CourtID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases2->CourtID->EditAttrs["onchange"] = "";
?>
<span id="as_x_CourtID" class="text-nowrap" style="z-index: 8950">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_CourtID" id="sv_x_CourtID" value="<?php echo RemoveHtml($cases2->CourtID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases2->CourtID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases2->CourtID->getPlaceHolder()) ?>"<?php echo $cases2->CourtID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases2->CourtID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_CourtID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($cases2->CourtID->ReadOnly || $cases2->CourtID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "courts") && !$cases2->CourtID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_CourtID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases2->CourtID->caption() ?>" data-title="<?php echo $cases2->CourtID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_CourtID',url:'courtsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases2" data-field="x_CourtID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases2->CourtID->displayValueSeparatorAttribute() ?>" name="x_CourtID" id="x_CourtID" value="<?php echo HtmlEncode($cases2->CourtID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcases2edit.createAutoSuggest({"id":"x_CourtID","forceSelect":true});
</script>
<?php echo $cases2->CourtID->Lookup->getParamTag("p_x_CourtID") ?>
</span>
<?php echo $cases2->CourtID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_CourtID">
		<td class="<?php echo $cases2_edit->TableLeftColumnClass ?>"><span id="elh_cases2_CourtID"><?php echo $cases2->CourtID->caption() ?><?php echo ($cases2->CourtID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases2->CourtID->cellAttributes() ?>>
<span id="el_cases2_CourtID">
<?php
$wrkonchange = "" . trim(@$cases2->CourtID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases2->CourtID->EditAttrs["onchange"] = "";
?>
<span id="as_x_CourtID" class="text-nowrap" style="z-index: 8950">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_CourtID" id="sv_x_CourtID" value="<?php echo RemoveHtml($cases2->CourtID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases2->CourtID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases2->CourtID->getPlaceHolder()) ?>"<?php echo $cases2->CourtID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases2->CourtID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_CourtID',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($cases2->CourtID->ReadOnly || $cases2->CourtID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "courts") && !$cases2->CourtID->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_CourtID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases2->CourtID->caption() ?>" data-title="<?php echo $cases2->CourtID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_CourtID',url:'courtsaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases2" data-field="x_CourtID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases2->CourtID->displayValueSeparatorAttribute() ?>" name="x_CourtID" id="x_CourtID" value="<?php echo HtmlEncode($cases2->CourtID->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcases2edit.createAutoSuggest({"id":"x_CourtID","forceSelect":true});
</script>
<?php echo $cases2->CourtID->Lookup->getParamTag("p_x_CourtID") ?>
</span>
<?php echo $cases2->CourtID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->CaseNumber->Visible) { // CaseNumber ?>
<?php if ($cases2_edit->IsMobileOrModal) { ?>
	<div id="r_CaseNumber" class="form-group row">
		<label id="elh_cases2_CaseNumber" for="x_CaseNumber" class="<?php echo $cases2_edit->LeftColumnClass ?>"><?php echo $cases2->CaseNumber->caption() ?><?php echo ($cases2->CaseNumber->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases2_edit->RightColumnClass ?>"><div<?php echo $cases2->CaseNumber->cellAttributes() ?>>
<span id="el_cases2_CaseNumber">
<input type="text" data-table="cases2" data-field="x_CaseNumber" name="x_CaseNumber" id="x_CaseNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($cases2->CaseNumber->getPlaceHolder()) ?>" value="<?php echo $cases2->CaseNumber->EditValue ?>"<?php echo $cases2->CaseNumber->editAttributes() ?>>
</span>
<?php echo $cases2->CaseNumber->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseNumber">
		<td class="<?php echo $cases2_edit->TableLeftColumnClass ?>"><span id="elh_cases2_CaseNumber"><?php echo $cases2->CaseNumber->caption() ?><?php echo ($cases2->CaseNumber->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases2->CaseNumber->cellAttributes() ?>>
<span id="el_cases2_CaseNumber">
<input type="text" data-table="cases2" data-field="x_CaseNumber" name="x_CaseNumber" id="x_CaseNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($cases2->CaseNumber->getPlaceHolder()) ?>" value="<?php echo $cases2->CaseNumber->EditValue ?>"<?php echo $cases2->CaseNumber->editAttributes() ?>>
</span>
<?php echo $cases2->CaseNumber->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->FileNumber->Visible) { // FileNumber ?>
<?php if ($cases2_edit->IsMobileOrModal) { ?>
	<div id="r_FileNumber" class="form-group row">
		<label id="elh_cases2_FileNumber" for="x_FileNumber" class="<?php echo $cases2_edit->LeftColumnClass ?>"><?php echo $cases2->FileNumber->caption() ?><?php echo ($cases2->FileNumber->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases2_edit->RightColumnClass ?>"><div<?php echo $cases2->FileNumber->cellAttributes() ?>>
<span id="el_cases2_FileNumber">
<input type="text" data-table="cases2" data-field="x_FileNumber" name="x_FileNumber" id="x_FileNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($cases2->FileNumber->getPlaceHolder()) ?>" value="<?php echo $cases2->FileNumber->EditValue ?>"<?php echo $cases2->FileNumber->editAttributes() ?>>
</span>
<?php echo $cases2->FileNumber->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_FileNumber">
		<td class="<?php echo $cases2_edit->TableLeftColumnClass ?>"><span id="elh_cases2_FileNumber"><?php echo $cases2->FileNumber->caption() ?><?php echo ($cases2->FileNumber->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases2->FileNumber->cellAttributes() ?>>
<span id="el_cases2_FileNumber">
<input type="text" data-table="cases2" data-field="x_FileNumber" name="x_FileNumber" id="x_FileNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($cases2->FileNumber->getPlaceHolder()) ?>" value="<?php echo $cases2->FileNumber->EditValue ?>"<?php echo $cases2->FileNumber->editAttributes() ?>>
</span>
<?php echo $cases2->FileNumber->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->ClientStatusID->Visible) { // ClientStatusID ?>
<?php if ($cases2_edit->IsMobileOrModal) { ?>
	<div id="r_ClientStatusID" class="form-group row">
		<label id="elh_cases2_ClientStatusID" for="x_ClientStatusID" class="<?php echo $cases2_edit->LeftColumnClass ?>"><?php echo $cases2->ClientStatusID->caption() ?><?php echo ($cases2->ClientStatusID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases2_edit->RightColumnClass ?>"><div<?php echo $cases2->ClientStatusID->cellAttributes() ?>>
<span id="el_cases2_ClientStatusID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases2" data-field="x_ClientStatusID" data-value-separator="<?php echo $cases2->ClientStatusID->displayValueSeparatorAttribute() ?>" id="x_ClientStatusID" name="x_ClientStatusID"<?php echo $cases2->ClientStatusID->editAttributes() ?>>
		<?php echo $cases2->ClientStatusID->selectOptionListHtml("x_ClientStatusID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "partiesstatus") && !$cases2->ClientStatusID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_ClientStatusID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases2->ClientStatusID->caption() ?>" data-title="<?php echo $cases2->ClientStatusID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_ClientStatusID',url:'partiesstatusaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases2->ClientStatusID->Lookup->getParamTag("p_x_ClientStatusID") ?>
</span>
<?php echo $cases2->ClientStatusID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_ClientStatusID">
		<td class="<?php echo $cases2_edit->TableLeftColumnClass ?>"><span id="elh_cases2_ClientStatusID"><?php echo $cases2->ClientStatusID->caption() ?><?php echo ($cases2->ClientStatusID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases2->ClientStatusID->cellAttributes() ?>>
<span id="el_cases2_ClientStatusID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases2" data-field="x_ClientStatusID" data-value-separator="<?php echo $cases2->ClientStatusID->displayValueSeparatorAttribute() ?>" id="x_ClientStatusID" name="x_ClientStatusID"<?php echo $cases2->ClientStatusID->editAttributes() ?>>
		<?php echo $cases2->ClientStatusID->selectOptionListHtml("x_ClientStatusID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "partiesstatus") && !$cases2->ClientStatusID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_ClientStatusID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases2->ClientStatusID->caption() ?>" data-title="<?php echo $cases2->ClientStatusID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_ClientStatusID',url:'partiesstatusaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases2->ClientStatusID->Lookup->getParamTag("p_x_ClientStatusID") ?>
</span>
<?php echo $cases2->ClientStatusID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->LitigantStatusID->Visible) { // LitigantStatusID ?>
<?php if ($cases2_edit->IsMobileOrModal) { ?>
	<div id="r_LitigantStatusID" class="form-group row">
		<label id="elh_cases2_LitigantStatusID" for="x_LitigantStatusID" class="<?php echo $cases2_edit->LeftColumnClass ?>"><?php echo $cases2->LitigantStatusID->caption() ?><?php echo ($cases2->LitigantStatusID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases2_edit->RightColumnClass ?>"><div<?php echo $cases2->LitigantStatusID->cellAttributes() ?>>
<span id="el_cases2_LitigantStatusID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases2" data-field="x_LitigantStatusID" data-value-separator="<?php echo $cases2->LitigantStatusID->displayValueSeparatorAttribute() ?>" id="x_LitigantStatusID" name="x_LitigantStatusID"<?php echo $cases2->LitigantStatusID->editAttributes() ?>>
		<?php echo $cases2->LitigantStatusID->selectOptionListHtml("x_LitigantStatusID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "partiesstatus") && !$cases2->LitigantStatusID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_LitigantStatusID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases2->LitigantStatusID->caption() ?>" data-title="<?php echo $cases2->LitigantStatusID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_LitigantStatusID',url:'partiesstatusaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases2->LitigantStatusID->Lookup->getParamTag("p_x_LitigantStatusID") ?>
</span>
<?php echo $cases2->LitigantStatusID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_LitigantStatusID">
		<td class="<?php echo $cases2_edit->TableLeftColumnClass ?>"><span id="elh_cases2_LitigantStatusID"><?php echo $cases2->LitigantStatusID->caption() ?><?php echo ($cases2->LitigantStatusID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases2->LitigantStatusID->cellAttributes() ?>>
<span id="el_cases2_LitigantStatusID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases2" data-field="x_LitigantStatusID" data-value-separator="<?php echo $cases2->LitigantStatusID->displayValueSeparatorAttribute() ?>" id="x_LitigantStatusID" name="x_LitigantStatusID"<?php echo $cases2->LitigantStatusID->editAttributes() ?>>
		<?php echo $cases2->LitigantStatusID->selectOptionListHtml("x_LitigantStatusID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "partiesstatus") && !$cases2->LitigantStatusID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_LitigantStatusID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases2->LitigantStatusID->caption() ?>" data-title="<?php echo $cases2->LitigantStatusID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_LitigantStatusID',url:'partiesstatusaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases2->LitigantStatusID->Lookup->getParamTag("p_x_LitigantStatusID") ?>
</span>
<?php echo $cases2->LitigantStatusID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->CaseSortID->Visible) { // CaseSortID ?>
<?php if ($cases2_edit->IsMobileOrModal) { ?>
	<div id="r_CaseSortID" class="form-group row">
		<label id="elh_cases2_CaseSortID" for="x_CaseSortID" class="<?php echo $cases2_edit->LeftColumnClass ?>"><?php echo $cases2->CaseSortID->caption() ?><?php echo ($cases2->CaseSortID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases2_edit->RightColumnClass ?>"><div<?php echo $cases2->CaseSortID->cellAttributes() ?>>
<span id="el_cases2_CaseSortID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases2" data-field="x_CaseSortID" data-value-separator="<?php echo $cases2->CaseSortID->displayValueSeparatorAttribute() ?>" id="x_CaseSortID" name="x_CaseSortID"<?php echo $cases2->CaseSortID->editAttributes() ?>>
		<?php echo $cases2->CaseSortID->selectOptionListHtml("x_CaseSortID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "casesort") && !$cases2->CaseSortID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_CaseSortID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases2->CaseSortID->caption() ?>" data-title="<?php echo $cases2->CaseSortID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_CaseSortID',url:'casesortaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases2->CaseSortID->Lookup->getParamTag("p_x_CaseSortID") ?>
</span>
<?php echo $cases2->CaseSortID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseSortID">
		<td class="<?php echo $cases2_edit->TableLeftColumnClass ?>"><span id="elh_cases2_CaseSortID"><?php echo $cases2->CaseSortID->caption() ?><?php echo ($cases2->CaseSortID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases2->CaseSortID->cellAttributes() ?>>
<span id="el_cases2_CaseSortID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases2" data-field="x_CaseSortID" data-value-separator="<?php echo $cases2->CaseSortID->displayValueSeparatorAttribute() ?>" id="x_CaseSortID" name="x_CaseSortID"<?php echo $cases2->CaseSortID->editAttributes() ?>>
		<?php echo $cases2->CaseSortID->selectOptionListHtml("x_CaseSortID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "casesort") && !$cases2->CaseSortID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_CaseSortID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases2->CaseSortID->caption() ?>" data-title="<?php echo $cases2->CaseSortID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_CaseSortID',url:'casesortaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases2->CaseSortID->Lookup->getParamTag("p_x_CaseSortID") ?>
</span>
<?php echo $cases2->CaseSortID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->CaseStatusID->Visible) { // CaseStatusID ?>
<?php if ($cases2_edit->IsMobileOrModal) { ?>
	<div id="r_CaseStatusID" class="form-group row">
		<label id="elh_cases2_CaseStatusID" for="x_CaseStatusID" class="<?php echo $cases2_edit->LeftColumnClass ?>"><?php echo $cases2->CaseStatusID->caption() ?><?php echo ($cases2->CaseStatusID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases2_edit->RightColumnClass ?>"><div<?php echo $cases2->CaseStatusID->cellAttributes() ?>>
<span id="el_cases2_CaseStatusID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases2" data-field="x_CaseStatusID" data-value-separator="<?php echo $cases2->CaseStatusID->displayValueSeparatorAttribute() ?>" id="x_CaseStatusID" name="x_CaseStatusID"<?php echo $cases2->CaseStatusID->editAttributes() ?>>
		<?php echo $cases2->CaseStatusID->selectOptionListHtml("x_CaseStatusID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "casestatus") && !$cases2->CaseStatusID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_CaseStatusID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases2->CaseStatusID->caption() ?>" data-title="<?php echo $cases2->CaseStatusID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_CaseStatusID',url:'casestatusaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases2->CaseStatusID->Lookup->getParamTag("p_x_CaseStatusID") ?>
</span>
<?php echo $cases2->CaseStatusID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseStatusID">
		<td class="<?php echo $cases2_edit->TableLeftColumnClass ?>"><span id="elh_cases2_CaseStatusID"><?php echo $cases2->CaseStatusID->caption() ?><?php echo ($cases2->CaseStatusID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases2->CaseStatusID->cellAttributes() ?>>
<span id="el_cases2_CaseStatusID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases2" data-field="x_CaseStatusID" data-value-separator="<?php echo $cases2->CaseStatusID->displayValueSeparatorAttribute() ?>" id="x_CaseStatusID" name="x_CaseStatusID"<?php echo $cases2->CaseStatusID->editAttributes() ?>>
		<?php echo $cases2->CaseStatusID->selectOptionListHtml("x_CaseStatusID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "casestatus") && !$cases2->CaseStatusID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_CaseStatusID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases2->CaseStatusID->caption() ?>" data-title="<?php echo $cases2->CaseStatusID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_CaseStatusID',url:'casestatusaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases2->CaseStatusID->Lookup->getParamTag("p_x_CaseStatusID") ?>
</span>
<?php echo $cases2->CaseStatusID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->ParentCaseID->Visible) { // ParentCaseID ?>
<?php if ($cases2_edit->IsMobileOrModal) { ?>
	<div id="r_ParentCaseID" class="form-group row">
		<label id="elh_cases2_ParentCaseID" for="x_ParentCaseID" class="<?php echo $cases2_edit->LeftColumnClass ?>"><?php echo $cases2->ParentCaseID->caption() ?><?php echo ($cases2->ParentCaseID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases2_edit->RightColumnClass ?>"><div<?php echo $cases2->ParentCaseID->cellAttributes() ?>>
<span id="el_cases2_ParentCaseID">
<input type="text" data-table="cases2" data-field="x_ParentCaseID" name="x_ParentCaseID" id="x_ParentCaseID" size="30" placeholder="<?php echo HtmlEncode($cases2->ParentCaseID->getPlaceHolder()) ?>" value="<?php echo $cases2->ParentCaseID->EditValue ?>"<?php echo $cases2->ParentCaseID->editAttributes() ?>>
</span>
<?php echo $cases2->ParentCaseID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_ParentCaseID">
		<td class="<?php echo $cases2_edit->TableLeftColumnClass ?>"><span id="elh_cases2_ParentCaseID"><?php echo $cases2->ParentCaseID->caption() ?><?php echo ($cases2->ParentCaseID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases2->ParentCaseID->cellAttributes() ?>>
<span id="el_cases2_ParentCaseID">
<input type="text" data-table="cases2" data-field="x_ParentCaseID" name="x_ParentCaseID" id="x_ParentCaseID" size="30" placeholder="<?php echo HtmlEncode($cases2->ParentCaseID->getPlaceHolder()) ?>" value="<?php echo $cases2->ParentCaseID->EditValue ?>"<?php echo $cases2->ParentCaseID->editAttributes() ?>>
</span>
<?php echo $cases2->ParentCaseID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->CaseRegisteredDate->Visible) { // CaseRegisteredDate ?>
<?php if ($cases2_edit->IsMobileOrModal) { ?>
	<div id="r_CaseRegisteredDate" class="form-group row">
		<label id="elh_cases2_CaseRegisteredDate" for="x_CaseRegisteredDate" class="<?php echo $cases2_edit->LeftColumnClass ?>"><?php echo $cases2->CaseRegisteredDate->caption() ?><?php echo ($cases2->CaseRegisteredDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases2_edit->RightColumnClass ?>"><div<?php echo $cases2->CaseRegisteredDate->cellAttributes() ?>>
<span id="el_cases2_CaseRegisteredDate">
<input type="text" data-table="cases2" data-field="x_CaseRegisteredDate" data-format="7" name="x_CaseRegisteredDate" id="x_CaseRegisteredDate" placeholder="<?php echo HtmlEncode($cases2->CaseRegisteredDate->getPlaceHolder()) ?>" value="<?php echo $cases2->CaseRegisteredDate->EditValue ?>"<?php echo $cases2->CaseRegisteredDate->editAttributes() ?>>
<?php if (!$cases2->CaseRegisteredDate->ReadOnly && !$cases2->CaseRegisteredDate->Disabled && !isset($cases2->CaseRegisteredDate->EditAttrs["readonly"]) && !isset($cases2->CaseRegisteredDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fcases2edit", "x_CaseRegisteredDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<?php echo $cases2->CaseRegisteredDate->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseRegisteredDate">
		<td class="<?php echo $cases2_edit->TableLeftColumnClass ?>"><span id="elh_cases2_CaseRegisteredDate"><?php echo $cases2->CaseRegisteredDate->caption() ?><?php echo ($cases2->CaseRegisteredDate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases2->CaseRegisteredDate->cellAttributes() ?>>
<span id="el_cases2_CaseRegisteredDate">
<input type="text" data-table="cases2" data-field="x_CaseRegisteredDate" data-format="7" name="x_CaseRegisteredDate" id="x_CaseRegisteredDate" placeholder="<?php echo HtmlEncode($cases2->CaseRegisteredDate->getPlaceHolder()) ?>" value="<?php echo $cases2->CaseRegisteredDate->EditValue ?>"<?php echo $cases2->CaseRegisteredDate->editAttributes() ?>>
<?php if (!$cases2->CaseRegisteredDate->ReadOnly && !$cases2->CaseRegisteredDate->Disabled && !isset($cases2->CaseRegisteredDate->EditAttrs["readonly"]) && !isset($cases2->CaseRegisteredDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fcases2edit", "x_CaseRegisteredDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
<?php echo $cases2->CaseRegisteredDate->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->_Case->Visible) { // Case ?>
<?php if ($cases2_edit->IsMobileOrModal) { ?>
	<div id="r__Case" class="form-group row">
		<label id="elh_cases2__Case" for="x__Case" class="<?php echo $cases2_edit->LeftColumnClass ?>"><?php echo $cases2->_Case->caption() ?><?php echo ($cases2->_Case->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases2_edit->RightColumnClass ?>"><div<?php echo $cases2->_Case->cellAttributes() ?>>
<span id="el_cases2__Case">
<input type="text" data-table="cases2" data-field="x__Case" name="x__Case" id="x__Case" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($cases2->_Case->getPlaceHolder()) ?>" value="<?php echo $cases2->_Case->EditValue ?>"<?php echo $cases2->_Case->editAttributes() ?>>
</span>
<?php echo $cases2->_Case->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r__Case">
		<td class="<?php echo $cases2_edit->TableLeftColumnClass ?>"><span id="elh_cases2__Case"><?php echo $cases2->_Case->caption() ?><?php echo ($cases2->_Case->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases2->_Case->cellAttributes() ?>>
<span id="el_cases2__Case">
<input type="text" data-table="cases2" data-field="x__Case" name="x__Case" id="x__Case" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($cases2->_Case->getPlaceHolder()) ?>" value="<?php echo $cases2->_Case->EditValue ?>"<?php echo $cases2->_Case->editAttributes() ?>>
</span>
<?php echo $cases2->_Case->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->CourtTypeID->Visible) { // CourtTypeID ?>
<?php if ($cases2_edit->IsMobileOrModal) { ?>
	<div id="r_CourtTypeID" class="form-group row">
		<label id="elh_cases2_CourtTypeID" for="x_CourtTypeID" class="<?php echo $cases2_edit->LeftColumnClass ?>"><?php echo $cases2->CourtTypeID->caption() ?><?php echo ($cases2->CourtTypeID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases2_edit->RightColumnClass ?>"><div<?php echo $cases2->CourtTypeID->cellAttributes() ?>>
<span id="el_cases2_CourtTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases2" data-field="x_CourtTypeID" data-value-separator="<?php echo $cases2->CourtTypeID->displayValueSeparatorAttribute() ?>" id="x_CourtTypeID" name="x_CourtTypeID"<?php echo $cases2->CourtTypeID->editAttributes() ?>>
		<?php echo $cases2->CourtTypeID->selectOptionListHtml("x_CourtTypeID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "courttype") && !$cases2->CourtTypeID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_CourtTypeID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases2->CourtTypeID->caption() ?>" data-title="<?php echo $cases2->CourtTypeID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_CourtTypeID',url:'courttypeaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases2->CourtTypeID->Lookup->getParamTag("p_x_CourtTypeID") ?>
</span>
<?php echo $cases2->CourtTypeID->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_CourtTypeID">
		<td class="<?php echo $cases2_edit->TableLeftColumnClass ?>"><span id="elh_cases2_CourtTypeID"><?php echo $cases2->CourtTypeID->caption() ?><?php echo ($cases2->CourtTypeID->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases2->CourtTypeID->cellAttributes() ?>>
<span id="el_cases2_CourtTypeID">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="cases2" data-field="x_CourtTypeID" data-value-separator="<?php echo $cases2->CourtTypeID->displayValueSeparatorAttribute() ?>" id="x_CourtTypeID" name="x_CourtTypeID"<?php echo $cases2->CourtTypeID->editAttributes() ?>>
		<?php echo $cases2->CourtTypeID->selectOptionListHtml("x_CourtTypeID") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "courttype") && !$cases2->CourtTypeID->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_CourtTypeID" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $cases2->CourtTypeID->caption() ?>" data-title="<?php echo $cases2->CourtTypeID->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_CourtTypeID',url:'courttypeaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $cases2->CourtTypeID->Lookup->getParamTag("p_x_CourtTypeID") ?>
</span>
<?php echo $cases2->CourtTypeID->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->Notes->Visible) { // Notes ?>
<?php if ($cases2_edit->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label id="elh_cases2_Notes" class="<?php echo $cases2_edit->LeftColumnClass ?>"><?php echo $cases2->Notes->caption() ?><?php echo ($cases2->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases2_edit->RightColumnClass ?>"><div<?php echo $cases2->Notes->cellAttributes() ?>>
<span id="el_cases2_Notes">
<?php AppendClass($cases2->Notes->EditAttrs["class"], "editor"); ?>
<textarea data-table="cases2" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($cases2->Notes->getPlaceHolder()) ?>"<?php echo $cases2->Notes->editAttributes() ?>><?php echo $cases2->Notes->EditValue ?></textarea>
<script>
ew.createEditor("fcases2edit", "x_Notes", 35, 4, <?php echo ($cases2->Notes->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $cases2->Notes->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $cases2_edit->TableLeftColumnClass ?>"><span id="elh_cases2_Notes"><?php echo $cases2->Notes->caption() ?><?php echo ($cases2->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases2->Notes->cellAttributes() ?>>
<span id="el_cases2_Notes">
<?php AppendClass($cases2->Notes->EditAttrs["class"], "editor"); ?>
<textarea data-table="cases2" data-field="x_Notes" name="x_Notes" id="x_Notes" cols="35" rows="4" placeholder="<?php echo HtmlEncode($cases2->Notes->getPlaceHolder()) ?>"<?php echo $cases2->Notes->editAttributes() ?>><?php echo $cases2->Notes->EditValue ?></textarea>
<script>
ew.createEditor("fcases2edit", "x_Notes", 35, 4, <?php echo ($cases2->Notes->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $cases2->Notes->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->FileLocation->Visible) { // FileLocation ?>
<?php if ($cases2_edit->IsMobileOrModal) { ?>
	<div id="r_FileLocation" class="form-group row">
		<label id="elh_cases2_FileLocation" for="x_FileLocation" class="<?php echo $cases2_edit->LeftColumnClass ?>"><?php echo $cases2->FileLocation->caption() ?><?php echo ($cases2->FileLocation->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $cases2_edit->RightColumnClass ?>"><div<?php echo $cases2->FileLocation->cellAttributes() ?>>
<span id="el_cases2_FileLocation">
<input type="text" data-table="cases2" data-field="x_FileLocation" name="x_FileLocation" id="x_FileLocation" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($cases2->FileLocation->getPlaceHolder()) ?>" value="<?php echo $cases2->FileLocation->EditValue ?>"<?php echo $cases2->FileLocation->editAttributes() ?>>
</span>
<?php echo $cases2->FileLocation->CustomMsg ?></div></div>
	</div>
<?php } else { ?>
	<tr id="r_FileLocation">
		<td class="<?php echo $cases2_edit->TableLeftColumnClass ?>"><span id="elh_cases2_FileLocation"><?php echo $cases2->FileLocation->caption() ?><?php echo ($cases2->FileLocation->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></span></td>
		<td<?php echo $cases2->FileLocation->cellAttributes() ?>>
<span id="el_cases2_FileLocation">
<input type="text" data-table="cases2" data-field="x_FileLocation" name="x_FileLocation" id="x_FileLocation" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($cases2->FileLocation->getPlaceHolder()) ?>" value="<?php echo $cases2->FileLocation->EditValue ?>"<?php echo $cases2->FileLocation->editAttributes() ?>>
</span>
<?php echo $cases2->FileLocation->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2_edit->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<span id="el_cases2_CaseID">
<input type="hidden" data-table="cases2" data-field="x_CaseID" name="x_CaseID" id="x_CaseID" value="<?php echo HtmlEncode($cases2->CaseID->CurrentValue) ?>">
</span>
<?php if (!$cases2_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $cases2_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $cases2_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$cases2_edit->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
<?php if (!$cases2_edit->IsModal) { ?>
<?php if (!isset($cases2_edit->Pager)) $cases2_edit->Pager = new PrevNextPager($cases2_edit->StartRec, $cases2_edit->DisplayRecs, $cases2_edit->TotalRecs, $cases2_edit->AutoHidePager) ?>
<?php if ($cases2_edit->Pager->RecordCount > 0 && $cases2_edit->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($cases2_edit->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $cases2_edit->pageUrl() ?>start=<?php echo $cases2_edit->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($cases2_edit->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $cases2_edit->pageUrl() ?>start=<?php echo $cases2_edit->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $cases2_edit->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($cases2_edit->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $cases2_edit->pageUrl() ?>start=<?php echo $cases2_edit->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($cases2_edit->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $cases2_edit->pageUrl() ?>start=<?php echo $cases2_edit->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $cases2_edit->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<div class="clearfix"></div>
<?php } ?>
</form>
<?php
$cases2_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$cases2_edit->terminate();
?>
