<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$cases2_search = new cases2_search();

// Run the page
$cases2_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$cases2_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($cases2_search->IsModal) { ?>
var fcases2search = currentAdvancedSearchForm = new ew.Form("fcases2search", "search");
<?php } else { ?>
var fcases2search = currentForm = new ew.Form("fcases2search", "search");
<?php } ?>

// Form_CustomValidate event
fcases2search.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcases2search.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcases2search.lists["x_ClientID"] = <?php echo $cases2_search->ClientID->Lookup->toClientList() ?>;
fcases2search.lists["x_ClientID"].options = <?php echo JsonEncode($cases2_search->ClientID->lookupOptions()) ?>;
fcases2search.autoSuggests["x_ClientID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcases2search.lists["x_LitigantID"] = <?php echo $cases2_search->LitigantID->Lookup->toClientList() ?>;
fcases2search.lists["x_LitigantID"].options = <?php echo JsonEncode($cases2_search->LitigantID->lookupOptions()) ?>;
fcases2search.autoSuggests["x_LitigantID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcases2search.lists["x_CaseTypeID"] = <?php echo $cases2_search->CaseTypeID->Lookup->toClientList() ?>;
fcases2search.lists["x_CaseTypeID"].options = <?php echo JsonEncode($cases2_search->CaseTypeID->lookupOptions()) ?>;
fcases2search.lists["x_CourtID"] = <?php echo $cases2_search->CourtID->Lookup->toClientList() ?>;
fcases2search.lists["x_CourtID"].options = <?php echo JsonEncode($cases2_search->CourtID->lookupOptions()) ?>;
fcases2search.autoSuggests["x_CourtID"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fcases2search.lists["x_ClientStatusID"] = <?php echo $cases2_search->ClientStatusID->Lookup->toClientList() ?>;
fcases2search.lists["x_ClientStatusID"].options = <?php echo JsonEncode($cases2_search->ClientStatusID->lookupOptions()) ?>;
fcases2search.lists["x_LitigantStatusID"] = <?php echo $cases2_search->LitigantStatusID->Lookup->toClientList() ?>;
fcases2search.lists["x_LitigantStatusID"].options = <?php echo JsonEncode($cases2_search->LitigantStatusID->lookupOptions()) ?>;
fcases2search.lists["x_CaseSortID"] = <?php echo $cases2_search->CaseSortID->Lookup->toClientList() ?>;
fcases2search.lists["x_CaseSortID"].options = <?php echo JsonEncode($cases2_search->CaseSortID->lookupOptions()) ?>;
fcases2search.lists["x_CaseStatusID"] = <?php echo $cases2_search->CaseStatusID->Lookup->toClientList() ?>;
fcases2search.lists["x_CaseStatusID"].options = <?php echo JsonEncode($cases2_search->CaseStatusID->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fcases2search.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_CaseRegisteredDate");
	if (elm && !ew.checkEuroDate(elm.value))
		return this.onError(elm, "<?php echo JsEncode($cases2->CaseRegisteredDate->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $cases2_search->showPageHeader(); ?>
<?php
$cases2_search->showMessage();
?>
<form name="fcases2search" id="fcases2search" class="<?php echo $cases2_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($cases2_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $cases2_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="cases2">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$cases2_search->IsModal ?>">
<?php if (!$cases2_search->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($cases2_search->IsMobileOrModal) { ?>
<div class="ew-search-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_cases2search" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($cases2->CaseID->Visible) { // CaseID ?>
<?php if ($cases2_search->IsMobileOrModal) { ?>
	<div id="r_CaseID" class="form-group row">
		<label class="<?php echo $cases2_search->LeftColumnClass ?>"><span id="elh_cases2_CaseID"><?php echo $cases2->CaseID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CaseID" id="z_CaseID" value="="></span>
		</label>
		<div class="<?php echo $cases2_search->RightColumnClass ?>"><div<?php echo $cases2->CaseID->cellAttributes() ?>>
			<span id="el_cases2_CaseID">
<input type="text" data-table="cases2" data-field="x_CaseID" name="x_CaseID" id="x_CaseID" placeholder="<?php echo HtmlEncode($cases2->CaseID->getPlaceHolder()) ?>" value="<?php echo $cases2->CaseID->EditValue ?>"<?php echo $cases2->CaseID->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseID">
		<td class="<?php echo $cases2_search->TableLeftColumnClass ?>"><span id="elh_cases2_CaseID"><?php echo $cases2->CaseID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CaseID" id="z_CaseID" value="="></span></td>
		<td<?php echo $cases2->CaseID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases2_CaseID">
<input type="text" data-table="cases2" data-field="x_CaseID" name="x_CaseID" id="x_CaseID" placeholder="<?php echo HtmlEncode($cases2->CaseID->getPlaceHolder()) ?>" value="<?php echo $cases2->CaseID->EditValue ?>"<?php echo $cases2->CaseID->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->ClientID->Visible) { // ClientID ?>
<?php if ($cases2_search->IsMobileOrModal) { ?>
	<div id="r_ClientID" class="form-group row">
		<label class="<?php echo $cases2_search->LeftColumnClass ?>"><span id="elh_cases2_ClientID"><?php echo $cases2->ClientID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ClientID" id="z_ClientID" value="="></span>
		</label>
		<div class="<?php echo $cases2_search->RightColumnClass ?>"><div<?php echo $cases2->ClientID->cellAttributes() ?>>
			<span id="el_cases2_ClientID">
<?php
$wrkonchange = "" . trim(@$cases2->ClientID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases2->ClientID->EditAttrs["onchange"] = "";
?>
<span id="as_x_ClientID" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_ClientID" id="sv_x_ClientID" value="<?php echo RemoveHtml($cases2->ClientID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases2->ClientID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases2->ClientID->getPlaceHolder()) ?>"<?php echo $cases2->ClientID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases2->ClientID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_ClientID',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($cases2->ClientID->ReadOnly || $cases2->ClientID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases2" data-field="x_ClientID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases2->ClientID->displayValueSeparatorAttribute() ?>" name="x_ClientID" id="x_ClientID" value="<?php echo HtmlEncode($cases2->ClientID->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcases2search.createAutoSuggest({"id":"x_ClientID","forceSelect":false});
</script>
<?php echo $cases2->ClientID->Lookup->getParamTag("p_x_ClientID") ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_ClientID">
		<td class="<?php echo $cases2_search->TableLeftColumnClass ?>"><span id="elh_cases2_ClientID"><?php echo $cases2->ClientID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ClientID" id="z_ClientID" value="="></span></td>
		<td<?php echo $cases2->ClientID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases2_ClientID">
<?php
$wrkonchange = "" . trim(@$cases2->ClientID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases2->ClientID->EditAttrs["onchange"] = "";
?>
<span id="as_x_ClientID" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_ClientID" id="sv_x_ClientID" value="<?php echo RemoveHtml($cases2->ClientID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases2->ClientID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases2->ClientID->getPlaceHolder()) ?>"<?php echo $cases2->ClientID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases2->ClientID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_ClientID',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($cases2->ClientID->ReadOnly || $cases2->ClientID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases2" data-field="x_ClientID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases2->ClientID->displayValueSeparatorAttribute() ?>" name="x_ClientID" id="x_ClientID" value="<?php echo HtmlEncode($cases2->ClientID->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcases2search.createAutoSuggest({"id":"x_ClientID","forceSelect":false});
</script>
<?php echo $cases2->ClientID->Lookup->getParamTag("p_x_ClientID") ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->LitigantID->Visible) { // LitigantID ?>
<?php if ($cases2_search->IsMobileOrModal) { ?>
	<div id="r_LitigantID" class="form-group row">
		<label class="<?php echo $cases2_search->LeftColumnClass ?>"><span id="elh_cases2_LitigantID"><?php echo $cases2->LitigantID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_LitigantID" id="z_LitigantID" value="="></span>
		</label>
		<div class="<?php echo $cases2_search->RightColumnClass ?>"><div<?php echo $cases2->LitigantID->cellAttributes() ?>>
			<span id="el_cases2_LitigantID">
<?php
$wrkonchange = "" . trim(@$cases2->LitigantID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases2->LitigantID->EditAttrs["onchange"] = "";
?>
<span id="as_x_LitigantID" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_LitigantID" id="sv_x_LitigantID" value="<?php echo RemoveHtml($cases2->LitigantID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases2->LitigantID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases2->LitigantID->getPlaceHolder()) ?>"<?php echo $cases2->LitigantID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases2->LitigantID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_LitigantID',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($cases2->LitigantID->ReadOnly || $cases2->LitigantID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases2" data-field="x_LitigantID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases2->LitigantID->displayValueSeparatorAttribute() ?>" name="x_LitigantID" id="x_LitigantID" value="<?php echo HtmlEncode($cases2->LitigantID->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcases2search.createAutoSuggest({"id":"x_LitigantID","forceSelect":false});
</script>
<?php echo $cases2->LitigantID->Lookup->getParamTag("p_x_LitigantID") ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_LitigantID">
		<td class="<?php echo $cases2_search->TableLeftColumnClass ?>"><span id="elh_cases2_LitigantID"><?php echo $cases2->LitigantID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_LitigantID" id="z_LitigantID" value="="></span></td>
		<td<?php echo $cases2->LitigantID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases2_LitigantID">
<?php
$wrkonchange = "" . trim(@$cases2->LitigantID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases2->LitigantID->EditAttrs["onchange"] = "";
?>
<span id="as_x_LitigantID" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_LitigantID" id="sv_x_LitigantID" value="<?php echo RemoveHtml($cases2->LitigantID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases2->LitigantID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases2->LitigantID->getPlaceHolder()) ?>"<?php echo $cases2->LitigantID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases2->LitigantID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_LitigantID',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($cases2->LitigantID->ReadOnly || $cases2->LitigantID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases2" data-field="x_LitigantID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases2->LitigantID->displayValueSeparatorAttribute() ?>" name="x_LitigantID" id="x_LitigantID" value="<?php echo HtmlEncode($cases2->LitigantID->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcases2search.createAutoSuggest({"id":"x_LitigantID","forceSelect":false});
</script>
<?php echo $cases2->LitigantID->Lookup->getParamTag("p_x_LitigantID") ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->CaseTypeID->Visible) { // CaseTypeID ?>
<?php if ($cases2_search->IsMobileOrModal) { ?>
	<div id="r_CaseTypeID" class="form-group row">
		<label for="x_CaseTypeID" class="<?php echo $cases2_search->LeftColumnClass ?>"><span id="elh_cases2_CaseTypeID"><?php echo $cases2->CaseTypeID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CaseTypeID" id="z_CaseTypeID" value="="></span>
		</label>
		<div class="<?php echo $cases2_search->RightColumnClass ?>"><div<?php echo $cases2->CaseTypeID->cellAttributes() ?>>
			<span id="el_cases2_CaseTypeID">
<input type="text" data-table="cases2" data-field="x_CaseTypeID" name="x_CaseTypeID" id="x_CaseTypeID" size="30" placeholder="<?php echo HtmlEncode($cases2->CaseTypeID->getPlaceHolder()) ?>" value="<?php echo $cases2->CaseTypeID->EditValue ?>"<?php echo $cases2->CaseTypeID->editAttributes() ?>>
<?php echo $cases2->CaseTypeID->Lookup->getParamTag("p_x_CaseTypeID") ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseTypeID">
		<td class="<?php echo $cases2_search->TableLeftColumnClass ?>"><span id="elh_cases2_CaseTypeID"><?php echo $cases2->CaseTypeID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CaseTypeID" id="z_CaseTypeID" value="="></span></td>
		<td<?php echo $cases2->CaseTypeID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases2_CaseTypeID">
<input type="text" data-table="cases2" data-field="x_CaseTypeID" name="x_CaseTypeID" id="x_CaseTypeID" size="30" placeholder="<?php echo HtmlEncode($cases2->CaseTypeID->getPlaceHolder()) ?>" value="<?php echo $cases2->CaseTypeID->EditValue ?>"<?php echo $cases2->CaseTypeID->editAttributes() ?>>
<?php echo $cases2->CaseTypeID->Lookup->getParamTag("p_x_CaseTypeID") ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->CourtID->Visible) { // CourtID ?>
<?php if ($cases2_search->IsMobileOrModal) { ?>
	<div id="r_CourtID" class="form-group row">
		<label class="<?php echo $cases2_search->LeftColumnClass ?>"><span id="elh_cases2_CourtID"><?php echo $cases2->CourtID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CourtID" id="z_CourtID" value="="></span>
		</label>
		<div class="<?php echo $cases2_search->RightColumnClass ?>"><div<?php echo $cases2->CourtID->cellAttributes() ?>>
			<span id="el_cases2_CourtID">
<?php
$wrkonchange = "" . trim(@$cases2->CourtID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases2->CourtID->EditAttrs["onchange"] = "";
?>
<span id="as_x_CourtID" class="text-nowrap" style="z-index: 8950">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_CourtID" id="sv_x_CourtID" value="<?php echo RemoveHtml($cases2->CourtID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases2->CourtID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases2->CourtID->getPlaceHolder()) ?>"<?php echo $cases2->CourtID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases2->CourtID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_CourtID',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($cases2->CourtID->ReadOnly || $cases2->CourtID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases2" data-field="x_CourtID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases2->CourtID->displayValueSeparatorAttribute() ?>" name="x_CourtID" id="x_CourtID" value="<?php echo HtmlEncode($cases2->CourtID->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcases2search.createAutoSuggest({"id":"x_CourtID","forceSelect":false});
</script>
<?php echo $cases2->CourtID->Lookup->getParamTag("p_x_CourtID") ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_CourtID">
		<td class="<?php echo $cases2_search->TableLeftColumnClass ?>"><span id="elh_cases2_CourtID"><?php echo $cases2->CourtID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CourtID" id="z_CourtID" value="="></span></td>
		<td<?php echo $cases2->CourtID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases2_CourtID">
<?php
$wrkonchange = "" . trim(@$cases2->CourtID->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$cases2->CourtID->EditAttrs["onchange"] = "";
?>
<span id="as_x_CourtID" class="text-nowrap" style="z-index: 8950">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_CourtID" id="sv_x_CourtID" value="<?php echo RemoveHtml($cases2->CourtID->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($cases2->CourtID->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($cases2->CourtID->getPlaceHolder()) ?>"<?php echo $cases2->CourtID->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($cases2->CourtID->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_CourtID',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($cases2->CourtID->ReadOnly || $cases2->CourtID->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="cases2" data-field="x_CourtID" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $cases2->CourtID->displayValueSeparatorAttribute() ?>" name="x_CourtID" id="x_CourtID" value="<?php echo HtmlEncode($cases2->CourtID->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcases2search.createAutoSuggest({"id":"x_CourtID","forceSelect":false});
</script>
<?php echo $cases2->CourtID->Lookup->getParamTag("p_x_CourtID") ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->CaseNumber->Visible) { // CaseNumber ?>
<?php if ($cases2_search->IsMobileOrModal) { ?>
	<div id="r_CaseNumber" class="form-group row">
		<label for="x_CaseNumber" class="<?php echo $cases2_search->LeftColumnClass ?>"><span id="elh_cases2_CaseNumber"><?php echo $cases2->CaseNumber->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_CaseNumber" id="z_CaseNumber" value="LIKE"></span>
		</label>
		<div class="<?php echo $cases2_search->RightColumnClass ?>"><div<?php echo $cases2->CaseNumber->cellAttributes() ?>>
			<span id="el_cases2_CaseNumber">
<input type="text" data-table="cases2" data-field="x_CaseNumber" name="x_CaseNumber" id="x_CaseNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($cases2->CaseNumber->getPlaceHolder()) ?>" value="<?php echo $cases2->CaseNumber->EditValue ?>"<?php echo $cases2->CaseNumber->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseNumber">
		<td class="<?php echo $cases2_search->TableLeftColumnClass ?>"><span id="elh_cases2_CaseNumber"><?php echo $cases2->CaseNumber->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_CaseNumber" id="z_CaseNumber" value="LIKE"></span></td>
		<td<?php echo $cases2->CaseNumber->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases2_CaseNumber">
<input type="text" data-table="cases2" data-field="x_CaseNumber" name="x_CaseNumber" id="x_CaseNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($cases2->CaseNumber->getPlaceHolder()) ?>" value="<?php echo $cases2->CaseNumber->EditValue ?>"<?php echo $cases2->CaseNumber->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->FileNumber->Visible) { // FileNumber ?>
<?php if ($cases2_search->IsMobileOrModal) { ?>
	<div id="r_FileNumber" class="form-group row">
		<label for="x_FileNumber" class="<?php echo $cases2_search->LeftColumnClass ?>"><span id="elh_cases2_FileNumber"><?php echo $cases2->FileNumber->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_FileNumber" id="z_FileNumber" value="LIKE"></span>
		</label>
		<div class="<?php echo $cases2_search->RightColumnClass ?>"><div<?php echo $cases2->FileNumber->cellAttributes() ?>>
			<span id="el_cases2_FileNumber">
<input type="text" data-table="cases2" data-field="x_FileNumber" name="x_FileNumber" id="x_FileNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($cases2->FileNumber->getPlaceHolder()) ?>" value="<?php echo $cases2->FileNumber->EditValue ?>"<?php echo $cases2->FileNumber->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_FileNumber">
		<td class="<?php echo $cases2_search->TableLeftColumnClass ?>"><span id="elh_cases2_FileNumber"><?php echo $cases2->FileNumber->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_FileNumber" id="z_FileNumber" value="LIKE"></span></td>
		<td<?php echo $cases2->FileNumber->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases2_FileNumber">
<input type="text" data-table="cases2" data-field="x_FileNumber" name="x_FileNumber" id="x_FileNumber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($cases2->FileNumber->getPlaceHolder()) ?>" value="<?php echo $cases2->FileNumber->EditValue ?>"<?php echo $cases2->FileNumber->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->ClientStatusID->Visible) { // ClientStatusID ?>
<?php if ($cases2_search->IsMobileOrModal) { ?>
	<div id="r_ClientStatusID" class="form-group row">
		<label for="x_ClientStatusID" class="<?php echo $cases2_search->LeftColumnClass ?>"><span id="elh_cases2_ClientStatusID"><?php echo $cases2->ClientStatusID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ClientStatusID" id="z_ClientStatusID" value="="></span>
		</label>
		<div class="<?php echo $cases2_search->RightColumnClass ?>"><div<?php echo $cases2->ClientStatusID->cellAttributes() ?>>
			<span id="el_cases2_ClientStatusID">
<input type="text" data-table="cases2" data-field="x_ClientStatusID" name="x_ClientStatusID" id="x_ClientStatusID" size="30" placeholder="<?php echo HtmlEncode($cases2->ClientStatusID->getPlaceHolder()) ?>" value="<?php echo $cases2->ClientStatusID->EditValue ?>"<?php echo $cases2->ClientStatusID->editAttributes() ?>>
<?php echo $cases2->ClientStatusID->Lookup->getParamTag("p_x_ClientStatusID") ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_ClientStatusID">
		<td class="<?php echo $cases2_search->TableLeftColumnClass ?>"><span id="elh_cases2_ClientStatusID"><?php echo $cases2->ClientStatusID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ClientStatusID" id="z_ClientStatusID" value="="></span></td>
		<td<?php echo $cases2->ClientStatusID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases2_ClientStatusID">
<input type="text" data-table="cases2" data-field="x_ClientStatusID" name="x_ClientStatusID" id="x_ClientStatusID" size="30" placeholder="<?php echo HtmlEncode($cases2->ClientStatusID->getPlaceHolder()) ?>" value="<?php echo $cases2->ClientStatusID->EditValue ?>"<?php echo $cases2->ClientStatusID->editAttributes() ?>>
<?php echo $cases2->ClientStatusID->Lookup->getParamTag("p_x_ClientStatusID") ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->LitigantStatusID->Visible) { // LitigantStatusID ?>
<?php if ($cases2_search->IsMobileOrModal) { ?>
	<div id="r_LitigantStatusID" class="form-group row">
		<label for="x_LitigantStatusID" class="<?php echo $cases2_search->LeftColumnClass ?>"><span id="elh_cases2_LitigantStatusID"><?php echo $cases2->LitigantStatusID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_LitigantStatusID" id="z_LitigantStatusID" value="="></span>
		</label>
		<div class="<?php echo $cases2_search->RightColumnClass ?>"><div<?php echo $cases2->LitigantStatusID->cellAttributes() ?>>
			<span id="el_cases2_LitigantStatusID">
<input type="text" data-table="cases2" data-field="x_LitigantStatusID" name="x_LitigantStatusID" id="x_LitigantStatusID" size="30" placeholder="<?php echo HtmlEncode($cases2->LitigantStatusID->getPlaceHolder()) ?>" value="<?php echo $cases2->LitigantStatusID->EditValue ?>"<?php echo $cases2->LitigantStatusID->editAttributes() ?>>
<?php echo $cases2->LitigantStatusID->Lookup->getParamTag("p_x_LitigantStatusID") ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_LitigantStatusID">
		<td class="<?php echo $cases2_search->TableLeftColumnClass ?>"><span id="elh_cases2_LitigantStatusID"><?php echo $cases2->LitigantStatusID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_LitigantStatusID" id="z_LitigantStatusID" value="="></span></td>
		<td<?php echo $cases2->LitigantStatusID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases2_LitigantStatusID">
<input type="text" data-table="cases2" data-field="x_LitigantStatusID" name="x_LitigantStatusID" id="x_LitigantStatusID" size="30" placeholder="<?php echo HtmlEncode($cases2->LitigantStatusID->getPlaceHolder()) ?>" value="<?php echo $cases2->LitigantStatusID->EditValue ?>"<?php echo $cases2->LitigantStatusID->editAttributes() ?>>
<?php echo $cases2->LitigantStatusID->Lookup->getParamTag("p_x_LitigantStatusID") ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->CaseSortID->Visible) { // CaseSortID ?>
<?php if ($cases2_search->IsMobileOrModal) { ?>
	<div id="r_CaseSortID" class="form-group row">
		<label for="x_CaseSortID" class="<?php echo $cases2_search->LeftColumnClass ?>"><span id="elh_cases2_CaseSortID"><?php echo $cases2->CaseSortID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CaseSortID" id="z_CaseSortID" value="="></span>
		</label>
		<div class="<?php echo $cases2_search->RightColumnClass ?>"><div<?php echo $cases2->CaseSortID->cellAttributes() ?>>
			<span id="el_cases2_CaseSortID">
<input type="text" data-table="cases2" data-field="x_CaseSortID" name="x_CaseSortID" id="x_CaseSortID" size="30" placeholder="<?php echo HtmlEncode($cases2->CaseSortID->getPlaceHolder()) ?>" value="<?php echo $cases2->CaseSortID->EditValue ?>"<?php echo $cases2->CaseSortID->editAttributes() ?>>
<?php echo $cases2->CaseSortID->Lookup->getParamTag("p_x_CaseSortID") ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseSortID">
		<td class="<?php echo $cases2_search->TableLeftColumnClass ?>"><span id="elh_cases2_CaseSortID"><?php echo $cases2->CaseSortID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CaseSortID" id="z_CaseSortID" value="="></span></td>
		<td<?php echo $cases2->CaseSortID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases2_CaseSortID">
<input type="text" data-table="cases2" data-field="x_CaseSortID" name="x_CaseSortID" id="x_CaseSortID" size="30" placeholder="<?php echo HtmlEncode($cases2->CaseSortID->getPlaceHolder()) ?>" value="<?php echo $cases2->CaseSortID->EditValue ?>"<?php echo $cases2->CaseSortID->editAttributes() ?>>
<?php echo $cases2->CaseSortID->Lookup->getParamTag("p_x_CaseSortID") ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->CaseStatusID->Visible) { // CaseStatusID ?>
<?php if ($cases2_search->IsMobileOrModal) { ?>
	<div id="r_CaseStatusID" class="form-group row">
		<label for="x_CaseStatusID" class="<?php echo $cases2_search->LeftColumnClass ?>"><span id="elh_cases2_CaseStatusID"><?php echo $cases2->CaseStatusID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CaseStatusID" id="z_CaseStatusID" value="="></span>
		</label>
		<div class="<?php echo $cases2_search->RightColumnClass ?>"><div<?php echo $cases2->CaseStatusID->cellAttributes() ?>>
			<span id="el_cases2_CaseStatusID">
<input type="text" data-table="cases2" data-field="x_CaseStatusID" name="x_CaseStatusID" id="x_CaseStatusID" size="30" placeholder="<?php echo HtmlEncode($cases2->CaseStatusID->getPlaceHolder()) ?>" value="<?php echo $cases2->CaseStatusID->EditValue ?>"<?php echo $cases2->CaseStatusID->editAttributes() ?>>
<?php echo $cases2->CaseStatusID->Lookup->getParamTag("p_x_CaseStatusID") ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseStatusID">
		<td class="<?php echo $cases2_search->TableLeftColumnClass ?>"><span id="elh_cases2_CaseStatusID"><?php echo $cases2->CaseStatusID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CaseStatusID" id="z_CaseStatusID" value="="></span></td>
		<td<?php echo $cases2->CaseStatusID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases2_CaseStatusID">
<input type="text" data-table="cases2" data-field="x_CaseStatusID" name="x_CaseStatusID" id="x_CaseStatusID" size="30" placeholder="<?php echo HtmlEncode($cases2->CaseStatusID->getPlaceHolder()) ?>" value="<?php echo $cases2->CaseStatusID->EditValue ?>"<?php echo $cases2->CaseStatusID->editAttributes() ?>>
<?php echo $cases2->CaseStatusID->Lookup->getParamTag("p_x_CaseStatusID") ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->CaseRegisteredDate->Visible) { // CaseRegisteredDate ?>
<?php if ($cases2_search->IsMobileOrModal) { ?>
	<div id="r_CaseRegisteredDate" class="form-group row">
		<label for="x_CaseRegisteredDate" class="<?php echo $cases2_search->LeftColumnClass ?>"><span id="elh_cases2_CaseRegisteredDate"><?php echo $cases2->CaseRegisteredDate->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CaseRegisteredDate" id="z_CaseRegisteredDate" value="="></span>
		</label>
		<div class="<?php echo $cases2_search->RightColumnClass ?>"><div<?php echo $cases2->CaseRegisteredDate->cellAttributes() ?>>
			<span id="el_cases2_CaseRegisteredDate">
<input type="text" data-table="cases2" data-field="x_CaseRegisteredDate" data-format="7" name="x_CaseRegisteredDate" id="x_CaseRegisteredDate" placeholder="<?php echo HtmlEncode($cases2->CaseRegisteredDate->getPlaceHolder()) ?>" value="<?php echo $cases2->CaseRegisteredDate->EditValue ?>"<?php echo $cases2->CaseRegisteredDate->editAttributes() ?>>
<?php if (!$cases2->CaseRegisteredDate->ReadOnly && !$cases2->CaseRegisteredDate->Disabled && !isset($cases2->CaseRegisteredDate->EditAttrs["readonly"]) && !isset($cases2->CaseRegisteredDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fcases2search", "x_CaseRegisteredDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_CaseRegisteredDate">
		<td class="<?php echo $cases2_search->TableLeftColumnClass ?>"><span id="elh_cases2_CaseRegisteredDate"><?php echo $cases2->CaseRegisteredDate->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_CaseRegisteredDate" id="z_CaseRegisteredDate" value="="></span></td>
		<td<?php echo $cases2->CaseRegisteredDate->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases2_CaseRegisteredDate">
<input type="text" data-table="cases2" data-field="x_CaseRegisteredDate" data-format="7" name="x_CaseRegisteredDate" id="x_CaseRegisteredDate" placeholder="<?php echo HtmlEncode($cases2->CaseRegisteredDate->getPlaceHolder()) ?>" value="<?php echo $cases2->CaseRegisteredDate->EditValue ?>"<?php echo $cases2->CaseRegisteredDate->editAttributes() ?>>
<?php if (!$cases2->CaseRegisteredDate->ReadOnly && !$cases2->CaseRegisteredDate->Disabled && !isset($cases2->CaseRegisteredDate->EditAttrs["readonly"]) && !isset($cases2->CaseRegisteredDate->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fcases2search", "x_CaseRegisteredDate", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->_Case->Visible) { // Case ?>
<?php if ($cases2_search->IsMobileOrModal) { ?>
	<div id="r__Case" class="form-group row">
		<label for="x__Case" class="<?php echo $cases2_search->LeftColumnClass ?>"><span id="elh_cases2__Case"><?php echo $cases2->_Case->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__Case" id="z__Case" value="LIKE"></span>
		</label>
		<div class="<?php echo $cases2_search->RightColumnClass ?>"><div<?php echo $cases2->_Case->cellAttributes() ?>>
			<span id="el_cases2__Case">
<input type="text" data-table="cases2" data-field="x__Case" name="x__Case" id="x__Case" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($cases2->_Case->getPlaceHolder()) ?>" value="<?php echo $cases2->_Case->EditValue ?>"<?php echo $cases2->_Case->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r__Case">
		<td class="<?php echo $cases2_search->TableLeftColumnClass ?>"><span id="elh_cases2__Case"><?php echo $cases2->_Case->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__Case" id="z__Case" value="LIKE"></span></td>
		<td<?php echo $cases2->_Case->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases2__Case">
<input type="text" data-table="cases2" data-field="x__Case" name="x__Case" id="x__Case" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($cases2->_Case->getPlaceHolder()) ?>" value="<?php echo $cases2->_Case->EditValue ?>"<?php echo $cases2->_Case->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->Notes->Visible) { // Notes ?>
<?php if ($cases2_search->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label class="<?php echo $cases2_search->LeftColumnClass ?>"><span id="elh_cases2_Notes"><?php echo $cases2->Notes->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Notes" id="z_Notes" value="LIKE"></span>
		</label>
		<div class="<?php echo $cases2_search->RightColumnClass ?>"><div<?php echo $cases2->Notes->cellAttributes() ?>>
			<span id="el_cases2_Notes">
<input type="text" data-table="cases2" data-field="x_Notes" name="x_Notes" id="x_Notes" size="35" placeholder="<?php echo HtmlEncode($cases2->Notes->getPlaceHolder()) ?>" value="<?php echo $cases2->Notes->EditValue ?>"<?php echo $cases2->Notes->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $cases2_search->TableLeftColumnClass ?>"><span id="elh_cases2_Notes"><?php echo $cases2->Notes->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Notes" id="z_Notes" value="LIKE"></span></td>
		<td<?php echo $cases2->Notes->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases2_Notes">
<input type="text" data-table="cases2" data-field="x_Notes" name="x_Notes" id="x_Notes" size="35" placeholder="<?php echo HtmlEncode($cases2->Notes->getPlaceHolder()) ?>" value="<?php echo $cases2->Notes->EditValue ?>"<?php echo $cases2->Notes->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2->FileLocation->Visible) { // FileLocation ?>
<?php if ($cases2_search->IsMobileOrModal) { ?>
	<div id="r_FileLocation" class="form-group row">
		<label for="x_FileLocation" class="<?php echo $cases2_search->LeftColumnClass ?>"><span id="elh_cases2_FileLocation"><?php echo $cases2->FileLocation->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_FileLocation" id="z_FileLocation" value="LIKE"></span>
		</label>
		<div class="<?php echo $cases2_search->RightColumnClass ?>"><div<?php echo $cases2->FileLocation->cellAttributes() ?>>
			<span id="el_cases2_FileLocation">
<input type="text" data-table="cases2" data-field="x_FileLocation" name="x_FileLocation" id="x_FileLocation" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($cases2->FileLocation->getPlaceHolder()) ?>" value="<?php echo $cases2->FileLocation->EditValue ?>"<?php echo $cases2->FileLocation->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_FileLocation">
		<td class="<?php echo $cases2_search->TableLeftColumnClass ?>"><span id="elh_cases2_FileLocation"><?php echo $cases2->FileLocation->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_FileLocation" id="z_FileLocation" value="LIKE"></span></td>
		<td<?php echo $cases2->FileLocation->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_cases2_FileLocation">
<input type="text" data-table="cases2" data-field="x_FileLocation" name="x_FileLocation" id="x_FileLocation" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($cases2->FileLocation->getPlaceHolder()) ?>" value="<?php echo $cases2->FileLocation->EditValue ?>"<?php echo $cases2->FileLocation->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($cases2_search->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if (!$cases2_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $cases2_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$cases2_search->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
</form>
<?php
$cases2_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$cases2_search->terminate();
?>
