<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$casesort_addopt = new casesort_addopt();

// Run the page
$casesort_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$casesort_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fcasesortaddopt = currentForm = new ew.Form("fcasesortaddopt", "addopt");

// Validate form
fcasesortaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($casesort_addopt->CaseSort->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseSort");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $casesort->CaseSort->caption(), $casesort->CaseSort->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($casesort_addopt->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $casesort->Notes->caption(), $casesort->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fcasesortaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcasesortaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $casesort_addopt->showPageHeader(); ?>
<?php
$casesort_addopt->showMessage();
?>
<form name="fcasesortaddopt" id="fcasesortaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($casesort_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $casesort_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $casesort_addopt->TableVar ?>">
<?php if ($casesort->CaseSort->Visible) { // CaseSort ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_CaseSort"><?php echo $casesort->CaseSort->caption() ?><?php echo ($casesort->CaseSort->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="casesort" data-field="x_CaseSort" name="x_CaseSort" id="x_CaseSort" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($casesort->CaseSort->getPlaceHolder()) ?>" value="<?php echo $casesort->CaseSort->EditValue ?>"<?php echo $casesort->CaseSort->editAttributes() ?>>
</div>
	</div>
<?php } ?>
<?php if ($casesort->Notes->Visible) { // Notes ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_Notes"><?php echo $casesort->Notes->caption() ?><?php echo ($casesort->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="casesort" data-field="x_Notes" name="x_Notes" id="x_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($casesort->Notes->getPlaceHolder()) ?>" value="<?php echo $casesort->Notes->EditValue ?>"<?php echo $casesort->Notes->editAttributes() ?>>
</div>
	</div>
<?php } ?>
</form>
<?php
$casesort_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$casesort_addopt->terminate();
?>
