<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$casetypes_addopt = new casetypes_addopt();

// Run the page
$casetypes_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$casetypes_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fcasetypesaddopt = currentForm = new ew.Form("fcasetypesaddopt", "addopt");

// Validate form
fcasetypesaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($casetypes_addopt->CaseType->Required) { ?>
			elm = this.getElements("x" + infix + "_CaseType");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $casetypes->CaseType->caption(), $casetypes->CaseType->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($casetypes_addopt->Notes->Required) { ?>
			elm = this.getElements("x" + infix + "_Notes");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $casetypes->Notes->caption(), $casetypes->Notes->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fcasetypesaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcasetypesaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $casetypes_addopt->showPageHeader(); ?>
<?php
$casetypes_addopt->showMessage();
?>
<form name="fcasetypesaddopt" id="fcasetypesaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($casetypes_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $casetypes_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $casetypes_addopt->TableVar ?>">
<?php if ($casetypes->CaseType->Visible) { // CaseType ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_CaseType"><?php echo $casetypes->CaseType->caption() ?><?php echo ($casetypes->CaseType->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="casetypes" data-field="x_CaseType" name="x_CaseType" id="x_CaseType" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($casetypes->CaseType->getPlaceHolder()) ?>" value="<?php echo $casetypes->CaseType->EditValue ?>"<?php echo $casetypes->CaseType->editAttributes() ?>>
</div>
	</div>
<?php } ?>
<?php if ($casetypes->Notes->Visible) { // Notes ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_Notes"><?php echo $casetypes->Notes->caption() ?><?php echo ($casetypes->Notes->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="casetypes" data-field="x_Notes" name="x_Notes" id="x_Notes" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($casetypes->Notes->getPlaceHolder()) ?>" value="<?php echo $casetypes->Notes->EditValue ?>"<?php echo $casetypes->Notes->editAttributes() ?>>
</div>
	</div>
<?php } ?>
</form>
<?php
$casetypes_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$casetypes_addopt->terminate();
?>
