<?php
namespace PHPMaker2019\project_germanos;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$chambers_search = new chambers_search();

// Run the page
$chambers_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$chambers_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($chambers_search->IsModal) { ?>
var fchamberssearch = currentAdvancedSearchForm = new ew.Form("fchamberssearch", "search");
<?php } else { ?>
var fchamberssearch = currentForm = new ew.Form("fchamberssearch", "search");
<?php } ?>

// Form_CustomValidate event
fchamberssearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fchamberssearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search
// Validate function for search

fchamberssearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_ChamberID");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($chambers->ChamberID->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $chambers_search->showPageHeader(); ?>
<?php
$chambers_search->showMessage();
?>
<form name="fchamberssearch" id="fchamberssearch" class="<?php echo $chambers_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($chambers_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $chambers_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="chambers">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$chambers_search->IsModal ?>">
<?php if (!$chambers_search->IsMobileOrModal) { ?>
<div class="ew-desktop"><!-- desktop -->
<?php } ?>
<?php if ($chambers_search->IsMobileOrModal) { ?>
<div class="ew-search-div"><!-- page* -->
<?php } else { ?>
<table id="tbl_chamberssearch" class="table table-striped table-sm ew-desktop-table"><!-- table* -->
<?php } ?>
<?php if ($chambers->ChamberID->Visible) { // ChamberID ?>
<?php if ($chambers_search->IsMobileOrModal) { ?>
	<div id="r_ChamberID" class="form-group row">
		<label for="x_ChamberID" class="<?php echo $chambers_search->LeftColumnClass ?>"><span id="elh_chambers_ChamberID"><?php echo $chambers->ChamberID->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ChamberID" id="z_ChamberID" value="="></span>
		</label>
		<div class="<?php echo $chambers_search->RightColumnClass ?>"><div<?php echo $chambers->ChamberID->cellAttributes() ?>>
			<span id="el_chambers_ChamberID">
<input type="text" data-table="chambers" data-field="x_ChamberID" name="x_ChamberID" id="x_ChamberID" placeholder="<?php echo HtmlEncode($chambers->ChamberID->getPlaceHolder()) ?>" value="<?php echo $chambers->ChamberID->EditValue ?>"<?php echo $chambers->ChamberID->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_ChamberID">
		<td class="<?php echo $chambers_search->TableLeftColumnClass ?>"><span id="elh_chambers_ChamberID"><?php echo $chambers->ChamberID->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ChamberID" id="z_ChamberID" value="="></span></td>
		<td<?php echo $chambers->ChamberID->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_chambers_ChamberID">
<input type="text" data-table="chambers" data-field="x_ChamberID" name="x_ChamberID" id="x_ChamberID" placeholder="<?php echo HtmlEncode($chambers->ChamberID->getPlaceHolder()) ?>" value="<?php echo $chambers->ChamberID->EditValue ?>"<?php echo $chambers->ChamberID->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($chambers->Chamber->Visible) { // Chamber ?>
<?php if ($chambers_search->IsMobileOrModal) { ?>
	<div id="r_Chamber" class="form-group row">
		<label for="x_Chamber" class="<?php echo $chambers_search->LeftColumnClass ?>"><span id="elh_chambers_Chamber"><?php echo $chambers->Chamber->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Chamber" id="z_Chamber" value="LIKE"></span>
		</label>
		<div class="<?php echo $chambers_search->RightColumnClass ?>"><div<?php echo $chambers->Chamber->cellAttributes() ?>>
			<span id="el_chambers_Chamber">
<input type="text" data-table="chambers" data-field="x_Chamber" name="x_Chamber" id="x_Chamber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($chambers->Chamber->getPlaceHolder()) ?>" value="<?php echo $chambers->Chamber->EditValue ?>"<?php echo $chambers->Chamber->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_Chamber">
		<td class="<?php echo $chambers_search->TableLeftColumnClass ?>"><span id="elh_chambers_Chamber"><?php echo $chambers->Chamber->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Chamber" id="z_Chamber" value="LIKE"></span></td>
		<td<?php echo $chambers->Chamber->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_chambers_Chamber">
<input type="text" data-table="chambers" data-field="x_Chamber" name="x_Chamber" id="x_Chamber" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($chambers->Chamber->getPlaceHolder()) ?>" value="<?php echo $chambers->Chamber->EditValue ?>"<?php echo $chambers->Chamber->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($chambers->Notes->Visible) { // Notes ?>
<?php if ($chambers_search->IsMobileOrModal) { ?>
	<div id="r_Notes" class="form-group row">
		<label for="x_Notes" class="<?php echo $chambers_search->LeftColumnClass ?>"><span id="elh_chambers_Notes"><?php echo $chambers->Notes->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Notes" id="z_Notes" value="LIKE"></span>
		</label>
		<div class="<?php echo $chambers_search->RightColumnClass ?>"><div<?php echo $chambers->Notes->cellAttributes() ?>>
			<span id="el_chambers_Notes">
<input type="text" data-table="chambers" data-field="x_Notes" name="x_Notes" id="x_Notes" size="35" placeholder="<?php echo HtmlEncode($chambers->Notes->getPlaceHolder()) ?>" value="<?php echo $chambers->Notes->EditValue ?>"<?php echo $chambers->Notes->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } else { ?>
	<tr id="r_Notes">
		<td class="<?php echo $chambers_search->TableLeftColumnClass ?>"><span id="elh_chambers_Notes"><?php echo $chambers->Notes->caption() ?></span></td>
		<td class="w-col-1"><span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Notes" id="z_Notes" value="LIKE"></span></td>
		<td<?php echo $chambers->Notes->cellAttributes() ?>>
			<div class="text-nowrap">
				<span id="el_chambers_Notes">
<input type="text" data-table="chambers" data-field="x_Notes" name="x_Notes" id="x_Notes" size="35" placeholder="<?php echo HtmlEncode($chambers->Notes->getPlaceHolder()) ?>" value="<?php echo $chambers->Notes->EditValue ?>"<?php echo $chambers->Notes->editAttributes() ?>>
</span>
			</div>
		</td>
	</tr>
<?php } ?>
<?php } ?>
<?php if ($chambers_search->IsMobileOrModal) { ?>
</div><!-- /page* -->
<?php } else { ?>
</table><!-- /table* -->
<?php } ?>
<?php if (!$chambers_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $chambers_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
<?php if (!$chambers_search->IsMobileOrModal) { ?>
</div><!-- /desktop -->
<?php } ?>
</form>
<?php
$chambers_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$chambers_search->terminate();
?>
