<?php
namespace PHPMaker2019\project_germanos;

/**
 * Page class
 */
class cases2_edit extends cases2
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{8D47CED4-FEF0-4756-8F48-9FC38A15AA2A}";

	// Table name
	public $TableName = 'cases2';

	// Page object name
	public $PageObjName = "cases2_edit";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (cases2)
		if (!isset($GLOBALS["cases2"]) || get_class($GLOBALS["cases2"]) == PROJECT_NAMESPACE . "cases2") {
			$GLOBALS["cases2"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["cases2"];
		}

		// Table object (employees)
		if (!isset($GLOBALS['employees']))
			$GLOBALS['employees'] = new employees();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'cases2');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new employees();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $cases2;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($cases2);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "cases2view.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['CaseID'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->CaseID->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $DisplayRecs = 1;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $RecCnt;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (IsPasswordExpired())
				$this->terminate(GetUrl("changepwd.php"));
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("cases2list.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Update last accessed time
		if ($UserProfile->isValidUser(CurrentUserName(), session_id())) {
		} else {
			Write($Language->phrase("UserProfileCorrupted"));
			$this->terminate();
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->CaseID->setVisibility();
		$this->ClientID->setVisibility();
		$this->LitigantID->setVisibility();
		$this->CaseTypeID->setVisibility();
		$this->CourtID->setVisibility();
		$this->CaseNumber->setVisibility();
		$this->FileNumber->setVisibility();
		$this->EnvelopeNumber->Visible = FALSE;
		$this->ClientStatusID->setVisibility();
		$this->LitigantStatusID->setVisibility();
		$this->CaseSortID->setVisibility();
		$this->CaseStatusID->setVisibility();
		$this->ParentCaseID->setVisibility();
		$this->CaseRegisteredDate->setVisibility();
		$this->_Case->setVisibility();
		$this->CaseEn->Visible = FALSE;
		$this->CourtTypeID->setVisibility();
		$this->CourtGenderID->Visible = FALSE;
		$this->JudgeID->Visible = FALSE;
		$this->Notes->setVisibility();
		$this->FileLocation->setVisibility();
		$this->_UserID->Visible = FALSE;
		$this->CreatedBy->Visible = FALSE;
		$this->CreatedDate->Visible = FALSE;
		$this->UpdatedBy->Visible = FALSE;
		$this->UpdatedDate->Visible = FALSE;
		$this->ClientStatusConv->Visible = FALSE;
		$this->LitigantStatusConv->Visible = FALSE;
		$this->CaseTypeConv->Visible = FALSE;
		$this->CaseConv->Visible = FALSE;
		$this->ClientNameConv->Visible = FALSE;
		$this->LitigantNameConv->Visible = FALSE;
		$this->ClientNameConvFiles->Visible = FALSE;
		$this->LitigantNameConvFiles->Visible = FALSE;
		$this->CaseTypeConvFiles->Visible = FALSE;
		$this->CourtConvFiles->Visible = FALSE;
		$this->FileNumberConvFiles->Visible = FALSE;
		$this->CaseNumberConvFiles->Visible = FALSE;
		$this->NotesConvFiles->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->ClientID);
		$this->setupLookupOptions($this->LitigantID);
		$this->setupLookupOptions($this->CaseTypeID);
		$this->setupLookupOptions($this->CourtID);
		$this->setupLookupOptions($this->ClientStatusID);
		$this->setupLookupOptions($this->LitigantStatusID);
		$this->setupLookupOptions($this->CaseSortID);
		$this->setupLookupOptions($this->CaseStatusID);
		$this->setupLookupOptions($this->CourtTypeID);
		$this->setupLookupOptions($this->CourtGenderID);
		$this->setupLookupOptions($this->JudgeID);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";

		// Load record by position
		$loadByPosition = FALSE;
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_CaseID")) {
				$this->CaseID->setFormValue($CurrentForm->getValue("x_CaseID"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("CaseID") !== NULL) {
				$this->CaseID->setQueryStringValue(Get("CaseID"));
				$loadByQuery = TRUE;
			} else {
				$this->CaseID->CurrentValue = NULL;
			}
			if (!$loadByQuery)
				$loadByPosition = TRUE;
		}

		// Load recordset
		$this->StartRec = 1; // Initialize start position
		if ($rs = $this->loadRecordset()) // Load records
			$this->TotalRecs = $rs->RecordCount(); // Get record count
		if ($this->TotalRecs <= 0) { // No record found
			if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$this->terminate("cases2list.php"); // Return to list page
		} elseif ($loadByPosition) { // Load record by position
			$this->setupStartRec(); // Set up start record position

			// Point to current record
			if ($this->StartRec <= $this->TotalRecs) {
				$rs->move($this->StartRec - 1);
				$loaded = TRUE;
			}
		} else { // Match key values
			if ($this->CaseID->CurrentValue != NULL) {
				while (!$rs->EOF) {
					if (SameString($this->CaseID->CurrentValue, $rs->fields('CaseID'))) {
						$this->setStartRecordNumber($this->StartRec); // Save record position
						$loaded = TRUE;
						break;
					} else {
						$this->StartRec++;
						$rs->moveNext();
					}
				}
			}
		}

		// Load current row values
		if ($loaded)
			$this->loadRowValues($rs);

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) {
					if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
					$this->terminate("cases2list.php"); // Return to list page
				} else {
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "cases2list.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'CaseID' first before field var 'x_CaseID'
		$val = $CurrentForm->hasValue("CaseID") ? $CurrentForm->getValue("CaseID") : $CurrentForm->getValue("x_CaseID");
		if (!$this->CaseID->IsDetailKey)
			$this->CaseID->setFormValue($val);

		// Check field name 'ClientID' first before field var 'x_ClientID'
		$val = $CurrentForm->hasValue("ClientID") ? $CurrentForm->getValue("ClientID") : $CurrentForm->getValue("x_ClientID");
		if (!$this->ClientID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ClientID->Visible = FALSE; // Disable update for API request
			else
				$this->ClientID->setFormValue($val);
		}

		// Check field name 'LitigantID' first before field var 'x_LitigantID'
		$val = $CurrentForm->hasValue("LitigantID") ? $CurrentForm->getValue("LitigantID") : $CurrentForm->getValue("x_LitigantID");
		if (!$this->LitigantID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->LitigantID->Visible = FALSE; // Disable update for API request
			else
				$this->LitigantID->setFormValue($val);
		}

		// Check field name 'CaseTypeID' first before field var 'x_CaseTypeID'
		$val = $CurrentForm->hasValue("CaseTypeID") ? $CurrentForm->getValue("CaseTypeID") : $CurrentForm->getValue("x_CaseTypeID");
		if (!$this->CaseTypeID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CaseTypeID->Visible = FALSE; // Disable update for API request
			else
				$this->CaseTypeID->setFormValue($val);
		}

		// Check field name 'CourtID' first before field var 'x_CourtID'
		$val = $CurrentForm->hasValue("CourtID") ? $CurrentForm->getValue("CourtID") : $CurrentForm->getValue("x_CourtID");
		if (!$this->CourtID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CourtID->Visible = FALSE; // Disable update for API request
			else
				$this->CourtID->setFormValue($val);
		}

		// Check field name 'CaseNumber' first before field var 'x_CaseNumber'
		$val = $CurrentForm->hasValue("CaseNumber") ? $CurrentForm->getValue("CaseNumber") : $CurrentForm->getValue("x_CaseNumber");
		if (!$this->CaseNumber->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CaseNumber->Visible = FALSE; // Disable update for API request
			else
				$this->CaseNumber->setFormValue($val);
		}

		// Check field name 'FileNumber' first before field var 'x_FileNumber'
		$val = $CurrentForm->hasValue("FileNumber") ? $CurrentForm->getValue("FileNumber") : $CurrentForm->getValue("x_FileNumber");
		if (!$this->FileNumber->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->FileNumber->Visible = FALSE; // Disable update for API request
			else
				$this->FileNumber->setFormValue($val);
		}

		// Check field name 'ClientStatusID' first before field var 'x_ClientStatusID'
		$val = $CurrentForm->hasValue("ClientStatusID") ? $CurrentForm->getValue("ClientStatusID") : $CurrentForm->getValue("x_ClientStatusID");
		if (!$this->ClientStatusID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ClientStatusID->Visible = FALSE; // Disable update for API request
			else
				$this->ClientStatusID->setFormValue($val);
		}

		// Check field name 'LitigantStatusID' first before field var 'x_LitigantStatusID'
		$val = $CurrentForm->hasValue("LitigantStatusID") ? $CurrentForm->getValue("LitigantStatusID") : $CurrentForm->getValue("x_LitigantStatusID");
		if (!$this->LitigantStatusID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->LitigantStatusID->Visible = FALSE; // Disable update for API request
			else
				$this->LitigantStatusID->setFormValue($val);
		}

		// Check field name 'CaseSortID' first before field var 'x_CaseSortID'
		$val = $CurrentForm->hasValue("CaseSortID") ? $CurrentForm->getValue("CaseSortID") : $CurrentForm->getValue("x_CaseSortID");
		if (!$this->CaseSortID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CaseSortID->Visible = FALSE; // Disable update for API request
			else
				$this->CaseSortID->setFormValue($val);
		}

		// Check field name 'CaseStatusID' first before field var 'x_CaseStatusID'
		$val = $CurrentForm->hasValue("CaseStatusID") ? $CurrentForm->getValue("CaseStatusID") : $CurrentForm->getValue("x_CaseStatusID");
		if (!$this->CaseStatusID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CaseStatusID->Visible = FALSE; // Disable update for API request
			else
				$this->CaseStatusID->setFormValue($val);
		}

		// Check field name 'ParentCaseID' first before field var 'x_ParentCaseID'
		$val = $CurrentForm->hasValue("ParentCaseID") ? $CurrentForm->getValue("ParentCaseID") : $CurrentForm->getValue("x_ParentCaseID");
		if (!$this->ParentCaseID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ParentCaseID->Visible = FALSE; // Disable update for API request
			else
				$this->ParentCaseID->setFormValue($val);
		}

		// Check field name 'CaseRegisteredDate' first before field var 'x_CaseRegisteredDate'
		$val = $CurrentForm->hasValue("CaseRegisteredDate") ? $CurrentForm->getValue("CaseRegisteredDate") : $CurrentForm->getValue("x_CaseRegisteredDate");
		if (!$this->CaseRegisteredDate->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CaseRegisteredDate->Visible = FALSE; // Disable update for API request
			else
				$this->CaseRegisteredDate->setFormValue($val);
			$this->CaseRegisteredDate->CurrentValue = UnFormatDateTime($this->CaseRegisteredDate->CurrentValue, 7);
		}

		// Check field name 'Case' first before field var 'x__Case'
		$val = $CurrentForm->hasValue("Case") ? $CurrentForm->getValue("Case") : $CurrentForm->getValue("x__Case");
		if (!$this->_Case->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_Case->Visible = FALSE; // Disable update for API request
			else
				$this->_Case->setFormValue($val);
		}

		// Check field name 'CourtTypeID' first before field var 'x_CourtTypeID'
		$val = $CurrentForm->hasValue("CourtTypeID") ? $CurrentForm->getValue("CourtTypeID") : $CurrentForm->getValue("x_CourtTypeID");
		if (!$this->CourtTypeID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CourtTypeID->Visible = FALSE; // Disable update for API request
			else
				$this->CourtTypeID->setFormValue($val);
		}

		// Check field name 'Notes' first before field var 'x_Notes'
		$val = $CurrentForm->hasValue("Notes") ? $CurrentForm->getValue("Notes") : $CurrentForm->getValue("x_Notes");
		if (!$this->Notes->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Notes->Visible = FALSE; // Disable update for API request
			else
				$this->Notes->setFormValue($val);
		}

		// Check field name 'FileLocation' first before field var 'x_FileLocation'
		$val = $CurrentForm->hasValue("FileLocation") ? $CurrentForm->getValue("FileLocation") : $CurrentForm->getValue("x_FileLocation");
		if (!$this->FileLocation->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->FileLocation->Visible = FALSE; // Disable update for API request
			else
				$this->FileLocation->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->CaseID->CurrentValue = $this->CaseID->FormValue;
		$this->ClientID->CurrentValue = $this->ClientID->FormValue;
		$this->LitigantID->CurrentValue = $this->LitigantID->FormValue;
		$this->CaseTypeID->CurrentValue = $this->CaseTypeID->FormValue;
		$this->CourtID->CurrentValue = $this->CourtID->FormValue;
		$this->CaseNumber->CurrentValue = $this->CaseNumber->FormValue;
		$this->FileNumber->CurrentValue = $this->FileNumber->FormValue;
		$this->ClientStatusID->CurrentValue = $this->ClientStatusID->FormValue;
		$this->LitigantStatusID->CurrentValue = $this->LitigantStatusID->FormValue;
		$this->CaseSortID->CurrentValue = $this->CaseSortID->FormValue;
		$this->CaseStatusID->CurrentValue = $this->CaseStatusID->FormValue;
		$this->ParentCaseID->CurrentValue = $this->ParentCaseID->FormValue;
		$this->CaseRegisteredDate->CurrentValue = $this->CaseRegisteredDate->FormValue;
		$this->CaseRegisteredDate->CurrentValue = UnFormatDateTime($this->CaseRegisteredDate->CurrentValue, 7);
		$this->_Case->CurrentValue = $this->_Case->FormValue;
		$this->CourtTypeID->CurrentValue = $this->CourtTypeID->FormValue;
		$this->Notes->CurrentValue = $this->Notes->FormValue;
		$this->FileLocation->CurrentValue = $this->FileLocation->FormValue;
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->CaseID->setDbValue($row['CaseID']);
		$this->ClientID->setDbValue($row['ClientID']);
		if (array_key_exists('EV__ClientID', $rs->fields)) {
			$this->ClientID->VirtualValue = $rs->fields('EV__ClientID'); // Set up virtual field value
		} else {
			$this->ClientID->VirtualValue = ""; // Clear value
		}
		$this->LitigantID->setDbValue($row['LitigantID']);
		if (array_key_exists('EV__LitigantID', $rs->fields)) {
			$this->LitigantID->VirtualValue = $rs->fields('EV__LitigantID'); // Set up virtual field value
		} else {
			$this->LitigantID->VirtualValue = ""; // Clear value
		}
		$this->CaseTypeID->setDbValue($row['CaseTypeID']);
		if (array_key_exists('EV__CaseTypeID', $rs->fields)) {
			$this->CaseTypeID->VirtualValue = $rs->fields('EV__CaseTypeID'); // Set up virtual field value
		} else {
			$this->CaseTypeID->VirtualValue = ""; // Clear value
		}
		$this->CourtID->setDbValue($row['CourtID']);
		if (array_key_exists('EV__CourtID', $rs->fields)) {
			$this->CourtID->VirtualValue = $rs->fields('EV__CourtID'); // Set up virtual field value
		} else {
			$this->CourtID->VirtualValue = ""; // Clear value
		}
		$this->CaseNumber->setDbValue($row['CaseNumber']);
		$this->FileNumber->setDbValue($row['FileNumber']);
		$this->EnvelopeNumber->setDbValue($row['EnvelopeNumber']);
		$this->ClientStatusID->setDbValue($row['ClientStatusID']);
		if (array_key_exists('EV__ClientStatusID', $rs->fields)) {
			$this->ClientStatusID->VirtualValue = $rs->fields('EV__ClientStatusID'); // Set up virtual field value
		} else {
			$this->ClientStatusID->VirtualValue = ""; // Clear value
		}
		$this->LitigantStatusID->setDbValue($row['LitigantStatusID']);
		if (array_key_exists('EV__LitigantStatusID', $rs->fields)) {
			$this->LitigantStatusID->VirtualValue = $rs->fields('EV__LitigantStatusID'); // Set up virtual field value
		} else {
			$this->LitigantStatusID->VirtualValue = ""; // Clear value
		}
		$this->CaseSortID->setDbValue($row['CaseSortID']);
		if (array_key_exists('EV__CaseSortID', $rs->fields)) {
			$this->CaseSortID->VirtualValue = $rs->fields('EV__CaseSortID'); // Set up virtual field value
		} else {
			$this->CaseSortID->VirtualValue = ""; // Clear value
		}
		$this->CaseStatusID->setDbValue($row['CaseStatusID']);
		if (array_key_exists('EV__CaseStatusID', $rs->fields)) {
			$this->CaseStatusID->VirtualValue = $rs->fields('EV__CaseStatusID'); // Set up virtual field value
		} else {
			$this->CaseStatusID->VirtualValue = ""; // Clear value
		}
		$this->ParentCaseID->setDbValue($row['ParentCaseID']);
		$this->CaseRegisteredDate->setDbValue($row['CaseRegisteredDate']);
		$this->_Case->setDbValue($row['Case']);
		$this->CaseEn->setDbValue($row['CaseEn']);
		$this->CourtTypeID->setDbValue($row['CourtTypeID']);
		if (array_key_exists('EV__CourtTypeID', $rs->fields)) {
			$this->CourtTypeID->VirtualValue = $rs->fields('EV__CourtTypeID'); // Set up virtual field value
		} else {
			$this->CourtTypeID->VirtualValue = ""; // Clear value
		}
		$this->CourtGenderID->setDbValue($row['CourtGenderID']);
		if (array_key_exists('EV__CourtGenderID', $rs->fields)) {
			$this->CourtGenderID->VirtualValue = $rs->fields('EV__CourtGenderID'); // Set up virtual field value
		} else {
			$this->CourtGenderID->VirtualValue = ""; // Clear value
		}
		$this->JudgeID->setDbValue($row['JudgeID']);
		if (array_key_exists('EV__JudgeID', $rs->fields)) {
			$this->JudgeID->VirtualValue = $rs->fields('EV__JudgeID'); // Set up virtual field value
		} else {
			$this->JudgeID->VirtualValue = ""; // Clear value
		}
		$this->Notes->setDbValue($row['Notes']);
		$this->FileLocation->setDbValue($row['FileLocation']);
		$this->_UserID->setDbValue($row['UserID']);
		$this->CreatedBy->setDbValue($row['CreatedBy']);
		$this->CreatedDate->setDbValue($row['CreatedDate']);
		$this->UpdatedBy->setDbValue($row['UpdatedBy']);
		$this->UpdatedDate->setDbValue($row['UpdatedDate']);
		$this->ClientStatusConv->setDbValue($row['ClientStatusConv']);
		$this->LitigantStatusConv->setDbValue($row['LitigantStatusConv']);
		$this->CaseTypeConv->setDbValue($row['CaseTypeConv']);
		$this->CaseConv->setDbValue($row['CaseConv']);
		$this->ClientNameConv->setDbValue($row['ClientNameConv']);
		$this->LitigantNameConv->setDbValue($row['LitigantNameConv']);
		$this->ClientNameConvFiles->setDbValue($row['ClientNameConvFiles']);
		$this->LitigantNameConvFiles->setDbValue($row['LitigantNameConvFiles']);
		$this->CaseTypeConvFiles->setDbValue($row['CaseTypeConvFiles']);
		$this->CourtConvFiles->setDbValue($row['CourtConvFiles']);
		$this->FileNumberConvFiles->setDbValue($row['FileNumberConvFiles']);
		$this->CaseNumberConvFiles->setDbValue($row['CaseNumberConvFiles']);
		$this->NotesConvFiles->setDbValue($row['NotesConvFiles']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['CaseID'] = NULL;
		$row['ClientID'] = NULL;
		$row['LitigantID'] = NULL;
		$row['CaseTypeID'] = NULL;
		$row['CourtID'] = NULL;
		$row['CaseNumber'] = NULL;
		$row['FileNumber'] = NULL;
		$row['EnvelopeNumber'] = NULL;
		$row['ClientStatusID'] = NULL;
		$row['LitigantStatusID'] = NULL;
		$row['CaseSortID'] = NULL;
		$row['CaseStatusID'] = NULL;
		$row['ParentCaseID'] = NULL;
		$row['CaseRegisteredDate'] = NULL;
		$row['Case'] = NULL;
		$row['CaseEn'] = NULL;
		$row['CourtTypeID'] = NULL;
		$row['CourtGenderID'] = NULL;
		$row['JudgeID'] = NULL;
		$row['Notes'] = NULL;
		$row['FileLocation'] = NULL;
		$row['UserID'] = NULL;
		$row['CreatedBy'] = NULL;
		$row['CreatedDate'] = NULL;
		$row['UpdatedBy'] = NULL;
		$row['UpdatedDate'] = NULL;
		$row['ClientStatusConv'] = NULL;
		$row['LitigantStatusConv'] = NULL;
		$row['CaseTypeConv'] = NULL;
		$row['CaseConv'] = NULL;
		$row['ClientNameConv'] = NULL;
		$row['LitigantNameConv'] = NULL;
		$row['ClientNameConvFiles'] = NULL;
		$row['LitigantNameConvFiles'] = NULL;
		$row['CaseTypeConvFiles'] = NULL;
		$row['CourtConvFiles'] = NULL;
		$row['FileNumberConvFiles'] = NULL;
		$row['CaseNumberConvFiles'] = NULL;
		$row['NotesConvFiles'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("CaseID")) <> "")
			$this->CaseID->CurrentValue = $this->getKey("CaseID"); // CaseID
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// CaseID
		// ClientID
		// LitigantID
		// CaseTypeID
		// CourtID
		// CaseNumber
		// FileNumber
		// EnvelopeNumber
		// ClientStatusID
		// LitigantStatusID
		// CaseSortID
		// CaseStatusID
		// ParentCaseID
		// CaseRegisteredDate
		// Case
		// CaseEn
		// CourtTypeID
		// CourtGenderID
		// JudgeID
		// Notes
		// FileLocation
		// UserID
		// CreatedBy
		// CreatedDate
		// UpdatedBy
		// UpdatedDate
		// ClientStatusConv
		// LitigantStatusConv
		// CaseTypeConv
		// CaseConv
		// ClientNameConv
		// LitigantNameConv
		// ClientNameConvFiles
		// LitigantNameConvFiles
		// CaseTypeConvFiles
		// CourtConvFiles
		// FileNumberConvFiles
		// CaseNumberConvFiles
		// NotesConvFiles

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// CaseID
			$this->CaseID->ViewValue = $this->CaseID->CurrentValue;
			$this->CaseID->ViewCustomAttributes = "";

			// ClientID
			if ($this->ClientID->VirtualValue <> "") {
				$this->ClientID->ViewValue = $this->ClientID->VirtualValue;
			} else {
				$this->ClientID->ViewValue = $this->ClientID->CurrentValue;
			$curVal = strval($this->ClientID->CurrentValue);
			if ($curVal <> "") {
				$this->ClientID->ViewValue = $this->ClientID->lookupCacheOption($curVal);
				if ($this->ClientID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`ClientID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ClientID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->ClientID->ViewValue = $this->ClientID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ClientID->ViewValue = $this->ClientID->CurrentValue;
					}
				}
			} else {
				$this->ClientID->ViewValue = NULL;
			}
			}
			$this->ClientID->CssStyle = "font-weight: bold;";
			$this->ClientID->ViewCustomAttributes = "";

			// LitigantID
			if ($this->LitigantID->VirtualValue <> "") {
				$this->LitigantID->ViewValue = $this->LitigantID->VirtualValue;
			} else {
				$this->LitigantID->ViewValue = $this->LitigantID->CurrentValue;
			$curVal = strval($this->LitigantID->CurrentValue);
			if ($curVal <> "") {
				$this->LitigantID->ViewValue = $this->LitigantID->lookupCacheOption($curVal);
				if ($this->LitigantID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`LitigantID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->LitigantID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->LitigantID->ViewValue = $this->LitigantID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->LitigantID->ViewValue = $this->LitigantID->CurrentValue;
					}
				}
			} else {
				$this->LitigantID->ViewValue = NULL;
			}
			}
			$this->LitigantID->CssStyle = "font-weight: bold;";
			$this->LitigantID->ViewCustomAttributes = "";

			// CaseTypeID
			if ($this->CaseTypeID->VirtualValue <> "") {
				$this->CaseTypeID->ViewValue = $this->CaseTypeID->VirtualValue;
			} else {
			$curVal = strval($this->CaseTypeID->CurrentValue);
			if ($curVal <> "") {
				$this->CaseTypeID->ViewValue = $this->CaseTypeID->lookupCacheOption($curVal);
				if ($this->CaseTypeID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CaseTypeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CaseTypeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CaseTypeID->ViewValue = $this->CaseTypeID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CaseTypeID->ViewValue = $this->CaseTypeID->CurrentValue;
					}
				}
			} else {
				$this->CaseTypeID->ViewValue = NULL;
			}
			}
			$this->CaseTypeID->CssStyle = "font-style: italic;";
			$this->CaseTypeID->ViewCustomAttributes = "";

			// CourtID
			if ($this->CourtID->VirtualValue <> "") {
				$this->CourtID->ViewValue = $this->CourtID->VirtualValue;
			} else {
				$this->CourtID->ViewValue = $this->CourtID->CurrentValue;
			$curVal = strval($this->CourtID->CurrentValue);
			if ($curVal <> "") {
				$this->CourtID->ViewValue = $this->CourtID->lookupCacheOption($curVal);
				if ($this->CourtID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CourtID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CourtID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CourtID->ViewValue = $this->CourtID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CourtID->ViewValue = $this->CourtID->CurrentValue;
					}
				}
			} else {
				$this->CourtID->ViewValue = NULL;
			}
			}
			$this->CourtID->ViewCustomAttributes = "";

			// CaseNumber
			$this->CaseNumber->ViewValue = $this->CaseNumber->CurrentValue;
			$this->CaseNumber->ViewCustomAttributes = "";

			// FileNumber
			$this->FileNumber->ViewValue = $this->FileNumber->CurrentValue;
			$this->FileNumber->ViewCustomAttributes = "";

			// ClientStatusID
			if ($this->ClientStatusID->VirtualValue <> "") {
				$this->ClientStatusID->ViewValue = $this->ClientStatusID->VirtualValue;
			} else {
			$curVal = strval($this->ClientStatusID->CurrentValue);
			if ($curVal <> "") {
				$this->ClientStatusID->ViewValue = $this->ClientStatusID->lookupCacheOption($curVal);
				if ($this->ClientStatusID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`PartiesStatusID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ClientStatusID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->ClientStatusID->ViewValue = $this->ClientStatusID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ClientStatusID->ViewValue = $this->ClientStatusID->CurrentValue;
					}
				}
			} else {
				$this->ClientStatusID->ViewValue = NULL;
			}
			}
			$this->ClientStatusID->CssStyle = "font-style: italic;";
			$this->ClientStatusID->ViewCustomAttributes = "";

			// LitigantStatusID
			if ($this->LitigantStatusID->VirtualValue <> "") {
				$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->VirtualValue;
			} else {
			$curVal = strval($this->LitigantStatusID->CurrentValue);
			if ($curVal <> "") {
				$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->lookupCacheOption($curVal);
				if ($this->LitigantStatusID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`PartiesStatusID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->LitigantStatusID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->CurrentValue;
					}
				}
			} else {
				$this->LitigantStatusID->ViewValue = NULL;
			}
			}
			$this->LitigantStatusID->CssStyle = "font-style: italic;";
			$this->LitigantStatusID->ViewCustomAttributes = "";

			// CaseSortID
			if ($this->CaseSortID->VirtualValue <> "") {
				$this->CaseSortID->ViewValue = $this->CaseSortID->VirtualValue;
			} else {
			$curVal = strval($this->CaseSortID->CurrentValue);
			if ($curVal <> "") {
				$this->CaseSortID->ViewValue = $this->CaseSortID->lookupCacheOption($curVal);
				if ($this->CaseSortID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CaseSortID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CaseSortID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CaseSortID->ViewValue = $this->CaseSortID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CaseSortID->ViewValue = $this->CaseSortID->CurrentValue;
					}
				}
			} else {
				$this->CaseSortID->ViewValue = NULL;
			}
			}
			$this->CaseSortID->ViewCustomAttributes = "";

			// CaseStatusID
			if ($this->CaseStatusID->VirtualValue <> "") {
				$this->CaseStatusID->ViewValue = $this->CaseStatusID->VirtualValue;
			} else {
			$curVal = strval($this->CaseStatusID->CurrentValue);
			if ($curVal <> "") {
				$this->CaseStatusID->ViewValue = $this->CaseStatusID->lookupCacheOption($curVal);
				if ($this->CaseStatusID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CaseStatusID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CaseStatusID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CaseStatusID->ViewValue = $this->CaseStatusID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CaseStatusID->ViewValue = $this->CaseStatusID->CurrentValue;
					}
				}
			} else {
				$this->CaseStatusID->ViewValue = NULL;
			}
			}
			$this->CaseStatusID->CssStyle = "font-style: italic;";
			$this->CaseStatusID->ViewCustomAttributes = "";

			// ParentCaseID
			$this->ParentCaseID->ViewValue = $this->ParentCaseID->CurrentValue;
			$this->ParentCaseID->ViewValue = FormatNumber($this->ParentCaseID->ViewValue, 0, -2, -2, -2);
			$this->ParentCaseID->ViewCustomAttributes = "";

			// CaseRegisteredDate
			$this->CaseRegisteredDate->ViewValue = $this->CaseRegisteredDate->CurrentValue;
			$this->CaseRegisteredDate->ViewValue = FormatDateTime($this->CaseRegisteredDate->ViewValue, 7);
			$this->CaseRegisteredDate->ViewCustomAttributes = "";

			// Case
			$this->_Case->ViewValue = $this->_Case->CurrentValue;
			$this->_Case->ViewCustomAttributes = "";

			// CourtTypeID
			if ($this->CourtTypeID->VirtualValue <> "") {
				$this->CourtTypeID->ViewValue = $this->CourtTypeID->VirtualValue;
			} else {
			$curVal = strval($this->CourtTypeID->CurrentValue);
			if ($curVal <> "") {
				$this->CourtTypeID->ViewValue = $this->CourtTypeID->lookupCacheOption($curVal);
				if ($this->CourtTypeID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CourtTypeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CourtTypeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CourtTypeID->ViewValue = $this->CourtTypeID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CourtTypeID->ViewValue = $this->CourtTypeID->CurrentValue;
					}
				}
			} else {
				$this->CourtTypeID->ViewValue = NULL;
			}
			}
			$this->CourtTypeID->CssStyle = "font-style: italic;";
			$this->CourtTypeID->ViewCustomAttributes = "";

			// Notes
			$this->Notes->ViewValue = $this->Notes->CurrentValue;
			$this->Notes->ViewCustomAttributes = "";

			// FileLocation
			$this->FileLocation->ViewValue = $this->FileLocation->CurrentValue;
			$this->FileLocation->ViewCustomAttributes = "";

			// CaseID
			$this->CaseID->LinkCustomAttributes = "";
			$this->CaseID->HrefValue = "";
			$this->CaseID->TooltipValue = "";

			// ClientID
			$this->ClientID->LinkCustomAttributes = "";
			if (!EmptyValue($this->ClientID->CurrentValue)) {
				$this->ClientID->HrefValue = "/home/clients2view.php?showdetail=clientaddress,clientcontact,cases2&ClientID=" . $this->ClientID->CurrentValue; // Add prefix/suffix
				$this->ClientID->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->ClientID->HrefValue = FullUrl($this->ClientID->HrefValue, "href");
			} else {
				$this->ClientID->HrefValue = "";
			}
			$this->ClientID->TooltipValue = "";

			// LitigantID
			$this->LitigantID->LinkCustomAttributes = "";
			if (!EmptyValue($this->LitigantID->CurrentValue)) {
				$this->LitigantID->HrefValue = "/home/litigantsview.php?showdetail=litigantaddress,litigantcontact,cases&LitigantID=" . $this->LitigantID->CurrentValue; // Add prefix/suffix
				$this->LitigantID->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->LitigantID->HrefValue = FullUrl($this->LitigantID->HrefValue, "href");
			} else {
				$this->LitigantID->HrefValue = "";
			}
			$this->LitigantID->TooltipValue = "";

			// CaseTypeID
			$this->CaseTypeID->LinkCustomAttributes = "";
			$this->CaseTypeID->HrefValue = "";
			$this->CaseTypeID->TooltipValue = "";

			// CourtID
			$this->CourtID->LinkCustomAttributes = "";
			if (!EmptyValue($this->CourtID->CurrentValue)) {
				$this->CourtID->HrefValue = "/home/courtsview.php?showdetail=courtaddress,courtcontact&CourtID=" . $this->CourtID->CurrentValue; // Add prefix/suffix
				$this->CourtID->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->CourtID->HrefValue = FullUrl($this->CourtID->HrefValue, "href");
			} else {
				$this->CourtID->HrefValue = "";
			}
			$this->CourtID->TooltipValue = "";

			// CaseNumber
			$this->CaseNumber->LinkCustomAttributes = "";
			$this->CaseNumber->HrefValue = "";
			$this->CaseNumber->TooltipValue = "";

			// FileNumber
			$this->FileNumber->LinkCustomAttributes = "";
			$this->FileNumber->HrefValue = "";
			$this->FileNumber->TooltipValue = "";

			// ClientStatusID
			$this->ClientStatusID->LinkCustomAttributes = "";
			$this->ClientStatusID->HrefValue = "";
			$this->ClientStatusID->TooltipValue = "";

			// LitigantStatusID
			$this->LitigantStatusID->LinkCustomAttributes = "";
			$this->LitigantStatusID->HrefValue = "";
			$this->LitigantStatusID->TooltipValue = "";

			// CaseSortID
			$this->CaseSortID->LinkCustomAttributes = "";
			$this->CaseSortID->HrefValue = "";
			$this->CaseSortID->TooltipValue = "";

			// CaseStatusID
			$this->CaseStatusID->LinkCustomAttributes = "";
			$this->CaseStatusID->HrefValue = "";
			$this->CaseStatusID->TooltipValue = "";

			// ParentCaseID
			$this->ParentCaseID->LinkCustomAttributes = "";
			$this->ParentCaseID->HrefValue = "";
			$this->ParentCaseID->TooltipValue = "";

			// CaseRegisteredDate
			$this->CaseRegisteredDate->LinkCustomAttributes = "";
			$this->CaseRegisteredDate->HrefValue = "";
			$this->CaseRegisteredDate->TooltipValue = "";

			// Case
			$this->_Case->LinkCustomAttributes = "";
			$this->_Case->HrefValue = "";
			$this->_Case->TooltipValue = "";

			// CourtTypeID
			$this->CourtTypeID->LinkCustomAttributes = "";
			$this->CourtTypeID->HrefValue = "";
			$this->CourtTypeID->TooltipValue = "";

			// Notes
			$this->Notes->LinkCustomAttributes = "";
			$this->Notes->HrefValue = "";
			$this->Notes->TooltipValue = "";

			// FileLocation
			$this->FileLocation->LinkCustomAttributes = "";
			$this->FileLocation->HrefValue = "";
			$this->FileLocation->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// CaseID
			$this->CaseID->EditAttrs["class"] = "form-control";
			$this->CaseID->EditCustomAttributes = "";

			// ClientID
			$this->ClientID->EditAttrs["class"] = "form-control";
			$this->ClientID->EditCustomAttributes = "";
			$this->ClientID->EditValue = HtmlEncode($this->ClientID->CurrentValue);
			$curVal = strval($this->ClientID->CurrentValue);
			if ($curVal <> "") {
				$this->ClientID->EditValue = $this->ClientID->lookupCacheOption($curVal);
				if ($this->ClientID->EditValue === NULL) { // Lookup from database
					$filterWrk = "`ClientID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ClientID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$arwrk[3] = HtmlEncode($rswrk->fields('df3'));
						$this->ClientID->EditValue = $this->ClientID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ClientID->EditValue = HtmlEncode($this->ClientID->CurrentValue);
					}
				}
			} else {
				$this->ClientID->EditValue = NULL;
			}
			$this->ClientID->PlaceHolder = RemoveHtml($this->ClientID->caption());

			// LitigantID
			$this->LitigantID->EditAttrs["class"] = "form-control";
			$this->LitigantID->EditCustomAttributes = "";
			$this->LitigantID->EditValue = HtmlEncode($this->LitigantID->CurrentValue);
			$curVal = strval($this->LitigantID->CurrentValue);
			if ($curVal <> "") {
				$this->LitigantID->EditValue = $this->LitigantID->lookupCacheOption($curVal);
				if ($this->LitigantID->EditValue === NULL) { // Lookup from database
					$filterWrk = "`LitigantID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->LitigantID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$arwrk[3] = HtmlEncode($rswrk->fields('df3'));
						$this->LitigantID->EditValue = $this->LitigantID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->LitigantID->EditValue = HtmlEncode($this->LitigantID->CurrentValue);
					}
				}
			} else {
				$this->LitigantID->EditValue = NULL;
			}
			$this->LitigantID->PlaceHolder = RemoveHtml($this->LitigantID->caption());

			// CaseTypeID
			$this->CaseTypeID->EditAttrs["class"] = "form-control";
			$this->CaseTypeID->EditCustomAttributes = "";
			$curVal = trim(strval($this->CaseTypeID->CurrentValue));
			if ($curVal <> "")
				$this->CaseTypeID->ViewValue = $this->CaseTypeID->lookupCacheOption($curVal);
			else
				$this->CaseTypeID->ViewValue = $this->CaseTypeID->Lookup !== NULL && is_array($this->CaseTypeID->Lookup->Options) ? $curVal : NULL;
			if ($this->CaseTypeID->ViewValue !== NULL) { // Load from cache
				$this->CaseTypeID->EditValue = array_values($this->CaseTypeID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`CaseTypeID`" . SearchString("=", $this->CaseTypeID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->CaseTypeID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->CaseTypeID->EditValue = $arwrk;
			}

			// CourtID
			$this->CourtID->EditAttrs["class"] = "form-control";
			$this->CourtID->EditCustomAttributes = "";
			$this->CourtID->EditValue = HtmlEncode($this->CourtID->CurrentValue);
			$curVal = strval($this->CourtID->CurrentValue);
			if ($curVal <> "") {
				$this->CourtID->EditValue = $this->CourtID->lookupCacheOption($curVal);
				if ($this->CourtID->EditValue === NULL) { // Lookup from database
					$filterWrk = "`CourtID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CourtID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->CourtID->EditValue = $this->CourtID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CourtID->EditValue = HtmlEncode($this->CourtID->CurrentValue);
					}
				}
			} else {
				$this->CourtID->EditValue = NULL;
			}
			$this->CourtID->PlaceHolder = RemoveHtml($this->CourtID->caption());

			// CaseNumber
			$this->CaseNumber->EditAttrs["class"] = "form-control";
			$this->CaseNumber->EditCustomAttributes = "";
			$this->CaseNumber->EditValue = HtmlEncode($this->CaseNumber->CurrentValue);
			$this->CaseNumber->PlaceHolder = RemoveHtml($this->CaseNumber->caption());

			// FileNumber
			$this->FileNumber->EditAttrs["class"] = "form-control";
			$this->FileNumber->EditCustomAttributes = "";
			$this->FileNumber->EditValue = HtmlEncode($this->FileNumber->CurrentValue);
			$this->FileNumber->PlaceHolder = RemoveHtml($this->FileNumber->caption());

			// ClientStatusID
			$this->ClientStatusID->EditAttrs["class"] = "form-control";
			$this->ClientStatusID->EditCustomAttributes = "";
			$curVal = trim(strval($this->ClientStatusID->CurrentValue));
			if ($curVal <> "")
				$this->ClientStatusID->ViewValue = $this->ClientStatusID->lookupCacheOption($curVal);
			else
				$this->ClientStatusID->ViewValue = $this->ClientStatusID->Lookup !== NULL && is_array($this->ClientStatusID->Lookup->Options) ? $curVal : NULL;
			if ($this->ClientStatusID->ViewValue !== NULL) { // Load from cache
				$this->ClientStatusID->EditValue = array_values($this->ClientStatusID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`PartiesStatusID`" . SearchString("=", $this->ClientStatusID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->ClientStatusID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->ClientStatusID->EditValue = $arwrk;
			}

			// LitigantStatusID
			$this->LitigantStatusID->EditAttrs["class"] = "form-control";
			$this->LitigantStatusID->EditCustomAttributes = "";
			$curVal = trim(strval($this->LitigantStatusID->CurrentValue));
			if ($curVal <> "")
				$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->lookupCacheOption($curVal);
			else
				$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->Lookup !== NULL && is_array($this->LitigantStatusID->Lookup->Options) ? $curVal : NULL;
			if ($this->LitigantStatusID->ViewValue !== NULL) { // Load from cache
				$this->LitigantStatusID->EditValue = array_values($this->LitigantStatusID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`PartiesStatusID`" . SearchString("=", $this->LitigantStatusID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->LitigantStatusID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->LitigantStatusID->EditValue = $arwrk;
			}

			// CaseSortID
			$this->CaseSortID->EditAttrs["class"] = "form-control";
			$this->CaseSortID->EditCustomAttributes = "";
			$curVal = trim(strval($this->CaseSortID->CurrentValue));
			if ($curVal <> "")
				$this->CaseSortID->ViewValue = $this->CaseSortID->lookupCacheOption($curVal);
			else
				$this->CaseSortID->ViewValue = $this->CaseSortID->Lookup !== NULL && is_array($this->CaseSortID->Lookup->Options) ? $curVal : NULL;
			if ($this->CaseSortID->ViewValue !== NULL) { // Load from cache
				$this->CaseSortID->EditValue = array_values($this->CaseSortID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`CaseSortID`" . SearchString("=", $this->CaseSortID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->CaseSortID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->CaseSortID->EditValue = $arwrk;
			}

			// CaseStatusID
			$this->CaseStatusID->EditAttrs["class"] = "form-control";
			$this->CaseStatusID->EditCustomAttributes = "";
			$curVal = trim(strval($this->CaseStatusID->CurrentValue));
			if ($curVal <> "")
				$this->CaseStatusID->ViewValue = $this->CaseStatusID->lookupCacheOption($curVal);
			else
				$this->CaseStatusID->ViewValue = $this->CaseStatusID->Lookup !== NULL && is_array($this->CaseStatusID->Lookup->Options) ? $curVal : NULL;
			if ($this->CaseStatusID->ViewValue !== NULL) { // Load from cache
				$this->CaseStatusID->EditValue = array_values($this->CaseStatusID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`CaseStatusID`" . SearchString("=", $this->CaseStatusID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->CaseStatusID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->CaseStatusID->EditValue = $arwrk;
			}

			// ParentCaseID
			$this->ParentCaseID->EditAttrs["class"] = "form-control";
			$this->ParentCaseID->EditCustomAttributes = "";
			$this->ParentCaseID->EditValue = HtmlEncode($this->ParentCaseID->CurrentValue);
			$this->ParentCaseID->PlaceHolder = RemoveHtml($this->ParentCaseID->caption());

			// CaseRegisteredDate
			$this->CaseRegisteredDate->EditAttrs["class"] = "form-control";
			$this->CaseRegisteredDate->EditCustomAttributes = "";
			$this->CaseRegisteredDate->EditValue = HtmlEncode(FormatDateTime($this->CaseRegisteredDate->CurrentValue, 7));
			$this->CaseRegisteredDate->PlaceHolder = RemoveHtml($this->CaseRegisteredDate->caption());

			// Case
			$this->_Case->EditAttrs["class"] = "form-control";
			$this->_Case->EditCustomAttributes = "";
			$this->_Case->EditValue = HtmlEncode($this->_Case->CurrentValue);
			$this->_Case->PlaceHolder = RemoveHtml($this->_Case->caption());

			// CourtTypeID
			$this->CourtTypeID->EditAttrs["class"] = "form-control";
			$this->CourtTypeID->EditCustomAttributes = "";
			$curVal = trim(strval($this->CourtTypeID->CurrentValue));
			if ($curVal <> "")
				$this->CourtTypeID->ViewValue = $this->CourtTypeID->lookupCacheOption($curVal);
			else
				$this->CourtTypeID->ViewValue = $this->CourtTypeID->Lookup !== NULL && is_array($this->CourtTypeID->Lookup->Options) ? $curVal : NULL;
			if ($this->CourtTypeID->ViewValue !== NULL) { // Load from cache
				$this->CourtTypeID->EditValue = array_values($this->CourtTypeID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`CourtTypeID`" . SearchString("=", $this->CourtTypeID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->CourtTypeID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->CourtTypeID->EditValue = $arwrk;
			}

			// Notes
			$this->Notes->EditAttrs["class"] = "form-control";
			$this->Notes->EditCustomAttributes = "";
			$this->Notes->EditValue = HtmlEncode($this->Notes->CurrentValue);
			$this->Notes->PlaceHolder = RemoveHtml($this->Notes->caption());

			// FileLocation
			$this->FileLocation->EditAttrs["class"] = "form-control";
			$this->FileLocation->EditCustomAttributes = "";
			$this->FileLocation->EditValue = HtmlEncode($this->FileLocation->CurrentValue);
			$this->FileLocation->PlaceHolder = RemoveHtml($this->FileLocation->caption());

			// Edit refer script
			// CaseID

			$this->CaseID->LinkCustomAttributes = "";
			$this->CaseID->HrefValue = "";

			// ClientID
			$this->ClientID->LinkCustomAttributes = "";
			if (!EmptyValue($this->ClientID->CurrentValue)) {
				$this->ClientID->HrefValue = "/home/clients2view.php?showdetail=clientaddress,clientcontact,cases2&ClientID=" . $this->ClientID->CurrentValue; // Add prefix/suffix
				$this->ClientID->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->ClientID->HrefValue = FullUrl($this->ClientID->HrefValue, "href");
			} else {
				$this->ClientID->HrefValue = "";
			}

			// LitigantID
			$this->LitigantID->LinkCustomAttributes = "";
			if (!EmptyValue($this->LitigantID->CurrentValue)) {
				$this->LitigantID->HrefValue = "/home/litigantsview.php?showdetail=litigantaddress,litigantcontact,cases&LitigantID=" . $this->LitigantID->CurrentValue; // Add prefix/suffix
				$this->LitigantID->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->LitigantID->HrefValue = FullUrl($this->LitigantID->HrefValue, "href");
			} else {
				$this->LitigantID->HrefValue = "";
			}

			// CaseTypeID
			$this->CaseTypeID->LinkCustomAttributes = "";
			$this->CaseTypeID->HrefValue = "";

			// CourtID
			$this->CourtID->LinkCustomAttributes = "";
			if (!EmptyValue($this->CourtID->CurrentValue)) {
				$this->CourtID->HrefValue = "/home/courtsview.php?showdetail=courtaddress,courtcontact&CourtID=" . $this->CourtID->CurrentValue; // Add prefix/suffix
				$this->CourtID->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->CourtID->HrefValue = FullUrl($this->CourtID->HrefValue, "href");
			} else {
				$this->CourtID->HrefValue = "";
			}

			// CaseNumber
			$this->CaseNumber->LinkCustomAttributes = "";
			$this->CaseNumber->HrefValue = "";

			// FileNumber
			$this->FileNumber->LinkCustomAttributes = "";
			$this->FileNumber->HrefValue = "";

			// ClientStatusID
			$this->ClientStatusID->LinkCustomAttributes = "";
			$this->ClientStatusID->HrefValue = "";

			// LitigantStatusID
			$this->LitigantStatusID->LinkCustomAttributes = "";
			$this->LitigantStatusID->HrefValue = "";

			// CaseSortID
			$this->CaseSortID->LinkCustomAttributes = "";
			$this->CaseSortID->HrefValue = "";

			// CaseStatusID
			$this->CaseStatusID->LinkCustomAttributes = "";
			$this->CaseStatusID->HrefValue = "";

			// ParentCaseID
			$this->ParentCaseID->LinkCustomAttributes = "";
			$this->ParentCaseID->HrefValue = "";

			// CaseRegisteredDate
			$this->CaseRegisteredDate->LinkCustomAttributes = "";
			$this->CaseRegisteredDate->HrefValue = "";

			// Case
			$this->_Case->LinkCustomAttributes = "";
			$this->_Case->HrefValue = "";

			// CourtTypeID
			$this->CourtTypeID->LinkCustomAttributes = "";
			$this->CourtTypeID->HrefValue = "";

			// Notes
			$this->Notes->LinkCustomAttributes = "";
			$this->Notes->HrefValue = "";

			// FileLocation
			$this->FileLocation->LinkCustomAttributes = "";
			$this->FileLocation->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->CaseID->Required) {
			if (!$this->CaseID->IsDetailKey && $this->CaseID->FormValue != NULL && $this->CaseID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseID->caption(), $this->CaseID->RequiredErrorMessage));
			}
		}
		if ($this->ClientID->Required) {
			if (!$this->ClientID->IsDetailKey && $this->ClientID->FormValue != NULL && $this->ClientID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ClientID->caption(), $this->ClientID->RequiredErrorMessage));
			}
		}
		if ($this->LitigantID->Required) {
			if (!$this->LitigantID->IsDetailKey && $this->LitigantID->FormValue != NULL && $this->LitigantID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->LitigantID->caption(), $this->LitigantID->RequiredErrorMessage));
			}
		}
		if ($this->CaseTypeID->Required) {
			if (!$this->CaseTypeID->IsDetailKey && $this->CaseTypeID->FormValue != NULL && $this->CaseTypeID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseTypeID->caption(), $this->CaseTypeID->RequiredErrorMessage));
			}
		}
		if ($this->CourtID->Required) {
			if (!$this->CourtID->IsDetailKey && $this->CourtID->FormValue != NULL && $this->CourtID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CourtID->caption(), $this->CourtID->RequiredErrorMessage));
			}
		}
		if ($this->CaseNumber->Required) {
			if (!$this->CaseNumber->IsDetailKey && $this->CaseNumber->FormValue != NULL && $this->CaseNumber->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseNumber->caption(), $this->CaseNumber->RequiredErrorMessage));
			}
		}
		if ($this->FileNumber->Required) {
			if (!$this->FileNumber->IsDetailKey && $this->FileNumber->FormValue != NULL && $this->FileNumber->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->FileNumber->caption(), $this->FileNumber->RequiredErrorMessage));
			}
		}
		if ($this->EnvelopeNumber->Required) {
			if (!$this->EnvelopeNumber->IsDetailKey && $this->EnvelopeNumber->FormValue != NULL && $this->EnvelopeNumber->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->EnvelopeNumber->caption(), $this->EnvelopeNumber->RequiredErrorMessage));
			}
		}
		if ($this->ClientStatusID->Required) {
			if (!$this->ClientStatusID->IsDetailKey && $this->ClientStatusID->FormValue != NULL && $this->ClientStatusID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ClientStatusID->caption(), $this->ClientStatusID->RequiredErrorMessage));
			}
		}
		if ($this->LitigantStatusID->Required) {
			if (!$this->LitigantStatusID->IsDetailKey && $this->LitigantStatusID->FormValue != NULL && $this->LitigantStatusID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->LitigantStatusID->caption(), $this->LitigantStatusID->RequiredErrorMessage));
			}
		}
		if ($this->CaseSortID->Required) {
			if (!$this->CaseSortID->IsDetailKey && $this->CaseSortID->FormValue != NULL && $this->CaseSortID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseSortID->caption(), $this->CaseSortID->RequiredErrorMessage));
			}
		}
		if ($this->CaseStatusID->Required) {
			if (!$this->CaseStatusID->IsDetailKey && $this->CaseStatusID->FormValue != NULL && $this->CaseStatusID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseStatusID->caption(), $this->CaseStatusID->RequiredErrorMessage));
			}
		}
		if ($this->ParentCaseID->Required) {
			if (!$this->ParentCaseID->IsDetailKey && $this->ParentCaseID->FormValue != NULL && $this->ParentCaseID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ParentCaseID->caption(), $this->ParentCaseID->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->ParentCaseID->FormValue)) {
			AddMessage($FormError, $this->ParentCaseID->errorMessage());
		}
		if ($this->CaseRegisteredDate->Required) {
			if (!$this->CaseRegisteredDate->IsDetailKey && $this->CaseRegisteredDate->FormValue != NULL && $this->CaseRegisteredDate->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseRegisteredDate->caption(), $this->CaseRegisteredDate->RequiredErrorMessage));
			}
		}
		if (!CheckEuroDate($this->CaseRegisteredDate->FormValue)) {
			AddMessage($FormError, $this->CaseRegisteredDate->errorMessage());
		}
		if ($this->_Case->Required) {
			if (!$this->_Case->IsDetailKey && $this->_Case->FormValue != NULL && $this->_Case->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_Case->caption(), $this->_Case->RequiredErrorMessage));
			}
		}
		if ($this->CaseEn->Required) {
			if (!$this->CaseEn->IsDetailKey && $this->CaseEn->FormValue != NULL && $this->CaseEn->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseEn->caption(), $this->CaseEn->RequiredErrorMessage));
			}
		}
		if ($this->CourtTypeID->Required) {
			if (!$this->CourtTypeID->IsDetailKey && $this->CourtTypeID->FormValue != NULL && $this->CourtTypeID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CourtTypeID->caption(), $this->CourtTypeID->RequiredErrorMessage));
			}
		}
		if ($this->CourtGenderID->Required) {
			if (!$this->CourtGenderID->IsDetailKey && $this->CourtGenderID->FormValue != NULL && $this->CourtGenderID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CourtGenderID->caption(), $this->CourtGenderID->RequiredErrorMessage));
			}
		}
		if ($this->JudgeID->Required) {
			if (!$this->JudgeID->IsDetailKey && $this->JudgeID->FormValue != NULL && $this->JudgeID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->JudgeID->caption(), $this->JudgeID->RequiredErrorMessage));
			}
		}
		if ($this->Notes->Required) {
			if (!$this->Notes->IsDetailKey && $this->Notes->FormValue != NULL && $this->Notes->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Notes->caption(), $this->Notes->RequiredErrorMessage));
			}
		}
		if ($this->FileLocation->Required) {
			if (!$this->FileLocation->IsDetailKey && $this->FileLocation->FormValue != NULL && $this->FileLocation->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->FileLocation->caption(), $this->FileLocation->RequiredErrorMessage));
			}
		}
		if ($this->_UserID->Required) {
			if (!$this->_UserID->IsDetailKey && $this->_UserID->FormValue != NULL && $this->_UserID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_UserID->caption(), $this->_UserID->RequiredErrorMessage));
			}
		}
		if ($this->CreatedBy->Required) {
			if (!$this->CreatedBy->IsDetailKey && $this->CreatedBy->FormValue != NULL && $this->CreatedBy->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CreatedBy->caption(), $this->CreatedBy->RequiredErrorMessage));
			}
		}
		if ($this->CreatedDate->Required) {
			if (!$this->CreatedDate->IsDetailKey && $this->CreatedDate->FormValue != NULL && $this->CreatedDate->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CreatedDate->caption(), $this->CreatedDate->RequiredErrorMessage));
			}
		}
		if ($this->UpdatedBy->Required) {
			if (!$this->UpdatedBy->IsDetailKey && $this->UpdatedBy->FormValue != NULL && $this->UpdatedBy->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->UpdatedBy->caption(), $this->UpdatedBy->RequiredErrorMessage));
			}
		}
		if ($this->UpdatedDate->Required) {
			if (!$this->UpdatedDate->IsDetailKey && $this->UpdatedDate->FormValue != NULL && $this->UpdatedDate->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->UpdatedDate->caption(), $this->UpdatedDate->RequiredErrorMessage));
			}
		}
		if ($this->ClientStatusConv->Required) {
			if (!$this->ClientStatusConv->IsDetailKey && $this->ClientStatusConv->FormValue != NULL && $this->ClientStatusConv->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ClientStatusConv->caption(), $this->ClientStatusConv->RequiredErrorMessage));
			}
		}
		if ($this->LitigantStatusConv->Required) {
			if (!$this->LitigantStatusConv->IsDetailKey && $this->LitigantStatusConv->FormValue != NULL && $this->LitigantStatusConv->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->LitigantStatusConv->caption(), $this->LitigantStatusConv->RequiredErrorMessage));
			}
		}
		if ($this->CaseTypeConv->Required) {
			if (!$this->CaseTypeConv->IsDetailKey && $this->CaseTypeConv->FormValue != NULL && $this->CaseTypeConv->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseTypeConv->caption(), $this->CaseTypeConv->RequiredErrorMessage));
			}
		}
		if ($this->CaseConv->Required) {
			if (!$this->CaseConv->IsDetailKey && $this->CaseConv->FormValue != NULL && $this->CaseConv->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseConv->caption(), $this->CaseConv->RequiredErrorMessage));
			}
		}
		if ($this->ClientNameConv->Required) {
			if (!$this->ClientNameConv->IsDetailKey && $this->ClientNameConv->FormValue != NULL && $this->ClientNameConv->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ClientNameConv->caption(), $this->ClientNameConv->RequiredErrorMessage));
			}
		}
		if ($this->LitigantNameConv->Required) {
			if (!$this->LitigantNameConv->IsDetailKey && $this->LitigantNameConv->FormValue != NULL && $this->LitigantNameConv->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->LitigantNameConv->caption(), $this->LitigantNameConv->RequiredErrorMessage));
			}
		}
		if ($this->ClientNameConvFiles->Required) {
			if (!$this->ClientNameConvFiles->IsDetailKey && $this->ClientNameConvFiles->FormValue != NULL && $this->ClientNameConvFiles->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ClientNameConvFiles->caption(), $this->ClientNameConvFiles->RequiredErrorMessage));
			}
		}
		if ($this->LitigantNameConvFiles->Required) {
			if (!$this->LitigantNameConvFiles->IsDetailKey && $this->LitigantNameConvFiles->FormValue != NULL && $this->LitigantNameConvFiles->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->LitigantNameConvFiles->caption(), $this->LitigantNameConvFiles->RequiredErrorMessage));
			}
		}
		if ($this->CaseTypeConvFiles->Required) {
			if (!$this->CaseTypeConvFiles->IsDetailKey && $this->CaseTypeConvFiles->FormValue != NULL && $this->CaseTypeConvFiles->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseTypeConvFiles->caption(), $this->CaseTypeConvFiles->RequiredErrorMessage));
			}
		}
		if ($this->CourtConvFiles->Required) {
			if (!$this->CourtConvFiles->IsDetailKey && $this->CourtConvFiles->FormValue != NULL && $this->CourtConvFiles->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CourtConvFiles->caption(), $this->CourtConvFiles->RequiredErrorMessage));
			}
		}
		if ($this->FileNumberConvFiles->Required) {
			if (!$this->FileNumberConvFiles->IsDetailKey && $this->FileNumberConvFiles->FormValue != NULL && $this->FileNumberConvFiles->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->FileNumberConvFiles->caption(), $this->FileNumberConvFiles->RequiredErrorMessage));
			}
		}
		if ($this->CaseNumberConvFiles->Required) {
			if (!$this->CaseNumberConvFiles->IsDetailKey && $this->CaseNumberConvFiles->FormValue != NULL && $this->CaseNumberConvFiles->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CaseNumberConvFiles->caption(), $this->CaseNumberConvFiles->RequiredErrorMessage));
			}
		}
		if ($this->NotesConvFiles->Required) {
			if (!$this->NotesConvFiles->IsDetailKey && $this->NotesConvFiles->FormValue != NULL && $this->NotesConvFiles->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NotesConvFiles->caption(), $this->NotesConvFiles->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		if ($this->FileNumber->CurrentValue <> "") { // Check field with unique index
			$filterChk = "(`FileNumber` = '" . AdjustSql($this->FileNumber->CurrentValue, $this->Dbid) . "')";
			$filterChk .= " AND NOT (" . $filter . ")";
			$this->CurrentFilter = $filterChk;
			$sqlChk = $this->getCurrentSql();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rsChk = $conn->Execute($sqlChk);
			$conn->raiseErrorFn = '';
			if ($rsChk === FALSE) {
				return FALSE;
			} elseif (!$rsChk->EOF) {
				$idxErrMsg = str_replace("%f", $this->FileNumber->caption(), $Language->phrase("DupIndex"));
				$idxErrMsg = str_replace("%v", $this->FileNumber->CurrentValue, $idxErrMsg);
				$this->setFailureMessage($idxErrMsg);
				$rsChk->close();
				return FALSE;
			}
			$rsChk->close();
		}
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// ClientID
			$this->ClientID->setDbValueDef($rsnew, $this->ClientID->CurrentValue, NULL, $this->ClientID->ReadOnly);

			// LitigantID
			$this->LitigantID->setDbValueDef($rsnew, $this->LitigantID->CurrentValue, NULL, $this->LitigantID->ReadOnly);

			// CaseTypeID
			$this->CaseTypeID->setDbValueDef($rsnew, $this->CaseTypeID->CurrentValue, 0, $this->CaseTypeID->ReadOnly);

			// CourtID
			$this->CourtID->setDbValueDef($rsnew, $this->CourtID->CurrentValue, NULL, $this->CourtID->ReadOnly);

			// CaseNumber
			$this->CaseNumber->setDbValueDef($rsnew, $this->CaseNumber->CurrentValue, NULL, $this->CaseNumber->ReadOnly);

			// FileNumber
			$this->FileNumber->setDbValueDef($rsnew, $this->FileNumber->CurrentValue, "", $this->FileNumber->ReadOnly);

			// ClientStatusID
			$this->ClientStatusID->setDbValueDef($rsnew, $this->ClientStatusID->CurrentValue, NULL, $this->ClientStatusID->ReadOnly);

			// LitigantStatusID
			$this->LitigantStatusID->setDbValueDef($rsnew, $this->LitigantStatusID->CurrentValue, NULL, $this->LitigantStatusID->ReadOnly);

			// CaseSortID
			$this->CaseSortID->setDbValueDef($rsnew, $this->CaseSortID->CurrentValue, 0, $this->CaseSortID->ReadOnly);

			// CaseStatusID
			$this->CaseStatusID->setDbValueDef($rsnew, $this->CaseStatusID->CurrentValue, 0, $this->CaseStatusID->ReadOnly);

			// ParentCaseID
			$this->ParentCaseID->setDbValueDef($rsnew, $this->ParentCaseID->CurrentValue, NULL, $this->ParentCaseID->ReadOnly);

			// CaseRegisteredDate
			$this->CaseRegisteredDate->setDbValueDef($rsnew, UnFormatDateTime($this->CaseRegisteredDate->CurrentValue, 7), NULL, $this->CaseRegisteredDate->ReadOnly);

			// Case
			$this->_Case->setDbValueDef($rsnew, $this->_Case->CurrentValue, NULL, $this->_Case->ReadOnly);

			// CourtTypeID
			$this->CourtTypeID->setDbValueDef($rsnew, $this->CourtTypeID->CurrentValue, NULL, $this->CourtTypeID->ReadOnly);

			// Notes
			$this->Notes->setDbValueDef($rsnew, $this->Notes->CurrentValue, NULL, $this->Notes->ReadOnly);

			// FileLocation
			$this->FileLocation->setDbValueDef($rsnew, $this->FileLocation->CurrentValue, NULL, $this->FileLocation->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("cases2list.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_ClientID":
							break;
						case "x_LitigantID":
							break;
						case "x_CaseTypeID":
							break;
						case "x_CourtID":
							break;
						case "x_ClientStatusID":
							break;
						case "x_LitigantStatusID":
							break;
						case "x_CaseSortID":
							break;
						case "x_CaseStatusID":
							break;
						case "x_CourtTypeID":
							break;
						case "x_CourtGenderID":
							break;
						case "x_JudgeID":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
