<?php
namespace PHPMaker2019\project_germanos;

/**
 * Table class for caseslookupv
 */
class caseslookupv extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $CaseID;
	public $ClientID;
	public $LitigantID;
	public $CaseTypeID;
	public $CourtID;
	public $CaseNumber;
	public $FileNumber;
	public $EnvelopeNumber;
	public $ClientStatusID;
	public $LitigantStatusID;
	public $_Case;
	public $CaseEn;
	public $JudgeID;
	public $CaseSortID;
	public $CaseRegisteredDate;
	public $CaseStatusID;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'caseslookupv';
		$this->TableName = 'caseslookupv';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`caseslookupv`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// CaseID
		$this->CaseID = new DbField('caseslookupv', 'caseslookupv', 'x_CaseID', 'CaseID', '`CaseID`', '`CaseID`', 3, -1, FALSE, '`CaseID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'HIDDEN');
		$this->CaseID->IsAutoIncrement = TRUE; // Autoincrement field
		$this->CaseID->IsPrimaryKey = TRUE; // Primary key field
		$this->CaseID->Sortable = TRUE; // Allow sort
		$this->CaseID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['CaseID'] = &$this->CaseID;

		// ClientID
		$this->ClientID = new DbField('caseslookupv', 'caseslookupv', 'x_ClientID', 'ClientID', '`ClientID`', '`ClientID`', 3, -1, FALSE, '`EV__ClientID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->ClientID->Required = TRUE; // Required field
		$this->ClientID->Sortable = TRUE; // Allow sort
		switch ($CurrentLanguage) {
			case "ar":
				$this->ClientID->Lookup = new Lookup('ClientID', 'clients', FALSE, 'ClientID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->ClientID->Lookup = new Lookup('ClientID', 'clients', FALSE, 'ClientID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->ClientID->Lookup = new Lookup('ClientID', 'clients', FALSE, 'ClientID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->ClientID->Lookup = new Lookup('ClientID', 'clients', FALSE, 'ClientID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->ClientID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['ClientID'] = &$this->ClientID;

		// LitigantID
		$this->LitigantID = new DbField('caseslookupv', 'caseslookupv', 'x_LitigantID', 'LitigantID', '`LitigantID`', '`LitigantID`', 3, -1, FALSE, '`EV__LitigantID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->LitigantID->Sortable = TRUE; // Allow sort
		switch ($CurrentLanguage) {
			case "ar":
				$this->LitigantID->Lookup = new Lookup('LitigantID', 'litigants', FALSE, 'LitigantID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->LitigantID->Lookup = new Lookup('LitigantID', 'litigants', FALSE, 'LitigantID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->LitigantID->Lookup = new Lookup('LitigantID', 'litigants', FALSE, 'LitigantID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->LitigantID->Lookup = new Lookup('LitigantID', 'litigants', FALSE, 'LitigantID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->LitigantID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['LitigantID'] = &$this->LitigantID;

		// CaseTypeID
		$this->CaseTypeID = new DbField('caseslookupv', 'caseslookupv', 'x_CaseTypeID', 'CaseTypeID', '`CaseTypeID`', '`CaseTypeID`', 3, -1, FALSE, '`EV__CaseTypeID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->CaseTypeID->Nullable = FALSE; // NOT NULL field
		$this->CaseTypeID->Required = TRUE; // Required field
		$this->CaseTypeID->Sortable = TRUE; // Allow sort
		$this->CaseTypeID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->CaseTypeID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->CaseTypeID->Lookup = new Lookup('CaseTypeID', 'casetypes', TRUE, 'CaseTypeID', ["CaseType","","",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->CaseTypeID->Lookup = new Lookup('CaseTypeID', 'casetypes', TRUE, 'CaseTypeID', ["CaseType","","",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->CaseTypeID->Lookup = new Lookup('CaseTypeID', 'casetypes', TRUE, 'CaseTypeID', ["CaseType","","",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->CaseTypeID->Lookup = new Lookup('CaseTypeID', 'casetypes', TRUE, 'CaseTypeID', ["CaseType","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->CaseTypeID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['CaseTypeID'] = &$this->CaseTypeID;

		// CourtID
		$this->CourtID = new DbField('caseslookupv', 'caseslookupv', 'x_CourtID', 'CourtID', '`CourtID`', '`CourtID`', 3, -1, FALSE, '`EV__CourtID`', TRUE, FALSE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->CourtID->Sortable = TRUE; // Allow sort
		switch ($CurrentLanguage) {
			case "ar":
				$this->CourtID->Lookup = new Lookup('CourtID', 'courts', TRUE, 'CourtID', ["Court","","",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->CourtID->Lookup = new Lookup('CourtID', 'courts', TRUE, 'CourtID', ["Court","","",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->CourtID->Lookup = new Lookup('CourtID', 'courts', TRUE, 'CourtID', ["Court","","",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->CourtID->Lookup = new Lookup('CourtID', 'courts', TRUE, 'CourtID', ["Court","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->CourtID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['CourtID'] = &$this->CourtID;

		// CaseNumber
		$this->CaseNumber = new DbField('caseslookupv', 'caseslookupv', 'x_CaseNumber', 'CaseNumber', '`CaseNumber`', '`CaseNumber`', 200, -1, FALSE, '`CaseNumber`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CaseNumber->Sortable = TRUE; // Allow sort
		$this->fields['CaseNumber'] = &$this->CaseNumber;

		// FileNumber
		$this->FileNumber = new DbField('caseslookupv', 'caseslookupv', 'x_FileNumber', 'FileNumber', '`FileNumber`', '`FileNumber`', 200, -1, FALSE, '`FileNumber`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->FileNumber->Nullable = FALSE; // NOT NULL field
		$this->FileNumber->Required = TRUE; // Required field
		$this->FileNumber->Sortable = TRUE; // Allow sort
		$this->fields['FileNumber'] = &$this->FileNumber;

		// EnvelopeNumber
		$this->EnvelopeNumber = new DbField('caseslookupv', 'caseslookupv', 'x_EnvelopeNumber', 'EnvelopeNumber', '`EnvelopeNumber`', '`EnvelopeNumber`', 3, -1, FALSE, '`EnvelopeNumber`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->EnvelopeNumber->Sortable = TRUE; // Allow sort
		$this->fields['EnvelopeNumber'] = &$this->EnvelopeNumber;

		// ClientStatusID
		$this->ClientStatusID = new DbField('caseslookupv', 'caseslookupv', 'x_ClientStatusID', 'ClientStatusID', '`ClientStatusID`', '`ClientStatusID`', 3, -1, FALSE, '`EV__ClientStatusID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->ClientStatusID->Nullable = FALSE; // NOT NULL field
		$this->ClientStatusID->Required = TRUE; // Required field
		$this->ClientStatusID->Sortable = TRUE; // Allow sort
		$this->ClientStatusID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->ClientStatusID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->ClientStatusID->Lookup = new Lookup('ClientStatusID', 'partiesstatus', TRUE, 'PartiesStatusID', ["PartiesStatus","","",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->ClientStatusID->Lookup = new Lookup('ClientStatusID', 'partiesstatus', TRUE, 'PartiesStatusID', ["PartiesStatus","","",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->ClientStatusID->Lookup = new Lookup('ClientStatusID', 'partiesstatus', TRUE, 'PartiesStatusID', ["PartiesStatus","","",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->ClientStatusID->Lookup = new Lookup('ClientStatusID', 'partiesstatus', TRUE, 'PartiesStatusID', ["PartiesStatus","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->ClientStatusID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['ClientStatusID'] = &$this->ClientStatusID;

		// LitigantStatusID
		$this->LitigantStatusID = new DbField('caseslookupv', 'caseslookupv', 'x_LitigantStatusID', 'LitigantStatusID', '`LitigantStatusID`', '`LitigantStatusID`', 3, -1, FALSE, '`EV__LitigantStatusID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->LitigantStatusID->Nullable = FALSE; // NOT NULL field
		$this->LitigantStatusID->Required = TRUE; // Required field
		$this->LitigantStatusID->Sortable = TRUE; // Allow sort
		$this->LitigantStatusID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->LitigantStatusID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->LitigantStatusID->Lookup = new Lookup('LitigantStatusID', 'partiesstatus', TRUE, 'PartiesStatusID', ["PartiesStatus","","",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->LitigantStatusID->Lookup = new Lookup('LitigantStatusID', 'partiesstatus', TRUE, 'PartiesStatusID', ["PartiesStatus","","",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->LitigantStatusID->Lookup = new Lookup('LitigantStatusID', 'partiesstatus', TRUE, 'PartiesStatusID', ["PartiesStatus","","",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->LitigantStatusID->Lookup = new Lookup('LitigantStatusID', 'partiesstatus', TRUE, 'PartiesStatusID', ["PartiesStatus","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->LitigantStatusID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['LitigantStatusID'] = &$this->LitigantStatusID;

		// Case
		$this->_Case = new DbField('caseslookupv', 'caseslookupv', 'x__Case', 'Case', '`Case`', '`Case`', 200, -1, FALSE, '`Case`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_Case->Sortable = TRUE; // Allow sort
		$this->fields['Case'] = &$this->_Case;

		// CaseEn
		$this->CaseEn = new DbField('caseslookupv', 'caseslookupv', 'x_CaseEn', 'CaseEn', '`CaseEn`', '`CaseEn`', 200, -1, FALSE, '`CaseEn`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CaseEn->Sortable = FALSE; // Allow sort
		$this->fields['CaseEn'] = &$this->CaseEn;

		// JudgeID
		$this->JudgeID = new DbField('caseslookupv', 'caseslookupv', 'x_JudgeID', 'JudgeID', '`JudgeID`', '`JudgeID`', 3, -1, FALSE, '`EV__JudgeID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->JudgeID->Sortable = TRUE; // Allow sort
		$this->JudgeID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->JudgeID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->JudgeID->Lookup = new Lookup('JudgeID', 'judges', TRUE, 'JudgeID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->JudgeID->Lookup = new Lookup('JudgeID', 'judges', TRUE, 'JudgeID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->JudgeID->Lookup = new Lookup('JudgeID', 'judges', TRUE, 'JudgeID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->JudgeID->Lookup = new Lookup('JudgeID', 'judges', TRUE, 'JudgeID', ["FirstName","MiddleName","LastName",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->JudgeID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['JudgeID'] = &$this->JudgeID;

		// CaseSortID
		$this->CaseSortID = new DbField('caseslookupv', 'caseslookupv', 'x_CaseSortID', 'CaseSortID', '`CaseSortID`', '`CaseSortID`', 3, -1, FALSE, '`EV__CaseSortID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->CaseSortID->Nullable = FALSE; // NOT NULL field
		$this->CaseSortID->Sortable = TRUE; // Allow sort
		$this->CaseSortID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->CaseSortID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->CaseSortID->Lookup = new Lookup('CaseSortID', 'casesort', TRUE, 'CaseSortID', ["CaseSort","","",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->CaseSortID->Lookup = new Lookup('CaseSortID', 'casesort', TRUE, 'CaseSortID', ["CaseSort","","",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->CaseSortID->Lookup = new Lookup('CaseSortID', 'casesort', TRUE, 'CaseSortID', ["CaseSort","","",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->CaseSortID->Lookup = new Lookup('CaseSortID', 'casesort', TRUE, 'CaseSortID', ["CaseSort","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->CaseSortID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['CaseSortID'] = &$this->CaseSortID;

		// CaseRegisteredDate
		$this->CaseRegisteredDate = new DbField('caseslookupv', 'caseslookupv', 'x_CaseRegisteredDate', 'CaseRegisteredDate', '`CaseRegisteredDate`', CastDateFieldForLike('`CaseRegisteredDate`', 7, "DB"), 133, 7, FALSE, '`CaseRegisteredDate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CaseRegisteredDate->Sortable = TRUE; // Allow sort
		$this->CaseRegisteredDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['CaseRegisteredDate'] = &$this->CaseRegisteredDate;

		// CaseStatusID
		$this->CaseStatusID = new DbField('caseslookupv', 'caseslookupv', 'x_CaseStatusID', 'CaseStatusID', '`CaseStatusID`', '`CaseStatusID`', 3, -1, FALSE, '`EV__CaseStatusID`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->CaseStatusID->Nullable = FALSE; // NOT NULL field
		$this->CaseStatusID->Required = TRUE; // Required field
		$this->CaseStatusID->Sortable = TRUE; // Allow sort
		$this->CaseStatusID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->CaseStatusID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->CaseStatusID->Lookup = new Lookup('CaseStatusID', 'casestatus', TRUE, 'CaseStatusID', ["CaseStatus","","",""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->CaseStatusID->Lookup = new Lookup('CaseStatusID', 'casestatus', TRUE, 'CaseStatusID', ["CaseStatus","","",""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->CaseStatusID->Lookup = new Lookup('CaseStatusID', 'casestatus', TRUE, 'CaseStatusID', ["CaseStatus","","",""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->CaseStatusID->Lookup = new Lookup('CaseStatusID', 'casestatus', TRUE, 'CaseStatusID', ["CaseStatus","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->CaseStatusID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['CaseStatusID'] = &$this->CaseStatusID;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`caseslookupv`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		global $CurrentLanguage;
		switch ($CurrentLanguage) {
			case "ar":
				$select = "SELECT * FROM (" .
					"SELECT *, (SELECT CONCAT(COALESCE(`FirstName`, ''),'" . ValueSeparator(1, $this->ClientID) . "',COALESCE(`MiddleName`,''),'" . ValueSeparator(2, $this->ClientID) . "',COALESCE(`LastName`,'')) FROM `clients` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`ClientID` = `caseslookupv`.`ClientID` LIMIT 1) AS `EV__ClientID`, (SELECT CONCAT(COALESCE(`FirstName`, ''),'" . ValueSeparator(1, $this->LitigantID) . "',COALESCE(`MiddleName`,''),'" . ValueSeparator(2, $this->LitigantID) . "',COALESCE(`LastName`,'')) FROM `litigants` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`LitigantID` = `caseslookupv`.`LitigantID` LIMIT 1) AS `EV__LitigantID`, (SELECT DISTINCT `CaseType` FROM `casetypes` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CaseTypeID` = `caseslookupv`.`CaseTypeID` LIMIT 1) AS `EV__CaseTypeID`, (SELECT DISTINCT `Court` FROM `courts` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CourtID` = `caseslookupv`.`CourtID` LIMIT 1) AS `EV__CourtID`, (SELECT DISTINCT `PartiesStatus` FROM `partiesstatus` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`PartiesStatusID` = `caseslookupv`.`ClientStatusID` LIMIT 1) AS `EV__ClientStatusID`, (SELECT DISTINCT `PartiesStatus` FROM `partiesstatus` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`PartiesStatusID` = `caseslookupv`.`LitigantStatusID` LIMIT 1) AS `EV__LitigantStatusID`, (SELECT DISTINCT CONCAT(COALESCE(`FirstName`, ''),'" . ValueSeparator(1, $this->JudgeID) . "',COALESCE(`MiddleName`,''),'" . ValueSeparator(2, $this->JudgeID) . "',COALESCE(`LastName`,'')) FROM `judges` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`JudgeID` = `caseslookupv`.`JudgeID` LIMIT 1) AS `EV__JudgeID`, (SELECT DISTINCT `CaseSort` FROM `casesort` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CaseSortID` = `caseslookupv`.`CaseSortID` LIMIT 1) AS `EV__CaseSortID`, (SELECT DISTINCT `CaseStatus` FROM `casestatus` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CaseStatusID` = `caseslookupv`.`CaseStatusID` LIMIT 1) AS `EV__CaseStatusID` FROM `caseslookupv`" .
					") `TMP_TABLE`";
				break;
			case "en":
				$select = "SELECT * FROM (" .
					"SELECT *, (SELECT CONCAT(COALESCE(`FirstName`, ''),'" . ValueSeparator(1, $this->ClientID) . "',COALESCE(`MiddleName`,''),'" . ValueSeparator(2, $this->ClientID) . "',COALESCE(`LastName`,'')) FROM `clients` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`ClientID` = `caseslookupv`.`ClientID` LIMIT 1) AS `EV__ClientID`, (SELECT CONCAT(COALESCE(`FirstName`, ''),'" . ValueSeparator(1, $this->LitigantID) . "',COALESCE(`MiddleName`,''),'" . ValueSeparator(2, $this->LitigantID) . "',COALESCE(`LastName`,'')) FROM `litigants` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`LitigantID` = `caseslookupv`.`LitigantID` LIMIT 1) AS `EV__LitigantID`, (SELECT DISTINCT `CaseType` FROM `casetypes` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CaseTypeID` = `caseslookupv`.`CaseTypeID` LIMIT 1) AS `EV__CaseTypeID`, (SELECT DISTINCT `Court` FROM `courts` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CourtID` = `caseslookupv`.`CourtID` LIMIT 1) AS `EV__CourtID`, (SELECT DISTINCT `PartiesStatus` FROM `partiesstatus` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`PartiesStatusID` = `caseslookupv`.`ClientStatusID` LIMIT 1) AS `EV__ClientStatusID`, (SELECT DISTINCT `PartiesStatus` FROM `partiesstatus` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`PartiesStatusID` = `caseslookupv`.`LitigantStatusID` LIMIT 1) AS `EV__LitigantStatusID`, (SELECT DISTINCT CONCAT(COALESCE(`FirstName`, ''),'" . ValueSeparator(1, $this->JudgeID) . "',COALESCE(`MiddleName`,''),'" . ValueSeparator(2, $this->JudgeID) . "',COALESCE(`LastName`,'')) FROM `judges` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`JudgeID` = `caseslookupv`.`JudgeID` LIMIT 1) AS `EV__JudgeID`, (SELECT DISTINCT `CaseSort` FROM `casesort` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CaseSortID` = `caseslookupv`.`CaseSortID` LIMIT 1) AS `EV__CaseSortID`, (SELECT DISTINCT `CaseStatus` FROM `casestatus` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CaseStatusID` = `caseslookupv`.`CaseStatusID` LIMIT 1) AS `EV__CaseStatusID` FROM `caseslookupv`" .
					") `TMP_TABLE`";
				break;
			case "fr":
				$select = "SELECT * FROM (" .
					"SELECT *, (SELECT CONCAT(COALESCE(`FirstName`, ''),'" . ValueSeparator(1, $this->ClientID) . "',COALESCE(`MiddleName`,''),'" . ValueSeparator(2, $this->ClientID) . "',COALESCE(`LastName`,'')) FROM `clients` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`ClientID` = `caseslookupv`.`ClientID` LIMIT 1) AS `EV__ClientID`, (SELECT CONCAT(COALESCE(`FirstName`, ''),'" . ValueSeparator(1, $this->LitigantID) . "',COALESCE(`MiddleName`,''),'" . ValueSeparator(2, $this->LitigantID) . "',COALESCE(`LastName`,'')) FROM `litigants` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`LitigantID` = `caseslookupv`.`LitigantID` LIMIT 1) AS `EV__LitigantID`, (SELECT DISTINCT `CaseType` FROM `casetypes` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CaseTypeID` = `caseslookupv`.`CaseTypeID` LIMIT 1) AS `EV__CaseTypeID`, (SELECT DISTINCT `Court` FROM `courts` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CourtID` = `caseslookupv`.`CourtID` LIMIT 1) AS `EV__CourtID`, (SELECT DISTINCT `PartiesStatus` FROM `partiesstatus` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`PartiesStatusID` = `caseslookupv`.`ClientStatusID` LIMIT 1) AS `EV__ClientStatusID`, (SELECT DISTINCT `PartiesStatus` FROM `partiesstatus` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`PartiesStatusID` = `caseslookupv`.`LitigantStatusID` LIMIT 1) AS `EV__LitigantStatusID`, (SELECT DISTINCT CONCAT(COALESCE(`FirstName`, ''),'" . ValueSeparator(1, $this->JudgeID) . "',COALESCE(`MiddleName`,''),'" . ValueSeparator(2, $this->JudgeID) . "',COALESCE(`LastName`,'')) FROM `judges` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`JudgeID` = `caseslookupv`.`JudgeID` LIMIT 1) AS `EV__JudgeID`, (SELECT DISTINCT `CaseSort` FROM `casesort` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CaseSortID` = `caseslookupv`.`CaseSortID` LIMIT 1) AS `EV__CaseSortID`, (SELECT DISTINCT `CaseStatus` FROM `casestatus` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CaseStatusID` = `caseslookupv`.`CaseStatusID` LIMIT 1) AS `EV__CaseStatusID` FROM `caseslookupv`" .
					") `TMP_TABLE`";
				break;
			default:
				$select = "SELECT * FROM (" .
					"SELECT *, (SELECT CONCAT(COALESCE(`FirstName`, ''),'" . ValueSeparator(1, $this->ClientID) . "',COALESCE(`MiddleName`,''),'" . ValueSeparator(2, $this->ClientID) . "',COALESCE(`LastName`,'')) FROM `clients` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`ClientID` = `caseslookupv`.`ClientID` LIMIT 1) AS `EV__ClientID`, (SELECT CONCAT(COALESCE(`FirstName`, ''),'" . ValueSeparator(1, $this->LitigantID) . "',COALESCE(`MiddleName`,''),'" . ValueSeparator(2, $this->LitigantID) . "',COALESCE(`LastName`,'')) FROM `litigants` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`LitigantID` = `caseslookupv`.`LitigantID` LIMIT 1) AS `EV__LitigantID`, (SELECT DISTINCT `CaseType` FROM `casetypes` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CaseTypeID` = `caseslookupv`.`CaseTypeID` LIMIT 1) AS `EV__CaseTypeID`, (SELECT DISTINCT `Court` FROM `courts` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CourtID` = `caseslookupv`.`CourtID` LIMIT 1) AS `EV__CourtID`, (SELECT DISTINCT `PartiesStatus` FROM `partiesstatus` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`PartiesStatusID` = `caseslookupv`.`ClientStatusID` LIMIT 1) AS `EV__ClientStatusID`, (SELECT DISTINCT `PartiesStatus` FROM `partiesstatus` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`PartiesStatusID` = `caseslookupv`.`LitigantStatusID` LIMIT 1) AS `EV__LitigantStatusID`, (SELECT DISTINCT CONCAT(COALESCE(`FirstName`, ''),'" . ValueSeparator(1, $this->JudgeID) . "',COALESCE(`MiddleName`,''),'" . ValueSeparator(2, $this->JudgeID) . "',COALESCE(`LastName`,'')) FROM `judges` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`JudgeID` = `caseslookupv`.`JudgeID` LIMIT 1) AS `EV__JudgeID`, (SELECT DISTINCT `CaseSort` FROM `casesort` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CaseSortID` = `caseslookupv`.`CaseSortID` LIMIT 1) AS `EV__CaseSortID`, (SELECT DISTINCT `CaseStatus` FROM `casestatus` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`CaseStatusID` = `caseslookupv`.`CaseStatusID` LIMIT 1) AS `EV__CaseStatusID` FROM `caseslookupv`" .
					") `TMP_TABLE`";
				break;
		}
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->ClientID->AdvancedSearch->SearchValue <> "" ||
			$this->ClientID->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->ClientID->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->ClientID->VirtualExpression . " "))
			return TRUE;
		if ($this->LitigantID->AdvancedSearch->SearchValue <> "" ||
			$this->LitigantID->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->LitigantID->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->LitigantID->VirtualExpression . " "))
			return TRUE;
		if ($this->CaseTypeID->AdvancedSearch->SearchValue <> "" ||
			$this->CaseTypeID->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->CaseTypeID->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->CaseTypeID->VirtualExpression . " "))
			return TRUE;
		if ($this->CourtID->AdvancedSearch->SearchValue <> "" ||
			$this->CourtID->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->CourtID->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->CourtID->VirtualExpression . " "))
			return TRUE;
		if ($this->ClientStatusID->AdvancedSearch->SearchValue <> "" ||
			$this->ClientStatusID->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->ClientStatusID->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->ClientStatusID->VirtualExpression . " "))
			return TRUE;
		if ($this->LitigantStatusID->AdvancedSearch->SearchValue <> "" ||
			$this->LitigantStatusID->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->LitigantStatusID->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->LitigantStatusID->VirtualExpression . " "))
			return TRUE;
		if ($this->JudgeID->AdvancedSearch->SearchValue <> "" ||
			$this->JudgeID->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->JudgeID->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->JudgeID->VirtualExpression . " "))
			return TRUE;
		if ($this->CaseSortID->AdvancedSearch->SearchValue <> "" ||
			$this->CaseSortID->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->CaseSortID->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->CaseSortID->VirtualExpression . " "))
			return TRUE;
		if ($this->CaseStatusID->AdvancedSearch->SearchValue <> "" ||
			$this->CaseStatusID->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->CaseStatusID->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->CaseStatusID->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->CaseID->setDbValue($conn->insert_ID());
			$rs['CaseID'] = $this->CaseID->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('CaseID', $rs))
				AddFilter($where, QuotedName('CaseID', $this->Dbid) . '=' . QuotedValue($rs['CaseID'], $this->CaseID->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->CaseID->DbValue = $row['CaseID'];
		$this->ClientID->DbValue = $row['ClientID'];
		$this->LitigantID->DbValue = $row['LitigantID'];
		$this->CaseTypeID->DbValue = $row['CaseTypeID'];
		$this->CourtID->DbValue = $row['CourtID'];
		$this->CaseNumber->DbValue = $row['CaseNumber'];
		$this->FileNumber->DbValue = $row['FileNumber'];
		$this->EnvelopeNumber->DbValue = $row['EnvelopeNumber'];
		$this->ClientStatusID->DbValue = $row['ClientStatusID'];
		$this->LitigantStatusID->DbValue = $row['LitigantStatusID'];
		$this->_Case->DbValue = $row['Case'];
		$this->CaseEn->DbValue = $row['CaseEn'];
		$this->JudgeID->DbValue = $row['JudgeID'];
		$this->CaseSortID->DbValue = $row['CaseSortID'];
		$this->CaseRegisteredDate->DbValue = $row['CaseRegisteredDate'];
		$this->CaseStatusID->DbValue = $row['CaseStatusID'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`CaseID` = @CaseID@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('CaseID', $row) ? $row['CaseID'] : NULL) : $this->CaseID->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@CaseID@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "caseslookupvlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "caseslookupvview.php")
			return $Language->phrase("View");
		elseif ($pageName == "caseslookupvedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "caseslookupvadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "caseslookupvlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("caseslookupvview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("caseslookupvview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "caseslookupvadd.php?" . $this->getUrlParm($parm);
		else
			$url = "caseslookupvadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("caseslookupvedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("caseslookupvadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("caseslookupvdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "CaseID:" . JsonEncode($this->CaseID->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->CaseID->CurrentValue != NULL) {
			$url .= "CaseID=" . urlencode($this->CaseID->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("CaseID") !== NULL)
				$arKeys[] = Param("CaseID");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->CaseID->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->CaseID->setDbValue($rs->fields('CaseID'));
		$this->ClientID->setDbValue($rs->fields('ClientID'));
		$this->LitigantID->setDbValue($rs->fields('LitigantID'));
		$this->CaseTypeID->setDbValue($rs->fields('CaseTypeID'));
		$this->CourtID->setDbValue($rs->fields('CourtID'));
		$this->CaseNumber->setDbValue($rs->fields('CaseNumber'));
		$this->FileNumber->setDbValue($rs->fields('FileNumber'));
		$this->EnvelopeNumber->setDbValue($rs->fields('EnvelopeNumber'));
		$this->ClientStatusID->setDbValue($rs->fields('ClientStatusID'));
		$this->LitigantStatusID->setDbValue($rs->fields('LitigantStatusID'));
		$this->_Case->setDbValue($rs->fields('Case'));
		$this->CaseEn->setDbValue($rs->fields('CaseEn'));
		$this->JudgeID->setDbValue($rs->fields('JudgeID'));
		$this->CaseSortID->setDbValue($rs->fields('CaseSortID'));
		$this->CaseRegisteredDate->setDbValue($rs->fields('CaseRegisteredDate'));
		$this->CaseStatusID->setDbValue($rs->fields('CaseStatusID'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// CaseID
		// ClientID

		$this->ClientID->CellCssStyle = "min-width: 150px;";

		// LitigantID
		$this->LitigantID->CellCssStyle = "width: 250px; white-space: nowrap;";

		// CaseTypeID
		$this->CaseTypeID->CellCssStyle = "min-width: 120px;";

		// CourtID
		$this->CourtID->CellCssStyle = "width: 200px; white-space: nowrap;";

		// CaseNumber
		// FileNumber
		// EnvelopeNumber
		// ClientStatusID
		// LitigantStatusID
		// Case

		$this->_Case->CellCssStyle = "min-width: 180px;";

		// CaseEn
		$this->CaseEn->CellCssStyle = "white-space: nowrap;";

		// JudgeID
		$this->JudgeID->CellCssStyle = "min-width: 150px;";

		// CaseSortID
		// CaseRegisteredDate
		// CaseStatusID
		// CaseID

		$this->CaseID->ViewValue = $this->CaseID->CurrentValue;
		$this->CaseID->ViewCustomAttributes = "";

		// ClientID
		if ($this->ClientID->VirtualValue <> "") {
			$this->ClientID->ViewValue = $this->ClientID->VirtualValue;
		} else {
			$this->ClientID->ViewValue = $this->ClientID->CurrentValue;
		$curVal = strval($this->ClientID->CurrentValue);
		if ($curVal <> "") {
			$this->ClientID->ViewValue = $this->ClientID->lookupCacheOption($curVal);
			if ($this->ClientID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`ClientID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->ClientID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->ClientID->ViewValue = $this->ClientID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->ClientID->ViewValue = $this->ClientID->CurrentValue;
				}
			}
		} else {
			$this->ClientID->ViewValue = NULL;
		}
		}
		$this->ClientID->CssStyle = "font-weight: bold;";
		$this->ClientID->ViewCustomAttributes = "";

		// LitigantID
		if ($this->LitigantID->VirtualValue <> "") {
			$this->LitigantID->ViewValue = $this->LitigantID->VirtualValue;
		} else {
			$this->LitigantID->ViewValue = $this->LitigantID->CurrentValue;
		$curVal = strval($this->LitigantID->CurrentValue);
		if ($curVal <> "") {
			$this->LitigantID->ViewValue = $this->LitigantID->lookupCacheOption($curVal);
			if ($this->LitigantID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`LitigantID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->LitigantID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->LitigantID->ViewValue = $this->LitigantID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->LitigantID->ViewValue = $this->LitigantID->CurrentValue;
				}
			}
		} else {
			$this->LitigantID->ViewValue = NULL;
		}
		}
		$this->LitigantID->CssStyle = "font-weight: bold;";
		$this->LitigantID->ViewCustomAttributes = "";

		// CaseTypeID
		if ($this->CaseTypeID->VirtualValue <> "") {
			$this->CaseTypeID->ViewValue = $this->CaseTypeID->VirtualValue;
		} else {
		$curVal = strval($this->CaseTypeID->CurrentValue);
		if ($curVal <> "") {
			$this->CaseTypeID->ViewValue = $this->CaseTypeID->lookupCacheOption($curVal);
			if ($this->CaseTypeID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`CaseTypeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->CaseTypeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->CaseTypeID->ViewValue = $this->CaseTypeID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->CaseTypeID->ViewValue = $this->CaseTypeID->CurrentValue;
				}
			}
		} else {
			$this->CaseTypeID->ViewValue = NULL;
		}
		}
		$this->CaseTypeID->CssStyle = "font-style: italic;";
		$this->CaseTypeID->ViewCustomAttributes = "";

		// CourtID
		if ($this->CourtID->VirtualValue <> "") {
			$this->CourtID->ViewValue = $this->CourtID->VirtualValue;
		} else {
			$this->CourtID->ViewValue = $this->CourtID->CurrentValue;
		$curVal = strval($this->CourtID->CurrentValue);
		if ($curVal <> "") {
			$this->CourtID->ViewValue = $this->CourtID->lookupCacheOption($curVal);
			if ($this->CourtID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`CourtID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->CourtID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->CourtID->ViewValue = $this->CourtID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->CourtID->ViewValue = $this->CourtID->CurrentValue;
				}
			}
		} else {
			$this->CourtID->ViewValue = NULL;
		}
		}
		$this->CourtID->ViewCustomAttributes = "";

		// CaseNumber
		$this->CaseNumber->ViewValue = $this->CaseNumber->CurrentValue;
		$this->CaseNumber->ViewCustomAttributes = "";

		// FileNumber
		$this->FileNumber->ViewValue = $this->FileNumber->CurrentValue;
		$this->FileNumber->ViewCustomAttributes = "";

		// EnvelopeNumber
		$this->EnvelopeNumber->ViewValue = $this->EnvelopeNumber->CurrentValue;
		$this->EnvelopeNumber->ViewCustomAttributes = "";

		// ClientStatusID
		if ($this->ClientStatusID->VirtualValue <> "") {
			$this->ClientStatusID->ViewValue = $this->ClientStatusID->VirtualValue;
		} else {
		$curVal = strval($this->ClientStatusID->CurrentValue);
		if ($curVal <> "") {
			$this->ClientStatusID->ViewValue = $this->ClientStatusID->lookupCacheOption($curVal);
			if ($this->ClientStatusID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`PartiesStatusID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->ClientStatusID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->ClientStatusID->ViewValue = $this->ClientStatusID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->ClientStatusID->ViewValue = $this->ClientStatusID->CurrentValue;
				}
			}
		} else {
			$this->ClientStatusID->ViewValue = NULL;
		}
		}
		$this->ClientStatusID->CssStyle = "font-style: italic;";
		$this->ClientStatusID->ViewCustomAttributes = "";

		// LitigantStatusID
		if ($this->LitigantStatusID->VirtualValue <> "") {
			$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->VirtualValue;
		} else {
		$curVal = strval($this->LitigantStatusID->CurrentValue);
		if ($curVal <> "") {
			$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->lookupCacheOption($curVal);
			if ($this->LitigantStatusID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`PartiesStatusID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->LitigantStatusID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->LitigantStatusID->ViewValue = $this->LitigantStatusID->CurrentValue;
				}
			}
		} else {
			$this->LitigantStatusID->ViewValue = NULL;
		}
		}
		$this->LitigantStatusID->CssStyle = "font-style: italic;";
		$this->LitigantStatusID->ViewCustomAttributes = "";

		// Case
		$this->_Case->ViewValue = $this->_Case->CurrentValue;
		$this->_Case->ViewCustomAttributes = "";

		// CaseEn
		$this->CaseEn->ViewValue = $this->CaseEn->CurrentValue;
		$this->CaseEn->ViewCustomAttributes = "";

		// JudgeID
		if ($this->JudgeID->VirtualValue <> "") {
			$this->JudgeID->ViewValue = $this->JudgeID->VirtualValue;
		} else {
		$curVal = strval($this->JudgeID->CurrentValue);
		if ($curVal <> "") {
			$this->JudgeID->ViewValue = $this->JudgeID->lookupCacheOption($curVal);
			if ($this->JudgeID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`JudgeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->JudgeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->JudgeID->ViewValue = $this->JudgeID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->JudgeID->ViewValue = $this->JudgeID->CurrentValue;
				}
			}
		} else {
			$this->JudgeID->ViewValue = NULL;
		}
		}
		$this->JudgeID->ViewCustomAttributes = "";

		// CaseSortID
		if ($this->CaseSortID->VirtualValue <> "") {
			$this->CaseSortID->ViewValue = $this->CaseSortID->VirtualValue;
		} else {
		$curVal = strval($this->CaseSortID->CurrentValue);
		if ($curVal <> "") {
			$this->CaseSortID->ViewValue = $this->CaseSortID->lookupCacheOption($curVal);
			if ($this->CaseSortID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`CaseSortID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->CaseSortID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->CaseSortID->ViewValue = $this->CaseSortID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->CaseSortID->ViewValue = $this->CaseSortID->CurrentValue;
				}
			}
		} else {
			$this->CaseSortID->ViewValue = NULL;
		}
		}
		$this->CaseSortID->ViewCustomAttributes = "";

		// CaseRegisteredDate
		$this->CaseRegisteredDate->ViewValue = $this->CaseRegisteredDate->CurrentValue;
		$this->CaseRegisteredDate->ViewValue = FormatDateTime($this->CaseRegisteredDate->ViewValue, 7);
		$this->CaseRegisteredDate->ViewCustomAttributes = "";

		// CaseStatusID
		if ($this->CaseStatusID->VirtualValue <> "") {
			$this->CaseStatusID->ViewValue = $this->CaseStatusID->VirtualValue;
		} else {
		$curVal = strval($this->CaseStatusID->CurrentValue);
		if ($curVal <> "") {
			$this->CaseStatusID->ViewValue = $this->CaseStatusID->lookupCacheOption($curVal);
			if ($this->CaseStatusID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`CaseStatusID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->CaseStatusID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->CaseStatusID->ViewValue = $this->CaseStatusID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->CaseStatusID->ViewValue = $this->CaseStatusID->CurrentValue;
				}
			}
		} else {
			$this->CaseStatusID->ViewValue = NULL;
		}
		}
		$this->CaseStatusID->CssStyle = "font-style: italic;";
		$this->CaseStatusID->ViewCustomAttributes = "";

		// CaseID
		$this->CaseID->LinkCustomAttributes = "";
		$this->CaseID->HrefValue = "";
		$this->CaseID->TooltipValue = "";

		// ClientID
		$this->ClientID->LinkCustomAttributes = "";
		if (!EmptyValue($this->ClientID->CurrentValue)) {
			$this->ClientID->HrefValue = "/home/clientsview.php?showdetail=clientaddress,clientcontact,cases&ClientID=" . $this->ClientID->CurrentValue; // Add prefix/suffix
			$this->ClientID->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->ClientID->HrefValue = FullUrl($this->ClientID->HrefValue, "href");
		} else {
			$this->ClientID->HrefValue = "";
		}
		$this->ClientID->TooltipValue = "";

		// LitigantID
		$this->LitigantID->LinkCustomAttributes = "";
		if (!EmptyValue($this->LitigantID->CurrentValue)) {
			$this->LitigantID->HrefValue = "/home/litigantsview.php?showdetail=litigantaddress,litigantcontact,cases&LitigantID=" . $this->LitigantID->CurrentValue; // Add prefix/suffix
			$this->LitigantID->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->LitigantID->HrefValue = FullUrl($this->LitigantID->HrefValue, "href");
		} else {
			$this->LitigantID->HrefValue = "";
		}
		$this->LitigantID->TooltipValue = "";

		// CaseTypeID
		$this->CaseTypeID->LinkCustomAttributes = "";
		$this->CaseTypeID->HrefValue = "";
		$this->CaseTypeID->TooltipValue = "";

		// CourtID
		$this->CourtID->LinkCustomAttributes = "";
		if (!EmptyValue($this->CourtID->CurrentValue)) {
			$this->CourtID->HrefValue = "/home/courtsview.php?showdetail=courtaddress,courtcontact&CourtID=" . $this->CourtID->CurrentValue; // Add prefix/suffix
			$this->CourtID->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->CourtID->HrefValue = FullUrl($this->CourtID->HrefValue, "href");
		} else {
			$this->CourtID->HrefValue = "";
		}
		$this->CourtID->TooltipValue = "";

		// CaseNumber
		$this->CaseNumber->LinkCustomAttributes = "";
		$this->CaseNumber->HrefValue = "";
		$this->CaseNumber->TooltipValue = "";

		// FileNumber
		$this->FileNumber->LinkCustomAttributes = "";
		$this->FileNumber->HrefValue = "";
		$this->FileNumber->TooltipValue = "";

		// EnvelopeNumber
		$this->EnvelopeNumber->LinkCustomAttributes = "";
		$this->EnvelopeNumber->HrefValue = "";
		$this->EnvelopeNumber->TooltipValue = "";

		// ClientStatusID
		$this->ClientStatusID->LinkCustomAttributes = "";
		$this->ClientStatusID->HrefValue = "";
		$this->ClientStatusID->TooltipValue = "";

		// LitigantStatusID
		$this->LitigantStatusID->LinkCustomAttributes = "";
		$this->LitigantStatusID->HrefValue = "";
		$this->LitigantStatusID->TooltipValue = "";

		// Case
		$this->_Case->LinkCustomAttributes = "";
		$this->_Case->HrefValue = "";
		$this->_Case->TooltipValue = "";

		// CaseEn
		$this->CaseEn->LinkCustomAttributes = "";
		$this->CaseEn->HrefValue = "";
		$this->CaseEn->TooltipValue = "";

		// JudgeID
		$this->JudgeID->LinkCustomAttributes = "";
		if (!EmptyValue($this->JudgeID->CurrentValue)) {
			$this->JudgeID->HrefValue = "/home/judgesview.php?showdetail=judgecontact,judgeaddress&JudgeID=" . $this->JudgeID->CurrentValue; // Add prefix/suffix
			$this->JudgeID->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->JudgeID->HrefValue = FullUrl($this->JudgeID->HrefValue, "href");
		} else {
			$this->JudgeID->HrefValue = "";
		}
		$this->JudgeID->TooltipValue = "";

		// CaseSortID
		$this->CaseSortID->LinkCustomAttributes = "";
		$this->CaseSortID->HrefValue = "";
		$this->CaseSortID->TooltipValue = "";

		// CaseRegisteredDate
		$this->CaseRegisteredDate->LinkCustomAttributes = "";
		$this->CaseRegisteredDate->HrefValue = "";
		$this->CaseRegisteredDate->TooltipValue = "";

		// CaseStatusID
		$this->CaseStatusID->LinkCustomAttributes = "";
		$this->CaseStatusID->HrefValue = "";
		$this->CaseStatusID->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// CaseID
		$this->CaseID->EditAttrs["class"] = "form-control";
		$this->CaseID->EditCustomAttributes = "";

		// ClientID
		$this->ClientID->EditAttrs["class"] = "form-control";
		$this->ClientID->EditCustomAttributes = "";
		$this->ClientID->EditValue = $this->ClientID->CurrentValue;
		$this->ClientID->PlaceHolder = RemoveHtml($this->ClientID->caption());

		// LitigantID
		$this->LitigantID->EditAttrs["class"] = "form-control";
		$this->LitigantID->EditCustomAttributes = "";
		$this->LitigantID->EditValue = $this->LitigantID->CurrentValue;
		$this->LitigantID->PlaceHolder = RemoveHtml($this->LitigantID->caption());

		// CaseTypeID
		$this->CaseTypeID->EditAttrs["class"] = "form-control";
		$this->CaseTypeID->EditCustomAttributes = "";

		// CourtID
		$this->CourtID->EditAttrs["class"] = "form-control";
		$this->CourtID->EditCustomAttributes = "";
		$this->CourtID->EditValue = $this->CourtID->CurrentValue;
		$this->CourtID->PlaceHolder = RemoveHtml($this->CourtID->caption());

		// CaseNumber
		$this->CaseNumber->EditAttrs["class"] = "form-control";
		$this->CaseNumber->EditCustomAttributes = "";
		$this->CaseNumber->EditValue = $this->CaseNumber->CurrentValue;
		$this->CaseNumber->PlaceHolder = RemoveHtml($this->CaseNumber->caption());

		// FileNumber
		$this->FileNumber->EditAttrs["class"] = "form-control";
		$this->FileNumber->EditCustomAttributes = "";
		$this->FileNumber->EditValue = $this->FileNumber->CurrentValue;
		$this->FileNumber->PlaceHolder = RemoveHtml($this->FileNumber->caption());

		// EnvelopeNumber
		$this->EnvelopeNumber->EditAttrs["class"] = "form-control";
		$this->EnvelopeNumber->EditCustomAttributes = "";
		$this->EnvelopeNumber->EditValue = $this->EnvelopeNumber->CurrentValue;
		$this->EnvelopeNumber->PlaceHolder = RemoveHtml($this->EnvelopeNumber->caption());

		// ClientStatusID
		$this->ClientStatusID->EditAttrs["class"] = "form-control";
		$this->ClientStatusID->EditCustomAttributes = "";

		// LitigantStatusID
		$this->LitigantStatusID->EditAttrs["class"] = "form-control";
		$this->LitigantStatusID->EditCustomAttributes = "";

		// Case
		$this->_Case->EditAttrs["class"] = "form-control";
		$this->_Case->EditCustomAttributes = "";
		$this->_Case->EditValue = $this->_Case->CurrentValue;
		$this->_Case->PlaceHolder = RemoveHtml($this->_Case->caption());

		// CaseEn
		$this->CaseEn->EditAttrs["class"] = "form-control";
		$this->CaseEn->EditCustomAttributes = "";
		$this->CaseEn->EditValue = $this->CaseEn->CurrentValue;
		$this->CaseEn->PlaceHolder = RemoveHtml($this->CaseEn->caption());

		// JudgeID
		$this->JudgeID->EditAttrs["class"] = "form-control";
		$this->JudgeID->EditCustomAttributes = "";

		// CaseSortID
		$this->CaseSortID->EditAttrs["class"] = "form-control";
		$this->CaseSortID->EditCustomAttributes = "";

		// CaseRegisteredDate
		$this->CaseRegisteredDate->EditAttrs["class"] = "form-control";
		$this->CaseRegisteredDate->EditCustomAttributes = "";
		$this->CaseRegisteredDate->EditValue = FormatDateTime($this->CaseRegisteredDate->CurrentValue, 7);
		$this->CaseRegisteredDate->PlaceHolder = RemoveHtml($this->CaseRegisteredDate->caption());

		// CaseStatusID
		$this->CaseStatusID->EditAttrs["class"] = "form-control";
		$this->CaseStatusID->EditCustomAttributes = "";

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->CaseID);
					$doc->exportCaption($this->ClientID);
					$doc->exportCaption($this->LitigantID);
					$doc->exportCaption($this->CaseTypeID);
					$doc->exportCaption($this->CourtID);
					$doc->exportCaption($this->CaseNumber);
					$doc->exportCaption($this->FileNumber);
					$doc->exportCaption($this->EnvelopeNumber);
					$doc->exportCaption($this->ClientStatusID);
					$doc->exportCaption($this->LitigantStatusID);
					$doc->exportCaption($this->_Case);
					$doc->exportCaption($this->JudgeID);
					$doc->exportCaption($this->CaseSortID);
					$doc->exportCaption($this->CaseRegisteredDate);
					$doc->exportCaption($this->CaseStatusID);
				} else {
					$doc->exportCaption($this->CaseID);
					$doc->exportCaption($this->ClientID);
					$doc->exportCaption($this->LitigantID);
					$doc->exportCaption($this->CaseTypeID);
					$doc->exportCaption($this->CourtID);
					$doc->exportCaption($this->CaseNumber);
					$doc->exportCaption($this->FileNumber);
					$doc->exportCaption($this->EnvelopeNumber);
					$doc->exportCaption($this->ClientStatusID);
					$doc->exportCaption($this->LitigantStatusID);
					$doc->exportCaption($this->_Case);
					$doc->exportCaption($this->JudgeID);
					$doc->exportCaption($this->CaseSortID);
					$doc->exportCaption($this->CaseRegisteredDate);
					$doc->exportCaption($this->CaseStatusID);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->CaseID);
						$doc->exportField($this->ClientID);
						$doc->exportField($this->LitigantID);
						$doc->exportField($this->CaseTypeID);
						$doc->exportField($this->CourtID);
						$doc->exportField($this->CaseNumber);
						$doc->exportField($this->FileNumber);
						$doc->exportField($this->EnvelopeNumber);
						$doc->exportField($this->ClientStatusID);
						$doc->exportField($this->LitigantStatusID);
						$doc->exportField($this->_Case);
						$doc->exportField($this->JudgeID);
						$doc->exportField($this->CaseSortID);
						$doc->exportField($this->CaseRegisteredDate);
						$doc->exportField($this->CaseStatusID);
					} else {
						$doc->exportField($this->CaseID);
						$doc->exportField($this->ClientID);
						$doc->exportField($this->LitigantID);
						$doc->exportField($this->CaseTypeID);
						$doc->exportField($this->CourtID);
						$doc->exportField($this->CaseNumber);
						$doc->exportField($this->FileNumber);
						$doc->exportField($this->EnvelopeNumber);
						$doc->exportField($this->ClientStatusID);
						$doc->exportField($this->LitigantStatusID);
						$doc->exportField($this->_Case);
						$doc->exportField($this->JudgeID);
						$doc->exportField($this->CaseSortID);
						$doc->exportField($this->CaseRegisteredDate);
						$doc->exportField($this->CaseStatusID);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		if (!$validRequest)
			return FALSE;

		// Load lookup parameters
		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>
