<?php
namespace PHPMaker2019\project_germanos;

/**
 * Table class for courtsv
 */
class courtsv extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $courttypeCourtTypeID;
	public $CourtType;
	public $CourtTypeEn;
	public $CourtTypeNotes;
	public $courtLocationCourtLocationID;
	public $CourtLocation;
	public $CourtLocationEn;
	public $CourtLocationGovernorateID;
	public $CourtLocationNotes;
	public $governoratesGovernorateID;
	public $Governorate;
	public $GovernorateEn;
	public $GovernoratesNotes;
	public $ChambersChamberID;
	public $Chamber;
	public $ChamberEn;
	public $chambersNotes;
	public $ChambersActivated;
	public $sectionsSectionID;
	public $Section;
	public $SectionEn;
	public $SectionsNotes;
	public $SectionsActivated;
	public $CourtID;
	public $Court;
	public $CourtEn;
	public $CourtTypeID;
	public $ChamberID;
	public $CourtLocationID;
	public $GovernorateID;
	public $SectionID;
	public $AddressID;
	public $ContactID;
	public $Activated;
	public $Notes;
	public $_UserID;
	public $CreatedBy;
	public $CreatedDate;
	public $UpdatedBy;
	public $UpdatedDate;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'courtsv';
		$this->TableName = 'courtsv';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`courtsv`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// courttypeCourtTypeID
		$this->courttypeCourtTypeID = new DbField('courtsv', 'courtsv', 'x_courttypeCourtTypeID', 'courttypeCourtTypeID', '`courttypeCourtTypeID`', '`courttypeCourtTypeID`', 3, -1, FALSE, '`courttypeCourtTypeID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->courttypeCourtTypeID->IsAutoIncrement = TRUE; // Autoincrement field
		$this->courttypeCourtTypeID->IsPrimaryKey = TRUE; // Primary key field
		$this->courttypeCourtTypeID->Sortable = TRUE; // Allow sort
		$this->courttypeCourtTypeID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['courttypeCourtTypeID'] = &$this->courttypeCourtTypeID;

		// CourtType
		$this->CourtType = new DbField('courtsv', 'courtsv', 'x_CourtType', 'CourtType', '`CourtType`', '`CourtType`', 200, -1, FALSE, '`CourtType`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CourtType->Required = TRUE; // Required field
		$this->CourtType->Sortable = TRUE; // Allow sort
		$this->fields['CourtType'] = &$this->CourtType;

		// CourtTypeEn
		$this->CourtTypeEn = new DbField('courtsv', 'courtsv', 'x_CourtTypeEn', 'CourtTypeEn', '`CourtTypeEn`', '`CourtTypeEn`', 200, -1, FALSE, '`CourtTypeEn`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CourtTypeEn->Required = TRUE; // Required field
		$this->CourtTypeEn->Sortable = TRUE; // Allow sort
		$this->fields['CourtTypeEn'] = &$this->CourtTypeEn;

		// CourtTypeNotes
		$this->CourtTypeNotes = new DbField('courtsv', 'courtsv', 'x_CourtTypeNotes', 'CourtTypeNotes', '`CourtTypeNotes`', '`CourtTypeNotes`', 200, -1, FALSE, '`CourtTypeNotes`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CourtTypeNotes->Sortable = TRUE; // Allow sort
		$this->fields['CourtTypeNotes'] = &$this->CourtTypeNotes;

		// courtLocationCourtLocationID
		$this->courtLocationCourtLocationID = new DbField('courtsv', 'courtsv', 'x_courtLocationCourtLocationID', 'courtLocationCourtLocationID', '`courtLocationCourtLocationID`', '`courtLocationCourtLocationID`', 3, -1, FALSE, '`courtLocationCourtLocationID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->courtLocationCourtLocationID->IsAutoIncrement = TRUE; // Autoincrement field
		$this->courtLocationCourtLocationID->IsPrimaryKey = TRUE; // Primary key field
		$this->courtLocationCourtLocationID->Sortable = TRUE; // Allow sort
		$this->courtLocationCourtLocationID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['courtLocationCourtLocationID'] = &$this->courtLocationCourtLocationID;

		// CourtLocation
		$this->CourtLocation = new DbField('courtsv', 'courtsv', 'x_CourtLocation', 'CourtLocation', '`CourtLocation`', '`CourtLocation`', 200, -1, FALSE, '`CourtLocation`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CourtLocation->Required = TRUE; // Required field
		$this->CourtLocation->Sortable = TRUE; // Allow sort
		$this->fields['CourtLocation'] = &$this->CourtLocation;

		// CourtLocationEn
		$this->CourtLocationEn = new DbField('courtsv', 'courtsv', 'x_CourtLocationEn', 'CourtLocationEn', '`CourtLocationEn`', '`CourtLocationEn`', 200, -1, FALSE, '`CourtLocationEn`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CourtLocationEn->Required = TRUE; // Required field
		$this->CourtLocationEn->Sortable = TRUE; // Allow sort
		$this->fields['CourtLocationEn'] = &$this->CourtLocationEn;

		// CourtLocationGovernorateID
		$this->CourtLocationGovernorateID = new DbField('courtsv', 'courtsv', 'x_CourtLocationGovernorateID', 'CourtLocationGovernorateID', '`CourtLocationGovernorateID`', '`CourtLocationGovernorateID`', 3, -1, FALSE, '`CourtLocationGovernorateID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CourtLocationGovernorateID->Required = TRUE; // Required field
		$this->CourtLocationGovernorateID->Sortable = TRUE; // Allow sort
		$this->CourtLocationGovernorateID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['CourtLocationGovernorateID'] = &$this->CourtLocationGovernorateID;

		// CourtLocationNotes
		$this->CourtLocationNotes = new DbField('courtsv', 'courtsv', 'x_CourtLocationNotes', 'CourtLocationNotes', '`CourtLocationNotes`', '`CourtLocationNotes`', 200, -1, FALSE, '`CourtLocationNotes`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CourtLocationNotes->Sortable = TRUE; // Allow sort
		$this->fields['CourtLocationNotes'] = &$this->CourtLocationNotes;

		// governoratesGovernorateID
		$this->governoratesGovernorateID = new DbField('courtsv', 'courtsv', 'x_governoratesGovernorateID', 'governoratesGovernorateID', '`governoratesGovernorateID`', '`governoratesGovernorateID`', 3, -1, FALSE, '`governoratesGovernorateID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->governoratesGovernorateID->IsAutoIncrement = TRUE; // Autoincrement field
		$this->governoratesGovernorateID->IsPrimaryKey = TRUE; // Primary key field
		$this->governoratesGovernorateID->Sortable = TRUE; // Allow sort
		$this->governoratesGovernorateID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['governoratesGovernorateID'] = &$this->governoratesGovernorateID;

		// Governorate
		$this->Governorate = new DbField('courtsv', 'courtsv', 'x_Governorate', 'Governorate', '`Governorate`', '`Governorate`', 200, -1, FALSE, '`Governorate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Governorate->Required = TRUE; // Required field
		$this->Governorate->Sortable = TRUE; // Allow sort
		$this->fields['Governorate'] = &$this->Governorate;

		// GovernorateEn
		$this->GovernorateEn = new DbField('courtsv', 'courtsv', 'x_GovernorateEn', 'GovernorateEn', '`GovernorateEn`', '`GovernorateEn`', 200, -1, FALSE, '`GovernorateEn`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->GovernorateEn->Required = TRUE; // Required field
		$this->GovernorateEn->Sortable = TRUE; // Allow sort
		$this->fields['GovernorateEn'] = &$this->GovernorateEn;

		// GovernoratesNotes
		$this->GovernoratesNotes = new DbField('courtsv', 'courtsv', 'x_GovernoratesNotes', 'GovernoratesNotes', '`GovernoratesNotes`', '`GovernoratesNotes`', 200, -1, FALSE, '`GovernoratesNotes`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->GovernoratesNotes->Sortable = TRUE; // Allow sort
		$this->fields['GovernoratesNotes'] = &$this->GovernoratesNotes;

		// ChambersChamberID
		$this->ChambersChamberID = new DbField('courtsv', 'courtsv', 'x_ChambersChamberID', 'ChambersChamberID', '`ChambersChamberID`', '`ChambersChamberID`', 3, -1, FALSE, '`ChambersChamberID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->ChambersChamberID->IsAutoIncrement = TRUE; // Autoincrement field
		$this->ChambersChamberID->IsPrimaryKey = TRUE; // Primary key field
		$this->ChambersChamberID->Sortable = TRUE; // Allow sort
		$this->ChambersChamberID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['ChambersChamberID'] = &$this->ChambersChamberID;

		// Chamber
		$this->Chamber = new DbField('courtsv', 'courtsv', 'x_Chamber', 'Chamber', '`Chamber`', '`Chamber`', 200, -1, FALSE, '`Chamber`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Chamber->Required = TRUE; // Required field
		$this->Chamber->Sortable = TRUE; // Allow sort
		$this->fields['Chamber'] = &$this->Chamber;

		// ChamberEn
		$this->ChamberEn = new DbField('courtsv', 'courtsv', 'x_ChamberEn', 'ChamberEn', '`ChamberEn`', '`ChamberEn`', 200, -1, FALSE, '`ChamberEn`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ChamberEn->Sortable = TRUE; // Allow sort
		$this->fields['ChamberEn'] = &$this->ChamberEn;

		// chambersNotes
		$this->chambersNotes = new DbField('courtsv', 'courtsv', 'x_chambersNotes', 'chambersNotes', '`chambersNotes`', '`chambersNotes`', 201, -1, FALSE, '`chambersNotes`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->chambersNotes->Sortable = TRUE; // Allow sort
		$this->fields['chambersNotes'] = &$this->chambersNotes;

		// ChambersActivated
		$this->ChambersActivated = new DbField('courtsv', 'courtsv', 'x_ChambersActivated', 'ChambersActivated', '`ChambersActivated`', '`ChambersActivated`', 202, -1, FALSE, '`ChambersActivated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->ChambersActivated->Sortable = TRUE; // Allow sort
		$this->ChambersActivated->DataType = DATATYPE_BOOLEAN;
		$this->ChambersActivated->TrueValue = 'Y';
		$this->ChambersActivated->FalseValue = 'N';
		switch ($CurrentLanguage) {
			case "ar":
				$this->ChambersActivated->Lookup = new Lookup('ChambersActivated', 'courtsv', FALSE, '', [null,null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->ChambersActivated->Lookup = new Lookup('ChambersActivated', 'courtsv', FALSE, '', [null,null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->ChambersActivated->Lookup = new Lookup('ChambersActivated', 'courtsv', FALSE, '', [null,null,null,""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->ChambersActivated->Lookup = new Lookup('ChambersActivated', 'courtsv', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->ChambersActivated->OptionCount = 2;
		$this->fields['ChambersActivated'] = &$this->ChambersActivated;

		// sectionsSectionID
		$this->sectionsSectionID = new DbField('courtsv', 'courtsv', 'x_sectionsSectionID', 'sectionsSectionID', '`sectionsSectionID`', '`sectionsSectionID`', 3, -1, FALSE, '`sectionsSectionID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->sectionsSectionID->IsAutoIncrement = TRUE; // Autoincrement field
		$this->sectionsSectionID->IsPrimaryKey = TRUE; // Primary key field
		$this->sectionsSectionID->Sortable = TRUE; // Allow sort
		$this->sectionsSectionID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['sectionsSectionID'] = &$this->sectionsSectionID;

		// Section
		$this->Section = new DbField('courtsv', 'courtsv', 'x_Section', 'Section', '`Section`', '`Section`', 200, -1, FALSE, '`Section`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Section->Required = TRUE; // Required field
		$this->Section->Sortable = TRUE; // Allow sort
		$this->fields['Section'] = &$this->Section;

		// SectionEn
		$this->SectionEn = new DbField('courtsv', 'courtsv', 'x_SectionEn', 'SectionEn', '`SectionEn`', '`SectionEn`', 200, -1, FALSE, '`SectionEn`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->SectionEn->Sortable = TRUE; // Allow sort
		$this->fields['SectionEn'] = &$this->SectionEn;

		// SectionsNotes
		$this->SectionsNotes = new DbField('courtsv', 'courtsv', 'x_SectionsNotes', 'SectionsNotes', '`SectionsNotes`', '`SectionsNotes`', 201, -1, FALSE, '`SectionsNotes`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->SectionsNotes->Sortable = TRUE; // Allow sort
		$this->fields['SectionsNotes'] = &$this->SectionsNotes;

		// SectionsActivated
		$this->SectionsActivated = new DbField('courtsv', 'courtsv', 'x_SectionsActivated', 'SectionsActivated', '`SectionsActivated`', '`SectionsActivated`', 202, -1, FALSE, '`SectionsActivated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->SectionsActivated->Sortable = TRUE; // Allow sort
		$this->SectionsActivated->DataType = DATATYPE_BOOLEAN;
		$this->SectionsActivated->TrueValue = 'Y';
		$this->SectionsActivated->FalseValue = 'N';
		switch ($CurrentLanguage) {
			case "ar":
				$this->SectionsActivated->Lookup = new Lookup('SectionsActivated', 'courtsv', FALSE, '', [null,null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->SectionsActivated->Lookup = new Lookup('SectionsActivated', 'courtsv', FALSE, '', [null,null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->SectionsActivated->Lookup = new Lookup('SectionsActivated', 'courtsv', FALSE, '', [null,null,null,""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->SectionsActivated->Lookup = new Lookup('SectionsActivated', 'courtsv', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->SectionsActivated->OptionCount = 2;
		$this->fields['SectionsActivated'] = &$this->SectionsActivated;

		// CourtID
		$this->CourtID = new DbField('courtsv', 'courtsv', 'x_CourtID', 'CourtID', '`CourtID`', '`CourtID`', 3, -1, FALSE, '`CourtID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->CourtID->IsAutoIncrement = TRUE; // Autoincrement field
		$this->CourtID->IsPrimaryKey = TRUE; // Primary key field
		$this->CourtID->Sortable = TRUE; // Allow sort
		$this->CourtID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['CourtID'] = &$this->CourtID;

		// Court
		$this->Court = new DbField('courtsv', 'courtsv', 'x_Court', 'Court', '`Court`', '`Court`', 200, -1, FALSE, '`Court`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Court->Nullable = FALSE; // NOT NULL field
		$this->Court->Required = TRUE; // Required field
		$this->Court->Sortable = TRUE; // Allow sort
		$this->fields['Court'] = &$this->Court;

		// CourtEn
		$this->CourtEn = new DbField('courtsv', 'courtsv', 'x_CourtEn', 'CourtEn', '`CourtEn`', '`CourtEn`', 200, -1, FALSE, '`CourtEn`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CourtEn->Sortable = TRUE; // Allow sort
		$this->fields['CourtEn'] = &$this->CourtEn;

		// CourtTypeID
		$this->CourtTypeID = new DbField('courtsv', 'courtsv', 'x_CourtTypeID', 'CourtTypeID', '`CourtTypeID`', '`CourtTypeID`', 3, -1, FALSE, '`CourtTypeID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->CourtTypeID->Nullable = FALSE; // NOT NULL field
		$this->CourtTypeID->Required = TRUE; // Required field
		$this->CourtTypeID->Sortable = TRUE; // Allow sort
		$this->CourtTypeID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->CourtTypeID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->CourtTypeID->Lookup = new Lookup('CourtTypeID', 'courttype', FALSE, 'CourtTypeID', ["CourtType",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->CourtTypeID->Lookup = new Lookup('CourtTypeID', 'courttype', FALSE, 'CourtTypeID', ["CourtTypeEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->CourtTypeID->Lookup = new Lookup('CourtTypeID', 'courttype', FALSE, 'CourtTypeID', ["CourtTypeEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->CourtTypeID->Lookup = new Lookup('CourtTypeID', 'courttype', FALSE, 'CourtTypeID', ["CourtType","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->CourtTypeID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['CourtTypeID'] = &$this->CourtTypeID;

		// ChamberID
		$this->ChamberID = new DbField('courtsv', 'courtsv', 'x_ChamberID', 'ChamberID', '`ChamberID`', '`ChamberID`', 3, -1, FALSE, '`ChamberID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->ChamberID->Sortable = TRUE; // Allow sort
		$this->ChamberID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->ChamberID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->ChamberID->Lookup = new Lookup('ChamberID', 'chambers', FALSE, 'ChamberID', ["Chamber",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->ChamberID->Lookup = new Lookup('ChamberID', 'chambers', FALSE, 'ChamberID', ["ChamberEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->ChamberID->Lookup = new Lookup('ChamberID', 'chambers', FALSE, 'ChamberID', ["ChamberEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->ChamberID->Lookup = new Lookup('ChamberID', 'chambers', FALSE, 'ChamberID', ["Chamber","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->ChamberID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['ChamberID'] = &$this->ChamberID;

		// CourtLocationID
		$this->CourtLocationID = new DbField('courtsv', 'courtsv', 'x_CourtLocationID', 'CourtLocationID', '`CourtLocationID`', '`CourtLocationID`', 3, -1, FALSE, '`CourtLocationID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->CourtLocationID->Sortable = TRUE; // Allow sort
		$this->CourtLocationID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->CourtLocationID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->CourtLocationID->Lookup = new Lookup('CourtLocationID', 'courtlocation', FALSE, 'CourtLocationID', ["CourtLocation",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->CourtLocationID->Lookup = new Lookup('CourtLocationID', 'courtlocation', FALSE, 'CourtLocationID', ["CourtLocationEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->CourtLocationID->Lookup = new Lookup('CourtLocationID', 'courtlocation', FALSE, 'CourtLocationID', ["CourtLocationEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->CourtLocationID->Lookup = new Lookup('CourtLocationID', 'courtlocation', FALSE, 'CourtLocationID', ["CourtLocation","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->CourtLocationID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['CourtLocationID'] = &$this->CourtLocationID;

		// GovernorateID
		$this->GovernorateID = new DbField('courtsv', 'courtsv', 'x_GovernorateID', 'GovernorateID', '`GovernorateID`', '`GovernorateID`', 3, -1, FALSE, '`GovernorateID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->GovernorateID->Sortable = TRUE; // Allow sort
		$this->GovernorateID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->GovernorateID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->GovernorateID->Lookup = new Lookup('GovernorateID', 'governorates', FALSE, 'GovernorateID', ["Governorate",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->GovernorateID->Lookup = new Lookup('GovernorateID', 'governorates', FALSE, 'GovernorateID', ["GovernorateEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->GovernorateID->Lookup = new Lookup('GovernorateID', 'governorates', FALSE, 'GovernorateID', ["GovernorateEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->GovernorateID->Lookup = new Lookup('GovernorateID', 'governorates', FALSE, 'GovernorateID', ["Governorate","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->GovernorateID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['GovernorateID'] = &$this->GovernorateID;

		// SectionID
		$this->SectionID = new DbField('courtsv', 'courtsv', 'x_SectionID', 'SectionID', '`SectionID`', '`SectionID`', 3, -1, FALSE, '`SectionID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->SectionID->Sortable = TRUE; // Allow sort
		$this->SectionID->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->SectionID->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		switch ($CurrentLanguage) {
			case "ar":
				$this->SectionID->Lookup = new Lookup('SectionID', 'sections', FALSE, 'SectionID', ["Section",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->SectionID->Lookup = new Lookup('SectionID', 'sections', FALSE, 'SectionID', ["SectionEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->SectionID->Lookup = new Lookup('SectionID', 'sections', FALSE, 'SectionID', ["SectionEn",null,null,""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->SectionID->Lookup = new Lookup('SectionID', 'sections', FALSE, 'SectionID', ["Section","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->SectionID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['SectionID'] = &$this->SectionID;

		// AddressID
		$this->AddressID = new DbField('courtsv', 'courtsv', 'x_AddressID', 'AddressID', '`AddressID`', '`AddressID`', 3, -1, FALSE, '`AddressID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->AddressID->Sortable = TRUE; // Allow sort
		$this->AddressID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['AddressID'] = &$this->AddressID;

		// ContactID
		$this->ContactID = new DbField('courtsv', 'courtsv', 'x_ContactID', 'ContactID', '`ContactID`', '`ContactID`', 3, -1, FALSE, '`ContactID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ContactID->Sortable = TRUE; // Allow sort
		$this->ContactID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['ContactID'] = &$this->ContactID;

		// Activated
		$this->Activated = new DbField('courtsv', 'courtsv', 'x_Activated', 'Activated', '`Activated`', '`Activated`', 202, -1, FALSE, '`Activated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->Activated->Nullable = FALSE; // NOT NULL field
		$this->Activated->Sortable = TRUE; // Allow sort
		$this->Activated->DataType = DATATYPE_BOOLEAN;
		$this->Activated->TrueValue = 'Y';
		$this->Activated->FalseValue = 'N';
		switch ($CurrentLanguage) {
			case "ar":
				$this->Activated->Lookup = new Lookup('Activated', 'courtsv', FALSE, '', [null,null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "en":
				$this->Activated->Lookup = new Lookup('Activated', 'courtsv', FALSE, '', [null,null,null,""], [], [], [], [], [], [], '', '');
				break;
			case "fr":
				$this->Activated->Lookup = new Lookup('Activated', 'courtsv', FALSE, '', [null,null,null,""], [], [], [], [], [], [], '', '');
				break;
			default:
				$this->Activated->Lookup = new Lookup('Activated', 'courtsv', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
				break;
		}
		$this->Activated->OptionCount = 2;
		$this->fields['Activated'] = &$this->Activated;

		// Notes
		$this->Notes = new DbField('courtsv', 'courtsv', 'x_Notes', 'Notes', '`Notes`', '`Notes`', 201, -1, FALSE, '`Notes`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->Notes->Sortable = TRUE; // Allow sort
		$this->fields['Notes'] = &$this->Notes;

		// UserID
		$this->_UserID = new DbField('courtsv', 'courtsv', 'x__UserID', 'UserID', '`UserID`', '`UserID`', 3, -1, FALSE, '`UserID`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_UserID->Sortable = FALSE; // Allow sort
		$this->_UserID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['UserID'] = &$this->_UserID;

		// CreatedBy
		$this->CreatedBy = new DbField('courtsv', 'courtsv', 'x_CreatedBy', 'CreatedBy', '`CreatedBy`', '`CreatedBy`', 200, -1, FALSE, '`CreatedBy`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CreatedBy->Sortable = FALSE; // Allow sort
		$this->fields['CreatedBy'] = &$this->CreatedBy;

		// CreatedDate
		$this->CreatedDate = new DbField('courtsv', 'courtsv', 'x_CreatedDate', 'CreatedDate', '`CreatedDate`', CastDateFieldForLike('`CreatedDate`', 0, "DB"), 135, 0, FALSE, '`CreatedDate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->CreatedDate->Sortable = FALSE; // Allow sort
		$this->CreatedDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['CreatedDate'] = &$this->CreatedDate;

		// UpdatedBy
		$this->UpdatedBy = new DbField('courtsv', 'courtsv', 'x_UpdatedBy', 'UpdatedBy', '`UpdatedBy`', '`UpdatedBy`', 200, -1, FALSE, '`UpdatedBy`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->UpdatedBy->Sortable = FALSE; // Allow sort
		$this->fields['UpdatedBy'] = &$this->UpdatedBy;

		// UpdatedDate
		$this->UpdatedDate = new DbField('courtsv', 'courtsv', 'x_UpdatedDate', 'UpdatedDate', '`UpdatedDate`', CastDateFieldForLike('`UpdatedDate`', 0, "DB"), 135, 0, FALSE, '`UpdatedDate`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->UpdatedDate->Sortable = FALSE; // Allow sort
		$this->UpdatedDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['UpdatedDate'] = &$this->UpdatedDate;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`courtsv`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->courttypeCourtTypeID->setDbValue($conn->insert_ID());
			$rs['courttypeCourtTypeID'] = $this->courttypeCourtTypeID->DbValue;

			// Get insert id if necessary
			$this->courtLocationCourtLocationID->setDbValue($conn->insert_ID());
			$rs['courtLocationCourtLocationID'] = $this->courtLocationCourtLocationID->DbValue;

			// Get insert id if necessary
			$this->governoratesGovernorateID->setDbValue($conn->insert_ID());
			$rs['governoratesGovernorateID'] = $this->governoratesGovernorateID->DbValue;

			// Get insert id if necessary
			$this->ChambersChamberID->setDbValue($conn->insert_ID());
			$rs['ChambersChamberID'] = $this->ChambersChamberID->DbValue;

			// Get insert id if necessary
			$this->sectionsSectionID->setDbValue($conn->insert_ID());
			$rs['sectionsSectionID'] = $this->sectionsSectionID->DbValue;

			// Get insert id if necessary
			$this->CourtID->setDbValue($conn->insert_ID());
			$rs['CourtID'] = $this->CourtID->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('courttypeCourtTypeID', $rs))
				AddFilter($where, QuotedName('courttypeCourtTypeID', $this->Dbid) . '=' . QuotedValue($rs['courttypeCourtTypeID'], $this->courttypeCourtTypeID->DataType, $this->Dbid));
			if (array_key_exists('courtLocationCourtLocationID', $rs))
				AddFilter($where, QuotedName('courtLocationCourtLocationID', $this->Dbid) . '=' . QuotedValue($rs['courtLocationCourtLocationID'], $this->courtLocationCourtLocationID->DataType, $this->Dbid));
			if (array_key_exists('governoratesGovernorateID', $rs))
				AddFilter($where, QuotedName('governoratesGovernorateID', $this->Dbid) . '=' . QuotedValue($rs['governoratesGovernorateID'], $this->governoratesGovernorateID->DataType, $this->Dbid));
			if (array_key_exists('ChambersChamberID', $rs))
				AddFilter($where, QuotedName('ChambersChamberID', $this->Dbid) . '=' . QuotedValue($rs['ChambersChamberID'], $this->ChambersChamberID->DataType, $this->Dbid));
			if (array_key_exists('sectionsSectionID', $rs))
				AddFilter($where, QuotedName('sectionsSectionID', $this->Dbid) . '=' . QuotedValue($rs['sectionsSectionID'], $this->sectionsSectionID->DataType, $this->Dbid));
			if (array_key_exists('CourtID', $rs))
				AddFilter($where, QuotedName('CourtID', $this->Dbid) . '=' . QuotedValue($rs['CourtID'], $this->CourtID->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->courttypeCourtTypeID->DbValue = $row['courttypeCourtTypeID'];
		$this->CourtType->DbValue = $row['CourtType'];
		$this->CourtTypeEn->DbValue = $row['CourtTypeEn'];
		$this->CourtTypeNotes->DbValue = $row['CourtTypeNotes'];
		$this->courtLocationCourtLocationID->DbValue = $row['courtLocationCourtLocationID'];
		$this->CourtLocation->DbValue = $row['CourtLocation'];
		$this->CourtLocationEn->DbValue = $row['CourtLocationEn'];
		$this->CourtLocationGovernorateID->DbValue = $row['CourtLocationGovernorateID'];
		$this->CourtLocationNotes->DbValue = $row['CourtLocationNotes'];
		$this->governoratesGovernorateID->DbValue = $row['governoratesGovernorateID'];
		$this->Governorate->DbValue = $row['Governorate'];
		$this->GovernorateEn->DbValue = $row['GovernorateEn'];
		$this->GovernoratesNotes->DbValue = $row['GovernoratesNotes'];
		$this->ChambersChamberID->DbValue = $row['ChambersChamberID'];
		$this->Chamber->DbValue = $row['Chamber'];
		$this->ChamberEn->DbValue = $row['ChamberEn'];
		$this->chambersNotes->DbValue = $row['chambersNotes'];
		$this->ChambersActivated->DbValue = $row['ChambersActivated'];
		$this->sectionsSectionID->DbValue = $row['sectionsSectionID'];
		$this->Section->DbValue = $row['Section'];
		$this->SectionEn->DbValue = $row['SectionEn'];
		$this->SectionsNotes->DbValue = $row['SectionsNotes'];
		$this->SectionsActivated->DbValue = $row['SectionsActivated'];
		$this->CourtID->DbValue = $row['CourtID'];
		$this->Court->DbValue = $row['Court'];
		$this->CourtEn->DbValue = $row['CourtEn'];
		$this->CourtTypeID->DbValue = $row['CourtTypeID'];
		$this->ChamberID->DbValue = $row['ChamberID'];
		$this->CourtLocationID->DbValue = $row['CourtLocationID'];
		$this->GovernorateID->DbValue = $row['GovernorateID'];
		$this->SectionID->DbValue = $row['SectionID'];
		$this->AddressID->DbValue = $row['AddressID'];
		$this->ContactID->DbValue = $row['ContactID'];
		$this->Activated->DbValue = $row['Activated'];
		$this->Notes->DbValue = $row['Notes'];
		$this->_UserID->DbValue = $row['UserID'];
		$this->CreatedBy->DbValue = $row['CreatedBy'];
		$this->CreatedDate->DbValue = $row['CreatedDate'];
		$this->UpdatedBy->DbValue = $row['UpdatedBy'];
		$this->UpdatedDate->DbValue = $row['UpdatedDate'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`courttypeCourtTypeID` = @courttypeCourtTypeID@ AND `courtLocationCourtLocationID` = @courtLocationCourtLocationID@ AND `governoratesGovernorateID` = @governoratesGovernorateID@ AND `ChambersChamberID` = @ChambersChamberID@ AND `sectionsSectionID` = @sectionsSectionID@ AND `CourtID` = @CourtID@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('courttypeCourtTypeID', $row) ? $row['courttypeCourtTypeID'] : NULL) : $this->courttypeCourtTypeID->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@courttypeCourtTypeID@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		$val = is_array($row) ? (array_key_exists('courtLocationCourtLocationID', $row) ? $row['courtLocationCourtLocationID'] : NULL) : $this->courtLocationCourtLocationID->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@courtLocationCourtLocationID@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		$val = is_array($row) ? (array_key_exists('governoratesGovernorateID', $row) ? $row['governoratesGovernorateID'] : NULL) : $this->governoratesGovernorateID->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@governoratesGovernorateID@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		$val = is_array($row) ? (array_key_exists('ChambersChamberID', $row) ? $row['ChambersChamberID'] : NULL) : $this->ChambersChamberID->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@ChambersChamberID@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		$val = is_array($row) ? (array_key_exists('sectionsSectionID', $row) ? $row['sectionsSectionID'] : NULL) : $this->sectionsSectionID->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@sectionsSectionID@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		$val = is_array($row) ? (array_key_exists('CourtID', $row) ? $row['CourtID'] : NULL) : $this->CourtID->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@CourtID@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "courtsvlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "courtsvview.php")
			return $Language->phrase("View");
		elseif ($pageName == "courtsvedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "courtsvadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "courtsvlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("courtsvview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("courtsvview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "courtsvadd.php?" . $this->getUrlParm($parm);
		else
			$url = "courtsvadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("courtsvedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("courtsvadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("courtsvdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "courttypeCourtTypeID:" . JsonEncode($this->courttypeCourtTypeID->CurrentValue, "number");
		$json .= ",courtLocationCourtLocationID:" . JsonEncode($this->courtLocationCourtLocationID->CurrentValue, "number");
		$json .= ",governoratesGovernorateID:" . JsonEncode($this->governoratesGovernorateID->CurrentValue, "number");
		$json .= ",ChambersChamberID:" . JsonEncode($this->ChambersChamberID->CurrentValue, "number");
		$json .= ",sectionsSectionID:" . JsonEncode($this->sectionsSectionID->CurrentValue, "number");
		$json .= ",CourtID:" . JsonEncode($this->CourtID->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->courttypeCourtTypeID->CurrentValue != NULL) {
			$url .= "courttypeCourtTypeID=" . urlencode($this->courttypeCourtTypeID->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->courtLocationCourtLocationID->CurrentValue != NULL) {
			$url .= "&courtLocationCourtLocationID=" . urlencode($this->courtLocationCourtLocationID->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->governoratesGovernorateID->CurrentValue != NULL) {
			$url .= "&governoratesGovernorateID=" . urlencode($this->governoratesGovernorateID->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->ChambersChamberID->CurrentValue != NULL) {
			$url .= "&ChambersChamberID=" . urlencode($this->ChambersChamberID->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->sectionsSectionID->CurrentValue != NULL) {
			$url .= "&sectionsSectionID=" . urlencode($this->sectionsSectionID->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->CourtID->CurrentValue != NULL) {
			$url .= "&CourtID=" . urlencode($this->CourtID->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
			for ($i = 0; $i < $cnt; $i++)
				$arKeys[$i] = explode($COMPOSITE_KEY_SEPARATOR, $arKeys[$i]);
		} else {
			if (Param("courttypeCourtTypeID") !== NULL)
				$arKey[] = Param("courttypeCourtTypeID");
			elseif (IsApi() && Key(0) !== NULL)
				$arKey[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKey[] = Route(2);
			else
				$arKeys = NULL; // Do not setup
			if (Param("courtLocationCourtLocationID") !== NULL)
				$arKey[] = Param("courtLocationCourtLocationID");
			elseif (IsApi() && Key(1) !== NULL)
				$arKey[] = Key(1);
			elseif (IsApi() && Route(3) !== NULL)
				$arKey[] = Route(3);
			else
				$arKeys = NULL; // Do not setup
			if (Param("governoratesGovernorateID") !== NULL)
				$arKey[] = Param("governoratesGovernorateID");
			elseif (IsApi() && Key(2) !== NULL)
				$arKey[] = Key(2);
			elseif (IsApi() && Route(4) !== NULL)
				$arKey[] = Route(4);
			else
				$arKeys = NULL; // Do not setup
			if (Param("ChambersChamberID") !== NULL)
				$arKey[] = Param("ChambersChamberID");
			elseif (IsApi() && Key(3) !== NULL)
				$arKey[] = Key(3);
			elseif (IsApi() && Route(5) !== NULL)
				$arKey[] = Route(5);
			else
				$arKeys = NULL; // Do not setup
			if (Param("sectionsSectionID") !== NULL)
				$arKey[] = Param("sectionsSectionID");
			elseif (IsApi() && Key(4) !== NULL)
				$arKey[] = Key(4);
			elseif (IsApi() && Route(6) !== NULL)
				$arKey[] = Route(6);
			else
				$arKeys = NULL; // Do not setup
			if (Param("CourtID") !== NULL)
				$arKey[] = Param("CourtID");
			elseif (IsApi() && Key(5) !== NULL)
				$arKey[] = Key(5);
			elseif (IsApi() && Route(7) !== NULL)
				$arKey[] = Route(7);
			else
				$arKeys = NULL; // Do not setup
			if (is_array($arKeys)) $arKeys[] = $arKey;

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_array($key) || count($key) <> 6)
					continue; // Just skip so other keys will still work
				if (!is_numeric($key[0])) // courttypeCourtTypeID
					continue;
				if (!is_numeric($key[1])) // courtLocationCourtLocationID
					continue;
				if (!is_numeric($key[2])) // governoratesGovernorateID
					continue;
				if (!is_numeric($key[3])) // ChambersChamberID
					continue;
				if (!is_numeric($key[4])) // sectionsSectionID
					continue;
				if (!is_numeric($key[5])) // CourtID
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->courttypeCourtTypeID->CurrentValue = $key[0];
			$this->courtLocationCourtLocationID->CurrentValue = $key[1];
			$this->governoratesGovernorateID->CurrentValue = $key[2];
			$this->ChambersChamberID->CurrentValue = $key[3];
			$this->sectionsSectionID->CurrentValue = $key[4];
			$this->CourtID->CurrentValue = $key[5];
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->courttypeCourtTypeID->setDbValue($rs->fields('courttypeCourtTypeID'));
		$this->CourtType->setDbValue($rs->fields('CourtType'));
		$this->CourtTypeEn->setDbValue($rs->fields('CourtTypeEn'));
		$this->CourtTypeNotes->setDbValue($rs->fields('CourtTypeNotes'));
		$this->courtLocationCourtLocationID->setDbValue($rs->fields('courtLocationCourtLocationID'));
		$this->CourtLocation->setDbValue($rs->fields('CourtLocation'));
		$this->CourtLocationEn->setDbValue($rs->fields('CourtLocationEn'));
		$this->CourtLocationGovernorateID->setDbValue($rs->fields('CourtLocationGovernorateID'));
		$this->CourtLocationNotes->setDbValue($rs->fields('CourtLocationNotes'));
		$this->governoratesGovernorateID->setDbValue($rs->fields('governoratesGovernorateID'));
		$this->Governorate->setDbValue($rs->fields('Governorate'));
		$this->GovernorateEn->setDbValue($rs->fields('GovernorateEn'));
		$this->GovernoratesNotes->setDbValue($rs->fields('GovernoratesNotes'));
		$this->ChambersChamberID->setDbValue($rs->fields('ChambersChamberID'));
		$this->Chamber->setDbValue($rs->fields('Chamber'));
		$this->ChamberEn->setDbValue($rs->fields('ChamberEn'));
		$this->chambersNotes->setDbValue($rs->fields('chambersNotes'));
		$this->ChambersActivated->setDbValue($rs->fields('ChambersActivated'));
		$this->sectionsSectionID->setDbValue($rs->fields('sectionsSectionID'));
		$this->Section->setDbValue($rs->fields('Section'));
		$this->SectionEn->setDbValue($rs->fields('SectionEn'));
		$this->SectionsNotes->setDbValue($rs->fields('SectionsNotes'));
		$this->SectionsActivated->setDbValue($rs->fields('SectionsActivated'));
		$this->CourtID->setDbValue($rs->fields('CourtID'));
		$this->Court->setDbValue($rs->fields('Court'));
		$this->CourtEn->setDbValue($rs->fields('CourtEn'));
		$this->CourtTypeID->setDbValue($rs->fields('CourtTypeID'));
		$this->ChamberID->setDbValue($rs->fields('ChamberID'));
		$this->CourtLocationID->setDbValue($rs->fields('CourtLocationID'));
		$this->GovernorateID->setDbValue($rs->fields('GovernorateID'));
		$this->SectionID->setDbValue($rs->fields('SectionID'));
		$this->AddressID->setDbValue($rs->fields('AddressID'));
		$this->ContactID->setDbValue($rs->fields('ContactID'));
		$this->Activated->setDbValue($rs->fields('Activated'));
		$this->Notes->setDbValue($rs->fields('Notes'));
		$this->_UserID->setDbValue($rs->fields('UserID'));
		$this->CreatedBy->setDbValue($rs->fields('CreatedBy'));
		$this->CreatedDate->setDbValue($rs->fields('CreatedDate'));
		$this->UpdatedBy->setDbValue($rs->fields('UpdatedBy'));
		$this->UpdatedDate->setDbValue($rs->fields('UpdatedDate'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// courttypeCourtTypeID
		// CourtType
		// CourtTypeEn
		// CourtTypeNotes
		// courtLocationCourtLocationID
		// CourtLocation
		// CourtLocationEn
		// CourtLocationGovernorateID
		// CourtLocationNotes
		// governoratesGovernorateID
		// Governorate
		// GovernorateEn
		// GovernoratesNotes
		// ChambersChamberID
		// Chamber
		// ChamberEn
		// chambersNotes
		// ChambersActivated
		// sectionsSectionID
		// Section
		// SectionEn
		// SectionsNotes
		// SectionsActivated
		// CourtID
		// Court
		// CourtEn
		// CourtTypeID
		// ChamberID
		// CourtLocationID
		// GovernorateID
		// SectionID
		// AddressID
		// ContactID
		// Activated
		// Notes

		$this->Notes->CellCssStyle = "white-space: nowrap;";

		// UserID
		$this->_UserID->CellCssStyle = "white-space: nowrap;";

		// CreatedBy
		$this->CreatedBy->CellCssStyle = "white-space: nowrap;";

		// CreatedDate
		$this->CreatedDate->CellCssStyle = "white-space: nowrap;";

		// UpdatedBy
		$this->UpdatedBy->CellCssStyle = "white-space: nowrap;";

		// UpdatedDate
		$this->UpdatedDate->CellCssStyle = "white-space: nowrap;";

		// courttypeCourtTypeID
		$this->courttypeCourtTypeID->ViewValue = $this->courttypeCourtTypeID->CurrentValue;
		$this->courttypeCourtTypeID->ViewCustomAttributes = "";

		// CourtType
		$this->CourtType->ViewValue = $this->CourtType->CurrentValue;
		$this->CourtType->ViewCustomAttributes = "";

		// CourtTypeEn
		$this->CourtTypeEn->ViewValue = $this->CourtTypeEn->CurrentValue;
		$this->CourtTypeEn->ViewCustomAttributes = "";

		// CourtTypeNotes
		$this->CourtTypeNotes->ViewValue = $this->CourtTypeNotes->CurrentValue;
		$this->CourtTypeNotes->ViewCustomAttributes = "";

		// courtLocationCourtLocationID
		$this->courtLocationCourtLocationID->ViewValue = $this->courtLocationCourtLocationID->CurrentValue;
		$this->courtLocationCourtLocationID->ViewCustomAttributes = "";

		// CourtLocation
		$this->CourtLocation->ViewValue = $this->CourtLocation->CurrentValue;
		$this->CourtLocation->ViewCustomAttributes = "";

		// CourtLocationEn
		$this->CourtLocationEn->ViewValue = $this->CourtLocationEn->CurrentValue;
		$this->CourtLocationEn->ViewCustomAttributes = "";

		// CourtLocationGovernorateID
		$this->CourtLocationGovernorateID->ViewValue = $this->CourtLocationGovernorateID->CurrentValue;
		$this->CourtLocationGovernorateID->ViewValue = FormatNumber($this->CourtLocationGovernorateID->ViewValue, 0, -2, -2, -2);
		$this->CourtLocationGovernorateID->ViewCustomAttributes = "";

		// CourtLocationNotes
		$this->CourtLocationNotes->ViewValue = $this->CourtLocationNotes->CurrentValue;
		$this->CourtLocationNotes->ViewCustomAttributes = "";

		// governoratesGovernorateID
		$this->governoratesGovernorateID->ViewValue = $this->governoratesGovernorateID->CurrentValue;
		$this->governoratesGovernorateID->ViewCustomAttributes = "";

		// Governorate
		$this->Governorate->ViewValue = $this->Governorate->CurrentValue;
		$this->Governorate->ViewCustomAttributes = "";

		// GovernorateEn
		$this->GovernorateEn->ViewValue = $this->GovernorateEn->CurrentValue;
		$this->GovernorateEn->ViewCustomAttributes = "";

		// GovernoratesNotes
		$this->GovernoratesNotes->ViewValue = $this->GovernoratesNotes->CurrentValue;
		$this->GovernoratesNotes->ViewCustomAttributes = "";

		// ChambersChamberID
		$this->ChambersChamberID->ViewValue = $this->ChambersChamberID->CurrentValue;
		$this->ChambersChamberID->ViewCustomAttributes = "";

		// Chamber
		$this->Chamber->ViewValue = $this->Chamber->CurrentValue;
		$this->Chamber->ViewCustomAttributes = "";

		// ChamberEn
		$this->ChamberEn->ViewValue = $this->ChamberEn->CurrentValue;
		$this->ChamberEn->ViewCustomAttributes = "";

		// chambersNotes
		$this->chambersNotes->ViewValue = $this->chambersNotes->CurrentValue;
		$this->chambersNotes->ViewCustomAttributes = "";

		// ChambersActivated
		if (ConvertToBool($this->ChambersActivated->CurrentValue)) {
			$this->ChambersActivated->ViewValue = $this->ChambersActivated->tagCaption(1) <> "" ? $this->ChambersActivated->tagCaption(1) : "Y";
		} else {
			$this->ChambersActivated->ViewValue = $this->ChambersActivated->tagCaption(2) <> "" ? $this->ChambersActivated->tagCaption(2) : "N";
		}
		$this->ChambersActivated->ViewCustomAttributes = "";

		// sectionsSectionID
		$this->sectionsSectionID->ViewValue = $this->sectionsSectionID->CurrentValue;
		$this->sectionsSectionID->ViewCustomAttributes = "";

		// Section
		$this->Section->ViewValue = $this->Section->CurrentValue;
		$this->Section->ViewCustomAttributes = "";

		// SectionEn
		$this->SectionEn->ViewValue = $this->SectionEn->CurrentValue;
		$this->SectionEn->ViewCustomAttributes = "";

		// SectionsNotes
		$this->SectionsNotes->ViewValue = $this->SectionsNotes->CurrentValue;
		$this->SectionsNotes->ViewCustomAttributes = "";

		// SectionsActivated
		if (ConvertToBool($this->SectionsActivated->CurrentValue)) {
			$this->SectionsActivated->ViewValue = $this->SectionsActivated->tagCaption(1) <> "" ? $this->SectionsActivated->tagCaption(1) : "Y";
		} else {
			$this->SectionsActivated->ViewValue = $this->SectionsActivated->tagCaption(2) <> "" ? $this->SectionsActivated->tagCaption(2) : "N";
		}
		$this->SectionsActivated->ViewCustomAttributes = "";

		// CourtID
		$this->CourtID->ViewValue = $this->CourtID->CurrentValue;
		$this->CourtID->ViewCustomAttributes = "";

		// Court
		$this->Court->ViewValue = $this->Court->CurrentValue;
		$this->Court->ViewCustomAttributes = "";

		// CourtEn
		$this->CourtEn->ViewValue = $this->CourtEn->CurrentValue;
		$this->CourtEn->ViewCustomAttributes = "";

		// CourtTypeID
		$curVal = strval($this->CourtTypeID->CurrentValue);
		if ($curVal <> "") {
			$this->CourtTypeID->ViewValue = $this->CourtTypeID->lookupCacheOption($curVal);
			if ($this->CourtTypeID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`CourtTypeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->CourtTypeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->CourtTypeID->ViewValue = $this->CourtTypeID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->CourtTypeID->ViewValue = $this->CourtTypeID->CurrentValue;
				}
			}
		} else {
			$this->CourtTypeID->ViewValue = NULL;
		}
		$this->CourtTypeID->ViewCustomAttributes = "";

		// ChamberID
		$curVal = strval($this->ChamberID->CurrentValue);
		if ($curVal <> "") {
			$this->ChamberID->ViewValue = $this->ChamberID->lookupCacheOption($curVal);
			if ($this->ChamberID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`ChamberID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->ChamberID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->ChamberID->ViewValue = $this->ChamberID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->ChamberID->ViewValue = $this->ChamberID->CurrentValue;
				}
			}
		} else {
			$this->ChamberID->ViewValue = NULL;
		}
		$this->ChamberID->ViewCustomAttributes = "";

		// CourtLocationID
		$curVal = strval($this->CourtLocationID->CurrentValue);
		if ($curVal <> "") {
			$this->CourtLocationID->ViewValue = $this->CourtLocationID->lookupCacheOption($curVal);
			if ($this->CourtLocationID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`CourtLocationID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->CourtLocationID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->CourtLocationID->ViewValue = $this->CourtLocationID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->CourtLocationID->ViewValue = $this->CourtLocationID->CurrentValue;
				}
			}
		} else {
			$this->CourtLocationID->ViewValue = NULL;
		}
		$this->CourtLocationID->ViewCustomAttributes = "";

		// GovernorateID
		$curVal = strval($this->GovernorateID->CurrentValue);
		if ($curVal <> "") {
			$this->GovernorateID->ViewValue = $this->GovernorateID->lookupCacheOption($curVal);
			if ($this->GovernorateID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`GovernorateID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->GovernorateID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->GovernorateID->ViewValue = $this->GovernorateID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->GovernorateID->ViewValue = $this->GovernorateID->CurrentValue;
				}
			}
		} else {
			$this->GovernorateID->ViewValue = NULL;
		}
		$this->GovernorateID->ViewCustomAttributes = "";

		// SectionID
		$curVal = strval($this->SectionID->CurrentValue);
		if ($curVal <> "") {
			$this->SectionID->ViewValue = $this->SectionID->lookupCacheOption($curVal);
			if ($this->SectionID->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`SectionID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->SectionID->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->SectionID->ViewValue = $this->SectionID->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->SectionID->ViewValue = $this->SectionID->CurrentValue;
				}
			}
		} else {
			$this->SectionID->ViewValue = NULL;
		}
		$this->SectionID->ViewCustomAttributes = "";

		// AddressID
		$this->AddressID->ViewValue = $this->AddressID->CurrentValue;
		$this->AddressID->ViewValue = FormatNumber($this->AddressID->ViewValue, 0, -2, -2, -2);
		$this->AddressID->ViewCustomAttributes = "";

		// ContactID
		$this->ContactID->ViewValue = $this->ContactID->CurrentValue;
		$this->ContactID->ViewValue = FormatNumber($this->ContactID->ViewValue, 0, -2, -2, -2);
		$this->ContactID->ViewCustomAttributes = "";

		// Activated
		if (ConvertToBool($this->Activated->CurrentValue)) {
			$this->Activated->ViewValue = $this->Activated->tagCaption(1) <> "" ? $this->Activated->tagCaption(1) : "Y";
		} else {
			$this->Activated->ViewValue = $this->Activated->tagCaption(2) <> "" ? $this->Activated->tagCaption(2) : "N";
		}
		$this->Activated->ViewCustomAttributes = "";

		// Notes
		$this->Notes->ViewValue = $this->Notes->CurrentValue;
		$this->Notes->ViewCustomAttributes = "";

		// UserID
		$this->_UserID->ViewValue = $this->_UserID->CurrentValue;
		$this->_UserID->ViewValue = FormatNumber($this->_UserID->ViewValue, 0, -2, -2, -2);
		$this->_UserID->ViewCustomAttributes = "";

		// CreatedBy
		$this->CreatedBy->ViewValue = $this->CreatedBy->CurrentValue;
		$this->CreatedBy->ViewCustomAttributes = "";

		// CreatedDate
		$this->CreatedDate->ViewValue = $this->CreatedDate->CurrentValue;
		$this->CreatedDate->ViewValue = FormatDateTime($this->CreatedDate->ViewValue, 0);
		$this->CreatedDate->ViewCustomAttributes = "";

		// UpdatedBy
		$this->UpdatedBy->ViewValue = $this->UpdatedBy->CurrentValue;
		$this->UpdatedBy->ViewCustomAttributes = "";

		// UpdatedDate
		$this->UpdatedDate->ViewValue = $this->UpdatedDate->CurrentValue;
		$this->UpdatedDate->ViewValue = FormatDateTime($this->UpdatedDate->ViewValue, 0);
		$this->UpdatedDate->ViewCustomAttributes = "";

		// courttypeCourtTypeID
		$this->courttypeCourtTypeID->LinkCustomAttributes = "";
		$this->courttypeCourtTypeID->HrefValue = "";
		$this->courttypeCourtTypeID->TooltipValue = "";

		// CourtType
		$this->CourtType->LinkCustomAttributes = "";
		$this->CourtType->HrefValue = "";
		$this->CourtType->TooltipValue = "";

		// CourtTypeEn
		$this->CourtTypeEn->LinkCustomAttributes = "";
		$this->CourtTypeEn->HrefValue = "";
		$this->CourtTypeEn->TooltipValue = "";

		// CourtTypeNotes
		$this->CourtTypeNotes->LinkCustomAttributes = "";
		$this->CourtTypeNotes->HrefValue = "";
		$this->CourtTypeNotes->TooltipValue = "";

		// courtLocationCourtLocationID
		$this->courtLocationCourtLocationID->LinkCustomAttributes = "";
		$this->courtLocationCourtLocationID->HrefValue = "";
		$this->courtLocationCourtLocationID->TooltipValue = "";

		// CourtLocation
		$this->CourtLocation->LinkCustomAttributes = "";
		$this->CourtLocation->HrefValue = "";
		$this->CourtLocation->TooltipValue = "";

		// CourtLocationEn
		$this->CourtLocationEn->LinkCustomAttributes = "";
		$this->CourtLocationEn->HrefValue = "";
		$this->CourtLocationEn->TooltipValue = "";

		// CourtLocationGovernorateID
		$this->CourtLocationGovernorateID->LinkCustomAttributes = "";
		$this->CourtLocationGovernorateID->HrefValue = "";
		$this->CourtLocationGovernorateID->TooltipValue = "";

		// CourtLocationNotes
		$this->CourtLocationNotes->LinkCustomAttributes = "";
		$this->CourtLocationNotes->HrefValue = "";
		$this->CourtLocationNotes->TooltipValue = "";

		// governoratesGovernorateID
		$this->governoratesGovernorateID->LinkCustomAttributes = "";
		$this->governoratesGovernorateID->HrefValue = "";
		$this->governoratesGovernorateID->TooltipValue = "";

		// Governorate
		$this->Governorate->LinkCustomAttributes = "";
		$this->Governorate->HrefValue = "";
		$this->Governorate->TooltipValue = "";

		// GovernorateEn
		$this->GovernorateEn->LinkCustomAttributes = "";
		$this->GovernorateEn->HrefValue = "";
		$this->GovernorateEn->TooltipValue = "";

		// GovernoratesNotes
		$this->GovernoratesNotes->LinkCustomAttributes = "";
		$this->GovernoratesNotes->HrefValue = "";
		$this->GovernoratesNotes->TooltipValue = "";

		// ChambersChamberID
		$this->ChambersChamberID->LinkCustomAttributes = "";
		$this->ChambersChamberID->HrefValue = "";
		$this->ChambersChamberID->TooltipValue = "";

		// Chamber
		$this->Chamber->LinkCustomAttributes = "";
		$this->Chamber->HrefValue = "";
		$this->Chamber->TooltipValue = "";

		// ChamberEn
		$this->ChamberEn->LinkCustomAttributes = "";
		$this->ChamberEn->HrefValue = "";
		$this->ChamberEn->TooltipValue = "";

		// chambersNotes
		$this->chambersNotes->LinkCustomAttributes = "";
		$this->chambersNotes->HrefValue = "";
		$this->chambersNotes->TooltipValue = "";

		// ChambersActivated
		$this->ChambersActivated->LinkCustomAttributes = "";
		$this->ChambersActivated->HrefValue = "";
		$this->ChambersActivated->TooltipValue = "";

		// sectionsSectionID
		$this->sectionsSectionID->LinkCustomAttributes = "";
		$this->sectionsSectionID->HrefValue = "";
		$this->sectionsSectionID->TooltipValue = "";

		// Section
		$this->Section->LinkCustomAttributes = "";
		$this->Section->HrefValue = "";
		$this->Section->TooltipValue = "";

		// SectionEn
		$this->SectionEn->LinkCustomAttributes = "";
		$this->SectionEn->HrefValue = "";
		$this->SectionEn->TooltipValue = "";

		// SectionsNotes
		$this->SectionsNotes->LinkCustomAttributes = "";
		$this->SectionsNotes->HrefValue = "";
		$this->SectionsNotes->TooltipValue = "";

		// SectionsActivated
		$this->SectionsActivated->LinkCustomAttributes = "";
		$this->SectionsActivated->HrefValue = "";
		$this->SectionsActivated->TooltipValue = "";

		// CourtID
		$this->CourtID->LinkCustomAttributes = "";
		$this->CourtID->HrefValue = "";
		$this->CourtID->TooltipValue = "";

		// Court
		$this->Court->LinkCustomAttributes = "";
		$this->Court->HrefValue = "";
		$this->Court->TooltipValue = "";

		// CourtEn
		$this->CourtEn->LinkCustomAttributes = "";
		$this->CourtEn->HrefValue = "";
		$this->CourtEn->TooltipValue = "";

		// CourtTypeID
		$this->CourtTypeID->LinkCustomAttributes = "";
		$this->CourtTypeID->HrefValue = "";
		$this->CourtTypeID->TooltipValue = "";

		// ChamberID
		$this->ChamberID->LinkCustomAttributes = "";
		$this->ChamberID->HrefValue = "";
		$this->ChamberID->TooltipValue = "";

		// CourtLocationID
		$this->CourtLocationID->LinkCustomAttributes = "";
		$this->CourtLocationID->HrefValue = "";
		$this->CourtLocationID->TooltipValue = "";

		// GovernorateID
		$this->GovernorateID->LinkCustomAttributes = "";
		$this->GovernorateID->HrefValue = "";
		$this->GovernorateID->TooltipValue = "";

		// SectionID
		$this->SectionID->LinkCustomAttributes = "";
		$this->SectionID->HrefValue = "";
		$this->SectionID->TooltipValue = "";

		// AddressID
		$this->AddressID->LinkCustomAttributes = "";
		$this->AddressID->HrefValue = "";
		$this->AddressID->TooltipValue = "";

		// ContactID
		$this->ContactID->LinkCustomAttributes = "";
		$this->ContactID->HrefValue = "";
		$this->ContactID->TooltipValue = "";

		// Activated
		$this->Activated->LinkCustomAttributes = "";
		$this->Activated->HrefValue = "";
		$this->Activated->TooltipValue = "";

		// Notes
		$this->Notes->LinkCustomAttributes = "";
		$this->Notes->HrefValue = "";
		$this->Notes->TooltipValue = "";

		// UserID
		$this->_UserID->LinkCustomAttributes = "";
		$this->_UserID->HrefValue = "";
		$this->_UserID->TooltipValue = "";

		// CreatedBy
		$this->CreatedBy->LinkCustomAttributes = "";
		$this->CreatedBy->HrefValue = "";
		$this->CreatedBy->TooltipValue = "";

		// CreatedDate
		$this->CreatedDate->LinkCustomAttributes = "";
		$this->CreatedDate->HrefValue = "";
		$this->CreatedDate->TooltipValue = "";

		// UpdatedBy
		$this->UpdatedBy->LinkCustomAttributes = "";
		$this->UpdatedBy->HrefValue = "";
		$this->UpdatedBy->TooltipValue = "";

		// UpdatedDate
		$this->UpdatedDate->LinkCustomAttributes = "";
		$this->UpdatedDate->HrefValue = "";
		$this->UpdatedDate->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// courttypeCourtTypeID
		$this->courttypeCourtTypeID->EditAttrs["class"] = "form-control";
		$this->courttypeCourtTypeID->EditCustomAttributes = "";
		$this->courttypeCourtTypeID->EditValue = $this->courttypeCourtTypeID->CurrentValue;
		$this->courttypeCourtTypeID->ViewCustomAttributes = "";

		// CourtType
		$this->CourtType->EditAttrs["class"] = "form-control";
		$this->CourtType->EditCustomAttributes = "";
		$this->CourtType->EditValue = $this->CourtType->CurrentValue;
		$this->CourtType->PlaceHolder = RemoveHtml($this->CourtType->caption());

		// CourtTypeEn
		$this->CourtTypeEn->EditAttrs["class"] = "form-control";
		$this->CourtTypeEn->EditCustomAttributes = "";
		$this->CourtTypeEn->EditValue = $this->CourtTypeEn->CurrentValue;
		$this->CourtTypeEn->PlaceHolder = RemoveHtml($this->CourtTypeEn->caption());

		// CourtTypeNotes
		$this->CourtTypeNotes->EditAttrs["class"] = "form-control";
		$this->CourtTypeNotes->EditCustomAttributes = "";
		$this->CourtTypeNotes->EditValue = $this->CourtTypeNotes->CurrentValue;
		$this->CourtTypeNotes->PlaceHolder = RemoveHtml($this->CourtTypeNotes->caption());

		// courtLocationCourtLocationID
		$this->courtLocationCourtLocationID->EditAttrs["class"] = "form-control";
		$this->courtLocationCourtLocationID->EditCustomAttributes = "";
		$this->courtLocationCourtLocationID->EditValue = $this->courtLocationCourtLocationID->CurrentValue;
		$this->courtLocationCourtLocationID->ViewCustomAttributes = "";

		// CourtLocation
		$this->CourtLocation->EditAttrs["class"] = "form-control";
		$this->CourtLocation->EditCustomAttributes = "";
		$this->CourtLocation->EditValue = $this->CourtLocation->CurrentValue;
		$this->CourtLocation->PlaceHolder = RemoveHtml($this->CourtLocation->caption());

		// CourtLocationEn
		$this->CourtLocationEn->EditAttrs["class"] = "form-control";
		$this->CourtLocationEn->EditCustomAttributes = "";
		$this->CourtLocationEn->EditValue = $this->CourtLocationEn->CurrentValue;
		$this->CourtLocationEn->PlaceHolder = RemoveHtml($this->CourtLocationEn->caption());

		// CourtLocationGovernorateID
		$this->CourtLocationGovernorateID->EditAttrs["class"] = "form-control";
		$this->CourtLocationGovernorateID->EditCustomAttributes = "";
		$this->CourtLocationGovernorateID->EditValue = $this->CourtLocationGovernorateID->CurrentValue;
		$this->CourtLocationGovernorateID->PlaceHolder = RemoveHtml($this->CourtLocationGovernorateID->caption());

		// CourtLocationNotes
		$this->CourtLocationNotes->EditAttrs["class"] = "form-control";
		$this->CourtLocationNotes->EditCustomAttributes = "";
		$this->CourtLocationNotes->EditValue = $this->CourtLocationNotes->CurrentValue;
		$this->CourtLocationNotes->PlaceHolder = RemoveHtml($this->CourtLocationNotes->caption());

		// governoratesGovernorateID
		$this->governoratesGovernorateID->EditAttrs["class"] = "form-control";
		$this->governoratesGovernorateID->EditCustomAttributes = "";
		$this->governoratesGovernorateID->EditValue = $this->governoratesGovernorateID->CurrentValue;
		$this->governoratesGovernorateID->ViewCustomAttributes = "";

		// Governorate
		$this->Governorate->EditAttrs["class"] = "form-control";
		$this->Governorate->EditCustomAttributes = "";
		$this->Governorate->EditValue = $this->Governorate->CurrentValue;
		$this->Governorate->PlaceHolder = RemoveHtml($this->Governorate->caption());

		// GovernorateEn
		$this->GovernorateEn->EditAttrs["class"] = "form-control";
		$this->GovernorateEn->EditCustomAttributes = "";
		$this->GovernorateEn->EditValue = $this->GovernorateEn->CurrentValue;
		$this->GovernorateEn->PlaceHolder = RemoveHtml($this->GovernorateEn->caption());

		// GovernoratesNotes
		$this->GovernoratesNotes->EditAttrs["class"] = "form-control";
		$this->GovernoratesNotes->EditCustomAttributes = "";
		$this->GovernoratesNotes->EditValue = $this->GovernoratesNotes->CurrentValue;
		$this->GovernoratesNotes->PlaceHolder = RemoveHtml($this->GovernoratesNotes->caption());

		// ChambersChamberID
		$this->ChambersChamberID->EditAttrs["class"] = "form-control";
		$this->ChambersChamberID->EditCustomAttributes = "";
		$this->ChambersChamberID->EditValue = $this->ChambersChamberID->CurrentValue;
		$this->ChambersChamberID->ViewCustomAttributes = "";

		// Chamber
		$this->Chamber->EditAttrs["class"] = "form-control";
		$this->Chamber->EditCustomAttributes = "";
		$this->Chamber->EditValue = $this->Chamber->CurrentValue;
		$this->Chamber->PlaceHolder = RemoveHtml($this->Chamber->caption());

		// ChamberEn
		$this->ChamberEn->EditAttrs["class"] = "form-control";
		$this->ChamberEn->EditCustomAttributes = "";
		$this->ChamberEn->EditValue = $this->ChamberEn->CurrentValue;
		$this->ChamberEn->PlaceHolder = RemoveHtml($this->ChamberEn->caption());

		// chambersNotes
		$this->chambersNotes->EditAttrs["class"] = "form-control";
		$this->chambersNotes->EditCustomAttributes = "";
		$this->chambersNotes->EditValue = $this->chambersNotes->CurrentValue;
		$this->chambersNotes->PlaceHolder = RemoveHtml($this->chambersNotes->caption());

		// ChambersActivated
		$this->ChambersActivated->EditCustomAttributes = "";
		$this->ChambersActivated->EditValue = $this->ChambersActivated->options(FALSE);

		// sectionsSectionID
		$this->sectionsSectionID->EditAttrs["class"] = "form-control";
		$this->sectionsSectionID->EditCustomAttributes = "";
		$this->sectionsSectionID->EditValue = $this->sectionsSectionID->CurrentValue;
		$this->sectionsSectionID->ViewCustomAttributes = "";

		// Section
		$this->Section->EditAttrs["class"] = "form-control";
		$this->Section->EditCustomAttributes = "";
		$this->Section->EditValue = $this->Section->CurrentValue;
		$this->Section->PlaceHolder = RemoveHtml($this->Section->caption());

		// SectionEn
		$this->SectionEn->EditAttrs["class"] = "form-control";
		$this->SectionEn->EditCustomAttributes = "";
		$this->SectionEn->EditValue = $this->SectionEn->CurrentValue;
		$this->SectionEn->PlaceHolder = RemoveHtml($this->SectionEn->caption());

		// SectionsNotes
		$this->SectionsNotes->EditAttrs["class"] = "form-control";
		$this->SectionsNotes->EditCustomAttributes = "";
		$this->SectionsNotes->EditValue = $this->SectionsNotes->CurrentValue;
		$this->SectionsNotes->PlaceHolder = RemoveHtml($this->SectionsNotes->caption());

		// SectionsActivated
		$this->SectionsActivated->EditCustomAttributes = "";
		$this->SectionsActivated->EditValue = $this->SectionsActivated->options(FALSE);

		// CourtID
		$this->CourtID->EditAttrs["class"] = "form-control";
		$this->CourtID->EditCustomAttributes = "";
		$this->CourtID->EditValue = $this->CourtID->CurrentValue;
		$this->CourtID->ViewCustomAttributes = "";

		// Court
		$this->Court->EditAttrs["class"] = "form-control";
		$this->Court->EditCustomAttributes = "";
		$this->Court->EditValue = $this->Court->CurrentValue;
		$this->Court->PlaceHolder = RemoveHtml($this->Court->caption());

		// CourtEn
		$this->CourtEn->EditAttrs["class"] = "form-control";
		$this->CourtEn->EditCustomAttributes = "";
		$this->CourtEn->EditValue = $this->CourtEn->CurrentValue;
		$this->CourtEn->PlaceHolder = RemoveHtml($this->CourtEn->caption());

		// CourtTypeID
		$this->CourtTypeID->EditAttrs["class"] = "form-control";
		$this->CourtTypeID->EditCustomAttributes = "";

		// ChamberID
		$this->ChamberID->EditAttrs["class"] = "form-control";
		$this->ChamberID->EditCustomAttributes = "";

		// CourtLocationID
		$this->CourtLocationID->EditAttrs["class"] = "form-control";
		$this->CourtLocationID->EditCustomAttributes = "";

		// GovernorateID
		$this->GovernorateID->EditAttrs["class"] = "form-control";
		$this->GovernorateID->EditCustomAttributes = "";

		// SectionID
		$this->SectionID->EditAttrs["class"] = "form-control";
		$this->SectionID->EditCustomAttributes = "";

		// AddressID
		$this->AddressID->EditAttrs["class"] = "form-control";
		$this->AddressID->EditCustomAttributes = "";
		$this->AddressID->EditValue = $this->AddressID->CurrentValue;
		$this->AddressID->PlaceHolder = RemoveHtml($this->AddressID->caption());

		// ContactID
		$this->ContactID->EditAttrs["class"] = "form-control";
		$this->ContactID->EditCustomAttributes = "";
		$this->ContactID->EditValue = $this->ContactID->CurrentValue;
		$this->ContactID->PlaceHolder = RemoveHtml($this->ContactID->caption());

		// Activated
		$this->Activated->EditCustomAttributes = "";
		$this->Activated->EditValue = $this->Activated->options(FALSE);

		// Notes
		$this->Notes->EditAttrs["class"] = "form-control";
		$this->Notes->EditCustomAttributes = "";
		$this->Notes->EditValue = $this->Notes->CurrentValue;
		$this->Notes->PlaceHolder = RemoveHtml($this->Notes->caption());

		// UserID
		$this->_UserID->EditAttrs["class"] = "form-control";
		$this->_UserID->EditCustomAttributes = "";
		$this->_UserID->EditValue = $this->_UserID->CurrentValue;
		$this->_UserID->PlaceHolder = RemoveHtml($this->_UserID->caption());

		// CreatedBy
		$this->CreatedBy->EditAttrs["class"] = "form-control";
		$this->CreatedBy->EditCustomAttributes = "";
		$this->CreatedBy->EditValue = $this->CreatedBy->CurrentValue;
		$this->CreatedBy->PlaceHolder = RemoveHtml($this->CreatedBy->caption());

		// CreatedDate
		$this->CreatedDate->EditAttrs["class"] = "form-control";
		$this->CreatedDate->EditCustomAttributes = "";
		$this->CreatedDate->EditValue = FormatDateTime($this->CreatedDate->CurrentValue, 8);
		$this->CreatedDate->PlaceHolder = RemoveHtml($this->CreatedDate->caption());

		// UpdatedBy
		$this->UpdatedBy->EditAttrs["class"] = "form-control";
		$this->UpdatedBy->EditCustomAttributes = "";
		$this->UpdatedBy->EditValue = $this->UpdatedBy->CurrentValue;
		$this->UpdatedBy->PlaceHolder = RemoveHtml($this->UpdatedBy->caption());

		// UpdatedDate
		$this->UpdatedDate->EditAttrs["class"] = "form-control";
		$this->UpdatedDate->EditCustomAttributes = "";
		$this->UpdatedDate->EditValue = FormatDateTime($this->UpdatedDate->CurrentValue, 8);
		$this->UpdatedDate->PlaceHolder = RemoveHtml($this->UpdatedDate->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->courttypeCourtTypeID);
					$doc->exportCaption($this->CourtType);
					$doc->exportCaption($this->CourtTypeEn);
					$doc->exportCaption($this->CourtTypeNotes);
					$doc->exportCaption($this->courtLocationCourtLocationID);
					$doc->exportCaption($this->CourtLocation);
					$doc->exportCaption($this->CourtLocationEn);
					$doc->exportCaption($this->CourtLocationGovernorateID);
					$doc->exportCaption($this->CourtLocationNotes);
					$doc->exportCaption($this->governoratesGovernorateID);
					$doc->exportCaption($this->Governorate);
					$doc->exportCaption($this->GovernorateEn);
					$doc->exportCaption($this->GovernoratesNotes);
					$doc->exportCaption($this->ChambersChamberID);
					$doc->exportCaption($this->Chamber);
					$doc->exportCaption($this->ChamberEn);
					$doc->exportCaption($this->chambersNotes);
					$doc->exportCaption($this->ChambersActivated);
					$doc->exportCaption($this->sectionsSectionID);
					$doc->exportCaption($this->Section);
					$doc->exportCaption($this->SectionEn);
					$doc->exportCaption($this->SectionsNotes);
					$doc->exportCaption($this->SectionsActivated);
					$doc->exportCaption($this->CourtID);
					$doc->exportCaption($this->Court);
					$doc->exportCaption($this->CourtEn);
					$doc->exportCaption($this->CourtTypeID);
					$doc->exportCaption($this->ChamberID);
					$doc->exportCaption($this->CourtLocationID);
					$doc->exportCaption($this->GovernorateID);
					$doc->exportCaption($this->SectionID);
					$doc->exportCaption($this->AddressID);
					$doc->exportCaption($this->ContactID);
					$doc->exportCaption($this->Activated);
					$doc->exportCaption($this->Notes);
					$doc->exportCaption($this->_UserID);
					$doc->exportCaption($this->CreatedBy);
					$doc->exportCaption($this->CreatedDate);
					$doc->exportCaption($this->UpdatedBy);
					$doc->exportCaption($this->UpdatedDate);
				} else {
					$doc->exportCaption($this->courttypeCourtTypeID);
					$doc->exportCaption($this->CourtType);
					$doc->exportCaption($this->CourtTypeEn);
					$doc->exportCaption($this->CourtTypeNotes);
					$doc->exportCaption($this->courtLocationCourtLocationID);
					$doc->exportCaption($this->CourtLocation);
					$doc->exportCaption($this->CourtLocationEn);
					$doc->exportCaption($this->CourtLocationGovernorateID);
					$doc->exportCaption($this->CourtLocationNotes);
					$doc->exportCaption($this->governoratesGovernorateID);
					$doc->exportCaption($this->Governorate);
					$doc->exportCaption($this->GovernorateEn);
					$doc->exportCaption($this->GovernoratesNotes);
					$doc->exportCaption($this->ChambersChamberID);
					$doc->exportCaption($this->Chamber);
					$doc->exportCaption($this->ChamberEn);
					$doc->exportCaption($this->ChambersActivated);
					$doc->exportCaption($this->sectionsSectionID);
					$doc->exportCaption($this->Section);
					$doc->exportCaption($this->SectionEn);
					$doc->exportCaption($this->SectionsActivated);
					$doc->exportCaption($this->CourtID);
					$doc->exportCaption($this->Court);
					$doc->exportCaption($this->CourtEn);
					$doc->exportCaption($this->CourtTypeID);
					$doc->exportCaption($this->ChamberID);
					$doc->exportCaption($this->CourtLocationID);
					$doc->exportCaption($this->GovernorateID);
					$doc->exportCaption($this->SectionID);
					$doc->exportCaption($this->AddressID);
					$doc->exportCaption($this->ContactID);
					$doc->exportCaption($this->Activated);
					$doc->exportCaption($this->Notes);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->courttypeCourtTypeID);
						$doc->exportField($this->CourtType);
						$doc->exportField($this->CourtTypeEn);
						$doc->exportField($this->CourtTypeNotes);
						$doc->exportField($this->courtLocationCourtLocationID);
						$doc->exportField($this->CourtLocation);
						$doc->exportField($this->CourtLocationEn);
						$doc->exportField($this->CourtLocationGovernorateID);
						$doc->exportField($this->CourtLocationNotes);
						$doc->exportField($this->governoratesGovernorateID);
						$doc->exportField($this->Governorate);
						$doc->exportField($this->GovernorateEn);
						$doc->exportField($this->GovernoratesNotes);
						$doc->exportField($this->ChambersChamberID);
						$doc->exportField($this->Chamber);
						$doc->exportField($this->ChamberEn);
						$doc->exportField($this->chambersNotes);
						$doc->exportField($this->ChambersActivated);
						$doc->exportField($this->sectionsSectionID);
						$doc->exportField($this->Section);
						$doc->exportField($this->SectionEn);
						$doc->exportField($this->SectionsNotes);
						$doc->exportField($this->SectionsActivated);
						$doc->exportField($this->CourtID);
						$doc->exportField($this->Court);
						$doc->exportField($this->CourtEn);
						$doc->exportField($this->CourtTypeID);
						$doc->exportField($this->ChamberID);
						$doc->exportField($this->CourtLocationID);
						$doc->exportField($this->GovernorateID);
						$doc->exportField($this->SectionID);
						$doc->exportField($this->AddressID);
						$doc->exportField($this->ContactID);
						$doc->exportField($this->Activated);
						$doc->exportField($this->Notes);
						$doc->exportField($this->_UserID);
						$doc->exportField($this->CreatedBy);
						$doc->exportField($this->CreatedDate);
						$doc->exportField($this->UpdatedBy);
						$doc->exportField($this->UpdatedDate);
					} else {
						$doc->exportField($this->courttypeCourtTypeID);
						$doc->exportField($this->CourtType);
						$doc->exportField($this->CourtTypeEn);
						$doc->exportField($this->CourtTypeNotes);
						$doc->exportField($this->courtLocationCourtLocationID);
						$doc->exportField($this->CourtLocation);
						$doc->exportField($this->CourtLocationEn);
						$doc->exportField($this->CourtLocationGovernorateID);
						$doc->exportField($this->CourtLocationNotes);
						$doc->exportField($this->governoratesGovernorateID);
						$doc->exportField($this->Governorate);
						$doc->exportField($this->GovernorateEn);
						$doc->exportField($this->GovernoratesNotes);
						$doc->exportField($this->ChambersChamberID);
						$doc->exportField($this->Chamber);
						$doc->exportField($this->ChamberEn);
						$doc->exportField($this->ChambersActivated);
						$doc->exportField($this->sectionsSectionID);
						$doc->exportField($this->Section);
						$doc->exportField($this->SectionEn);
						$doc->exportField($this->SectionsActivated);
						$doc->exportField($this->CourtID);
						$doc->exportField($this->Court);
						$doc->exportField($this->CourtEn);
						$doc->exportField($this->CourtTypeID);
						$doc->exportField($this->ChamberID);
						$doc->exportField($this->CourtLocationID);
						$doc->exportField($this->GovernorateID);
						$doc->exportField($this->SectionID);
						$doc->exportField($this->AddressID);
						$doc->exportField($this->ContactID);
						$doc->exportField($this->Activated);
						$doc->exportField($this->Notes);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		if (!$validRequest)
			return FALSE;

		// Load lookup parameters
		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>
