<?php
namespace PHPMaker2019\project_germanos;

/**
 * Page class
 */
class courtsv_list extends courtsv
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{8D47CED4-FEF0-4756-8F48-9FC38A15AA2A}";

	// Table name
	public $TableName = 'courtsv';

	// Page object name
	public $PageObjName = "courtsv_list";

	// Grid form hidden field names
	public $FormName = "fcourtsvlist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (courtsv)
		if (!isset($GLOBALS["courtsv"]) || get_class($GLOBALS["courtsv"]) == PROJECT_NAMESPACE . "courtsv") {
			$GLOBALS["courtsv"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["courtsv"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->AddUrl = "courtsvadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "courtsvdelete.php";
		$this->MultiUpdateUrl = "courtsvupdate.php";

		// Table object (employees)
		if (!isset($GLOBALS['employees']))
			$GLOBALS['employees'] = new employees();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'courtsv');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new employees();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions();
		$this->ImportOptions->Tag = "div";
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option fcourtsvlistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $courtsv;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($courtsv);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['courttypeCourtTypeID'] . $COMPOSITE_KEY_SEPARATOR;
			$key .= @$ar['courtLocationCourtLocationID'] . $COMPOSITE_KEY_SEPARATOR;
			$key .= @$ar['governoratesGovernorateID'] . $COMPOSITE_KEY_SEPARATOR;
			$key .= @$ar['ChambersChamberID'] . $COMPOSITE_KEY_SEPARATOR;
			$key .= @$ar['sectionsSectionID'] . $COMPOSITE_KEY_SEPARATOR;
			$key .= @$ar['CourtID'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->courttypeCourtTypeID->Visible = FALSE;
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->courtLocationCourtLocationID->Visible = FALSE;
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->governoratesGovernorateID->Visible = FALSE;
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->ChambersChamberID->Visible = FALSE;
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->sectionsSectionID->Visible = FALSE;
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->CourtID->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecs = 10;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (IsPasswordExpired())
				$this->terminate(GetUrl("changepwd.php"));
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Update last accessed time
		if ($UserProfile->isValidUser(CurrentUserName(), session_id())) {
		} else {
			Write($Language->phrase("UserProfileCorrupted"));
			$this->terminate();
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->courttypeCourtTypeID->setVisibility();
		$this->CourtType->setVisibility();
		$this->CourtTypeEn->setVisibility();
		$this->CourtTypeNotes->setVisibility();
		$this->courtLocationCourtLocationID->setVisibility();
		$this->CourtLocation->setVisibility();
		$this->CourtLocationEn->setVisibility();
		$this->CourtLocationGovernorateID->setVisibility();
		$this->CourtLocationNotes->setVisibility();
		$this->governoratesGovernorateID->setVisibility();
		$this->Governorate->setVisibility();
		$this->GovernorateEn->setVisibility();
		$this->GovernoratesNotes->setVisibility();
		$this->ChambersChamberID->setVisibility();
		$this->Chamber->setVisibility();
		$this->ChamberEn->setVisibility();
		$this->chambersNotes->Visible = FALSE;
		$this->ChambersActivated->setVisibility();
		$this->sectionsSectionID->setVisibility();
		$this->Section->setVisibility();
		$this->SectionEn->setVisibility();
		$this->SectionsNotes->Visible = FALSE;
		$this->SectionsActivated->setVisibility();
		$this->CourtID->setVisibility();
		$this->Court->setVisibility();
		$this->CourtEn->setVisibility();
		$this->CourtTypeID->setVisibility();
		$this->ChamberID->setVisibility();
		$this->CourtLocationID->setVisibility();
		$this->GovernorateID->setVisibility();
		$this->SectionID->setVisibility();
		$this->AddressID->setVisibility();
		$this->ContactID->setVisibility();
		$this->Activated->setVisibility();
		$this->Notes->Visible = FALSE;
		$this->_UserID->Visible = FALSE;
		$this->CreatedBy->Visible = FALSE;
		$this->CreatedDate->Visible = FALSE;
		$this->UpdatedBy->Visible = FALSE;
		$this->UpdatedDate->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->CourtTypeID);
		$this->setupLookupOptions($this->ChamberID);
		$this->setupLookupOptions($this->CourtLocationID);
		$this->setupLookupOptions($this->GovernorateID);
		$this->setupLookupOptions($this->SectionID);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 10; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys($EXPORT))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRec = 1;
			$this->DisplayRecs = $this->GridAddRowCount;
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			if ($this->DisplayRecs <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecs = $this->TotalRecs;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRec();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 10; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 6) {
			$this->courttypeCourtTypeID->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->courttypeCourtTypeID->FormValue))
				return FALSE;
			$this->courtLocationCourtLocationID->setFormValue($arKeyFlds[1]);
			if (!is_numeric($this->courtLocationCourtLocationID->FormValue))
				return FALSE;
			$this->governoratesGovernorateID->setFormValue($arKeyFlds[2]);
			if (!is_numeric($this->governoratesGovernorateID->FormValue))
				return FALSE;
			$this->ChambersChamberID->setFormValue($arKeyFlds[3]);
			if (!is_numeric($this->ChambersChamberID->FormValue))
				return FALSE;
			$this->sectionsSectionID->setFormValue($arKeyFlds[4]);
			if (!is_numeric($this->sectionsSectionID->FormValue))
				return FALSE;
			$this->CourtID->setFormValue($arKeyFlds[5]);
			if (!is_numeric($this->CourtID->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";

		// Load server side filters
		if (SEARCH_FILTER_OPTION == "Server" && isset($UserProfile))
			$savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "fcourtsvlistsrch");
		$filterList = Concat($filterList, $this->courttypeCourtTypeID->AdvancedSearch->toJson(), ","); // Field courttypeCourtTypeID
		$filterList = Concat($filterList, $this->CourtType->AdvancedSearch->toJson(), ","); // Field CourtType
		$filterList = Concat($filterList, $this->CourtTypeEn->AdvancedSearch->toJson(), ","); // Field CourtTypeEn
		$filterList = Concat($filterList, $this->CourtTypeNotes->AdvancedSearch->toJson(), ","); // Field CourtTypeNotes
		$filterList = Concat($filterList, $this->courtLocationCourtLocationID->AdvancedSearch->toJson(), ","); // Field courtLocationCourtLocationID
		$filterList = Concat($filterList, $this->CourtLocation->AdvancedSearch->toJson(), ","); // Field CourtLocation
		$filterList = Concat($filterList, $this->CourtLocationEn->AdvancedSearch->toJson(), ","); // Field CourtLocationEn
		$filterList = Concat($filterList, $this->CourtLocationGovernorateID->AdvancedSearch->toJson(), ","); // Field CourtLocationGovernorateID
		$filterList = Concat($filterList, $this->CourtLocationNotes->AdvancedSearch->toJson(), ","); // Field CourtLocationNotes
		$filterList = Concat($filterList, $this->governoratesGovernorateID->AdvancedSearch->toJson(), ","); // Field governoratesGovernorateID
		$filterList = Concat($filterList, $this->Governorate->AdvancedSearch->toJson(), ","); // Field Governorate
		$filterList = Concat($filterList, $this->GovernorateEn->AdvancedSearch->toJson(), ","); // Field GovernorateEn
		$filterList = Concat($filterList, $this->GovernoratesNotes->AdvancedSearch->toJson(), ","); // Field GovernoratesNotes
		$filterList = Concat($filterList, $this->ChambersChamberID->AdvancedSearch->toJson(), ","); // Field ChambersChamberID
		$filterList = Concat($filterList, $this->Chamber->AdvancedSearch->toJson(), ","); // Field Chamber
		$filterList = Concat($filterList, $this->ChamberEn->AdvancedSearch->toJson(), ","); // Field ChamberEn
		$filterList = Concat($filterList, $this->chambersNotes->AdvancedSearch->toJson(), ","); // Field chambersNotes
		$filterList = Concat($filterList, $this->ChambersActivated->AdvancedSearch->toJson(), ","); // Field ChambersActivated
		$filterList = Concat($filterList, $this->sectionsSectionID->AdvancedSearch->toJson(), ","); // Field sectionsSectionID
		$filterList = Concat($filterList, $this->Section->AdvancedSearch->toJson(), ","); // Field Section
		$filterList = Concat($filterList, $this->SectionEn->AdvancedSearch->toJson(), ","); // Field SectionEn
		$filterList = Concat($filterList, $this->SectionsNotes->AdvancedSearch->toJson(), ","); // Field SectionsNotes
		$filterList = Concat($filterList, $this->SectionsActivated->AdvancedSearch->toJson(), ","); // Field SectionsActivated
		$filterList = Concat($filterList, $this->CourtID->AdvancedSearch->toJson(), ","); // Field CourtID
		$filterList = Concat($filterList, $this->Court->AdvancedSearch->toJson(), ","); // Field Court
		$filterList = Concat($filterList, $this->CourtEn->AdvancedSearch->toJson(), ","); // Field CourtEn
		$filterList = Concat($filterList, $this->CourtTypeID->AdvancedSearch->toJson(), ","); // Field CourtTypeID
		$filterList = Concat($filterList, $this->ChamberID->AdvancedSearch->toJson(), ","); // Field ChamberID
		$filterList = Concat($filterList, $this->CourtLocationID->AdvancedSearch->toJson(), ","); // Field CourtLocationID
		$filterList = Concat($filterList, $this->GovernorateID->AdvancedSearch->toJson(), ","); // Field GovernorateID
		$filterList = Concat($filterList, $this->SectionID->AdvancedSearch->toJson(), ","); // Field SectionID
		$filterList = Concat($filterList, $this->AddressID->AdvancedSearch->toJson(), ","); // Field AddressID
		$filterList = Concat($filterList, $this->ContactID->AdvancedSearch->toJson(), ","); // Field ContactID
		$filterList = Concat($filterList, $this->Activated->AdvancedSearch->toJson(), ","); // Field Activated
		if ($this->BasicSearch->Keyword <> "") {
			$wrk = "\"" . TABLE_BASIC_SEARCH . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . TABLE_BASIC_SEARCH_TYPE . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList <> "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList <> "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList <> "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "fcourtsvlistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field courttypeCourtTypeID
		$this->courttypeCourtTypeID->AdvancedSearch->SearchValue = @$filter["x_courttypeCourtTypeID"];
		$this->courttypeCourtTypeID->AdvancedSearch->SearchOperator = @$filter["z_courttypeCourtTypeID"];
		$this->courttypeCourtTypeID->AdvancedSearch->SearchCondition = @$filter["v_courttypeCourtTypeID"];
		$this->courttypeCourtTypeID->AdvancedSearch->SearchValue2 = @$filter["y_courttypeCourtTypeID"];
		$this->courttypeCourtTypeID->AdvancedSearch->SearchOperator2 = @$filter["w_courttypeCourtTypeID"];
		$this->courttypeCourtTypeID->AdvancedSearch->save();

		// Field CourtType
		$this->CourtType->AdvancedSearch->SearchValue = @$filter["x_CourtType"];
		$this->CourtType->AdvancedSearch->SearchOperator = @$filter["z_CourtType"];
		$this->CourtType->AdvancedSearch->SearchCondition = @$filter["v_CourtType"];
		$this->CourtType->AdvancedSearch->SearchValue2 = @$filter["y_CourtType"];
		$this->CourtType->AdvancedSearch->SearchOperator2 = @$filter["w_CourtType"];
		$this->CourtType->AdvancedSearch->save();

		// Field CourtTypeEn
		$this->CourtTypeEn->AdvancedSearch->SearchValue = @$filter["x_CourtTypeEn"];
		$this->CourtTypeEn->AdvancedSearch->SearchOperator = @$filter["z_CourtTypeEn"];
		$this->CourtTypeEn->AdvancedSearch->SearchCondition = @$filter["v_CourtTypeEn"];
		$this->CourtTypeEn->AdvancedSearch->SearchValue2 = @$filter["y_CourtTypeEn"];
		$this->CourtTypeEn->AdvancedSearch->SearchOperator2 = @$filter["w_CourtTypeEn"];
		$this->CourtTypeEn->AdvancedSearch->save();

		// Field CourtTypeNotes
		$this->CourtTypeNotes->AdvancedSearch->SearchValue = @$filter["x_CourtTypeNotes"];
		$this->CourtTypeNotes->AdvancedSearch->SearchOperator = @$filter["z_CourtTypeNotes"];
		$this->CourtTypeNotes->AdvancedSearch->SearchCondition = @$filter["v_CourtTypeNotes"];
		$this->CourtTypeNotes->AdvancedSearch->SearchValue2 = @$filter["y_CourtTypeNotes"];
		$this->CourtTypeNotes->AdvancedSearch->SearchOperator2 = @$filter["w_CourtTypeNotes"];
		$this->CourtTypeNotes->AdvancedSearch->save();

		// Field courtLocationCourtLocationID
		$this->courtLocationCourtLocationID->AdvancedSearch->SearchValue = @$filter["x_courtLocationCourtLocationID"];
		$this->courtLocationCourtLocationID->AdvancedSearch->SearchOperator = @$filter["z_courtLocationCourtLocationID"];
		$this->courtLocationCourtLocationID->AdvancedSearch->SearchCondition = @$filter["v_courtLocationCourtLocationID"];
		$this->courtLocationCourtLocationID->AdvancedSearch->SearchValue2 = @$filter["y_courtLocationCourtLocationID"];
		$this->courtLocationCourtLocationID->AdvancedSearch->SearchOperator2 = @$filter["w_courtLocationCourtLocationID"];
		$this->courtLocationCourtLocationID->AdvancedSearch->save();

		// Field CourtLocation
		$this->CourtLocation->AdvancedSearch->SearchValue = @$filter["x_CourtLocation"];
		$this->CourtLocation->AdvancedSearch->SearchOperator = @$filter["z_CourtLocation"];
		$this->CourtLocation->AdvancedSearch->SearchCondition = @$filter["v_CourtLocation"];
		$this->CourtLocation->AdvancedSearch->SearchValue2 = @$filter["y_CourtLocation"];
		$this->CourtLocation->AdvancedSearch->SearchOperator2 = @$filter["w_CourtLocation"];
		$this->CourtLocation->AdvancedSearch->save();

		// Field CourtLocationEn
		$this->CourtLocationEn->AdvancedSearch->SearchValue = @$filter["x_CourtLocationEn"];
		$this->CourtLocationEn->AdvancedSearch->SearchOperator = @$filter["z_CourtLocationEn"];
		$this->CourtLocationEn->AdvancedSearch->SearchCondition = @$filter["v_CourtLocationEn"];
		$this->CourtLocationEn->AdvancedSearch->SearchValue2 = @$filter["y_CourtLocationEn"];
		$this->CourtLocationEn->AdvancedSearch->SearchOperator2 = @$filter["w_CourtLocationEn"];
		$this->CourtLocationEn->AdvancedSearch->save();

		// Field CourtLocationGovernorateID
		$this->CourtLocationGovernorateID->AdvancedSearch->SearchValue = @$filter["x_CourtLocationGovernorateID"];
		$this->CourtLocationGovernorateID->AdvancedSearch->SearchOperator = @$filter["z_CourtLocationGovernorateID"];
		$this->CourtLocationGovernorateID->AdvancedSearch->SearchCondition = @$filter["v_CourtLocationGovernorateID"];
		$this->CourtLocationGovernorateID->AdvancedSearch->SearchValue2 = @$filter["y_CourtLocationGovernorateID"];
		$this->CourtLocationGovernorateID->AdvancedSearch->SearchOperator2 = @$filter["w_CourtLocationGovernorateID"];
		$this->CourtLocationGovernorateID->AdvancedSearch->save();

		// Field CourtLocationNotes
		$this->CourtLocationNotes->AdvancedSearch->SearchValue = @$filter["x_CourtLocationNotes"];
		$this->CourtLocationNotes->AdvancedSearch->SearchOperator = @$filter["z_CourtLocationNotes"];
		$this->CourtLocationNotes->AdvancedSearch->SearchCondition = @$filter["v_CourtLocationNotes"];
		$this->CourtLocationNotes->AdvancedSearch->SearchValue2 = @$filter["y_CourtLocationNotes"];
		$this->CourtLocationNotes->AdvancedSearch->SearchOperator2 = @$filter["w_CourtLocationNotes"];
		$this->CourtLocationNotes->AdvancedSearch->save();

		// Field governoratesGovernorateID
		$this->governoratesGovernorateID->AdvancedSearch->SearchValue = @$filter["x_governoratesGovernorateID"];
		$this->governoratesGovernorateID->AdvancedSearch->SearchOperator = @$filter["z_governoratesGovernorateID"];
		$this->governoratesGovernorateID->AdvancedSearch->SearchCondition = @$filter["v_governoratesGovernorateID"];
		$this->governoratesGovernorateID->AdvancedSearch->SearchValue2 = @$filter["y_governoratesGovernorateID"];
		$this->governoratesGovernorateID->AdvancedSearch->SearchOperator2 = @$filter["w_governoratesGovernorateID"];
		$this->governoratesGovernorateID->AdvancedSearch->save();

		// Field Governorate
		$this->Governorate->AdvancedSearch->SearchValue = @$filter["x_Governorate"];
		$this->Governorate->AdvancedSearch->SearchOperator = @$filter["z_Governorate"];
		$this->Governorate->AdvancedSearch->SearchCondition = @$filter["v_Governorate"];
		$this->Governorate->AdvancedSearch->SearchValue2 = @$filter["y_Governorate"];
		$this->Governorate->AdvancedSearch->SearchOperator2 = @$filter["w_Governorate"];
		$this->Governorate->AdvancedSearch->save();

		// Field GovernorateEn
		$this->GovernorateEn->AdvancedSearch->SearchValue = @$filter["x_GovernorateEn"];
		$this->GovernorateEn->AdvancedSearch->SearchOperator = @$filter["z_GovernorateEn"];
		$this->GovernorateEn->AdvancedSearch->SearchCondition = @$filter["v_GovernorateEn"];
		$this->GovernorateEn->AdvancedSearch->SearchValue2 = @$filter["y_GovernorateEn"];
		$this->GovernorateEn->AdvancedSearch->SearchOperator2 = @$filter["w_GovernorateEn"];
		$this->GovernorateEn->AdvancedSearch->save();

		// Field GovernoratesNotes
		$this->GovernoratesNotes->AdvancedSearch->SearchValue = @$filter["x_GovernoratesNotes"];
		$this->GovernoratesNotes->AdvancedSearch->SearchOperator = @$filter["z_GovernoratesNotes"];
		$this->GovernoratesNotes->AdvancedSearch->SearchCondition = @$filter["v_GovernoratesNotes"];
		$this->GovernoratesNotes->AdvancedSearch->SearchValue2 = @$filter["y_GovernoratesNotes"];
		$this->GovernoratesNotes->AdvancedSearch->SearchOperator2 = @$filter["w_GovernoratesNotes"];
		$this->GovernoratesNotes->AdvancedSearch->save();

		// Field ChambersChamberID
		$this->ChambersChamberID->AdvancedSearch->SearchValue = @$filter["x_ChambersChamberID"];
		$this->ChambersChamberID->AdvancedSearch->SearchOperator = @$filter["z_ChambersChamberID"];
		$this->ChambersChamberID->AdvancedSearch->SearchCondition = @$filter["v_ChambersChamberID"];
		$this->ChambersChamberID->AdvancedSearch->SearchValue2 = @$filter["y_ChambersChamberID"];
		$this->ChambersChamberID->AdvancedSearch->SearchOperator2 = @$filter["w_ChambersChamberID"];
		$this->ChambersChamberID->AdvancedSearch->save();

		// Field Chamber
		$this->Chamber->AdvancedSearch->SearchValue = @$filter["x_Chamber"];
		$this->Chamber->AdvancedSearch->SearchOperator = @$filter["z_Chamber"];
		$this->Chamber->AdvancedSearch->SearchCondition = @$filter["v_Chamber"];
		$this->Chamber->AdvancedSearch->SearchValue2 = @$filter["y_Chamber"];
		$this->Chamber->AdvancedSearch->SearchOperator2 = @$filter["w_Chamber"];
		$this->Chamber->AdvancedSearch->save();

		// Field ChamberEn
		$this->ChamberEn->AdvancedSearch->SearchValue = @$filter["x_ChamberEn"];
		$this->ChamberEn->AdvancedSearch->SearchOperator = @$filter["z_ChamberEn"];
		$this->ChamberEn->AdvancedSearch->SearchCondition = @$filter["v_ChamberEn"];
		$this->ChamberEn->AdvancedSearch->SearchValue2 = @$filter["y_ChamberEn"];
		$this->ChamberEn->AdvancedSearch->SearchOperator2 = @$filter["w_ChamberEn"];
		$this->ChamberEn->AdvancedSearch->save();

		// Field chambersNotes
		$this->chambersNotes->AdvancedSearch->SearchValue = @$filter["x_chambersNotes"];
		$this->chambersNotes->AdvancedSearch->SearchOperator = @$filter["z_chambersNotes"];
		$this->chambersNotes->AdvancedSearch->SearchCondition = @$filter["v_chambersNotes"];
		$this->chambersNotes->AdvancedSearch->SearchValue2 = @$filter["y_chambersNotes"];
		$this->chambersNotes->AdvancedSearch->SearchOperator2 = @$filter["w_chambersNotes"];
		$this->chambersNotes->AdvancedSearch->save();

		// Field ChambersActivated
		$this->ChambersActivated->AdvancedSearch->SearchValue = @$filter["x_ChambersActivated"];
		$this->ChambersActivated->AdvancedSearch->SearchOperator = @$filter["z_ChambersActivated"];
		$this->ChambersActivated->AdvancedSearch->SearchCondition = @$filter["v_ChambersActivated"];
		$this->ChambersActivated->AdvancedSearch->SearchValue2 = @$filter["y_ChambersActivated"];
		$this->ChambersActivated->AdvancedSearch->SearchOperator2 = @$filter["w_ChambersActivated"];
		$this->ChambersActivated->AdvancedSearch->save();

		// Field sectionsSectionID
		$this->sectionsSectionID->AdvancedSearch->SearchValue = @$filter["x_sectionsSectionID"];
		$this->sectionsSectionID->AdvancedSearch->SearchOperator = @$filter["z_sectionsSectionID"];
		$this->sectionsSectionID->AdvancedSearch->SearchCondition = @$filter["v_sectionsSectionID"];
		$this->sectionsSectionID->AdvancedSearch->SearchValue2 = @$filter["y_sectionsSectionID"];
		$this->sectionsSectionID->AdvancedSearch->SearchOperator2 = @$filter["w_sectionsSectionID"];
		$this->sectionsSectionID->AdvancedSearch->save();

		// Field Section
		$this->Section->AdvancedSearch->SearchValue = @$filter["x_Section"];
		$this->Section->AdvancedSearch->SearchOperator = @$filter["z_Section"];
		$this->Section->AdvancedSearch->SearchCondition = @$filter["v_Section"];
		$this->Section->AdvancedSearch->SearchValue2 = @$filter["y_Section"];
		$this->Section->AdvancedSearch->SearchOperator2 = @$filter["w_Section"];
		$this->Section->AdvancedSearch->save();

		// Field SectionEn
		$this->SectionEn->AdvancedSearch->SearchValue = @$filter["x_SectionEn"];
		$this->SectionEn->AdvancedSearch->SearchOperator = @$filter["z_SectionEn"];
		$this->SectionEn->AdvancedSearch->SearchCondition = @$filter["v_SectionEn"];
		$this->SectionEn->AdvancedSearch->SearchValue2 = @$filter["y_SectionEn"];
		$this->SectionEn->AdvancedSearch->SearchOperator2 = @$filter["w_SectionEn"];
		$this->SectionEn->AdvancedSearch->save();

		// Field SectionsNotes
		$this->SectionsNotes->AdvancedSearch->SearchValue = @$filter["x_SectionsNotes"];
		$this->SectionsNotes->AdvancedSearch->SearchOperator = @$filter["z_SectionsNotes"];
		$this->SectionsNotes->AdvancedSearch->SearchCondition = @$filter["v_SectionsNotes"];
		$this->SectionsNotes->AdvancedSearch->SearchValue2 = @$filter["y_SectionsNotes"];
		$this->SectionsNotes->AdvancedSearch->SearchOperator2 = @$filter["w_SectionsNotes"];
		$this->SectionsNotes->AdvancedSearch->save();

		// Field SectionsActivated
		$this->SectionsActivated->AdvancedSearch->SearchValue = @$filter["x_SectionsActivated"];
		$this->SectionsActivated->AdvancedSearch->SearchOperator = @$filter["z_SectionsActivated"];
		$this->SectionsActivated->AdvancedSearch->SearchCondition = @$filter["v_SectionsActivated"];
		$this->SectionsActivated->AdvancedSearch->SearchValue2 = @$filter["y_SectionsActivated"];
		$this->SectionsActivated->AdvancedSearch->SearchOperator2 = @$filter["w_SectionsActivated"];
		$this->SectionsActivated->AdvancedSearch->save();

		// Field CourtID
		$this->CourtID->AdvancedSearch->SearchValue = @$filter["x_CourtID"];
		$this->CourtID->AdvancedSearch->SearchOperator = @$filter["z_CourtID"];
		$this->CourtID->AdvancedSearch->SearchCondition = @$filter["v_CourtID"];
		$this->CourtID->AdvancedSearch->SearchValue2 = @$filter["y_CourtID"];
		$this->CourtID->AdvancedSearch->SearchOperator2 = @$filter["w_CourtID"];
		$this->CourtID->AdvancedSearch->save();

		// Field Court
		$this->Court->AdvancedSearch->SearchValue = @$filter["x_Court"];
		$this->Court->AdvancedSearch->SearchOperator = @$filter["z_Court"];
		$this->Court->AdvancedSearch->SearchCondition = @$filter["v_Court"];
		$this->Court->AdvancedSearch->SearchValue2 = @$filter["y_Court"];
		$this->Court->AdvancedSearch->SearchOperator2 = @$filter["w_Court"];
		$this->Court->AdvancedSearch->save();

		// Field CourtEn
		$this->CourtEn->AdvancedSearch->SearchValue = @$filter["x_CourtEn"];
		$this->CourtEn->AdvancedSearch->SearchOperator = @$filter["z_CourtEn"];
		$this->CourtEn->AdvancedSearch->SearchCondition = @$filter["v_CourtEn"];
		$this->CourtEn->AdvancedSearch->SearchValue2 = @$filter["y_CourtEn"];
		$this->CourtEn->AdvancedSearch->SearchOperator2 = @$filter["w_CourtEn"];
		$this->CourtEn->AdvancedSearch->save();

		// Field CourtTypeID
		$this->CourtTypeID->AdvancedSearch->SearchValue = @$filter["x_CourtTypeID"];
		$this->CourtTypeID->AdvancedSearch->SearchOperator = @$filter["z_CourtTypeID"];
		$this->CourtTypeID->AdvancedSearch->SearchCondition = @$filter["v_CourtTypeID"];
		$this->CourtTypeID->AdvancedSearch->SearchValue2 = @$filter["y_CourtTypeID"];
		$this->CourtTypeID->AdvancedSearch->SearchOperator2 = @$filter["w_CourtTypeID"];
		$this->CourtTypeID->AdvancedSearch->save();

		// Field ChamberID
		$this->ChamberID->AdvancedSearch->SearchValue = @$filter["x_ChamberID"];
		$this->ChamberID->AdvancedSearch->SearchOperator = @$filter["z_ChamberID"];
		$this->ChamberID->AdvancedSearch->SearchCondition = @$filter["v_ChamberID"];
		$this->ChamberID->AdvancedSearch->SearchValue2 = @$filter["y_ChamberID"];
		$this->ChamberID->AdvancedSearch->SearchOperator2 = @$filter["w_ChamberID"];
		$this->ChamberID->AdvancedSearch->save();

		// Field CourtLocationID
		$this->CourtLocationID->AdvancedSearch->SearchValue = @$filter["x_CourtLocationID"];
		$this->CourtLocationID->AdvancedSearch->SearchOperator = @$filter["z_CourtLocationID"];
		$this->CourtLocationID->AdvancedSearch->SearchCondition = @$filter["v_CourtLocationID"];
		$this->CourtLocationID->AdvancedSearch->SearchValue2 = @$filter["y_CourtLocationID"];
		$this->CourtLocationID->AdvancedSearch->SearchOperator2 = @$filter["w_CourtLocationID"];
		$this->CourtLocationID->AdvancedSearch->save();

		// Field GovernorateID
		$this->GovernorateID->AdvancedSearch->SearchValue = @$filter["x_GovernorateID"];
		$this->GovernorateID->AdvancedSearch->SearchOperator = @$filter["z_GovernorateID"];
		$this->GovernorateID->AdvancedSearch->SearchCondition = @$filter["v_GovernorateID"];
		$this->GovernorateID->AdvancedSearch->SearchValue2 = @$filter["y_GovernorateID"];
		$this->GovernorateID->AdvancedSearch->SearchOperator2 = @$filter["w_GovernorateID"];
		$this->GovernorateID->AdvancedSearch->save();

		// Field SectionID
		$this->SectionID->AdvancedSearch->SearchValue = @$filter["x_SectionID"];
		$this->SectionID->AdvancedSearch->SearchOperator = @$filter["z_SectionID"];
		$this->SectionID->AdvancedSearch->SearchCondition = @$filter["v_SectionID"];
		$this->SectionID->AdvancedSearch->SearchValue2 = @$filter["y_SectionID"];
		$this->SectionID->AdvancedSearch->SearchOperator2 = @$filter["w_SectionID"];
		$this->SectionID->AdvancedSearch->save();

		// Field AddressID
		$this->AddressID->AdvancedSearch->SearchValue = @$filter["x_AddressID"];
		$this->AddressID->AdvancedSearch->SearchOperator = @$filter["z_AddressID"];
		$this->AddressID->AdvancedSearch->SearchCondition = @$filter["v_AddressID"];
		$this->AddressID->AdvancedSearch->SearchValue2 = @$filter["y_AddressID"];
		$this->AddressID->AdvancedSearch->SearchOperator2 = @$filter["w_AddressID"];
		$this->AddressID->AdvancedSearch->save();

		// Field ContactID
		$this->ContactID->AdvancedSearch->SearchValue = @$filter["x_ContactID"];
		$this->ContactID->AdvancedSearch->SearchOperator = @$filter["z_ContactID"];
		$this->ContactID->AdvancedSearch->SearchCondition = @$filter["v_ContactID"];
		$this->ContactID->AdvancedSearch->SearchValue2 = @$filter["y_ContactID"];
		$this->ContactID->AdvancedSearch->SearchOperator2 = @$filter["w_ContactID"];
		$this->ContactID->AdvancedSearch->save();

		// Field Activated
		$this->Activated->AdvancedSearch->SearchValue = @$filter["x_Activated"];
		$this->Activated->AdvancedSearch->SearchOperator = @$filter["z_Activated"];
		$this->Activated->AdvancedSearch->SearchCondition = @$filter["v_Activated"];
		$this->Activated->AdvancedSearch->SearchValue2 = @$filter["y_Activated"];
		$this->Activated->AdvancedSearch->SearchOperator2 = @$filter["w_Activated"];
		$this->Activated->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->courttypeCourtTypeID, $default, FALSE); // courttypeCourtTypeID
		$this->buildSearchSql($where, $this->CourtType, $default, FALSE); // CourtType
		$this->buildSearchSql($where, $this->CourtTypeEn, $default, FALSE); // CourtTypeEn
		$this->buildSearchSql($where, $this->CourtTypeNotes, $default, FALSE); // CourtTypeNotes
		$this->buildSearchSql($where, $this->courtLocationCourtLocationID, $default, FALSE); // courtLocationCourtLocationID
		$this->buildSearchSql($where, $this->CourtLocation, $default, FALSE); // CourtLocation
		$this->buildSearchSql($where, $this->CourtLocationEn, $default, FALSE); // CourtLocationEn
		$this->buildSearchSql($where, $this->CourtLocationGovernorateID, $default, FALSE); // CourtLocationGovernorateID
		$this->buildSearchSql($where, $this->CourtLocationNotes, $default, FALSE); // CourtLocationNotes
		$this->buildSearchSql($where, $this->governoratesGovernorateID, $default, FALSE); // governoratesGovernorateID
		$this->buildSearchSql($where, $this->Governorate, $default, FALSE); // Governorate
		$this->buildSearchSql($where, $this->GovernorateEn, $default, FALSE); // GovernorateEn
		$this->buildSearchSql($where, $this->GovernoratesNotes, $default, FALSE); // GovernoratesNotes
		$this->buildSearchSql($where, $this->ChambersChamberID, $default, FALSE); // ChambersChamberID
		$this->buildSearchSql($where, $this->Chamber, $default, FALSE); // Chamber
		$this->buildSearchSql($where, $this->ChamberEn, $default, FALSE); // ChamberEn
		$this->buildSearchSql($where, $this->chambersNotes, $default, FALSE); // chambersNotes
		$this->buildSearchSql($where, $this->ChambersActivated, $default, FALSE); // ChambersActivated
		$this->buildSearchSql($where, $this->sectionsSectionID, $default, FALSE); // sectionsSectionID
		$this->buildSearchSql($where, $this->Section, $default, FALSE); // Section
		$this->buildSearchSql($where, $this->SectionEn, $default, FALSE); // SectionEn
		$this->buildSearchSql($where, $this->SectionsNotes, $default, FALSE); // SectionsNotes
		$this->buildSearchSql($where, $this->SectionsActivated, $default, FALSE); // SectionsActivated
		$this->buildSearchSql($where, $this->CourtID, $default, FALSE); // CourtID
		$this->buildSearchSql($where, $this->Court, $default, FALSE); // Court
		$this->buildSearchSql($where, $this->CourtEn, $default, FALSE); // CourtEn
		$this->buildSearchSql($where, $this->CourtTypeID, $default, FALSE); // CourtTypeID
		$this->buildSearchSql($where, $this->ChamberID, $default, FALSE); // ChamberID
		$this->buildSearchSql($where, $this->CourtLocationID, $default, FALSE); // CourtLocationID
		$this->buildSearchSql($where, $this->GovernorateID, $default, FALSE); // GovernorateID
		$this->buildSearchSql($where, $this->SectionID, $default, FALSE); // SectionID
		$this->buildSearchSql($where, $this->AddressID, $default, FALSE); // AddressID
		$this->buildSearchSql($where, $this->ContactID, $default, FALSE); // ContactID
		$this->buildSearchSql($where, $this->Activated, $default, FALSE); // Activated

		// Set up search parm
		if (!$default && $where <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->courttypeCourtTypeID->AdvancedSearch->save(); // courttypeCourtTypeID
			$this->CourtType->AdvancedSearch->save(); // CourtType
			$this->CourtTypeEn->AdvancedSearch->save(); // CourtTypeEn
			$this->CourtTypeNotes->AdvancedSearch->save(); // CourtTypeNotes
			$this->courtLocationCourtLocationID->AdvancedSearch->save(); // courtLocationCourtLocationID
			$this->CourtLocation->AdvancedSearch->save(); // CourtLocation
			$this->CourtLocationEn->AdvancedSearch->save(); // CourtLocationEn
			$this->CourtLocationGovernorateID->AdvancedSearch->save(); // CourtLocationGovernorateID
			$this->CourtLocationNotes->AdvancedSearch->save(); // CourtLocationNotes
			$this->governoratesGovernorateID->AdvancedSearch->save(); // governoratesGovernorateID
			$this->Governorate->AdvancedSearch->save(); // Governorate
			$this->GovernorateEn->AdvancedSearch->save(); // GovernorateEn
			$this->GovernoratesNotes->AdvancedSearch->save(); // GovernoratesNotes
			$this->ChambersChamberID->AdvancedSearch->save(); // ChambersChamberID
			$this->Chamber->AdvancedSearch->save(); // Chamber
			$this->ChamberEn->AdvancedSearch->save(); // ChamberEn
			$this->chambersNotes->AdvancedSearch->save(); // chambersNotes
			$this->ChambersActivated->AdvancedSearch->save(); // ChambersActivated
			$this->sectionsSectionID->AdvancedSearch->save(); // sectionsSectionID
			$this->Section->AdvancedSearch->save(); // Section
			$this->SectionEn->AdvancedSearch->save(); // SectionEn
			$this->SectionsNotes->AdvancedSearch->save(); // SectionsNotes
			$this->SectionsActivated->AdvancedSearch->save(); // SectionsActivated
			$this->CourtID->AdvancedSearch->save(); // CourtID
			$this->Court->AdvancedSearch->save(); // Court
			$this->CourtEn->AdvancedSearch->save(); // CourtEn
			$this->CourtTypeID->AdvancedSearch->save(); // CourtTypeID
			$this->ChamberID->AdvancedSearch->save(); // ChamberID
			$this->CourtLocationID->AdvancedSearch->save(); // CourtLocationID
			$this->GovernorateID->AdvancedSearch->save(); // GovernorateID
			$this->SectionID->AdvancedSearch->save(); // SectionID
			$this->AddressID->AdvancedSearch->save(); // AddressID
			$this->ContactID->AdvancedSearch->save(); // ContactID
			$this->Activated->AdvancedSearch->save(); // Activated
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (SEARCH_MULTI_VALUE_OPTION == 1)
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal <> "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 <> "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 <> "")
				$wrk = ($wrk <> "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == NULL_VALUE || $fldVal == NOT_NULL_VALUE)
			return $fldVal;
		$value = $fldVal;
		if ($fld->DataType == DATATYPE_BOOLEAN) {
			if ($fldVal <> "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal <> "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->CourtType, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->CourtTypeEn, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->CourtTypeNotes, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->CourtLocation, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->CourtLocationEn, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->CourtLocationNotes, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Governorate, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->GovernorateEn, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->GovernoratesNotes, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Chamber, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->ChamberEn, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->chambersNotes, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Section, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->SectionEn, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->SectionsNotes, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Court, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->CourtEn, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		global $BASIC_SEARCH_IGNORE_PATTERN;
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if ($BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$keyword = preg_replace($BASIC_SEARCH_IGNORE_PATTERN, "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = array($keyword);
			}
			foreach ($ar as $keyword) {
				if ($keyword <> "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == NULL_VALUE) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == NOT_NULL_VALUE) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk <> "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] <> "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql <> "") {
			if ($where <> "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword <> "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword <> "") {
						if ($searchStr <> "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql(array($keyword), $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, array("", "reset", "resetall")))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->courttypeCourtTypeID->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->CourtType->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->CourtTypeEn->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->CourtTypeNotes->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->courtLocationCourtLocationID->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->CourtLocation->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->CourtLocationEn->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->CourtLocationGovernorateID->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->CourtLocationNotes->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->governoratesGovernorateID->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Governorate->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->GovernorateEn->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->GovernoratesNotes->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->ChambersChamberID->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Chamber->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->ChamberEn->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->chambersNotes->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->ChambersActivated->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->sectionsSectionID->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Section->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->SectionEn->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->SectionsNotes->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->SectionsActivated->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->CourtID->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Court->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->CourtEn->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->CourtTypeID->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->ChamberID->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->CourtLocationID->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->GovernorateID->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->SectionID->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->AddressID->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->ContactID->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Activated->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->courttypeCourtTypeID->AdvancedSearch->unsetSession();
		$this->CourtType->AdvancedSearch->unsetSession();
		$this->CourtTypeEn->AdvancedSearch->unsetSession();
		$this->CourtTypeNotes->AdvancedSearch->unsetSession();
		$this->courtLocationCourtLocationID->AdvancedSearch->unsetSession();
		$this->CourtLocation->AdvancedSearch->unsetSession();
		$this->CourtLocationEn->AdvancedSearch->unsetSession();
		$this->CourtLocationGovernorateID->AdvancedSearch->unsetSession();
		$this->CourtLocationNotes->AdvancedSearch->unsetSession();
		$this->governoratesGovernorateID->AdvancedSearch->unsetSession();
		$this->Governorate->AdvancedSearch->unsetSession();
		$this->GovernorateEn->AdvancedSearch->unsetSession();
		$this->GovernoratesNotes->AdvancedSearch->unsetSession();
		$this->ChambersChamberID->AdvancedSearch->unsetSession();
		$this->Chamber->AdvancedSearch->unsetSession();
		$this->ChamberEn->AdvancedSearch->unsetSession();
		$this->chambersNotes->AdvancedSearch->unsetSession();
		$this->ChambersActivated->AdvancedSearch->unsetSession();
		$this->sectionsSectionID->AdvancedSearch->unsetSession();
		$this->Section->AdvancedSearch->unsetSession();
		$this->SectionEn->AdvancedSearch->unsetSession();
		$this->SectionsNotes->AdvancedSearch->unsetSession();
		$this->SectionsActivated->AdvancedSearch->unsetSession();
		$this->CourtID->AdvancedSearch->unsetSession();
		$this->Court->AdvancedSearch->unsetSession();
		$this->CourtEn->AdvancedSearch->unsetSession();
		$this->CourtTypeID->AdvancedSearch->unsetSession();
		$this->ChamberID->AdvancedSearch->unsetSession();
		$this->CourtLocationID->AdvancedSearch->unsetSession();
		$this->GovernorateID->AdvancedSearch->unsetSession();
		$this->SectionID->AdvancedSearch->unsetSession();
		$this->AddressID->AdvancedSearch->unsetSession();
		$this->ContactID->AdvancedSearch->unsetSession();
		$this->Activated->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->courttypeCourtTypeID->AdvancedSearch->load();
		$this->CourtType->AdvancedSearch->load();
		$this->CourtTypeEn->AdvancedSearch->load();
		$this->CourtTypeNotes->AdvancedSearch->load();
		$this->courtLocationCourtLocationID->AdvancedSearch->load();
		$this->CourtLocation->AdvancedSearch->load();
		$this->CourtLocationEn->AdvancedSearch->load();
		$this->CourtLocationGovernorateID->AdvancedSearch->load();
		$this->CourtLocationNotes->AdvancedSearch->load();
		$this->governoratesGovernorateID->AdvancedSearch->load();
		$this->Governorate->AdvancedSearch->load();
		$this->GovernorateEn->AdvancedSearch->load();
		$this->GovernoratesNotes->AdvancedSearch->load();
		$this->ChambersChamberID->AdvancedSearch->load();
		$this->Chamber->AdvancedSearch->load();
		$this->ChamberEn->AdvancedSearch->load();
		$this->chambersNotes->AdvancedSearch->load();
		$this->ChambersActivated->AdvancedSearch->load();
		$this->sectionsSectionID->AdvancedSearch->load();
		$this->Section->AdvancedSearch->load();
		$this->SectionEn->AdvancedSearch->load();
		$this->SectionsNotes->AdvancedSearch->load();
		$this->SectionsActivated->AdvancedSearch->load();
		$this->CourtID->AdvancedSearch->load();
		$this->Court->AdvancedSearch->load();
		$this->CourtEn->AdvancedSearch->load();
		$this->CourtTypeID->AdvancedSearch->load();
		$this->ChamberID->AdvancedSearch->load();
		$this->CourtLocationID->AdvancedSearch->load();
		$this->GovernorateID->AdvancedSearch->load();
		$this->SectionID->AdvancedSearch->load();
		$this->AddressID->AdvancedSearch->load();
		$this->ContactID->AdvancedSearch->load();
		$this->Activated->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for Ctrl pressed
		$ctrl = Get("ctrl") !== NULL;

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->courttypeCourtTypeID, $ctrl); // courttypeCourtTypeID
			$this->updateSort($this->CourtType, $ctrl); // CourtType
			$this->updateSort($this->CourtTypeEn, $ctrl); // CourtTypeEn
			$this->updateSort($this->CourtTypeNotes, $ctrl); // CourtTypeNotes
			$this->updateSort($this->courtLocationCourtLocationID, $ctrl); // courtLocationCourtLocationID
			$this->updateSort($this->CourtLocation, $ctrl); // CourtLocation
			$this->updateSort($this->CourtLocationEn, $ctrl); // CourtLocationEn
			$this->updateSort($this->CourtLocationGovernorateID, $ctrl); // CourtLocationGovernorateID
			$this->updateSort($this->CourtLocationNotes, $ctrl); // CourtLocationNotes
			$this->updateSort($this->governoratesGovernorateID, $ctrl); // governoratesGovernorateID
			$this->updateSort($this->Governorate, $ctrl); // Governorate
			$this->updateSort($this->GovernorateEn, $ctrl); // GovernorateEn
			$this->updateSort($this->GovernoratesNotes, $ctrl); // GovernoratesNotes
			$this->updateSort($this->ChambersChamberID, $ctrl); // ChambersChamberID
			$this->updateSort($this->Chamber, $ctrl); // Chamber
			$this->updateSort($this->ChamberEn, $ctrl); // ChamberEn
			$this->updateSort($this->ChambersActivated, $ctrl); // ChambersActivated
			$this->updateSort($this->sectionsSectionID, $ctrl); // sectionsSectionID
			$this->updateSort($this->Section, $ctrl); // Section
			$this->updateSort($this->SectionEn, $ctrl); // SectionEn
			$this->updateSort($this->SectionsActivated, $ctrl); // SectionsActivated
			$this->updateSort($this->CourtID, $ctrl); // CourtID
			$this->updateSort($this->Court, $ctrl); // Court
			$this->updateSort($this->CourtEn, $ctrl); // CourtEn
			$this->updateSort($this->CourtTypeID, $ctrl); // CourtTypeID
			$this->updateSort($this->ChamberID, $ctrl); // ChamberID
			$this->updateSort($this->CourtLocationID, $ctrl); // CourtLocationID
			$this->updateSort($this->GovernorateID, $ctrl); // GovernorateID
			$this->updateSort($this->SectionID, $ctrl); // SectionID
			$this->updateSort($this->AddressID, $ctrl); // AddressID
			$this->updateSort($this->ContactID, $ctrl); // ContactID
			$this->updateSort($this->Activated, $ctrl); // Activated
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->courttypeCourtTypeID->setSort("");
				$this->CourtType->setSort("");
				$this->CourtTypeEn->setSort("");
				$this->CourtTypeNotes->setSort("");
				$this->courtLocationCourtLocationID->setSort("");
				$this->CourtLocation->setSort("");
				$this->CourtLocationEn->setSort("");
				$this->CourtLocationGovernorateID->setSort("");
				$this->CourtLocationNotes->setSort("");
				$this->governoratesGovernorateID->setSort("");
				$this->Governorate->setSort("");
				$this->GovernorateEn->setSort("");
				$this->GovernoratesNotes->setSort("");
				$this->ChambersChamberID->setSort("");
				$this->Chamber->setSort("");
				$this->ChamberEn->setSort("");
				$this->ChambersActivated->setSort("");
				$this->sectionsSectionID->setSort("");
				$this->Section->setSort("");
				$this->SectionEn->setSort("");
				$this->SectionsActivated->setSort("");
				$this->CourtID->setSort("");
				$this->Court->setSort("");
				$this->CourtEn->setSort("");
				$this->CourtTypeID->setSort("");
				$this->ChamberID->setSort("");
				$this->CourtLocationID->setSort("");
				$this->GovernorateID->setSort("");
				$this->SectionID->setSort("");
				$this->AddressID->setSort("");
				$this->ContactID->setSort("");
				$this->Activated->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew.selectAllKey(this);\">";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// Set up list action buttons
		$opt = &$this->ListOptions->getItem("listactions");
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $Language->phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = &$this->ListOptions->Items["checkbox"];
		$opt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ew-multi-select\" value=\"" . HtmlEncode($this->courttypeCourtTypeID->CurrentValue . $GLOBALS["COMPOSITE_KEY_SEPARATOR"] . $this->courtLocationCourtLocationID->CurrentValue . $GLOBALS["COMPOSITE_KEY_SEPARATOR"] . $this->governoratesGovernorateID->CurrentValue . $GLOBALS["COMPOSITE_KEY_SEPARATOR"] . $this->ChambersChamberID->CurrentValue . $GLOBALS["COMPOSITE_KEY_SEPARATOR"] . $this->sectionsSectionID->CurrentValue . $GLOBALS["COMPOSITE_KEY_SEPARATOR"] . $this->CourtID->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\">";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fcourtsvlistsrch\" href=\"#\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fcourtsvlistsrch\" href=\"#\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({f:document.fcourtsvlist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->getItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter <> "" && $userAction <> "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions->Items[$userAction]->Caption;
				if (!$this->ListActions->Items[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere <> "") ? " active" : " active";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fcourtsvlistsrch\">" . $Language->phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}
	protected function setupListOptionsExt()
	{
		global $Security, $Language;

		// Hide detail items for dropdown if necessary
		$this->ListOptions->hideDetailItemsForDropDown();
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(TABLE_BASIC_SEARCH, ""), FALSE);
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(TABLE_BASIC_SEARCH_TYPE, ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// courttypeCourtTypeID

		if (!$this->isAddOrEdit())
			$this->courttypeCourtTypeID->AdvancedSearch->setSearchValue(Get("x_courttypeCourtTypeID", Get("courttypeCourtTypeID", "")));
		if ($this->courttypeCourtTypeID->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->courttypeCourtTypeID->AdvancedSearch->setSearchOperator(Get("z_courttypeCourtTypeID", ""));

		// CourtType
		if (!$this->isAddOrEdit())
			$this->CourtType->AdvancedSearch->setSearchValue(Get("x_CourtType", Get("CourtType", "")));
		if ($this->CourtType->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->CourtType->AdvancedSearch->setSearchOperator(Get("z_CourtType", ""));

		// CourtTypeEn
		if (!$this->isAddOrEdit())
			$this->CourtTypeEn->AdvancedSearch->setSearchValue(Get("x_CourtTypeEn", Get("CourtTypeEn", "")));
		if ($this->CourtTypeEn->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->CourtTypeEn->AdvancedSearch->setSearchOperator(Get("z_CourtTypeEn", ""));

		// CourtTypeNotes
		if (!$this->isAddOrEdit())
			$this->CourtTypeNotes->AdvancedSearch->setSearchValue(Get("x_CourtTypeNotes", Get("CourtTypeNotes", "")));
		if ($this->CourtTypeNotes->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->CourtTypeNotes->AdvancedSearch->setSearchOperator(Get("z_CourtTypeNotes", ""));

		// courtLocationCourtLocationID
		if (!$this->isAddOrEdit())
			$this->courtLocationCourtLocationID->AdvancedSearch->setSearchValue(Get("x_courtLocationCourtLocationID", Get("courtLocationCourtLocationID", "")));
		if ($this->courtLocationCourtLocationID->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->courtLocationCourtLocationID->AdvancedSearch->setSearchOperator(Get("z_courtLocationCourtLocationID", ""));

		// CourtLocation
		if (!$this->isAddOrEdit())
			$this->CourtLocation->AdvancedSearch->setSearchValue(Get("x_CourtLocation", Get("CourtLocation", "")));
		if ($this->CourtLocation->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->CourtLocation->AdvancedSearch->setSearchOperator(Get("z_CourtLocation", ""));

		// CourtLocationEn
		if (!$this->isAddOrEdit())
			$this->CourtLocationEn->AdvancedSearch->setSearchValue(Get("x_CourtLocationEn", Get("CourtLocationEn", "")));
		if ($this->CourtLocationEn->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->CourtLocationEn->AdvancedSearch->setSearchOperator(Get("z_CourtLocationEn", ""));

		// CourtLocationGovernorateID
		if (!$this->isAddOrEdit())
			$this->CourtLocationGovernorateID->AdvancedSearch->setSearchValue(Get("x_CourtLocationGovernorateID", Get("CourtLocationGovernorateID", "")));
		if ($this->CourtLocationGovernorateID->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->CourtLocationGovernorateID->AdvancedSearch->setSearchOperator(Get("z_CourtLocationGovernorateID", ""));

		// CourtLocationNotes
		if (!$this->isAddOrEdit())
			$this->CourtLocationNotes->AdvancedSearch->setSearchValue(Get("x_CourtLocationNotes", Get("CourtLocationNotes", "")));
		if ($this->CourtLocationNotes->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->CourtLocationNotes->AdvancedSearch->setSearchOperator(Get("z_CourtLocationNotes", ""));

		// governoratesGovernorateID
		if (!$this->isAddOrEdit())
			$this->governoratesGovernorateID->AdvancedSearch->setSearchValue(Get("x_governoratesGovernorateID", Get("governoratesGovernorateID", "")));
		if ($this->governoratesGovernorateID->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->governoratesGovernorateID->AdvancedSearch->setSearchOperator(Get("z_governoratesGovernorateID", ""));

		// Governorate
		if (!$this->isAddOrEdit())
			$this->Governorate->AdvancedSearch->setSearchValue(Get("x_Governorate", Get("Governorate", "")));
		if ($this->Governorate->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->Governorate->AdvancedSearch->setSearchOperator(Get("z_Governorate", ""));

		// GovernorateEn
		if (!$this->isAddOrEdit())
			$this->GovernorateEn->AdvancedSearch->setSearchValue(Get("x_GovernorateEn", Get("GovernorateEn", "")));
		if ($this->GovernorateEn->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->GovernorateEn->AdvancedSearch->setSearchOperator(Get("z_GovernorateEn", ""));

		// GovernoratesNotes
		if (!$this->isAddOrEdit())
			$this->GovernoratesNotes->AdvancedSearch->setSearchValue(Get("x_GovernoratesNotes", Get("GovernoratesNotes", "")));
		if ($this->GovernoratesNotes->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->GovernoratesNotes->AdvancedSearch->setSearchOperator(Get("z_GovernoratesNotes", ""));

		// ChambersChamberID
		if (!$this->isAddOrEdit())
			$this->ChambersChamberID->AdvancedSearch->setSearchValue(Get("x_ChambersChamberID", Get("ChambersChamberID", "")));
		if ($this->ChambersChamberID->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->ChambersChamberID->AdvancedSearch->setSearchOperator(Get("z_ChambersChamberID", ""));

		// Chamber
		if (!$this->isAddOrEdit())
			$this->Chamber->AdvancedSearch->setSearchValue(Get("x_Chamber", Get("Chamber", "")));
		if ($this->Chamber->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->Chamber->AdvancedSearch->setSearchOperator(Get("z_Chamber", ""));

		// ChamberEn
		if (!$this->isAddOrEdit())
			$this->ChamberEn->AdvancedSearch->setSearchValue(Get("x_ChamberEn", Get("ChamberEn", "")));
		if ($this->ChamberEn->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->ChamberEn->AdvancedSearch->setSearchOperator(Get("z_ChamberEn", ""));

		// chambersNotes
		if (!$this->isAddOrEdit())
			$this->chambersNotes->AdvancedSearch->setSearchValue(Get("x_chambersNotes", Get("chambersNotes", "")));
		if ($this->chambersNotes->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->chambersNotes->AdvancedSearch->setSearchOperator(Get("z_chambersNotes", ""));

		// ChambersActivated
		if (!$this->isAddOrEdit())
			$this->ChambersActivated->AdvancedSearch->setSearchValue(Get("x_ChambersActivated", Get("ChambersActivated", "")));
		if ($this->ChambersActivated->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->ChambersActivated->AdvancedSearch->setSearchOperator(Get("z_ChambersActivated", ""));
		if (is_array($this->ChambersActivated->AdvancedSearch->SearchValue))
			$this->ChambersActivated->AdvancedSearch->SearchValue = implode(",", $this->ChambersActivated->AdvancedSearch->SearchValue);
		if (is_array($this->ChambersActivated->AdvancedSearch->SearchValue2))
			$this->ChambersActivated->AdvancedSearch->SearchValue2 = implode(",", $this->ChambersActivated->AdvancedSearch->SearchValue2);

		// sectionsSectionID
		if (!$this->isAddOrEdit())
			$this->sectionsSectionID->AdvancedSearch->setSearchValue(Get("x_sectionsSectionID", Get("sectionsSectionID", "")));
		if ($this->sectionsSectionID->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->sectionsSectionID->AdvancedSearch->setSearchOperator(Get("z_sectionsSectionID", ""));

		// Section
		if (!$this->isAddOrEdit())
			$this->Section->AdvancedSearch->setSearchValue(Get("x_Section", Get("Section", "")));
		if ($this->Section->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->Section->AdvancedSearch->setSearchOperator(Get("z_Section", ""));

		// SectionEn
		if (!$this->isAddOrEdit())
			$this->SectionEn->AdvancedSearch->setSearchValue(Get("x_SectionEn", Get("SectionEn", "")));
		if ($this->SectionEn->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->SectionEn->AdvancedSearch->setSearchOperator(Get("z_SectionEn", ""));

		// SectionsNotes
		if (!$this->isAddOrEdit())
			$this->SectionsNotes->AdvancedSearch->setSearchValue(Get("x_SectionsNotes", Get("SectionsNotes", "")));
		if ($this->SectionsNotes->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->SectionsNotes->AdvancedSearch->setSearchOperator(Get("z_SectionsNotes", ""));

		// SectionsActivated
		if (!$this->isAddOrEdit())
			$this->SectionsActivated->AdvancedSearch->setSearchValue(Get("x_SectionsActivated", Get("SectionsActivated", "")));
		if ($this->SectionsActivated->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->SectionsActivated->AdvancedSearch->setSearchOperator(Get("z_SectionsActivated", ""));
		if (is_array($this->SectionsActivated->AdvancedSearch->SearchValue))
			$this->SectionsActivated->AdvancedSearch->SearchValue = implode(",", $this->SectionsActivated->AdvancedSearch->SearchValue);
		if (is_array($this->SectionsActivated->AdvancedSearch->SearchValue2))
			$this->SectionsActivated->AdvancedSearch->SearchValue2 = implode(",", $this->SectionsActivated->AdvancedSearch->SearchValue2);

		// CourtID
		if (!$this->isAddOrEdit())
			$this->CourtID->AdvancedSearch->setSearchValue(Get("x_CourtID", Get("CourtID", "")));
		if ($this->CourtID->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->CourtID->AdvancedSearch->setSearchOperator(Get("z_CourtID", ""));

		// Court
		if (!$this->isAddOrEdit())
			$this->Court->AdvancedSearch->setSearchValue(Get("x_Court", Get("Court", "")));
		if ($this->Court->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->Court->AdvancedSearch->setSearchOperator(Get("z_Court", ""));

		// CourtEn
		if (!$this->isAddOrEdit())
			$this->CourtEn->AdvancedSearch->setSearchValue(Get("x_CourtEn", Get("CourtEn", "")));
		if ($this->CourtEn->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->CourtEn->AdvancedSearch->setSearchOperator(Get("z_CourtEn", ""));

		// CourtTypeID
		if (!$this->isAddOrEdit())
			$this->CourtTypeID->AdvancedSearch->setSearchValue(Get("x_CourtTypeID", Get("CourtTypeID", "")));
		if ($this->CourtTypeID->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->CourtTypeID->AdvancedSearch->setSearchOperator(Get("z_CourtTypeID", ""));

		// ChamberID
		if (!$this->isAddOrEdit())
			$this->ChamberID->AdvancedSearch->setSearchValue(Get("x_ChamberID", Get("ChamberID", "")));
		if ($this->ChamberID->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->ChamberID->AdvancedSearch->setSearchOperator(Get("z_ChamberID", ""));

		// CourtLocationID
		if (!$this->isAddOrEdit())
			$this->CourtLocationID->AdvancedSearch->setSearchValue(Get("x_CourtLocationID", Get("CourtLocationID", "")));
		if ($this->CourtLocationID->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->CourtLocationID->AdvancedSearch->setSearchOperator(Get("z_CourtLocationID", ""));

		// GovernorateID
		if (!$this->isAddOrEdit())
			$this->GovernorateID->AdvancedSearch->setSearchValue(Get("x_GovernorateID", Get("GovernorateID", "")));
		if ($this->GovernorateID->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->GovernorateID->AdvancedSearch->setSearchOperator(Get("z_GovernorateID", ""));

		// SectionID
		if (!$this->isAddOrEdit())
			$this->SectionID->AdvancedSearch->setSearchValue(Get("x_SectionID", Get("SectionID", "")));
		if ($this->SectionID->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->SectionID->AdvancedSearch->setSearchOperator(Get("z_SectionID", ""));

		// AddressID
		if (!$this->isAddOrEdit())
			$this->AddressID->AdvancedSearch->setSearchValue(Get("x_AddressID", Get("AddressID", "")));
		if ($this->AddressID->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->AddressID->AdvancedSearch->setSearchOperator(Get("z_AddressID", ""));

		// ContactID
		if (!$this->isAddOrEdit())
			$this->ContactID->AdvancedSearch->setSearchValue(Get("x_ContactID", Get("ContactID", "")));
		if ($this->ContactID->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->ContactID->AdvancedSearch->setSearchOperator(Get("z_ContactID", ""));

		// Activated
		if (!$this->isAddOrEdit())
			$this->Activated->AdvancedSearch->setSearchValue(Get("x_Activated", Get("Activated", "")));
		if ($this->Activated->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->Activated->AdvancedSearch->setSearchOperator(Get("z_Activated", ""));
		if (is_array($this->Activated->AdvancedSearch->SearchValue))
			$this->Activated->AdvancedSearch->SearchValue = implode(",", $this->Activated->AdvancedSearch->SearchValue);
		if (is_array($this->Activated->AdvancedSearch->SearchValue2))
			$this->Activated->AdvancedSearch->SearchValue2 = implode(",", $this->Activated->AdvancedSearch->SearchValue2);
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->courttypeCourtTypeID->setDbValue($row['courttypeCourtTypeID']);
		$this->CourtType->setDbValue($row['CourtType']);
		$this->CourtTypeEn->setDbValue($row['CourtTypeEn']);
		$this->CourtTypeNotes->setDbValue($row['CourtTypeNotes']);
		$this->courtLocationCourtLocationID->setDbValue($row['courtLocationCourtLocationID']);
		$this->CourtLocation->setDbValue($row['CourtLocation']);
		$this->CourtLocationEn->setDbValue($row['CourtLocationEn']);
		$this->CourtLocationGovernorateID->setDbValue($row['CourtLocationGovernorateID']);
		$this->CourtLocationNotes->setDbValue($row['CourtLocationNotes']);
		$this->governoratesGovernorateID->setDbValue($row['governoratesGovernorateID']);
		$this->Governorate->setDbValue($row['Governorate']);
		$this->GovernorateEn->setDbValue($row['GovernorateEn']);
		$this->GovernoratesNotes->setDbValue($row['GovernoratesNotes']);
		$this->ChambersChamberID->setDbValue($row['ChambersChamberID']);
		$this->Chamber->setDbValue($row['Chamber']);
		$this->ChamberEn->setDbValue($row['ChamberEn']);
		$this->chambersNotes->setDbValue($row['chambersNotes']);
		$this->ChambersActivated->setDbValue($row['ChambersActivated']);
		$this->sectionsSectionID->setDbValue($row['sectionsSectionID']);
		$this->Section->setDbValue($row['Section']);
		$this->SectionEn->setDbValue($row['SectionEn']);
		$this->SectionsNotes->setDbValue($row['SectionsNotes']);
		$this->SectionsActivated->setDbValue($row['SectionsActivated']);
		$this->CourtID->setDbValue($row['CourtID']);
		$this->Court->setDbValue($row['Court']);
		$this->CourtEn->setDbValue($row['CourtEn']);
		$this->CourtTypeID->setDbValue($row['CourtTypeID']);
		$this->ChamberID->setDbValue($row['ChamberID']);
		$this->CourtLocationID->setDbValue($row['CourtLocationID']);
		$this->GovernorateID->setDbValue($row['GovernorateID']);
		$this->SectionID->setDbValue($row['SectionID']);
		$this->AddressID->setDbValue($row['AddressID']);
		$this->ContactID->setDbValue($row['ContactID']);
		$this->Activated->setDbValue($row['Activated']);
		$this->Notes->setDbValue($row['Notes']);
		$this->_UserID->setDbValue($row['UserID']);
		$this->CreatedBy->setDbValue($row['CreatedBy']);
		$this->CreatedDate->setDbValue($row['CreatedDate']);
		$this->UpdatedBy->setDbValue($row['UpdatedBy']);
		$this->UpdatedDate->setDbValue($row['UpdatedDate']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['courttypeCourtTypeID'] = NULL;
		$row['CourtType'] = NULL;
		$row['CourtTypeEn'] = NULL;
		$row['CourtTypeNotes'] = NULL;
		$row['courtLocationCourtLocationID'] = NULL;
		$row['CourtLocation'] = NULL;
		$row['CourtLocationEn'] = NULL;
		$row['CourtLocationGovernorateID'] = NULL;
		$row['CourtLocationNotes'] = NULL;
		$row['governoratesGovernorateID'] = NULL;
		$row['Governorate'] = NULL;
		$row['GovernorateEn'] = NULL;
		$row['GovernoratesNotes'] = NULL;
		$row['ChambersChamberID'] = NULL;
		$row['Chamber'] = NULL;
		$row['ChamberEn'] = NULL;
		$row['chambersNotes'] = NULL;
		$row['ChambersActivated'] = NULL;
		$row['sectionsSectionID'] = NULL;
		$row['Section'] = NULL;
		$row['SectionEn'] = NULL;
		$row['SectionsNotes'] = NULL;
		$row['SectionsActivated'] = NULL;
		$row['CourtID'] = NULL;
		$row['Court'] = NULL;
		$row['CourtEn'] = NULL;
		$row['CourtTypeID'] = NULL;
		$row['ChamberID'] = NULL;
		$row['CourtLocationID'] = NULL;
		$row['GovernorateID'] = NULL;
		$row['SectionID'] = NULL;
		$row['AddressID'] = NULL;
		$row['ContactID'] = NULL;
		$row['Activated'] = NULL;
		$row['Notes'] = NULL;
		$row['UserID'] = NULL;
		$row['CreatedBy'] = NULL;
		$row['CreatedDate'] = NULL;
		$row['UpdatedBy'] = NULL;
		$row['UpdatedDate'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("courttypeCourtTypeID")) <> "")
			$this->courttypeCourtTypeID->CurrentValue = $this->getKey("courttypeCourtTypeID"); // courttypeCourtTypeID
		else
			$validKey = FALSE;
		if (strval($this->getKey("courtLocationCourtLocationID")) <> "")
			$this->courtLocationCourtLocationID->CurrentValue = $this->getKey("courtLocationCourtLocationID"); // courtLocationCourtLocationID
		else
			$validKey = FALSE;
		if (strval($this->getKey("governoratesGovernorateID")) <> "")
			$this->governoratesGovernorateID->CurrentValue = $this->getKey("governoratesGovernorateID"); // governoratesGovernorateID
		else
			$validKey = FALSE;
		if (strval($this->getKey("ChambersChamberID")) <> "")
			$this->ChambersChamberID->CurrentValue = $this->getKey("ChambersChamberID"); // ChambersChamberID
		else
			$validKey = FALSE;
		if (strval($this->getKey("sectionsSectionID")) <> "")
			$this->sectionsSectionID->CurrentValue = $this->getKey("sectionsSectionID"); // sectionsSectionID
		else
			$validKey = FALSE;
		if (strval($this->getKey("CourtID")) <> "")
			$this->CourtID->CurrentValue = $this->getKey("CourtID"); // CourtID
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// courttypeCourtTypeID
		// CourtType
		// CourtTypeEn
		// CourtTypeNotes
		// courtLocationCourtLocationID
		// CourtLocation
		// CourtLocationEn
		// CourtLocationGovernorateID
		// CourtLocationNotes
		// governoratesGovernorateID
		// Governorate
		// GovernorateEn
		// GovernoratesNotes
		// ChambersChamberID
		// Chamber
		// ChamberEn
		// chambersNotes
		// ChambersActivated
		// sectionsSectionID
		// Section
		// SectionEn
		// SectionsNotes
		// SectionsActivated
		// CourtID
		// Court
		// CourtEn
		// CourtTypeID
		// ChamberID
		// CourtLocationID
		// GovernorateID
		// SectionID
		// AddressID
		// ContactID
		// Activated
		// Notes

		$this->Notes->CellCssStyle = "white-space: nowrap;";

		// UserID
		$this->_UserID->CellCssStyle = "white-space: nowrap;";

		// CreatedBy
		$this->CreatedBy->CellCssStyle = "white-space: nowrap;";

		// CreatedDate
		$this->CreatedDate->CellCssStyle = "white-space: nowrap;";

		// UpdatedBy
		$this->UpdatedBy->CellCssStyle = "white-space: nowrap;";

		// UpdatedDate
		$this->UpdatedDate->CellCssStyle = "white-space: nowrap;";
		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// courttypeCourtTypeID
			$this->courttypeCourtTypeID->ViewValue = $this->courttypeCourtTypeID->CurrentValue;
			$this->courttypeCourtTypeID->ViewCustomAttributes = "";

			// CourtType
			$this->CourtType->ViewValue = $this->CourtType->CurrentValue;
			$this->CourtType->ViewCustomAttributes = "";

			// CourtTypeEn
			$this->CourtTypeEn->ViewValue = $this->CourtTypeEn->CurrentValue;
			$this->CourtTypeEn->ViewCustomAttributes = "";

			// CourtTypeNotes
			$this->CourtTypeNotes->ViewValue = $this->CourtTypeNotes->CurrentValue;
			$this->CourtTypeNotes->ViewCustomAttributes = "";

			// courtLocationCourtLocationID
			$this->courtLocationCourtLocationID->ViewValue = $this->courtLocationCourtLocationID->CurrentValue;
			$this->courtLocationCourtLocationID->ViewCustomAttributes = "";

			// CourtLocation
			$this->CourtLocation->ViewValue = $this->CourtLocation->CurrentValue;
			$this->CourtLocation->ViewCustomAttributes = "";

			// CourtLocationEn
			$this->CourtLocationEn->ViewValue = $this->CourtLocationEn->CurrentValue;
			$this->CourtLocationEn->ViewCustomAttributes = "";

			// CourtLocationGovernorateID
			$this->CourtLocationGovernorateID->ViewValue = $this->CourtLocationGovernorateID->CurrentValue;
			$this->CourtLocationGovernorateID->ViewValue = FormatNumber($this->CourtLocationGovernorateID->ViewValue, 0, -2, -2, -2);
			$this->CourtLocationGovernorateID->ViewCustomAttributes = "";

			// CourtLocationNotes
			$this->CourtLocationNotes->ViewValue = $this->CourtLocationNotes->CurrentValue;
			$this->CourtLocationNotes->ViewCustomAttributes = "";

			// governoratesGovernorateID
			$this->governoratesGovernorateID->ViewValue = $this->governoratesGovernorateID->CurrentValue;
			$this->governoratesGovernorateID->ViewCustomAttributes = "";

			// Governorate
			$this->Governorate->ViewValue = $this->Governorate->CurrentValue;
			$this->Governorate->ViewCustomAttributes = "";

			// GovernorateEn
			$this->GovernorateEn->ViewValue = $this->GovernorateEn->CurrentValue;
			$this->GovernorateEn->ViewCustomAttributes = "";

			// GovernoratesNotes
			$this->GovernoratesNotes->ViewValue = $this->GovernoratesNotes->CurrentValue;
			$this->GovernoratesNotes->ViewCustomAttributes = "";

			// ChambersChamberID
			$this->ChambersChamberID->ViewValue = $this->ChambersChamberID->CurrentValue;
			$this->ChambersChamberID->ViewCustomAttributes = "";

			// Chamber
			$this->Chamber->ViewValue = $this->Chamber->CurrentValue;
			$this->Chamber->ViewCustomAttributes = "";

			// ChamberEn
			$this->ChamberEn->ViewValue = $this->ChamberEn->CurrentValue;
			$this->ChamberEn->ViewCustomAttributes = "";

			// ChambersActivated
			if (ConvertToBool($this->ChambersActivated->CurrentValue)) {
				$this->ChambersActivated->ViewValue = $this->ChambersActivated->tagCaption(1) <> "" ? $this->ChambersActivated->tagCaption(1) : "Y";
			} else {
				$this->ChambersActivated->ViewValue = $this->ChambersActivated->tagCaption(2) <> "" ? $this->ChambersActivated->tagCaption(2) : "N";
			}
			$this->ChambersActivated->ViewCustomAttributes = "";

			// sectionsSectionID
			$this->sectionsSectionID->ViewValue = $this->sectionsSectionID->CurrentValue;
			$this->sectionsSectionID->ViewCustomAttributes = "";

			// Section
			$this->Section->ViewValue = $this->Section->CurrentValue;
			$this->Section->ViewCustomAttributes = "";

			// SectionEn
			$this->SectionEn->ViewValue = $this->SectionEn->CurrentValue;
			$this->SectionEn->ViewCustomAttributes = "";

			// SectionsActivated
			if (ConvertToBool($this->SectionsActivated->CurrentValue)) {
				$this->SectionsActivated->ViewValue = $this->SectionsActivated->tagCaption(1) <> "" ? $this->SectionsActivated->tagCaption(1) : "Y";
			} else {
				$this->SectionsActivated->ViewValue = $this->SectionsActivated->tagCaption(2) <> "" ? $this->SectionsActivated->tagCaption(2) : "N";
			}
			$this->SectionsActivated->ViewCustomAttributes = "";

			// CourtID
			$this->CourtID->ViewValue = $this->CourtID->CurrentValue;
			$this->CourtID->ViewCustomAttributes = "";

			// Court
			$this->Court->ViewValue = $this->Court->CurrentValue;
			$this->Court->ViewCustomAttributes = "";

			// CourtEn
			$this->CourtEn->ViewValue = $this->CourtEn->CurrentValue;
			$this->CourtEn->ViewCustomAttributes = "";

			// CourtTypeID
			$curVal = strval($this->CourtTypeID->CurrentValue);
			if ($curVal <> "") {
				$this->CourtTypeID->ViewValue = $this->CourtTypeID->lookupCacheOption($curVal);
				if ($this->CourtTypeID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CourtTypeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CourtTypeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CourtTypeID->ViewValue = $this->CourtTypeID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CourtTypeID->ViewValue = $this->CourtTypeID->CurrentValue;
					}
				}
			} else {
				$this->CourtTypeID->ViewValue = NULL;
			}
			$this->CourtTypeID->ViewCustomAttributes = "";

			// ChamberID
			$curVal = strval($this->ChamberID->CurrentValue);
			if ($curVal <> "") {
				$this->ChamberID->ViewValue = $this->ChamberID->lookupCacheOption($curVal);
				if ($this->ChamberID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`ChamberID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->ChamberID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->ChamberID->ViewValue = $this->ChamberID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ChamberID->ViewValue = $this->ChamberID->CurrentValue;
					}
				}
			} else {
				$this->ChamberID->ViewValue = NULL;
			}
			$this->ChamberID->ViewCustomAttributes = "";

			// CourtLocationID
			$curVal = strval($this->CourtLocationID->CurrentValue);
			if ($curVal <> "") {
				$this->CourtLocationID->ViewValue = $this->CourtLocationID->lookupCacheOption($curVal);
				if ($this->CourtLocationID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`CourtLocationID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->CourtLocationID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->CourtLocationID->ViewValue = $this->CourtLocationID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->CourtLocationID->ViewValue = $this->CourtLocationID->CurrentValue;
					}
				}
			} else {
				$this->CourtLocationID->ViewValue = NULL;
			}
			$this->CourtLocationID->ViewCustomAttributes = "";

			// GovernorateID
			$curVal = strval($this->GovernorateID->CurrentValue);
			if ($curVal <> "") {
				$this->GovernorateID->ViewValue = $this->GovernorateID->lookupCacheOption($curVal);
				if ($this->GovernorateID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`GovernorateID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->GovernorateID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->GovernorateID->ViewValue = $this->GovernorateID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->GovernorateID->ViewValue = $this->GovernorateID->CurrentValue;
					}
				}
			} else {
				$this->GovernorateID->ViewValue = NULL;
			}
			$this->GovernorateID->ViewCustomAttributes = "";

			// SectionID
			$curVal = strval($this->SectionID->CurrentValue);
			if ($curVal <> "") {
				$this->SectionID->ViewValue = $this->SectionID->lookupCacheOption($curVal);
				if ($this->SectionID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`SectionID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->SectionID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->SectionID->ViewValue = $this->SectionID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->SectionID->ViewValue = $this->SectionID->CurrentValue;
					}
				}
			} else {
				$this->SectionID->ViewValue = NULL;
			}
			$this->SectionID->ViewCustomAttributes = "";

			// AddressID
			$this->AddressID->ViewValue = $this->AddressID->CurrentValue;
			$this->AddressID->ViewValue = FormatNumber($this->AddressID->ViewValue, 0, -2, -2, -2);
			$this->AddressID->ViewCustomAttributes = "";

			// ContactID
			$this->ContactID->ViewValue = $this->ContactID->CurrentValue;
			$this->ContactID->ViewValue = FormatNumber($this->ContactID->ViewValue, 0, -2, -2, -2);
			$this->ContactID->ViewCustomAttributes = "";

			// Activated
			if (ConvertToBool($this->Activated->CurrentValue)) {
				$this->Activated->ViewValue = $this->Activated->tagCaption(1) <> "" ? $this->Activated->tagCaption(1) : "Y";
			} else {
				$this->Activated->ViewValue = $this->Activated->tagCaption(2) <> "" ? $this->Activated->tagCaption(2) : "N";
			}
			$this->Activated->ViewCustomAttributes = "";

			// Notes
			$this->Notes->ViewValue = $this->Notes->CurrentValue;
			$this->Notes->ViewCustomAttributes = "";

			// courttypeCourtTypeID
			$this->courttypeCourtTypeID->LinkCustomAttributes = "";
			$this->courttypeCourtTypeID->HrefValue = "";
			$this->courttypeCourtTypeID->TooltipValue = "";

			// CourtType
			$this->CourtType->LinkCustomAttributes = "";
			$this->CourtType->HrefValue = "";
			$this->CourtType->TooltipValue = "";

			// CourtTypeEn
			$this->CourtTypeEn->LinkCustomAttributes = "";
			$this->CourtTypeEn->HrefValue = "";
			$this->CourtTypeEn->TooltipValue = "";

			// CourtTypeNotes
			$this->CourtTypeNotes->LinkCustomAttributes = "";
			$this->CourtTypeNotes->HrefValue = "";
			$this->CourtTypeNotes->TooltipValue = "";

			// courtLocationCourtLocationID
			$this->courtLocationCourtLocationID->LinkCustomAttributes = "";
			$this->courtLocationCourtLocationID->HrefValue = "";
			$this->courtLocationCourtLocationID->TooltipValue = "";

			// CourtLocation
			$this->CourtLocation->LinkCustomAttributes = "";
			$this->CourtLocation->HrefValue = "";
			$this->CourtLocation->TooltipValue = "";

			// CourtLocationEn
			$this->CourtLocationEn->LinkCustomAttributes = "";
			$this->CourtLocationEn->HrefValue = "";
			$this->CourtLocationEn->TooltipValue = "";

			// CourtLocationGovernorateID
			$this->CourtLocationGovernorateID->LinkCustomAttributes = "";
			$this->CourtLocationGovernorateID->HrefValue = "";
			$this->CourtLocationGovernorateID->TooltipValue = "";

			// CourtLocationNotes
			$this->CourtLocationNotes->LinkCustomAttributes = "";
			$this->CourtLocationNotes->HrefValue = "";
			$this->CourtLocationNotes->TooltipValue = "";

			// governoratesGovernorateID
			$this->governoratesGovernorateID->LinkCustomAttributes = "";
			$this->governoratesGovernorateID->HrefValue = "";
			$this->governoratesGovernorateID->TooltipValue = "";

			// Governorate
			$this->Governorate->LinkCustomAttributes = "";
			$this->Governorate->HrefValue = "";
			$this->Governorate->TooltipValue = "";

			// GovernorateEn
			$this->GovernorateEn->LinkCustomAttributes = "";
			$this->GovernorateEn->HrefValue = "";
			$this->GovernorateEn->TooltipValue = "";

			// GovernoratesNotes
			$this->GovernoratesNotes->LinkCustomAttributes = "";
			$this->GovernoratesNotes->HrefValue = "";
			$this->GovernoratesNotes->TooltipValue = "";

			// ChambersChamberID
			$this->ChambersChamberID->LinkCustomAttributes = "";
			$this->ChambersChamberID->HrefValue = "";
			$this->ChambersChamberID->TooltipValue = "";

			// Chamber
			$this->Chamber->LinkCustomAttributes = "";
			$this->Chamber->HrefValue = "";
			$this->Chamber->TooltipValue = "";

			// ChamberEn
			$this->ChamberEn->LinkCustomAttributes = "";
			$this->ChamberEn->HrefValue = "";
			$this->ChamberEn->TooltipValue = "";

			// ChambersActivated
			$this->ChambersActivated->LinkCustomAttributes = "";
			$this->ChambersActivated->HrefValue = "";
			$this->ChambersActivated->TooltipValue = "";

			// sectionsSectionID
			$this->sectionsSectionID->LinkCustomAttributes = "";
			$this->sectionsSectionID->HrefValue = "";
			$this->sectionsSectionID->TooltipValue = "";

			// Section
			$this->Section->LinkCustomAttributes = "";
			$this->Section->HrefValue = "";
			$this->Section->TooltipValue = "";

			// SectionEn
			$this->SectionEn->LinkCustomAttributes = "";
			$this->SectionEn->HrefValue = "";
			$this->SectionEn->TooltipValue = "";

			// SectionsActivated
			$this->SectionsActivated->LinkCustomAttributes = "";
			$this->SectionsActivated->HrefValue = "";
			$this->SectionsActivated->TooltipValue = "";

			// CourtID
			$this->CourtID->LinkCustomAttributes = "";
			$this->CourtID->HrefValue = "";
			$this->CourtID->TooltipValue = "";

			// Court
			$this->Court->LinkCustomAttributes = "";
			$this->Court->HrefValue = "";
			$this->Court->TooltipValue = "";

			// CourtEn
			$this->CourtEn->LinkCustomAttributes = "";
			$this->CourtEn->HrefValue = "";
			$this->CourtEn->TooltipValue = "";

			// CourtTypeID
			$this->CourtTypeID->LinkCustomAttributes = "";
			$this->CourtTypeID->HrefValue = "";
			$this->CourtTypeID->TooltipValue = "";

			// ChamberID
			$this->ChamberID->LinkCustomAttributes = "";
			$this->ChamberID->HrefValue = "";
			$this->ChamberID->TooltipValue = "";

			// CourtLocationID
			$this->CourtLocationID->LinkCustomAttributes = "";
			$this->CourtLocationID->HrefValue = "";
			$this->CourtLocationID->TooltipValue = "";

			// GovernorateID
			$this->GovernorateID->LinkCustomAttributes = "";
			$this->GovernorateID->HrefValue = "";
			$this->GovernorateID->TooltipValue = "";

			// SectionID
			$this->SectionID->LinkCustomAttributes = "";
			$this->SectionID->HrefValue = "";
			$this->SectionID->TooltipValue = "";

			// AddressID
			$this->AddressID->LinkCustomAttributes = "";
			$this->AddressID->HrefValue = "";
			$this->AddressID->TooltipValue = "";

			// ContactID
			$this->ContactID->LinkCustomAttributes = "";
			$this->ContactID->HrefValue = "";
			$this->ContactID->TooltipValue = "";

			// Activated
			$this->Activated->LinkCustomAttributes = "";
			$this->Activated->HrefValue = "";
			$this->Activated->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// courttypeCourtTypeID
			$this->courttypeCourtTypeID->EditAttrs["class"] = "form-control";
			$this->courttypeCourtTypeID->EditCustomAttributes = "";
			$this->courttypeCourtTypeID->EditValue = HtmlEncode($this->courttypeCourtTypeID->AdvancedSearch->SearchValue);
			$this->courttypeCourtTypeID->PlaceHolder = RemoveHtml($this->courttypeCourtTypeID->caption());

			// CourtType
			$this->CourtType->EditAttrs["class"] = "form-control";
			$this->CourtType->EditCustomAttributes = "";
			$this->CourtType->EditValue = HtmlEncode($this->CourtType->AdvancedSearch->SearchValue);
			$this->CourtType->PlaceHolder = RemoveHtml($this->CourtType->caption());

			// CourtTypeEn
			$this->CourtTypeEn->EditAttrs["class"] = "form-control";
			$this->CourtTypeEn->EditCustomAttributes = "";
			$this->CourtTypeEn->EditValue = HtmlEncode($this->CourtTypeEn->AdvancedSearch->SearchValue);
			$this->CourtTypeEn->PlaceHolder = RemoveHtml($this->CourtTypeEn->caption());

			// CourtTypeNotes
			$this->CourtTypeNotes->EditAttrs["class"] = "form-control";
			$this->CourtTypeNotes->EditCustomAttributes = "";
			$this->CourtTypeNotes->EditValue = HtmlEncode($this->CourtTypeNotes->AdvancedSearch->SearchValue);
			$this->CourtTypeNotes->PlaceHolder = RemoveHtml($this->CourtTypeNotes->caption());

			// courtLocationCourtLocationID
			$this->courtLocationCourtLocationID->EditAttrs["class"] = "form-control";
			$this->courtLocationCourtLocationID->EditCustomAttributes = "";
			$this->courtLocationCourtLocationID->EditValue = HtmlEncode($this->courtLocationCourtLocationID->AdvancedSearch->SearchValue);
			$this->courtLocationCourtLocationID->PlaceHolder = RemoveHtml($this->courtLocationCourtLocationID->caption());

			// CourtLocation
			$this->CourtLocation->EditAttrs["class"] = "form-control";
			$this->CourtLocation->EditCustomAttributes = "";
			$this->CourtLocation->EditValue = HtmlEncode($this->CourtLocation->AdvancedSearch->SearchValue);
			$this->CourtLocation->PlaceHolder = RemoveHtml($this->CourtLocation->caption());

			// CourtLocationEn
			$this->CourtLocationEn->EditAttrs["class"] = "form-control";
			$this->CourtLocationEn->EditCustomAttributes = "";
			$this->CourtLocationEn->EditValue = HtmlEncode($this->CourtLocationEn->AdvancedSearch->SearchValue);
			$this->CourtLocationEn->PlaceHolder = RemoveHtml($this->CourtLocationEn->caption());

			// CourtLocationGovernorateID
			$this->CourtLocationGovernorateID->EditAttrs["class"] = "form-control";
			$this->CourtLocationGovernorateID->EditCustomAttributes = "";
			$this->CourtLocationGovernorateID->EditValue = HtmlEncode($this->CourtLocationGovernorateID->AdvancedSearch->SearchValue);
			$this->CourtLocationGovernorateID->PlaceHolder = RemoveHtml($this->CourtLocationGovernorateID->caption());

			// CourtLocationNotes
			$this->CourtLocationNotes->EditAttrs["class"] = "form-control";
			$this->CourtLocationNotes->EditCustomAttributes = "";
			$this->CourtLocationNotes->EditValue = HtmlEncode($this->CourtLocationNotes->AdvancedSearch->SearchValue);
			$this->CourtLocationNotes->PlaceHolder = RemoveHtml($this->CourtLocationNotes->caption());

			// governoratesGovernorateID
			$this->governoratesGovernorateID->EditAttrs["class"] = "form-control";
			$this->governoratesGovernorateID->EditCustomAttributes = "";
			$this->governoratesGovernorateID->EditValue = HtmlEncode($this->governoratesGovernorateID->AdvancedSearch->SearchValue);
			$this->governoratesGovernorateID->PlaceHolder = RemoveHtml($this->governoratesGovernorateID->caption());

			// Governorate
			$this->Governorate->EditAttrs["class"] = "form-control";
			$this->Governorate->EditCustomAttributes = "";
			$this->Governorate->EditValue = HtmlEncode($this->Governorate->AdvancedSearch->SearchValue);
			$this->Governorate->PlaceHolder = RemoveHtml($this->Governorate->caption());

			// GovernorateEn
			$this->GovernorateEn->EditAttrs["class"] = "form-control";
			$this->GovernorateEn->EditCustomAttributes = "";
			$this->GovernorateEn->EditValue = HtmlEncode($this->GovernorateEn->AdvancedSearch->SearchValue);
			$this->GovernorateEn->PlaceHolder = RemoveHtml($this->GovernorateEn->caption());

			// GovernoratesNotes
			$this->GovernoratesNotes->EditAttrs["class"] = "form-control";
			$this->GovernoratesNotes->EditCustomAttributes = "";
			$this->GovernoratesNotes->EditValue = HtmlEncode($this->GovernoratesNotes->AdvancedSearch->SearchValue);
			$this->GovernoratesNotes->PlaceHolder = RemoveHtml($this->GovernoratesNotes->caption());

			// ChambersChamberID
			$this->ChambersChamberID->EditAttrs["class"] = "form-control";
			$this->ChambersChamberID->EditCustomAttributes = "";
			$this->ChambersChamberID->EditValue = HtmlEncode($this->ChambersChamberID->AdvancedSearch->SearchValue);
			$this->ChambersChamberID->PlaceHolder = RemoveHtml($this->ChambersChamberID->caption());

			// Chamber
			$this->Chamber->EditAttrs["class"] = "form-control";
			$this->Chamber->EditCustomAttributes = "";
			$this->Chamber->EditValue = HtmlEncode($this->Chamber->AdvancedSearch->SearchValue);
			$this->Chamber->PlaceHolder = RemoveHtml($this->Chamber->caption());

			// ChamberEn
			$this->ChamberEn->EditAttrs["class"] = "form-control";
			$this->ChamberEn->EditCustomAttributes = "";
			$this->ChamberEn->EditValue = HtmlEncode($this->ChamberEn->AdvancedSearch->SearchValue);
			$this->ChamberEn->PlaceHolder = RemoveHtml($this->ChamberEn->caption());

			// ChambersActivated
			$this->ChambersActivated->EditCustomAttributes = "";
			$this->ChambersActivated->EditValue = $this->ChambersActivated->options(FALSE);

			// sectionsSectionID
			$this->sectionsSectionID->EditAttrs["class"] = "form-control";
			$this->sectionsSectionID->EditCustomAttributes = "";
			$this->sectionsSectionID->EditValue = HtmlEncode($this->sectionsSectionID->AdvancedSearch->SearchValue);
			$this->sectionsSectionID->PlaceHolder = RemoveHtml($this->sectionsSectionID->caption());

			// Section
			$this->Section->EditAttrs["class"] = "form-control";
			$this->Section->EditCustomAttributes = "";
			$this->Section->EditValue = HtmlEncode($this->Section->AdvancedSearch->SearchValue);
			$this->Section->PlaceHolder = RemoveHtml($this->Section->caption());

			// SectionEn
			$this->SectionEn->EditAttrs["class"] = "form-control";
			$this->SectionEn->EditCustomAttributes = "";
			$this->SectionEn->EditValue = HtmlEncode($this->SectionEn->AdvancedSearch->SearchValue);
			$this->SectionEn->PlaceHolder = RemoveHtml($this->SectionEn->caption());

			// SectionsActivated
			$this->SectionsActivated->EditCustomAttributes = "";
			$this->SectionsActivated->EditValue = $this->SectionsActivated->options(FALSE);

			// CourtID
			$this->CourtID->EditAttrs["class"] = "form-control";
			$this->CourtID->EditCustomAttributes = "";
			$this->CourtID->EditValue = HtmlEncode($this->CourtID->AdvancedSearch->SearchValue);
			$this->CourtID->PlaceHolder = RemoveHtml($this->CourtID->caption());

			// Court
			$this->Court->EditAttrs["class"] = "form-control";
			$this->Court->EditCustomAttributes = "";
			$this->Court->EditValue = HtmlEncode($this->Court->AdvancedSearch->SearchValue);
			$this->Court->PlaceHolder = RemoveHtml($this->Court->caption());

			// CourtEn
			$this->CourtEn->EditAttrs["class"] = "form-control";
			$this->CourtEn->EditCustomAttributes = "";
			$this->CourtEn->EditValue = HtmlEncode($this->CourtEn->AdvancedSearch->SearchValue);
			$this->CourtEn->PlaceHolder = RemoveHtml($this->CourtEn->caption());

			// CourtTypeID
			$this->CourtTypeID->EditAttrs["class"] = "form-control";
			$this->CourtTypeID->EditCustomAttributes = "";

			// ChamberID
			$this->ChamberID->EditAttrs["class"] = "form-control";
			$this->ChamberID->EditCustomAttributes = "";

			// CourtLocationID
			$this->CourtLocationID->EditAttrs["class"] = "form-control";
			$this->CourtLocationID->EditCustomAttributes = "";

			// GovernorateID
			$this->GovernorateID->EditAttrs["class"] = "form-control";
			$this->GovernorateID->EditCustomAttributes = "";

			// SectionID
			$this->SectionID->EditAttrs["class"] = "form-control";
			$this->SectionID->EditCustomAttributes = "";

			// AddressID
			$this->AddressID->EditAttrs["class"] = "form-control";
			$this->AddressID->EditCustomAttributes = "";
			$this->AddressID->EditValue = HtmlEncode($this->AddressID->AdvancedSearch->SearchValue);
			$this->AddressID->PlaceHolder = RemoveHtml($this->AddressID->caption());

			// ContactID
			$this->ContactID->EditAttrs["class"] = "form-control";
			$this->ContactID->EditCustomAttributes = "";
			$this->ContactID->EditValue = HtmlEncode($this->ContactID->AdvancedSearch->SearchValue);
			$this->ContactID->PlaceHolder = RemoveHtml($this->ContactID->caption());

			// Activated
			$this->Activated->EditCustomAttributes = "";
			$this->Activated->EditValue = $this->Activated->options(FALSE);
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->courttypeCourtTypeID->AdvancedSearch->load();
		$this->CourtType->AdvancedSearch->load();
		$this->CourtTypeEn->AdvancedSearch->load();
		$this->CourtTypeNotes->AdvancedSearch->load();
		$this->courtLocationCourtLocationID->AdvancedSearch->load();
		$this->CourtLocation->AdvancedSearch->load();
		$this->CourtLocationEn->AdvancedSearch->load();
		$this->CourtLocationGovernorateID->AdvancedSearch->load();
		$this->CourtLocationNotes->AdvancedSearch->load();
		$this->governoratesGovernorateID->AdvancedSearch->load();
		$this->Governorate->AdvancedSearch->load();
		$this->GovernorateEn->AdvancedSearch->load();
		$this->GovernoratesNotes->AdvancedSearch->load();
		$this->ChambersChamberID->AdvancedSearch->load();
		$this->Chamber->AdvancedSearch->load();
		$this->ChamberEn->AdvancedSearch->load();
		$this->chambersNotes->AdvancedSearch->load();
		$this->ChambersActivated->AdvancedSearch->load();
		$this->sectionsSectionID->AdvancedSearch->load();
		$this->Section->AdvancedSearch->load();
		$this->SectionEn->AdvancedSearch->load();
		$this->SectionsNotes->AdvancedSearch->load();
		$this->SectionsActivated->AdvancedSearch->load();
		$this->CourtID->AdvancedSearch->load();
		$this->Court->AdvancedSearch->load();
		$this->CourtEn->AdvancedSearch->load();
		$this->CourtTypeID->AdvancedSearch->load();
		$this->ChamberID->AdvancedSearch->load();
		$this->CourtLocationID->AdvancedSearch->load();
		$this->GovernorateID->AdvancedSearch->load();
		$this->SectionID->AdvancedSearch->load();
		$this->AddressID->AdvancedSearch->load();
		$this->ContactID->AdvancedSearch->load();
		$this->Activated->AdvancedSearch->load();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.fcourtsvlist,'" . $this->ExportExcelUrl . "','excel',true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.fcourtsvlist,'" . $this->ExportWordUrl . "','word',true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.fcourtsvlist,'" . $this->ExportPdfUrl . "','pdf',true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = TRUE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = TRUE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$url = "";
		$item->Body = "<button id=\"emf_courtsv\" class=\"ew-export-link ew-email\" title=\"" . $Language->phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->phrase("ExportToEmailText") . "\" onclick=\"ew.emailDialogShow({lnk:'emf_courtsv',hdr:ew.language.phrase('ExportToEmailText'),f:document.fcourtsvlist,sel:false" . $url . "});\">" . $Language->phrase("ExportToEmail") . "</button>";
		$item->Visible = TRUE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = FALSE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed 
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(PROJECT_CHARSET, "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecs = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->setupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRec, $this->StopRec, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!DEBUG_ENABLED && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (DEBUG_ENABLED && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {
			if ($return)
				return $doc->Text; // Return email content
			else
				echo $this->exportEmail($doc->Text); // Send email
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Export email
	protected function exportEmail($emailContent)
	{
		global $TempImages, $Language;
		$sender = Post("sender", "");
		$recipient = Post("recipient", "");
		$cc = Post("cc", "");
		$bcc = Post("bcc", "");

		// Subject
		$subject = Post("subject", "");
		$emailSubject = $subject;

		// Message
		$content = Post("message", "");
		$emailMessage = $content;

		// Check sender
		if ($sender == "") {
			return "<p class=\"text-danger\">" . $Language->phrase("EnterSenderEmail") . "</p>";
		}
		if (!CheckEmail($sender)) {
			return "<p class=\"text-danger\">" . $Language->phrase("EnterProperSenderEmail") . "</p>";
		}

		// Check recipient
		if (!CheckEmailList($recipient, MAX_EMAIL_RECIPIENT)) {
			return "<p class=\"text-danger\">" . $Language->phrase("EnterProperRecipientEmail") . "</p>";
		}

		// Check cc
		if (!CheckEmailList($cc, MAX_EMAIL_RECIPIENT)) {
			return "<p class=\"text-danger\">" . $Language->phrase("EnterProperCcEmail") . "</p>";
		}

		// Check bcc
		if (!CheckEmailList($bcc, MAX_EMAIL_RECIPIENT)) {
			return "<p class=\"text-danger\">" . $Language->phrase("EnterProperBccEmail") . "</p>";
		}

		// Check email sent count
		if (!isset($_SESSION[EXPORT_EMAIL_COUNTER]))
			$_SESSION[EXPORT_EMAIL_COUNTER] = 0;
		if ((int)$_SESSION[EXPORT_EMAIL_COUNTER] > MAX_EMAIL_SENT_COUNT) {
			return "<p class=\"text-danger\">" . $Language->phrase("ExceedMaxEmailExport") . "</p>";
		}

		// Send email
		$email = new Email();
		$email->Sender = $sender; // Sender
		$email->Recipient = $recipient; // Recipient
		$email->Cc = $cc; // Cc
		$email->Bcc = $bcc; // Bcc
		$email->Subject = $emailSubject; // Subject
		$email->Format = "html";
		if ($emailMessage <> "")
			$emailMessage = RemoveXss($emailMessage) . "<br><br>";
		foreach ($TempImages as $tmpImage)
			$email->addEmbeddedImage($tmpImage);
		$email->Content = $emailMessage . CleanEmailContent($emailContent); // Content
		$eventArgs = [];
		if ($this->Recordset) {
			$this->RecCnt = $this->StartRec - 1;
			$this->Recordset->moveFirst();
			if ($this->StartRec > 1)
				$this->Recordset->move($this->StartRec - 1);
			$eventArgs["rs"] = &$this->Recordset;
		}
		$emailSent = FALSE;
		if ($this->Email_Sending($email, $eventArgs))
			$emailSent = $email->send();

		// Check email sent status
		if ($emailSent) {

			// Update email sent count
			$_SESSION[EXPORT_EMAIL_COUNTER]++;

			// Sent email success
			return "<p class=\"text-success\">" . $Language->phrase("SendEmailSuccess") . "</p>"; // Set up success message
		} else {

			// Sent email failure
			return "<p class=\"text-danger\">" . $email->SendErrDescription . "</p>";
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_CourtTypeID":
							break;
						case "x_ChamberID":
							break;
						case "x_CourtLocationID":
							break;
						case "x_GovernorateID":
							break;
						case "x_SectionID":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
}
?>
