<?php
namespace PHPMaker2019\project_germanos;

/**
 * Page class
 */
class employeehr_add extends employeehr
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{8D47CED4-FEF0-4756-8F48-9FC38A15AA2A}";

	// Table name
	public $TableName = 'employeehr';

	// Page object name
	public $PageObjName = "employeehr_add";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (employeehr)
		if (!isset($GLOBALS["employeehr"]) || get_class($GLOBALS["employeehr"]) == PROJECT_NAMESPACE . "employeehr") {
			$GLOBALS["employeehr"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["employeehr"];
		}

		// Table object (employees)
		if (!isset($GLOBALS['employees']))
			$GLOBALS['employees'] = new employees();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'employeehr');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new employees();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $employeehr;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($employeehr);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "employeehrview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['EmployeeHrID'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->EmployeeHrID->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (IsPasswordExpired())
				$this->terminate(GetUrl("changepwd.php"));
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("employeehrlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Update last accessed time
		if ($UserProfile->isValidUser(CurrentUserName(), session_id())) {
		} else {
			Write($Language->phrase("UserProfileCorrupted"));
			$this->terminate();
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->EmployeeHrID->Visible = FALSE;
		$this->EmployeeID->setVisibility();
		$this->JobTitle->setVisibility();
		$this->Department->setVisibility();
		$this->BranchID->setVisibility();
		$this->LawFirmID->setVisibility();
		$this->Notes->setVisibility();
		$this->HireDate->setVisibility();
		$this->EndOfServiceDate->setVisibility();
		$this->SocialSecurity23->setVisibility();
		$this->Financial23->setVisibility();
		$this->Extra23->setVisibility();
		$this->WorkNature->setVisibility();
		$this->_UserID->Visible = FALSE;
		$this->CreatedBy->Visible = FALSE;
		$this->CreatedDate->Visible = FALSE;
		$this->UpdatedBy->Visible = FALSE;
		$this->UpdatedDate->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->EmployeeID);
		$this->setupLookupOptions($this->BranchID);
		$this->setupLookupOptions($this->LawFirmID);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("EmployeeHrID") !== NULL) {
				$this->EmployeeHrID->setQueryStringValue(Get("EmployeeHrID"));
				$this->setKey("EmployeeHrID", $this->EmployeeHrID->CurrentValue); // Set up key
			} else {
				$this->setKey("EmployeeHrID", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Set up master/detail parameters
		// NOTE: must be after loadOldRecord to prevent master key values overwritten

		$this->setupMasterParms();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("employeehrlist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "employeehrlist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "employeehrview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->EmployeeHrID->CurrentValue = NULL;
		$this->EmployeeHrID->OldValue = $this->EmployeeHrID->CurrentValue;
		$this->EmployeeID->CurrentValue = NULL;
		$this->EmployeeID->OldValue = $this->EmployeeID->CurrentValue;
		$this->JobTitle->CurrentValue = NULL;
		$this->JobTitle->OldValue = $this->JobTitle->CurrentValue;
		$this->Department->CurrentValue = NULL;
		$this->Department->OldValue = $this->Department->CurrentValue;
		$this->BranchID->CurrentValue = 1;
		$this->LawFirmID->CurrentValue = 1;
		$this->Notes->CurrentValue = NULL;
		$this->Notes->OldValue = $this->Notes->CurrentValue;
		$this->HireDate->CurrentValue = NULL;
		$this->HireDate->OldValue = $this->HireDate->CurrentValue;
		$this->EndOfServiceDate->CurrentValue = NULL;
		$this->EndOfServiceDate->OldValue = $this->EndOfServiceDate->CurrentValue;
		$this->SocialSecurity23->CurrentValue = NULL;
		$this->SocialSecurity23->OldValue = $this->SocialSecurity23->CurrentValue;
		$this->Financial23->CurrentValue = NULL;
		$this->Financial23->OldValue = $this->Financial23->CurrentValue;
		$this->Extra23->CurrentValue = NULL;
		$this->Extra23->OldValue = $this->Extra23->CurrentValue;
		$this->WorkNature->CurrentValue = NULL;
		$this->WorkNature->OldValue = $this->WorkNature->CurrentValue;
		$this->_UserID->CurrentValue = NULL;
		$this->_UserID->OldValue = $this->_UserID->CurrentValue;
		$this->CreatedBy->CurrentValue = NULL;
		$this->CreatedBy->OldValue = $this->CreatedBy->CurrentValue;
		$this->CreatedDate->CurrentValue = NULL;
		$this->CreatedDate->OldValue = $this->CreatedDate->CurrentValue;
		$this->UpdatedBy->CurrentValue = NULL;
		$this->UpdatedBy->OldValue = $this->UpdatedBy->CurrentValue;
		$this->UpdatedDate->CurrentValue = NULL;
		$this->UpdatedDate->OldValue = $this->UpdatedDate->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'EmployeeID' first before field var 'x_EmployeeID'
		$val = $CurrentForm->hasValue("EmployeeID") ? $CurrentForm->getValue("EmployeeID") : $CurrentForm->getValue("x_EmployeeID");
		if (!$this->EmployeeID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->EmployeeID->Visible = FALSE; // Disable update for API request
			else
				$this->EmployeeID->setFormValue($val);
		}

		// Check field name 'JobTitle' first before field var 'x_JobTitle'
		$val = $CurrentForm->hasValue("JobTitle") ? $CurrentForm->getValue("JobTitle") : $CurrentForm->getValue("x_JobTitle");
		if (!$this->JobTitle->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->JobTitle->Visible = FALSE; // Disable update for API request
			else
				$this->JobTitle->setFormValue($val);
		}

		// Check field name 'Department' first before field var 'x_Department'
		$val = $CurrentForm->hasValue("Department") ? $CurrentForm->getValue("Department") : $CurrentForm->getValue("x_Department");
		if (!$this->Department->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Department->Visible = FALSE; // Disable update for API request
			else
				$this->Department->setFormValue($val);
		}

		// Check field name 'BranchID' first before field var 'x_BranchID'
		$val = $CurrentForm->hasValue("BranchID") ? $CurrentForm->getValue("BranchID") : $CurrentForm->getValue("x_BranchID");
		if (!$this->BranchID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->BranchID->Visible = FALSE; // Disable update for API request
			else
				$this->BranchID->setFormValue($val);
		}

		// Check field name 'LawFirmID' first before field var 'x_LawFirmID'
		$val = $CurrentForm->hasValue("LawFirmID") ? $CurrentForm->getValue("LawFirmID") : $CurrentForm->getValue("x_LawFirmID");
		if (!$this->LawFirmID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->LawFirmID->Visible = FALSE; // Disable update for API request
			else
				$this->LawFirmID->setFormValue($val);
		}

		// Check field name 'Notes' first before field var 'x_Notes'
		$val = $CurrentForm->hasValue("Notes") ? $CurrentForm->getValue("Notes") : $CurrentForm->getValue("x_Notes");
		if (!$this->Notes->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Notes->Visible = FALSE; // Disable update for API request
			else
				$this->Notes->setFormValue($val);
		}

		// Check field name 'HireDate' first before field var 'x_HireDate'
		$val = $CurrentForm->hasValue("HireDate") ? $CurrentForm->getValue("HireDate") : $CurrentForm->getValue("x_HireDate");
		if (!$this->HireDate->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->HireDate->Visible = FALSE; // Disable update for API request
			else
				$this->HireDate->setFormValue($val);
			$this->HireDate->CurrentValue = UnFormatDateTime($this->HireDate->CurrentValue, 0);
		}

		// Check field name 'EndOfServiceDate' first before field var 'x_EndOfServiceDate'
		$val = $CurrentForm->hasValue("EndOfServiceDate") ? $CurrentForm->getValue("EndOfServiceDate") : $CurrentForm->getValue("x_EndOfServiceDate");
		if (!$this->EndOfServiceDate->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->EndOfServiceDate->Visible = FALSE; // Disable update for API request
			else
				$this->EndOfServiceDate->setFormValue($val);
			$this->EndOfServiceDate->CurrentValue = UnFormatDateTime($this->EndOfServiceDate->CurrentValue, 0);
		}

		// Check field name 'SocialSecurity#' first before field var 'x_SocialSecurity23'
		$val = $CurrentForm->hasValue("SocialSecurity#") ? $CurrentForm->getValue("SocialSecurity#") : $CurrentForm->getValue("x_SocialSecurity23");
		if (!$this->SocialSecurity23->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->SocialSecurity23->Visible = FALSE; // Disable update for API request
			else
				$this->SocialSecurity23->setFormValue($val);
		}

		// Check field name 'Financial#' first before field var 'x_Financial23'
		$val = $CurrentForm->hasValue("Financial#") ? $CurrentForm->getValue("Financial#") : $CurrentForm->getValue("x_Financial23");
		if (!$this->Financial23->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Financial23->Visible = FALSE; // Disable update for API request
			else
				$this->Financial23->setFormValue($val);
		}

		// Check field name 'Extra#' first before field var 'x_Extra23'
		$val = $CurrentForm->hasValue("Extra#") ? $CurrentForm->getValue("Extra#") : $CurrentForm->getValue("x_Extra23");
		if (!$this->Extra23->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Extra23->Visible = FALSE; // Disable update for API request
			else
				$this->Extra23->setFormValue($val);
		}

		// Check field name 'WorkNature' first before field var 'x_WorkNature'
		$val = $CurrentForm->hasValue("WorkNature") ? $CurrentForm->getValue("WorkNature") : $CurrentForm->getValue("x_WorkNature");
		if (!$this->WorkNature->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->WorkNature->Visible = FALSE; // Disable update for API request
			else
				$this->WorkNature->setFormValue($val);
		}

		// Check field name 'EmployeeHrID' first before field var 'x_EmployeeHrID'
		$val = $CurrentForm->hasValue("EmployeeHrID") ? $CurrentForm->getValue("EmployeeHrID") : $CurrentForm->getValue("x_EmployeeHrID");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->EmployeeID->CurrentValue = $this->EmployeeID->FormValue;
		$this->JobTitle->CurrentValue = $this->JobTitle->FormValue;
		$this->Department->CurrentValue = $this->Department->FormValue;
		$this->BranchID->CurrentValue = $this->BranchID->FormValue;
		$this->LawFirmID->CurrentValue = $this->LawFirmID->FormValue;
		$this->Notes->CurrentValue = $this->Notes->FormValue;
		$this->HireDate->CurrentValue = $this->HireDate->FormValue;
		$this->HireDate->CurrentValue = UnFormatDateTime($this->HireDate->CurrentValue, 0);
		$this->EndOfServiceDate->CurrentValue = $this->EndOfServiceDate->FormValue;
		$this->EndOfServiceDate->CurrentValue = UnFormatDateTime($this->EndOfServiceDate->CurrentValue, 0);
		$this->SocialSecurity23->CurrentValue = $this->SocialSecurity23->FormValue;
		$this->Financial23->CurrentValue = $this->Financial23->FormValue;
		$this->Extra23->CurrentValue = $this->Extra23->FormValue;
		$this->WorkNature->CurrentValue = $this->WorkNature->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->EmployeeHrID->setDbValue($row['EmployeeHrID']);
		$this->EmployeeID->setDbValue($row['EmployeeID']);
		$this->JobTitle->setDbValue($row['JobTitle']);
		$this->Department->setDbValue($row['Department']);
		$this->BranchID->setDbValue($row['BranchID']);
		$this->LawFirmID->setDbValue($row['LawFirmID']);
		$this->Notes->setDbValue($row['Notes']);
		$this->HireDate->setDbValue($row['HireDate']);
		$this->EndOfServiceDate->setDbValue($row['EndOfServiceDate']);
		$this->SocialSecurity23->setDbValue($row['SocialSecurity#']);
		$this->Financial23->setDbValue($row['Financial#']);
		$this->Extra23->setDbValue($row['Extra#']);
		$this->WorkNature->setDbValue($row['WorkNature']);
		$this->_UserID->setDbValue($row['UserID']);
		$this->CreatedBy->setDbValue($row['CreatedBy']);
		$this->CreatedDate->setDbValue($row['CreatedDate']);
		$this->UpdatedBy->setDbValue($row['UpdatedBy']);
		$this->UpdatedDate->setDbValue($row['UpdatedDate']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['EmployeeHrID'] = $this->EmployeeHrID->CurrentValue;
		$row['EmployeeID'] = $this->EmployeeID->CurrentValue;
		$row['JobTitle'] = $this->JobTitle->CurrentValue;
		$row['Department'] = $this->Department->CurrentValue;
		$row['BranchID'] = $this->BranchID->CurrentValue;
		$row['LawFirmID'] = $this->LawFirmID->CurrentValue;
		$row['Notes'] = $this->Notes->CurrentValue;
		$row['HireDate'] = $this->HireDate->CurrentValue;
		$row['EndOfServiceDate'] = $this->EndOfServiceDate->CurrentValue;
		$row['SocialSecurity#'] = $this->SocialSecurity23->CurrentValue;
		$row['Financial#'] = $this->Financial23->CurrentValue;
		$row['Extra#'] = $this->Extra23->CurrentValue;
		$row['WorkNature'] = $this->WorkNature->CurrentValue;
		$row['UserID'] = $this->_UserID->CurrentValue;
		$row['CreatedBy'] = $this->CreatedBy->CurrentValue;
		$row['CreatedDate'] = $this->CreatedDate->CurrentValue;
		$row['UpdatedBy'] = $this->UpdatedBy->CurrentValue;
		$row['UpdatedDate'] = $this->UpdatedDate->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("EmployeeHrID")) <> "")
			$this->EmployeeHrID->CurrentValue = $this->getKey("EmployeeHrID"); // EmployeeHrID
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// EmployeeHrID
		// EmployeeID
		// JobTitle
		// Department
		// BranchID
		// LawFirmID
		// Notes
		// HireDate
		// EndOfServiceDate
		// SocialSecurity#
		// Financial#
		// Extra#
		// WorkNature
		// UserID
		// CreatedBy
		// CreatedDate
		// UpdatedBy
		// UpdatedDate

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// EmployeeHrID
			$this->EmployeeHrID->ViewValue = $this->EmployeeHrID->CurrentValue;
			$this->EmployeeHrID->ViewCustomAttributes = "";

			// EmployeeID
			$curVal = strval($this->EmployeeID->CurrentValue);
			if ($curVal <> "") {
				$this->EmployeeID->ViewValue = $this->EmployeeID->lookupCacheOption($curVal);
				if ($this->EmployeeID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`EmployeeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->EmployeeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->EmployeeID->ViewValue = $this->EmployeeID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->EmployeeID->ViewValue = $this->EmployeeID->CurrentValue;
					}
				}
			} else {
				$this->EmployeeID->ViewValue = NULL;
			}
			$this->EmployeeID->ViewCustomAttributes = "";

			// JobTitle
			$this->JobTitle->ViewValue = $this->JobTitle->CurrentValue;
			$this->JobTitle->ViewCustomAttributes = "";

			// Department
			$this->Department->ViewValue = $this->Department->CurrentValue;
			$this->Department->ViewCustomAttributes = "";

			// BranchID
			$curVal = strval($this->BranchID->CurrentValue);
			if ($curVal <> "") {
				$this->BranchID->ViewValue = $this->BranchID->lookupCacheOption($curVal);
				if ($this->BranchID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`BranchID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->BranchID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->BranchID->ViewValue = $this->BranchID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->BranchID->ViewValue = $this->BranchID->CurrentValue;
					}
				}
			} else {
				$this->BranchID->ViewValue = NULL;
			}
			$this->BranchID->ViewCustomAttributes = "";

			// LawFirmID
			$curVal = strval($this->LawFirmID->CurrentValue);
			if ($curVal <> "") {
				$this->LawFirmID->ViewValue = $this->LawFirmID->lookupCacheOption($curVal);
				if ($this->LawFirmID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`LawFirmID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->LawFirmID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->LawFirmID->ViewValue = $this->LawFirmID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->LawFirmID->ViewValue = $this->LawFirmID->CurrentValue;
					}
				}
			} else {
				$this->LawFirmID->ViewValue = NULL;
			}
			$this->LawFirmID->ViewCustomAttributes = "";

			// Notes
			$this->Notes->ViewValue = $this->Notes->CurrentValue;
			$this->Notes->ViewCustomAttributes = "";

			// HireDate
			$this->HireDate->ViewValue = $this->HireDate->CurrentValue;
			$this->HireDate->ViewValue = FormatDateTime($this->HireDate->ViewValue, 0);
			$this->HireDate->ViewCustomAttributes = "";

			// EndOfServiceDate
			$this->EndOfServiceDate->ViewValue = $this->EndOfServiceDate->CurrentValue;
			$this->EndOfServiceDate->ViewValue = FormatDateTime($this->EndOfServiceDate->ViewValue, 0);
			$this->EndOfServiceDate->ViewCustomAttributes = "";

			// SocialSecurity#
			$this->SocialSecurity23->ViewValue = $this->SocialSecurity23->CurrentValue;
			$this->SocialSecurity23->ViewCustomAttributes = "";

			// Financial#
			$this->Financial23->ViewValue = $this->Financial23->CurrentValue;
			$this->Financial23->ViewCustomAttributes = "";

			// Extra#
			$this->Extra23->ViewValue = $this->Extra23->CurrentValue;
			$this->Extra23->ViewCustomAttributes = "";

			// WorkNature
			$this->WorkNature->ViewValue = $this->WorkNature->CurrentValue;
			$this->WorkNature->ViewCustomAttributes = "";

			// EmployeeID
			$this->EmployeeID->LinkCustomAttributes = "";
			$this->EmployeeID->HrefValue = "";
			$this->EmployeeID->TooltipValue = "";

			// JobTitle
			$this->JobTitle->LinkCustomAttributes = "";
			$this->JobTitle->HrefValue = "";
			$this->JobTitle->TooltipValue = "";

			// Department
			$this->Department->LinkCustomAttributes = "";
			$this->Department->HrefValue = "";
			$this->Department->TooltipValue = "";

			// BranchID
			$this->BranchID->LinkCustomAttributes = "";
			$this->BranchID->HrefValue = "";
			$this->BranchID->TooltipValue = "";

			// LawFirmID
			$this->LawFirmID->LinkCustomAttributes = "";
			$this->LawFirmID->HrefValue = "";
			$this->LawFirmID->TooltipValue = "";

			// Notes
			$this->Notes->LinkCustomAttributes = "";
			$this->Notes->HrefValue = "";
			$this->Notes->TooltipValue = "";

			// HireDate
			$this->HireDate->LinkCustomAttributes = "";
			$this->HireDate->HrefValue = "";
			$this->HireDate->TooltipValue = "";

			// EndOfServiceDate
			$this->EndOfServiceDate->LinkCustomAttributes = "";
			$this->EndOfServiceDate->HrefValue = "";
			$this->EndOfServiceDate->TooltipValue = "";

			// SocialSecurity#
			$this->SocialSecurity23->LinkCustomAttributes = "";
			$this->SocialSecurity23->HrefValue = "";
			$this->SocialSecurity23->TooltipValue = "";

			// Financial#
			$this->Financial23->LinkCustomAttributes = "";
			$this->Financial23->HrefValue = "";
			$this->Financial23->TooltipValue = "";

			// Extra#
			$this->Extra23->LinkCustomAttributes = "";
			$this->Extra23->HrefValue = "";
			$this->Extra23->TooltipValue = "";

			// WorkNature
			$this->WorkNature->LinkCustomAttributes = "";
			$this->WorkNature->HrefValue = "";
			$this->WorkNature->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// EmployeeID
			$this->EmployeeID->EditAttrs["class"] = "form-control";
			$this->EmployeeID->EditCustomAttributes = "";
			if ($this->EmployeeID->getSessionValue() <> "") {
				$this->EmployeeID->CurrentValue = $this->EmployeeID->getSessionValue();
			$curVal = strval($this->EmployeeID->CurrentValue);
			if ($curVal <> "") {
				$this->EmployeeID->ViewValue = $this->EmployeeID->lookupCacheOption($curVal);
				if ($this->EmployeeID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`EmployeeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->EmployeeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->EmployeeID->ViewValue = $this->EmployeeID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->EmployeeID->ViewValue = $this->EmployeeID->CurrentValue;
					}
				}
			} else {
				$this->EmployeeID->ViewValue = NULL;
			}
			$this->EmployeeID->ViewCustomAttributes = "";
			} else {
			$curVal = trim(strval($this->EmployeeID->CurrentValue));
			if ($curVal <> "")
				$this->EmployeeID->ViewValue = $this->EmployeeID->lookupCacheOption($curVal);
			else
				$this->EmployeeID->ViewValue = $this->EmployeeID->Lookup !== NULL && is_array($this->EmployeeID->Lookup->Options) ? $curVal : NULL;
			if ($this->EmployeeID->ViewValue !== NULL) { // Load from cache
				$this->EmployeeID->EditValue = array_values($this->EmployeeID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`EmployeeID`" . SearchString("=", $this->EmployeeID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->EmployeeID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->EmployeeID->EditValue = $arwrk;
			}
			}

			// JobTitle
			$this->JobTitle->EditAttrs["class"] = "form-control";
			$this->JobTitle->EditCustomAttributes = "";
			$this->JobTitle->EditValue = HtmlEncode($this->JobTitle->CurrentValue);
			$this->JobTitle->PlaceHolder = RemoveHtml($this->JobTitle->caption());

			// Department
			$this->Department->EditAttrs["class"] = "form-control";
			$this->Department->EditCustomAttributes = "";
			$this->Department->EditValue = HtmlEncode($this->Department->CurrentValue);
			$this->Department->PlaceHolder = RemoveHtml($this->Department->caption());

			// BranchID
			$this->BranchID->EditAttrs["class"] = "form-control";
			$this->BranchID->EditCustomAttributes = "";
			$curVal = trim(strval($this->BranchID->CurrentValue));
			if ($curVal <> "")
				$this->BranchID->ViewValue = $this->BranchID->lookupCacheOption($curVal);
			else
				$this->BranchID->ViewValue = $this->BranchID->Lookup !== NULL && is_array($this->BranchID->Lookup->Options) ? $curVal : NULL;
			if ($this->BranchID->ViewValue !== NULL) { // Load from cache
				$this->BranchID->EditValue = array_values($this->BranchID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`BranchID`" . SearchString("=", $this->BranchID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->BranchID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->BranchID->EditValue = $arwrk;
			}

			// LawFirmID
			$this->LawFirmID->EditAttrs["class"] = "form-control";
			$this->LawFirmID->EditCustomAttributes = "";
			$curVal = trim(strval($this->LawFirmID->CurrentValue));
			if ($curVal <> "")
				$this->LawFirmID->ViewValue = $this->LawFirmID->lookupCacheOption($curVal);
			else
				$this->LawFirmID->ViewValue = $this->LawFirmID->Lookup !== NULL && is_array($this->LawFirmID->Lookup->Options) ? $curVal : NULL;
			if ($this->LawFirmID->ViewValue !== NULL) { // Load from cache
				$this->LawFirmID->EditValue = array_values($this->LawFirmID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`LawFirmID`" . SearchString("=", $this->LawFirmID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->LawFirmID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->LawFirmID->EditValue = $arwrk;
			}

			// Notes
			$this->Notes->EditAttrs["class"] = "form-control";
			$this->Notes->EditCustomAttributes = "";
			$this->Notes->EditValue = HtmlEncode($this->Notes->CurrentValue);
			$this->Notes->PlaceHolder = RemoveHtml($this->Notes->caption());

			// HireDate
			$this->HireDate->EditAttrs["class"] = "form-control";
			$this->HireDate->EditCustomAttributes = "";
			$this->HireDate->EditValue = HtmlEncode(FormatDateTime($this->HireDate->CurrentValue, 8));
			$this->HireDate->PlaceHolder = RemoveHtml($this->HireDate->caption());

			// EndOfServiceDate
			$this->EndOfServiceDate->EditAttrs["class"] = "form-control";
			$this->EndOfServiceDate->EditCustomAttributes = "";
			$this->EndOfServiceDate->EditValue = HtmlEncode(FormatDateTime($this->EndOfServiceDate->CurrentValue, 8));
			$this->EndOfServiceDate->PlaceHolder = RemoveHtml($this->EndOfServiceDate->caption());

			// SocialSecurity#
			$this->SocialSecurity23->EditAttrs["class"] = "form-control";
			$this->SocialSecurity23->EditCustomAttributes = "";
			$this->SocialSecurity23->EditValue = HtmlEncode($this->SocialSecurity23->CurrentValue);
			$this->SocialSecurity23->PlaceHolder = RemoveHtml($this->SocialSecurity23->caption());

			// Financial#
			$this->Financial23->EditAttrs["class"] = "form-control";
			$this->Financial23->EditCustomAttributes = "";
			$this->Financial23->EditValue = HtmlEncode($this->Financial23->CurrentValue);
			$this->Financial23->PlaceHolder = RemoveHtml($this->Financial23->caption());

			// Extra#
			$this->Extra23->EditAttrs["class"] = "form-control";
			$this->Extra23->EditCustomAttributes = "";
			$this->Extra23->EditValue = HtmlEncode($this->Extra23->CurrentValue);
			$this->Extra23->PlaceHolder = RemoveHtml($this->Extra23->caption());

			// WorkNature
			$this->WorkNature->EditAttrs["class"] = "form-control";
			$this->WorkNature->EditCustomAttributes = "";
			$this->WorkNature->EditValue = HtmlEncode($this->WorkNature->CurrentValue);
			$this->WorkNature->PlaceHolder = RemoveHtml($this->WorkNature->caption());

			// Add refer script
			// EmployeeID

			$this->EmployeeID->LinkCustomAttributes = "";
			$this->EmployeeID->HrefValue = "";

			// JobTitle
			$this->JobTitle->LinkCustomAttributes = "";
			$this->JobTitle->HrefValue = "";

			// Department
			$this->Department->LinkCustomAttributes = "";
			$this->Department->HrefValue = "";

			// BranchID
			$this->BranchID->LinkCustomAttributes = "";
			$this->BranchID->HrefValue = "";

			// LawFirmID
			$this->LawFirmID->LinkCustomAttributes = "";
			$this->LawFirmID->HrefValue = "";

			// Notes
			$this->Notes->LinkCustomAttributes = "";
			$this->Notes->HrefValue = "";

			// HireDate
			$this->HireDate->LinkCustomAttributes = "";
			$this->HireDate->HrefValue = "";

			// EndOfServiceDate
			$this->EndOfServiceDate->LinkCustomAttributes = "";
			$this->EndOfServiceDate->HrefValue = "";

			// SocialSecurity#
			$this->SocialSecurity23->LinkCustomAttributes = "";
			$this->SocialSecurity23->HrefValue = "";

			// Financial#
			$this->Financial23->LinkCustomAttributes = "";
			$this->Financial23->HrefValue = "";

			// Extra#
			$this->Extra23->LinkCustomAttributes = "";
			$this->Extra23->HrefValue = "";

			// WorkNature
			$this->WorkNature->LinkCustomAttributes = "";
			$this->WorkNature->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->EmployeeHrID->Required) {
			if (!$this->EmployeeHrID->IsDetailKey && $this->EmployeeHrID->FormValue != NULL && $this->EmployeeHrID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->EmployeeHrID->caption(), $this->EmployeeHrID->RequiredErrorMessage));
			}
		}
		if ($this->EmployeeID->Required) {
			if (!$this->EmployeeID->IsDetailKey && $this->EmployeeID->FormValue != NULL && $this->EmployeeID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->EmployeeID->caption(), $this->EmployeeID->RequiredErrorMessage));
			}
		}
		if ($this->JobTitle->Required) {
			if (!$this->JobTitle->IsDetailKey && $this->JobTitle->FormValue != NULL && $this->JobTitle->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->JobTitle->caption(), $this->JobTitle->RequiredErrorMessage));
			}
		}
		if ($this->Department->Required) {
			if (!$this->Department->IsDetailKey && $this->Department->FormValue != NULL && $this->Department->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Department->caption(), $this->Department->RequiredErrorMessage));
			}
		}
		if ($this->BranchID->Required) {
			if (!$this->BranchID->IsDetailKey && $this->BranchID->FormValue != NULL && $this->BranchID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->BranchID->caption(), $this->BranchID->RequiredErrorMessage));
			}
		}
		if ($this->LawFirmID->Required) {
			if (!$this->LawFirmID->IsDetailKey && $this->LawFirmID->FormValue != NULL && $this->LawFirmID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->LawFirmID->caption(), $this->LawFirmID->RequiredErrorMessage));
			}
		}
		if ($this->Notes->Required) {
			if (!$this->Notes->IsDetailKey && $this->Notes->FormValue != NULL && $this->Notes->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Notes->caption(), $this->Notes->RequiredErrorMessage));
			}
		}
		if ($this->HireDate->Required) {
			if (!$this->HireDate->IsDetailKey && $this->HireDate->FormValue != NULL && $this->HireDate->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->HireDate->caption(), $this->HireDate->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->HireDate->FormValue)) {
			AddMessage($FormError, $this->HireDate->errorMessage());
		}
		if ($this->EndOfServiceDate->Required) {
			if (!$this->EndOfServiceDate->IsDetailKey && $this->EndOfServiceDate->FormValue != NULL && $this->EndOfServiceDate->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->EndOfServiceDate->caption(), $this->EndOfServiceDate->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->EndOfServiceDate->FormValue)) {
			AddMessage($FormError, $this->EndOfServiceDate->errorMessage());
		}
		if ($this->SocialSecurity23->Required) {
			if (!$this->SocialSecurity23->IsDetailKey && $this->SocialSecurity23->FormValue != NULL && $this->SocialSecurity23->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->SocialSecurity23->caption(), $this->SocialSecurity23->RequiredErrorMessage));
			}
		}
		if ($this->Financial23->Required) {
			if (!$this->Financial23->IsDetailKey && $this->Financial23->FormValue != NULL && $this->Financial23->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Financial23->caption(), $this->Financial23->RequiredErrorMessage));
			}
		}
		if ($this->Extra23->Required) {
			if (!$this->Extra23->IsDetailKey && $this->Extra23->FormValue != NULL && $this->Extra23->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Extra23->caption(), $this->Extra23->RequiredErrorMessage));
			}
		}
		if ($this->WorkNature->Required) {
			if (!$this->WorkNature->IsDetailKey && $this->WorkNature->FormValue != NULL && $this->WorkNature->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->WorkNature->caption(), $this->WorkNature->RequiredErrorMessage));
			}
		}
		if ($this->_UserID->Required) {
			if (!$this->_UserID->IsDetailKey && $this->_UserID->FormValue != NULL && $this->_UserID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_UserID->caption(), $this->_UserID->RequiredErrorMessage));
			}
		}
		if ($this->CreatedBy->Required) {
			if (!$this->CreatedBy->IsDetailKey && $this->CreatedBy->FormValue != NULL && $this->CreatedBy->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CreatedBy->caption(), $this->CreatedBy->RequiredErrorMessage));
			}
		}
		if ($this->CreatedDate->Required) {
			if (!$this->CreatedDate->IsDetailKey && $this->CreatedDate->FormValue != NULL && $this->CreatedDate->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CreatedDate->caption(), $this->CreatedDate->RequiredErrorMessage));
			}
		}
		if ($this->UpdatedBy->Required) {
			if (!$this->UpdatedBy->IsDetailKey && $this->UpdatedBy->FormValue != NULL && $this->UpdatedBy->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->UpdatedBy->caption(), $this->UpdatedBy->RequiredErrorMessage));
			}
		}
		if ($this->UpdatedDate->Required) {
			if (!$this->UpdatedDate->IsDetailKey && $this->UpdatedDate->FormValue != NULL && $this->UpdatedDate->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->UpdatedDate->caption(), $this->UpdatedDate->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;

		// Check if valid key values for master user
		if ($Security->currentUserID() <> "" && !$Security->isAdmin()) { // Non system admin
			$masterFilter = $this->sqlMasterFilter_employees();
			if (strval($this->EmployeeID->CurrentValue) <> "") {
				$masterFilter = str_replace("@EmployeeID@", AdjustSql($this->EmployeeID->CurrentValue, "DB"), $masterFilter);
			} else {
				$masterFilter = "";
			}
			if ($masterFilter <> "") {
				$rsmaster = $GLOBALS["employees"]->loadRs($masterFilter);
				$this->MasterRecordExists = ($rsmaster && !$rsmaster->EOF);
				$validMasterKey = TRUE;
				if ($this->MasterRecordExists) {
					$validMasterKey = $Security->isValidUserID($rsmaster->fields['EmployeeID']);
				} elseif ($this->getCurrentMasterTable() == "employees") {
					$validMasterKey = FALSE;
				}
				if (!$validMasterKey) {
					$masterUserIdMsg = str_replace("%c", CurrentUserID(), $Language->phrase("UnAuthorizedMasterUserID"));
					$masterUserIdMsg = str_replace("%f", $sMasterFilter, $masterUserIdMsg);
					$this->setFailureMessage($masterUserIdMsg);
					return FALSE;
				}
				if ($rsmaster)
					$rsmaster->close();
			}
		}
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// EmployeeID
		$this->EmployeeID->setDbValueDef($rsnew, $this->EmployeeID->CurrentValue, 0, FALSE);

		// JobTitle
		$this->JobTitle->setDbValueDef($rsnew, $this->JobTitle->CurrentValue, NULL, FALSE);

		// Department
		$this->Department->setDbValueDef($rsnew, $this->Department->CurrentValue, NULL, FALSE);

		// BranchID
		$this->BranchID->setDbValueDef($rsnew, $this->BranchID->CurrentValue, 0, strval($this->BranchID->CurrentValue) == "");

		// LawFirmID
		$this->LawFirmID->setDbValueDef($rsnew, $this->LawFirmID->CurrentValue, 0, strval($this->LawFirmID->CurrentValue) == "");

		// Notes
		$this->Notes->setDbValueDef($rsnew, $this->Notes->CurrentValue, NULL, FALSE);

		// HireDate
		$this->HireDate->setDbValueDef($rsnew, UnFormatDateTime($this->HireDate->CurrentValue, 0), NULL, FALSE);

		// EndOfServiceDate
		$this->EndOfServiceDate->setDbValueDef($rsnew, UnFormatDateTime($this->EndOfServiceDate->CurrentValue, 0), NULL, FALSE);

		// SocialSecurity#
		$this->SocialSecurity23->setDbValueDef($rsnew, $this->SocialSecurity23->CurrentValue, NULL, FALSE);

		// Financial#
		$this->Financial23->setDbValueDef($rsnew, $this->Financial23->CurrentValue, NULL, FALSE);

		// Extra#
		$this->Extra23->setDbValueDef($rsnew, $this->Extra23->CurrentValue, NULL, FALSE);

		// WorkNature
		$this->WorkNature->setDbValueDef($rsnew, $this->WorkNature->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up master/detail based on QueryString
	protected function setupMasterParms()
	{
		$validMaster = FALSE;

		// Get the keys for master table
		if (Get(TABLE_SHOW_MASTER) !== NULL) {
			$masterTblVar = Get(TABLE_SHOW_MASTER);
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "employees") {
				$validMaster = TRUE;
				if (Get("fk_EmployeeID") !== NULL) {
					$GLOBALS["employees"]->EmployeeID->setQueryStringValue(Get("fk_EmployeeID"));
					$this->EmployeeID->setQueryStringValue($GLOBALS["employees"]->EmployeeID->QueryStringValue);
					$this->EmployeeID->setSessionValue($this->EmployeeID->QueryStringValue);
					if (!is_numeric($GLOBALS["employees"]->EmployeeID->QueryStringValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
			}
		} elseif (Post(TABLE_SHOW_MASTER) !== NULL) {
			$masterTblVar = Post(TABLE_SHOW_MASTER);
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "employees") {
				$validMaster = TRUE;
				if (Post("fk_EmployeeID") !== NULL) {
					$GLOBALS["employees"]->EmployeeID->setFormValue(Post("fk_EmployeeID"));
					$this->EmployeeID->setFormValue($GLOBALS["employees"]->EmployeeID->FormValue);
					$this->EmployeeID->setSessionValue($this->EmployeeID->FormValue);
					if (!is_numeric($GLOBALS["employees"]->EmployeeID->FormValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
			}
		}
		if ($validMaster) {

			// Save current master table
			$this->setCurrentMasterTable($masterTblVar);

			// Reset start record counter (new master key)
			if (!$this->isAddOrEdit()) {
				$this->StartRec = 1;
				$this->setStartRecordNumber($this->StartRec);
			}

			// Clear previous master key from Session
			if ($masterTblVar <> "employees") {
				if ($this->EmployeeID->CurrentValue == "")
					$this->EmployeeID->setSessionValue("");
			}
		}
		$this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("employeehrlist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_EmployeeID":
							break;
						case "x_BranchID":
							break;
						case "x_LawFirmID":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
