<?php
namespace PHPMaker2019\project_germanos;

/**
 * Page class
 */
class employeehr_search extends employeehr
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{8D47CED4-FEF0-4756-8F48-9FC38A15AA2A}";

	// Table name
	public $TableName = 'employeehr';

	// Page object name
	public $PageObjName = "employeehr_search";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (employeehr)
		if (!isset($GLOBALS["employeehr"]) || get_class($GLOBALS["employeehr"]) == PROJECT_NAMESPACE . "employeehr") {
			$GLOBALS["employeehr"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["employeehr"];
		}

		// Table object (employees)
		if (!isset($GLOBALS['employees']))
			$GLOBALS['employees'] = new employees();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'employeehr');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new employees();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $employeehr;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($employeehr);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "employeehrview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['EmployeeHrID'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->EmployeeHrID->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (IsPasswordExpired())
				$this->terminate(GetUrl("changepwd.php"));
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("employeehrlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Update last accessed time
		if ($UserProfile->isValidUser(CurrentUserName(), session_id())) {
		} else {
			Write($Language->phrase("UserProfileCorrupted"));
			$this->terminate();
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->EmployeeHrID->setVisibility();
		$this->EmployeeID->setVisibility();
		$this->JobTitle->setVisibility();
		$this->Department->setVisibility();
		$this->BranchID->setVisibility();
		$this->LawFirmID->setVisibility();
		$this->Notes->setVisibility();
		$this->HireDate->setVisibility();
		$this->EndOfServiceDate->setVisibility();
		$this->SocialSecurity23->setVisibility();
		$this->Financial23->setVisibility();
		$this->Extra23->setVisibility();
		$this->WorkNature->setVisibility();
		$this->_UserID->Visible = FALSE;
		$this->CreatedBy->Visible = FALSE;
		$this->CreatedDate->Visible = FALSE;
		$this->UpdatedBy->Visible = FALSE;
		$this->UpdatedDate->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->EmployeeID);
		$this->setupLookupOptions($this->BranchID);
		$this->setupLookupOptions($this->LawFirmID);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-search-form ew-horizontal";
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "employeehrlist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->EmployeeHrID); // EmployeeHrID
		$this->buildSearchUrl($srchUrl, $this->EmployeeID); // EmployeeID
		$this->buildSearchUrl($srchUrl, $this->JobTitle); // JobTitle
		$this->buildSearchUrl($srchUrl, $this->Department); // Department
		$this->buildSearchUrl($srchUrl, $this->BranchID); // BranchID
		$this->buildSearchUrl($srchUrl, $this->LawFirmID); // LawFirmID
		$this->buildSearchUrl($srchUrl, $this->Notes); // Notes
		$this->buildSearchUrl($srchUrl, $this->HireDate); // HireDate
		$this->buildSearchUrl($srchUrl, $this->EndOfServiceDate); // EndOfServiceDate
		$this->buildSearchUrl($srchUrl, $this->SocialSecurity23); // SocialSecurity#
		$this->buildSearchUrl($srchUrl, $this->Financial23); // Financial#
		$this->buildSearchUrl($srchUrl, $this->Extra23); // Extra#
		$this->buildSearchUrl($srchUrl, $this->WorkNature); // WorkNature
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// EmployeeHrID

		if (!$this->isAddOrEdit())
			$this->EmployeeHrID->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_EmployeeHrID"));
		$this->EmployeeHrID->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_EmployeeHrID"));

		// EmployeeID
		if (!$this->isAddOrEdit())
			$this->EmployeeID->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_EmployeeID"));
		$this->EmployeeID->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_EmployeeID"));

		// JobTitle
		if (!$this->isAddOrEdit())
			$this->JobTitle->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_JobTitle"));
		$this->JobTitle->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_JobTitle"));

		// Department
		if (!$this->isAddOrEdit())
			$this->Department->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_Department"));
		$this->Department->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_Department"));

		// BranchID
		if (!$this->isAddOrEdit())
			$this->BranchID->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_BranchID"));
		$this->BranchID->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_BranchID"));

		// LawFirmID
		if (!$this->isAddOrEdit())
			$this->LawFirmID->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_LawFirmID"));
		$this->LawFirmID->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_LawFirmID"));

		// Notes
		if (!$this->isAddOrEdit())
			$this->Notes->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_Notes"));
		$this->Notes->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_Notes"));

		// HireDate
		if (!$this->isAddOrEdit())
			$this->HireDate->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_HireDate"));
		$this->HireDate->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_HireDate"));

		// EndOfServiceDate
		if (!$this->isAddOrEdit())
			$this->EndOfServiceDate->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_EndOfServiceDate"));
		$this->EndOfServiceDate->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_EndOfServiceDate"));

		// SocialSecurity#
		if (!$this->isAddOrEdit())
			$this->SocialSecurity23->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_SocialSecurity23"));
		$this->SocialSecurity23->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_SocialSecurity23"));

		// Financial#
		if (!$this->isAddOrEdit())
			$this->Financial23->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_Financial23"));
		$this->Financial23->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_Financial23"));

		// Extra#
		if (!$this->isAddOrEdit())
			$this->Extra23->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_Extra23"));
		$this->Extra23->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_Extra23"));

		// WorkNature
		if (!$this->isAddOrEdit())
			$this->WorkNature->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_WorkNature"));
		$this->WorkNature->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_WorkNature"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// EmployeeHrID
		// EmployeeID
		// JobTitle
		// Department
		// BranchID
		// LawFirmID
		// Notes
		// HireDate
		// EndOfServiceDate
		// SocialSecurity#
		// Financial#
		// Extra#
		// WorkNature
		// UserID
		// CreatedBy
		// CreatedDate
		// UpdatedBy
		// UpdatedDate

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// EmployeeHrID
			$this->EmployeeHrID->ViewValue = $this->EmployeeHrID->CurrentValue;
			$this->EmployeeHrID->ViewCustomAttributes = "";

			// EmployeeID
			$curVal = strval($this->EmployeeID->CurrentValue);
			if ($curVal <> "") {
				$this->EmployeeID->ViewValue = $this->EmployeeID->lookupCacheOption($curVal);
				if ($this->EmployeeID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`EmployeeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->EmployeeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->EmployeeID->ViewValue = $this->EmployeeID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->EmployeeID->ViewValue = $this->EmployeeID->CurrentValue;
					}
				}
			} else {
				$this->EmployeeID->ViewValue = NULL;
			}
			$this->EmployeeID->ViewCustomAttributes = "";

			// JobTitle
			$this->JobTitle->ViewValue = $this->JobTitle->CurrentValue;
			$this->JobTitle->ViewCustomAttributes = "";

			// Department
			$this->Department->ViewValue = $this->Department->CurrentValue;
			$this->Department->ViewCustomAttributes = "";

			// BranchID
			$curVal = strval($this->BranchID->CurrentValue);
			if ($curVal <> "") {
				$this->BranchID->ViewValue = $this->BranchID->lookupCacheOption($curVal);
				if ($this->BranchID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`BranchID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->BranchID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->BranchID->ViewValue = $this->BranchID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->BranchID->ViewValue = $this->BranchID->CurrentValue;
					}
				}
			} else {
				$this->BranchID->ViewValue = NULL;
			}
			$this->BranchID->ViewCustomAttributes = "";

			// LawFirmID
			$curVal = strval($this->LawFirmID->CurrentValue);
			if ($curVal <> "") {
				$this->LawFirmID->ViewValue = $this->LawFirmID->lookupCacheOption($curVal);
				if ($this->LawFirmID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`LawFirmID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->LawFirmID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->LawFirmID->ViewValue = $this->LawFirmID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->LawFirmID->ViewValue = $this->LawFirmID->CurrentValue;
					}
				}
			} else {
				$this->LawFirmID->ViewValue = NULL;
			}
			$this->LawFirmID->ViewCustomAttributes = "";

			// Notes
			$this->Notes->ViewValue = $this->Notes->CurrentValue;
			$this->Notes->ViewCustomAttributes = "";

			// HireDate
			$this->HireDate->ViewValue = $this->HireDate->CurrentValue;
			$this->HireDate->ViewValue = FormatDateTime($this->HireDate->ViewValue, 0);
			$this->HireDate->ViewCustomAttributes = "";

			// EndOfServiceDate
			$this->EndOfServiceDate->ViewValue = $this->EndOfServiceDate->CurrentValue;
			$this->EndOfServiceDate->ViewValue = FormatDateTime($this->EndOfServiceDate->ViewValue, 0);
			$this->EndOfServiceDate->ViewCustomAttributes = "";

			// SocialSecurity#
			$this->SocialSecurity23->ViewValue = $this->SocialSecurity23->CurrentValue;
			$this->SocialSecurity23->ViewCustomAttributes = "";

			// Financial#
			$this->Financial23->ViewValue = $this->Financial23->CurrentValue;
			$this->Financial23->ViewCustomAttributes = "";

			// Extra#
			$this->Extra23->ViewValue = $this->Extra23->CurrentValue;
			$this->Extra23->ViewCustomAttributes = "";

			// WorkNature
			$this->WorkNature->ViewValue = $this->WorkNature->CurrentValue;
			$this->WorkNature->ViewCustomAttributes = "";

			// EmployeeHrID
			$this->EmployeeHrID->LinkCustomAttributes = "";
			$this->EmployeeHrID->HrefValue = "";
			$this->EmployeeHrID->TooltipValue = "";

			// EmployeeID
			$this->EmployeeID->LinkCustomAttributes = "";
			$this->EmployeeID->HrefValue = "";
			$this->EmployeeID->TooltipValue = "";

			// JobTitle
			$this->JobTitle->LinkCustomAttributes = "";
			$this->JobTitle->HrefValue = "";
			$this->JobTitle->TooltipValue = "";

			// Department
			$this->Department->LinkCustomAttributes = "";
			$this->Department->HrefValue = "";
			$this->Department->TooltipValue = "";

			// BranchID
			$this->BranchID->LinkCustomAttributes = "";
			$this->BranchID->HrefValue = "";
			$this->BranchID->TooltipValue = "";

			// LawFirmID
			$this->LawFirmID->LinkCustomAttributes = "";
			$this->LawFirmID->HrefValue = "";
			$this->LawFirmID->TooltipValue = "";

			// Notes
			$this->Notes->LinkCustomAttributes = "";
			$this->Notes->HrefValue = "";
			$this->Notes->TooltipValue = "";

			// HireDate
			$this->HireDate->LinkCustomAttributes = "";
			$this->HireDate->HrefValue = "";
			$this->HireDate->TooltipValue = "";

			// EndOfServiceDate
			$this->EndOfServiceDate->LinkCustomAttributes = "";
			$this->EndOfServiceDate->HrefValue = "";
			$this->EndOfServiceDate->TooltipValue = "";

			// SocialSecurity#
			$this->SocialSecurity23->LinkCustomAttributes = "";
			$this->SocialSecurity23->HrefValue = "";
			$this->SocialSecurity23->TooltipValue = "";

			// Financial#
			$this->Financial23->LinkCustomAttributes = "";
			$this->Financial23->HrefValue = "";
			$this->Financial23->TooltipValue = "";

			// Extra#
			$this->Extra23->LinkCustomAttributes = "";
			$this->Extra23->HrefValue = "";
			$this->Extra23->TooltipValue = "";

			// WorkNature
			$this->WorkNature->LinkCustomAttributes = "";
			$this->WorkNature->HrefValue = "";
			$this->WorkNature->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// EmployeeHrID
			$this->EmployeeHrID->EditAttrs["class"] = "form-control";
			$this->EmployeeHrID->EditCustomAttributes = "";
			$this->EmployeeHrID->EditValue = HtmlEncode($this->EmployeeHrID->AdvancedSearch->SearchValue);
			$this->EmployeeHrID->PlaceHolder = RemoveHtml($this->EmployeeHrID->caption());

			// EmployeeID
			$this->EmployeeID->EditAttrs["class"] = "form-control";
			$this->EmployeeID->EditCustomAttributes = "";
			$curVal = trim(strval($this->EmployeeID->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->EmployeeID->AdvancedSearch->ViewValue = $this->EmployeeID->lookupCacheOption($curVal);
			else
				$this->EmployeeID->AdvancedSearch->ViewValue = $this->EmployeeID->Lookup !== NULL && is_array($this->EmployeeID->Lookup->Options) ? $curVal : NULL;
			if ($this->EmployeeID->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->EmployeeID->EditValue = array_values($this->EmployeeID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`EmployeeID`" . SearchString("=", $this->EmployeeID->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->EmployeeID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->EmployeeID->EditValue = $arwrk;
			}

			// JobTitle
			$this->JobTitle->EditAttrs["class"] = "form-control";
			$this->JobTitle->EditCustomAttributes = "";
			$this->JobTitle->EditValue = HtmlEncode($this->JobTitle->AdvancedSearch->SearchValue);
			$this->JobTitle->PlaceHolder = RemoveHtml($this->JobTitle->caption());

			// Department
			$this->Department->EditAttrs["class"] = "form-control";
			$this->Department->EditCustomAttributes = "";
			$this->Department->EditValue = HtmlEncode($this->Department->AdvancedSearch->SearchValue);
			$this->Department->PlaceHolder = RemoveHtml($this->Department->caption());

			// BranchID
			$this->BranchID->EditAttrs["class"] = "form-control";
			$this->BranchID->EditCustomAttributes = "";
			$curVal = trim(strval($this->BranchID->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->BranchID->AdvancedSearch->ViewValue = $this->BranchID->lookupCacheOption($curVal);
			else
				$this->BranchID->AdvancedSearch->ViewValue = $this->BranchID->Lookup !== NULL && is_array($this->BranchID->Lookup->Options) ? $curVal : NULL;
			if ($this->BranchID->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->BranchID->EditValue = array_values($this->BranchID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`BranchID`" . SearchString("=", $this->BranchID->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->BranchID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->BranchID->EditValue = $arwrk;
			}

			// LawFirmID
			$this->LawFirmID->EditAttrs["class"] = "form-control";
			$this->LawFirmID->EditCustomAttributes = "";
			$curVal = trim(strval($this->LawFirmID->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->LawFirmID->AdvancedSearch->ViewValue = $this->LawFirmID->lookupCacheOption($curVal);
			else
				$this->LawFirmID->AdvancedSearch->ViewValue = $this->LawFirmID->Lookup !== NULL && is_array($this->LawFirmID->Lookup->Options) ? $curVal : NULL;
			if ($this->LawFirmID->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->LawFirmID->EditValue = array_values($this->LawFirmID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`LawFirmID`" . SearchString("=", $this->LawFirmID->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->LawFirmID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->LawFirmID->EditValue = $arwrk;
			}

			// Notes
			$this->Notes->EditAttrs["class"] = "form-control";
			$this->Notes->EditCustomAttributes = "";
			$this->Notes->EditValue = HtmlEncode($this->Notes->AdvancedSearch->SearchValue);
			$this->Notes->PlaceHolder = RemoveHtml($this->Notes->caption());

			// HireDate
			$this->HireDate->EditAttrs["class"] = "form-control";
			$this->HireDate->EditCustomAttributes = "";
			$this->HireDate->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->HireDate->AdvancedSearch->SearchValue, 0), 8));
			$this->HireDate->PlaceHolder = RemoveHtml($this->HireDate->caption());

			// EndOfServiceDate
			$this->EndOfServiceDate->EditAttrs["class"] = "form-control";
			$this->EndOfServiceDate->EditCustomAttributes = "";
			$this->EndOfServiceDate->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->EndOfServiceDate->AdvancedSearch->SearchValue, 0), 8));
			$this->EndOfServiceDate->PlaceHolder = RemoveHtml($this->EndOfServiceDate->caption());

			// SocialSecurity#
			$this->SocialSecurity23->EditAttrs["class"] = "form-control";
			$this->SocialSecurity23->EditCustomAttributes = "";
			$this->SocialSecurity23->EditValue = HtmlEncode($this->SocialSecurity23->AdvancedSearch->SearchValue);
			$this->SocialSecurity23->PlaceHolder = RemoveHtml($this->SocialSecurity23->caption());

			// Financial#
			$this->Financial23->EditAttrs["class"] = "form-control";
			$this->Financial23->EditCustomAttributes = "";
			$this->Financial23->EditValue = HtmlEncode($this->Financial23->AdvancedSearch->SearchValue);
			$this->Financial23->PlaceHolder = RemoveHtml($this->Financial23->caption());

			// Extra#
			$this->Extra23->EditAttrs["class"] = "form-control";
			$this->Extra23->EditCustomAttributes = "";
			$this->Extra23->EditValue = HtmlEncode($this->Extra23->AdvancedSearch->SearchValue);
			$this->Extra23->PlaceHolder = RemoveHtml($this->Extra23->caption());

			// WorkNature
			$this->WorkNature->EditAttrs["class"] = "form-control";
			$this->WorkNature->EditCustomAttributes = "";
			$this->WorkNature->EditValue = HtmlEncode($this->WorkNature->AdvancedSearch->SearchValue);
			$this->WorkNature->PlaceHolder = RemoveHtml($this->WorkNature->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckDate($this->HireDate->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->HireDate->errorMessage());
		}
		if (!CheckDate($this->EndOfServiceDate->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->EndOfServiceDate->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->EmployeeHrID->AdvancedSearch->load();
		$this->EmployeeID->AdvancedSearch->load();
		$this->JobTitle->AdvancedSearch->load();
		$this->Department->AdvancedSearch->load();
		$this->BranchID->AdvancedSearch->load();
		$this->LawFirmID->AdvancedSearch->load();
		$this->Notes->AdvancedSearch->load();
		$this->HireDate->AdvancedSearch->load();
		$this->EndOfServiceDate->AdvancedSearch->load();
		$this->SocialSecurity23->AdvancedSearch->load();
		$this->Financial23->AdvancedSearch->load();
		$this->Extra23->AdvancedSearch->load();
		$this->WorkNature->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("employeehrlist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_EmployeeID":
							break;
						case "x_BranchID":
							break;
						case "x_LawFirmID":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
