<?php
namespace PHPMaker2019\project_germanos;

/**
 * Page class
 */
class employeeperson_add extends employeeperson
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{8D47CED4-FEF0-4756-8F48-9FC38A15AA2A}";

	// Table name
	public $TableName = 'employeeperson';

	// Page object name
	public $PageObjName = "employeeperson_add";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (employeeperson)
		if (!isset($GLOBALS["employeeperson"]) || get_class($GLOBALS["employeeperson"]) == PROJECT_NAMESPACE . "employeeperson") {
			$GLOBALS["employeeperson"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["employeeperson"];
		}

		// Table object (employees)
		if (!isset($GLOBALS['employees']))
			$GLOBALS['employees'] = new employees();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'employeeperson');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (employees)
		if (!isset($UserTable)) {
			$UserTable = new employees();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $employeeperson;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($employeeperson);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "employeepersonview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['EmployeePersonID'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->EmployeePersonID->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (IsPasswordExpired())
				$this->terminate(GetUrl("changepwd.php"));
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("employeepersonlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Update last accessed time
		if ($UserProfile->isValidUser(CurrentUserName(), session_id())) {
		} else {
			Write($Language->phrase("UserProfileCorrupted"));
			$this->terminate();
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->EmployeePersonID->Visible = FALSE;
		$this->EmployeeID->setVisibility();
		$this->MaritalStatusID->setVisibility();
		$this->CivilStatus23->setVisibility();
		$this->CivilStatusPlace->setVisibility();
		$this->IdCard23->setVisibility();
		$this->PracticingProfessionLicense23->setVisibility();
		$this->NationalId23->setVisibility();
		$this->Nationality1->setVisibility();
		$this->Nationality2->setVisibility();
		$this->Nationality3->setVisibility();
		$this->DriverLicense23->setVisibility();
		$this->Extra23->setVisibility();
		$this->Notes->setVisibility();
		$this->_UserID->Visible = FALSE;
		$this->CreatedBy->Visible = FALSE;
		$this->CreatedDate->Visible = FALSE;
		$this->UpdatedBy->Visible = FALSE;
		$this->UpdatedDate->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->EmployeeID);
		$this->setupLookupOptions($this->MaritalStatusID);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("EmployeePersonID") !== NULL) {
				$this->EmployeePersonID->setQueryStringValue(Get("EmployeePersonID"));
				$this->setKey("EmployeePersonID", $this->EmployeePersonID->CurrentValue); // Set up key
			} else {
				$this->setKey("EmployeePersonID", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Set up master/detail parameters
		// NOTE: must be after loadOldRecord to prevent master key values overwritten

		$this->setupMasterParms();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("employeepersonlist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "employeepersonlist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "employeepersonview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->EmployeePersonID->CurrentValue = NULL;
		$this->EmployeePersonID->OldValue = $this->EmployeePersonID->CurrentValue;
		$this->EmployeeID->CurrentValue = NULL;
		$this->EmployeeID->OldValue = $this->EmployeeID->CurrentValue;
		$this->MaritalStatusID->CurrentValue = NULL;
		$this->MaritalStatusID->OldValue = $this->MaritalStatusID->CurrentValue;
		$this->CivilStatus23->CurrentValue = NULL;
		$this->CivilStatus23->OldValue = $this->CivilStatus23->CurrentValue;
		$this->CivilStatusPlace->CurrentValue = NULL;
		$this->CivilStatusPlace->OldValue = $this->CivilStatusPlace->CurrentValue;
		$this->IdCard23->CurrentValue = NULL;
		$this->IdCard23->OldValue = $this->IdCard23->CurrentValue;
		$this->PracticingProfessionLicense23->CurrentValue = NULL;
		$this->PracticingProfessionLicense23->OldValue = $this->PracticingProfessionLicense23->CurrentValue;
		$this->NationalId23->CurrentValue = NULL;
		$this->NationalId23->OldValue = $this->NationalId23->CurrentValue;
		$this->Nationality1->CurrentValue = NULL;
		$this->Nationality1->OldValue = $this->Nationality1->CurrentValue;
		$this->Nationality2->CurrentValue = NULL;
		$this->Nationality2->OldValue = $this->Nationality2->CurrentValue;
		$this->Nationality3->CurrentValue = NULL;
		$this->Nationality3->OldValue = $this->Nationality3->CurrentValue;
		$this->DriverLicense23->CurrentValue = NULL;
		$this->DriverLicense23->OldValue = $this->DriverLicense23->CurrentValue;
		$this->Extra23->CurrentValue = NULL;
		$this->Extra23->OldValue = $this->Extra23->CurrentValue;
		$this->Notes->CurrentValue = NULL;
		$this->Notes->OldValue = $this->Notes->CurrentValue;
		$this->_UserID->CurrentValue = NULL;
		$this->_UserID->OldValue = $this->_UserID->CurrentValue;
		$this->CreatedBy->CurrentValue = NULL;
		$this->CreatedBy->OldValue = $this->CreatedBy->CurrentValue;
		$this->CreatedDate->CurrentValue = NULL;
		$this->CreatedDate->OldValue = $this->CreatedDate->CurrentValue;
		$this->UpdatedBy->CurrentValue = NULL;
		$this->UpdatedBy->OldValue = $this->UpdatedBy->CurrentValue;
		$this->UpdatedDate->CurrentValue = NULL;
		$this->UpdatedDate->OldValue = $this->UpdatedDate->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'EmployeeID' first before field var 'x_EmployeeID'
		$val = $CurrentForm->hasValue("EmployeeID") ? $CurrentForm->getValue("EmployeeID") : $CurrentForm->getValue("x_EmployeeID");
		if (!$this->EmployeeID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->EmployeeID->Visible = FALSE; // Disable update for API request
			else
				$this->EmployeeID->setFormValue($val);
		}

		// Check field name 'MaritalStatusID' first before field var 'x_MaritalStatusID'
		$val = $CurrentForm->hasValue("MaritalStatusID") ? $CurrentForm->getValue("MaritalStatusID") : $CurrentForm->getValue("x_MaritalStatusID");
		if (!$this->MaritalStatusID->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->MaritalStatusID->Visible = FALSE; // Disable update for API request
			else
				$this->MaritalStatusID->setFormValue($val);
		}

		// Check field name 'CivilStatus#' first before field var 'x_CivilStatus23'
		$val = $CurrentForm->hasValue("CivilStatus#") ? $CurrentForm->getValue("CivilStatus#") : $CurrentForm->getValue("x_CivilStatus23");
		if (!$this->CivilStatus23->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CivilStatus23->Visible = FALSE; // Disable update for API request
			else
				$this->CivilStatus23->setFormValue($val);
		}

		// Check field name 'CivilStatusPlace' first before field var 'x_CivilStatusPlace'
		$val = $CurrentForm->hasValue("CivilStatusPlace") ? $CurrentForm->getValue("CivilStatusPlace") : $CurrentForm->getValue("x_CivilStatusPlace");
		if (!$this->CivilStatusPlace->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->CivilStatusPlace->Visible = FALSE; // Disable update for API request
			else
				$this->CivilStatusPlace->setFormValue($val);
		}

		// Check field name 'IdCard#' first before field var 'x_IdCard23'
		$val = $CurrentForm->hasValue("IdCard#") ? $CurrentForm->getValue("IdCard#") : $CurrentForm->getValue("x_IdCard23");
		if (!$this->IdCard23->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->IdCard23->Visible = FALSE; // Disable update for API request
			else
				$this->IdCard23->setFormValue($val);
		}

		// Check field name 'PracticingProfessionLicense#' first before field var 'x_PracticingProfessionLicense23'
		$val = $CurrentForm->hasValue("PracticingProfessionLicense#") ? $CurrentForm->getValue("PracticingProfessionLicense#") : $CurrentForm->getValue("x_PracticingProfessionLicense23");
		if (!$this->PracticingProfessionLicense23->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->PracticingProfessionLicense23->Visible = FALSE; // Disable update for API request
			else
				$this->PracticingProfessionLicense23->setFormValue($val);
		}

		// Check field name 'NationalId#' first before field var 'x_NationalId23'
		$val = $CurrentForm->hasValue("NationalId#") ? $CurrentForm->getValue("NationalId#") : $CurrentForm->getValue("x_NationalId23");
		if (!$this->NationalId23->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->NationalId23->Visible = FALSE; // Disable update for API request
			else
				$this->NationalId23->setFormValue($val);
		}

		// Check field name 'Nationality1' first before field var 'x_Nationality1'
		$val = $CurrentForm->hasValue("Nationality1") ? $CurrentForm->getValue("Nationality1") : $CurrentForm->getValue("x_Nationality1");
		if (!$this->Nationality1->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Nationality1->Visible = FALSE; // Disable update for API request
			else
				$this->Nationality1->setFormValue($val);
		}

		// Check field name 'Nationality2' first before field var 'x_Nationality2'
		$val = $CurrentForm->hasValue("Nationality2") ? $CurrentForm->getValue("Nationality2") : $CurrentForm->getValue("x_Nationality2");
		if (!$this->Nationality2->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Nationality2->Visible = FALSE; // Disable update for API request
			else
				$this->Nationality2->setFormValue($val);
		}

		// Check field name 'Nationality3' first before field var 'x_Nationality3'
		$val = $CurrentForm->hasValue("Nationality3") ? $CurrentForm->getValue("Nationality3") : $CurrentForm->getValue("x_Nationality3");
		if (!$this->Nationality3->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Nationality3->Visible = FALSE; // Disable update for API request
			else
				$this->Nationality3->setFormValue($val);
		}

		// Check field name 'DriverLicense#' first before field var 'x_DriverLicense23'
		$val = $CurrentForm->hasValue("DriverLicense#") ? $CurrentForm->getValue("DriverLicense#") : $CurrentForm->getValue("x_DriverLicense23");
		if (!$this->DriverLicense23->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->DriverLicense23->Visible = FALSE; // Disable update for API request
			else
				$this->DriverLicense23->setFormValue($val);
		}

		// Check field name 'Extra#' first before field var 'x_Extra23'
		$val = $CurrentForm->hasValue("Extra#") ? $CurrentForm->getValue("Extra#") : $CurrentForm->getValue("x_Extra23");
		if (!$this->Extra23->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Extra23->Visible = FALSE; // Disable update for API request
			else
				$this->Extra23->setFormValue($val);
		}

		// Check field name 'Notes' first before field var 'x_Notes'
		$val = $CurrentForm->hasValue("Notes") ? $CurrentForm->getValue("Notes") : $CurrentForm->getValue("x_Notes");
		if (!$this->Notes->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Notes->Visible = FALSE; // Disable update for API request
			else
				$this->Notes->setFormValue($val);
		}

		// Check field name 'EmployeePersonID' first before field var 'x_EmployeePersonID'
		$val = $CurrentForm->hasValue("EmployeePersonID") ? $CurrentForm->getValue("EmployeePersonID") : $CurrentForm->getValue("x_EmployeePersonID");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->EmployeeID->CurrentValue = $this->EmployeeID->FormValue;
		$this->MaritalStatusID->CurrentValue = $this->MaritalStatusID->FormValue;
		$this->CivilStatus23->CurrentValue = $this->CivilStatus23->FormValue;
		$this->CivilStatusPlace->CurrentValue = $this->CivilStatusPlace->FormValue;
		$this->IdCard23->CurrentValue = $this->IdCard23->FormValue;
		$this->PracticingProfessionLicense23->CurrentValue = $this->PracticingProfessionLicense23->FormValue;
		$this->NationalId23->CurrentValue = $this->NationalId23->FormValue;
		$this->Nationality1->CurrentValue = $this->Nationality1->FormValue;
		$this->Nationality2->CurrentValue = $this->Nationality2->FormValue;
		$this->Nationality3->CurrentValue = $this->Nationality3->FormValue;
		$this->DriverLicense23->CurrentValue = $this->DriverLicense23->FormValue;
		$this->Extra23->CurrentValue = $this->Extra23->FormValue;
		$this->Notes->CurrentValue = $this->Notes->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->EmployeePersonID->setDbValue($row['EmployeePersonID']);
		$this->EmployeeID->setDbValue($row['EmployeeID']);
		$this->MaritalStatusID->setDbValue($row['MaritalStatusID']);
		$this->CivilStatus23->setDbValue($row['CivilStatus#']);
		$this->CivilStatusPlace->setDbValue($row['CivilStatusPlace']);
		$this->IdCard23->setDbValue($row['IdCard#']);
		$this->PracticingProfessionLicense23->setDbValue($row['PracticingProfessionLicense#']);
		$this->NationalId23->setDbValue($row['NationalId#']);
		$this->Nationality1->setDbValue($row['Nationality1']);
		$this->Nationality2->setDbValue($row['Nationality2']);
		$this->Nationality3->setDbValue($row['Nationality3']);
		$this->DriverLicense23->setDbValue($row['DriverLicense#']);
		$this->Extra23->setDbValue($row['Extra#']);
		$this->Notes->setDbValue($row['Notes']);
		$this->_UserID->setDbValue($row['UserID']);
		$this->CreatedBy->setDbValue($row['CreatedBy']);
		$this->CreatedDate->setDbValue($row['CreatedDate']);
		$this->UpdatedBy->setDbValue($row['UpdatedBy']);
		$this->UpdatedDate->setDbValue($row['UpdatedDate']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['EmployeePersonID'] = $this->EmployeePersonID->CurrentValue;
		$row['EmployeeID'] = $this->EmployeeID->CurrentValue;
		$row['MaritalStatusID'] = $this->MaritalStatusID->CurrentValue;
		$row['CivilStatus#'] = $this->CivilStatus23->CurrentValue;
		$row['CivilStatusPlace'] = $this->CivilStatusPlace->CurrentValue;
		$row['IdCard#'] = $this->IdCard23->CurrentValue;
		$row['PracticingProfessionLicense#'] = $this->PracticingProfessionLicense23->CurrentValue;
		$row['NationalId#'] = $this->NationalId23->CurrentValue;
		$row['Nationality1'] = $this->Nationality1->CurrentValue;
		$row['Nationality2'] = $this->Nationality2->CurrentValue;
		$row['Nationality3'] = $this->Nationality3->CurrentValue;
		$row['DriverLicense#'] = $this->DriverLicense23->CurrentValue;
		$row['Extra#'] = $this->Extra23->CurrentValue;
		$row['Notes'] = $this->Notes->CurrentValue;
		$row['UserID'] = $this->_UserID->CurrentValue;
		$row['CreatedBy'] = $this->CreatedBy->CurrentValue;
		$row['CreatedDate'] = $this->CreatedDate->CurrentValue;
		$row['UpdatedBy'] = $this->UpdatedBy->CurrentValue;
		$row['UpdatedDate'] = $this->UpdatedDate->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("EmployeePersonID")) <> "")
			$this->EmployeePersonID->CurrentValue = $this->getKey("EmployeePersonID"); // EmployeePersonID
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// EmployeePersonID
		// EmployeeID
		// MaritalStatusID
		// CivilStatus#
		// CivilStatusPlace
		// IdCard#
		// PracticingProfessionLicense#
		// NationalId#
		// Nationality1
		// Nationality2
		// Nationality3
		// DriverLicense#
		// Extra#
		// Notes
		// UserID
		// CreatedBy
		// CreatedDate
		// UpdatedBy
		// UpdatedDate

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// EmployeePersonID
			$this->EmployeePersonID->ViewValue = $this->EmployeePersonID->CurrentValue;
			$this->EmployeePersonID->ViewCustomAttributes = "";

			// EmployeeID
			$curVal = strval($this->EmployeeID->CurrentValue);
			if ($curVal <> "") {
				$this->EmployeeID->ViewValue = $this->EmployeeID->lookupCacheOption($curVal);
				if ($this->EmployeeID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`EmployeeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->EmployeeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->EmployeeID->ViewValue = $this->EmployeeID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->EmployeeID->ViewValue = $this->EmployeeID->CurrentValue;
					}
				}
			} else {
				$this->EmployeeID->ViewValue = NULL;
			}
			$this->EmployeeID->ViewCustomAttributes = "";

			// MaritalStatusID
			$curVal = strval($this->MaritalStatusID->CurrentValue);
			if ($curVal <> "") {
				$this->MaritalStatusID->ViewValue = $this->MaritalStatusID->lookupCacheOption($curVal);
				if ($this->MaritalStatusID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`MaritalStatusID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->MaritalStatusID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->MaritalStatusID->ViewValue = $this->MaritalStatusID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->MaritalStatusID->ViewValue = $this->MaritalStatusID->CurrentValue;
					}
				}
			} else {
				$this->MaritalStatusID->ViewValue = NULL;
			}
			$this->MaritalStatusID->ViewCustomAttributes = "";

			// CivilStatus#
			$this->CivilStatus23->ViewValue = $this->CivilStatus23->CurrentValue;
			$this->CivilStatus23->ViewCustomAttributes = "";

			// CivilStatusPlace
			$this->CivilStatusPlace->ViewValue = $this->CivilStatusPlace->CurrentValue;
			$this->CivilStatusPlace->ViewCustomAttributes = "";

			// IdCard#
			$this->IdCard23->ViewValue = $this->IdCard23->CurrentValue;
			$this->IdCard23->ViewCustomAttributes = "";

			// PracticingProfessionLicense#
			$this->PracticingProfessionLicense23->ViewValue = $this->PracticingProfessionLicense23->CurrentValue;
			$this->PracticingProfessionLicense23->ViewCustomAttributes = "";

			// NationalId#
			$this->NationalId23->ViewValue = $this->NationalId23->CurrentValue;
			$this->NationalId23->ViewCustomAttributes = "";

			// Nationality1
			$this->Nationality1->ViewValue = $this->Nationality1->CurrentValue;
			$this->Nationality1->ViewCustomAttributes = "";

			// Nationality2
			$this->Nationality2->ViewValue = $this->Nationality2->CurrentValue;
			$this->Nationality2->ViewCustomAttributes = "";

			// Nationality3
			$this->Nationality3->ViewValue = $this->Nationality3->CurrentValue;
			$this->Nationality3->ViewCustomAttributes = "";

			// DriverLicense#
			$this->DriverLicense23->ViewValue = $this->DriverLicense23->CurrentValue;
			$this->DriverLicense23->ViewCustomAttributes = "";

			// Extra#
			$this->Extra23->ViewValue = $this->Extra23->CurrentValue;
			$this->Extra23->ViewCustomAttributes = "";

			// Notes
			$this->Notes->ViewValue = $this->Notes->CurrentValue;
			$this->Notes->ViewCustomAttributes = "";

			// EmployeeID
			$this->EmployeeID->LinkCustomAttributes = "";
			$this->EmployeeID->HrefValue = "";
			$this->EmployeeID->TooltipValue = "";

			// MaritalStatusID
			$this->MaritalStatusID->LinkCustomAttributes = "";
			$this->MaritalStatusID->HrefValue = "";
			$this->MaritalStatusID->TooltipValue = "";

			// CivilStatus#
			$this->CivilStatus23->LinkCustomAttributes = "";
			$this->CivilStatus23->HrefValue = "";
			$this->CivilStatus23->TooltipValue = "";

			// CivilStatusPlace
			$this->CivilStatusPlace->LinkCustomAttributes = "";
			$this->CivilStatusPlace->HrefValue = "";
			$this->CivilStatusPlace->TooltipValue = "";

			// IdCard#
			$this->IdCard23->LinkCustomAttributes = "";
			$this->IdCard23->HrefValue = "";
			$this->IdCard23->TooltipValue = "";

			// PracticingProfessionLicense#
			$this->PracticingProfessionLicense23->LinkCustomAttributes = "";
			$this->PracticingProfessionLicense23->HrefValue = "";
			$this->PracticingProfessionLicense23->TooltipValue = "";

			// NationalId#
			$this->NationalId23->LinkCustomAttributes = "";
			$this->NationalId23->HrefValue = "";
			$this->NationalId23->TooltipValue = "";

			// Nationality1
			$this->Nationality1->LinkCustomAttributes = "";
			$this->Nationality1->HrefValue = "";
			$this->Nationality1->TooltipValue = "";

			// Nationality2
			$this->Nationality2->LinkCustomAttributes = "";
			$this->Nationality2->HrefValue = "";
			$this->Nationality2->TooltipValue = "";

			// Nationality3
			$this->Nationality3->LinkCustomAttributes = "";
			$this->Nationality3->HrefValue = "";
			$this->Nationality3->TooltipValue = "";

			// DriverLicense#
			$this->DriverLicense23->LinkCustomAttributes = "";
			$this->DriverLicense23->HrefValue = "";
			$this->DriverLicense23->TooltipValue = "";

			// Extra#
			$this->Extra23->LinkCustomAttributes = "";
			$this->Extra23->HrefValue = "";
			$this->Extra23->TooltipValue = "";

			// Notes
			$this->Notes->LinkCustomAttributes = "";
			$this->Notes->HrefValue = "";
			$this->Notes->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// EmployeeID
			$this->EmployeeID->EditAttrs["class"] = "form-control";
			$this->EmployeeID->EditCustomAttributes = "";
			if ($this->EmployeeID->getSessionValue() <> "") {
				$this->EmployeeID->CurrentValue = $this->EmployeeID->getSessionValue();
			$curVal = strval($this->EmployeeID->CurrentValue);
			if ($curVal <> "") {
				$this->EmployeeID->ViewValue = $this->EmployeeID->lookupCacheOption($curVal);
				if ($this->EmployeeID->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`EmployeeID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->EmployeeID->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->EmployeeID->ViewValue = $this->EmployeeID->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->EmployeeID->ViewValue = $this->EmployeeID->CurrentValue;
					}
				}
			} else {
				$this->EmployeeID->ViewValue = NULL;
			}
			$this->EmployeeID->ViewCustomAttributes = "";
			} else {
			$curVal = trim(strval($this->EmployeeID->CurrentValue));
			if ($curVal <> "")
				$this->EmployeeID->ViewValue = $this->EmployeeID->lookupCacheOption($curVal);
			else
				$this->EmployeeID->ViewValue = $this->EmployeeID->Lookup !== NULL && is_array($this->EmployeeID->Lookup->Options) ? $curVal : NULL;
			if ($this->EmployeeID->ViewValue !== NULL) { // Load from cache
				$this->EmployeeID->EditValue = array_values($this->EmployeeID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`EmployeeID`" . SearchString("=", $this->EmployeeID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->EmployeeID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->EmployeeID->EditValue = $arwrk;
			}
			}

			// MaritalStatusID
			$this->MaritalStatusID->EditAttrs["class"] = "form-control";
			$this->MaritalStatusID->EditCustomAttributes = "";
			$curVal = trim(strval($this->MaritalStatusID->CurrentValue));
			if ($curVal <> "")
				$this->MaritalStatusID->ViewValue = $this->MaritalStatusID->lookupCacheOption($curVal);
			else
				$this->MaritalStatusID->ViewValue = $this->MaritalStatusID->Lookup !== NULL && is_array($this->MaritalStatusID->Lookup->Options) ? $curVal : NULL;
			if ($this->MaritalStatusID->ViewValue !== NULL) { // Load from cache
				$this->MaritalStatusID->EditValue = array_values($this->MaritalStatusID->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`MaritalStatusID`" . SearchString("=", $this->MaritalStatusID->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->MaritalStatusID->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->MaritalStatusID->EditValue = $arwrk;
			}

			// CivilStatus#
			$this->CivilStatus23->EditAttrs["class"] = "form-control";
			$this->CivilStatus23->EditCustomAttributes = "";
			$this->CivilStatus23->EditValue = HtmlEncode($this->CivilStatus23->CurrentValue);
			$this->CivilStatus23->PlaceHolder = RemoveHtml($this->CivilStatus23->caption());

			// CivilStatusPlace
			$this->CivilStatusPlace->EditAttrs["class"] = "form-control";
			$this->CivilStatusPlace->EditCustomAttributes = "";
			$this->CivilStatusPlace->EditValue = HtmlEncode($this->CivilStatusPlace->CurrentValue);
			$this->CivilStatusPlace->PlaceHolder = RemoveHtml($this->CivilStatusPlace->caption());

			// IdCard#
			$this->IdCard23->EditAttrs["class"] = "form-control";
			$this->IdCard23->EditCustomAttributes = "";
			$this->IdCard23->EditValue = HtmlEncode($this->IdCard23->CurrentValue);
			$this->IdCard23->PlaceHolder = RemoveHtml($this->IdCard23->caption());

			// PracticingProfessionLicense#
			$this->PracticingProfessionLicense23->EditAttrs["class"] = "form-control";
			$this->PracticingProfessionLicense23->EditCustomAttributes = "";
			$this->PracticingProfessionLicense23->EditValue = HtmlEncode($this->PracticingProfessionLicense23->CurrentValue);
			$this->PracticingProfessionLicense23->PlaceHolder = RemoveHtml($this->PracticingProfessionLicense23->caption());

			// NationalId#
			$this->NationalId23->EditAttrs["class"] = "form-control";
			$this->NationalId23->EditCustomAttributes = "";
			$this->NationalId23->EditValue = HtmlEncode($this->NationalId23->CurrentValue);
			$this->NationalId23->PlaceHolder = RemoveHtml($this->NationalId23->caption());

			// Nationality1
			$this->Nationality1->EditAttrs["class"] = "form-control";
			$this->Nationality1->EditCustomAttributes = "";
			$this->Nationality1->EditValue = HtmlEncode($this->Nationality1->CurrentValue);
			$this->Nationality1->PlaceHolder = RemoveHtml($this->Nationality1->caption());

			// Nationality2
			$this->Nationality2->EditAttrs["class"] = "form-control";
			$this->Nationality2->EditCustomAttributes = "";
			$this->Nationality2->EditValue = HtmlEncode($this->Nationality2->CurrentValue);
			$this->Nationality2->PlaceHolder = RemoveHtml($this->Nationality2->caption());

			// Nationality3
			$this->Nationality3->EditAttrs["class"] = "form-control";
			$this->Nationality3->EditCustomAttributes = "";
			$this->Nationality3->EditValue = HtmlEncode($this->Nationality3->CurrentValue);
			$this->Nationality3->PlaceHolder = RemoveHtml($this->Nationality3->caption());

			// DriverLicense#
			$this->DriverLicense23->EditAttrs["class"] = "form-control";
			$this->DriverLicense23->EditCustomAttributes = "";
			$this->DriverLicense23->EditValue = HtmlEncode($this->DriverLicense23->CurrentValue);
			$this->DriverLicense23->PlaceHolder = RemoveHtml($this->DriverLicense23->caption());

			// Extra#
			$this->Extra23->EditAttrs["class"] = "form-control";
			$this->Extra23->EditCustomAttributes = "";
			$this->Extra23->EditValue = HtmlEncode($this->Extra23->CurrentValue);
			$this->Extra23->PlaceHolder = RemoveHtml($this->Extra23->caption());

			// Notes
			$this->Notes->EditAttrs["class"] = "form-control";
			$this->Notes->EditCustomAttributes = "";
			$this->Notes->EditValue = HtmlEncode($this->Notes->CurrentValue);
			$this->Notes->PlaceHolder = RemoveHtml($this->Notes->caption());

			// Add refer script
			// EmployeeID

			$this->EmployeeID->LinkCustomAttributes = "";
			$this->EmployeeID->HrefValue = "";

			// MaritalStatusID
			$this->MaritalStatusID->LinkCustomAttributes = "";
			$this->MaritalStatusID->HrefValue = "";

			// CivilStatus#
			$this->CivilStatus23->LinkCustomAttributes = "";
			$this->CivilStatus23->HrefValue = "";

			// CivilStatusPlace
			$this->CivilStatusPlace->LinkCustomAttributes = "";
			$this->CivilStatusPlace->HrefValue = "";

			// IdCard#
			$this->IdCard23->LinkCustomAttributes = "";
			$this->IdCard23->HrefValue = "";

			// PracticingProfessionLicense#
			$this->PracticingProfessionLicense23->LinkCustomAttributes = "";
			$this->PracticingProfessionLicense23->HrefValue = "";

			// NationalId#
			$this->NationalId23->LinkCustomAttributes = "";
			$this->NationalId23->HrefValue = "";

			// Nationality1
			$this->Nationality1->LinkCustomAttributes = "";
			$this->Nationality1->HrefValue = "";

			// Nationality2
			$this->Nationality2->LinkCustomAttributes = "";
			$this->Nationality2->HrefValue = "";

			// Nationality3
			$this->Nationality3->LinkCustomAttributes = "";
			$this->Nationality3->HrefValue = "";

			// DriverLicense#
			$this->DriverLicense23->LinkCustomAttributes = "";
			$this->DriverLicense23->HrefValue = "";

			// Extra#
			$this->Extra23->LinkCustomAttributes = "";
			$this->Extra23->HrefValue = "";

			// Notes
			$this->Notes->LinkCustomAttributes = "";
			$this->Notes->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->EmployeePersonID->Required) {
			if (!$this->EmployeePersonID->IsDetailKey && $this->EmployeePersonID->FormValue != NULL && $this->EmployeePersonID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->EmployeePersonID->caption(), $this->EmployeePersonID->RequiredErrorMessage));
			}
		}
		if ($this->EmployeeID->Required) {
			if (!$this->EmployeeID->IsDetailKey && $this->EmployeeID->FormValue != NULL && $this->EmployeeID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->EmployeeID->caption(), $this->EmployeeID->RequiredErrorMessage));
			}
		}
		if ($this->MaritalStatusID->Required) {
			if (!$this->MaritalStatusID->IsDetailKey && $this->MaritalStatusID->FormValue != NULL && $this->MaritalStatusID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->MaritalStatusID->caption(), $this->MaritalStatusID->RequiredErrorMessage));
			}
		}
		if ($this->CivilStatus23->Required) {
			if (!$this->CivilStatus23->IsDetailKey && $this->CivilStatus23->FormValue != NULL && $this->CivilStatus23->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CivilStatus23->caption(), $this->CivilStatus23->RequiredErrorMessage));
			}
		}
		if ($this->CivilStatusPlace->Required) {
			if (!$this->CivilStatusPlace->IsDetailKey && $this->CivilStatusPlace->FormValue != NULL && $this->CivilStatusPlace->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CivilStatusPlace->caption(), $this->CivilStatusPlace->RequiredErrorMessage));
			}
		}
		if ($this->IdCard23->Required) {
			if (!$this->IdCard23->IsDetailKey && $this->IdCard23->FormValue != NULL && $this->IdCard23->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->IdCard23->caption(), $this->IdCard23->RequiredErrorMessage));
			}
		}
		if ($this->PracticingProfessionLicense23->Required) {
			if (!$this->PracticingProfessionLicense23->IsDetailKey && $this->PracticingProfessionLicense23->FormValue != NULL && $this->PracticingProfessionLicense23->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PracticingProfessionLicense23->caption(), $this->PracticingProfessionLicense23->RequiredErrorMessage));
			}
		}
		if ($this->NationalId23->Required) {
			if (!$this->NationalId23->IsDetailKey && $this->NationalId23->FormValue != NULL && $this->NationalId23->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NationalId23->caption(), $this->NationalId23->RequiredErrorMessage));
			}
		}
		if ($this->Nationality1->Required) {
			if (!$this->Nationality1->IsDetailKey && $this->Nationality1->FormValue != NULL && $this->Nationality1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Nationality1->caption(), $this->Nationality1->RequiredErrorMessage));
			}
		}
		if ($this->Nationality2->Required) {
			if (!$this->Nationality2->IsDetailKey && $this->Nationality2->FormValue != NULL && $this->Nationality2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Nationality2->caption(), $this->Nationality2->RequiredErrorMessage));
			}
		}
		if ($this->Nationality3->Required) {
			if (!$this->Nationality3->IsDetailKey && $this->Nationality3->FormValue != NULL && $this->Nationality3->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Nationality3->caption(), $this->Nationality3->RequiredErrorMessage));
			}
		}
		if ($this->DriverLicense23->Required) {
			if (!$this->DriverLicense23->IsDetailKey && $this->DriverLicense23->FormValue != NULL && $this->DriverLicense23->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->DriverLicense23->caption(), $this->DriverLicense23->RequiredErrorMessage));
			}
		}
		if ($this->Extra23->Required) {
			if (!$this->Extra23->IsDetailKey && $this->Extra23->FormValue != NULL && $this->Extra23->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Extra23->caption(), $this->Extra23->RequiredErrorMessage));
			}
		}
		if ($this->Notes->Required) {
			if (!$this->Notes->IsDetailKey && $this->Notes->FormValue != NULL && $this->Notes->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Notes->caption(), $this->Notes->RequiredErrorMessage));
			}
		}
		if ($this->_UserID->Required) {
			if (!$this->_UserID->IsDetailKey && $this->_UserID->FormValue != NULL && $this->_UserID->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_UserID->caption(), $this->_UserID->RequiredErrorMessage));
			}
		}
		if ($this->CreatedBy->Required) {
			if (!$this->CreatedBy->IsDetailKey && $this->CreatedBy->FormValue != NULL && $this->CreatedBy->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CreatedBy->caption(), $this->CreatedBy->RequiredErrorMessage));
			}
		}
		if ($this->CreatedDate->Required) {
			if (!$this->CreatedDate->IsDetailKey && $this->CreatedDate->FormValue != NULL && $this->CreatedDate->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CreatedDate->caption(), $this->CreatedDate->RequiredErrorMessage));
			}
		}
		if ($this->UpdatedBy->Required) {
			if (!$this->UpdatedBy->IsDetailKey && $this->UpdatedBy->FormValue != NULL && $this->UpdatedBy->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->UpdatedBy->caption(), $this->UpdatedBy->RequiredErrorMessage));
			}
		}
		if ($this->UpdatedDate->Required) {
			if (!$this->UpdatedDate->IsDetailKey && $this->UpdatedDate->FormValue != NULL && $this->UpdatedDate->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->UpdatedDate->caption(), $this->UpdatedDate->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;

		// Check if valid key values for master user
		if ($Security->currentUserID() <> "" && !$Security->isAdmin()) { // Non system admin
			$masterFilter = $this->sqlMasterFilter_employees();
			if (strval($this->EmployeeID->CurrentValue) <> "") {
				$masterFilter = str_replace("@EmployeeID@", AdjustSql($this->EmployeeID->CurrentValue, "DB"), $masterFilter);
			} else {
				$masterFilter = "";
			}
			if ($masterFilter <> "") {
				$rsmaster = $GLOBALS["employees"]->loadRs($masterFilter);
				$this->MasterRecordExists = ($rsmaster && !$rsmaster->EOF);
				$validMasterKey = TRUE;
				if ($this->MasterRecordExists) {
					$validMasterKey = $Security->isValidUserID($rsmaster->fields['EmployeeID']);
				} elseif ($this->getCurrentMasterTable() == "employees") {
					$validMasterKey = FALSE;
				}
				if (!$validMasterKey) {
					$masterUserIdMsg = str_replace("%c", CurrentUserID(), $Language->phrase("UnAuthorizedMasterUserID"));
					$masterUserIdMsg = str_replace("%f", $sMasterFilter, $masterUserIdMsg);
					$this->setFailureMessage($masterUserIdMsg);
					return FALSE;
				}
				if ($rsmaster)
					$rsmaster->close();
			}
		}
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// EmployeeID
		$this->EmployeeID->setDbValueDef($rsnew, $this->EmployeeID->CurrentValue, 0, FALSE);

		// MaritalStatusID
		$this->MaritalStatusID->setDbValueDef($rsnew, $this->MaritalStatusID->CurrentValue, NULL, FALSE);

		// CivilStatus#
		$this->CivilStatus23->setDbValueDef($rsnew, $this->CivilStatus23->CurrentValue, NULL, FALSE);

		// CivilStatusPlace
		$this->CivilStatusPlace->setDbValueDef($rsnew, $this->CivilStatusPlace->CurrentValue, NULL, FALSE);

		// IdCard#
		$this->IdCard23->setDbValueDef($rsnew, $this->IdCard23->CurrentValue, NULL, FALSE);

		// PracticingProfessionLicense#
		$this->PracticingProfessionLicense23->setDbValueDef($rsnew, $this->PracticingProfessionLicense23->CurrentValue, NULL, FALSE);

		// NationalId#
		$this->NationalId23->setDbValueDef($rsnew, $this->NationalId23->CurrentValue, NULL, FALSE);

		// Nationality1
		$this->Nationality1->setDbValueDef($rsnew, $this->Nationality1->CurrentValue, NULL, FALSE);

		// Nationality2
		$this->Nationality2->setDbValueDef($rsnew, $this->Nationality2->CurrentValue, NULL, FALSE);

		// Nationality3
		$this->Nationality3->setDbValueDef($rsnew, $this->Nationality3->CurrentValue, NULL, FALSE);

		// DriverLicense#
		$this->DriverLicense23->setDbValueDef($rsnew, $this->DriverLicense23->CurrentValue, NULL, FALSE);

		// Extra#
		$this->Extra23->setDbValueDef($rsnew, $this->Extra23->CurrentValue, NULL, FALSE);

		// Notes
		$this->Notes->setDbValueDef($rsnew, $this->Notes->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up master/detail based on QueryString
	protected function setupMasterParms()
	{
		$validMaster = FALSE;

		// Get the keys for master table
		if (Get(TABLE_SHOW_MASTER) !== NULL) {
			$masterTblVar = Get(TABLE_SHOW_MASTER);
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "employees") {
				$validMaster = TRUE;
				if (Get("fk_EmployeeID") !== NULL) {
					$GLOBALS["employees"]->EmployeeID->setQueryStringValue(Get("fk_EmployeeID"));
					$this->EmployeeID->setQueryStringValue($GLOBALS["employees"]->EmployeeID->QueryStringValue);
					$this->EmployeeID->setSessionValue($this->EmployeeID->QueryStringValue);
					if (!is_numeric($GLOBALS["employees"]->EmployeeID->QueryStringValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
			}
		} elseif (Post(TABLE_SHOW_MASTER) !== NULL) {
			$masterTblVar = Post(TABLE_SHOW_MASTER);
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "employees") {
				$validMaster = TRUE;
				if (Post("fk_EmployeeID") !== NULL) {
					$GLOBALS["employees"]->EmployeeID->setFormValue(Post("fk_EmployeeID"));
					$this->EmployeeID->setFormValue($GLOBALS["employees"]->EmployeeID->FormValue);
					$this->EmployeeID->setSessionValue($this->EmployeeID->FormValue);
					if (!is_numeric($GLOBALS["employees"]->EmployeeID->FormValue))
						$validMaster = FALSE;
				} else {
					$validMaster = FALSE;
				}
			}
		}
		if ($validMaster) {

			// Save current master table
			$this->setCurrentMasterTable($masterTblVar);

			// Reset start record counter (new master key)
			if (!$this->isAddOrEdit()) {
				$this->StartRec = 1;
				$this->setStartRecordNumber($this->StartRec);
			}

			// Clear previous master key from Session
			if ($masterTblVar <> "employees") {
				if ($this->EmployeeID->CurrentValue == "")
					$this->EmployeeID->setSessionValue("");
			}
		}
		$this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("employeepersonlist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_EmployeeID":
							break;
						case "x_MaritalStatusID":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
